package mp4

import "github.com/wader/fq/pkg/scalar"

// based on https://github.com/HexFiend/HexFiend/blob/master/templates/Media/MOV.tcl

var boxDescriptions = scalar.StrToScalar{
	"ainf": {Description: "Asset information to identify, license and play"},
	"albm": {Description: "Album title and track number for media"},
	"alou": {Description: "Album loudness base"},
	"angl": {Description: "Name of the camera angle through which the clip was shot"},
	"assp": {Description: "Alternative startup sequence properties"},
	"auth": {Description: "Author of the media"},
	"avcn": {Description: "AVC NAL Unit Storage Box"},
	"bidx": {Description: "Box Index"},
	"bloc": {Description: "Base location and purchase location for license acquisition"},
	"bpcc": {Description: "Bits per component"},
	"btrt": {Description: "Bitrate"},
	"buff": {Description: "Buffering information"},
	"bxml": {Description: "Binary XML container"},
	"ccid": {Description: "OMA DRM Content ID"},
	"cdef": {Description: "Type and ordering of the components within the codestream"},
	"cinf": {Description: "Complete track information"},
	"clfn": {Description: "Name of the clip file"},
	"clid": {Description: "Identifier of the clip"},
	"clip": {Description: "Visual clipping region container"},
	"clsf": {Description: "Classification of the media"},
	"cmap": {Description: "Mapping between a palette and codestream components"},
	"cmid": {Description: "Identifier of the camera"},
	"cmnm": {Description: "Name that identifies the camera"},
	"co64": {Description: "64-bit chunk offset"},
	"coin": {Description: "Content Information Box"},
	"coll": {Description: "Name of the collection from which the media comes"},
	"colr": {Description: "Specifies the colourspace of the image"},
	"cprt": {Description: "Copyright etc"},
	"crgn": {Description: "Visual clipping region definition"},
	"crhd": {Description: "Reserved for ClockReferenceStream header"},
	"csgp": {Description: "Compact sample to group"},
	"cslg": {Description: "Composition to decode timeline mapping"},
	"ctab": {Description: "Track color-table"},
	"ctts": {Description: "Composition time to sample"},
	"cvru": {Description: "OMA DRM Cover URI"},
	"dac4": {Description: "Dolby AC-4 stream descriptor"},
	"date": {Description: "Date and time, formatted according to ISO 8601, when the content was created. For clips captured by recording devices, this is typically the date and time when the clip’s recording started"},
	"dcfD": {Description: "Marlin DCF Duration, user-data atom type"},
	"dec3": {Description: "E-AC-3 (Dolby Digital Plus) stream descriptor"},
	"dihd": {Description: "Data Integrity Hash"},
	"dinf": {Description: "Data information box, container"},
	"dint": {Description: "Data Integrity"},
	"dref": {Description: "Data reference box, declares source(s) of media data in track"},
	"dscp": {Description: "Media description"},
	"dsgd": {Description: "DVB Sample Group Description Box"},
	"dstg": {Description: "DVB Sample to Group Box"},
	"edts": {Description: "Edit list container"},
	"elng": {Description: "Extended Language Tag"},
	"elst": {Description: "An edit list"},
	"emsg": {Description: "Event message"},
	"esds": {Description: "Elementary stream descriptor"},
	"etyp": {Description: "Extended type and type combination"},
	"evti": {Description: "Event information"},
	"fdel": {Description: "File delivery information (item info extension)"},
	"feci": {Description: "FEC Informatiom"},
	"fecr": {Description: "FEC Reservoir"},
	"fidx": {Description: "Box File Index"},
	"fiel": {Description: "Video field order"},
	"fiin": {Description: "FD Item Information"},
	"fire": {Description: "File Reservoir"},
	"fpar": {Description: "File Partition"},
	"free": {Description: "Free space"},
	"frma": {Description: "Original format box"},
	"frpa": {Description: "Front Part"},
	"ftyp": {Description: "File type and compatibility"},
	"gitn": {Description: "Group ID to name"},
	"gnre": {Description: "Media genre"},
	"grpi": {Description: "OMA DRM Group ID"},
	"grpl": {Description: "Groups List box"},
	"hdlr": {Description: "Handler, declares the media (handler) type"},
	"hinf": {Description: "Hint information"},
	"hmhd": {Description: "Hint media header, overall information (hint track only)"},
	"hnti": {Description: "Hint information"},
	"hpix": {Description: "Hipix Rich Picture (user-data or meta-data)"},
	"icnu": {Description: "OMA DRM Icon URI"},
	"ID32": {Description: "ID3 version 2 container"},
	"idat": {Description: "Item data"},
	"ihdr": {Description: "Image Header"},
	"iinf": {Description: "Item information"},
	"iloc": {Description: "Item location"},
	"imap": {Description: "Track input map definition"},
	"imda": {Description: "Identified media data"},
	"imif": {Description: "IPMP Information box"},
	"infe": {Description: "Item information entry"},
	"infu": {Description: "OMA DRM Info URL"},
	"iods": {Description: "Object Descriptor container box"},
	"ipco": {Description: "ItemPropertyContainerBox"},
	"iphd": {Description: "Reserved for IPMP Stream header"},
	"ipma": {Description: "ItemPropertyAssociation"},
	"ipmc": {Description: "IPMP Control Box"},
	"ipro": {Description: "Item protection"},
	"iprp": {Description: "Item Properties Box"},
	"iref": {Description: "Item reference"},
	"j2kH": {Description: "JPEG 2000 header item property"},
	"jP  ": {Description: "JPEG 2000 Signature"},
	"jp2c": {Description: "JPEG 2000 contiguous codestream"},
	"jp2h": {Description: "Header"},
	"jp2i": {Description: "Intellectual property information"},
	"kind": {Description: "Track kind"},
	"kmat": {Description: "Compressed visual track matte"},
	"kywd": {Description: "Media keywords"},
	"leva": {Description: "Leval assignment"},
	"load": {Description: "Track pre-load definitions"},
	"loci": {Description: "Media location information"},
	"loop": {Description: "Looping behavior"},
	"lrcu": {Description: "OMA DRM Lyrics URI"},
	"ludt": {Description: "Track loudness container"},
	"m7hd": {Description: "Reserved for MPEG7Stream header"},
	"manu": {Description: "Manufacturer name of the camera"},
	"matt": {Description: "Visual track matte for compositing"},
	"md5i": {Description: "MD5IntegrityBox"},
	"mdat": {Description: "Media data container"},
	"mdhd": {Description: "Media header, overall information about the media"},
	"mdia": {Description: "Container for the media information in a track"},
	"mdri": {Description: "Mutable DRM information"},
	"meco": {Description: "Additional metadata container"},
	"mehd": {Description: "Movie extends header box"},
	"mere": {Description: "Metabox relation"},
	"meta": {Description: "Metadata container"},
	"mfhd": {Description: "Movie fragment header"},
	"mfra": {Description: "Movie fragment random access"},
	"mfro": {Description: "Movie fragment random access offset"},
	"minf": {Description: "Media information container"},
	"mjhd": {Description: "Reserved for MPEG-J Stream header"},
	"modl": {Description: "Model name of the camera"},
	"moof": {Description: "Movie fragment"},
	"moov": {Description: "Container for all the meta-data"},
	"mstv": {Description: "MVC sub track view box"},
	"mvcg": {Description: "Multiview group"},
	"mvci": {Description: "Multiview Information"},
	"mvdr": {Description: "MVDDepthResolutionBox"},
	"mvex": {Description: "Movie extends box"},
	"mvhd": {Description: "Movie header, overall declarations"},
	"mvra": {Description: "Multiview Relation Attribute"},
	"nmhd": {Description: "Null media header, overall information (some tracks only)"},
	"ochd": {Description: "Reserved for ObjectContentInfoStream header"},
	"odaf": {Description: "OMA DRM Access Unit Format"},
	"odda": {Description: "OMA DRM Content Object"},
	"odhd": {Description: "Reserved for ObjectDescriptorStream header"},
	"odhe": {Description: "OMA DRM Discrete Media Headers"},
	"odrb": {Description: "OMA DRM Rights Object"},
	"odrm": {Description: "OMA DRM Container"},
	"odtt": {Description: "OMA DRM Transaction Tracking"},
	"ohdr": {Description: "OMA DRM Common headers"},
	"orie": {Description: "Orientation information"},
	"padb": {Description: "Sample padding bits"},
	"paen": {Description: "Partition Entry"},
	"pasp": {Description: "Pixel aspect ratio"},
	"pclr": {Description: "Palette which maps a single component in index space to a multiple- component image"},
	"pdat": {Description: "Partial Data"},
	"pdin": {Description: "Progressive download information"},
	"perf": {Description: "Media performer name"},
	"pfhd": {Description: "Partial File Header"},
	"pfil": {Description: "Partial File"},
	"pitm": {Description: "Primary item reference"},
	"ploc": {Description: "Partial Segment Location"},
	"pnot": {Description: "Preview container"},
	"prft": {Description: "Producer reference time"},
	"pseg": {Description: "Partial Segment"},
	"pshd": {Description: "Partial Segment Header"},
	"pssh": {Description: "Protection system specific header"},
	"ptle": {Description: "Partial Top Level Entry"},
	"reel": {Description: "Name of the tape reel"},
	"res ": {Description: "Grid resolution"},
	"resc": {Description: "Grid resolution at which the image was captured"},
	"resd": {Description: "Default grid resolution at which the image should be displayed"},
	"rinf": {Description: "Restricted scheme information box"},
	"rtng": {Description: "Media rating"},
	"saio": {Description: "Sample auxiliary information offsets"},
	"saiz": {Description: "Sample auxiliary information sizes"},
	"sbgp": {Description: "Sample to Group box"},
	"scen": {Description: "Name of the scene for which the clip was shot"},
	"schi": {Description: "Scheme information box"},
	"schm": {Description: "Scheme type box"},
	"sdep": {Description: "Sample dependency"},
	"sdhd": {Description: "Reserved for SceneDescriptionStream header"},
	"sdtp": {Description: "Sample Dependency Flags"},
	"sdvp": {Description: "SD Profile Box"},
	"segr": {Description: "File delivery session group"},
	"seii": {Description: "SEI information box"},
	"senc": {Description: "Sample specific encryption data"},
	"sgpd": {Description: "Sample group definition box"},
	"shot": {Description: "Name that identifies the shot"},
	"sidx": {Description: "Segment Index Box"},
	"sinf": {Description: "Protection scheme information box"},
	"skip": {Description: "Free space"},
	"slno": {Description: "Serial number of the camera"},
	"smhd": {Description: "Sound media header, overall information (sound track only)"},
	"srmb": {Description: "System Renewability Message"},
	"srmc": {Description: "System Renewability Message container"},
	"srpp": {Description: "STRP Process"},
	"ssix": {Description: "Sub-sample index"},
	"sstl": {Description: "SVC sub track layer box"},
	"stbl": {Description: "Sample table box, container for the time/space map"},
	"stco": {Description: "Chunk offset, partial data-offset information"},
	"stdp": {Description: "Sample degradation priority"},
	"sthd": {Description: "Subtitle Media Header Box"},
	"stmg": {Description: "MVC sub track multiview group box"},
	"strd": {Description: "Sub-track definition"},
	"stri": {Description: "Sub-track information"},
	"strk": {Description: "Sub track information"},
	"stsc": {Description: "Sample-to-chunk, partial data-offset information"},
	"stsd": {Description: "Sample descriptions (codec types, initialization etc.)"},
	"stsg": {Description: "Sub-track sample grouping"},
	"stsh": {Description: "Shadow sync sample table"},
	"stss": {Description: "Sync sample table (random access points)"},
	"stsz": {Description: "Sample sizes (framing)"},
	"stti": {Description: "Sub track tier box"},
	"stts": {Description: "Sample time-to-sample"},
	"styp": {Description: "Segment Type Box"},
	"stz2": {Description: "Compact sample sizes (framing)"},
	"subs": {Description: "Sub-sample information"},
	"surl": {Description: "Source URL"},
	"swtc": {Description: "Multiview Group Relation"},
	"tenc": {Description: "Track Encryption"},
	"tfad": {Description: "Track fragment adjustment box"},
	"tfdt": {Description: "Track fragment decode time"},
	"tfhd": {Description: "Track fragment header"},
	"tfma": {Description: "Track fragment media adjustment box"},
	"tfra": {Description: "Track fragment radom access"},
	"thmb": {Description: "Thumbnail image of the media"},
	"tibr": {Description: "Tier Bit rate"},
	"tiri": {Description: "Tier Information"},
	"titl": {Description: "Media title"},
	"tkhd": {Description: "Track header, overall information about the track"},
	"tlou": {Description: "Track loudness base"},
	"traf": {Description: "Track fragment"},
	"trak": {Description: "Container for an individual track or stream"},
	"tref": {Description: "Track reference container"},
	"trep": {Description: "Track extension properties"},
	"trex": {Description: "Track extends defaults"},
	"trgr": {Description: "Track grouping information"},
	"trik": {Description: "Facilitates random access and trick play modes"},
	"trun": {Description: "Track fragment run"},
	"tsel": {Description: "Track selection"},
	"tstb": {Description: "TileSubTrackGroupBox"},
	"ttyp": {Description: "Track type and compatibility"},
	"tyco": {Description: "Type and-combination"},
	"udta": {Description: "User-data"},
	"uinf": {Description: "A tool by which a vendor may provide access to additional information associated with a UUID"},
	"UITS": {Description: "Unique Identifier Technology Solution"},
	"ulst": {Description: "A list of UUID’s"},
	"urat": {Description: "User 'star' rating of the media"},
	"url ": {Description: "A URL"},
	"uuid": {Description: "User-extension box"},
	"vmhd": {Description: "Video media header, overall information (video track only)"},
	"vwdi": {Description: "Multiview Scene Information"},
	"wide": {Description: "Expansion space reservation"},
	"xml ": {Description: "XML container"},
	"yrrc": {Description: "Year when media was recorded"},

	"\x00\x00\x00\x00": {Description: "Terminator Atom"},
}
