/* backend.c generated by valac 0.35.3.10-6b27, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <libebook/libebook.h>
#include <gee.h>
#include <libebook-contacts/libebook-contacts.h>
#include <folks-test.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <gobject/gvaluecollector.h>


#define EDS_TEST_TYPE_BACKEND (eds_test_backend_get_type ())
#define EDS_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackend))
#define EDS_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))
#define EDS_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TEST_TYPE_BACKEND))
#define EDS_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TEST_TYPE_BACKEND, EdsTestBackendClass))

typedef struct _EdsTestBackend EdsTestBackend;
typedef struct _EdsTestBackendClass EdsTestBackendClass;
typedef struct _EdsTestBackendPrivate EdsTestBackendPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _eds_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (eds_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _EdsTestBackendUpdateContactData EdsTestBackendUpdateContactData;
typedef struct _EdsTestBackendRemoveContactData EdsTestBackendRemoveContactData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _EdsTestBackendPrepareSourceAsyncData EdsTestBackendPrepareSourceAsyncData;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _EdsTestBackendCommitContactsToAddressbookData EdsTestBackendCommitContactsToAddressbookData;
typedef struct _Block3Data Block3Data;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define __vala_EContactPhoto_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactPhoto_free (var), NULL)))
#define __vala_EContactName_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactName_free (var), NULL)))
#define __vala_EContactAddress_free0(var) ((var == NULL) ? NULL : (var = (_vala_EContactAddress_free (var), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
typedef struct _EdsTestParamSpecBackend EdsTestParamSpecBackend;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	EDS_TEST_BACKEND_SETUP_ERROR_FETCH_SOURCE_GROUP_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_OPENING_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_CONTACT_FAILED,
	EDS_TEST_BACKEND_SETUP_ERROR_ADD_TO_SOURCE_GROUP_FAILED
} EdsTestBackendSetupError;
#define EDS_TEST_BACKEND_SETUP_ERROR eds_test_backend_setup_error_quark ()
struct _EdsTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EdsTestBackendPrivate * priv;
};

struct _EdsTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (EdsTestBackend *self);
};

struct _EdsTestBackendPrivate {
	gchar* _addressbook_name;
	EBookClient* _addressbook;
	gchar** _e_contacts;
	gint _e_contacts_length1;
	gint __e_contacts_size_;
	GList* _contacts;
	ESourceRegistry* _source_registry;
	ESource* _source;
	GFile* _source_file;
};

struct _EdsTestBackendUpdateContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	GeeHashMap* updated_data;
	gchar* uid;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EContact* _tmp7_;
	GeeHashMap* _tmp8_;
	EBookClient* _tmp9_;
	EContact* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _EdsTestBackendRemoveContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gint contact_pos;
	gchar* uid;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	EContact* contact;
	EBookClient* _tmp4_;
	const gchar* _tmp5_;
	EContact* _tmp6_;
	EBookClient* _tmp7_;
	EContact* _tmp8_;
	GError* e;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	EdsTestBackend* self;
	GMainLoop* mainloop;
};

struct _Block2Data {
	int _ref_count_;
	EdsTestBackend* self;
	gpointer _async_data_;
};

struct _EdsTestBackendPrepareSourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	gboolean is_default;
	Block2Data* _data2_;
	gchar* source_file_name;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* config_dir;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* source_file;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* source_file_content;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* _tmp14_;
	const gchar* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp17_;
	gint _tmp17__length1;
	ESourceRegistry* source_registry;
	ESourceRegistry* _tmp18_;
	ESourceRegistry* _tmp19_;
	ESourceRegistry* _tmp20_;
	gulong signal_id;
	ESourceRegistry* _tmp21_;
	gulong _tmp22_;
	ESourceRegistry* _tmp23_;
	const gchar* _tmp24_;
	ESource* _tmp25_;
	ESource* _tmp26_;
	ESource* _tmp27_;
	ESourceRegistry* _tmp28_;
	gulong _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	gboolean _tmp32_;
	GError * _inner_error_;
};

struct _EdsTestBackendCommitContactsToAddressbookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	EdsTestBackend* self;
	GSList* contacts;
	GList* _tmp0_;
	GList* c_collection;
	GList* c_it;
	GeeHashMap* _tmp1_;
	GeeHashMap* c;
	EContact* contact;
	EContact* _tmp2_;
	EContact* _tmp3_;
	GeeHashMap* _tmp4_;
	EContact* _tmp5_;
	EContact* _tmp6_;
	GSList* uids;
	EBookClient* _tmp7_;
	GSList* _tmp8_;
	GSList* _tmp9_;
	GSList* uid_collection;
	GSList* uid_it;
	const gchar* uid;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	EdsTestBackend* self;
	GMainLoop* main_loop;
};

struct _EdsTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer eds_test_backend_parent_class = NULL;

void e_source_registry_new (GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
ESourceRegistry* e_source_registry_new_finish (GAsyncResult* _res_, GError** error);
GQuark eds_test_backend_setup_error_quark (void);
gpointer eds_test_backend_ref (gpointer instance);
void eds_test_backend_unref (gpointer instance);
GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void eds_test_value_set_backend (GValue* value, gpointer v_object);
void eds_test_value_take_backend (GValue* value, gpointer v_object);
gpointer eds_test_value_get_backend (const GValue* value);
GType eds_test_backend_get_type (void) G_GNUC_CONST;
#define EDS_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), EDS_TEST_TYPE_BACKEND, EdsTestBackendPrivate))
enum  {
	EDS_TEST_BACKEND_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
EdsTestBackend* eds_test_backend_new (const gchar* name);
EdsTestBackend* eds_test_backend_construct (GType object_type, const gchar* name);
void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c);
static void eds_test_backend_update_contact_data_free (gpointer _data);
void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_);
static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c);
static void eds_test_backend_remove_contact_data_free (gpointer _data);
void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_);
static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void eds_test_backend_reset (EdsTestBackend* self);
void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default);
static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default);
void eds_test_backend_set_as_default (EdsTestBackend* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _eds_test_backend_prepare_source_async_data_free (gpointer _data);
static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void __lambda4_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s);
static void ___lambda4__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self);
static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data);
void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_);
static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_);
static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void _g_slist_free__g_object_unref0_ (GSList* self);
void eds_test_backend_commit_contacts_to_addressbook_sync (EdsTestBackend* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda6_ (Block3Data* _data3_, GObject* s, GAsyncResult* r);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _vala_GValue_free (GValue* self);
static void _vala_EContactPhoto_free (EContactPhoto* self);
static void _vala_EContactName_free (EContactName* self);
static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str);
static void _vala_EContactAddress_free (EContactAddress* self);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
void eds_test_backend_tear_down (EdsTestBackend* self);
const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self);
static void eds_test_backend_finalize (EdsTestBackend * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark eds_test_backend_setup_error_quark (void) {
	return g_quark_from_static_string ("eds_test_backend_setup_error-quark");
}


static void _g_object_unref0_ (gpointer var) {
#line 43 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 351 "backend.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 43 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 43 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_list_free (self);
#line 360 "backend.c"
}


EdsTestBackend* eds_test_backend_construct (GType object_type, const gchar* name) {
	EdsTestBackend* self = NULL;
	gchar** _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 53 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 53 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self = (EdsTestBackend*) g_type_create_instance (object_type);
#line 55 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 55 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 56 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 56 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 56 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = _tmp0_;
#line 56 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts_length1 = 0;
#line 56 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->__e_contacts_size_ = self->priv->_e_contacts_length1;
#line 57 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = name;
#line 57 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 57 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 57 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_addressbook_name = _tmp2_;
#line 53 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return self;
#line 397 "backend.c"
}


EdsTestBackend* eds_test_backend_new (const gchar* name) {
#line 53 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return eds_test_backend_construct (EDS_TEST_TYPE_BACKEND, name);
#line 404 "backend.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 62 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return self ? g_object_ref (self) : NULL;
#line 411 "backend.c"
}


void eds_test_backend_add_contact (EdsTestBackend* self, GeeHashMap* c) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
#line 60 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 60 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 62 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = c;
#line 62 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 62 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = g_list_prepend (self->priv->_contacts, _tmp1_);
#line 60 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (c);
#line 430 "backend.c"
}


static void eds_test_backend_update_contact_data_free (gpointer _data) {
	EdsTestBackendUpdateContactData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendUpdateContactData, _data_);
#line 443 "backend.c"
}


static gpointer _eds_test_backend_ref0 (gpointer self) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return self ? eds_test_backend_ref (self) : NULL;
#line 450 "backend.c"
}


void eds_test_backend_update_contact (EdsTestBackend* self, gint contact_pos, GeeHashMap* updated_data, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendUpdateContactData);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_update_contact);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_update_contact_data_free);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->updated_data = updated_data;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 478 "backend.c"
}


void eds_test_backend_update_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendUpdateContactData* _data_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 486 "backend.c"
}


static void eds_test_backend_update_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendUpdateContactData* _data_;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_update_contact_co (_data_);
#line 500 "backend.c"
}


static gboolean eds_test_backend_update_contact_co (EdsTestBackendUpdateContactData* _data_) {
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 509 "backend.c"
		goto _state_0;
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 513 "backend.c"
		goto _state_1;
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 2:
#line 517 "backend.c"
		goto _state_2;
		default:
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 522 "backend.c"
	}
	_state_0:
#line 68 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 68 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = _data_->self->priv->_e_contacts_length1;
#line 68 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 68 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
#line 68 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 68 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 537 "backend.c"
	{
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 551 "backend.c"
		_state_1:
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 72 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 561 "backend.c"
			goto __catch0_g_error;
		}
#line 73 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->contact;
#line 73 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->updated_data;
#line 73 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp7_, _data_->_tmp8_);
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = _data_->self->priv->_addressbook;
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp10_ = _data_->contact;
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact (_data_->_tmp9_, _data_->_tmp10_, NULL, eds_test_backend_update_contact_ready, _data_);
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 580 "backend.c"
		_state_2:
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_modify_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
#line 74 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 586 "backend.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 78 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:78: Couldn't update contact\n");
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 601 "backend.c"
	}
	__finally0:
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->updated_data);
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 70 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 618 "backend.c"
	}
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->updated_data);
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 630 "backend.c"
	} else {
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 634 "backend.c"
	}
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 640 "backend.c"
}


static void eds_test_backend_remove_contact_data_free (gpointer _data) {
	EdsTestBackendRemoveContactData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendRemoveContactData, _data_);
#line 651 "backend.c"
}


void eds_test_backend_remove_contact (EdsTestBackend* self, gint contact_pos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
	EdsTestBackend* _tmp0_;
	gint _tmp1_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendRemoveContactData);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_remove_contact);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_remove_contact_data_free);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = contact_pos;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->contact_pos = _tmp1_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 675 "backend.c"
}


void eds_test_backend_remove_contact_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendRemoveContactData* _data_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 683 "backend.c"
}


static void eds_test_backend_remove_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendRemoveContactData* _data_;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_remove_contact_co (_data_);
#line 697 "backend.c"
}


static gboolean eds_test_backend_remove_contact_co (EdsTestBackendRemoveContactData* _data_) {
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 706 "backend.c"
		goto _state_0;
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 710 "backend.c"
		goto _state_1;
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 2:
#line 714 "backend.c"
		goto _state_2;
		default:
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 719 "backend.c"
	}
	_state_0:
#line 84 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_e_contacts;
#line 84 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0__length1 = _data_->self->priv->_e_contacts_length1;
#line 84 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = _data_->contact_pos;
#line 84 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = _data_->_tmp0_[_data_->_tmp1_];
#line 84 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
#line 84 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->uid = _data_->_tmp3_;
#line 734 "backend.c"
	{
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp4_ = _data_->self->priv->_addressbook;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp5_ = _data_->uid;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp6_ = NULL;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact (_data_->_tmp4_, _data_->_tmp5_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 748 "backend.c"
		_state_1:
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_get_contact_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->contact = _data_->_tmp6_;
#line 88 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 758 "backend.c"
			goto __catch1_g_error;
		}
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contact;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 2;
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_remove_contact_ready, _data_);
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 771 "backend.c"
		_state_2:
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_remove_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
#line 89 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 777 "backend.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 93 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:93: Couldn't remove contact\n");
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 792 "backend.c"
	}
	__finally1:
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->contact);
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->uid);
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 86 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 807 "backend.c"
	}
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->contact);
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->uid);
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 817 "backend.c"
	} else {
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 821 "backend.c"
	}
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 82 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 827 "backend.c"
}


void eds_test_backend_reset (EdsTestBackend* self) {
	gchar** _tmp0_;
#line 97 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 99 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 99 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_contacts = NULL;
#line 100 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 100 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 100 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = _tmp0_;
#line 100 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts_length1 = 0;
#line 100 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->__e_contacts_size_ = self->priv->_e_contacts_length1;
#line 849 "backend.c"
}


void eds_test_backend_set_up (EdsTestBackend* self, gboolean source_is_default) {
	GError * _inner_error_ = NULL;
#line 104 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 857 "backend.c"
	{
		gboolean _tmp0_;
		EBookClient* _tmp1_;
		ESource* _tmp2_;
		EBookClient* _tmp3_;
		EBookClient* _tmp4_;
		const gchar* _tmp5_;
#line 108 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp0_ = source_is_default;
#line 108 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source (self, _tmp0_);
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp2_ = self->priv->_source;
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp3_ = e_book_client_connect_sync (_tmp2_, (guint32) 1, NULL, &_inner_error_);
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp1_ = _tmp3_;
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 877 "backend.c"
			goto __catch2_g_error;
		}
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp4_ = _tmp1_;
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp1_ = NULL;
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 109 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = _tmp4_;
#line 110 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp5_ = self->priv->_addressbook_name;
#line 110 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", _tmp5_, TRUE);
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp1_);
#line 894 "backend.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 115 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp6_ = e;
#line 115 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_->message;
#line 115 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:115: Unable to create test data: %s\n", _tmp7_);
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 914 "backend.c"
	}
	__finally2:
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 106 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return;
#line 925 "backend.c"
	}
}


void eds_test_backend_set_as_default (EdsTestBackend* self) {
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
#line 119 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 121 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_source_registry;
#line 121 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = self->priv->_source;
#line 121 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	e_source_registry_set_default_address_book (_tmp0_, _tmp1_);
#line 941 "backend.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return _data1_;
#line 950 "backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 959 "backend.c"
		EdsTestBackend* self;
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self = _data1_->self;
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data1_->mainloop);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 969 "backend.c"
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* async_res) {
	EdsTestBackend* self;
	GError * _inner_error_ = NULL;
#line 128 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self = _data1_->self;
#line 128 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (async_res != NULL);
#line 981 "backend.c"
	{
		GAsyncResult* _tmp0_;
#line 132 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp0_ = async_res;
#line 132 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_prepare_source_finish (self, _tmp0_, &_inner_error_);
#line 132 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 990 "backend.c"
			goto __catch3_g_error;
		}
#line 133 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_main_loop_quit (_data1_->mainloop);
#line 995 "backend.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 137 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp1_ = e;
#line 137 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp2_ = _tmp1_->message;
#line 137 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("backend.vala:137: %s", _tmp2_);
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 1015 "backend.c"
	}
	__finally3:
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 130 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return;
#line 1026 "backend.c"
	}
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 128 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__lambda5_ (self, source_object, res);
#line 128 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	block1_data_unref (self);
#line 1036 "backend.c"
}


static void _eds_test_backend_prepare_source (EdsTestBackend* self, gboolean is_default) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	gboolean _tmp1_;
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data1_->_ref_count_ = 1;
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data1_->self = eds_test_backend_ref (self);
#line 126 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 126 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data1_->mainloop = _tmp0_;
#line 128 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 128 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async (self, _tmp1_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 141 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_main_loop_run (_data1_->mainloop);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	block1_data_unref (_data1_);
#line 124 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data1_ = NULL;
#line 1066 "backend.c"
}


static void _eds_test_backend_prepare_source_async_data_free (gpointer _data) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendPrepareSourceAsyncData, _data_);
#line 1077 "backend.c"
}


static void _eds_test_backend_prepare_source_async (EdsTestBackend* self, gboolean is_default, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
	EdsTestBackend* _tmp0_;
	gboolean _tmp1_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendPrepareSourceAsyncData);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, _eds_test_backend_prepare_source_async);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _eds_test_backend_prepare_source_async_data_free);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = is_default;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->is_default = _tmp1_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1101 "backend.c"
}


static void _eds_test_backend_prepare_source_finish (EdsTestBackend* self, GAsyncResult* _res_, GError** error) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return;
#line 1111 "backend.c"
	}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1115 "backend.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return _data2_;
#line 1124 "backend.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1133 "backend.c"
		EdsTestBackend* self;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self = _data2_->self;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block2Data, _data2_);
#line 1141 "backend.c"
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1420 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1421 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1421 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1422 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1422 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1422 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1422 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 1186 "backend.c"
	}
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1423 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1192 "backend.c"
}


static void _eds_test_backend_prepare_source_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendPrepareSourceAsyncData* _data_;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data_);
#line 1206 "backend.c"
}


static void __lambda4_ (Block2Data* _data2_, ESourceRegistry* r, ESource* s) {
	EdsTestBackend* self;
	ESource* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self = _data2_->self;
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (s != NULL);
#line 169 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = s;
#line 169 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_source_get_uid (_tmp0_);
#line 169 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = _tmp1_;
#line 169 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp3_ = self->priv->_addressbook_name;
#line 169 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
#line 170 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return;
#line 1236 "backend.c"
	}
#line 172 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp4_ = s;
#line 172 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 172 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 172 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source = _tmp5_;
#line 173 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_prepare_source_async_co (_data2_->_async_data_);
#line 1248 "backend.c"
}


static void ___lambda4__e_source_registry_source_added (ESourceRegistry* _sender, ESource* source, gpointer self) {
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__lambda4_ (self, _sender, source);
#line 1255 "backend.c"
}


static gboolean _eds_test_backend_prepare_source_async_co (EdsTestBackendPrepareSourceAsyncData* _data_) {
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1264 "backend.c"
		goto _state_0;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1268 "backend.c"
		goto _state_1;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 2:
#line 1272 "backend.c"
		goto _state_2;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 3:
#line 1276 "backend.c"
		goto _state_3;
		default:
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1281 "backend.c"
	}
	_state_0:
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->self = eds_test_backend_ref (_data_->self);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 147 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_addressbook_name;
#line 147 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp1_ = g_strconcat (_data_->_tmp0_, ".source", NULL);
#line 147 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->source_file_name = _data_->_tmp1_;
#line 149 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp2_ = g_get_user_config_dir ();
#line 149 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
#line 149 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->config_dir = _data_->_tmp3_;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp4_ = _data_->config_dir;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp5_ = g_file_get_child (_data_->_tmp4_, "evolution");
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp7_ = g_file_get_child (_data_->_tmp6_, "sources");
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp9_ = _data_->source_file_name;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp10_ = g_file_get_child (_data_->_tmp8_, _data_->_tmp9_);
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp8_);
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->_tmp6_);
#line 150 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->source_file = _data_->_tmp11_;
#line 153 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp12_ = _data_->self->priv->_addressbook_name;
#line 153 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp13_ = g_strdup_printf ("[Data Source]\n" "DisplayName=%s\n" "Enabled=true\n" "Parent=local-stub\n" "\n" "[Address Book]\n" "BackendName=local\n", _data_->_tmp12_);
#line 153 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->source_file_content = _data_->_tmp13_;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp14_ = _data_->source_file;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp15_ = _data_->source_file_content;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp16_ = string_get_data (_data_->_tmp15_, &_data_->_tmp16__length1);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17_ = _data_->_tmp16_;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp17__length1 = _data_->_tmp16__length1;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 1;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_async (_data_->_tmp14_, _data_->_tmp17_, (gsize) _data_->_tmp17__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1348 "backend.c"
	_state_1:
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_file_replace_contents_finish (_data_->_tmp14_, _data_->_res_, NULL, &_data_->_inner_error_);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_take_error (_data_->_async_result, _data_->_inner_error_);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1372 "backend.c"
		} else {
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1376 "backend.c"
		}
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 161 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1382 "backend.c"
	}
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_state_ = 2;
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	e_source_registry_new (NULL, _eds_test_backend_prepare_source_async_ready, _data_);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1390 "backend.c"
	_state_2:
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp18_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error_);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->source_registry = _data_->_tmp18_;
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_take_error (_data_->_async_result, _data_->_inner_error_);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_content);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->source_file);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_data_->config_dir);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_data_->source_file_name);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		block2_data_unref (_data_->_data2_);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_data2_ = NULL;
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (_data_->_state_ == 0) {
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1416 "backend.c"
		} else {
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1420 "backend.c"
		}
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_object_unref (_data_->_async_result);
#line 165 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1426 "backend.c"
	}
#line 166 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp19_ = _data_->source_registry;
#line 166 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_registry);
#line 166 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_registry = _data_->_tmp20_;
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp21_ = _data_->source_registry;
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp22_ = g_signal_connect_data (_data_->_tmp21_, "source-added", (GCallback) ___lambda4__e_source_registry_source_added, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
#line 167 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->signal_id = _data_->_tmp22_;
#line 177 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp23_ = _data_->source_registry;
#line 177 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp24_ = _data_->self->priv->_addressbook_name;
#line 177 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp25_ = e_source_registry_ref_source (_data_->_tmp23_, _data_->_tmp24_);
#line 177 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source);
#line 177 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source = _data_->_tmp25_;
#line 178 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp26_ = _data_->self->priv->_source;
#line 178 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp26_ == NULL) {
#line 180 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 3;
#line 180 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1460 "backend.c"
		_state_3:
		;
	}
#line 184 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp27_ = _data_->self->priv->_source;
#line 184 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_vala_assert (_data_->_tmp27_ != NULL, "this._source != null");
#line 185 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp28_ = _data_->source_registry;
#line 185 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp29_ = _data_->signal_id;
#line 185 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_signal_handler_disconnect ((GObject*) _data_->_tmp28_, _data_->_tmp29_);
#line 187 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp30_ = _data_->source_file;
#line 187 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
#line 187 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->self->priv->_source_file);
#line 187 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_source_file = _data_->_tmp31_;
#line 189 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp32_ = _data_->is_default;
#line 189 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_tmp32_) {
#line 191 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_set_as_default (_data_->self);
#line 1488 "backend.c"
	}
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_registry);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_content);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->source_file);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (_data_->config_dir);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (_data_->source_file_name);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	block2_data_unref (_data_->_data2_);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_data2_ = NULL;
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1508 "backend.c"
	} else {
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1512 "backend.c"
	}
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 144 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1518 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_data_free (gpointer _data) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	_data_ = _data;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_eds_test_backend_unref0 (_data_->self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slice_free (EdsTestBackendCommitContactsToAddressbookData, _data_);
#line 1529 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook (EdsTestBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
	EdsTestBackend* _tmp0_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_slice_new0 (EdsTestBackendCommitContactsToAddressbookData);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, eds_test_backend_commit_contacts_to_addressbook);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, eds_test_backend_commit_contacts_to_addressbook_data_free);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = _eds_test_backend_ref0 (self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self = _tmp0_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1548 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_finish (EdsTestBackend* self, GAsyncResult* _res_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1556 "backend.c"
}


static void eds_test_backend_commit_contacts_to_addressbook_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	EdsTestBackendCommitContactsToAddressbookData* _data_;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_ = _user_data_;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_source_object_ = source_object;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_res_ = _res_;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_co (_data_);
#line 1570 "backend.c"
}


static void _g_free0_ (gpointer var) {
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	var = (g_free (var), NULL);
#line 1577 "backend.c"
}


static void _g_slist_free__g_free0_ (GSList* self) {
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slist_free (self);
#line 1586 "backend.c"
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if ((*length) == (*size)) {
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1597 "backend.c"
	}
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	(*array)[(*length)++] = value;
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	(*array)[*length] = NULL;
#line 1603 "backend.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_slist_free (self);
#line 1612 "backend.c"
}


static gboolean eds_test_backend_commit_contacts_to_addressbook_co (EdsTestBackendCommitContactsToAddressbookData* _data_) {
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	switch (_data_->_state_) {
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 0:
#line 1621 "backend.c"
		goto _state_0;
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		case 1:
#line 1625 "backend.c"
		goto _state_1;
		default:
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_assert_not_reached ();
#line 1630 "backend.c"
	}
	_state_0:
#line 197 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->contacts = NULL;
#line 199 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->self->priv->_contacts = g_list_reverse (_data_->self->priv->_contacts);
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data_->_tmp0_ = _data_->self->priv->_contacts;
#line 1639 "backend.c"
	{
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->c_collection = _data_->_tmp0_;
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		for (_data_->c_it = _data_->c_collection; _data_->c_it != NULL; _data_->c_it = _data_->c_it->next) {
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_data_->_tmp1_ = _g_object_ref0 ((GeeHashMap*) _data_->c_it->data);
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_data_->c = _data_->_tmp1_;
#line 1649 "backend.c"
			{
#line 203 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp2_ = e_contact_new ();
#line 203 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->contact = _data_->_tmp2_;
#line 205 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp3_ = _data_->contact;
#line 205 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp4_ = _data_->c;
#line 205 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_eds_test_backend_set_contact_fields (_data_->self, _data_->_tmp3_, _data_->_tmp4_);
#line 207 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp5_ = _data_->contact;
#line 207 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 207 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->contacts = g_slist_prepend (_data_->contacts, _data_->_tmp6_);
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->contact);
#line 201 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_object_unref0 (_data_->c);
#line 1671 "backend.c"
			}
		}
	}
	{
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp7_ = _data_->self->priv->_addressbook;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp8_ = _data_->contacts;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp9_ = NULL;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_state_ = 1;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_add_contacts (_data_->_tmp7_, _data_->_tmp8_, NULL, eds_test_backend_commit_contacts_to_addressbook_ready, _data_);
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1688 "backend.c"
		_state_1:
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_book_client_add_contacts_finish (_data_->_tmp7_, _data_->_res_, &_data_->_tmp9_, &_data_->_inner_error_);
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_free0_0 (_data_->uids);
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->uids = _data_->_tmp9_;
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 214 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			__g_slist_free__g_free0_0 (_data_->uids);
#line 1700 "backend.c"
			goto __catch4_g_error;
		}
		{
#line 216 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_data_->uid_collection = _data_->uids;
#line 216 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			for (_data_->uid_it = _data_->uid_collection; _data_->uid_it != NULL; _data_->uid_it = _data_->uid_it->next) {
#line 216 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_data_->uid = (const gchar*) _data_->uid_it->data;
#line 1710 "backend.c"
				{
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10_ = _data_->self->priv->_e_contacts;
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp10__length1 = _data_->self->priv->_e_contacts_length1;
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp11_ = _data_->uid;
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
#line 217 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_vala_array_add1 (&_data_->self->priv->_e_contacts, &_data_->self->priv->_e_contacts_length1, &_data_->self->priv->__e_contacts_size_, _data_->_tmp12_);
#line 1722 "backend.c"
				}
			}
		}
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_free0_0 (_data_->uids);
#line 1728 "backend.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->e = _data_->_inner_error_;
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_inner_error_ = NULL;
#line 221 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp13_ = _data_->e;
#line 221 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_data_->_tmp14_ = _data_->_tmp13_->message;
#line 221 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_warning ("backend.vala:221: Couldn't add contacts: %s\n", _data_->_tmp14_);
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (_data_->e);
#line 1745 "backend.c"
	}
	__finally4:
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		__g_slist_free__g_object_unref0_0 (_data_->contacts);
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_data_->_inner_error_);
#line 210 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return FALSE;
#line 1758 "backend.c"
	}
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__g_slist_free__g_object_unref0_0 (_data_->contacts);
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_data_->_state_ == 0) {
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1766 "backend.c"
	} else {
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1770 "backend.c"
	}
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_object_unref (_data_->_async_result);
#line 195 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return FALSE;
#line 1776 "backend.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return _data3_;
#line 1785 "backend.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1794 "backend.c"
		EdsTestBackend* self;
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self = _data3_->self;
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_main_loop_unref0 (_data3_->main_loop);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_eds_test_backend_unref0 (self);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_slice_free (Block3Data, _data3_);
#line 1804 "backend.c"
	}
}


static void __lambda6_ (Block3Data* _data3_, GObject* s, GAsyncResult* r) {
	EdsTestBackend* self;
	GAsyncResult* _tmp0_;
#line 229 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self = _data3_->self;
#line 229 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (r != NULL);
#line 231 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = r;
#line 231 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook_finish (self, _tmp0_);
#line 232 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_main_loop_quit (_data3_->main_loop);
#line 1822 "backend.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 229 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__lambda6_ (self, source_object, res);
#line 229 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	block3_data_unref (self);
#line 1831 "backend.c"
}


void eds_test_backend_commit_contacts_to_addressbook_sync (EdsTestBackend* self) {
	Block3Data* _data3_;
	GMainLoop* _tmp0_;
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data3_->_ref_count_ = 1;
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data3_->self = eds_test_backend_ref (self);
#line 228 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = g_main_loop_new (NULL, FALSE);
#line 228 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data3_->main_loop = _tmp0_;
#line 229 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_commit_contacts_to_addressbook (self, ___lambda6__gasync_ready_callback, block3_data_ref (_data3_));
#line 234 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	folks_test_utils_loop_run_with_timeout (_data3_->main_loop, 5);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	block3_data_unref (_data3_);
#line 226 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_data3_ = NULL;
#line 1858 "backend.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
#line 1347 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1348 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1348 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1348 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1349 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1349 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1891 "backend.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1350 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1350 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1350 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1900 "backend.c"
	}
#line 1352 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1352 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1906 "backend.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1353 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1353 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1353 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1915 "backend.c"
	}
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1921 "backend.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1930 "backend.c"
	} else {
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1934 "backend.c"
	}
#line 1355 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1942 "backend.c"
		glong _tmp14_;
		glong _tmp15_;
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1951 "backend.c"
	} else {
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1955 "backend.c"
	}
#line 1356 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1357 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1357 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1357 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1358 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1358 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1358 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1358 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1358 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1358 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1977 "backend.c"
}


static void _vala_GValue_free (GValue* self) {
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_value_unset (self);
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_free (self);
#line 1986 "backend.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1003 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1003 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1004 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1004 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 1004 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 1004 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1006 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1006 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 2013 "backend.c"
		gchar* _tmp4_;
#line 1007 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1007 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1007 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2021 "backend.c"
	} else {
#line 1009 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		result = -1;
#line 1009 "/opt/gnome/install/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2027 "backend.c"
	}
}


static void _vala_EContactPhoto_free (EContactPhoto* self) {
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_photo_get_type (), self);
#line 2035 "backend.c"
}


static void _vala_EContactName_free (EContactName* self) {
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_name_get_type (), self);
#line 2042 "backend.c"
}


static void _vala_EContactAddress_free (EContactAddress* self) {
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_contact_address_get_type (), self);
#line 2049 "backend.c"
}


static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self) {
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
#line 2056 "backend.c"
}


static gpointer __vala_EVCardAttribute_copy0 (gpointer self) {
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
#line 2063 "backend.c"
}


static void _vala_EVCardAttribute_free (EVCardAttribute* self) {
#line 336 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_boxed_free (e_vcard_attribute_get_type (), self);
#line 2070 "backend.c"
}


static void _eds_test_backend_set_contact_fields (EdsTestBackend* self, EContact* contact, GeeHashMap* c) {
	gboolean added_contact_name;
	EContactName* contact_name;
	EContactName* _tmp0_;
	gchar* contact_field_name;
	gchar* _tmp1_;
	gint min_len;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp208_;
	GError * _inner_error_ = NULL;
#line 237 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 237 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (contact != NULL);
#line 237 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (c != NULL);
#line 240 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	added_contact_name = FALSE;
#line 241 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = e_contact_name_new ();
#line 241 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	contact_name = _tmp0_;
#line 242 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = g_strdup ("contact_name");
#line 242 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	contact_field_name = _tmp1_;
#line 243 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = contact_field_name;
#line 243 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp3_ = strlen (_tmp2_);
#line 243 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp4_ = _tmp3_;
#line 243 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	min_len = _tmp4_;
#line 2110 "backend.c"
	{
		GeeIterator* _k_it;
		GeeHashMap* _tmp5_;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp5_ = c;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp7_ = _tmp6_;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp8_ = _tmp7_;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp10_ = _tmp9_;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_tmp8_);
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_k_it = _tmp10_;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		while (TRUE) {
#line 2137 "backend.c"
			GeeIterator* _tmp11_;
			gboolean _tmp12_;
			gchar* k;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp11_ = _k_it;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp12_ = gee_iterator_next (_tmp11_);
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			if (!_tmp12_) {
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				break;
#line 2156 "backend.c"
			}
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp13_ = _k_it;
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			k = (gchar*) _tmp14_;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp16_ = k;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp17_ = strlen (_tmp16_);
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp18_ = _tmp17_;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp19_ = min_len;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			if (_tmp18_ > _tmp19_) {
#line 2174 "backend.c"
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp20_ = k;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp21_ = min_len;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp22_ = string_slice (_tmp20_, (glong) 0, (glong) _tmp21_);
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp23_ = _tmp22_;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp24_ = contact_field_name;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp23_);
#line 2194 "backend.c"
			} else {
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp15_ = FALSE;
#line 2198 "backend.c"
			}
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			if (_tmp15_) {
#line 2202 "backend.c"
				gchar* v;
				GeeHashMap* _tmp25_;
				const gchar* _tmp26_;
				gpointer _tmp27_;
				GValue* _tmp28_;
				GValue _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_;
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp25_ = c;
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp26_ = k;
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp28_ = (GValue*) _tmp27_;
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp29_ = *_tmp28_;
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp30_ = g_value_get_string (&_tmp29_);
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp31_ = g_strdup (_tmp30_);
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp32_ = _tmp31_;
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				__vala_GValue_free0 (_tmp28_);
#line 249 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				v = _tmp32_;
#line 250 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp33_ = k;
#line 250 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp34_ = string_index_of (_tmp33_, "family", 0);
#line 250 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				if (_tmp34_ >= 0) {
#line 2240 "backend.c"
					EContactName* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
#line 252 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp35_ = contact_name;
#line 252 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp36_ = v;
#line 252 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp37_ = g_strdup (_tmp36_);
#line 252 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_g_free0 (_tmp35_->family);
#line 252 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp35_->family = _tmp37_;
#line 2254 "backend.c"
				} else {
					const gchar* _tmp38_;
					gint _tmp39_;
#line 254 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp38_ = k;
#line 254 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp39_ = string_index_of (_tmp38_, "given", 0);
#line 254 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					if (_tmp39_ >= 0) {
#line 2264 "backend.c"
						EContactName* _tmp40_;
						const gchar* _tmp41_;
						gchar* _tmp42_;
#line 256 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp40_ = contact_name;
#line 256 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp41_ = v;
#line 256 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp42_ = g_strdup (_tmp41_);
#line 256 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (_tmp40_->given);
#line 256 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp40_->given = _tmp42_;
#line 2278 "backend.c"
					} else {
						const gchar* _tmp43_;
						gint _tmp44_;
#line 258 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp43_ = k;
#line 258 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp44_ = string_index_of (_tmp43_, "additional", 0);
#line 258 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						if (_tmp44_ >= 0) {
#line 2288 "backend.c"
							EContactName* _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_;
#line 260 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp45_ = contact_name;
#line 260 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp46_ = v;
#line 260 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp47_ = g_strdup (_tmp46_);
#line 260 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_g_free0 (_tmp45_->additional);
#line 260 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp45_->additional = _tmp47_;
#line 2302 "backend.c"
						} else {
							const gchar* _tmp48_;
							gint _tmp49_;
#line 262 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp48_ = k;
#line 262 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp49_ = string_index_of (_tmp48_, "prefixes", 0);
#line 262 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							if (_tmp49_ >= 0) {
#line 2312 "backend.c"
								EContactName* _tmp50_;
								const gchar* _tmp51_;
								gchar* _tmp52_;
#line 264 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp50_ = contact_name;
#line 264 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp51_ = v;
#line 264 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp52_ = g_strdup (_tmp51_);
#line 264 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp50_->prefixes);
#line 264 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp50_->prefixes = _tmp52_;
#line 2326 "backend.c"
							} else {
								const gchar* _tmp53_;
								gint _tmp54_;
#line 266 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp53_ = k;
#line 266 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp54_ = string_index_of (_tmp53_, "suffixes", 0);
#line 266 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								if (_tmp54_ >= 0) {
#line 2336 "backend.c"
									EContactName* _tmp55_;
									const gchar* _tmp56_;
									gchar* _tmp57_;
#line 268 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp55_ = contact_name;
#line 268 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp56_ = v;
#line 268 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp57_ = g_strdup (_tmp56_);
#line 268 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (_tmp55_->suffixes);
#line 268 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp55_->suffixes = _tmp57_;
#line 2350 "backend.c"
								}
							}
						}
					}
				}
#line 271 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				added_contact_name = TRUE;
#line 247 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (v);
#line 2360 "backend.c"
			} else {
				const gchar* _tmp58_;
#line 273 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp58_ = k;
#line 273 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				if (g_strcmp0 (_tmp58_, "avatar") == 0) {
#line 2367 "backend.c"
					gchar* v;
					GeeHashMap* _tmp59_;
					const gchar* _tmp60_;
					gpointer _tmp61_;
					GValue* _tmp62_;
					GValue _tmp63_;
					const gchar* _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					guint8* photo_content = NULL;
					gint photo_content_length1 = 0;
					gint _photo_content_size_ = 0;
					GFile* file;
					const gchar* _tmp67_;
					GFile* _tmp68_;
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp59_ = c;
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp60_ = k;
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, _tmp60_);
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp62_ = (GValue*) _tmp61_;
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp63_ = *_tmp62_;
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp64_ = g_value_get_string (&_tmp63_);
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp65_ = g_strdup (_tmp64_);
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp66_ = _tmp65_;
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					__vala_GValue_free0 (_tmp62_);
#line 275 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					v = _tmp66_;
#line 277 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp67_ = v;
#line 277 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp68_ = g_file_new_for_path (_tmp67_);
#line 277 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					file = _tmp68_;
#line 2409 "backend.c"
					{
						GFile* _tmp69_;
						guint8* _tmp70_ = NULL;
						gsize _tmp71_;
						EContactPhoto* cp;
						EContactPhoto* _tmp72_;
						EContactPhoto* _tmp73_;
						EContactPhoto* _tmp74_;
						guint8* _tmp75_;
						gint _tmp75__length1;
						EContact* _tmp76_;
						EContactField _tmp77_;
						EContactPhoto* _tmp78_;
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp69_ = file;
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						g_file_load_contents (_tmp69_, NULL, &_tmp70_, &_tmp71_, NULL, &_inner_error_);
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						photo_content = _tmp70_;
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						photo_content_length1 = _tmp71_;
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_photo_content_size_ = photo_content_length1;
#line 281 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2437 "backend.c"
							goto __catch5_g_error;
						}
#line 283 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp72_ = e_contact_photo_new ();
#line 283 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						cp = _tmp72_;
#line 284 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp73_ = cp;
#line 284 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp73_->type = E_CONTACT_PHOTO_TYPE_INLINED;
#line 285 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp74_ = cp;
#line 285 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp75_ = photo_content;
#line 285 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp75__length1 = photo_content_length1;
#line 285 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						e_contact_photo_set_inlined (_tmp74_, _tmp75_, (gsize) _tmp75__length1);
#line 287 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp76_ = contact;
#line 287 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp77_ = e_contact_field_id ("photo");
#line 287 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp78_ = cp;
#line 287 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						e_contact_set (_tmp76_, _tmp77_, _tmp78_);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						__vala_EContactPhoto_free0 (cp);
#line 2466 "backend.c"
					}
					goto __finally5;
					__catch5_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp79_;
						GError* _tmp80_;
						const gchar* _tmp81_;
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						e = _inner_error_;
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_inner_error_ = NULL;
#line 291 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp79_ = v;
#line 291 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp80_ = e;
#line 291 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp81_ = _tmp80_->message;
#line 291 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						g_warning ("backend.vala:291: \n\nCan't load avatar %s: %s\n\n", _tmp79_, _tmp81_);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_error_free0 (e);
#line 2489 "backend.c"
					}
					__finally5:
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (file);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						photo_content = (g_free (photo_content), NULL);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (k);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_object_unref0 (_k_it);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (contact_field_name);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						__vala_EContactName_free0 (contact_name);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						g_clear_error (&_inner_error_);
#line 279 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						return;
#line 2514 "backend.c"
					}
#line 273 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_g_object_unref0 (file);
#line 273 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					photo_content = (g_free (photo_content), NULL);
#line 273 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_g_free0 (v);
#line 2522 "backend.c"
				} else {
					const gchar* _tmp82_;
#line 295 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					_tmp82_ = k;
#line 295 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
					if (g_strcmp0 (_tmp82_, "email_addresses") == 0) {
#line 2529 "backend.c"
						gchar* v;
						GeeHashMap* _tmp83_;
						const gchar* _tmp84_;
						gpointer _tmp85_;
						GValue* _tmp86_;
						GValue _tmp87_;
						const gchar* _tmp88_;
						gchar* _tmp89_;
						gchar* _tmp90_;
						gchar** addresses;
						const gchar* _tmp91_;
						gchar** _tmp92_;
						gchar** _tmp93_;
						gint addresses_length1;
						gint _addresses_size_;
						gchar** _tmp94_;
						gint _tmp94__length1;
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp83_ = c;
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp84_ = k;
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp85_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp83_, _tmp84_);
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp86_ = (GValue*) _tmp85_;
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp87_ = *_tmp86_;
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp88_ = g_value_get_string (&_tmp87_);
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp89_ = g_strdup (_tmp88_);
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp90_ = _tmp89_;
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						__vala_GValue_free0 (_tmp86_);
#line 297 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						v = _tmp90_;
#line 298 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp91_ = v;
#line 298 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp93_ = _tmp92_ = g_strsplit (_tmp91_, ",", 0);
#line 298 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						addresses = _tmp93_;
#line 298 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						addresses_length1 = _vala_array_length (_tmp92_);
#line 298 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_addresses_size_ = addresses_length1;
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp94_ = addresses;
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp94__length1 = addresses_length1;
#line 2581 "backend.c"
						{
							gchar** addr_collection = NULL;
							gint addr_collection_length1 = 0;
							gint _addr_collection_size_ = 0;
							gint addr_it = 0;
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							addr_collection = _tmp94_;
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							addr_collection_length1 = _tmp94__length1;
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							for (addr_it = 0; addr_it < _tmp94__length1; addr_it = addr_it + 1) {
#line 2593 "backend.c"
								gchar* _tmp95_;
								gchar* addr = NULL;
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp95_ = g_strdup (addr_collection[addr_it]);
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								addr = _tmp95_;
#line 2600 "backend.c"
								{
									EContact* _tmp96_;
									EContactField _tmp97_;
									const gchar* _tmp98_;
#line 302 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp96_ = contact;
#line 302 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp97_ = e_contact_field_id ("email");
#line 302 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp98_ = addr;
#line 302 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp96_, _tmp97_, _tmp98_);
#line 300 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2615 "backend.c"
								}
							}
						}
#line 295 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						addresses = (_vala_array_free (addresses, addresses_length1, (GDestroyNotify) g_free), NULL);
#line 295 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_g_free0 (v);
#line 2623 "backend.c"
					} else {
						const gchar* _tmp99_;
#line 305 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						_tmp99_ = k;
#line 305 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
						if (g_strcmp0 (_tmp99_, "im_addresses") == 0) {
#line 2630 "backend.c"
							gchar* v;
							GeeHashMap* _tmp100_;
							const gchar* _tmp101_;
							gpointer _tmp102_;
							GValue* _tmp103_;
							GValue _tmp104_;
							const gchar* _tmp105_;
							gchar* _tmp106_;
							gchar* _tmp107_;
							GeeHashMap* addresses;
							const gchar* _tmp108_;
							GeeHashMap* _tmp109_;
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp100_ = c;
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp101_ = k;
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp102_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp100_, _tmp101_);
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp103_ = (GValue*) _tmp102_;
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp104_ = *_tmp103_;
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp105_ = g_value_get_string (&_tmp104_);
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp106_ = g_strdup (_tmp105_);
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp107_ = _tmp106_;
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							__vala_GValue_free0 (_tmp103_);
#line 307 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							v = _tmp107_;
#line 308 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp108_ = v;
#line 308 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp109_ = _eds_test_backend_parse_im_addrs (self, _tmp108_);
#line 308 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							addresses = _tmp109_;
#line 2669 "backend.c"
							{
								GeeIterator* _addr_it;
								GeeHashMap* _tmp110_;
								GeeSet* _tmp111_;
								GeeSet* _tmp112_;
								GeeSet* _tmp113_;
								GeeIterator* _tmp114_;
								GeeIterator* _tmp115_;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp110_ = addresses;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp111_ = gee_abstract_map_get_keys ((GeeMap*) _tmp110_);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp112_ = _tmp111_;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp113_ = _tmp112_;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp114_ = gee_iterable_iterator ((GeeIterable*) _tmp113_);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp115_ = _tmp114_;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_tmp113_);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_addr_it = _tmp115_;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								while (TRUE) {
#line 2696 "backend.c"
									GeeIterator* _tmp116_;
									gboolean _tmp117_;
									gchar* addr;
									GeeIterator* _tmp118_;
									gpointer _tmp119_;
									gchar* proto;
									GeeHashMap* _tmp120_;
									const gchar* _tmp121_;
									gpointer _tmp122_;
									EContact* _tmp123_;
									const gchar* _tmp124_;
									EContactField _tmp125_;
									const gchar* _tmp126_;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp116_ = _addr_it;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp117_ = gee_iterator_next (_tmp116_);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									if (!_tmp117_) {
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
										break;
#line 2718 "backend.c"
									}
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp118_ = _addr_it;
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp119_ = gee_iterator_get (_tmp118_);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									addr = (gchar*) _tmp119_;
#line 311 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp120_ = addresses;
#line 311 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp121_ = addr;
#line 311 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp122_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp120_, _tmp121_);
#line 311 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									proto = (gchar*) _tmp122_;
#line 312 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp123_ = contact;
#line 312 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp124_ = proto;
#line 312 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp125_ = e_contact_field_id (_tmp124_);
#line 312 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp126_ = addr;
#line 312 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp123_, _tmp125_, _tmp126_);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (proto);
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_g_free0 (addr);
#line 2748 "backend.c"
								}
#line 309 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (_addr_it);
#line 2752 "backend.c"
							}
#line 305 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_g_object_unref0 (addresses);
#line 305 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_g_free0 (v);
#line 2758 "backend.c"
						} else {
							const gchar* _tmp127_;
							const gchar* _tmp128_;
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp127_ = k;
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							_tmp128_ = EDSF_PERSONA_address_fields[0];
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
							if (g_strcmp0 (_tmp127_, _tmp128_) == 0) {
#line 2768 "backend.c"
								FolksPostalAddressFieldDetails* pa_fd;
								GeeHashMap* _tmp129_;
								const gchar* _tmp130_;
								gpointer _tmp131_;
								GValue* _tmp132_;
								GValue _tmp133_;
								GObject* _tmp134_;
								FolksPostalAddressFieldDetails* _tmp135_;
								FolksPostalAddressFieldDetails* _tmp136_;
								FolksPostalAddress* pa;
								FolksPostalAddressFieldDetails* _tmp137_;
								gconstpointer _tmp138_;
								FolksPostalAddress* _tmp139_;
								FolksPostalAddress* _tmp140_;
								EContactAddress* address;
								EContactAddress* _tmp141_;
								EContactAddress* _tmp142_;
								FolksPostalAddress* _tmp143_;
								const gchar* _tmp144_;
								const gchar* _tmp145_;
								gchar* _tmp146_;
								EContactAddress* _tmp147_;
								FolksPostalAddress* _tmp148_;
								const gchar* _tmp149_;
								const gchar* _tmp150_;
								gchar* _tmp151_;
								EContactAddress* _tmp152_;
								FolksPostalAddress* _tmp153_;
								const gchar* _tmp154_;
								const gchar* _tmp155_;
								gchar* _tmp156_;
								EContactAddress* _tmp157_;
								FolksPostalAddress* _tmp158_;
								const gchar* _tmp159_;
								const gchar* _tmp160_;
								gchar* _tmp161_;
								EContactAddress* _tmp162_;
								FolksPostalAddress* _tmp163_;
								const gchar* _tmp164_;
								const gchar* _tmp165_;
								gchar* _tmp166_;
								EContactAddress* _tmp167_;
								FolksPostalAddress* _tmp168_;
								const gchar* _tmp169_;
								const gchar* _tmp170_;
								gchar* _tmp171_;
								EContactAddress* _tmp172_;
								FolksPostalAddress* _tmp173_;
								const gchar* _tmp174_;
								const gchar* _tmp175_;
								gchar* _tmp176_;
								EContactAddress* _tmp177_;
								FolksPostalAddress* _tmp178_;
								const gchar* _tmp179_;
								const gchar* _tmp180_;
								gchar* _tmp181_;
								EContact* _tmp182_;
								const gchar* _tmp183_;
								EContactField _tmp184_;
								EContactAddress* _tmp185_;
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp129_ = c;
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp130_ = k;
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp131_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp129_, _tmp130_);
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp132_ = (GValue*) _tmp131_;
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp133_ = *_tmp132_;
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp134_ = g_value_get_object (&_tmp133_);
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp135_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, FOLKS_TYPE_POSTAL_ADDRESS_FIELD_DETAILS, FolksPostalAddressFieldDetails));
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp136_ = _tmp135_;
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp132_);
#line 317 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								pa_fd = _tmp136_;
#line 318 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp137_ = pa_fd;
#line 318 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp138_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp137_);
#line 318 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp139_ = _tmp138_;
#line 318 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp140_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((FolksPostalAddress*) _tmp139_, FOLKS_TYPE_POSTAL_ADDRESS, FolksPostalAddress));
#line 318 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								pa = _tmp140_;
#line 319 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp141_ = e_contact_address_new ();
#line 319 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								address = _tmp141_;
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp142_ = address;
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp143_ = pa;
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp144_ = folks_postal_address_get_po_box (_tmp143_);
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp145_ = _tmp144_;
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp146_ = g_strdup (_tmp145_);
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp142_->po);
#line 320 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp142_->po = _tmp146_;
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp147_ = address;
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp148_ = pa;
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp149_ = folks_postal_address_get_extension (_tmp148_);
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp150_ = _tmp149_;
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp151_ = g_strdup (_tmp150_);
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp147_->ext);
#line 321 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp147_->ext = _tmp151_;
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp152_ = address;
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp153_ = pa;
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp154_ = folks_postal_address_get_street (_tmp153_);
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp155_ = _tmp154_;
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp156_ = g_strdup (_tmp155_);
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp152_->street);
#line 322 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp152_->street = _tmp156_;
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp157_ = address;
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp158_ = pa;
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp159_ = folks_postal_address_get_locality (_tmp158_);
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp160_ = _tmp159_;
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp161_ = g_strdup (_tmp160_);
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp157_->locality);
#line 323 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp157_->locality = _tmp161_;
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp162_ = address;
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp163_ = pa;
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp164_ = folks_postal_address_get_region (_tmp163_);
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp165_ = _tmp164_;
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp166_ = g_strdup (_tmp165_);
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp162_->region);
#line 324 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp162_->region = _tmp166_;
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp167_ = address;
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp168_ = pa;
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp169_ = folks_postal_address_get_postal_code (_tmp168_);
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp170_ = _tmp169_;
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp171_ = g_strdup (_tmp170_);
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp167_->code);
#line 325 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp167_->code = _tmp171_;
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp172_ = address;
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp173_ = pa;
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp174_ = folks_postal_address_get_country (_tmp173_);
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp175_ = _tmp174_;
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp176_ = g_strdup (_tmp175_);
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp172_->country);
#line 326 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp172_->country = _tmp176_;
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp177_ = address;
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp178_ = pa;
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp179_ = folks_postal_address_get_address_format (_tmp178_);
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp180_ = _tmp179_;
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp181_ = g_strdup (_tmp180_);
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (_tmp177_->address_format);
#line 327 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp177_->address_format = _tmp181_;
#line 329 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp182_ = contact;
#line 329 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp183_ = k;
#line 329 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp184_ = e_contact_field_id (_tmp183_);
#line 329 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp185_ = address;
#line 329 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								e_contact_set (_tmp182_, _tmp184_, _tmp185_);
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								__vala_EContactAddress_free0 (address);
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa);
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_object_unref0 (pa_fd);
#line 2991 "backend.c"
							} else {
								EContactField field_id;
								const gchar* _tmp186_;
								EContactField _tmp187_;
								gchar* v;
								GeeHashMap* _tmp188_;
								const gchar* _tmp189_;
								gpointer _tmp190_;
								GValue* _tmp191_;
								GValue _tmp192_;
								const gchar* _tmp193_;
								gchar* _tmp194_;
								gchar* _tmp195_;
								EContactField _tmp196_;
#line 333 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp186_ = k;
#line 333 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp187_ = e_contact_field_id (_tmp186_);
#line 333 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								field_id = _tmp187_;
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp188_ = c;
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp189_ = k;
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp190_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp188_, _tmp189_);
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp191_ = (GValue*) _tmp190_;
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp192_ = *_tmp191_;
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp193_ = g_value_get_string (&_tmp192_);
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp194_ = g_strdup (_tmp193_);
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp195_ = _tmp194_;
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								__vala_GValue_free0 (_tmp191_);
#line 334 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								v = _tmp195_;
#line 336 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_tmp196_ = field_id;
#line 336 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								if (_tmp196_ != 0) {
#line 3036 "backend.c"
									EContact* _tmp197_;
									EContactField _tmp198_;
									const gchar* _tmp199_;
#line 338 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp197_ = contact;
#line 338 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp198_ = field_id;
#line 338 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp199_ = v;
#line 338 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									e_contact_set (_tmp197_, _tmp198_, _tmp199_);
#line 3048 "backend.c"
								} else {
									EVCard* vcard;
									EContact* _tmp200_;
									EVCard* _tmp201_;
									EVCardAttribute* attr;
									const gchar* _tmp202_;
									EVCardAttribute* _tmp203_;
									EVCard* _tmp204_;
									EVCardAttribute* _tmp205_;
									EVCardAttribute* _tmp206_;
									const gchar* _tmp207_;
#line 342 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp200_ = contact;
#line 342 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp201_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, e_vcard_get_type (), EVCard));
#line 342 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									vcard = _tmp201_;
#line 343 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp202_ = k;
#line 343 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp203_ = e_vcard_attribute_new (NULL, _tmp202_);
#line 343 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									attr = _tmp203_;
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp204_ = vcard;
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp205_ = attr;
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp206_ = __vala_EVCardAttribute_copy0 (_tmp205_);
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_tmp207_ = v;
#line 344 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									e_vcard_append_attribute_with_value (_tmp204_, _tmp206_, _tmp207_);
#line 336 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									__vala_EVCardAttribute_free0 (attr);
#line 336 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
									_g_object_unref0 (vcard);
#line 3086 "backend.c"
								}
#line 315 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
								_g_free0 (v);
#line 3090 "backend.c"
							}
						}
					}
				}
			}
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_g_free0 (k);
#line 3098 "backend.c"
		}
#line 245 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (_k_it);
#line 3102 "backend.c"
	}
#line 348 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp208_ = added_contact_name;
#line 348 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (_tmp208_) {
#line 3108 "backend.c"
		EContact* _tmp209_;
		EContactField _tmp210_;
		EContactName* _tmp211_;
#line 350 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp209_ = contact;
#line 350 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp210_ = e_contact_field_id ("name");
#line 350 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp211_ = contact_name;
#line 350 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e_contact_set (_tmp209_, _tmp210_, _tmp211_);
#line 3120 "backend.c"
	}
#line 237 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (contact_field_name);
#line 237 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__vala_EContactName_free0 (contact_name);
#line 3126 "backend.c"
}


void eds_test_backend_tear_down (EdsTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 354 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (self != NULL);
#line 356 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_setenv ("FOLKS_BACKEND_EDS_USE_ADDRESS_BOOKS", "", TRUE);
#line 3136 "backend.c"
	{
		GFile* _tmp0_;
#line 361 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp0_ = self->priv->_source_file;
#line 361 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (_tmp0_ != NULL) {
#line 3143 "backend.c"
			const gchar* _tmp1_;
			GFile* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			GFile* _tmp5_;
#line 363 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp1_ = self->priv->_addressbook_name;
#line 363 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp2_ = self->priv->_source_file;
#line 363 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp3_ = g_file_get_path (_tmp2_);
#line 363 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp4_ = _tmp3_;
#line 363 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			g_debug ("backend.vala:363: Deleting address book ‘%s’ source file ‘%s’.", _tmp1_, _tmp4_);
#line 363 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_g_free0 (_tmp4_);
#line 365 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp5_ = self->priv->_source_file;
#line 365 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			g_file_delete (_tmp5_, NULL, &_inner_error_);
#line 365 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3167 "backend.c"
				goto __catch6_g_error;
			}
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		e = _inner_error_;
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_inner_error_ = NULL;
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp6_ = self->priv->_addressbook_name;
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp7_ = self->priv->_source_file;
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp8_ = g_file_get_path (_tmp7_);
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp9_ = _tmp8_;
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_tmp10_ = e->message;
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_error ("backend.vala:370: Unable to remove address book ‘%s’ source file ‘%s’:" \
" %s", _tmp6_, _tmp9_, _tmp10_);
#line 370 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_free0 (_tmp9_);
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_error_free0 (e);
#line 3201 "backend.c"
	}
	__finally6:
	{
#line 375 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_file);
#line 375 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self->priv->_source_file = NULL;
#line 376 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source);
#line 376 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self->priv->_source = NULL;
#line 377 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_addressbook);
#line 377 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self->priv->_addressbook = NULL;
#line 378 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		_g_object_unref0 (self->priv->_source_registry);
#line 378 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		self->priv->_source_registry = NULL;
#line 3221 "backend.c"
	}
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_clear_error (&_inner_error_);
#line 359 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return;
#line 3231 "backend.c"
	}
}


static GeeHashMap* _eds_test_backend_parse_im_addrs (EdsTestBackend* self, const gchar* addr_str) {
	GeeHashMap* result = NULL;
	GeeHashMap* ret;
	GeeHashMap* _tmp0_;
	gchar** im_addrs;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint im_addrs_length1;
	gint _im_addrs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
#line 382 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 382 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (addr_str != NULL, NULL);
#line 384 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 384 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	ret = _tmp0_;
#line 385 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = addr_str;
#line 385 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ",", 0);
#line 385 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	im_addrs = _tmp3_;
#line 385 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	im_addrs_length1 = _vala_array_length (_tmp2_);
#line 385 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_im_addrs_size_ = im_addrs_length1;
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp4_ = im_addrs;
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp4__length1 = im_addrs_length1;
#line 3270 "backend.c"
	{
		gchar** a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		a_collection = _tmp4_;
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		a_collection_length1 = _tmp4__length1;
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		for (a_it = 0; a_it < _tmp4__length1; a_it = a_it + 1) {
#line 3282 "backend.c"
			gchar* _tmp5_;
			gchar* a = NULL;
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			_tmp5_ = g_strdup (a_collection[a_it]);
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			a = _tmp5_;
#line 3289 "backend.c"
			{
				gchar** info;
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				gint info_length1;
				gint _info_size_;
				gchar* proto;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* addr;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				GeeHashMap* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 389 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp6_ = a;
#line 389 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "#", 0);
#line 389 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				info = _tmp8_;
#line 389 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				info_length1 = _vala_array_length (_tmp7_);
#line 389 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_info_size_ = info_length1;
#line 390 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp9_ = info;
#line 390 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp9__length1 = info_length1;
#line 390 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp10_ = _tmp9_[0];
#line 390 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 390 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				proto = _tmp11_;
#line 391 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp12_ = info;
#line 391 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp12__length1 = info_length1;
#line 391 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp13_ = _tmp12_[1];
#line 391 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 391 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				addr = _tmp14_;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp15_ = ret;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp16_ = addr;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				addr = NULL;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp17_ = _tmp16_;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp18_ = proto;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				proto = NULL;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_tmp19_ = _tmp18_;
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp17_, _tmp19_);
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp19_);
#line 393 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (_tmp17_);
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (addr);
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (proto);
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				info = (_vala_array_free (info, info_length1, (GDestroyNotify) g_free), NULL);
#line 387 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
				_g_free0 (a);
#line 3370 "backend.c"
			}
		}
	}
#line 396 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	result = ret;
#line 396 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	im_addrs = (_vala_array_free (im_addrs, im_addrs_length1, (GDestroyNotify) g_free), NULL);
#line 396 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return result;
#line 3380 "backend.c"
}


const gchar* eds_test_backend_get_address_book_uid (EdsTestBackend* self) {
	const gchar* result;
	EBookClient* _tmp0_;
	ESource* _tmp1_;
	const gchar* _tmp2_;
#line 50 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp0_ = self->priv->_addressbook;
#line 50 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp1_ = e_client_get_source ((EClient*) _tmp0_);
#line 50 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_tmp2_ = e_source_get_uid (_tmp1_);
#line 50 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	result = _tmp2_;
#line 50 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return result;
#line 3401 "backend.c"
}


static void eds_test_value_backend_init (GValue* value) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	value->data[0].v_pointer = NULL;
#line 3408 "backend.c"
}


static void eds_test_value_backend_free_value (GValue* value) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (value->data[0].v_pointer) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (value->data[0].v_pointer);
#line 3417 "backend.c"
	}
}


static void eds_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = eds_test_backend_ref (src_value->data[0].v_pointer);
#line 3427 "backend.c"
	} else {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3431 "backend.c"
	}
}


static gpointer eds_test_value_backend_peek_pointer (const GValue* value) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3439 "backend.c"
}


static gchar* eds_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (collect_values[0].v_pointer) {
#line 3446 "backend.c"
		EdsTestBackend * object;
		object = collect_values[0].v_pointer;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3453 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3457 "backend.c"
		}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = eds_test_backend_ref (object);
#line 3461 "backend.c"
	} else {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3465 "backend.c"
	}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3469 "backend.c"
}


static gchar* eds_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EdsTestBackend ** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (!object_p) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3480 "backend.c"
	}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		*object_p = NULL;
#line 3486 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 3490 "backend.c"
	} else {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		*object_p = eds_test_backend_ref (value->data[0].v_pointer);
#line 3494 "backend.c"
	}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return NULL;
#line 3498 "backend.c"
}


GParamSpec* eds_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	EdsTestParamSpecBackend* spec;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return G_PARAM_SPEC (spec);
#line 3512 "backend.c"
}


gpointer eds_test_value_get_backend (const GValue* value) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND), NULL);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return value->data[0].v_pointer;
#line 3521 "backend.c"
}


void eds_test_value_set_backend (GValue* value, gpointer v_object) {
	EdsTestBackend * old;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_ref (value->data[0].v_pointer);
#line 3541 "backend.c"
	} else {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3545 "backend.c"
	}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3551 "backend.c"
	}
}


void eds_test_value_take_backend (GValue* value, gpointer v_object) {
	EdsTestBackend * old;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	old = value->data[0].v_pointer;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (v_object) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, EDS_TEST_TYPE_BACKEND));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = v_object;
#line 3570 "backend.c"
	} else {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		value->data[0].v_pointer = NULL;
#line 3574 "backend.c"
	}
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (old) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		eds_test_backend_unref (old);
#line 3580 "backend.c"
	}
}


static void eds_test_backend_class_init (EdsTestBackendClass * klass) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	eds_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	((EdsTestBackendClass *) klass)->finalize = eds_test_backend_finalize;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_type_class_add_private (klass, sizeof (EdsTestBackendPrivate));
#line 3592 "backend.c"
}


static void eds_test_backend_instance_init (EdsTestBackend * self) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv = EDS_TEST_BACKEND_GET_PRIVATE (self);
#line 41 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_addressbook = NULL;
#line 44 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source_registry = NULL;
#line 45 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source = NULL;
#line 46 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_source_file = NULL;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->ref_count = 1;
#line 3609 "backend.c"
}


static void eds_test_backend_finalize (EdsTestBackend * obj) {
	EdsTestBackend * self;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EDS_TEST_TYPE_BACKEND, EdsTestBackend);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_signal_handlers_destroy (self);
#line 40 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_free0 (self->priv->_addressbook_name);
#line 41 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_addressbook);
#line 42 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	self->priv->_e_contacts = (_vala_array_free (self->priv->_e_contacts, self->priv->_e_contacts_length1, (GDestroyNotify) g_free), NULL);
#line 43 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_contacts);
#line 44 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_registry);
#line 45 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source);
#line 46 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	_g_object_unref0 (self->priv->_source_file);
#line 3633 "backend.c"
}


GType eds_test_backend_get_type (void) {
	static volatile gsize eds_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&eds_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { eds_test_value_backend_init, eds_test_value_backend_free_value, eds_test_value_backend_copy_value, eds_test_value_backend_peek_pointer, "p", eds_test_value_backend_collect_value, "p", eds_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EdsTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) eds_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EdsTestBackend), 0, (GInstanceInitFunc) eds_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType eds_test_backend_type_id;
		eds_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EdsTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&eds_test_backend_type_id__volatile, eds_test_backend_type_id);
	}
	return eds_test_backend_type_id__volatile;
}


gpointer eds_test_backend_ref (gpointer instance) {
	EdsTestBackend * self;
	self = instance;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	return instance;
#line 3658 "backend.c"
}


void eds_test_backend_unref (gpointer instance) {
	EdsTestBackend * self;
	self = instance;
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		EDS_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 38 "/opt/gnome/source/folks/tests/lib/eds/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3671 "backend.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



