  std::cout << "#!/bin/sh" << std::endl;
  std::cout << "# to be used in gedit to indent fortran source" << std::endl;
  std::cout << "# in gedit:" << std::endl;
  std::cout << "#    Edit -> preferences -> enable \"External Tools\"" << std::endl;
  std::cout << "#    Tools -> Manage External Tools -> Add" << std::endl;
  std::cout << "#       - rename \"New Tool\" into findent" << std::endl;
  std::cout << "#       - put this file in the tool, or place a command" << std::endl;
  std::cout << "#          in the tool that starts this script" << std::endl;
  std::cout << "#       Shortcut Key:  <Alt>F1    (or something more to your liking)" << std::endl;
  std::cout << "#       Save:          Nothing" << std::endl;
  std::cout << "#       Input:         Current document" << std::endl;
  std::cout << "#       Output:        Replace current document" << std::endl;
  std::cout << "#       Applicability: All documents   Fortran 95" << std::endl;
  std::cout << "#       " << std::endl;
  std::cout << "flags=\"-Ia -i3\"              # flags for findent" << std::endl;
  std::cout << "fin=`mktemp`" << std::endl;
  std::cout << "fout=`mktemp`" << std::endl;
  std::cout << "trap \"rm $fin $fout\" 0        # remove temps on exit" << std::endl;
  std::cout << "restore()" << std::endl;
  std::cout << "{" << std::endl;
  std::cout << "   cat $fin" << std::endl;
  std::cout << "   if [ \"$lineadded\" = \"yes\" ] ; then" << std::endl;
  std::cout << "      echo \"empty line added\" >&2" << std::endl;
  std::cout << "   else" << std::endl;
  std::cout << "      echo \"nothing changed\" >&2" << std::endl;
  std::cout << "   fi" << std::endl;
  std::cout << "   exit" << std::endl;
  std::cout << "}" << std::endl;
  std::cout << "cat > $fin                    # copy input to $fin" << std::endl;
  std::cout << "# gedit version 2 has some troubles keeping stdout and " << std::endl;
  std::cout << "#  stderr separate when stdout does not end with newline." << std::endl;
  std::cout << "# add newline if input file does not end with newline:" << std::endl;
  std::cout << "lastchar=\"$(tail -c1 $fin | od -a -An | tr -d ' ')\"" << std::endl;
  std::cout << "if [ \"$lastchar\" != \"nl\" ] ; then" << std::endl;
  std::cout << "   echo >> $fin" << std::endl;
  std::cout << "   lineadded=yes" << std::endl;
  std::cout << "else" << std::endl;
  std::cout << "   lineadded=no" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "if [ \"$GEDIT_CURRENT_DOCUMENT_TYPE\" != \"text/x-fortran\" ]; then" << std::endl;
  std::cout << "   echo \"not a fortran file\" >&2" << std::endl;
  std::cout << "   restore" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "FINDENT=`which /bin/ls 2>/dev/null`" << std::endl;
  std::cout << "FINDENT=`which findent 2>/dev/null`" << std::endl;
  std::cout << "if [ -z \"$FINDENT\" ] ; then" << std::endl;
  std::cout << "   echo \"cannot find findent\" 1>&2" << std::endl;
  std::cout << "   restore" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "fname=\"$GEDIT_CURRENT_DOCUMENT_NAME\" # get the file name" << std::endl;
  std::cout << "# get suffix in lowercase:" << std::endl;
  std::cout << "suffix=`echo \"${fname##*.}\" | tr '[:upper:]' '[:lower:]'` " << std::endl;
  std::cout << "# determine input type (fflag) from suffix:" << std::endl;
  std::cout << "case \"$suffix\" in" << std::endl;
  std::cout << "   f|for|fpp|ftn|fortran|f77)" << std::endl;
  std::cout << "      fflag=\"-ifixed\"" << std::endl;
  std::cout << "      ;;" << std::endl;
  std::cout << "   f90|f95|f03|f08)" << std::endl;
  std::cout << "      fflag=\"-ifree\"" << std::endl;
  std::cout << "      ;;" << std::endl;
  std::cout << "   *)" << std::endl;
  std::cout << "      # let findent find out:" << std::endl;
  std::cout << "      fflag=\"\"" << std::endl;
  std::cout << "      ;;" << std::endl;
  std::cout << "esac" << std::endl;
  std::cout << "findentflags=\"$flags $fflag\"" << std::endl;
  std::cout << "# run findent:" << std::endl;
  std::cout << "$FINDENT $findentflags < $fin > $fout 2>/dev/null" << std::endl;
  std::cout << "if [ $? -ne 0 ] ; then" << std::endl;
  std::cout << "   echo \"findent reports error\" >&2" << std::endl;
  std::cout << "   echo \"using \\\"$FINDENT $findentflags\\\"\" >&2" << std::endl;
  std::cout << "   restore" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "# check if output has same number of lines as input:" << std::endl;
  std::cout << "win=`wc -l < $fin`" << std::endl;
  std::cout << "wout=`wc -l < $fout`" << std::endl;
  std::cout << "if [ \"$win\" != \"$wout\" ] ; then" << std::endl;
  std::cout << "   echo \"findent does not function properly\" >&2" << std::endl;
  std::cout << "   restore" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "# produce the result" << std::endl;
  std::cout << "echo $wout lines indented 1>&2" << std::endl;
  std::cout << "if [ \"$lineadded\" = \"yes\" ] ; then" << std::endl;
  std::cout << "   echo \"empty line added\" >&2" << std::endl;
  std::cout << "fi" << std::endl;
  std::cout << "cat $fout" << std::endl;
