/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file ab_vcard.c
 * \brief vcard address book plugin (kde)
 */

#include <ffgtk.h>
#include <addressbook.h>
#include <vcard.h>

/** VCard file name */
static char *pnVcardName = NULL;

/**
 * \brief Set vcard file name
 */
static void setVcardName( void ) {
	char *pnHomeDir;
	size_t nLen;

	if ( pnVcardName != NULL ) {
		return;
	}

	if ( ( pnHomeDir = getenv( "HOME" ) ) == NULL ) {
		return;
	}

	nLen = strlen( pnHomeDir ) + strlen( ".kde/share/apps/kabc/std.vcf" ) + 3;
	pnVcardName = g_malloc( nLen );
	if ( pnVcardName != NULL ) {
		snprintf( pnVcardName, nLen, "%s/%s", pnHomeDir, ".kde/share/apps/kabc/std.vcf" );
		if ( g_file_test( pnVcardName, G_FILE_TEST_EXISTS ) == FALSE ) {
			snprintf( pnVcardName, nLen, "%s/%s", pnHomeDir, ".kde4/share/apps/kabc/std.vcf" );
 		}
	}
}

/**
 * \brief Read address book
 * \return error code
 */
static int vcardReadBook( void ) {
	if ( pnVcardName == NULL ) {
		setVcardName();
	}

	if ( pnVcardName != NULL ) {
		loadCardFile( pnVcardName );
	}

	return 0;
}

/**
 * \brief Write address book
 * \return error code
 */
static int vcardWriteBook( void ) {
	if ( pnVcardName == NULL ) {
		setVcardName();
	}

	if ( pnVcardName != NULL ) {
		writeCardFile( pnVcardName );
	}

	return 0;
}

/** book definition */
struct sAddressBook sVcard = {
	vcardReadBook,
	vcardWriteBook,
	PERSON_FIRST_NAME | PERSON_LAST_NAME | PERSON_DISPLAY_NAME | PERSON_COMPANY |
	PERSON_TITLE | PERSON_IMAGE | PERSON_PRIVATE_PHONE | PERSON_PRIVATE_MOBILE |
	PERSON_PRIVATE_FAX | PERSON_PRIVATE_STREET | PERSON_PRIVATE_CITY |
	PERSON_PRIVATE_ZIPCODE | PERSON_PRIVATE_COUNTRY | PERSON_BUSINESS_PHONE |
	PERSON_BUSINESS_FAX | PERSON_BUSINESS_STREET | PERSON_BUSINESS_CITY |
	PERSON_BUSINESS_ZIPCODE | PERSON_BUSINESS_COUNTRY,
	PERSON_FIRST_NAME | PERSON_LAST_NAME | PERSON_DISPLAY_NAME | PERSON_COMPANY |
	PERSON_TITLE | PERSON_IMAGE | PERSON_PRIVATE_PHONE | PERSON_PRIVATE_MOBILE |
	PERSON_PRIVATE_FAX | PERSON_PRIVATE_STREET | PERSON_PRIVATE_CITY |
	PERSON_PRIVATE_ZIPCODE | PERSON_PRIVATE_COUNTRY | PERSON_BUSINESS_PHONE |
	PERSON_BUSINESS_FAX | PERSON_BUSINESS_STREET | PERSON_BUSINESS_CITY |
	PERSON_BUSINESS_ZIPCODE | PERSON_BUSINESS_COUNTRY,
	NULL
};

MODULE_INIT( PLUGIN_TYPE_BOOK, _( "VCard (KDE)" ), &sVcard, NULL, NULL );
