/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dt.fmr.FmrcCoordSys;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public abstract class GridServiceProvider
extends AbstractIOServiceProvider {
    protected static IndexExtendMode indexFileModeOnOpen = IndexExtendMode.rewrite;
    protected static IndexExtendMode indexFileModeOnSync = IndexExtendMode.extendwrite;
    protected static boolean addLatLon = false;
    protected static boolean useMaximalCoordSys = false;
    protected static boolean forceNewIndex = false;
    protected static boolean alwaysInCache = false;
    protected static boolean debugOpen = false;
    protected static boolean debugMissing = false;
    protected static boolean debugMissingDetails = false;
    protected static boolean debugProj = false;
    protected static boolean debugTiming = false;
    protected static boolean debugVert = false;
    protected FmrcCoordSys fmrcCoordSys;
    protected NetcdfFile ncfile;
    protected RandomAccessFile raf;
    protected StringBuilder parseInfo = new StringBuilder();

    public static void useMaximalCoordSys(boolean b) {
        useMaximalCoordSys = b;
    }

    public static void forceNewIndex(boolean b) {
        forceNewIndex = b;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("Grid/open");
        debugMissing = debugFlag.isSet("Grid/missing");
        debugMissingDetails = debugFlag.isSet("Grid/missingDetails");
        debugProj = debugFlag.isSet("Grid/projection");
        debugVert = debugFlag.isSet("Grid/vertical");
        debugTiming = debugFlag.isSet("Grid/timing");
    }

    public static void setIndexFileModeOnOpen(IndexExtendMode mode) {
        indexFileModeOnOpen = mode;
    }

    public static void setIndexFileModeOnSync(IndexExtendMode mode) {
        indexFileModeOnSync = mode;
    }

    public static void setExtendIndex(boolean b) {
        indexFileModeOnOpen = b ? IndexExtendMode.extendwrite : IndexExtendMode.readonly;
        indexFileModeOnSync = b ? IndexExtendMode.extendwrite : IndexExtendMode.readonly;
    }

    public static void setIndexAlwaysInCache(boolean b) {
        alwaysInCache = b;
    }

    protected abstract void open(GridIndex var1, CancelTask var2) throws IOException;

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public String getDetailInfo() {
        return this.parseInfo.toString();
    }

    public Object sendIospMessage(Object special) {
        if (special instanceof FmrcCoordSys) {
            this.fmrcCoordSys = (FmrcCoordSys)special;
        }
        return null;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array dataArray = Array.factory(DataType.FLOAT, section.getShape());
        GridVariable pv = (GridVariable)v2.getSPobject();
        int count = 0;
        Range timeRange = new Range(0, 0);
        if (section.getRank() > 2) {
            timeRange = section.getRange(count++);
        }
        Range ensRange = pv.hasEnsemble() ? section.getRange(count++) : null;
        Range levRange = pv.hasVert() ? section.getRange(count++) : null;
        Range yRange = section.getRange(count++);
        Range xRange = section.getRange(count);
        IndexIterator ii = dataArray.getIndexIterator();
        for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
            if (pv.hasEnsemble()) {
                this.readEnsemble(v2, timeIdx, ensRange, levRange, yRange, xRange, ii);
                continue;
            }
            if (pv.hasVert()) {
                this.readLevel(v2, timeIdx, levRange, yRange, xRange, ii);
                continue;
            }
            this.readXY(v2, timeIdx, 0, 0, yRange, xRange, ii);
        }
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println("  read data took=" + took + " msec ");
        }
        return dataArray;
    }

    private void readEnsemble(Variable v2, int timeIdx, Range ensRange, Range levRange, Range yRange, Range xRange, IndexIterator ii) throws IOException, InvalidRangeException {
        for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
            if (levRange != null) {
                for (int levIdx = levRange.first(); levIdx <= levRange.last(); levIdx += levRange.stride()) {
                    this.readXY(v2, timeIdx, ensIdx, levIdx, yRange, xRange, ii);
                }
                continue;
            }
            this.readXY(v2, timeIdx, ensIdx, 0, yRange, xRange, ii);
        }
    }

    private void readLevel(Variable v2, int timeIdx, Range levelRange, Range yRange, Range xRange, IndexIterator ii) throws IOException, InvalidRangeException {
        for (int levIdx = levelRange.first(); levIdx <= levelRange.last(); levIdx += levelRange.stride()) {
            this.readXY(v2, timeIdx, 0, levIdx, yRange, xRange, ii);
        }
    }

    private void readXY(Variable v2, int timeIdx, int ensIdx, int levIdx, Range yRange, Range xRange, IndexIterator ii) throws IOException, InvalidRangeException {
        Attribute att = v2.findAttribute("missing_value");
        float missing_value = att == null ? -9999.0f : att.getNumericValue().floatValue();
        GridVariable pv = (GridVariable)v2.getSPobject();
        GridHorizCoordSys hsys = pv.getHorizCoordSys();
        int nx = hsys.getNx();
        GridRecord record = pv.findRecord(timeIdx, ensIdx, levIdx);
        if (record == null) {
            int xyCount = yRange.length() * xRange.length();
            for (int j = 0; j < xyCount; ++j) {
                ii.setFloatNext(missing_value);
            }
            return;
        }
        float[] data = this._readData(record);
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                int index = y * nx + x;
                ii.setFloatNext(data[index]);
            }
        }
    }

    public boolean isMissingXY(Variable v2, int timeIdx, int ensIdx, int levIdx) throws InvalidRangeException {
        GridVariable pv = (GridVariable)v2.getSPobject();
        if (null == pv) {
            System.out.println("HEY");
        }
        if (timeIdx < 0 || timeIdx >= pv.getNTimes()) {
            throw new InvalidRangeException("timeIdx=" + timeIdx);
        }
        if (levIdx < 0 || levIdx >= pv.getVertNlevels()) {
            throw new InvalidRangeException("levIdx=" + levIdx);
        }
        if (ensIdx < 0 || ensIdx >= pv.getNEnsembles()) {
            throw new InvalidRangeException("ensIdx=" + ensIdx);
        }
        return null == pv.findRecord(timeIdx, ensIdx, levIdx);
    }

    public int[] ensembleInfo(Variable v2) {
        GridVariable pv = (GridVariable)v2.getSPobject();
        int ensembles = pv.getNEnsembles();
        int[] ensInfo = new int[ensembles + 2];
        ensInfo[0] = ensembles;
        ensInfo[1] = pv.getPDN();
        System.arraycopy(pv.getEnsTypes(), 0, ensInfo, 2, ensembles);
        return ensInfo;
    }

    protected abstract float[] _readData(GridRecord var1) throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexExtendMode {
        rewrite,
        extendwrite,
        readonly;

    }
}

