#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("disables speech until next keypress")

    def run(self):
        if not self.env["commandBuffer"]["enableSpeechOnKeypress"]:
            return
        self.env["runtime"]["SettingsManager"].set_setting(
            "speech",
            "enabled",
            str(self.env["commandBuffer"]["enableSpeechOnKeypress"]),
        )
        self.env["commandBuffer"]["enableSpeechOnKeypress"] = False
        # Also disable prompt watching since speech was manually re-enabled
        if "silenceUntilPrompt" in self.env["commandBuffer"]:
            self.env["commandBuffer"]["silenceUntilPrompt"] = False
        self.env["runtime"]["OutputManager"].present_text(
            _("speech enabled"), sound_icon="SpeechOn", interrupt=True
        )

    def set_callback(self, callback):
        pass
