/* $Id: pci.h,v 1.26 2010-12-18 08:05:36 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __PCI_H_INCLUDED
#define __PCI_H_INCLUDED

#include "build_config.h"

#include "io.h"

#define PCI_VENDOR_ID			0x00	/* 16 Bits */
#define PCI_DEVICE_ID			0x02	/* 16 Bits */
#define PCI_COMMAND			0x04	/* 16 Bits */
#define PCI_STATUS			0x06	/* 16 Bits */
#define PCI_REVISION_ID			0x08	/* 8 Bits */
#define PCI_CLASS_CODE			0x09	/* 24 Bits */
#define PCI_CACHE_LINE_SIZE		0x0c	/* 8 Bits */
#define PCI_LATENCY_TIMER		0x0d	/* 8 Bits */
#define PCI_HEADER_TYPE			0x0e	/* 8 Bits */
#define PCI_BIST			0x0f	/* 8 Bits */
#define PCI_BASE_ADDRESS_0		0x10	/* 32 Bits */
#define PCI_BASE_ADDRESS_1		0x14	/* 32 Bits */
#define PCI_BASE_ADDRESS_2		0x18	/* 32 Bits */
#define PCI_BASE_ADDRESS_3		0x1c	/* 32 Bits */
#define PCI_BASE_ADDRESS_4		0x20	/* 32 Bits */
#define PCI_BASE_ADDRESS_5		0x24	/* 32 Bits */
#define PCI_CARDBUS_CIS_POINTER		0x28	/* 32 Bits */
#define PCI_SUBSYSTEM_VENDOR_ID		0x2c	/* 16 Bits */
#define PCI_SUBSYSTEM_ID		0x2e	/* 16 Bits */
#define PCI_EXPANSION_ROM_BASE_ADDRESS	0x30	/* 32 Bits */
/*      Reserved                        0x34       32 Bits */
/*      Reserved                        0x38       32 Bits */
#define PCI_INTERRUPT_LINE		0x3c	/* 8 Bits */
#define PCI_INTERRUPT_PIN		0x3d	/* 8 Bits */
#define PCI_MIN_GNT			0x3e	/* 8 Bits */
#define PCI_MAX_LAT			0x3f	/* 8 Bits */

#define PCICONF_ADDR	0x0cf8
#define PCICONF_DATA	0x0cfc

#define PCI_ADDR(bus,dev,func) \
		(((uint32_t) (bus) << 16 ) \
		| ((uint32_t) (dev) << 11) \
		| ((uint32_t) (func) << 8))


static inline unsigned long __attribute__((always_inline))
pci_creadl(
	unsigned int bus,
	unsigned int unit,
	unsigned int fn,
	unsigned int reg
)
{
	outl(PCI_ADDR(bus, unit, fn) | 0x80000000 | reg, PCICONF_ADDR);
	return inl(PCICONF_DATA);
}

static inline void __attribute__((always_inline))
pci_cwritel(
	unsigned int bus,
	unsigned int unit,
	unsigned int fn,
	unsigned int reg,
	uint32_t val
)
{
	outl(PCI_ADDR(bus, unit, fn) | 0x80000000 | reg, PCICONF_ADDR);
	outl(val, PCICONF_DATA);
}

static inline uint16_t __attribute__((always_inline))
pci_creadw(
	unsigned int bus,
	unsigned int unit,
	unsigned int fn,
	unsigned int reg
)
{
	outl(PCI_ADDR(bus, unit, fn) | 0x80000000 | (reg & 0xfc), PCICONF_ADDR);
	return inw(PCICONF_DATA + (reg & 0x03));
}

static inline void __attribute__((always_inline))
pci_cwritew(
	unsigned int bus,
	unsigned int unit,
	unsigned int fn,
	unsigned int reg,
	uint16_t val
)
{
	outl(PCI_ADDR(bus, unit, fn) | 0x80000000 | (reg & 0xfc), PCICONF_ADDR);
	outw(val, PCICONF_DATA + (reg & 0x03));
}

static inline uint8_t __attribute__((always_inline))
pci_creadb(
	unsigned int bus,
	unsigned int unit,
	unsigned int fn,
	unsigned int reg
)
{
	outl(PCI_ADDR(bus, unit, fn) | 0x80000000 | (reg & 0xfc), PCICONF_ADDR);
	return inb(PCICONF_DATA + (reg & 0x03));
}

static inline void __attribute__((always_inline))
pci_cwriteb(
	unsigned int bus,
	unsigned int unit,
	unsigned int fn,
	unsigned int reg,
	uint8_t val
)
{
	outl(PCI_ADDR(bus, unit, fn) | 0x80000000 | (reg & 0xfc), PCICONF_ADDR);
	outb(val, PCICONF_DATA + (reg & 0x03));
}

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

#include "ptrace.h"

extern void
bios_1a_b1xx(struct regs *regs);

extern void
bios_pci_pm(struct regs *regs);

#endif /* RUNTIME_RM */
/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

extern void
pci_init(void);

extern void
pci_runexpansionroms(int onlydovga);

extern void
pci_listdevices(void);

#endif /* INIT_RM */

#endif /* __PCI_H_INCLUDED */
