/* $Id: arch_vesa_faum.c,v 1.33 2009-07-15 07:00:27 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	unsigned short video_mode;
	unsigned short window;
	int scanline;
	unsigned long pos;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOUR

#ifndef REFRESH_CYCLES
#error arch_vesa_faum.c needs REFRESH_CYCLES defined
#endif

#define DEBUG 0

static inline unsigned char
NAME_(readb)(struct cpssp *cpssp, unsigned long pa)
{
#if 2 <= DEBUG
	fprintf(stderr, "%s: pa=0x%05lx\n", __FUNCTION__, pa);
#endif
	assert(0 <= pa && pa < SZ_VIDEO_MEMORY_LOW);

	pa += cpssp->NAME.window * 0x10000;

	assert(0 <= pa && pa < SZ_VIDEO_MEMORY);

	return video_readb(cpssp, pa);
}

static inline void
NAME_(writeb)(struct cpssp *cpssp, unsigned long pa, unsigned char val)
{
#if 2 <= DEBUG
	fprintf(stderr, "%s: pa=0x%05lx, val=0x%02x\n",
			__FUNCTION__, pa, val);
#endif
	assert(0 <= pa && pa < SZ_VIDEO_MEMORY_LOW);

	pa += cpssp->NAME.window * 0x10000;

	assert(0 <= pa && pa < SZ_VIDEO_MEMORY);

	video_writeb(cpssp, pa, val);
}

static inline int
NAME_(read)(struct cpssp *cpssp, unsigned long pa, void *_to, int len)
{
	unsigned char *to = (unsigned char *) _to;

	if (PA_VIDEO_MEMORY_LOW <= pa
	 && pa < PA_VIDEO_MEMORY_LOW + 0x10000) {
		/*
		 * Low VESA memory
		 *
		 * Simulate access.
		 */
		pa -= PA_VIDEO_MEMORY_LOW;

		while (0 < len) {
			*to = NAME_(readb)(cpssp, pa);
			pa++;
			to++;
			len--;
		}

		return 0;

	} else if (PA_VIDEO_MEMORY_HIGH <= pa
		&& pa <= PA_VIDEO_MEMORY_HIGH + SZ_VIDEO_MEMORY_HIGH - 1) {
		/*
		 * High VESA memory
		 *
		 * Map directly.
		 */
		return 1;

	} else {
		/* Don't know... */
		return 1;
	}
}

static inline int
NAME_(write)(struct cpssp *cpssp, unsigned long pa, const void *_from, int len)
{
	const unsigned char *from = (const unsigned char *) _from;

	if (PA_VIDEO_MEMORY_LOW <= pa
	 && pa < PA_VIDEO_MEMORY_LOW + 0x10000) {
		/*
		 * Low VESA memory
		 *
		 * Simulate access.
		 */
		pa -= PA_VIDEO_MEMORY_LOW;

		while (0 < len) {
			NAME_(writeb)(cpssp, pa, *from);
			pa++;
			from++;
			len--;
		}

		return 0;

	} else if (PA_VIDEO_MEMORY_HIGH <= pa
		&& pa <= PA_VIDEO_MEMORY_HIGH + SZ_VIDEO_MEMORY_HIGH - 1) {
		/*
		 * High VESA memory
		 *
		 * Map directly.
		 */
		return 1;

	} else {
		/* Don't know... */
		return 1;
	}
}

static inline int
NAME_(map)(
	struct cpssp *cpssp,
	unsigned long pa,
	char **haddr_mr_p,
	char **haddr_mw_p
)
{
	if (PA_VIDEO_MEMORY_LOW <= pa
	 && pa <= PA_VIDEO_MEMORY_LOW + 0x10000 - 1) {
		/*
		 * Low VESA memory
		 *
		 * Simulate access.
		 */
		*haddr_mr_p = NULL;
		*haddr_mw_p = NULL;
		return 0;

	} else if (PA_VIDEO_MEMORY_HIGH <= pa
		&& pa <= PA_VIDEO_MEMORY_HIGH + SZ_VIDEO_MEMORY_HIGH - 1) {
		/*
		 * High VESA memory
		 *
		 * Map directly.
		 */
		return video_map(cpssp, pa - PA_VIDEO_MEMORY_HIGH,
				haddr_mr_p, haddr_mw_p);

	} else {
		/* Don't know... */
		return 1;
	}
}

static inline int
NAME_(outw)(struct cpssp *cpssp, unsigned short value, unsigned short port)
{
	switch (port) {
	case 0x03dc:
		cpssp->NAME.window = value;
		return 0;

	case 0x03de:
		cpssp->NAME.video_mode = value;
		if (0x100 <= value) {
			cpssp->mode = VESA_FAUM;
		} else {
			cpssp->mode = VGA;
		}
		return 0;

	default:
		return 1;
	}
}

static inline void
NAME_(gen_8bit)(
	struct cpssp *cpssp,
	struct sig_video *video,
	unsigned int width,
	unsigned int height
)
{
	int x;
	int scan_count;

	scan_count = 1 + height / REFRESH_CYCLES;
	while (scan_count && cpssp->NAME.scanline < height) {
		for (x = 0; x < width; x++) {
			unsigned char col;

			col = video_readb(cpssp, cpssp->NAME.pos++);

			sig_video_out(video, (void *) 0,
					video_col_get(cpssp, col, 0),
					video_col_get(cpssp, col, 1),
					video_col_get(cpssp, col, 2));
		}

		cpssp->NAME.scanline++;
		scan_count--;
		sig_video_hor_retrace(video, (void *) 0);
	}

	if (cpssp->NAME.scanline >= height) {
		cpssp->NAME.scanline = 0;
		cpssp->NAME.pos = 0;
		sig_video_vert_retrace(video, (void *) 0);
	}
}

static inline void
NAME_(gen_16bit)(
	struct cpssp *cpssp,
	struct sig_video *video,
	unsigned int width,
	unsigned int height
)
{
	int x;
	int scan_count;

	scan_count = 1 + height / REFRESH_CYCLES;
	while (scan_count && cpssp->NAME.scanline < height) {
		for (x = 0; x < width; x++) {
			unsigned short val16;
			unsigned char r;
			unsigned char g;
			unsigned char b;

			val16  = video_readb(cpssp, cpssp->NAME.pos++);
			val16 |= video_readb(cpssp, cpssp->NAME.pos++) << 8;

			r = ((val16 >> 11) & 0x1f) << 3;
			g = ((val16 >>  5) & 0x3f) << 2;
			b = ((val16 >>  0) & 0x1f) << 3;

			sig_video_out(video, (void *) 0, r, g, b);
		}

		cpssp->NAME.scanline++;
		scan_count--;
		sig_video_hor_retrace(video, (void *) 0);
	}

	if (cpssp->NAME.scanline >= height) {
		cpssp->NAME.scanline = 0;
		cpssp->NAME.pos = 0;
		sig_video_vert_retrace(video, (void *) 0);
	}
}

static inline void
NAME_(gen_32bit)(
	struct cpssp *cpssp,
	struct sig_video *video,
	unsigned int width,
	unsigned int height
)
{
	int x;
	int scan_count;

	scan_count = 1 + height / REFRESH_CYCLES;
	while (scan_count && cpssp->NAME.scanline < height) {
		for (x = 0; x < width; x++) {
			unsigned char r;
			unsigned char g;
			unsigned char b;

			b = video_readb(cpssp, cpssp->NAME.pos++);
			g = video_readb(cpssp, cpssp->NAME.pos++);
			r = video_readb(cpssp, cpssp->NAME.pos++);
			cpssp->NAME.pos++;

			sig_video_out(video, (void *) 0, r, g, b);
		}

		cpssp->NAME.scanline++;
		scan_count--;
		sig_video_hor_retrace(video, (void *) 0);
	}

	if (cpssp->NAME.scanline >= height) {
		cpssp->NAME.scanline = 0;
		cpssp->NAME.pos = 0;
		sig_video_vert_retrace(video, (void *) 0);
	}
}

static inline void
NAME_(gen)(struct cpssp *cpssp, struct sig_video *video)
{
	unsigned int width;
	unsigned int height;
	unsigned int depth;

	switch (cpssp->NAME.video_mode) {
	/* 8 bit */
	case 769-0x200:
		width = 640;  height = 480;  depth = 8;
		break;
	case 771-0x200:
		width = 800;  height = 600;  depth = 8;
		break;
	case 773-0x200:
		width = 1024; height = 768;  depth = 8;
		break;
	case 775-0x200:
		width = 1280; height = 1024; depth = 8;
		break;
	/* 15 bit */
	case 784-0x200:
		width = 640;  height = 480;  depth = 15;
		break;
	case 787-0x200:
		width = 800;  height = 600;  depth = 15;
		break;
	case 790-0x200:
		width = 1024; height = 768;  depth = 15;
		break;
	case 793-0x200:
		width = 1280; height = 1024; depth = 15;
		break;
	/* 16 bit */
	case 785-0x200:
		width = 640;  height = 480;  depth = 16;
		break;
	case 788-0x200:
		width = 800;  height = 600;  depth = 16;
		break;
	case 791-0x200:
		width = 1024; height = 768;  depth = 16;
		break;
	case 794-0x200:
		width = 1280; height = 1024; depth = 16;
		break;
	/* 32 bit */
	case 786-0x200:
		width = 640;  height = 480;  depth = 32;
		break;
	case 789-0x200:
		width = 800;  height = 600;  depth = 32;
		break;
	case 792-0x200:
		width = 1024; height = 768;  depth = 32;
		break;
	case 795-0x200:
		width = 1280; height = 1024; depth = 32;
		break;
	default:
		assert(0);
	}

	switch (depth) {
	case 8:
		NAME_(gen_8bit)(cpssp, video, width, height);
		break;
	case 15:	/* Correct? FIXME VOSSI */
	case 16:
		NAME_(gen_16bit)(cpssp, video, width, height);
		break;
	case 32:
		NAME_(gen_32bit)(cpssp, video, width, height);
		break;
	default:
		assert(0);
	}
}

extern inline void
NAME_(init)(struct cpssp *cpssp)
{
}

#undef DEBUG

#endif /* BEHAVIOUR */
