/*
 * $Id: sig_std_logic.c,v 1.12 2012-07-05 21:09:31 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_std_logic.h"

static unsigned int
sig_std_logic_resolve(unsigned int val0, unsigned int val1)
{
	switch (val0) {
	case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
	case SIG_STD_LOGIC_X: 
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_X;
		default: assert(0);
		}
	case SIG_STD_LOGIC_0:
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_0;
		default: assert(0);
		}
	case SIG_STD_LOGIC_1:
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_1;
		default: assert(0);
		}
	case SIG_STD_LOGIC_W:
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_W;
		default: assert(0);
		}
	case SIG_STD_LOGIC_L:
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_L;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_L;
		default: assert(0);
		}
	case SIG_STD_LOGIC_H:
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_H;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_H;
		default: assert(0);
		}
	case SIG_STD_LOGIC_Z:
		switch (val1) {
		case SIG_STD_LOGIC_U: return SIG_STD_LOGIC_U;
		case SIG_STD_LOGIC_X: return SIG_STD_LOGIC_X;
		case SIG_STD_LOGIC_0: return SIG_STD_LOGIC_0;
		case SIG_STD_LOGIC_1: return SIG_STD_LOGIC_1;
		case SIG_STD_LOGIC_W: return SIG_STD_LOGIC_W;
		case SIG_STD_LOGIC_L: return SIG_STD_LOGIC_L;
		case SIG_STD_LOGIC_H: return SIG_STD_LOGIC_H;
		case SIG_STD_LOGIC_Z: return SIG_STD_LOGIC_Z;
		default: assert(0);
		}
	default: assert(0);
	}
}

static void
sig_std_logic_flush(struct sig_std_logic *b)
{
	unsigned int i;
	unsigned int nr;

	for (i = 0; i < b->in_count; i++) {
		void (*func)(void *, unsigned int);
		unsigned int new_val;

		new_val = SIG_STD_LOGIC_Z;

		for (nr = 0; nr < b->out_count; nr++) {
			if (b->out[nr].s == b->in[i].s) continue;

			new_val = sig_std_logic_resolve(new_val, b->out[nr].out);
		}

		func = b->in[i].f->set_ext;
		if (func
		 && b->in[i].in != new_val) {
			b->in[i].in = new_val;
			func(b->in[i].s, new_val);
		}

		for (nr = 0; nr < b->out_count; nr++) {
			if (b->out[nr].s != b->in[i].s) continue;

			new_val = sig_std_logic_resolve(new_val, b->out[nr].out);
		}

		func = b->in[i].f->set;
		if (func
		 && b->in[i].in != new_val) {
			b->in[i].in = new_val;
			func(b->in[i].s, new_val);
		}
	}
}

void
sig_std_logic_set(struct sig_std_logic *b, void *s, unsigned int val)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->out_count) {
			assert(0);
			break;
		}
		if (b->out[nr].s == s) {
			b->out[nr].out = val;
			break;
		}
	}

	sig_std_logic_flush(b);
}

void
sig_std_logic_connect_in(
	struct sig_std_logic *b,
	void *s,
	const struct sig_std_logic_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_STD_LOGIC);
	assert(b->in_count < sizeof(b->in) / sizeof(b->in[0]));
	// assert(s);
	assert(f);
	assert(f->set || f->set_ext);
	assert(! f->set || ! f->set_ext);

	b->in[b->in_count].s = s;
	b->in[b->in_count].f = f;
	b->in[b->in_count].in = SIG_STD_LOGIC_U;
	b->in_count++;

	sig_std_logic_flush(b);
}

void
sig_std_logic_connect_out(
	struct sig_std_logic *b,
	void *s,
	unsigned int val
)
{
	assert(b);
	assert(b->type == SIG_GEN_STD_LOGIC);
	assert(b->out_count < sizeof(b->out) / sizeof(b->out[0]));
	// assert(s);
	assert(val == SIG_STD_LOGIC_U
	    || val == SIG_STD_LOGIC_X
	    || val == SIG_STD_LOGIC_0
	    || val == SIG_STD_LOGIC_1
	    || val == SIG_STD_LOGIC_W
	    || val == SIG_STD_LOGIC_L
	    || val == SIG_STD_LOGIC_H
	    || val == SIG_STD_LOGIC_Z);

	b->out[b->out_count].s = s;
	b->out[b->out_count].out = val;
	b->out_count++;

	sig_std_logic_flush(b);
}

static void
sig_std_logic_s0_set(void *_f, unsigned int val)
{
	struct sig_std_logic_merge *f = (struct sig_std_logic_merge *) _f;

	sig_std_logic_set(f->s1, f, val);
}

static void
sig_std_logic_s1_set(void *_f, unsigned int val)
{
	struct sig_std_logic_merge *f = (struct sig_std_logic_merge *) _f;

	sig_std_logic_set(f->s0, f, val);
}

struct sig_std_logic_merge *
sig_std_logic_merge(struct sig_std_logic *s0, struct sig_std_logic *s1)
{
	static struct sig_std_logic_funcs s0_funcs = {
		.set_ext = sig_std_logic_s0_set,
	};
	static struct sig_std_logic_funcs s1_funcs = {
		.set_ext = sig_std_logic_s1_set,
	};
	struct sig_std_logic_merge *m;

	m = shm_alloc(sizeof(*m));
	assert(m);

	/* Out */
	m->s0 = s0;
	sig_std_logic_connect_out(s0, m, SIG_STD_LOGIC_Z);
	m->s1 = s1;
	sig_std_logic_connect_out(s1, m, SIG_STD_LOGIC_Z);

	/* In */
	sig_std_logic_connect_in(s0, m, &s0_funcs);
	sig_std_logic_connect_in(s1, m, &s1_funcs);

	return m;
}

void
sig_std_logic_split(struct sig_std_logic_merge *m)
{
	fixme();
}

struct sig_std_logic *
sig_std_logic_create(const char *name)
{
	struct sig_std_logic *b;

	b = shm_alloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_STD_LOGIC;
	b->out_count = 0;
	b->in_count = 0;

	return b;
}

void
sig_std_logic_destroy(struct sig_std_logic *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_STD_LOGIC);

	shm_free(sig);
}

void
sig_std_logic_suspend(struct sig_std_logic *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_std_logic_resume(struct sig_std_logic *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
