/*
 * $Id: sig_ide_bus.h,v 1.11 2012-03-06 14:46:49 siflkres Exp $
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_IDE_BUS_H_INCLUDED
#define __SIG_IDE_BUS_H_INCLUDED

#include "sig_gen.h"

struct sig_ide_bus_device_funcs {
	int (*inw)(void *cpss, unsigned short port, unsigned short *valp);
	void (*outw)(void *cpss, unsigned short port, unsigned short val);
};

struct sig_ide_bus_controller_funcs {
	void (*irq)(void *c, unsigned int val);
	void (*dmarq_set)(void *c, unsigned int val);
};

struct sig_ide_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_ide_bus_device_funcs *funcs;
		int irq_state;
	} device[2];
	unsigned int ndevices;

	struct {
		void *s;
		const struct sig_ide_bus_controller_funcs *funcs;
	} controller;
};

extern void
sig_ide_bus_inw(
	struct sig_ide_bus *bus,
	unsigned short port,
	unsigned short *valp
);
extern void
sig_ide_bus_outw(
	struct sig_ide_bus *bus,
	unsigned short port,
	unsigned short val
);

extern void
sig_ide_bus_irq(
	struct sig_ide_bus *cable,
	void *s,
	unsigned int val
);
extern void
sig_ide_bus_dmarq_set(
	struct sig_ide_bus *cable,
	unsigned int val
);

extern void
sig_ide_bus_connect_device(
	struct sig_ide_bus *cable,
	void *s,
	const struct sig_ide_bus_device_funcs *funcs
);
extern void
sig_ide_bus_connect_controller(
	struct sig_ide_bus *cable,
	void *s,
	const struct sig_ide_bus_controller_funcs *funcs
);

extern struct sig_ide_bus *
sig_ide_bus_create(const char *name);
extern void
sig_ide_bus_destroy(struct sig_ide_bus *sig);

extern void
sig_ide_bus_suspend(struct sig_ide_bus *b, FILE *fSig);
extern void
sig_ide_bus_resume(struct sig_ide_bus *b, FILE *fSig);

#endif /* __SIG_IDE_BUS_H_INCLUDED*/
