#!/bin/sh

TESTS_LIST_SUFFIX=$(uname -n | sed -e 's/faui//')
TESTS_LIST=tests.list.${TESTS_LIST_SUFFIX}

if [ ! -f ${TESTS_LIST} ]; then
	echo "Test list ${TESTS_LIST} for host $(uname -n) not found."
	exit 1
fi

cat ${TESTS_LIST} | while read ARG; do
	make clean

	TS=$(date +%Y%m%d-%H%M%S)

	./gen_vhdl_faults.sh $ARG >> log.faults
	echo "${TS} starting experiment." >> log.faults;

	make experiment
	RESULT=$?

	TS2=$(date +%Y%m%d-%H%M%S)
	if [ ${RESULT} -eq 0 ]; then
		echo "${TS} Success at ${TS2}." >> log.faults;
	else
		echo "${TS} Failure at ${TS2}." >> log.faults;
	fi;

	# TODO store cow/map files.to ${TS}_<disk>.media.{cow|map}
	# currently not feasable since cow files aren't sparse.

	cat log.faults >> experiment.log
	mv log.faults ${TS}.faults

	for I in node.def/screenshot*; do
		mv ${I} ${TS}.$(basename $I)
	done;

	mv log.faum-expect ${TS}.log.faum-expect
	mv log.faum-node.pc ${TS}.log.faum-node.pc
done
