/* $Id$
 *
 * TypeDeclaration: AST Class representing a type declaration.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPE_DECLARATION_HPP_INCLUDED
#define __TYPE_DECLARATION_HPP_INCLUDED

#include "frontend/ast/AttributableDeclaration.hpp"
#include "frontend/ast/Location.hpp"
#include "frontend/ast/Types.hpp"

namespace ast {

//! one generic VHDL type declaration.
/** This class represents one VHDL type declaration.
 */
class TypeDeclaration : public AttributableDeclaration {
public:
	//! c'tor
	/** @param declName name of the declared type.
          * @param loc location of the declaration.
	  * @param base base type of this declaration.
          */
	TypeDeclaration(
		std::string *declName,
		Location loc,
		enum BaseType base
		) : 	AttributableDeclaration(declName, loc),
			baseType(base),
			isUniversal(false) {}

	/** the base type of this declared type. */
	enum BaseType baseType;

	//! is this either universal_integer or universal_real?
	bool isUniversal;
};

}; /* namespace ast */

#endif /* __TYPE_DECLARATION_HPP_INCLUDED */
