# Метадані та URL-адреси документації

Ви можете налаштувати кілька конфігурацій метаданих у Вашому додатку **FastAPI**.

## Метадані для API

Ви можете встановити такі поля, які використовуються в специфікації OpenAPI та в автоматично згенерованих інтерфейсах документації API:

| Параметр | Тип | Опис |
|------------|------|-------------|
| `title` | `str` | Назва API. |
| `summary` | `str` | Короткий опис API. <small>Доступно з OpenAPI 3.1.0, FastAPI 0.99.0.</small> |
| `description` | `str` | Більш детальний опис API. Може використовувати Markdown. |
| `version` | `string` | Версія API. Це версія Вашого додатка, а не OpenAPI. Наприклад, `2.5.0`. |
| `terms_of_service` | `str` |  URL до умов використання API. Якщо вказано, має бути у форматі URL. |
| `contact` | `dict` | Інформація для контакту з API. Може містити кілька полів. <details><summary><code>contact</code> поля</summary><table><thead><tr><th>Параметр</th><th>Тип</th><th>Опис</th></tr></thead><tbody><tr><td><code>name</code></td><td><code>str</code></td><td>Ім'я контактної особи або організації.</td></tr><tr><td><code>url</code></td><td><code>str</code></td><td>URL з інформацією для контакту. Повинен бути у форматі URL.</td></tr><tr><td><code>email</code></td><td><code>str</code></td><td>Email контактної особи або організації. Повинен бути у форматі електронної пошти.</td></tr></tbody></table></details> |
| `license_info` | `dict` | Інформація про ліцензію для API. Може містити кілька полів. <details><summary><code>license_info</code> поля</summary><table><thead><tr><th>Параметр</th><th>Тип</th><th>Опис</th></tr></thead><tbody><tr><td><code>name</code></td><td><code>str</code></td><td><strong>ОБОВ'ЯЗКОВО</strong> (якщо встановлено <code>license_info</code>). Назва ліцензії для API.</td></tr><tr><td><code>identifier</code></td><td><code>str</code></td><td>Ліцензійний вираз за <a href="https://spdx.org/licenses/" class="external-link" target="_blank">SPDX</a> для API. Поле <code>identifier</code> взаємовиключне з полем <code>url</code>. <small>Доступно з OpenAPI 3.1.0, FastAPI 0.99.0.</small></td></tr><tr><td><code>url</code></td><td><code>str</code></td><td>URL до ліцензії, яка використовується для API. Повинен бути у форматі URL.</td></tr></tbody></table></details> |

Ви можете налаштувати їх наступним чином:

{* ../../docs_src/metadata/tutorial001.py hl[3:16, 19:32] *}

/// tip | Підказка

У полі `description` можна використовувати Markdown, і він буде відображатися у результаті.

///

З цією конфігурацією автоматична документація API виглядатиме так:

<img src="/img/tutorial/metadata/image01.png">

## Ідентифікатор ліцензії

З початку використання OpenAPI 3.1.0 та FastAPI 0.99.0 Ви також можете налаштувати `license_info` за допомогою `identifier` замість `url`.

Наприклад:

{* ../../docs_src/metadata/tutorial001_1.py hl[31] *}

## Метадані для тегів

Ви також можете додати додаткові метадані для різних тегів, які використовуються для групування операцій шляхів, за допомогою параметра `openapi_tags`.

Він приймає список, який містить один словник для кожного тега.

Кожен словник може містити:

* `name` (**обов'язково**): `str` з тією ж назвою тегу, яку Ви використовуєте у параметрі  `tags` у Ваших *операціях шляху* та `APIRouter`s.
* `description`: `str` з коротким описом тегу. Може містити Markdown і буде відображено в інтерфейсі документації.
* `externalDocs`: `dict` який описує зовнішню документацію з такими полями:
    * `description`: `str` з коротким описом зовнішньої документації.
    * `url` (**обов'язково**): `str`з URL-адресою зовнішньої документації.

### Створення метаданих для тегів

Спробуймо це на прикладі з тегами для `users` та `items`.

Створіть метадані для своїх тегів і передайте їх у параметр  `openapi_tags`:

{* ../../docs_src/metadata/tutorial004.py hl[3:16,18] *}

Зверніть увагу, що в описах можна використовувати Markdown, наприклад, "login" буде показано жирним шрифтом (**login**), а "fancy" буде показано курсивом (_fancy_).

/// tip | Порада

Не обов'язково додавати метадані для всіх тегів, які Ви використовуєте.

///

### Використання тегів

Використовуйте параметр `tags` зі своїми *операціями шляху* (і `APIRouter`) для призначення їх до різних тегів:

{* ../../docs_src/metadata/tutorial004.py hl[21,26] *}

/// info | Інформація

Детальніше про теги читайте в розділі [Конфігурація шляхів операцій](path-operation-configuration.md#tags){.internal-link target=_blank}.

///

### Перевірка документації

Якщо Ви зараз перевірите документацію, вона покаже всі додаткові метадані:

<img src="/img/tutorial/metadata/image02.png">

### Порядок тегів

Порядок кожного словника метаданих тегу також визначає порядок відображення в інтерфейсі документації.

Наприклад, хоча `users` мав би йти після `items` в алфавітному порядку, він відображається перед ними, оскільки ми додали його метадані як перший словник у списку.

## URL для OpenAPI

За замовчуванням схема OpenAPI надається за адресою `/openapi.json`.

Але Ви можете налаштувати це за допомогою параметра `openapi_url`.

Наприклад, щоб налаштувати його на `/api/v1/openapi.json`:

{* ../../docs_src/metadata/tutorial002.py hl[3] *}

Якщо Ви хочете повністю вимкнути схему OpenAPI, Ви можете встановити `openapi_url=None`, це також вимкне інтерфейси документації, які її використовують.

## URL-адреси документації

Ви можете налаштувати два інтерфейси користувача для документації, які включені:

* **Swagger UI**: доступний за адресою `/docs`.
    * Ви можете змінити його URL за допомогою параметра `docs_url`.
    * Ви можете вимкнути його, встановивши `docs_url=None`.
* **ReDoc**: доступний за адресою `/redoc`.
    * Ви можете змінити його URL за допомогою параметра `redoc_url`.
    * Ви можете вимкнути його, встановивши `redoc_url=None`.

Наприклад, щоб налаштувати Swagger UI на `/documentation` і вимкнути ReDoc:

{* ../../docs_src/metadata/tutorial003.py hl[3] *}
