/************************************************************* 
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 *
*************************************************************/

/*************************************************************
*
*  File:  proto.h
*
*  Purpose: ANSI function prototypes.
*  Note: Some compilers still don't like ANSI prototypes, so 
*        ARGS() is a macro defined in include.h to take care
*        of that.
*/

#ifdef  __cplusplus

void loadstub(void);

extern "C" {
#endif

#ifndef drand48
 extern double drand48 ARGS((void)); /* may not be in header file */
#endif

#ifdef MSC
 extern void srand48 ARGS((int));
#endif

#ifdef MPI_EVOLVER
#include "mpi_proto.h"
#endif
 
void read_array_initializer ARGS((struct array *));
int simple_unstar ARGS((facetedge_id));
int check_recalc_attr ARGS((int));
void check_readonly_attr ARGS((int));
void check_special_attr ARGS((int));
int  get_name_dim ARGS((int,struct locallist_t *));
int  get_name_datatype ARGS((int,struct locallist_t *));
char * get_name_name ARGS((int,struct locallist_t *));
struct array *get_name_arrayptr ARGS((int,REAL*,struct locallist_t *));
int  check_array_dims_same ARGS((int ,int));
void one_sided_volume_adjust ARGS((vertex_id));
int one_sided_lagrange_adjust ARGS((vertex_id));
int mat_approx_solve ARGS((REAL**,int,REAL*));
REAL vertex_total_vol_grad ARGS((vertex_id,REAL*));
void calc_one_sided_grads ARGS((void));
void mpi_hessian_cleanup ARGS((void));
void do_multigrid ARGS((struct linsys*));
void mark_recalc_params ARGS((void));
int mark_recalc_expr ARGS((struct expnode*));
int vertex_facet_check ARGS((void));
WRAPTYPE identity_inverse ARGS((WRAPTYPE));
WRAPTYPE identity_compose ARGS((WRAPTYPE,WRAPTYPE));
void identity_wrap ARGS((REAL *,REAL *,WRAPTYPE));
void identity_form_pullback ARGS((REAL *,REAL *,REAL *,WRAPTYPE));
void graph_string_facet ARGS((facet_id,struct graphdata *,int));
void plain_string_facets ARGS((void));
void print_profiling ARGS((void));
void reset_profiling ARGS((void));
void convert_constraint_to_quantities ARGS((int));
int create_body_boundary_content_method ARGS((body_id,int));
int create_body_constraint_content_method ARGS((body_id,int));
void simplex_to_fe ARGS((void));
void check_forwards ARGS((void));
int  star_finagle ARGS((edge_id));
void cg_restart ARGS((void));
REAL cg_sum_calc ARGS((void));
void cg_direction_local ARGS((void));
REAL ribiere_calc ARGS((void));
REAL v_estimate ARGS((void));
void add_vgrads_to_update ARGS(( struct linsys *));
void slice_facet ARGS((struct graphdata *));
void slice_edge ARGS((struct graphdata *));
void clip_facet ARGS((struct graphdata *,facet_id,int));
void clip_edge ARGS((struct graphdata *,edge_id,int));
void graph_edge_clip ARGS((struct graphdata *,edge_id));
void mark_element_loops ARGS((struct treenode *, int));
void mem_list_dump ARGS((void));
struct element * elhash_lookup ARGS((element_id));
void elhash_delete ARGS((element_id));
void elhash_bigger ARGS((void));
void elhash_extend ARGS((int,int));
struct element *elhash_new_element ARGS((int,element_id));
void elhash_insert ARGS((element_id,struct element *));
void elhash_replace ARGS((element_id,struct element *));
void matrix_multiply_command ARGS((struct array*,struct array*,struct array*,REAL*,REAL*,REAL*));
int matrix_inverse_command ARGS((struct array*,struct array*,REAL*,REAL*));
REAL matrix_determinant_command ARGS((struct array*,REAL*));
void tree_analyze ARGS((struct linsys *));
void fixup_edge_content_meths ARGS((edge_id));
void fixup_vertex_content_meths ARGS((vertex_id));
REAL tetra_vol ARGS((REAL*,REAL*,REAL*,REAL*));
int read_single_value ARGS((int,char*));
void set_ctypes ARGS((void));
void kb_unput ARGS((char));
void list_quantity ARGS((int));
void list_method_instance ARGS((int));
void list_boundary ARGS((int));
void list_constraint ARGS((int));
void torus_unwrap_edge ARGS(( edge_id ));
int pop_vertex_to_tri ARGS(( vertex_id, edge_id *));
int pop_vertex_to_quad ARGS(( vertex_id, edge_id *));
int cubecone_pop ARGS(( vertex_id, int ));
void wrap_vertex ARGS((vertex_id,int));
void find_cpu_speed ARGS((void));
void reset_counts ARGS((void));
int pop_constrained_vertex ARGS((vertex_id));
int one_con_pop_2 ARGS((vertex_id,edge_id *,edge_id *,int));
int one_con_pop_3 ARGS((vertex_id,int ,edge_id *,edge_id *,int));
int one_con_pop_4 ARGS((vertex_id,edge_id *,int));
int double_con_pop ARGS((vertex_id,edge_id,edge_id *));
int triple_con_pop ARGS((vertex_id));
void flush_counts ARGS((void));
void merge_vertex ARGS((vertex_id,vertex_id));
void merge_edge ARGS((edge_id,edge_id));
void merge_facet ARGS((facet_id,facet_id));
void binary_tree_add ARGS((REAL*,REAL));
void  torus_display_period_init ARGS((void));
REAL bezier_eval ARGS((int, int, int*, REAL *));
void bezier_convert_1D_init ARGS(( int ));
void bezier_convert_2D_init ARGS(( int ));
int t1_edgeswap ARGS((edge_id));
void get_edge_tail_tangent ARGS((edge_id,REAL*));
int valid_element ARGS((element_id));
void bezier_trans_1d ARGS((int,int,REAL**));
void bezier_eval_1d ARGS((int,int,REAL,REAL**,REAL*));
void lagrange_eval_1d ARGS((int,int,REAL,REAL**,REAL*));
void bezier_refine_1d_init ARGS((int));
void lagrange_to_bezier ARGS((void));
void bezier_to_lagrange ARGS((void));

void bezier_trans_2d ARGS((int,int,REAL**));
void lagrange_eval_2d ARGS((int,int,REAL*,REAL**,REAL*));
void bezier_eval_2d ARGS((int,int,REAL*,REAL**,REAL*));
void bezier_refine_2d_init ARGS((int));

void OFF_start ARGS((void));
void OFF_edge ARGS((struct graphdata *, edge_id));
void OFF_facet ARGS((struct graphdata *, facet_id));
void OFF_end ARGS((void));
void binary_OFF_start ARGS((void));
void binary_OFF_edge ARGS((struct graphdata *, edge_id));
void binary_OFF_facet ARGS((struct graphdata *, facet_id));
void binary_OFF_end ARGS((void));
unsigned int int32hash ARGS((unsigned int));
#ifndef NOLONGLONG
unsigned long long int64hash ARGS((unsigned long long));
#endif
void partner_move ARGS((void));
void partner_shift_grads ARGS((int));
void partner_hit_velocity_fix ARGS((void));
void partner_hit_volgrad_fix ARGS((void));
void detect_bdry_hits ARGS((void));
void thread_move_vertices ARGS((void));
void torus_period_init ARGS((void));
void set_eigenvalue_list_global ARGS((REAL*,int));
void set_view_transforms_global ARGS((void));
void set_torus_periods_global ARGS((void));
void set_inverse_periods_global ARGS((void));
void set_view_matrix_global ARGS((void));
void initialize_perm_globals ARGS((void));
void allocate_transform_colors ARGS((int));
int pop_tri_to_edge ARGS((facet_id));
int pop_edge_to_tri ARGS((edge_id));
int pop_edge_to_tri_con ARGS((edge_id));
int pop_quad_to_quad ARGS((facet_id));
void stack_usage ARGS((struct expnode *));
void list_top_procedures ARGS((int));
void list_procedure ARGS((struct global *));
void list_procedure_proto ARGS((struct global *));
void list_function_proto ARGS((struct global *));
void list_function ARGS((struct global *));
void init_local_scope ARGS((ident_t));
void exit_local_scope ARGS((void));
void begin_local_scope ARGS((void));
void end_local_scope ARGS((void));
void locals_copy ARGS((struct locallist_t **,struct locallist_t *));
void locals_copy_perm ARGS((struct locallist_t **,struct locallist_t *));
ident_t lookup_local_var ARGS((char*));
ident_t add_local_var ARGS((char*,int));
void read_attribute_value ARGS((struct extra *, void*));
int equiangulate_edge ARGS((edge_id));
int calc_view_transform_gens ARGS((void));
void force_project ARGS(( REAL*, vertex_id, REAL *));
int global_meth_needs ARGS((int));
int pop_given_vertex ARGS((vertex_id));
int pop_string_vertex ARGS((vertex_id));
void print_array ARGS((struct array *,void*));
void print_array_attribute ARGS(( struct extra*, void*)); 
void recalc_facet_area ARGS((facet_id));
void rewind_globals ARGS((int));
void perm_rewind_globals ARGS((int));
void add_warning_message ARGS((char*));
void graph_new_surface ARGS((void));
void LD_solve ARGS((REAL**,REAL*,REAL*,int));
int LD_factor ARGS(( REAL**, int ));
int lookup_global_hash ARGS((char*,int,int,int));
void dy_check ARGS((void));
void report_quantities ARGS((void));
void list_free ARGS((char *,int));
void list_free_all ARGS((int));
#ifdef MEMSTRINGS
char * list_calloc ARGS((size_t,size_t,int,char*,size_t));
char * list_realloc ARGS((char *,size_t,int,char*,size_t)); 
#else
char * list_calloc ARGS((size_t,size_t,int));
char * list_realloc ARGS((char *,size_t,int)); 
#endif
void mem_list_summary ARGS((void));
void mem_check_sanity ARGS((void));
void change_hessian_functions ARGS((int,int));
int LD_block_factor ARGS((REAL **, int));
void LD_block_solve ARGS((REAL **, REAL *, REAL *, int));
int find_fixed ARGS((void));
void sp_hash_init ARGS((struct linsys *,int));
void sp_hash_expand ARGS((struct linsys *));
void sp_hash_search ARGS((struct linsys *,int,int,REAL));
int sp_hash_end ARGS((struct linsys *,int,int,int));
void my_pvm_exit ARGS((void));
void pvm_calc_quants ARGS((int));
void pvm_calc_quant_grads ARGS((int));
void pvm_facet_knot_init ARGS((REAL*));
int two_split ARGS((facetedge_id,int));
int vertex_degfree ARGS((vertex_id));
int edge_degfree ARGS((edge_id));
int facet_degfree ARGS((facet_id));
void divide_quad ARGS((facetedge_id));
int pop_one_edge ARGS((edge_id));
void set_scroll_size ARGS((int));
REAL ellipticK ARGS((REAL));
REAL ellipticE ARGS((REAL));
REAL ellipticKdm ARGS((REAL));
REAL ellipticEdm ARGS((REAL));
REAL ellipticKdmdm ARGS((REAL));
REAL ellipticEdmdm ARGS((REAL));
REAL incompleteEllipticF ARGS((REAL,REAL));
REAL incompleteEllipticFdphi ARGS((REAL,REAL));
REAL incompleteEllipticFdm ARGS((REAL,REAL));
REAL incompleteEllipticFseconds ARGS((REAL,REAL,REAL*,REAL*,REAL*,REAL*,REAL*));
REAL incompleteEllipticE ARGS((REAL,REAL));
REAL incompleteEllipticEdphi ARGS((REAL,REAL));
REAL incompleteEllipticEdm ARGS((REAL,REAL));
REAL incompleteEllipticEseconds ARGS((REAL,REAL,REAL*,REAL*,REAL*,REAL*,REAL*));
int INDEX_TO_RGBA ARGS((int));
void multi_calc_quants ARGS((int));
void m_fix_grads ARGS((void));
void m_calc_quant_grads ARGS((int));
int mylock_web ARGS((void));
int myunlock_web ARGS((void));
int mylock_element ARGS((element_id));
int myunlock_element ARGS((element_id));
element_id thread_next_element ARGS((void));
void thread_launch ARGS((int,int));
void thread_project_all ARGS((int));
void thread_calc_facet_energy ARGS((void));
void thread_calc_facet_forces ARGS((void));
REAL interp_edge_attribute ARGS(( edge_id ,struct extra *, int ,int));
REAL interp_facet_attribute ARGS(( edge_id ,struct extra *, int ,int));
REAL get_extra_attrib_value ARGS(( element_id, struct extra *, int));
void define_array ARGS((void));
void userfunc_init ARGS((void));
void break_check ARGS((void));
int lagrange_facet_normal  ARGS((vertex_id,facet_id,REAL**));
void test_axial_points ARGS(( facet_id ));
int compare_edge_attr ARGS((edge_id, edge_id));
int compare_edge_facet_attr ARGS((edge_id,facet_id));
int compare_vertex_edge_attr ARGS((vertex_id, edge_id));
int compare_vertex_attr ARGS((vertex_id, vertex_id));
void set_body_volume ARGS((body_id,REAL,int));
void add_body_volume ARGS((body_id,REAL));
void add_body_volume_plain ARGS((body_id,REAL));
void add_body_abstotal ARGS((body_id,REAL));
void set_body ARGS((facet_id,body_id));
int kb_yylex ARGS((YYSTYPE*));
void reset_inputbuffer ARGS((void));
char *my_fgets ARGS((char *,int,FILE *stream));
int method_check ARGS((void));
void renumber_all ARGS((void));
void reorder_storage ARGS((void));
int identtype ARGS((char*));
REAL kb_drand ARGS((void));
void  kb_initr ARGS((int)); 
void dump_macros ARGS((void));
void move_to_free_front ARGS((int,int));
void calc_all_grads ARGS((int));
void check_pinning ARGS((void));
void convert_forms_to_vectors ARGS((int));
void local_convert_forms_to_vectors ARGS((int));
void clear_v_conmap ARGS((vertex_id ));
void list_attributes ARGS((void));
void reset_rot_order ARGS((void));
void start_logfile ARGS((char*));
void stop_logfile ARGS((void));
void start_keylogfile ARGS((char*));
void stop_keylogfile ARGS((void));
void one_sided_adjust ARGS((int));
void calc_leftside ARGS((void));
void local_calc_leftside ARGS((void));
void local_calc_rightside ARGS((void));
void load_library ARGS((char *));
void unload_libraries ARGS((void));
dll_func_type search_libraries ARGS((char*));
REAL get_internal_variable ARGS((int ));
void check_element_type  ARGS(( int, int ));
int read_pick ARGS((void));
int count_fixed_vol ARGS((void));
int oid ARGS((element_id));
void flip_toggle ARGS((int*,int,char*));
int gram_schmidt ARGS((REAL**,int,int));
int new_vertex_average ARGS((vertex_id,int));
int lagrange_vertex_average ARGS((vertex_id,REAL*));
void keyword_help ARGS((char *));
void error_help ARGS((char *));
void write_to_console ARGS((char *));
void read_line_from_console ARGS((char *));
int do_edgeswap ARGS((edge_id));
void apply_h_inverse_metric ARGS((void));
void list_proc ARGS((struct global *,int));
void list_procedures ARGS((int));
void linear_to_lagrange ARGS((int));
void quad_to_lagrange ARGS((int));
void lagrange_to_linear ARGS((void));
void lagrange_to_quad ARGS((void));
void sparse_permute ARGS((struct linsys *));
void do_tree_factor ARGS((struct linsys *));
void do_tree_solve ARGS((struct linsys *,REAL *,REAL*));
int find_method_instance ARGS((char*));
int find_quantity ARGS((char*));
void reconvert_bodies_to_quantities ARGS((void));
void convert_bodies_to_quantities ARGS((void));
int string_rebody ARGS((void));
void  lagrange_to_lagrange ARGS((int));
void  simplex_lagrange_to_lagrange ARGS((int));
void metis_partition ARGS((int,int));
void metis_partition_plain ARGS((int,int));
void metis_partition_body ARGS((int,int));
void metis_partition_dual ARGS((int,int));
void metis_order ARGS((struct linsys *));
void metis_vertex_order ARGS((int));
int lagrange_index ARGS((int,int,int*));
int increment_lagrange_index ARGS((int,int*));
void gauss_lagrange_setup ARGS((int,int,int));
void det_hess ARGS((REAL **,REAL ****,int ));
int simplex_delete_facet ARGS((facet_id));
int simplex_delete_edge ARGS((vertex_id,vertex_id));
void write_hessian ARGS((struct linsys *));
REAL gravity_all  ARGS((struct qinfo *,int));
void  LQ_decomp ARGS((REAL**,int,int,REAL**,REAL**,struct linsys *));
void q_info_free ARGS((struct qinfo *));
void q_info_init ARGS((struct qinfo *,int));
void make_el_list ARGS((int));
int Ord ARGS((element_id));
void toggle_save ARGS((char*));
void toggle_save_off ARGS((char*));
int get_v_constraint_status ARGS((vertex_id,int));
int v_hit_constraint_count ARGS((vertex_id));
REAL square_grad ARGS((void));
void square_grad_forces ARGS((void));
void cg_ritz ARGS((struct linsys *,int,REAL**,REAL*));
int check_pick ARGS((void));
void read_extra ARGS((element_id,int));
int simplex_quadrature ARGS((int,int,int,REAL**,REAL*));
int eartest ARGS((vertex_id,vertex_id));
void convert_string ARGS((char*,char*));
void hessian_legal ARGS((void));
int check_one_sided_constraints ARGS((void));
void set_v_global ARGS((vertex_id));
void set_v_conmap ARGS((vertex_id,conmap_t*));
void set_e_conmap ARGS((edge_id,conmap_t*));
void set_f_conmap ARGS((facet_id,conmap_t*));
void set_v_constraint_map ARGS((vertex_id,int));
void unset_v_constraint_map ARGS((vertex_id,int));
void set_v_constraint_status ARGS((vertex_id,int));
void unset_v_constraint_status ARGS((vertex_id,int));
void clear_v_constraint_status ARGS((vertex_id));
void set_e_constraint_map ARGS((edge_id,int));
void unset_e_constraint_map ARGS((edge_id,int));
void set_f_constraint_map ARGS((facet_id,int));
void unset_f_constraint_map ARGS((facet_id,int));
int v_on_constraint ARGS((vertex_id,int));
int e_on_constraint ARGS((edge_id,int));
int f_on_constraint ARGS((facet_id,int));
void get_v_common_conmap ARGS((vertex_id,vertex_id,conmap_t *));

int simplex_tiny_edges ARGS((REAL));
int get_tag ARGS((facet_id));
void set_tag ARGS((facet_id,int));
void ritz_command ARGS((REAL,int));
void do_ritz ARGS((struct linsys *,REAL,int,REAL **));
void print_hessian_menu ARGS((void));
void expand_attribute ARGS((int,int,int*));
void expand_global_hash ARGS((void));
int edgeswap ARGS(( edge_id));
REAL sparse_metric_dot ARGS((REAL*,REAL*,struct linsys *));
void gauss_jacobi ARGS((int, REAL , REAL *, REAL *));
void jacobi_eigenpairs ARGS(( REAL **, int, REAL *, REAL **, REAL *));
void star_metric_setup ARGS(( struct linsys *S, struct linsys *));
void linear_metric_setup ARGS((struct linsys *, struct linsys *));
void linear_metric_setup_quadratic ARGS(( struct linsys *, struct linsys *));
void linear_metric_setup_lagrange ARGS(( struct linsys *, struct linsys *));
REAL get_vertex_length_star ARGS((vertex_id));
REAL get_vertex_area_star ARGS((vertex_id));
void convert_to_quantities ARGS((void));
void convert_body_to_quantity ARGS((body_id));
void convert_new_body_to_quantity ARGS((body_id));
void long_jiggle ARGS((void));
void free_system ARGS((struct linsys *));
int simplex_long_edges ARGS((REAL));
void lanczos_command ARGS((REAL,int));
void eigenprobe_command ARGS((REAL,int));
void myfree ARGS((char *));
void option_facet ARGS((struct graphdata*,facet_id)); 
void geomview_command ARGS((char*));
void ysmp_numeric_factor ARGS((void));
void sp_hessian_mult ARGS((struct linsys *S, REAL *B, REAL *C));
void sp_solution ARGS((struct linsys *S, REAL *B, REAL *C));
void hessian_exit ARGS((REAL *));
void hessian_cleanup ARGS((void));
void hessian_solve ARGS((void)); 
void hessian_downhill ARGS((void)); 
void hessian_move ARGS((REAL,int,REAL *));
int  lanczos ARGS((struct linsys*,int,REAL*,int));
int  selective_lanczos ARGS((struct linsys*,int,REAL*,int));
void tridiag_QL ARGS((REAL*,REAL*,int));
void intersect_detect ARGS((void));
void bk_mul ARGS((struct linsys *, REAL*,REAL*));
void bk_AIJ_setup ARGS((int,struct linsys*));
void bk_eigenprobe ARGS((struct linsys *));
void bk_inverse_it ARGS((struct linsys *, REAL *));
void sp_hessian_solve ARGS((struct linsys *,REAL *, REAL *,int));
void sp_hessian_solve_multi ARGS((struct linsys *,REAL **, REAL **,int));
void sp_Hessian_solver ARGS((struct linsys *, REAL *, REAL **));
void bk_constraint_setup ARGS((int, struct linsys *));
void BK_hess_project_setup ARGS((struct linsys *));
void xmd_factor ARGS((struct linsys *));
void xmd_solve ARGS((struct linsys *,REAL *,REAL *));
void xmd_solve_multi ARGS((struct linsys *,REAL **,REAL **,int));
void sp_CHinvC ARGS((struct linsys *));
void tree_factor ARGS((struct linsys *));
void tree_solve ARGS((struct linsys *,REAL *,REAL *));
void tree_solve_multi ARGS((struct linsys *,REAL **,REAL **,int));
void ysmp_factor ARGS((struct linsys *));
void ysmp_solve ARGS((struct linsys *,REAL *,REAL *));
void ysmp_solve_multi ARGS((struct linsys *,REAL **,REAL **,int));
void find_ordering ARGS((struct hess_verlist *,int,int *));
void hessian_saddle ARGS((REAL));
REAL lowest_eigenpair ARGS((struct linsys *,REAL *));
REAL cg_lowest_eigenpair ARGS((struct linsys *,REAL *));
REAL old_cg_lowest_eigenpair ARGS((struct linsys *,REAL *));
REAL new_cg_lowest_eigenpair ARGS((struct linsys *,REAL *));
element_id get_ordinal_id ARGS((int,int));
element_id get_full_id ARGS((int,element_id));
void project_all ARGS((int,int));
void chebychev_hess ARGS((struct linsys *));
void chebychev_ev ARGS((struct linsys *));
void fill_self_entry ARGS((struct linsys *,vertex_id,REAL**));
void fill_grad ARGS((struct linsys *,struct hess_verlist *,REAL*,REAL *));
int add_attribute ARGS((int,char*,int,int,int*,int,struct expnode *));
int find_attribute ARGS((int,char*));
int find_extra ARGS((char *, int *));
int matrix_index ARGS((REAL**,int));
int exec_commands ARGS((FILE *,char *));
void *mac_exec_commands ARGS((FILE *));
void push_fd ARGS((FILE *,char *));
void pop_fd ARGS((void));
facet_id get_vertex_facet ARGS((vertex_id));
facet_id get_vertex_first_facet ARGS((vertex_id));
facet_id get_next_vertex_facet ARGS((vertex_id,facet_id));
facet_id get_simplex_next_vertex_facet ARGS((vertex_id,facet_id));
void macro_init ARGS((void));
REAL ** mat2d_setup ARGS((REAL**,REAL*,int,int));
REAL *** mat3d_setup ARGS((REAL***,REAL*,int,int,int));
REAL **** mat4d_setup ARGS((REAL****,REAL*,int,int,int,int));
void zerohess ARGS((struct qinfo *));
void get_facet_normal ARGS((facet_id,REAL*));
int get_toggle_value ARGS((int));
REAL user_attribute ARGS((element_id));
void force_normalization ARGS((void));
void insert_vertex_edge ARGS((vertex_id,edge_id));
void remove_vertex_edge ARGS((vertex_id,edge_id));
void insert_vertex_facet ARGS((vertex_id,facet_id));
void remove_vertex_facet ARGS((vertex_id,facet_id));
void catfulltext ARGS((char*));
int identcase ARGS((char*));
int eliminate_facet ARGS((facet_id));
int string_eliminate_facet ARGS((facet_id));
REAL quantity_attribute ARGS(( element_id, int ));
REAL instance_attribute ARGS(( element_id, int ));
int kb_checksum ARGS((char *,int));
void apply_quantity ARGS((element_id,int));
void unapply_quantity ARGS((element_id,int));
void read_instance_attr ARGS(( int ));
int read_named_quantity ARGS((void));
DY_OFFSET dy_calloc ARGS((int,int));
DY_OFFSET dy_realloc ARGS((DY_OFFSET,int,int));
void dy_free ARGS((DY_OFFSET));
void dump_method_specs ARGS(( int ));
void read_method_attr ARGS(( int ));
void calc_periods ARGS((int));
int read_method_instance ARGS((void));
int add_standard_quantity ARGS((char *,REAL));
int new_method_instance ARGS((char*,char*));
int attach_method ARGS(( int, char *));
int attach_method_num ARGS(( int, int));
void apply_method ARGS(( element_id , char *));
void apply_method_num ARGS(( element_id , int));
void unapply_method ARGS(( element_id , int));
int rebody ARGS((void));
int merge_bodies ARGS((void));
int get_body_valence ARGS((body_id ));
int get_vertex_evalence ARGS((vertex_id ));
int get_vertex_fvalence ARGS((vertex_id ));
void make_vfacet_lists ARGS((void));
void make_bfacet_lists ARGS((void));
void make_vedge_lists ARGS((void));
REAL dirichlet ARGS((int));
REAL sobolev ARGS((int));
int unstar ARGS((facetedge_id));
void reduce_string ARGS((char *)); 
REAL vertex_angle ARGS((vertex_id));
void fix_ctm ARGS((REAL**,REAL,REAL));
void my_exit ARGS((int));
void reverse_orientation_edge ARGS((edge_id));
void reverse_orientation_facet ARGS((facet_id));
int dissolve_vertex ARGS((vertex_id));
int dissolve_edge ARGS((edge_id));
int dissolve_facet ARGS((facet_id));
int dissolve_body ARGS((body_id));
REAL vertex_sq_mean_curvature ARGS((vertex_id));
REAL vertex_mean_curvature ARGS((vertex_id));
void burchard ARGS((int));
void do_gfile ARGS((int,char*));
int mat_simplify ARGS((REAL***,int));
void transform_gen_expr ARGS((char *));
void generate_transforms ARGS((int));
void read_transform_generators ARGS((int));
int const_expr ARGS((char *,REAL *));
REAL wedge_angle ARGS((vertex_id));
void begin_normal_motion ARGS((void));
void end_normal_motion ARGS((void));
REAL gray_level ARGS((float *));
void  metric_form_to_vector ARGS((REAL*,REAL*));
void end_geomview_object ARGS((void));
void calc_quant_grads ARGS((int));
int simplex_element_id_edges ARGS((REAL));
void quantity_init ARGS((void)); 
int new_quantity ARGS((char *,int));
void add_quantity ARGS((element_id,char*,char*));
REAL calc_quants ARGS((int)); 
void graph_edge_transforms ARGS(( struct graphdata *, edge_id ));
void graph_facet_transforms ARGS(( struct graphdata *, facet_id ));
void other_stuff ARGS((struct treenode *,int*,int*,element_id,REAL*,struct locallist_t*));
void more_other_stuff ARGS((struct treenode *,int*,int*,element_id,REAL*,struct locallist_t*));

void ask_wrap_display ARGS((void));
void print_attr ARGS(( struct treenode *, char *));
void print_set_attr ARGS(( struct treenode *, char *));
void set_print ARGS((struct treenode *, char *, char *,int));
void binary_print ARGS(( struct treenode *, int, int, char *, int));
int lookup_global ARGS((char*));
int lookup_perm_global ARGS((char*));
void klein_area_grad ARGS((REAL **,REAL**));
REAL klein_area ARGS((REAL**));
void klein_length_grad ARGS((REAL*,REAL*,REAL*,REAL*));
REAL klein_length ARGS((REAL*,REAL*));
void  geomview_start ARGS((void));
void  geomview_facet ARGS((struct graphdata *, facet_id));
void  geomview_edge ARGS((struct graphdata *, edge_id));
void  geomview_end ARGS((void));
void tree_copy ARGS(( struct expnode *, struct treenode *));
void perm_tree_copy ARGS(( struct expnode *, struct treenode *));
void conf_edge_curv_energy ARGS((void));
void conf_edge_curv_force ARGS((void));
REAL dihedral ARGS((edge_id));
void clear_symtable ARGS((void));
void clear_globals ARGS((void));
int add_global ARGS((char *));
int add_perm_global ARGS((char *));
char *keywordname ARGS((int));
void subtree_swap ARGS((int*,int*));
int begin_scope ARGS((void));
void end_scope ARGS((void));
void set_scope ARGS((int));
struct sym * symbol_add ARGS((char*,int));
struct sym *symbol_lookup ARGS((char*));
vertex_id void_test ARGS((vertex_id *,int));
char *tokname ARGS((int));
void update_aggr ARGS((int ,REAL *,REAL ));
void hessian_init ARGS((struct linsys *,REAL **));
void hessian_fill ARGS((struct linsys *,REAL **));
void find_hess_entry ARGS((struct linsys *, struct hess_verlist*,
                 struct hess_entry *[MAXCOORD][MAXCOORD]));
void fill_hess_entry ARGS((struct linsys *, vertex_id,REAL**));
int find_mixed_entry ARGS((struct linsys *, struct hess_verlist*,
    struct hess_verlist* ,struct hess_entry *[MAXCOORD][MAXCOORD]));
void fill_mixed_entry ARGS((struct linsys *, vertex_id,vertex_id, REAL **)); 
int find_hess_entries ARGS((struct linsys *, struct hess_verlist*,
        struct hess_verlist*, 
        struct hess_entry *[MAXCOORD][MAXCOORD],
        struct hess_entry *[MAXCOORD][MAXCOORD],
        struct hess_entry *[MAXCOORD][MAXCOORD]));

void area_hessian ARGS((struct linsys *,REAL *));
void calc_quant_hess ARGS((struct linsys *,int,int,REAL *));
void m_calc_quant_hess ARGS((int,int,REAL *));
void m_fix_hess ARGS((struct linsys *S));
void difference_hessian ARGS((struct linsys *,struct hess_verlist*,REAL *));
void edge_energy_hessian ARGS((struct linsys *,REAL *));
void simplex_hessian ARGS((struct linsys *,REAL *));
void simplex_facet_hessian ARGS((struct linsys *,REAL *));
void simplex_edge_hessian ARGS((struct linsys *,edge_id,REAL**,REAL****));
void edge_constr_hessian ARGS((struct linsys *,edge_id,REAL**,REAL****));
int body_hessian ARGS((struct linsys *,REAL*));
void tree_exec ARGS(( struct treenode *));
void letter_command ARGS((int));
void pop_commandfd ARGS((void));
void push_commandfd ARGS((FILE*,char*));
void pop_datafd ARGS((void));
void push_datafd ARGS((FILE*,char*));
void exec_file ARGS((FILE*,char*));
void unput_tok ARGS((void));
void unput_string ARGS((char*));
void set_f_phase_density ARGS((facet_id));
void set_e_phase_density ARGS((edge_id));
int bdry_basis ARGS((vertex_id,REAL**));
int constr_basis ARGS((vertex_id,REAL**));
void  sp_factor ARGS((struct linsys *));
void stability_test ARGS((void));
void mobility_cleanup ARGS((void));
void mobility_mult ARGS((REAL*));
void mobility_setup ARGS((void));
void approx_curv_calc ARGS((int));
void approx_curvature ARGS((void));
int new_popverst ARGS((vertex_id,int));
void phase_initialize ARGS((char *));
void check_vertex_fe ARGS((vertex_id));
void information ARGS((void));
void show_volumes ARGS((void));
int set_parameters ARGS((void));
int minus_type ARGS((int));
void string_fixup ARGS((void));
void runge_kutta ARGS((void));
void autopop_init ARGS((void));
void autopop_cleanup ARGS((void));
void autopop_pop ARGS((void));
void autochop_chop ARGS((void));
void autopop_detect ARGS((REAL));
vertex_id find_other_vertex ARGS((vertex_id *,int,vertex_id));
void simplex_delaunay_test ARGS((void));
void push_face ARGS((vertex_id *));
int pop_face ARGS((vertex_id *));
void end_face_stack ARGS((void));
void init_face_stack ARGS((int));
int simplex_equiangulate ARGS((void));
void calc_simplex_edge_force ARGS((edge_id));
int kernel_basis ARGS((REAL**,REAL**,int,int));
int kernel_basis_rows ARGS((REAL**,REAL**,int,int));
void tr_mat_mul ARGS((REAL**,REAL**,REAL**,int,int,int));
void mat_mul_tr ARGS((REAL**,REAL**,REAL**,int,int,int));
void  mat_tsquare ARGS((REAL**,REAL**,int,int));
void calc_simplex_edge_energy ARGS((edge_id));
void exterior_product ARGS((REAL **,REAL *,int,int));
int binom_coeff ARGS((int,int));
void hi_dim_graph ARGS((void));
void recalc ARGS((void));
void reset_conj_grad ARGS((void));
void kusner_energy ARGS((void));
void kusner_force ARGS((void));
void sqgauss_energy ARGS((void));
void sqgauss_force ARGS((void));
int prompt ARGS((char*,char*,int));
#ifdef USE_READLINE /* CSL */
void save_readline_history ARGS((void));
#endif
void update_display ARGS((void));
void local_update_display ARGS((void));
void set_spinr ARGS((REAL));
void set_spinl ARGS((REAL));
void set_tipup ARGS((REAL));
void set_tipdown ARGS((REAL));
void set_clockwise ARGS((REAL));
void set_counterclockwise ARGS((REAL));
void set_zoom ARGS((REAL));
void skinny_histogram ARGS((void));
int skinny ARGS((REAL));
int get_edge_valence ARGS((edge_id));
int get_facet_valence ARGS((edge_id));
void alice ARGS((void));
void sqcurve_force_string ARGS((vertex_id));
void sqcurve_force_string_end ARGS((void));
void sqcurve_energy_string ARGS((vertex_id));
void sqcurve_energy_string_init ARGS((void));
void bad_function ARGS((void));
void sqcurve_force_init ARGS((void));
void sqcurve_energy_init ARGS((void));
void sqcurve_energy ARGS((vertex_id*, REAL (*)[MAXCOORD])); 
void sqcurve_force ARGS((vertex_id*,edge_id*,REAL(*)[MAXCOORD])); 
void sqcurve_energy_end ARGS((void));
void sqcurve_force_end ARGS((void));
void top_dump ARGS((FILE *));
void bottom_dump ARGS((FILE *));
void vertex_dump ARGS((vertex_id,FILE *));
void edge_dump ARGS((edge_id,FILE *));
void facet_dump ARGS((facet_id,FILE *));
void facetedge_dump ARGS((facetedge_id,FILE *));
void body_dump ARGS((body_id,FILE *));
WRAPTYPE torus_inverse ARGS((WRAPTYPE));
WRAPTYPE torus_compose ARGS((WRAPTYPE,WRAPTYPE));
void torus_wrap ARGS((REAL *,REAL *,WRAPTYPE));
void torus_form_pullback ARGS((REAL *,REAL *,REAL *,WRAPTYPE));
WRAPTYPE group_inverse ARGS((WRAPTYPE));
WRAPTYPE group_compose ARGS((WRAPTYPE,WRAPTYPE));
void group_wrap ARGS((REAL *,REAL *,WRAPTYPE));
void group_form_pullback ARGS((REAL *,REAL *,REAL *,WRAPTYPE));
void print_matrix ARGS(( REAL **, int , int ));
REAL simplex_energy_metric ARGS((vertex_id*,REAL * *));
void simplex_force_metric ARGS((vertex_id *,REAL**, REAL,REAL **));
void gauss_setup ARGS((void));
void simplex_grad_l ARGS((void));
void end_hash_table ARGS((void));
void rehash ARGS((void));
void init_hash_table ARGS((void));
void check_orientation ARGS((struct simplex *,int));
void refine_simplex_init ARGS((void));
void refine_simplex ARGS((int,int *,struct divedge *,struct simplex *));
void refine_all_simplices ARGS((void));
vertex_id simplex_edge_divide ARGS((vertex_id,vertex_id));
int poponest ARGS((vertex_id,int));
void free_discards ARGS((int));
int find_vertex_to_pop ARGS((void));
void puff ARGS((void));
REAL splinepoly ARGS((int,REAL));
REAL splinederiv ARGS((int,REAL));
void spline_partial ARGS((int *,REAL,int,REAL *));
void spline_partial_t ARGS((int *,REAL,REAL *));
void dump_buff ARGS((char*,size_t));
int  command ARGS((char *,int));
void newcommand ARGS((char *));
void new_history ARGS((char *));
int old_history ARGS((char *));
int  qqparse ARGS((void));
#ifdef MEMSTRINGS
char *kb_calloc ARGS((size_t,size_t,char*,size_t));
char *KB_realloc ARGS((char*,size_t,char*,size_t));
char *kb_temp_calloc ARGS((size_t,size_t,char*,size_t));
char *kb_temp_realloc ARGS((char*,size_t,char*,size_t));
#else
char *kb_calloc ARGS((size_t,size_t));
char *KB_realloc ARGS((char*,size_t));
char *kb_temp_calloc ARGS((size_t,size_t));
char *kb_temp_realloc ARGS((char*,size_t));
#endif
void temp_free ARGS((char *));
void temp_free_all ARGS((void));
void cg_direction ARGS((void));
void cg_calc_gamma ARGS((void));
void simplex_facet_average ARGS((facet_id,int));
void facet_average ARGS((facet_id,int));
void edge_average ARGS((edge_id,int));
void recalc_verts ARGS((void));
void grule ARGS((int , REAL *, REAL *));
void read_facet_edges ARGS((void));
void read_faces ARGS((void));
void read_edges ARGS((void));
void read_vertices ARGS((void));
void read_bodies ARGS((void));
int read_quantity ARGS((void));
int read_const ARGS((REAL *));
void lowbound ARGS((void));
void ridge_histogram ARGS((void));
int collapse_check ARGS((void));
#ifndef TCPP
int vvvvcomp ARGS((struct vvvv *,struct vvvv *));
#endif
void End_OOGL ARGS((void ));
void End_geomview ARGS((void ));
void UpdateOOGL ARGS((void ));
void Begin_OOGL ARGS((void ));
void Begin_geomview ARGS((char*));
void softimage ARGS((void ));
void constraint_init ARGS((struct constraint *));
void constraint_free ARGS((struct constraint *));

REAL find_flux ARGS((facet_id));
int is_constant ARGS((int));
void free_expr ARGS((struct expnode *));
void perm_free_expr ARGS((struct expnode *));
void startup ARGS((char *));
void reset_view ARGS((void));
void read_parameter ARGS((void));
void read_transforms ARGS((int));
void zoom_vertex ARGS((vertex_id,REAL));
REAL distance ARGS((vertex_id,vertex_id));
void merge_collapsed_facets ARGS((void));
void constr_vol_grad_q ARGS((edge_id));
void homothety ARGS((void));
void ex_fold ARGS((struct treenode *));
void fold_recur ARGS((struct treenode *, int *));
int yybegin ARGS((void));
void yylex_init ARGS((void));
int yyerror ARGS((char *));
int yyparse ARGS((void));
int  yylook ARGS((void));
int  yywrap ARGS((void));
int yylex ARGS((void));
int yyreject ARGS((void));
int gettok ARGS((int));
int  kb_input ARGS((void));
void rawunput ARGS((int));
int  macro ARGS((void));
void record_macro ARGS((void));
void fe_reorder ARGS((edge_id));
void pix_start ARGS((void));
void pix_facet ARGS((struct graphdata *,facet_id));
void pix_end ARGS((void));
void constr_edge_force_q ARGS((edge_id));
void restore_vertex ARGS((vertex_id,struct oldcoord *,int));
REAL normal_change_check ARGS((void));
FILE *path_open ARGS((char *,int));
void fil_finish ARGS((void));
void fil_facet ARGS((struct tsort *));
void fil_edge ARGS((struct tsort *));
void fil_init ARGS((void));
void ps_finish ARGS((void));
void ps_facet ARGS((struct tsort *));
void ps_edge ARGS((struct tsort *));
void ps_init ARGS((void));
void display_file ARGS((int));
void graph_help ARGS((void));
void main_help ARGS((void));
REAL edge_grav_density ARGS((edge_id));
int facet_body_check ARGS((void));
int facetedge_check ARGS((int));
int list_check ARGS((void));
int run_checks ARGS((void));
int pop_vertex ARGS((vertex_id,int));
int kraynik_pop ARGS((vertex_id,int));
int popfilm ARGS((void));
void face_triangulate ARGS((facet_id,int));
void file_wulff ARGS((REAL *,REAL *));
void lens_wulff ARGS((REAL *,REAL *));
void hemi_wulff ARGS((REAL *,REAL *));
int curtest_facet ARGS((facet_id));
int curtest_edge ARGS((edge_id,facetedge_id,facetedge_id));
void curtest ARGS((void));
void fix_volconst ARGS((void));
element_id upgrade ARGS((element_id));
facet_id dup_facet ARGS((facet_id));
body_id dup_body ARGS((body_id));
REAL estimate_decrease ARGS((void));
void constr_edge_content_q ARGS((edge_id));
void constr_edge_energy_q ARGS((edge_id));
void tordup ARGS((int));
void add_outside ARGS((void));
REAL calc_content ARGS((int));
void local_calc_content ARGS((int));
int equal_constr ARGS((element_id ,element_id));
void bdry_spring_energy ARGS((edge_id));
void constr_spring_energy ARGS((edge_id));
void torus_cells ARGS((void));
void torus_edge_clip ARGS((struct graphdata *,int ));                          
void torus_arc_clip ARGS((struct graphdata *,int ));                          
void null_function ARGS((void));
void diffuse ARGS((void));
int cone_analyze ARGS((struct verfacet *,int));
vertex_id dup_vertex ARGS((vertex_id));
edge_id dup_edge ARGS((edge_id));
void versplit ARGS((facetedge_id ,facetedge_id,int));
int try_prop ARGS((facetedge_id *, facetedge_id,int));
int edgepop_film ARGS((void));
char * print_express ARGS((struct expnode *,int));
void exprint_recur ARGS((struct treenode *,int));
char *kb_strstr ARGS((char *,char *));
int kb_stricmp ARGS((char *,char *));
int kb_strnicmp ARGS((char *,char *, int));
void kb_memmove ARGS((char *,char *,size_t));
int pixdump ARGS((void));
void constr_springs ARGS((edge_id));
void save_coords ARGS((struct oldcoord *,int));
void local_save_coords ARGS((struct oldcoord *,int));
void restore_coords ARGS((struct oldcoord *,int));
void local_restore_coords ARGS((struct oldcoord *,int));
void unsave_coords ARGS((struct oldcoord *,int));
void local_unsave_coords ARGS((struct oldcoord *,int));
void enforce_constraints ARGS((void));
void kb_strupr ARGS((char *));
void b_proj ARGS((struct boundary *,REAL *,REAL * *,int, vertex_id ));
void b_extrapolate ARGS((struct boundary *,REAL *,REAL *,REAL *,REAL *,
   REAL *,vertex_id));
void bdry_force ARGS((edge_id ));
void calc_bdry_force_v ARGS((vertex_id ));
void calc_bdry_force_e ARGS((edge_id ));
void calc_bdry_energy_v ARGS((vertex_id ));
void calc_bdry_energy_e ARGS((edge_id ));
void calc_bdry_content_v ARGS((vertex_id ));
void calc_bdry_content_e ARGS((edge_id ));
void calc_force ARGS((void ));
void local_calc_force ARGS((void ));
void calc_energy ARGS((void));
void local_calc_energy ARGS((void));
void calc_pressure ARGS((void ));
void display ARGS((void ));
int constr_proj ARGS((int ,int ,struct constraint * *,REAL *,REAL *,
   REAL *,int *,int,vertex_id));
int constr_proj_matrix ARGS(( vertex_id, REAL ** ));
int constr_proj_matrix_wall ARGS(( vertex_id, REAL ** ));
int project_v_constr ARGS((vertex_id,int,int ));
void calc_constr_force_v ARGS((vertex_id ));
void calc_constr_force_e ARGS((edge_id ));
void calc_constr_energy_v ARGS((vertex_id ));
void calc_constr_energy_e ARGS((edge_id ));
void calc_constr_content_v ARGS((vertex_id ));
void calc_constr_content_e ARGS((edge_id ));
void dump ARGS((void ));
void do_dump ARGS((char *));
REAL eval ARGS((struct expnode *,REAL *,element_id,struct eval_frame*));
void eval_all ARGS((struct expnode *,REAL *,int,REAL *,REAL *,element_id));
void eval_second ARGS((struct expnode *,REAL *,int,REAL *,REAL *,
 REAL**,element_id));
REAL tree_eval ARGS((struct treenode *,REAL *));
REAL eval_deriv ARGS((struct expnode *,REAL *,int ));
REAL tree_eval_deriv ARGS((struct treenode *,REAL *,int ));
int exparse ARGS((int ,struct expnode *,int));
void calc_simplex_forces ARGS((facet_id));
void calc_simplex_energy ARGS((facet_id));
void calc_simplex_volume ARGS((facet_id));
void facet_force_l ARGS((facet_id ));
void facet_energy_l ARGS((facet_id,int));
void facet_force_l_hi_d ARGS((facet_id ));
void facet_energy_l_hi_d ARGS((facet_id));
void facet_volume_l ARGS((facet_id ));
void film_grad_l ARGS((void ));
void film_bdry_grad ARGS((void ));
void film_constr_grad ARGS((void ));
void facet_force_q ARGS((facet_id ));
void facet_energy_q ARGS((facet_id,int ));
void facet_volume_q ARGS((facet_id ));
void film_grad_q ARGS((void ));
REAL tq7_integral ARGS((REAL (*)(REAL,REAL)));
REAL intpoly6 ARGS((int ,REAL ,REAL ));
REAL intpoly6part ARGS((int ,int ,REAL ,REAL ));
REAL vintzf ARGS((REAL ,REAL ));
void vcoeff_init ARGS((void ));
void calc_volgrads ARGS((int));
void local_calc_volgrads ARGS((int));
void pressure_forces ARGS((void));
void calc_lagrange ARGS((void));
void lagrange_adjust ARGS((void));
int local_lagrange_adjust ARGS((void));
void volume_restore ARGS((REAL,int));
void local_volume_restore ARGS((REAL,int));
int graphgen ARGS((void ));
void plain_facets ARGS((void ));
void plain_edges ARGS((void ));
void bare_edges ARGS((void ));
void triple_edges ARGS((void ));
void torus_clip ARGS((struct graphdata *,int, facet_id ));
int bfcomp ARGS((struct bodyface *,struct bodyface *));
void torus_bodies ARGS((void ));
void reset_web ARGS((void ));
void initialize ARGS((void));
void read_periods ARGS((void ));
void read_display_periods ARGS((void ));
void wulff_initialize ARGS((char *));
int  read_boundary ARGS((void));
int  read_constraint ARGS((void));
void read_surface_energy ARGS((void));
void iterate ARGS((void ));
void fix_vertices ARGS((void ));
void move_vertices ARGS((int,REAL ));
void local_move_vertices ARGS((int,REAL ));
void jiggle ARGS((void ));
void element_id_jiggle ARGS((void ));
REAL gaussian ARGS((void ));
void nrerror ARGS((char *));
void matcopy ARGS((REAL * *,REAL * *,int ,int ));
REAL **perm_matrix2 ARGS((int,int));
#ifdef MEMSTRINGS
REAL * *kb_dmatrix ARGS((int ,int ,int ,int,char*,int ));
REAL * * * kb_dmatrix3 ARGS((int ,int ,int,char*,int ));
REAL * * * * kb_dmatrix4 ARGS((int ,int ,int, int,char*,int ));
REAL * *kb_temp_dmatrix ARGS((int ,int ,int ,int,char*,int ));
REAL * * * kb_temp_dmatrix3 ARGS((int ,int ,int,char*,int ));
REAL * * * * kb_temp_dmatrix4 ARGS((int ,int ,int, int,char*,int ));
#else
REAL * *kb_dmatrix ARGS((int ,int ,int ,int ));
REAL * * * kb_dmatrix3 ARGS((int ,int ,int ));
REAL * * * * kb_dmatrix4 ARGS((int ,int ,int, int ));
REAL * *kb_temp_dmatrix ARGS((int ,int ,int ,int ));
REAL * * * kb_temp_dmatrix3 ARGS((int ,int ,int ));
REAL * * * * kb_temp_dmatrix4 ARGS((int ,int ,int, int ));
#endif
REAL *** matrix3_reorder ARGS((REAL***,int,int,int));
int *ivector ARGS((int ,int ));
REAL *vector ARGS((int ,int ));
void free_ivector ARGS((int *,int ,int ));
void free_vector ARGS((REAL *,int ,int ));
void free_matrix ARGS((REAL * *));
void free_matrix3 ARGS((REAL * * *));
void free_matrix4 ARGS((REAL * * * *));
void free_temp_matrix ARGS((REAL * *));
void free_temp_matrix3 ARGS((REAL * * *));
void free_temp_matrix4 ARGS((REAL * * * *));
void vector_add ARGS((REAL*,REAL*,int));
void vector_add_smul ARGS((REAL*,REAL*,REAL,int));
void vector_sub ARGS((REAL*,REAL*,int));
void vnormal ARGS((REAL *,REAL *,REAL *,REAL *));
void cross_prod ARGS((REAL *,REAL *,REAL *));
REAL triple_prod ARGS((REAL *,REAL *,REAL *));
REAL dot ARGS((REAL *,REAL *,int ));
REAL dotf ARGS((float *,float *,int ));
REAL dotdf ARGS((REAL *,float *,int ));
void matvec_mul ARGS((REAL * *,REAL *,REAL *,int ,int ));
void vec_mat_mul ARGS((REAL *,REAL ** ,REAL *,int ,int ));
void mat_mult ARGS((REAL * *,REAL * *,REAL * *,int ,int ,int ));
REAL quadratic_form ARGS((REAL *,REAL **,REAL *,int));
int  mat_inv ARGS((REAL * *,int ));
int  mat_inv_sym ARGS((REAL * *,int ));
int  mat_inv_sparse ARGS((REAL * *,int ));
REAL  determinant ARGS((REAL * *,int ));
REAL  det_adjoint ARGS((REAL * *,int ));
void change_model ARGS((void ));
void linear_to_quad ARGS((void ));
void quad_to_linear ARGS((void ));
edge_id edge_divide ARGS((edge_id ));
void cross_cut ARGS((facetedge_id ,facetedge_id ));
void painter_start ARGS((void ));
void painter_facet ARGS((struct graphdata *,facet_id ));
void painter_end ARGS((void ));
int in_back ARGS((struct tsort *,struct tsort *));
int separating_plane ARGS((struct tsort *,struct tsort *,int));
int separating_line ARGS((struct tsort *,struct tsort *));
void painter_edge ARGS((struct graphdata *,edge_id));
int verpop_film ARGS((void ));
void do_save ARGS((void ));
void do_restore ARGS((void ));

int odd4cone_pop ARGS((vertex_id,int));
void set_facet_fe ARGS((facet_id ,facetedge_id ));
vertex_id new_vertex ARGS((REAL *,element_id));
edge_id new_edge ARGS((vertex_id ,vertex_id,element_id ));
facet_id new_facet ARGS((void ));
body_id new_body ARGS((void ));
facetedge_id new_facetedge ARGS((facet_id ,edge_id ));
REAL get_edge_length ARGS((edge_id ));
REAL get_facet_pressure ARGS((facet_id ));
#ifndef elptr
struct element *elptr ARGS((element_id ));
#endif
void extend ARGS((int,int));
void expand ARGS((int,int ));
void unfree_element ARGS((element_id));
int generate_all ARGS((int ,element_id *,element_id *));
void memory_report ARGS((void ));
void reset_skeleton ARGS((void ));
void vgrad_init ARGS((int ));
void vgrad_end ARGS((void ));
struct volgrad *get_vertex_vgrad ARGS((vertex_id));
void set_vertex_vgrad ARGS((vertex_id,struct volgrad*));
struct volgrad *get_next_vgrad ARGS((struct volgrad *));
struct volgrad *new_vgrad ARGS((void ));
struct volgrad *get_bv_vgrad ARGS((int ,vertex_id ));
struct volgrad *get_bv_new_vgrad ARGS((int ,vertex_id ));
element_id new_element ARGS((int,element_id,element_id));
void free_element ARGS((element_id ));
void edge_force_l ARGS((edge_id ));
void edge_energy_l ARGS((edge_id ));
void edge_area_l ARGS((edge_id ));
void edge_force_l_metric ARGS((edge_id ));
void edge_energy_l_metric ARGS((edge_id ));
void edge_force_q_metric ARGS((edge_id ));
void edge_energy_q_metric ARGS((edge_id ));
void string_grad_l ARGS((void ));
void string_bdry_grad ARGS((void ));
void string_constr_grad ARGS((void ));
REAL interpoly ARGS((int ,REAL ));
REAL interpolyderiv ARGS((int ,REAL ));
void scoeff_init ARGS((void ));
void edge_force_q ARGS((edge_id ));
void edge_energy_q ARGS((edge_id ));
void edge_area_q ARGS((edge_id ));
void string_grad_q ARGS((void ));
void do_show ARGS((void ));
int  view_transform ARGS((char *));
void init_view ARGS((void ));
void resize ARGS((void ));
int old_menu ARGS((char * ));
void extrapolate ARGS((void ));
void save ARGS((void ));
void restore ARGS((char *));
void torvol ARGS((void));
void torvol_project ARGS((int  ));
void refine ARGS((void ));
void local_refine ARGS((void ));
int areaweed ARGS((REAL ));
void area_histogram ARGS((void ));
int edgeweed ARGS((REAL ));
void edge_histogram ARGS((void ));
int eliminate_edge ARGS((edge_id ));
void change_vertex ARGS((facetedge_id ,vertex_id ,vertex_id ,WRAPTYPE));
int articulate ARGS((REAL ));
edge_id edge_refine ARGS((edge_id ));
int equiangulate ARGS((void ));
int ridge_notcher ARGS((REAL ));
void outstring ARGS(( CONST char *));
void erroutstring ARGS((char *));
void getstring ARGS((char *,int));
void kb_error ARGS((int, char *,int ));
void catcher ARGS((int ));
void calc_edge ARGS((edge_id ));
void get_edge_side ARGS((edge_id ,REAL *));
void get_edge_adjust ARGS((edge_id ,REAL *));
REAL calc_vertex_normal ARGS((vertex_id,facetedge_id ,REAL *));
void calc_vertex_smooth_normal ARGS((vertex_id,facetedge_id ,REAL *));
int new_calc_vertex_normal ARGS((vertex_id,REAL **));
int project_vertex_normals ARGS(( vertex_id, REAL **, int ));
int simplex_vertex_normal ARGS((vertex_id,REAL **));
void get_edge_verts ARGS((edge_id ,REAL * *,WRAPTYPE*));
void get_facet_verts ARGS((facet_id ,REAL * *,WRAPTYPE*));
void get_facet_verts_special ARGS((facet_id ,REAL * *,WRAPTYPE*));
void get_facet_verts_q ARGS((facet_id ,REAL * *,WRAPTYPE*));
int verpop_str ARGS((void ));
void dump_force ARGS((void));
void vertex_average ARGS((int));
void hessian_menu ARGS((void));
void hessian_auto ARGS((void));
REAL hessian_seek ARGS((REAL));
REAL hessian_line_seek ARGS((struct linsys *,REAL,REAL*));
void set_facet_body ARGS((facet_id ,body_id ));

int makenode ARGS((NTYPE,NTYPE,NTYPE));

void set_body_fixvol ARGS((body_id,REAL));
facet_id get_next_body_facet ARGS((facet_id));
facet_id get_prev_body_facet ARGS((facet_id));
void set_next_vertex_facet ARGS((vertex_id,facet_id,facet_id));
void set_next_body_facet ARGS((facet_id,facet_id));
void set_prev_body_facet ARGS((facet_id,facet_id));
void set_fe_facet ARGS((facetedge_id ,facet_id ));

#if !defined (INLINE)
/* some functions replaced by macros in serial version */
int get_meth_offset ARGS((int));
char *get_extra ARGS((element_id,int));
char *get_extra_ptr ARGS((element_id,struct extra *));
void set_body_volconst ARGS((body_id,REAL));
void set_fe_edge ARGS((facetedge_id ,edge_id ));
facet_id get_fe_facet ARGS((facetedge_id ));
facetedge_id get_prev_facet ARGS((facetedge_id ));
facetedge_id get_next_facet ARGS((facetedge_id ));
void set_prev_edge ARGS((facetedge_id ,facetedge_id ));
void set_next_edge ARGS((facetedge_id ,facetedge_id ));
void set_prev_facet ARGS((facetedge_id ,facetedge_id ));
void set_next_facet ARGS((facetedge_id ,facetedge_id ));
void set_edge_wrap ARGS((edge_id ,WRAPTYPE  ));
WRAPTYPE get_edge_wrap ARGS((edge_id ));
void set_edge_fe ARGS((edge_id ,facetedge_id ));
facetedge_id get_edge_fe ARGS((edge_id ));
void set_edge_tailv ARGS((edge_id ,vertex_id ));
void set_edge_headv ARGS((edge_id ,vertex_id ));
void set_edge_midv ARGS((edge_id ,vertex_id ));
body_id get_facet_body ARGS((facet_id ));
facetedge_id get_facet_fe ARGS((facet_id ));

void set_attr ARGS((element_id ,ATTR ));
void unset_attr ARGS((element_id ,ATTR ));
edge_id get_fe_edge ARGS((facetedge_id));
facetedge_id get_prev_edge ARGS((facetedge_id ));
facetedge_id get_next_edge ARGS((facetedge_id ));
vertex_id get_edge_tailv ARGS((edge_id ));
vertex_id get_edge_headv ARGS((edge_id ));
edge_id get_next_tail_edge ARGS((edge_id));
edge_id get_next_head_edge ARGS((edge_id));
void set_next_tail_edge ARGS((edge_id,edge_id));
facetedge_id get_body_fe ARGS((body_id));
facetedge_id get_body_facet ARGS((body_id));
void set_body_facet ARGS((body_id,facetedge_id));
REAL get_body_density ARGS((body_id));
REAL get_body_abstotal ARGS((body_id));
REAL get_body_volume ARGS((body_id));
REAL get_body_fixvol ARGS((body_id));
REAL  get_body_pressure ARGS((body_id));
REAL get_body_volconst ARGS((body_id));
void set_body_density ARGS((body_id,REAL));
void set_body_pressure ARGS((body_id,REAL));
facetedge_id get_vertex_fe ARGS((vertex_id));
  
#endif

#ifdef  __cplusplus
}
#endif
