/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __HANDLE_H
#define __HANDLE_H

//--- project includes ---
#include "handle_exception.h"

/*!
  \class T_Handle
  \brief Template class for a handle/ref. counted pointer

  Extended version of the example in Stroustrup, p. 783
*/
template <typename T>
class T_Handle
{
 private:
  T* m_rep;
  int* m_count;
  
 public:
  T_Handle(T*);
  T_Handle(const T_Handle&);
  ~T_Handle();

  T_Handle& operator=(const T_Handle&);
  inline T* operator->() {return m_rep;};
  inline T& operator*(){return *m_rep;};
  //void destroy();
};

#include "handle.hpp"

#endif // __HANDLE_H
