/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include <boost/version.hpp>
#include <boost/version.hpp>
#include <boost/python.hpp>
#include "Foundation/Rng.h"

namespace esys
{
  namespace lsm
  {
    void seedDefaultRng(unsigned int seed)
    {
      rng::s_zeroOneUniform.seed(seed);
    }
    
    using boost::python::arg;
    void exportRng()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      #if (BOOST_VERSION / 100000 >= 1) && (BOOST_VERSION / 100 % 1000 >= 34) 
        boost::python::docstring_options doc_str_opt(true,false);
      #endif
      boost::python::def(
        "seedDefaultRng",
        &seedDefaultRng,
        ( arg("seed")=1234567891 ),
        "Seeds the default C{[0,1]} uniform pseudo-random number generator.\n"
        "@type seed: int\n"
        "@kwarg seed: unsigned integer seed value."
      );
    }
  }
}
