/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner.formats;

import gnu.bioinformatics.jaligner.util.Alignment;

public class Pair {
    private static final int NAME_WIDTH = 13;
    private static final int POSITION_WIDTH = 6;
    private static final int SEQUENCE_WIDTH = 50;
    private static final String NEW_LINE = "\n";
    private static final String BLANK = " ";

    public static String format(Alignment alignment) {
        char[] sequence1 = alignment.getSequence1();
        char[] sequence2 = alignment.getSequence2();
        char[] markup = alignment.getMarkup();
        int length = sequence1.length > sequence2.length ? sequence2.length : sequence1.length;
        String name1 = Pair.adjustName(alignment.getName1());
        String name2 = Pair.adjustName(alignment.getName2());
        StringBuffer buffer = new StringBuffer();
        StringBuffer preMarkup = new StringBuffer();
        int j = 0;
        while (j < 21) {
            preMarkup.append(BLANK);
            ++j;
        }
        int position1 = 1 + alignment.getOffset1();
        int position2 = 1 + alignment.getOffset2();
        int i = 0;
        while (i * 50 < length) {
            int oldPosition1 = position1;
            int oldPosition2 = position2;
            int line = (i + 1) * 50 < length ? (i + 1) * 50 : length;
            char[] subsequence1 = new char[line - i * 50];
            char[] subsequence2 = new char[line - i * 50];
            char[] submarkup = new char[line - i * 50];
            int j2 = i * 50;
            int k = 0;
            while (j2 < line) {
                subsequence1[k] = sequence1[j2];
                subsequence2[k] = sequence2[j2];
                submarkup[k] = markup[j2];
                char c1 = subsequence1[k];
                char c2 = subsequence2[k];
                if (c1 == c2) {
                    ++position1;
                    ++position2;
                } else if (c1 == '-') {
                    ++position2;
                } else if (c2 == '-') {
                    ++position1;
                } else {
                    ++position1;
                    ++position2;
                }
                ++j2;
                ++k;
            }
            buffer.append(name1);
            buffer.append(BLANK);
            buffer.append(Pair.adjustPosition(new Integer(oldPosition1).toString()));
            buffer.append(BLANK);
            buffer.append(subsequence1);
            buffer.append(BLANK);
            buffer.append(Pair.adjustPosition(new Integer(position1 - 1).toString()));
            buffer.append(NEW_LINE);
            buffer.append(preMarkup);
            buffer.append(submarkup);
            buffer.append(NEW_LINE);
            buffer.append(name2);
            buffer.append(BLANK);
            buffer.append(Pair.adjustPosition(new Integer(oldPosition2).toString()));
            buffer.append(BLANK);
            buffer.append(subsequence2);
            buffer.append(BLANK);
            buffer.append(Pair.adjustPosition(new Integer(position2 - 1).toString()));
            buffer.append(NEW_LINE);
            buffer.append(NEW_LINE);
            ++i;
        }
        return buffer.toString();
    }

    private static String adjustName(String name) {
        StringBuffer buffer = new StringBuffer();
        if (name.length() > 13) {
            buffer.append(name.substring(0, 13));
        } else {
            buffer.append(name);
            int j = buffer.length();
            while (j < 13) {
                buffer.append(BLANK);
                ++j;
            }
        }
        return buffer.toString();
    }

    private static String adjustPosition(String position) {
        StringBuffer buffer1 = new StringBuffer();
        StringBuffer buffer2 = new StringBuffer();
        if (position.length() > 6) {
            buffer1.append(position.substring(position.length() - 6, position.length()));
        } else {
            buffer1.append(position);
        }
        int j = 0;
        int n = 6 - buffer1.length();
        while (j < n) {
            buffer2.append(BLANK);
            ++j;
        }
        return buffer2.append(buffer1).toString();
    }

    public static void print(Alignment alignment) {
        System.out.println(Pair.format(alignment));
    }
}

