/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.soap;

import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class FileList {
    private String flist = null;
    private String directories = null;
    private Vector vdir;

    public FileList(JembossParams mysettings, String fileRoot, String dir) throws JembossSoapException {
        PrivateRequest eRun;
        if (mysettings.getDebug()) {
            System.out.println("FileList: start " + fileRoot + " :/: " + dir);
        }
        Vector<String> params = new Vector<String>();
        String options = "fileroot=" + fileRoot;
        params.addElement(options);
        params.addElement(dir);
        try {
            eRun = new PrivateRequest(mysettings, "EmbreoFile", "directory_shortls", params);
        }
        catch (JembossSoapException e) {
            throw new JembossSoapException("Directory listing call failed: " + e.getMessage());
        }
        this.flist = eRun.getHash().get("list").toString();
        this.directories = eRun.getHash().get("dirlist").toString();
        this.vdir = new Vector();
        StringTokenizer tok = new StringTokenizer(this.directories, "\n");
        while (tok.hasMoreTokens()) {
            this.vdir.add(tok.nextToken());
        }
        if (mysettings.getDebug()) {
            System.out.println("FileList: done");
        }
    }

    public Vector fileVector() {
        Vector<String> v = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(this.flist, "\n");
        while (tok.hasMoreTokens()) {
            v.add(tok.nextToken());
        }
        Object[] list = v.toArray();
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            v.set(i, (String)list[i]);
        }
        return v;
    }

    public boolean isDirectory(String d) {
        return this.vdir.contains(d);
    }
}

