/*
// $Id: //open/dev/farrago/src/org/eigenbase/sql/SqlExplainLevel.java#8 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.sql;

/**
 * SqlExplainLevel defines detail levels for EXPLAIN PLAN.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/org/eigenbase/sql/SqlExplainLevel.java#8 $
 */
public enum SqlExplainLevel
    implements SqlLiteral.SqlSymbol
{
    /**
     * Suppress all attributes.
     */
    NO_ATTRIBUTES,

    /**
     * Display only attributes which contribute to the plan output.
     */
    EXPPLAN_ATTRIBUTES,

    /**
     * Display only attributes which contribute to an expression's digest.
     */
    DIGEST_ATTRIBUTES,

    /**
     * Display all attributes, including cost.
     */
    ALL_ATTRIBUTES
}

// End SqlExplainLevel.java
