/*
 * Copyright (c) 2021 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

/**
 * This package contains interfaces for {@link org.eclipse.collections.api.partition.list.PartitionList}.
 * <p>
 *     A PartitionList is the result of splitting a list into two lists based on a Predicate.
 * <p>
 *      This package contains 3 interfaces:
 * <ul>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.list.PartitionList} - a read-only PartitionList API.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.list.PartitionMutableList} - a modifiable PartitionList.
 *     </li>
 *     <li>
 *         {@link org.eclipse.collections.api.partition.list.PartitionImmutableList} - the non-modifiable equivalent interface to {@link org.eclipse.collections.api.partition.list.PartitionMutableList}.
 *     </li>
 * </ul>
 */
package org.eclipse.collections.api.partition.list;
