/*1:*/
#line 6 "./vector_function.cweb"


#include "vector_function.h"

#include <dynlapack.h> 

#include <cmath> 

#include <cstring> 
#include <algorithm> 

#ifdef __MINGW32__
#define __CROSS_COMPILATION__
#endif

#ifdef __MINGW64__
#define __CROSS_COMPILATION__
#endif

#ifdef __CROSS_COMPILATION__
#define M_PI 3.14159265358979323846
#endif

/*2:*/
#line 45 "./vector_function.cweb"

ParameterSignal::ParameterSignal(int n)
:data(new bool[n]),num(n)
{
for(int i= 0;i<num;i++)
data[i]= true;
}

/*:2*/
#line 29 "./vector_function.cweb"
;
/*3:*/
#line 54 "./vector_function.cweb"

ParameterSignal::ParameterSignal(const ParameterSignal&sig)
:data(new bool[sig.num]),num(sig.num)
{
memcpy(data,sig.data,num);
}

/*:3*/
#line 30 "./vector_function.cweb"
;
/*4:*/
#line 64 "./vector_function.cweb"

void ParameterSignal::signalAfter(int l)
{
for(int i= 0;i<std::min(l,num);i++)
data[i]= false;
for(int i= l;i<num;i++)
data[i]= true;
}

/*:4*/
#line 31 "./vector_function.cweb"
;
/*5:*/
#line 74 "./vector_function.cweb"

VectorFunctionSet::VectorFunctionSet(const VectorFunction&f,int n)
:funcs(n),first_shallow(false)
{
for(int i= 0;i<n;i++)
funcs[i]= f.clone();
}

/*:5*/
#line 32 "./vector_function.cweb"
;
/*6:*/
#line 85 "./vector_function.cweb"

VectorFunctionSet::VectorFunctionSet(VectorFunction&f,int n)
:funcs(n),first_shallow(true)
{
if(n> 0)
funcs[0]= &f;
for(int i= 1;i<n;i++)
funcs[i]= f.clone();
}

/*:6*/
#line 33 "./vector_function.cweb"
;
/*7:*/
#line 98 "./vector_function.cweb"

VectorFunctionSet::~VectorFunctionSet()
{
unsigned int start= first_shallow?1:0;
for(unsigned int i= start;i<funcs.size();i++)
delete funcs[i];
}

/*:7*/
#line 34 "./vector_function.cweb"
;
/*8:*/
#line 110 "./vector_function.cweb"

GaussConverterFunction::GaussConverterFunction(VectorFunction&f,const GeneralMatrix&vcov)
:VectorFunction(f),func(&f),delete_flag(false),A(vcov.numRows(),vcov.numRows()),
multiplier(calcMultiplier())
{

calcCholeskyFactor(vcov);
}

/*:8*/
#line 35 "./vector_function.cweb"
;
/*9:*/
#line 122 "./vector_function.cweb"

GaussConverterFunction::GaussConverterFunction(VectorFunction*f,const GeneralMatrix&vcov)
:VectorFunction(*f),func(f),delete_flag(true),A(vcov.numRows(),vcov.numRows()),
multiplier(calcMultiplier())
{

calcCholeskyFactor(vcov);
}


/*:9*/
#line 36 "./vector_function.cweb"
;
/*10:*/
#line 133 "./vector_function.cweb"

GaussConverterFunction::GaussConverterFunction(const GaussConverterFunction&f)
:VectorFunction(f),func(f.func->clone()),delete_flag(true),A(f.A),
multiplier(f.multiplier)
{
}

/*:10*/
#line 37 "./vector_function.cweb"
;
/*11:*/
#line 147 "./vector_function.cweb"

void GaussConverterFunction::eval(const Vector&point,const ParameterSignal&sig,Vector&out)
{
ParameterSignal s(sig);
int i= 0;
while(i<indim()&&!sig[i])
i++;
s.signalAfter(i);

Vector x(indim());
x.zeros();
A.multaVec(x,point);
x.mult(sqrt(2.0));

func->eval(x,s,out);

out.mult(multiplier);
}

/*:11*/
#line 38 "./vector_function.cweb"
;
/*12:*/
#line 167 "./vector_function.cweb"

double GaussConverterFunction::calcMultiplier()const
{
return sqrt(pow(M_PI,-1*indim()));
}

/*:12*/
#line 39 "./vector_function.cweb"
;
/*13:*/
#line 174 "./vector_function.cweb"

void GaussConverterFunction::calcCholeskyFactor(const GeneralMatrix&vcov)
{
A= vcov;

lapack_int rows= A.numRows();
for(int i= 0;i<rows;i++)
for(int j= i+1;j<rows;j++)
A.get(i,j)= 0.0;

lapack_int info;
dpotrf("L",&rows,A.base(),&rows,&info);

}


/*:13*/
#line 40 "./vector_function.cweb"
;

/*:1*/
