/////////////////////////////////////////////////////////////////////////////
// Name:        mediatrc.h
// Purpose:     Media Transcoder Interface
// Author:      Alex Thuering
// Created:     26.04.2008
// RCS-ID:      $Id: mediatrc.h,v 1.11 2013/03/17 18:51:00 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef WX_MEDIA_TRANSCODER_H
#define WX_MEDIA_TRANSCODER_H

#include "mediaenc.h"
#include "wx/dynarray.h"
#include <vector>

using namespace std;

enum FirstField {
	ffAUTO = -1,
	ffBOTTOM = 0,
	ffTOP = 1
};

class wxMediaTranscoder {
public:
	virtual ~wxMediaTranscoder() {}
	/** Adds input file. */
	virtual bool AddInputFile(const wxString& fileName, const wxString& format = wxT(""), long tsOffset = 0) = 0;
	/** Sets output file and video/audio/subtitle formats. */
	virtual bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, bool ntscFilm, AudioFormat audioFormat,
		SubtitleFormat subtitleFormat, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224,
		int mapFileIdx = -1, int mapStreamIdx = -1) = 0;
	/** Sets output file and video/audio/subtitle formats. */
	virtual bool SetOutputFile(const wxString& fileName, VideoFormat videoFormat, bool ntscFilm, wxArrayInt audioFormats,
		wxArrayInt subtitleFormats, int videoBitrate = 6000, bool vbr = false, int audioBitrate = 224,
		int mapFileIdx = -1, int mapStreamIdx = -1) = 0;
	/** Sets pad values */
	void SetPad(const vector<int>& pad);
	/** Sets crop values */
	void SetCrop(const vector<int>& crop);
	/** Sets interlaced encoding flag */
	void SetInterlaced(bool value);
	/** Sets first field flag (Auto, TFF, BFF) */
	void SetFirstField(FirstField firstField);
	/** Starts transcoding. */
	virtual bool Run(bool& canceled) = 0;
	/** Ends ttanscoding and closes all fiies. */
	virtual void End() = 0;
};

#endif // WX_MEDIA_TRANSCODER_H
