/*
 * Decompiled with CFR 0.152.
 */
package dumphd.util;

import dumphd.util.ByteSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;

public final class FileSource
implements ByteSource {
    public static final int bufferSize = 32768;
    private File file = null;
    private RandomAccessFile raf = null;
    private FileChannel fc = null;
    private ByteBuffer bb = null;
    private int mode = 0;
    private LinkedList<Window> windows = new LinkedList();
    private Window currentWindow = null;
    private long bufferOffset = 0L;
    private boolean bufferLimited = false;
    private int maxPos = 0;
    private boolean pendingWrite = false;

    public FileSource(File source, int mode) throws FileNotFoundException {
        this.file = source;
        this.mode = mode;
        switch (mode) {
            case 0: {
                this.raf = new RandomAccessFile(source, "r");
                break;
            }
            case 2: {
                this.raf = new RandomAccessFile(source, "rw");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode argument");
            }
        }
        this.fc = this.raf.getChannel();
        this.bb = ByteBuffer.allocateDirect(32768);
        this.currentWindow = new Window();
        this.windows.add(this.currentWindow);
    }

    @Override
    public int read(byte[] dst, int offset, int length) throws IOException {
        int transferred = 0;
        while (true) {
            int remaining;
            int currentLimit;
            if (this.maxPos < (currentLimit = this.bb.limit())) {
                currentLimit = this.maxPos;
            }
            if (length <= (remaining = currentLimit - this.bb.position())) {
                this.bb.get(dst, offset, length);
                transferred += length;
                break;
            }
            if (remaining > 0) {
                this.bb.get(dst, offset, remaining);
                offset += remaining;
                length -= remaining;
                transferred += remaining;
            }
            if (this.bb.position() == this.bb.limit()) {
                if (this.bufferLimited) {
                    if (transferred == 0) {
                        transferred = -1;
                        break;
                    }
                } else if (this.pendingWrite) {
                    this.writeBuffer(false);
                } else {
                    this.bb.clear();
                    this.maxPos = 0;
                    this.bufferOffset += 32768L;
                    this.updateLimit();
                    if (this.fc.position() != this.bufferOffset) {
                        this.fc.position(this.bufferOffset);
                    }
                }
            } else {
                long readPos = this.bufferOffset + (long)this.bb.position();
                if (this.fc.position() != readPos) {
                    this.fc.position(readPos);
                }
            }
            this.bb.mark();
            if (this.fc.read(this.bb) == -1) {
                if (transferred != 0) break;
                transferred = -1;
                break;
            }
            this.maxPos = this.bb.position();
            this.bb.reset();
        }
        return transferred;
    }

    @Override
    public int write(byte[] src, int offset, int length) throws IOException {
        int transferred = 0;
        while (true) {
            int newPos;
            int remaining;
            if (length <= (remaining = this.bb.remaining())) {
                this.bb.put(src, offset, length);
                transferred += length;
                this.pendingWrite = true;
                newPos = this.bb.position();
                if (newPos <= this.maxPos) break;
                this.maxPos = newPos;
                break;
            }
            if (remaining > 0) {
                this.bb.put(src, offset, remaining);
                offset += remaining;
                length -= remaining;
                transferred += remaining;
                this.pendingWrite = true;
                newPos = this.bb.position();
                if (newPos > this.maxPos) {
                    this.maxPos = newPos;
                }
            }
            if (this.bufferLimited) {
                if (transferred != 0) break;
                transferred = -1;
                break;
            }
            this.writeBuffer(false);
        }
        return transferred;
    }

    @Override
    public long getPosition() throws IOException {
        return this.bufferOffset + (long)this.bb.position() - this.currentWindow.start;
    }

    @Override
    public void setPosition(long position) throws IOException {
        long tPosition = this.currentWindow.start + position;
        if (tPosition >= this.currentWindow.start && tPosition <= this.currentWindow.end) {
            long newBufferPosition = tPosition - this.bufferOffset;
            if (newBufferPosition >= 0L && newBufferPosition <= (long)this.maxPos) {
                this.bb.position((int)newBufferPosition);
            } else {
                if (this.pendingWrite) {
                    this.writeBuffer(true);
                } else {
                    this.bb.clear();
                    this.maxPos = 0;
                }
                this.fc.position(tPosition);
                this.bufferOffset = tPosition;
                this.updateLimit();
            }
        } else {
            throw new IOException("Seek exceeds window limits");
        }
    }

    @Override
    public void addWindow(long size) throws IOException {
        long start = this.bufferOffset + (long)this.bb.position();
        long end = start + size;
        if (end > this.currentWindow.end) {
            throw new IOException("New window exceeds current window limits");
        }
        this.currentWindow = new Window(start, end);
        this.windows.add(this.currentWindow);
        this.updateLimit();
    }

    @Override
    public void removeWindow() throws IOException {
        if (this.windows.size() <= 1) {
            throw new IOException("No window set");
        }
        this.windows.removeLast();
        this.currentWindow = this.windows.getLast();
        this.updateLimit();
    }

    @Override
    public int windowCount() {
        return this.windows.size() - 1;
    }

    @Override
    public long size() throws IOException {
        long fileSize = this.fc.size();
        if (fileSize < this.currentWindow.end) {
            return fileSize - this.currentWindow.start;
        }
        return this.currentWindow.end - this.currentWindow.start;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        if (this.pendingWrite) {
            this.writeBuffer(true);
        }
        if (this.raf != null) {
            this.raf.close();
        }
        this.bb = null;
        this.fc = null;
        this.raf = null;
        this.currentWindow = null;
        this.windows = null;
    }

    private void writeBuffer(boolean flush) throws IOException {
        if (this.fc.position() != this.bufferOffset) {
            this.fc.position(this.bufferOffset);
        }
        if (flush) {
            if (this.bb.position() != 0) {
                this.bb.position(0);
            }
            if (this.bb.limit() != this.maxPos) {
                this.bb.limit(this.maxPos);
            }
            while (this.bb.hasRemaining()) {
                this.fc.write(this.bb);
            }
            this.pendingWrite = false;
            this.bb.clear();
            this.maxPos = 0;
        } else if (this.bb.position() == 32768) {
            this.bb.flip();
            this.fc.write(this.bb);
            this.pendingWrite = this.bb.hasRemaining();
            this.bb.compact();
            this.maxPos = this.bb.position();
            this.bufferOffset = this.fc.position();
            this.updateLimit();
        } else {
            throw new IllegalStateException("FileSource: Buffer cannot be written when not completely filled, position: " + this.bb.position() + ", bufferSize: " + 32768);
        }
    }

    private void updateLimit() {
        long checkLimit = this.currentWindow.end - this.bufferOffset;
        if (checkLimit <= 32768L) {
            this.bb.limit((int)checkLimit);
            this.bufferLimited = true;
        } else {
            this.bb.limit(32768);
            this.bufferLimited = false;
        }
    }

    private static final class Window {
        public long start = 0L;
        public long end = Long.MAX_VALUE;

        public Window() {
        }

        public Window(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(32);
            sb.append("Window :: start: ");
            sb.append(this.start);
            sb.append(", end: ");
            sb.append(this.end);
            return sb.toString();
        }
    }
}

