//
// Copyright(C) 1993-1996 Id Software, Inc.
// Copyright(C) 1993-2008 Raven Software
// Copyright(C) 2005-2014 Simon Howard
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

#include "doomtype.h"
#include "sounds.h"

// Hexen map music is set dynamically in SNDINFO
musicinfo_t hexen_S_music[HEXEN_NUMMUSIC] = {
    [hexen_mus_hexen] = { "HEXEN", 0 },
    [hexen_mus_hub]   = { "HUB", 0 },
    [hexen_mus_hall]  = { "HALL", 0 },
    [hexen_mus_orb]   = { "ORB", 0 },
    [hexen_mus_chess] = { "CHESS", 0 },
};

sfxinfo_t hexen_S_sfx[] = {
    { "", 0, 0, 0, 0, 0, 0, "" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterNormalDeath" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterCrazyDeath" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterExtreme1Death" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterExtreme2Death" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterExtreme3Death" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterBurnDeath" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericNormalDeath" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericCrazyDeath" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericExtreme1Death" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericExtreme2Death" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericExtreme3Death" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericBurnDeath" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageNormalDeath" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageCrazyDeath" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageExtreme1Death" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageExtreme2Death" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageExtreme3Death" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageBurnDeath" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterPain" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericPain" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMagePain" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterGrunt" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericGrunt" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageGrunt" },
    { "", 32, 0, 1, 0, 0, 2, "PlayerLand" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerPoisonCough" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFighterFallingScream" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerClericFallingScream" },
    { "", 256, 0, 0, 0, 0, 2, "PlayerMageFallingScream" },
    { "", 256, 0, 1, 0, 0, 2, "PlayerFallingSplat" },
    { "", 256, 0, 1, 0, 0, 1, "PlayerFighterFailedUse" },
    { "", 256, 0, 1, 0, 0, 1, "PlayerClericFailedUse" },
    { "", 256, 0, 0, 0, 0, 1, "PlayerMageFailedUse" },
    { "", 36, 0, 1, 0, 0, 2, "PlatformStart" },
    { "", 36, 0, 1, 0, 0, 2, "PlatformStartMetal" },
    { "", 40, 0, 1, 0, 0, 2, "PlatformStop" },
    { "", 32, 0, 1, 0, 0, 2, "StoneMove" },
    { "", 32, 0, 1, 0, 0, 2, "MetalMove" },
    { "", 36, 0, 1, 0, 0, 2, "DoorOpen" },
    { "", 36, 0, 1, 0, 0, 2, "DoorLocked" },
    { "", 36, 0, 1, 0, 0, 2, "DoorOpenMetal" },
    { "", 36, 0, 1, 0, 0, 2, "DoorCloseMetal" },
    { "", 36, 0, 1, 0, 0, 2, "DoorCloseLight" },
    { "", 36, 0, 1, 0, 0, 2, "DoorCloseHeavy" },
    { "", 36, 0, 1, 0, 0, 2, "DoorCreak" },
    { "", 36, 0, 0, 0, 0, 2, "PickupWeapon" },
    { "", 36, 0, 1, 0, 0, 2, "PickupArtifact" },
    { "", 36, 0, 1, 0, 0, 2, "PickupKey" },
    { "", 36, 0, 1, 0, 0, 2, "PickupItem" },
    { "", 36, 0, 0, 0, 0, 2, "PickupPiece" },
    { "", 36, 0, 0, 0, 0, 2, "WeaponBuild" },
    { "", 36, 0, 1, 0, 0, 2, "UseArtifact" },
    { "", 36, 0, 1, 0, 0, 2, "BlastRadius" },
    { "", 256, 0, 1, 0, 0, 2, "Teleport" },
    { "", 30, 0, 1, 0, 0, 2, "ThunderCrash" },
    { "", 80, 0, 1, 0, 0, 2, "FighterPunchMiss" },
    { "", 80, 0, 1, 0, 0, 2, "FighterPunchHitThing" },
    { "", 80, 0, 1, 0, 0, 2, "FighterPunchHitWall" },
    { "", 80, 0, 1, 0, 0, 2, "FighterGrunt" },
    { "", 80, 0, 1, 0, 0, 2, "FighterAxeHitThing" },
    { "", 80, 0, 1, 0, 0, 2, "FighterHammerMiss" },
    { "", 80, 0, 1, 0, 0, 2, "FighterHammerHitThing" },
    { "", 80, 0, 1, 0, 0, 2, "FighterHammerHitWall" },
    { "", 32, 0, 1, 0, 0, 2, "FighterHammerContinuous" },
    { "", 80, 0, 1, 0, 0, 2, "FighterHammerExplode" },
    { "", 80, 0, 1, 0, 0, 2, "FighterSwordFire" },
    { "", 80, 0, 1, 0, 0, 2, "FighterSwordExplode" },
    { "", 80, 0, 1, 0, 0, 2, "ClericCStaffFire" },
    { "", 40, 0, 1, 0, 0, 2, "ClericCStaffExplode" },
    { "", 80, 0, 1, 0, 0, 2, "ClericCStaffHitThing" },
    { "", 80, 0, 1, 0, 0, 2, "ClericFlameFire" },
    { "", 80, 0, 1, 0, 0, 2, "ClericFlameExplode" },
    { "", 80, 0, 1, 0, 0, 2, "ClericFlameCircle" },
    { "", 80, 0, 1, 0, 0, 2, "MageWandFire" },
    { "", 80, 0, 1, 0, 0, 2, "MageLightningFire" },
    { "", 32, 0, 1, 0, 0, 2, "MageLightningZap" },
    { "", 32, 0, 1, 0, 0, 2, "MageLightningContinuous" },
    { "", 30, 0, 1, 0, 0, 2, "MageLightningReady" },
    { "", 80, 0, 1, 0, 0, 2, "MageShardsFire" },
    { "", 36, 0, 1, 0, 0, 2, "MageShardsExplode" },
    { "", 80, 0, 1, 0, 0, 2, "MageStaffFire" },
    { "", 40, 0, 1, 0, 0, 2, "MageStaffExplode" },
    { "", 32, 0, 1, 0, 0, 2, "Switch1" },
    { "", 32, 0, 1, 0, 0, 2, "Switch2" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentSight" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentActive" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentPain" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentAttack" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentMeleeHit" },
    { "", 40, 0, 1, 0, 0, 2, "SerpentDeath" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentBirth" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentFXContinuous" },
    { "", 32, 0, 1, 0, 0, 2, "SerpentFXHit" },
    { "", 32, 0, 1, 0, 0, 2, "PotteryExplode" },
    { "", 32, 0, 1, 0, 0, 2, "Drip" },
    { "", 32, 0, 1, 0, 0, 2, "CentaurSight" },
    { "", 32, 0, 1, 0, 0, 2, "CentaurActive" },
    { "", 32, 0, 1, 0, 0, 2, "CentaurPain" },
    { "", 32, 0, 1, 0, 0, 2, "CentaurAttack" },
    { "", 40, 0, 1, 0, 0, 2, "CentaurDeath" },
    { "", 32, 0, 1, 0, 0, 2, "CentaurLeaderAttack" },
    { "", 32, 0, 1, 0, 0, 2, "CentaurMissileExplode" },
    { "", 1, 0, 1, 0, 0, 2, "Wind" },
    { "", 32, 0, 1, 0, 0, 2, "BishopSight" },
    { "", 32, 0, 1, 0, 0, 2, "BishopActive" },
    { "", 32, 0, 1, 0, 0, 2, "BishopPain" },
    { "", 32, 0, 1, 0, 0, 2, "BishopAttack" },
    { "", 40, 0, 1, 0, 0, 2, "BishopDeath" },
    { "", 32, 0, 1, 0, 0, 2, "BishopMissileExplode" },
    { "", 32, 0, 1, 0, 0, 2, "BishopBlur" },
    { "", 32, 0, 1, 0, 0, 2, "DemonSight" },
    { "", 32, 0, 1, 0, 0, 2, "DemonActive" },
    { "", 32, 0, 1, 0, 0, 2, "DemonPain" },
    { "", 32, 0, 1, 0, 0, 2, "DemonAttack" },
    { "", 32, 0, 1, 0, 0, 2, "DemonMissileFire" },
    { "", 32, 0, 1, 0, 0, 2, "DemonMissileExplode" },
    { "", 40, 0, 1, 0, 0, 2, "DemonDeath" },
    { "", 32, 0, 1, 0, 0, 2, "WraithSight" },
    { "", 32, 0, 1, 0, 0, 2, "WraithActive" },
    { "", 32, 0, 1, 0, 0, 2, "WraithPain" },
    { "", 32, 0, 1, 0, 0, 2, "WraithAttack" },
    { "", 32, 0, 1, 0, 0, 2, "WraithMissileFire" },
    { "", 32, 0, 1, 0, 0, 2, "WraithMissileExplode" },
    { "", 40, 0, 1, 0, 0, 2, "WraithDeath" },
    { "", 32, 0, 1, 0, 0, 2, "PigActive1" },
    { "", 32, 0, 1, 0, 0, 2, "PigActive2" },
    { "", 32, 0, 1, 0, 0, 2, "PigPain" },
    { "", 32, 0, 1, 0, 0, 2, "PigAttack" },
    { "", 40, 0, 1, 0, 0, 2, "PigDeath" },
    { "", 32, 0, 1, 0, 0, 2, "MaulatorSight" },
    { "", 32, 0, 1, 0, 0, 2, "MaulatorActive" },
    { "", 32, 0, 1, 0, 0, 2, "MaulatorPain" },
    { "", 32, 0, 1, 0, 0, 2, "MaulatorHamSwing" },
    { "", 32, 0, 1, 0, 0, 2, "MaulatorHamHit" },
    { "", 32, 0, 1, 0, 0, 2, "MaulatorMissileHit" },
    { "", 40, 0, 1, 0, 0, 2, "MaulatorDeath" },
    { "", 40, 0, 1, 0, 0, 2, "FreezeDeath" },
    { "", 40, 0, 1, 0, 0, 2, "FreezeShatter" },
    { "", 32, 0, 1, 0, 0, 2, "EttinSight" },
    { "", 32, 0, 1, 0, 0, 2, "EttinActive" },
    { "", 32, 0, 1, 0, 0, 2, "EttinPain" },
    { "", 32, 0, 1, 0, 0, 2, "EttinAttack" },
    { "", 40, 0, 1, 0, 0, 2, "EttinDeath" },
    { "", 32, 0, 1, 0, 0, 2, "FireDemonSpawn" },
    { "", 32, 0, 1, 0, 0, 2, "FireDemonActive" },
    { "", 32, 0, 1, 0, 0, 2, "FireDemonPain" },
    { "", 32, 0, 1, 0, 0, 2, "FireDemonAttack" },
    { "", 32, 0, 1, 0, 0, 2, "FireDemonMissileHit" },
    { "", 40, 0, 1, 0, 0, 2, "FireDemonDeath" },
    { "", 32, 0, 1, 0, 0, 2, "IceGuySight" },
    { "", 32, 0, 1, 0, 0, 2, "IceGuyActive" },
    { "", 32, 0, 1, 0, 0, 2, "IceGuyAttack" },
    { "", 32, 0, 1, 0, 0, 2, "IceGuyMissileExplode" },
    { "", 256, 0, 1, 0, 0, 2, "SorcererSight" },
    { "", 256, 0, 1, 0, 0, 2, "SorcererActive" },
    { "", 256, 0, 1, 0, 0, 2, "SorcererPain" },
    { "", 256, 0, 1, 0, 0, 2, "SorcererSpellCast" },
    { "", 256, 0, 1, 0, 0, 4, "SorcererBallWoosh" },
    { "", 256, 0, 1, 0, 0, 2, "SorcererDeathScream" },
    { "", 80, 0, 1, 0, 0, 2, "SorcererBishopSpawn" },
    { "", 80, 0, 1, 0, 0, 2, "SorcererBallPop" },
    { "", 80, 0, 1, 0, 0, 3, "SorcererBallBounce" },
    { "", 80, 0, 1, 0, 0, 3, "SorcererBallExplode" },
    { "", 80, 0, 1, 0, 0, 3, "SorcererBigBallExplode" },
    { "", 256, 0, 1, 0, 0, 2, "SorcererHeadScream" },
    { "", 64, 0, 1, 0, 0, 2, "DragonSight" },
    { "", 64, 0, 1, 0, 0, 2, "DragonActive" },
    { "", 64, 0, 1, 0, 0, 2, "DragonWingflap" },
    { "", 64, 0, 1, 0, 0, 2, "DragonAttack" },
    { "", 64, 0, 1, 0, 0, 2, "DragonPain" },
    { "", 64, 0, 1, 0, 0, 2, "DragonDeath" },
    { "", 32, 0, 1, 0, 0, 2, "DragonFireballExplode" },
    { "", 256, 0, 1, 0, 0, 2, "KoraxSight" },
    { "", 256, 0, 1, 0, 0, 2, "KoraxActive" },
    { "", 256, 0, 1, 0, 0, 2, "KoraxPain" },
    { "", 256, 0, 1, 0, 0, 2, "KoraxAttack" },
    { "", 256, 0, 1, 0, 0, 2, "KoraxCommand" },
    { "", 256, 0, 1, 0, 0, 2, "KoraxDeath" },
    { "", 128, 0, 1, 0, 0, 2, "KoraxStep" },
    { "", 32, 0, 1, 0, 0, 2, "ThrustSpikeRaise" },
    { "", 32, 0, 1, 0, 0, 2, "ThrustSpikeLower" },
    { "", 32, 0, 1, 0, 0, 2, "GlassShatter" },
    { "", 32, 0, 1, 0, 0, 2, "FlechetteBounce" },
    { "", 32, 0, 1, 0, 0, 2, "FlechetteExplode" },
    { "", 36, 0, 1, 0, 0, 2, "LavaMove" },
    { "", 36, 0, 1, 0, 0, 2, "WaterMove" },
    { "", 36, 0, 1, 0, 0, 2, "IceStartMove" },
    { "", 36, 0, 1, 0, 0, 2, "EarthStartMove" },
    { "", 32, 0, 1, 0, 0, 2, "WaterSplash" },
    { "", 32, 0, 1, 0, 0, 2, "LavaSizzle" },
    { "", 32, 0, 1, 0, 0, 2, "SludgeGloop" },
    { "", 64, 0, 1, 0, 0, 2, "HolySymbolFire" },
    { "", 32, 0, 1, 0, 0, 2, "SpiritActive" },
    { "", 32, 0, 1, 0, 0, 2, "SpiritAttack" },
    { "", 32, 0, 1, 0, 0, 2, "SpiritDie" },
    { "", 36, 0, 1, 0, 0, 2, "ValveTurn" },
    { "", 36, 0, 1, 0, 0, 2, "RopePull" },
    { "", 20, 0, 1, 0, 0, 2, "FlyBuzz" },
    { "", 32, 0, 1, 0, 0, 2, "Ignite" },
    { "", 256, 0, 1, 0, 0, 2, "PuzzleSuccess" },
    { "", 256, 0, 1, 0, 0, 2, "PuzzleFailFighter" },
    { "", 256, 0, 1, 0, 0, 2, "PuzzleFailCleric" },
    { "", 256, 0, 1, 0, 0, 2, "PuzzleFailMage" },
    { "", 32, 0, 1, 0, 0, 2, "Earthquake" },
    { "", 32, 0, 0, 0, 0, 2, "BellRing" },
    { "", 32, 0, 1, 0, 0, 2, "TreeBreak" },
    { "", 32, 0, 1, 0, 0, 2, "TreeExplode" },
    { "", 32, 0, 1, 0, 0, 2, "SuitofArmorBreak" },
    { "", 20, 0, 1, 0, 0, 2, "PoisonShroomPain" },
    { "", 32, 0, 1, 0, 0, 2, "PoisonShroomDeath" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient1" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient2" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient3" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient4" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient5" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient6" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient7" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient8" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient9" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient10" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient11" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient12" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient13" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient14" },
    { "", 1, 0, 1, 0, 0, 1, "Ambient15" },
    { "", 32, 0, 1, 0, 0, 2, "StartupTick" },
    { "", 32, 0, 1, 0, 0, 2, "SwitchOtherLevel" },
    { "", 32, 0, 1, 0, 0, 2, "Respawn" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceGreetings" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceReady" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceBlood" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceGame" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceBoard" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceWorship" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceMaybe" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceStrong" },
    { "", 512, 0, 1, 0, 0, 2, "KoraxVoiceFace" },
    { "", 32, 0, 1, 0, 0, 2, "BatScream" },
    { "", 512, 0, 1, 0, 0, 2, "Chat" },
    { "", 32, 0, 1, 0, 0, 2, "MenuMove" },
    { "", 32, 0, 1, 0, 0, 2, "ClockTick" },
    { "", 32, 0, 1, 0, 0, 2, "Fireball" },
    { "", 30, 0, 1, 0, 0, 2, "PuppyBeat" },
    { "", 32, 0, 1, 0, 0, 4, "MysticIncant" },
};
