// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
// ------------------------------------------------------------------------------
// Changes to this file must follow the http://aka.ms/api-review process.
// ------------------------------------------------------------------------------
[assembly: System.Runtime.CompilerServices.CompilationRelaxations(8)]
[assembly: System.Runtime.CompilerServices.RuntimeCompatibility(WrapNonExceptionThrows = true)]
[assembly: System.Diagnostics.Debuggable(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly: System.CLSCompliant(true)]
[assembly: System.Runtime.Versioning.TargetFramework(".NETStandard,Version=v2.0", FrameworkDisplayName = ".NET Standard 2.0")]
[assembly: System.Reflection.AssemblyCompany("Microsoft Corporation")]
[assembly: System.Reflection.AssemblyConfiguration("release")]
[assembly: System.Reflection.AssemblyCopyright("© Microsoft Corporation. All rights reserved.")]
[assembly: System.Reflection.AssemblyDescription("NuGet's implementation for interacting with feeds. Contains functionality for all feed types.")]
[assembly: System.Reflection.AssemblyFileVersion("6.11.0.119")]
[assembly: System.Reflection.AssemblyInformationalVersion("6.11.0+324d7272b8526a3826ef1f12fa6fc3a362b5bb79.324d7272b8526a3826ef1f12fa6fc3a362b5bb79")]
[assembly: System.Reflection.AssemblyProduct("NuGet")]
[assembly: System.Reflection.AssemblyTitle("NuGet.Protocol")]
[assembly: System.Reflection.AssemblyMetadata("RepositoryUrl", "https://github.com/NuGet/NuGet.Client")]
[assembly: System.Resources.NeutralResourcesLanguage("en-US")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("DynamicProxyGenAssembly2, PublicKey=0024000004800000940000000602000000240000525341310004000001000100C547CAC37ABD99C8DB225EF2F6C8A3602F3B3606CC9891605D02BAA56104F4CFC0734AA39B93BF7852F7D9266654753CC297E7D2EDFE0BAC1CDCF9F717241550E0A7B191195B7667BB4F64BCB8E2121380FD1D9D46AD2D92D2D15605093924CCEAF74C4861EFF62ABF69B9291ED0A340E113BE11E6A7D3113E92484CF7045CC7")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.CommandLine.Xplat.Tests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Credentials.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.PackageManagement.VisualStudio.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Protocol.FuncTest, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Protocol.Tests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.VisualStudio.Common.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.XPlat.FuncTest, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Test.Utility, PublicKey=002400000480000094000000060200000024000052534131000400000100010007D1FA57C4AED9F0A32E84AA0FAEFD0DE9E8FD6AEC8F87FB03766C834C99921EB23BE79AD9D5DCC1DD9AD236132102900B723CF980957FC4E177108FC607774F29E8320E92EA05ECE4E821C0A5EFE8F1645C4C0C93C1AB99285D622CAA652C1DFAD63D745D6F2DE5F17E5EAF0FC4963D261C8A12436518206DC093344D5AD293")]
[assembly: System.Reflection.AssemblyVersionAttribute("6.11.0.119")]
[assembly: System.Runtime.CompilerServices.ReferenceAssembly]
[assembly: System.Reflection.AssemblyFlagsAttribute((System.Reflection.AssemblyNameFlags)0x70)]
namespace NuGet.Protocol
{
    public partial class AlternatePackageMetadata
    {
        [Newtonsoft.Json.JsonProperty(PropertyName = "id")]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "range", ItemConverterType = typeof(VersionRangeConverter))]
        public Versioning.VersionRange Range { get { throw null; } }
    }

    public partial class AmbientAuthenticationState
    {
        public int AuthenticationRetriesCount { get { throw null; } }

        public bool IsBlocked { get { throw null; } }

        public void Block() { }

        public void Increment() { }
    }

    public partial class AutoCompleteResourceV2Feed : Core.Types.AutoCompleteResource
    {
        public AutoCompleteResourceV2Feed(HttpSourceResource httpSourceResource, string baseAddress, Configuration.PackageSource packageSource) { }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> IdStartsWith(string packageIdPrefix, bool includePrerelease, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> VersionStartsWith(string packageId, string versionPrefix, bool includePrerelease, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class AutoCompleteResourceV2FeedProvider : Core.Types.ResourceProvider
    {
        public AutoCompleteResourceV2FeedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class AutoCompleteResourceV3 : Core.Types.AutoCompleteResource
    {
        public AutoCompleteResourceV3(HttpSource client, ServiceIndexResourceV3 serviceIndex, RegistrationResourceV3 regResource) { }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> IdStartsWith(string packageIdPrefix, bool includePrerelease, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> VersionStartsWith(string packageId, string versionPrefix, bool includePrerelease, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class AutoCompleteResourceV3Provider : Core.Types.ResourceProvider
    {
        public AutoCompleteResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class CachingSourceProvider : Core.Types.ISourceRepositoryProvider
    {
        public CachingSourceProvider(Configuration.IPackageSourceProvider packageSourceProvider) { }

        public Configuration.IPackageSourceProvider PackageSourceProvider { get { throw null; } }

        public void AddSourceRepository(Core.Types.SourceRepository source) { }

        public Core.Types.SourceRepository CreateRepository(Configuration.PackageSource source, FeedType type) { throw null; }

        public Core.Types.SourceRepository CreateRepository(Configuration.PackageSource source) { throw null; }

        public Core.Types.SourceRepository CreateRepository(string source) { throw null; }

        public System.Collections.Generic.IEnumerable<Core.Types.SourceRepository> GetRepositories() { throw null; }
    }

    public static partial class CachingUtility
    {
        public const int BufferSize = 8192;
        public static string ComputeHash(string value, bool addIdentifiableCharacters = true) { throw null; }

        public static bool IsFileAlreadyOpen(string filePath) { throw null; }

        public static System.IO.Stream ReadCacheFile(System.TimeSpan maxAge, string cacheFile) { throw null; }

        public static string RemoveInvalidFileNameChars(string value) { throw null; }
    }

    public partial class DependencyInfoResourceV2Feed : Core.Types.DependencyInfoResource
    {
        public DependencyInfoResourceV2Feed(V2FeedParser feedParser, Core.Types.SourceRepository source) { }

        public override System.Threading.Tasks.Task<Core.Types.SourcePackageDependencyInfo> ResolvePackage(Packaging.Core.PackageIdentity package, Frameworks.NuGetFramework projectFramework, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.SourcePackageDependencyInfo>> ResolvePackages(string packageId, Frameworks.NuGetFramework projectFramework, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class DependencyInfoResourceV2FeedProvider : Core.Types.ResourceProvider
    {
        public DependencyInfoResourceV2FeedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class DependencyInfoResourceV3 : Core.Types.DependencyInfoResource
    {
        public DependencyInfoResourceV3(HttpSource client, RegistrationResourceV3 regResource, Core.Types.SourceRepository source) { }

        public override System.Threading.Tasks.Task<Core.Types.SourcePackageDependencyInfo> ResolvePackage(Packaging.Core.PackageIdentity package, Frameworks.NuGetFramework projectFramework, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.SourcePackageDependencyInfo>> ResolvePackages(string packageId, Frameworks.NuGetFramework projectFramework, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.RemoteSourceDependencyInfo>> ResolvePackages(string packageId, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class DependencyInfoResourceV3Provider : Core.Types.ResourceProvider
    {
        public DependencyInfoResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class DownloadResourcePlugin : Core.Types.DownloadResource
    {
        public DownloadResourcePlugin(Plugins.IPlugin plugin, Plugins.IPluginMulticlientUtilities utilities, Configuration.PackageSource packageSource) { }

        public override System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> GetDownloadResourceResultAsync(Packaging.Core.PackageIdentity identity, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class DownloadResourcePluginProvider : Core.Types.ResourceProvider
    {
        public DownloadResourcePluginProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class DownloadResourceV2Feed : Core.Types.DownloadResource
    {
        public DownloadResourceV2Feed(V2FeedParser feedParser, string source) { }

        [System.Obsolete("Use constructor with source parameter")]
        public DownloadResourceV2Feed(V2FeedParser feedParser) { }

        public override System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> GetDownloadResourceResultAsync(Packaging.Core.PackageIdentity identity, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class DownloadResourceV2FeedProvider : Core.Types.ResourceProvider
    {
        public DownloadResourceV2FeedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class DownloadResourceV3 : Core.Types.DownloadResource
    {
        [System.Obsolete("Use constructor with source parameter")]
        public DownloadResourceV3(HttpSource client, RegistrationResourceV3 regResource) { }

        [System.Obsolete("Use constructor with source parameter")]
        public DownloadResourceV3(HttpSource client, string packageBaseAddress) { }

        public DownloadResourceV3(string source, HttpSource client, RegistrationResourceV3 regResource) { }

        public DownloadResourceV3(string source, HttpSource client, string packageBaseAddress) { }

        public override System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> GetDownloadResourceResultAsync(Packaging.Core.PackageIdentity identity, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class DownloadResourceV3Provider : Core.Types.ResourceProvider
    {
        public DownloadResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class DownloadTimeoutStream : System.IO.Stream
    {
        public DownloadTimeoutStream(string downloadName, System.IO.Stream networkStream, System.TimeSpan timeout) { }

        public override bool CanRead { get { throw null; } }

        public override bool CanSeek { get { throw null; } }

        public override bool CanWrite { get { throw null; } }

        public override long Length { get { throw null; } }

        public override long Position { get { throw null; } set { } }

        protected override void Dispose(bool disposing) { }

        public override void Flush() { }

        public override int Read(byte[] buffer, int offset, int count) { throw null; }

        public override System.Threading.Tasks.Task<int> ReadAsync(byte[] buffer, int offset, int count, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override long Seek(long offset, System.IO.SeekOrigin origin) { throw null; }

        public override void SetLength(long value) { }

        public override void Write(byte[] buffer, int offset, int count) { }
    }

    public partial class DownloadTimeoutStreamContent : System.Net.Http.StreamContent
    {
        public DownloadTimeoutStreamContent(string downloadName, System.IO.Stream networkStream, System.TimeSpan timeout) : base(default!) { }
    }

    public static partial class FactoryExtensionsV3
    {
        public static Core.Types.SourceRepository GetCoreV2(this Core.Types.Repository.RepositoryFactory factory, Configuration.PackageSource source) { throw null; }

        public static System.Collections.Generic.IEnumerable<System.Lazy<Core.Types.INuGetResourceProvider>> GetCoreV3(this Core.Types.Repository.ProviderFactory factory) { throw null; }

        public static Core.Types.SourceRepository GetCoreV3(this Core.Types.Repository.RepositoryFactory factory, Configuration.PackageSource source) { throw null; }

        public static Core.Types.SourceRepository GetCoreV3(this Core.Types.Repository.RepositoryFactory factory, string source, FeedType type) { throw null; }

        public static Core.Types.SourceRepository GetCoreV3(this Core.Types.Repository.RepositoryFactory factory, string source) { throw null; }
    }

    public enum FeedType
    {
        Undefined = 0,
        HttpV2 = 1,
        HttpV3 = 2,
        FileSystemV2 = 4,
        FileSystemV3 = 8,
        FileSystemUnzipped = 16,
        FileSystemPackagesConfig = 32,
        FileSystemUnknown = 1024
    }

    public partial class FeedTypePackageSource : Configuration.PackageSource
    {
        public FeedTypePackageSource(string source, FeedType feedType) : base(default!) { }

        public FeedType FeedType { get { throw null; } }
    }

    public partial class FeedTypeResource : Core.Types.INuGetResource
    {
        public FeedTypeResource(FeedType feedType) { }

        public FeedType FeedType { get { throw null; } }
    }

    public partial class FeedTypeResourceProvider : Core.Types.ResourceProvider
    {
        public FeedTypeResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class FeedTypeUtility
    {
        public static FeedType GetFeedType(Configuration.PackageSource packageSource) { throw null; }
    }

    public abstract partial class FindLocalPackagesResource : Core.Types.INuGetResource
    {
        public string Root { get { throw null; } protected set { } }

        public virtual bool Exists(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public virtual bool Exists(string packageId, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public abstract System.Collections.Generic.IEnumerable<LocalPackageInfo> FindPackagesById(string id, Common.ILogger logger, System.Threading.CancellationToken token);
        public abstract LocalPackageInfo GetPackage(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token);
        public abstract LocalPackageInfo GetPackage(System.Uri path, Common.ILogger logger, System.Threading.CancellationToken token);
        public abstract System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackages(Common.ILogger logger, System.Threading.CancellationToken token);
    }

    public partial class FindLocalPackagesResourcePackagesConfig : FindLocalPackagesResource
    {
        public FindLocalPackagesResourcePackagesConfig(string root) { }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> FindPackagesById(string id, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(System.Uri path, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackages(Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourcePackagesConfigProvider : Core.Types.ResourceProvider
    {
        public FindLocalPackagesResourcePackagesConfigProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourceUnzipped : FindLocalPackagesResource
    {
        public FindLocalPackagesResourceUnzipped(string root) { }

        public override bool Exists(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> FindPackagesById(string id, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(System.Uri path, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackages(Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourceUnzippedProvider : Core.Types.ResourceProvider
    {
        public FindLocalPackagesResourceUnzippedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourceV2 : FindLocalPackagesResource
    {
        public FindLocalPackagesResourceV2(string root) { }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> FindPackagesById(string id, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(System.Uri path, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackages(Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourceV2Provider : Core.Types.ResourceProvider
    {
        public FindLocalPackagesResourceV2Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourceV3 : FindLocalPackagesResource
    {
        public FindLocalPackagesResourceV3(string root) { }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> FindPackagesById(string id, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(Packaging.Core.PackageIdentity identity, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override LocalPackageInfo GetPackage(System.Uri path, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackages(Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindLocalPackagesResourceV3Provider : Core.Types.ResourceProvider
    {
        public FindLocalPackagesResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FindPackagesByIdNupkgDownloader
    {
        public FindPackagesByIdNupkgDownloader(HttpSource httpSource) { }

        public System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(Packaging.Core.PackageIdentity identity, string url, System.IO.Stream destination, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<Packaging.NuspecReader> GetNuspecReaderFromNupkgAsync(Packaging.Core.PackageIdentity identity, string url, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class FingerprintsConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanWrite { get { throw null; } }

        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public static partial class GetDownloadResultUtility
    {
        public static void CleanUpDirectDownloads(Core.Types.PackageDownloadContext downloadContext) { }

        public static System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> GetDownloadResultAsync(HttpSource client, Packaging.Core.PackageIdentity identity, System.Uri uri, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class GlobalPackagesFolderUtility
    {
        public static System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> AddPackageAsync(string source, Packaging.Core.PackageIdentity packageIdentity, System.IO.Stream packageStream, string globalPackagesFolder, System.Guid parentId, Packaging.Signing.ClientPolicyContext clientPolicyContext, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public static Core.Types.DownloadResourceResult GetPackage(Packaging.Core.PackageIdentity packageIdentity, string globalPackagesFolder) { throw null; }
    }

    public partial class HttpCacheResult
    {
        public HttpCacheResult(System.TimeSpan maxAge, string newFile, string cacheFule) { }

        public string CacheFile { get { throw null; } }

        public System.TimeSpan MaxAge { get { throw null; } }

        public string NewFile { get { throw null; } }

        public System.IO.Stream Stream { get { throw null; } set { } }
    }

    public static partial class HttpCacheUtility
    {
        public static System.Threading.Tasks.Task CreateCacheFileAsync(HttpCacheResult result, System.Net.Http.HttpResponseMessage response, System.Action<System.IO.Stream> ensureValidContents, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static HttpCacheResult InitializeHttpCacheResult(string httpCacheDirectory, System.Uri sourceUri, string cacheKey, Core.Types.HttpSourceCacheContext context) { throw null; }
    }

    public partial class HttpFileSystemBasedFindPackageByIdResource : Core.Types.FindPackageByIdResource
    {
        public HttpFileSystemBasedFindPackageByIdResource(System.Collections.Generic.IReadOnlyList<System.Uri> baseUris, HttpSource httpSource) { }

        public override System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Core.Types.FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class HttpFileSystemBasedFindPackageByIdResourceProvider : Core.Types.ResourceProvider
    {
        public HttpFileSystemBasedFindPackageByIdResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository sourceRepository, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class HttpHandlerResourceV3 : Core.Types.HttpHandlerResource
    {
        public HttpHandlerResourceV3(System.Net.Http.HttpClientHandler clientHandler, System.Net.Http.HttpMessageHandler messageHandler) { }

        public override System.Net.Http.HttpClientHandler ClientHandler { get { throw null; } }

        public static System.Lazy<Configuration.ICredentialService> CredentialService { get { throw null; } set { } }

        public static System.Action<System.Uri, System.Net.ICredentials> CredentialsSuccessfullyUsed { get { throw null; } set { } }

        public override System.Net.Http.HttpMessageHandler MessageHandler { get { throw null; } }
    }

    public partial class HttpHandlerResourceV3Provider : Core.Types.ResourceProvider
    {
        public HttpHandlerResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class HttpRequestMessageConfiguration
    {
        public static readonly HttpRequestMessageConfiguration Default;
        public HttpRequestMessageConfiguration(Common.ILogger logger = null, bool promptOn403 = true) { }

        public Common.ILogger Logger { get { throw null; } }

        public bool PromptOn403 { get { throw null; } }
    }

    public static partial class HttpRequestMessageExtensions
    {
        public static HttpRequestMessageConfiguration GetOrCreateConfiguration(this System.Net.Http.HttpRequestMessage request) { throw null; }

        public static void SetConfiguration(this System.Net.Http.HttpRequestMessage request, HttpRequestMessageConfiguration configuration) { }
    }

    public static partial class HttpRequestMessageFactory
    {
        public static System.Net.Http.HttpRequestMessage Create(System.Net.Http.HttpMethod method, string requestUri, Common.ILogger log) { throw null; }

        public static System.Net.Http.HttpRequestMessage Create(System.Net.Http.HttpMethod method, string requestUri, HttpRequestMessageConfiguration configuration) { throw null; }

        public static System.Net.Http.HttpRequestMessage Create(System.Net.Http.HttpMethod method, System.Uri requestUri, Common.ILogger log) { throw null; }

        public static System.Net.Http.HttpRequestMessage Create(System.Net.Http.HttpMethod method, System.Uri requestUri, HttpRequestMessageConfiguration configuration) { throw null; }
    }

    public static partial class HttpResponseMessageExtensions
    {
        public static void LogServerWarning(this System.Net.Http.HttpResponseMessage response, Common.ILogger log) { }
    }

    public partial class HttpRetryHandler : IHttpRetryHandler
    {
        public System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(HttpRetryHandlerRequest request, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(HttpRetryHandlerRequest request, string source, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class HttpRetryHandlerRequest
    {
        public static readonly System.TimeSpan DefaultDownloadTimeout;
        public static readonly int DefaultMaxTries;
        public HttpRetryHandlerRequest(System.Net.Http.HttpClient httpClient, System.Func<System.Net.Http.HttpRequestMessage> requestFactory) { }

        public System.Collections.Generic.IList<System.Collections.Generic.KeyValuePair<string, System.Collections.Generic.IEnumerable<string>>> AddHeaders { get { throw null; } set { } }

        public System.Net.Http.HttpCompletionOption CompletionOption { get { throw null; } set { } }

        public System.TimeSpan DownloadTimeout { get { throw null; } set { } }

        public System.Net.Http.HttpClient HttpClient { get { throw null; } }

        public bool IsLastAttempt { get { throw null; } set { } }

        public bool IsRetry { get { throw null; } set { } }

        public int MaxTries { get { throw null; } set { } }

        public System.Func<System.Net.Http.HttpRequestMessage> RequestFactory { get { throw null; } }

        public System.TimeSpan RequestTimeout { get { throw null; } set { } }

        public System.TimeSpan RetryDelay { get { throw null; } set { } }
    }

    public partial class HttpSource : System.IDisposable
    {
        public HttpSource(Configuration.PackageSource packageSource, System.Func<System.Threading.Tasks.Task<Core.Types.HttpHandlerResource>> messageHandlerFactory, IThrottle throttle) { }

        public string HttpCacheDirectory { get { throw null; } set { } }

        public string PackageSource { get { throw null; } }

        public IHttpRetryHandler RetryHandler { get { throw null; } set { } }

        public static HttpSource Create(Core.Types.SourceRepository source, IThrottle throttle) { throw null; }

        public static HttpSource Create(Core.Types.SourceRepository source) { throw null; }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }

        public virtual System.Threading.Tasks.Task<T> GetAsync<T>(HttpSourceCachedRequest request, System.Func<HttpSourceResult, System.Threading.Tasks.Task<T>> processAsync, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<Newtonsoft.Json.Linq.JObject> GetJObjectAsync(HttpSourceRequest request, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<T> ProcessResponseAsync<T>(HttpSourceRequest request, System.Func<System.Net.Http.HttpResponseMessage, System.Threading.Tasks.Task<T>> processAsync, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<T> ProcessResponseAsync<T>(HttpSourceRequest request, System.Func<System.Net.Http.HttpResponseMessage, System.Threading.Tasks.Task<T>> processAsync, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<T> ProcessStreamAsync<T>(HttpSourceRequest request, System.Func<System.IO.Stream, System.Threading.Tasks.Task<T>> processAsync, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<T> ProcessStreamAsync<T>(HttpSourceRequest request, System.Func<System.IO.Stream, System.Threading.Tasks.Task<T>> processAsync, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        protected virtual System.IO.Stream TryReadCacheFile(string uri, System.TimeSpan maxAge, string cacheFile) { throw null; }
    }

    public partial class HttpSourceAuthenticationHandler : System.Net.Http.DelegatingHandler
    {
        public static readonly int MaxAuthRetries;
        public HttpSourceAuthenticationHandler(Configuration.PackageSource packageSource, System.Net.Http.HttpClientHandler clientHandler, Configuration.ICredentialService credentialService) { }

        protected override void Dispose(bool disposing) { }

        protected override System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(System.Net.Http.HttpRequestMessage request, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class HttpSourceCachedRequest
    {
        public HttpSourceCachedRequest(string uri, string cacheKey, Core.Types.HttpSourceCacheContext cacheContext) { }

        public System.Collections.Generic.IList<System.Net.Http.Headers.MediaTypeWithQualityHeaderValue> AcceptHeaderValues { get { throw null; } }

        public Core.Types.HttpSourceCacheContext CacheContext { get { throw null; } }

        public string CacheKey { get { throw null; } }

        public System.TimeSpan DownloadTimeout { get { throw null; } set { } }

        public System.Action<System.IO.Stream> EnsureValidContents { get { throw null; } set { } }

        public bool IgnoreNotFounds { get { throw null; } set { } }

        public bool IsLastAttempt { get { throw null; } set { } }

        public bool IsRetry { get { throw null; } set { } }

        public int MaxTries { get { throw null; } set { } }

        public System.TimeSpan RequestTimeout { get { throw null; } set { } }

        public string Uri { get { throw null; } }
    }

    public partial class HttpSourceCredentials : System.Net.CredentialCache, System.Net.ICredentials
    {
        public HttpSourceCredentials() { }

        public HttpSourceCredentials(System.Net.ICredentials credentials = null) { }

        public System.Net.ICredentials Credentials { get { throw null; } set { } }

        public System.Guid Version { get { throw null; } }

        System.Net.NetworkCredential System.Net.ICredentials.GetCredential(System.Uri uri, string authType) { throw null; }
    }

    public partial class HttpSourceRequest
    {
        public static readonly System.TimeSpan DefaultRequestTimeout;
        public HttpSourceRequest(System.Func<System.Net.Http.HttpRequestMessage> requestFactory) { }

        public HttpSourceRequest(string uri, Common.ILogger log) { }

        public HttpSourceRequest(System.Uri uri, Common.ILogger log) { }

        public System.TimeSpan DownloadTimeout { get { throw null; } set { } }

        public bool IgnoreNotFounds { get { throw null; } set { } }

        public bool IsLastAttempt { get { throw null; } set { } }

        public bool IsRetry { get { throw null; } set { } }

        public int MaxTries { get { throw null; } set { } }

        public System.Func<System.Net.Http.HttpRequestMessage> RequestFactory { get { throw null; } }

        public System.TimeSpan RequestTimeout { get { throw null; } set { } }
    }

    public partial class HttpSourceResource : Core.Types.INuGetResource
    {
        public HttpSourceResource(HttpSource httpSource) { }

        public HttpSource HttpSource { get { throw null; } }
    }

    public partial class HttpSourceResourceProvider : Core.Types.ResourceProvider
    {
        public HttpSourceResourceProvider() : base(default!) { }

        public static IThrottle Throttle { get { throw null; } set { } }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class HttpSourceResult : System.IDisposable
    {
        public HttpSourceResult(HttpSourceResultStatus status, string cacheFileName, System.IO.Stream stream) { }

        public HttpSourceResult(HttpSourceResultStatus status) { }

        public string CacheFile { get { throw null; } }

        public HttpSourceResultStatus Status { get { throw null; } }

        public System.IO.Stream Stream { get { throw null; } }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }
    }

    public enum HttpSourceResultStatus
    {
        NotFound = 0,
        NoContent = 1,
        OpenedFromDisk = 2,
        OpenedFromNetwork = 3
    }

    public static partial class HttpStreamValidation
    {
        public static void ValidateJObject(string uri, System.IO.Stream stream) { }

        public static void ValidateNupkg(string uri, System.IO.Stream stream) { }

        public static void ValidateXml(string uri, System.IO.Stream stream) { }
    }

    public partial interface IHttpRetryHandler
    {
        System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(HttpRetryHandlerRequest request, Common.ILogger log, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(HttpRetryHandlerRequest request, string sourceUri, Common.ILogger log, System.Threading.CancellationToken cancellationToken);
    }

    public abstract partial class InvalidCacheProtocolException : Core.Types.FatalProtocolException
    {
        protected InvalidCacheProtocolException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) : base(default!) { }

        public InvalidCacheProtocolException(string message, System.Exception innerException) : base(default!) { }

        public InvalidCacheProtocolException(string message) : base(default!) { }
    }

    public partial interface IThrottle
    {
        void Release();
        System.Threading.Tasks.Task WaitAsync();
    }

    public partial interface IV2FeedParser
    {
        System.Threading.Tasks.Task<V2FeedPage> GetPackagesPageAsync(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken token);
        System.Threading.Tasks.Task<V2FeedPage> GetSearchPageAsync(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken token);
    }

    public partial interface IVulnerabilityInfoResource : Core.Types.INuGetResource
    {
        System.Threading.Tasks.Task<Model.GetVulnerabilityInfoResult> GetVulnerabilityInfoAsync(Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
    }

    public static partial class JsonExtensions
    {
        public const int JsonSerializationMaxDepth = 512;
        public static readonly Newtonsoft.Json.JsonSerializerSettings ObjectSerializationSettings;
        public static object FromJson(this string json, System.Type type) { throw null; }

        public static T FromJson<T>(this string json, Newtonsoft.Json.JsonSerializerSettings settings) { throw null; }

        public static T FromJson<T>(this string json) { throw null; }

        public static object FromJToken(this Newtonsoft.Json.Linq.JToken jtoken, System.Type type) { throw null; }

        public static T FromJToken<T>(this Newtonsoft.Json.Linq.JToken jtoken) { throw null; }

        public static bool? GetBoolean(this Newtonsoft.Json.Linq.JObject json, string propertyName) { throw null; }

        public static T GetJObjectProperty<T>(this Newtonsoft.Json.Linq.JObject jobject, string propertyName) { throw null; }

        public static string ToJson(this object obj, Newtonsoft.Json.Formatting formatting = Newtonsoft.Json.Formatting.None) { throw null; }

        public static Newtonsoft.Json.Linq.JToken ToJToken(this object obj) { throw null; }
    }

    public static partial class JsonProperties
    {
        public const string AdvisoryUrl = "advisoryUrl";
        public const string AllRepositorySigned = "allRepositorySigned";
        public const string AlternatePackage = "alternatePackage";
        public const string Authors = "authors";
        public const string ContentUrl = "contentUrl";
        public const string Created = "created";
        public const string Data = "data";
        public const string Dependencies = "dependencies";
        public const string DependencyGroups = "dependencyGroups";
        public const string Deprecation = "deprecation";
        public const string DeprecationMessage = "message";
        public const string DeprecationReasons = "reasons";
        public const string Description = "description";
        public const string DownloadCount = "totalDownloads";
        public const string Fingerprints = "fingerprints";
        public const string IconUrl = "iconUrl";
        public const string Issuer = "issuer";
        public const string Language = "language";
        public const string LastEdited = "lastEdited";
        public const string LatestVersion = "latestVersion";
        public const string LicenseExpression = "licenseExpression";
        public const string LicenseExpressionVersion = "licenseExpressionVersion";
        public const string LicenseUrl = "licenseUrl";
        public const string Listed = "listed";
        public const string MinimumClientVersion = "minClientVersion";
        public const string NotAfter = "notAfter";
        public const string NotBefore = "notBefore";
        public const string Owners = "owners";
        public const string PackageContent = "packageContent";
        public const string PackageId = "id";
        public const string PrefixReserved = "verified";
        public const string ProjectUrl = "projectUrl";
        public const string Published = "published";
        public const string Range = "range";
        public const string ReadmeUrl = "readmeUrl";
        public const string RequireLicenseAcceptance = "requireLicenseAcceptance";
        public const string Severity = "severity";
        public const string SigningCertificates = "signingCertificates";
        public const string Subject = "subject";
        public const string SubjectId = "@id";
        public const string Summary = "summary";
        public const string Tags = "tags";
        public const string TargetFramework = "targetFramework";
        public const string Title = "title";
        public const string Type = "@type";
        public const string Url = "url";
        public const string Version = "version";
        public const string Versions = "versions";
        public const string Vulnerabilities = "vulnerabilities";
    }

    public partial class LegacyFeedCapabilityResourceV2Feed : Core.Types.LegacyFeedCapabilityResource
    {
        public LegacyFeedCapabilityResourceV2Feed(V2FeedParser feedParser, string baseAddress) { }

        public override System.Threading.Tasks.Task<bool> SupportsIsAbsoluteLatestVersionAsync(Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<bool> SupportsSearchAsync(Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalAutoCompleteResource : Core.Types.AutoCompleteResource
    {
        public LocalAutoCompleteResource(FindLocalPackagesResource localResource) { }

        protected System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetPackageVersionsFromLocalPackageRepository(string packageId, string versionPrefix, bool includePrerelease, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> IdStartsWith(string packageIdPrefix, bool includePrerelease, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> VersionStartsWith(string packageId, string versionPrefix, bool includePrerelease, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalAutoCompleteResourceProvider : Core.Types.ResourceProvider
    {
        public LocalAutoCompleteResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalDependencyInfoResource : Core.Types.DependencyInfoResource
    {
        public LocalDependencyInfoResource(FindLocalPackagesResource localResource, Core.Types.SourceRepository source) { }

        public override System.Threading.Tasks.Task<Core.Types.SourcePackageDependencyInfo> ResolvePackage(Packaging.Core.PackageIdentity package, Frameworks.NuGetFramework projectFramework, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.SourcePackageDependencyInfo>> ResolvePackages(string packageId, Frameworks.NuGetFramework projectFramework, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalDependencyInfoResourceProvider : Core.Types.ResourceProvider
    {
        public LocalDependencyInfoResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalDownloadResource : Core.Types.DownloadResource
    {
        [System.Obsolete("Use constructor with source parameter")]
        public LocalDownloadResource(FindLocalPackagesResource localResource) { }

        public LocalDownloadResource(string source, FindLocalPackagesResource localResource) { }

        public override System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> GetDownloadResourceResultAsync(Packaging.Core.PackageIdentity identity, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalDownloadResourceProvider : Core.Types.ResourceProvider
    {
        public LocalDownloadResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class LocalFolderUtility
    {
        public static void EnsurePackageFileExists(string packagePath, System.Collections.Generic.IEnumerable<string> matchingPackagePaths) { }

        public static void GenerateNupkgMetadataFile(string nupkgPath, string installPath, string hashPath, string nupkgMetadataPath) { }

        public static System.IO.DirectoryInfo GetAndVerifyRootDirectory(string root) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetDistinctPackages(System.Collections.Generic.IEnumerable<LocalPackageInfo> packages) { throw null; }

        public static Packaging.Core.PackageIdentity GetIdentityFromNupkgPath(System.IO.FileInfo file, string id) { throw null; }

        public static FeedType GetLocalFeedType(string root, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<System.IO.FileInfo> GetNupkgsFromFlatFolder(string root, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<System.IO.FileInfo> GetNupkgsFromFlatFolder(string root, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<System.IO.FileInfo> GetNupkgsFromFlatFolder(string root, string id, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<System.IO.FileInfo> GetNupkgsFromFlatFolder(string root, string id, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackage(System.Uri path, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackagesConfigFolderPackage(string root, Packaging.Core.PackageIdentity identity, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackagesConfigFolderPackage(string root, string id, Versioning.NuGetVersion version, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesConfigFolderPackages(string root, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesConfigFolderPackages(string root, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesConfigFolderPackages(string root, string id, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV2(string root, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV2(string root, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV2(string root, string id, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV2(string root, string id, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV3(string root, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV3(string root, Common.ILogger log) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV3(string root, string id, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Collections.Generic.IEnumerable<LocalPackageInfo> GetPackagesV3(string root, string id, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackageV2(string root, Packaging.Core.PackageIdentity identity, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static LocalPackageInfo GetPackageV2(string root, Packaging.Core.PackageIdentity identity, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackageV2(string root, string id, Versioning.NuGetVersion version, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static LocalPackageInfo GetPackageV2(string root, string id, Versioning.NuGetVersion version, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackageV3(string root, Packaging.Core.PackageIdentity identity, Common.ILogger log) { throw null; }

        public static LocalPackageInfo GetPackageV3(string root, string id, Versioning.NuGetVersion version, Common.ILogger log) { throw null; }

        public static Versioning.NuGetVersion GetVersionFromFileName(string fileName, string id, string extension) { throw null; }

        public static bool IsPossiblePackageMatch(System.IO.FileInfo file, Packaging.Core.PackageIdentity identity) { throw null; }

        public static bool IsPossiblePackageMatch(System.IO.FileInfo file, string id) { throw null; }

        public static System.Collections.Generic.IEnumerable<string> ResolvePackageFromPath(string packagePath, bool isSnupkg = false) { throw null; }
    }

    public partial class LocalMetadataResource : Core.Types.MetadataResource
    {
        public LocalMetadataResource(FindLocalPackagesResource localResource) { }

        public override System.Threading.Tasks.Task<bool> Exists(Packaging.Core.PackageIdentity identity, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<bool> Exists(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, Versioning.NuGetVersion>>> GetLatestVersions(System.Collections.Generic.IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetVersions(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalMetadataResourceProvider : Core.Types.ResourceProvider
    {
        public LocalMetadataResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class LocalPackageArchiveDownloader : Packaging.IPackageDownloader, System.IDisposable
    {
        public LocalPackageArchiveDownloader(string source, string packageFilePath, Packaging.Core.PackageIdentity packageIdentity, Common.ILogger logger) { }

        public Packaging.IAsyncPackageContentReader ContentReader { get { throw null; } }

        public Packaging.Core.IAsyncPackageCoreReader CoreReader { get { throw null; } }

        public Packaging.Signing.ISignedPackageReader SignedPackageReader { get { throw null; } }

        public string Source { get { throw null; } }

        public System.Threading.Tasks.Task<bool> CopyNupkgFileToAsync(string destinationFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task<string> GetPackageHashAsync(string hashAlgorithm, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void SetExceptionHandler(System.Func<System.Exception, System.Threading.Tasks.Task<bool>> handleExceptionAsync) { }

        public void SetThrottle(System.Threading.SemaphoreSlim throttle) { }
    }

    public partial class LocalPackageFileCache
    {
        public virtual System.Lazy<System.Collections.Generic.IReadOnlyList<string>> GetOrAddFiles(string expandedPath) { throw null; }

        public virtual System.Lazy<Packaging.NuspecReader> GetOrAddNuspec(string manifestPath, string expandedPath) { throw null; }

        public virtual System.Lazy<RuntimeModel.RuntimeGraph> GetOrAddRuntimeGraph(string expandedPath) { throw null; }

        public virtual System.Lazy<string> GetOrAddSha512(string sha512Path) { throw null; }

        public virtual bool Sha512Exists(string sha512Path) { throw null; }

        public void UpdateLastAccessTime(string nupkgMetadataPath) { }
    }

    public partial class LocalPackageInfo
    {
        protected LocalPackageInfo() { }

        public LocalPackageInfo(Packaging.Core.PackageIdentity identity, string path, System.DateTime lastWriteTimeUtc, System.Lazy<Packaging.NuspecReader> nuspec, bool useFolder) { }

        [System.Obsolete("use other constructor")]
        public LocalPackageInfo(Packaging.Core.PackageIdentity identity, string path, System.DateTime lastWriteTimeUtc, System.Lazy<Packaging.NuspecReader> nuspec, System.Func<Packaging.PackageReaderBase> getPackageReader) { }

        public virtual Packaging.Core.PackageIdentity Identity { get { throw null; } }

        public virtual bool IsNupkg { get { throw null; } }

        public virtual System.DateTime LastWriteTimeUtc { get { throw null; } }

        public virtual Packaging.NuspecReader Nuspec { get { throw null; } }

        public virtual string Path { get { throw null; } }

        public virtual Packaging.PackageReaderBase GetReader() { throw null; }
    }

    public partial class LocalPackageListResource : Core.Types.ListResource
    {
        public LocalPackageListResource(Core.Types.PackageSearchResource localPackageSearchResource, string baseAddress) { }

        public override string Source { get { throw null; } }

        public override System.Threading.Tasks.Task<Common.IEnumerableAsync<Core.Types.IPackageSearchMetadata>> ListAsync(string searchTerm, bool prerelease, bool allVersions, bool includeDelisted, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalPackageMetadataResource : Core.Types.PackageMetadataResource
    {
        public LocalPackageMetadataResource(FindLocalPackagesResource localResource) { }

        public override System.Threading.Tasks.Task<Core.Types.IPackageSearchMetadata> GetMetadataAsync(Packaging.Core.PackageIdentity package, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.IPackageSearchMetadata>> GetMetadataAsync(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalPackageMetadataResourceProvider : Core.Types.ResourceProvider
    {
        public LocalPackageMetadataResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalPackageSearchMetadata : Core.Types.IPackageSearchMetadata
    {
        public LocalPackageSearchMetadata(LocalPackageInfo package) { }

        public string Authors { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencySets { get { throw null; } }

        public string Description { get { throw null; } }

        public long? DownloadCount { get { throw null; } }

        public System.Uri IconUrl { get { throw null; } }

        public Packaging.Core.PackageIdentity Identity { get { throw null; } }

        public bool IsListed { get { throw null; } }

        public Packaging.LicenseMetadata LicenseMetadata { get { throw null; } }

        public System.Uri LicenseUrl { get { throw null; } }

        public string Owners { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> OwnersList { get { throw null; } }

        public System.Uri PackageDetailsUrl { get { throw null; } }

        public string PackagePath { get { throw null; } }

        public System.Func<Packaging.PackageReaderBase> PackageReader { get { throw null; } }

        public bool PrefixReserved { get { throw null; } }

        public System.Uri ProjectUrl { get { throw null; } }

        public System.DateTimeOffset? Published { get { throw null; } }

        public System.Uri ReadmeUrl { get { throw null; } }

        public System.Uri ReportAbuseUrl { get { throw null; } }

        public bool RequireLicenseAcceptance { get { throw null; } }

        public string Summary { get { throw null; } }

        public string Tags { get { throw null; } }

        public string Title { get { throw null; } }

        public System.Collections.Generic.IEnumerable<PackageVulnerabilityMetadata> Vulnerabilities { get { throw null; } }

        public System.Threading.Tasks.Task<PackageDeprecationMetadata> GetDeprecationMetadataAsync() { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.VersionInfo>> GetVersionsAsync() { throw null; }

        public string LoadFileAsText(string path) { throw null; }
    }

    public partial class LocalPackageSearchResource : Core.Types.PackageSearchResource
    {
        public LocalPackageSearchResource(FindLocalPackagesResource localResource) { }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.IPackageSearchMetadata>> SearchAsync(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalPackageSearchResourceProvider : Core.Types.ResourceProvider
    {
        public LocalPackageSearchResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalV2FindPackageByIdResource : Core.Types.FindPackageByIdResource
    {
        public LocalV2FindPackageByIdResource(Configuration.PackageSource packageSource) { }

        public override System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Core.Types.FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class LocalV2FindPackageByIdResourceProvider : Core.Types.ResourceProvider
    {
        public LocalV2FindPackageByIdResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class LocalV3FindPackageByIdResource : Core.Types.FindPackageByIdResource
    {
        public LocalV3FindPackageByIdResource(Configuration.PackageSource packageSource) { }

        public bool IsFallbackFolder { get { throw null; } set { } }

        public LocalPackageFileCache PackageFileCache { get { throw null; } set { } }

        public override System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Core.Types.FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class LocalV3FindPackageByIdResourceProvider : Core.Types.ResourceProvider
    {
        public LocalV3FindPackageByIdResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class MetadataFieldConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanWrite { get { throw null; } }

        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public partial class MetadataReferenceCache
    {
        public T GetObject<T>(T input) { throw null; }

        public string GetString(string s) { throw null; }

        public Versioning.NuGetVersion GetVersion(string s) { throw null; }
    }

    public partial class MetadataResourceV2Feed : Core.Types.MetadataResource
    {
        public MetadataResourceV2Feed(V2FeedParser feedParser, Core.Types.SourceRepository source) { }

        public override System.Threading.Tasks.Task<bool> Exists(Packaging.Core.PackageIdentity identity, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<bool> Exists(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, Versioning.NuGetVersion>>> GetLatestVersions(System.Collections.Generic.IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetVersions(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class MetadataResourceV2FeedProvider : Core.Types.ResourceProvider
    {
        public MetadataResourceV2FeedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class MetadataResourceV3 : Core.Types.MetadataResource
    {
        public MetadataResourceV3(RegistrationResourceV3 regResource) { }

        public override System.Threading.Tasks.Task<bool> Exists(Packaging.Core.PackageIdentity identity, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<bool> Exists(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, Versioning.NuGetVersion>>> GetLatestVersions(System.Collections.Generic.IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetVersions(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class MetadataResourceV3Provider : Core.Types.ResourceProvider
    {
        public MetadataResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class NuGetVersionConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public partial class NullThrottle : IThrottle
    {
        public static NullThrottle Instance { get { throw null; } }

        public void Release() { }

        public System.Threading.Tasks.Task WaitAsync() { throw null; }
    }

    public partial class ODataServiceDocumentResourceV2 : Core.Types.INuGetResource
    {
        public ODataServiceDocumentResourceV2(string baseAddress, System.DateTime requestTime) { }

        public string BaseAddress { get { throw null; } }

        public virtual System.DateTime RequestTime { get { throw null; } }
    }

    public partial class ODataServiceDocumentResourceV2Provider : Core.Types.ResourceProvider
    {
        public ODataServiceDocumentResourceV2Provider() : base(default!) { }

        public System.TimeSpan MaxCacheDuration { get { throw null; } protected set { } }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }

        protected partial class ODataServiceDocumentCacheInfo
        {
            public System.DateTime CachedTime { get { throw null; } set { } }

            public ODataServiceDocumentResourceV2 ServiceDocument { get { throw null; } set { } }
        }
    }

    public partial class PackageDependencyGroupConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanWrite { get { throw null; } }

        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public partial class PackageDeprecationMetadata
    {
        [Newtonsoft.Json.JsonProperty(PropertyName = "alternatePackage")]
        public AlternatePackageMetadata AlternatePackage { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "message")]
        public string Message { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "reasons")]
        public System.Collections.Generic.IEnumerable<string> Reasons { get { throw null; } }
    }

    public partial class PackageDetailsUriResourceV3 : Core.Types.INuGetResource
    {
        internal PackageDetailsUriResourceV3() { }

        public static PackageDetailsUriResourceV3 CreateOrNull(string uriTemplate) { throw null; }

        public System.Uri GetUri(string id, Versioning.NuGetVersion version) { throw null; }
    }

    public partial class PackageDetailsUriResourceV3Provider : Core.Types.ResourceProvider
    {
        public PackageDetailsUriResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageMetadataResourceV2Feed : Core.Types.PackageMetadataResource
    {
        public PackageMetadataResourceV2Feed(HttpSourceResource httpSourceResource, string baseAddress, Configuration.PackageSource packageSource) { }

        public override System.Threading.Tasks.Task<Core.Types.IPackageSearchMetadata> GetMetadataAsync(Packaging.Core.PackageIdentity package, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.IPackageSearchMetadata>> GetMetadataAsync(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageMetadataResourceV2FeedProvider : Core.Types.ResourceProvider
    {
        public PackageMetadataResourceV2FeedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageMetadataResourceV3 : Core.Types.PackageMetadataResource
    {
        public PackageMetadataResourceV3(HttpSource client, RegistrationResourceV3 regResource, ReportAbuseResourceV3 reportAbuseResource, PackageDetailsUriResourceV3 packageDetailsUriResource) { }

        public override System.Threading.Tasks.Task<Core.Types.IPackageSearchMetadata> GetMetadataAsync(Packaging.Core.PackageIdentity package, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.IPackageSearchMetadata>> GetMetadataAsync(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageMetadataResourceV3Provider : Core.Types.ResourceProvider
    {
        public PackageMetadataResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageNotFoundProtocolException : InvalidCacheProtocolException
    {
        public PackageNotFoundProtocolException(Packaging.Core.PackageIdentity package, System.Exception innerException) : base(default!) { }

        public PackageNotFoundProtocolException(Packaging.Core.PackageIdentity package) : base(default!) { }

        public Packaging.Core.PackageIdentity PackageIdentity { get { throw null; } }
    }

    public partial class PackageSearchMetadata : Core.Types.IPackageSearchMetadata
    {
        [Newtonsoft.Json.JsonProperty(PropertyName = "authors")]
        [Newtonsoft.Json.JsonConverter(typeof(MetadataFieldConverter))]
        public string Authors { get { throw null; } }

        [Newtonsoft.Json.JsonIgnore]
        public System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencySets { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "dependencyGroups", ItemConverterType = typeof(PackageDependencyGroupConverter))]
        public System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencySetsInternal { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "deprecation")]
        public PackageDeprecationMetadata DeprecationMetadata { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "description")]
        public string Description { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "totalDownloads")]
        public long? DownloadCount { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "iconUrl")]
        public System.Uri IconUrl { get { throw null; } }

        [Newtonsoft.Json.JsonIgnore]
        public Packaging.Core.PackageIdentity Identity { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "listed")]
        public bool IsListed { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "licenseExpression")]
        public string LicenseExpression { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "licenseExpressionVersion")]
        public string LicenseExpressionVersion { get { throw null; } }

        [Newtonsoft.Json.JsonIgnore]
        public Packaging.LicenseMetadata LicenseMetadata { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "licenseUrl")]
        [Newtonsoft.Json.JsonConverter(typeof(SafeUriConverter))]
        public System.Uri LicenseUrl { get { throw null; } }

        public string Owners { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "owners")]
        public System.Collections.Generic.IReadOnlyList<string> OwnersList { get { throw null; } }

        [Newtonsoft.Json.JsonIgnore]
        public System.Uri PackageDetailsUrl { get { throw null; } set { } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "id")]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "versions")]
        public Core.Types.VersionInfo[] ParsedVersions { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "verified")]
        public bool PrefixReserved { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "projectUrl")]
        [Newtonsoft.Json.JsonConverter(typeof(SafeUriConverter))]
        public System.Uri ProjectUrl { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "published")]
        public System.DateTimeOffset? Published { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "readmeUrl")]
        [Newtonsoft.Json.JsonConverter(typeof(SafeUriConverter))]
        public System.Uri ReadmeUrl { get { throw null; } }

        [Newtonsoft.Json.JsonIgnore]
        public System.Uri ReportAbuseUrl { get { throw null; } set { } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "requireLicenseAcceptance", DefaultValueHandling = Newtonsoft.Json.DefaultValueHandling.Populate)]
        [System.ComponentModel.DefaultValue(false)]
        [Newtonsoft.Json.JsonConverter(typeof(SafeBoolConverter))]
        public bool RequireLicenseAcceptance { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "summary")]
        public string Summary { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "tags")]
        [Newtonsoft.Json.JsonConverter(typeof(MetadataFieldConverter))]
        public string Tags { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "title")]
        public string Title { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "version")]
        public Versioning.NuGetVersion Version { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "vulnerabilities")]
        public System.Collections.Generic.IEnumerable<PackageVulnerabilityMetadata> Vulnerabilities { get { throw null; } }

        public System.Threading.Tasks.Task<PackageDeprecationMetadata> GetDeprecationMetadataAsync() { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.VersionInfo>> GetVersionsAsync() { throw null; }
    }

    public partial class PackageSearchMetadataRegistration : PackageSearchMetadata
    {
        [Newtonsoft.Json.JsonProperty(PropertyName = "@id")]
        public System.Uri CatalogUri { get { throw null; } }
    }

    public partial class PackageSearchMetadataV2Feed : Core.Types.IPackageSearchMetadata
    {
        public PackageSearchMetadataV2Feed(V2FeedPackageInfo package, MetadataReferenceCache metadataCache) { }

        public PackageSearchMetadataV2Feed(V2FeedPackageInfo package) { }

        public string Authors { get { throw null; } }

        public System.DateTimeOffset? Created { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencySets { get { throw null; } }

        public PackageDeprecationMetadata DeprecationMetadata { get { throw null; } }

        public string Description { get { throw null; } }

        public long? DownloadCount { get { throw null; } }

        public System.Uri IconUrl { get { throw null; } }

        public Packaging.Core.PackageIdentity Identity { get { throw null; } }

        public bool IsListed { get { throw null; } }

        public System.DateTimeOffset? LastEdited { get { throw null; } }

        public Packaging.LicenseMetadata LicenseMetadata { get { throw null; } }

        public System.Uri LicenseUrl { get { throw null; } }

        public string Owners { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> OwnersList { get { throw null; } }

        public System.Uri PackageDetailsUrl { get { throw null; } }

        public string PackageId { get { throw null; } }

        public bool PrefixReserved { get { throw null; } }

        public System.Uri ProjectUrl { get { throw null; } }

        public System.DateTimeOffset? Published { get { throw null; } }

        public System.Uri ReadmeUrl { get { throw null; } }

        public System.Uri ReportAbuseUrl { get { throw null; } }

        public bool RequireLicenseAcceptance { get { throw null; } }

        public string Summary { get { throw null; } }

        public string Tags { get { throw null; } }

        public string Title { get { throw null; } }

        public Versioning.NuGetVersion Version { get { throw null; } }

        public System.Collections.Generic.IEnumerable<PackageVulnerabilityMetadata> Vulnerabilities { get { throw null; } }

        public System.Threading.Tasks.Task<PackageDeprecationMetadata> GetDeprecationMetadataAsync() { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.VersionInfo>> GetVersionsAsync() { throw null; }
    }

    public partial class PackageSearchResourceV2Feed : Core.Types.PackageSearchResource
    {
        public PackageSearchResourceV2Feed(HttpSourceResource httpSourceResource, string baseAddress, Configuration.PackageSource packageSource) { }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.IPackageSearchMetadata>> SearchAsync(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class PackageSearchResourceV2FeedProvider : Core.Types.ResourceProvider
    {
        public PackageSearchResourceV2FeedProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageSearchResourceV3 : Core.Types.PackageSearchResource
    {
        [System.Obsolete("Use PackageSearchResource instead (via SourceRepository.GetResourceAsync<PackageSearchResource>")]
        public PackageSearchResourceV3(RawSearchResourceV3 searchResource) { }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Core.Types.IPackageSearchMetadata>> SearchAsync(string searchTerm, Core.Types.SearchFilter filter, int skip, int take, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class PackageSearchResourceV3Provider : Core.Types.ResourceProvider
    {
        public PackageSearchResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageUpdateResourceV2Provider : Core.Types.ResourceProvider
    {
        public PackageUpdateResourceV2Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageUpdateResourceV3Provider : Core.Types.ResourceProvider
    {
        public PackageUpdateResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageVulnerabilityMetadata
    {
        [Newtonsoft.Json.JsonProperty(PropertyName = "advisoryUrl", ItemConverterType = typeof(SafeUriConverter))]
        public System.Uri AdvisoryUrl { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "severity")]
        public int Severity { get { throw null; } }
    }

    public enum PackageVulnerabilitySeverity
    {
        Unknown = -1,
        Low = 0,
        Moderate = 1,
        High = 2,
        Critical = 3
    }

    public sealed partial class PluginFindPackageByIdResourceProvider : Core.Types.ResourceProvider
    {
        public PluginFindPackageByIdResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public static partial class ProtocolConstants
    {
        public static readonly string ApiKeyHeader;
        public static readonly string ServerWarningHeader;
        public static readonly string SessionId;
    }

    public partial class ProxyAuthenticationHandler : System.Net.Http.DelegatingHandler
    {
        public static readonly int MaxAuthRetries;
        public ProxyAuthenticationHandler(System.Net.Http.HttpClientHandler clientHandler, Configuration.ICredentialService credentialService, Configuration.IProxyCredentialCache credentialCache) { }

        protected override System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(System.Net.Http.HttpRequestMessage request, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    [System.Obsolete("Use PackageSearchResource instead (via SourceRepository.GetResourceAsync<PackageSearchResource>")]
    public partial class RawSearchResourceV3 : Core.Types.INuGetResource
    {
        public RawSearchResourceV3(HttpSource client, System.Collections.Generic.IEnumerable<System.Uri> searchEndpoints) { }

        [System.Obsolete("Use PackageSearchResource instead (via SourceRepository.GetResourceAsync<PackageSearchResource>")]
        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Newtonsoft.Json.Linq.JObject>> Search(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        [System.Obsolete("Use PackageSearchResource instead (via SourceRepository.GetResourceAsync<PackageSearchResource>")]
        public virtual System.Threading.Tasks.Task<Newtonsoft.Json.Linq.JObject> SearchPage(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    [System.Obsolete("Use PackageSearchResource instead (via SourceRepository.GetResourceAsync<PackageSearchResource>")]
    public partial class RawSearchResourceV3Provider : Core.Types.ResourceProvider
    {
        public RawSearchResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class RegistrationResourceV3 : Core.Types.INuGetResource
    {
        public RegistrationResourceV3(HttpSource client, System.Uri baseUrl) { }

        public System.Uri BaseUri { get { throw null; } }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Newtonsoft.Json.Linq.JObject>> GetPackageEntries(string packageId, bool includeUnlisted, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public virtual System.Threading.Tasks.Task<Newtonsoft.Json.Linq.JObject> GetPackageMetadata(Packaging.Core.PackageIdentity identity, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Newtonsoft.Json.Linq.JObject>> GetPackageMetadata(string packageId, Versioning.VersionRange range, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Newtonsoft.Json.Linq.JObject>> GetPackageMetadata(string packageId, bool includePrerelease, bool includeUnlisted, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public virtual System.Uri GetUri(Packaging.Core.PackageIdentity package) { throw null; }

        public virtual System.Uri GetUri(string id, Versioning.NuGetVersion version) { throw null; }

        public virtual System.Uri GetUri(string packageId) { throw null; }
    }

    public partial class RegistrationResourceV3Provider : Core.Types.ResourceProvider
    {
        public RegistrationResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class RegistrationUtility
    {
        public static Versioning.VersionRange CreateVersionRange(string stringToParse) { throw null; }

        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Newtonsoft.Json.Linq.JObject>> LoadRanges(HttpSource httpSource, System.Uri registrationUri, string packageId, Versioning.VersionRange range, Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class RemotePackageArchiveDownloader : Packaging.IPackageDownloader, System.IDisposable
    {
        public RemotePackageArchiveDownloader(string source, Core.Types.FindPackageByIdResource resource, Packaging.Core.PackageIdentity packageIdentity, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger) { }

        public Packaging.IAsyncPackageContentReader ContentReader { get { throw null; } }

        public Packaging.Core.IAsyncPackageCoreReader CoreReader { get { throw null; } }

        public Packaging.Signing.ISignedPackageReader SignedPackageReader { get { throw null; } }

        public string Source { get { throw null; } }

        public System.Threading.Tasks.Task<bool> CopyNupkgFileToAsync(string destinationFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task<string> GetPackageHashAsync(string hashAlgorithm, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void SetExceptionHandler(System.Func<System.Exception, System.Threading.Tasks.Task<bool>> handleExceptionAsync) { }

        public void SetThrottle(System.Threading.SemaphoreSlim throttle) { }
    }

    public partial class RemoteV2FindPackageByIdResource : Core.Types.FindPackageByIdResource
    {
        public RemoteV2FindPackageByIdResource(Configuration.PackageSource packageSource, HttpSource httpSource) { }

        public Configuration.PackageSource PackageSource { get { throw null; } }

        public override System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Core.Types.FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class RemoteV2FindPackageByIdResourceProvider : Core.Types.ResourceProvider
    {
        public RemoteV2FindPackageByIdResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository sourceRepository, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class RemoteV3FindPackageByIdResource : Core.Types.FindPackageByIdResource
    {
        public RemoteV3FindPackageByIdResource(Core.Types.SourceRepository sourceRepository, HttpSource httpSource) { }

        public Core.Types.SourceRepository SourceRepository { get { throw null; } }

        public override System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Core.Types.FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class RemoteV3FindPackageByIdResourceProvider : Core.Types.ResourceProvider
    {
        public RemoteV3FindPackageByIdResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository sourceRepository, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class ReportAbuseResourceV3 : Core.Types.INuGetResource
    {
        public ReportAbuseResourceV3(string uriTemplate) { }

        public System.Uri GetReportAbuseUrl(string id, Versioning.NuGetVersion version) { throw null; }
    }

    public partial class ReportAbuseResourceV3Provider : Core.Types.ResourceProvider
    {
        public ReportAbuseResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class RepositoryCertificateInfo : Packaging.Core.IRepositoryCertificateInfo
    {
        [Newtonsoft.Json.JsonProperty(PropertyName = "contentUrl")]
        public string ContentUrl { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "fingerprints")]
        public Packaging.Core.Fingerprints Fingerprints { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "issuer")]
        public string Issuer { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "notAfter")]
        public System.DateTimeOffset NotAfter { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "notBefore")]
        public System.DateTimeOffset NotBefore { get { throw null; } }

        [Newtonsoft.Json.JsonProperty(PropertyName = "subject")]
        public string Subject { get { throw null; } }
    }

    public partial class RepositorySignatureResource : Core.Types.INuGetResource
    {
        public RepositorySignatureResource(Newtonsoft.Json.Linq.JObject repoSignInformationContent, Core.Types.SourceRepository source) { }

        public RepositorySignatureResource(bool allRepositorySigned, System.Collections.Generic.IEnumerable<Packaging.Core.IRepositoryCertificateInfo> repositoryCertInfos) { }

        public bool AllRepositorySigned { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Packaging.Core.IRepositoryCertificateInfo> RepositoryCertificateInfos { get { throw null; } }

        public string Source { get { throw null; } }

        public void UpdateRepositorySignatureInfo() { }
    }

    public partial class RepositorySignatureResourceProvider : Core.Types.ResourceProvider
    {
        public RepositorySignatureResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class SafeBoolConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanRead { get { throw null; } }

        public override bool CanWrite { get { throw null; } }

        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public partial class SafeUriConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanRead { get { throw null; } }

        public override bool CanWrite { get { throw null; } }

        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public sealed partial class SemanticVersionConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public partial class SemaphoreSlimThrottle : IThrottle
    {
        public SemaphoreSlimThrottle(System.Threading.SemaphoreSlim semaphore) { }

        public int CurrentCount { get { throw null; } }

        public static SemaphoreSlimThrottle CreateBinarySemaphore() { throw null; }

        public static SemaphoreSlimThrottle CreateSemaphoreThrottle(int initialCount) { throw null; }

        public void Release() { }

        public System.Threading.Tasks.Task WaitAsync() { throw null; }
    }

    public partial class ServerWarningLogHandler : System.Net.Http.DelegatingHandler
    {
        public ServerWarningLogHandler(System.Net.Http.HttpClientHandler clientHandler) { }

        protected override System.Threading.Tasks.Task<System.Net.Http.HttpResponseMessage> SendAsync(System.Net.Http.HttpRequestMessage request, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class ServiceIndexEntry
    {
        public ServiceIndexEntry(System.Uri serviceUri, string serviceType, Versioning.SemanticVersion clientVersion) { }

        public Versioning.SemanticVersion ClientVersion { get { throw null; } }

        public string Type { get { throw null; } }

        public System.Uri Uri { get { throw null; } }
    }

    public partial class ServiceIndexResourceV3 : Core.Types.INuGetResource
    {
        public ServiceIndexResourceV3(Newtonsoft.Json.Linq.JObject index, System.DateTime requestTime) { }

        public virtual System.Collections.Generic.IReadOnlyList<ServiceIndexEntry> Entries { get { throw null; } }

        public virtual string Json { get { throw null; } }

        public virtual System.DateTime RequestTime { get { throw null; } }

        public virtual System.Collections.Generic.IReadOnlyList<ServiceIndexEntry> GetServiceEntries(Versioning.NuGetVersion clientVersion, params string[] orderedTypes) { throw null; }

        public virtual System.Collections.Generic.IReadOnlyList<ServiceIndexEntry> GetServiceEntries(params string[] orderedTypes) { throw null; }

        public virtual System.Uri GetServiceEntryUri(params string[] orderedTypes) { throw null; }

        public virtual System.Collections.Generic.IReadOnlyList<System.Uri> GetServiceEntryUris(Versioning.NuGetVersion clientVersion, params string[] orderedTypes) { throw null; }

        public virtual System.Collections.Generic.IReadOnlyList<System.Uri> GetServiceEntryUris(params string[] orderedTypes) { throw null; }
    }

    public partial class ServiceIndexResourceV3Provider : Core.Types.ResourceProvider
    {
        public ServiceIndexResourceV3Provider() : base(default!) { }

        public System.TimeSpan MaxCacheDuration { get { throw null; } protected set { } }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }

        protected partial class ServiceIndexCacheInfo
        {
            public System.DateTime CachedTime { get { throw null; } set { } }

            public ServiceIndexResourceV3 Index { get { throw null; } set { } }
        }
    }

    public static partial class ServiceTypes
    {
        public static readonly string[] LegacyGallery;
        public static readonly string[] PackageBaseAddress;
        public static readonly string[] PackageDetailsUriTemplate;
        public static readonly string[] PackagePublish;
        public static readonly string[] RegistrationsBaseUrl;
        public static readonly string[] ReportAbuse;
        public static readonly string[] RepositorySignatures;
        public static readonly string[] SearchAutocompleteService;
        public static readonly string[] SearchQueryService;
        public static readonly string[] SymbolPackagePublish;
        public static readonly string Version200;
        public static readonly string Version300;
        public static readonly string Version300beta;
        public static readonly string Version300rc;
        public static readonly string Version340;
        public static readonly string Version360;
        public static readonly string Version470;
        public static readonly string Version490;
        public static readonly string Version500;
        public static readonly string Version510;
        public static readonly string Versioned;
    }

    public static partial class StreamExtensions
    {
        public static readonly int BufferSize;
        public static System.Threading.Tasks.Task CopyToAsync(this System.IO.Stream stream, System.IO.Stream destination, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class SymbolPackageUpdateResourceV3Provider : Core.Types.ResourceProvider
    {
        public SymbolPackageUpdateResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class TimeoutUtility
    {
        public static System.Threading.Tasks.Task StartWithTimeout(System.Func<System.Threading.CancellationToken, System.Threading.Tasks.Task> getTask, System.TimeSpan timeout, string timeoutMessage, System.Threading.CancellationToken token) { throw null; }

        public static System.Threading.Tasks.Task<T> StartWithTimeout<T>(System.Func<System.Threading.CancellationToken, System.Threading.Tasks.Task<T>> getTask, System.TimeSpan timeout, string timeoutMessage, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class TokenStore
    {
        public static TokenStore Instance { get { throw null; } }

        public System.Guid Version { get { throw null; } }

        public void AddToken(System.Uri sourceUri, string token) { }

        public string GetToken(System.Uri sourceUri) { throw null; }
    }

    public partial class V2FeedListResource : Core.Types.ListResource
    {
        public V2FeedListResource(IV2FeedParser feedParser, Core.Types.ILegacyFeedCapabilityResource feedCapabilities, string baseAddress) { }

        public override string Source { get { throw null; } }

        public override System.Threading.Tasks.Task<Common.IEnumerableAsync<Core.Types.IPackageSearchMetadata>> ListAsync(string searchTerm, bool prerelease, bool allVersions, bool includeDelisted, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class V2FeedListResourceProvider : Core.Types.ResourceProvider
    {
        public V2FeedListResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class V2FeedPackageInfo : Packaging.Core.PackageIdentity
    {
        public V2FeedPackageInfo(Packaging.Core.PackageIdentity identity, string title, string summary, string description, System.Collections.Generic.IEnumerable<string> authors, System.Collections.Generic.IEnumerable<string> owners, string iconUrl, string licenseUrl, string projectUrl, string reportAbuseUrl, string galleryDetailsUrl, string tags, System.DateTimeOffset? created, System.DateTimeOffset? lastEdited, System.DateTimeOffset? published, string dependencies, bool requireLicenseAccept, string downloadUrl, string downloadCount, string packageHash, string packageHashAlgorithm, Versioning.NuGetVersion minClientVersion) : base(default!, default!) { }

        public System.Collections.Generic.IEnumerable<string> Authors { get { throw null; } }

        public System.DateTimeOffset? Created { get { throw null; } }

        public string Dependencies { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<Packaging.PackageDependencyGroup> DependencySets { get { throw null; } }

        public string Description { get { throw null; } }

        public string DownloadCount { get { throw null; } }

        public int DownloadCountAsInt { get { throw null; } }

        public string DownloadUrl { get { throw null; } }

        public string GalleryDetailsUrl { get { throw null; } }

        public string IconUrl { get { throw null; } }

        public bool IsListed { get { throw null; } }

        public System.DateTimeOffset? LastEdited { get { throw null; } }

        public string LicenseUrl { get { throw null; } }

        public Versioning.NuGetVersion MinClientVersion { get { throw null; } }

        public System.Collections.Generic.IEnumerable<string> Owners { get { throw null; } }

        public string PackageHash { get { throw null; } }

        public string PackageHashAlgorithm { get { throw null; } }

        public string ProjectUrl { get { throw null; } }

        public System.DateTimeOffset? Published { get { throw null; } }

        public string ReportAbuseUrl { get { throw null; } }

        public bool RequireLicenseAcceptance { get { throw null; } }

        public string Summary { get { throw null; } }

        public string Tags { get { throw null; } }

        public string Title { get { throw null; } }
    }

    public partial class V2FeedPage
    {
        public V2FeedPage(System.Collections.Generic.List<V2FeedPackageInfo> items, string nextUri) { }

        public System.Collections.Generic.IReadOnlyList<V2FeedPackageInfo> Items { get { throw null; } }

        public string NextUri { get { throw null; } }
    }

    public sealed partial class V2FeedParser : IV2FeedParser
    {
        public V2FeedParser(HttpSource httpSource, string baseAddress, string source) { }

        public V2FeedParser(HttpSource httpSource, string baseAddress) { }

        public string Source { get { throw null; } }

        public System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> DownloadFromIdentity(Packaging.Core.PackageIdentity package, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<Core.Types.DownloadResourceResult> DownloadFromUrl(Packaging.Core.PackageIdentity package, System.Uri downloadUri, Core.Types.PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<V2FeedPackageInfo>> FindPackagesByIdAsync(string id, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<V2FeedPackageInfo>> FindPackagesByIdAsync(string id, bool includeUnlisted, bool includePrerelease, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<V2FeedPackageInfo> GetPackage(Packaging.Core.PackageIdentity package, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<V2FeedPage> GetPackagesPageAsync(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<V2FeedPage> GetSearchPageAsync(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<V2FeedPage> QueryV2FeedAsync(string relativeUri, string id, int max, bool ignoreNotFounds, Core.Types.SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<V2FeedPackageInfo>> Search(string searchTerm, Core.Types.SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class V2FeedQueryBuilder
    {
        public string BuildFindPackagesByIdUri(string id) { throw null; }

        public string BuildGetPackagesUri(string searchTerm, Core.Types.SearchFilter filters, int? skip, int? take) { throw null; }

        public string BuildGetPackageUri(Packaging.Core.PackageIdentity package) { throw null; }

        public string BuildSearchUri(string searchTerm, Core.Types.SearchFilter filters, int skip, int take) { throw null; }
    }

    public static partial class V2FeedUtilities
    {
        public static Core.Types.IPackageSearchMetadata CreatePackageSearchResult(V2FeedPackageInfo package, MetadataReferenceCache metadataCache, Core.Types.SearchFilter filter, V2FeedParser feedParser, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class V3FeedListResourceProvider : Core.Types.ResourceProvider
    {
        public V3FeedListResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class VersionInfoConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanWrite { get { throw null; } }

        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }

    public partial class VersionRangeConverter : Newtonsoft.Json.JsonConverter
    {
        public override bool CanConvert(System.Type objectType) { throw null; }

        public override object ReadJson(Newtonsoft.Json.JsonReader reader, System.Type objectType, object existingValue, Newtonsoft.Json.JsonSerializer serializer) { throw null; }

        public override void WriteJson(Newtonsoft.Json.JsonWriter writer, object value, Newtonsoft.Json.JsonSerializer serializer) { }
    }
}

namespace NuGet.Protocol.Core.Types
{
    public abstract partial class AutoCompleteResource : INuGetResource
    {
        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> IdStartsWith(string packageIdPrefix, bool includePrerelease, Common.ILogger log, System.Threading.CancellationToken token);
        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> VersionStartsWith(string packageId, string versionPrefix, bool includePrerelease, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
    }

    public abstract partial class DependencyInfoResource : INuGetResource
    {
        public abstract System.Threading.Tasks.Task<SourcePackageDependencyInfo> ResolvePackage(Packaging.Core.PackageIdentity package, Frameworks.NuGetFramework projectFramework, SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token);
        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<SourcePackageDependencyInfo>> ResolvePackages(string packageId, Frameworks.NuGetFramework projectFramework, SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token);
        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<RemoteSourceDependencyInfo>> ResolvePackages(string packageId, SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
    }

    public abstract partial class DownloadResource : INuGetResource
    {
        public abstract System.Threading.Tasks.Task<DownloadResourceResult> GetDownloadResourceResultAsync(Packaging.Core.PackageIdentity identity, PackageDownloadContext downloadContext, string globalPackagesFolder, Common.ILogger logger, System.Threading.CancellationToken token);
    }

    public sealed partial class DownloadResourceResult : System.IDisposable
    {
        public DownloadResourceResult(Packaging.PackageReaderBase packageReader, string source) { }

        public DownloadResourceResult(DownloadResourceResultStatus status) { }

        public DownloadResourceResult(System.IO.Stream stream, Packaging.PackageReaderBase packageReader, string source) { }

        public DownloadResourceResult(System.IO.Stream stream, string source) { }

        public Packaging.PackageReaderBase PackageReader { get { throw null; } }

        public string PackageSource { get { throw null; } }

        public System.IO.Stream PackageStream { get { throw null; } }

        public bool SignatureVerified { get { throw null; } set { } }

        public DownloadResourceResultStatus Status { get { throw null; } }

        public void Dispose() { }
    }

    public enum DownloadResourceResultStatus
    {
        Available = 0,
        AvailableWithoutStream = 1,
        NotFound = 2,
        Cancelled = 3
    }

    public partial class FatalProtocolException : NuGetProtocolException
    {
        protected FatalProtocolException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) : base(default!) { }

        public FatalProtocolException(string message, System.Exception innerException) : base(default!) { }

        public FatalProtocolException(string message) : base(default!) { }
    }

    public partial class FindPackageByIdDependencyInfo
    {
        public FindPackageByIdDependencyInfo(Packaging.Core.PackageIdentity packageIdentity, System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> dependencyGroups, System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> frameworkReferenceGroups) { }

        public System.Collections.Generic.IReadOnlyList<Packaging.PackageDependencyGroup> DependencyGroups { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<Packaging.FrameworkSpecificGroup> FrameworkReferenceGroups { get { throw null; } }

        public Packaging.Core.PackageIdentity PackageIdentity { get { throw null; } }
    }

    public abstract partial class FindPackageByIdResource : INuGetResource
    {
        public abstract System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
        public abstract System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
        protected static FindPackageByIdDependencyInfo GetDependencyInfo(Packaging.NuspecReader reader) { throw null; }

        public abstract System.Threading.Tasks.Task<FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
        public abstract System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
    }

    public abstract partial class HttpHandlerResource : INuGetResource
    {
        public abstract System.Net.Http.HttpClientHandler ClientHandler { get; }
        public abstract System.Net.Http.HttpMessageHandler MessageHandler { get; }
    }

    public partial class HttpSourceCacheContext
    {
        internal HttpSourceCacheContext() { }

        public bool DirectDownload { get { throw null; } }

        public System.TimeSpan MaxAge { get { throw null; } }

        public string RootTempFolder { get { throw null; } }

        public SourceCacheContext SourceCacheContext { get { throw null; } }

        public static HttpSourceCacheContext Create(SourceCacheContext cacheContext, bool isFirstAttempt) { throw null; }

        public static HttpSourceCacheContext Create(SourceCacheContext cacheContext, int retryCount) { throw null; }
    }

    public partial interface ILegacyFeedCapabilityResource
    {
        System.Threading.Tasks.Task<bool> SupportsIsAbsoluteLatestVersionAsync(Common.ILogger log, System.Threading.CancellationToken token);
        System.Threading.Tasks.Task<bool> SupportsSearchAsync(Common.ILogger log, System.Threading.CancellationToken token);
    }

    public partial interface INuGetResource
    {
    }

    public partial interface INuGetResourceProvider
    {
        System.Collections.Generic.IEnumerable<string> After { get; }

        System.Collections.Generic.IEnumerable<string> Before { get; }

        string Name { get; }

        System.Type ResourceType { get; }

        System.Threading.Tasks.Task<System.Tuple<bool, INuGetResource?>> TryCreate(SourceRepository source, System.Threading.CancellationToken token);
    }

    public partial interface IPackageSearchMetadata
    {
        string Authors { get; }

        System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencySets { get; }

        string Description { get; }

        long? DownloadCount { get; }

        System.Uri IconUrl { get; }

        Packaging.Core.PackageIdentity Identity { get; }

        bool IsListed { get; }

        Packaging.LicenseMetadata LicenseMetadata { get; }

        System.Uri LicenseUrl { get; }

        string Owners { get; }

        System.Collections.Generic.IReadOnlyList<string> OwnersList { get; }

        System.Uri PackageDetailsUrl { get; }

        bool PrefixReserved { get; }

        System.Uri ProjectUrl { get; }

        System.DateTimeOffset? Published { get; }

        System.Uri ReadmeUrl { get; }

        System.Uri ReportAbuseUrl { get; }

        bool RequireLicenseAcceptance { get; }

        string Summary { get; }

        string Tags { get; }

        string Title { get; }

        System.Collections.Generic.IEnumerable<PackageVulnerabilityMetadata> Vulnerabilities { get; }

        System.Threading.Tasks.Task<PackageDeprecationMetadata> GetDeprecationMetadataAsync();
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<VersionInfo>> GetVersionsAsync();
    }

    public partial interface ISourceRepositoryProvider
    {
        Configuration.IPackageSourceProvider PackageSourceProvider { get; }

        SourceRepository CreateRepository(Configuration.PackageSource source, FeedType type);
        SourceRepository CreateRepository(Configuration.PackageSource source);
        System.Collections.Generic.IEnumerable<SourceRepository> GetRepositories();
    }

    public abstract partial class LegacyFeedCapabilityResource : INuGetResource, ILegacyFeedCapabilityResource
    {
        public abstract System.Threading.Tasks.Task<bool> SupportsIsAbsoluteLatestVersionAsync(Common.ILogger log, System.Threading.CancellationToken token);
        public abstract System.Threading.Tasks.Task<bool> SupportsSearchAsync(Common.ILogger log, System.Threading.CancellationToken token);
    }

    public abstract partial class ListResource : INuGetResource
    {
        public abstract string Source { get; }

        public abstract System.Threading.Tasks.Task<Common.IEnumerableAsync<IPackageSearchMetadata>> ListAsync(string searchTerm, bool prerelease, bool allVersions, bool includeDelisted, Common.ILogger log, System.Threading.CancellationToken token);
    }

    public abstract partial class MetadataResource : INuGetResource
    {
        public System.Threading.Tasks.Task<bool> Exists(Packaging.Core.PackageIdentity identity, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public abstract System.Threading.Tasks.Task<bool> Exists(Packaging.Core.PackageIdentity identity, bool includeUnlisted, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
        public System.Threading.Tasks.Task<bool> Exists(string packageId, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public abstract System.Threading.Tasks.Task<bool> Exists(string packageId, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
        public System.Threading.Tasks.Task<Versioning.NuGetVersion> GetLatestVersion(string packageId, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, Versioning.NuGetVersion>>> GetLatestVersions(System.Collections.Generic.IEnumerable<string> packageIds, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetVersions(string packageId, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token) { throw null; }

        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetVersions(string packageId, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
    }

    public abstract partial class NuGetProtocolException : System.Exception
    {
        protected NuGetProtocolException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }

        public NuGetProtocolException(string message, System.Exception innerException) { }

        public NuGetProtocolException(string message) { }
    }

    public sealed partial class NuGetResourceProviderPositions
    {
        public const string First = "First";
        public const string Last = "Last";
    }

    public static partial class NuGetTestMode
    {
        public const string NuGetTestClientName = "NuGet Test Client";
        public static bool Enabled { get { throw null; } }

        public static T InvokeTestFunctionAgainstTestMode<T>(System.Func<T> function, bool testModeEnabled) { throw null; }
    }

    public partial class NullSourceCacheContext : SourceCacheContext
    {
        public override string GeneratedTempFolder { get { throw null; } }

        public static SourceCacheContext Instance { get { throw null; } }

        public override SourceCacheContext Clone() { throw null; }

        public override SourceCacheContext WithRefreshCacheTrue() { throw null; }
    }

    public partial class OfflineFeedAddContext
    {
        public OfflineFeedAddContext(string packagePath, string source, Common.ILogger logger, bool throwIfSourcePackageIsInvalid, bool throwIfPackageExistsAndInvalid, bool throwIfPackageExists, Packaging.PackageExtractionContext extractionContext) { }

        public Packaging.PackageExtractionContext ExtractionContext { get { throw null; } }

        public Common.ILogger Logger { get { throw null; } }

        public string PackagePath { get { throw null; } }

        public string Source { get { throw null; } }

        public bool ThrowIfPackageExists { get { throw null; } }

        public bool ThrowIfPackageExistsAndInvalid { get { throw null; } }

        public bool ThrowIfSourcePackageIsInvalid { get { throw null; } }
    }

    public static partial class OfflineFeedUtility
    {
        public static System.Threading.Tasks.Task AddPackageToSource(OfflineFeedAddContext offlineFeedAddContext, System.Threading.CancellationToken token) { throw null; }

        public static string GetPackageDirectory(Packaging.Core.PackageIdentity packageIdentity, string offlineFeed) { throw null; }

        public static bool PackageExists(Packaging.Core.PackageIdentity packageIdentity, string offlineFeed, out bool isValidPackage) { throw null; }

        public static void ThrowIfInvalid(string path) { }

        public static void ThrowIfInvalidOrNotFound(string path, bool isDirectory, string resourceString) { }
    }

    public partial class PackageDownloadContext
    {
        public PackageDownloadContext(SourceCacheContext sourceCacheContext, string directDownloadDirectory, bool directDownload, Configuration.PackageSourceMapping packageSourceMappingConfiguration) { }

        public PackageDownloadContext(SourceCacheContext sourceCacheContext, string directDownloadDirectory, bool directDownload) { }

        public PackageDownloadContext(SourceCacheContext sourceCacheContext) { }

        public Packaging.Signing.ClientPolicyContext ClientPolicyContext { get { throw null; } set { } }

        public bool DirectDownload { get { throw null; } }

        public string DirectDownloadDirectory { get { throw null; } }

        public Configuration.PackageSourceMapping PackageSourceMapping { get { throw null; } }

        public System.Guid ParentId { get { throw null; } set { } }

        public SourceCacheContext SourceCacheContext { get { throw null; } }
    }

    public abstract partial class PackageMetadataResource : INuGetResource
    {
        public abstract System.Threading.Tasks.Task<IPackageSearchMetadata> GetMetadataAsync(Packaging.Core.PackageIdentity package, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<IPackageSearchMetadata>> GetMetadataAsync(string packageId, bool includePrerelease, bool includeUnlisted, SourceCacheContext sourceCacheContext, Common.ILogger log, System.Threading.CancellationToken token);
    }

    public partial class PackageProgressEventArgs : System.EventArgs
    {
        public PackageProgressEventArgs(Packaging.Core.PackageIdentity identity, Configuration.PackageSource source, double complete) { }

        public double Complete { get { throw null; } }

        public bool HasPackageSource { get { throw null; } }

        public bool IsComplete { get { throw null; } }

        public Packaging.Core.PackageIdentity PackageIdentity { get { throw null; } }

        public Configuration.PackageSource PackageSource { get { throw null; } }
    }

    public partial class PackageSearchMetadataBuilder
    {
        internal PackageSearchMetadataBuilder() { }

        public IPackageSearchMetadata Build() { throw null; }

        public static PackageSearchMetadataBuilder FromIdentity(Packaging.Core.PackageIdentity identity) { throw null; }

        public static PackageSearchMetadataBuilder FromMetadata(IPackageSearchMetadata metadata) { throw null; }

        public PackageSearchMetadataBuilder WithDeprecation(Common.AsyncLazy<PackageDeprecationMetadata> lazyDeprecationFactory) { throw null; }

        public PackageSearchMetadataBuilder WithVersions(Common.AsyncLazy<System.Collections.Generic.IEnumerable<VersionInfo>> lazyVersionsFactory) { throw null; }

        public partial class ClonedPackageSearchMetadata : IPackageSearchMetadata
        {
            public string Authors { get { throw null; } set { } }

            public System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencySets { get { throw null; } set { } }

            public string Description { get { throw null; } set { } }

            public long? DownloadCount { get { throw null; } set { } }

            public System.Uri IconUrl { get { throw null; } set { } }

            public Packaging.Core.PackageIdentity Identity { get { throw null; } set { } }

            public bool IsListed { get { throw null; } set { } }

            public Packaging.LicenseMetadata LicenseMetadata { get { throw null; } set { } }

            public System.Uri LicenseUrl { get { throw null; } set { } }

            public string Owners { get { throw null; } set { } }

            public System.Collections.Generic.IReadOnlyList<string> OwnersList { get { throw null; } set { } }

            public System.Uri PackageDetailsUrl { get { throw null; } set { } }

            public string PackagePath { get { throw null; } set { } }

            [System.Obsolete("PackagePath is recommended in place of PackageReader")]
            public System.Func<Packaging.PackageReaderBase> PackageReader { get { throw null; } set { } }

            public bool PrefixReserved { get { throw null; } set { } }

            public System.Uri ProjectUrl { get { throw null; } set { } }

            public System.DateTimeOffset? Published { get { throw null; } set { } }

            public System.Uri ReadmeUrl { get { throw null; } set { } }

            public System.Uri ReportAbuseUrl { get { throw null; } set { } }

            public bool RequireLicenseAcceptance { get { throw null; } set { } }

            public string Summary { get { throw null; } set { } }

            public string Tags { get { throw null; } set { } }

            public string Title { get { throw null; } set { } }

            public System.Collections.Generic.IEnumerable<PackageVulnerabilityMetadata> Vulnerabilities { get { throw null; } set { } }

            public System.Threading.Tasks.Task<PackageDeprecationMetadata> GetDeprecationMetadataAsync() { throw null; }

            public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<VersionInfo>> GetVersionsAsync() { throw null; }
        }
    }

    public static partial class PackageSearchMetadataExtensions
    {
        public static IPackageSearchMetadata WithVersions(this IPackageSearchMetadata metadata, System.Collections.Generic.IEnumerable<VersionInfo> versions) { throw null; }

        public static IPackageSearchMetadata WithVersions(this IPackageSearchMetadata metadata, System.Func<System.Collections.Generic.IEnumerable<VersionInfo>> valueFactory) { throw null; }

        public static IPackageSearchMetadata WithVersions(this IPackageSearchMetadata metadata, System.Func<System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<VersionInfo>>> asyncValueFactory) { throw null; }
    }

    public abstract partial class PackageSearchResource : INuGetResource
    {
        public abstract System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<IPackageSearchMetadata>> SearchAsync(string searchTerm, SearchFilter filters, int skip, int take, Common.ILogger log, System.Threading.CancellationToken cancellationToken);
    }

    public partial class PackageUpdateResource : INuGetResource
    {
        public PackageUpdateResource(string source, HttpSource httpSource) { }

        public Configuration.ISettings Settings { get { throw null; } set { } }

        public System.Uri SourceUri { get { throw null; } }

        public System.Threading.Tasks.Task Delete(string packageId, string packageVersion, System.Func<string, string> getApiKey, System.Func<string, bool> confirm, bool noServiceEndpoint, Common.ILogger log) { throw null; }

        public System.Threading.Tasks.Task Delete(string packageId, string packageVersion, System.Func<string, string> getApiKey, System.Func<string, bool> confirm, bool noServiceEndpoint, bool allowInsecureConnections, Common.ILogger log) { throw null; }

        public static void ForceDeleteDirectory(string path) { }

        public System.Threading.Tasks.Task Push(System.Collections.Generic.IList<string> packagePaths, string symbolSource, int timeoutInSecond, bool disableBuffering, System.Func<string, string> getApiKey, System.Func<string, string> getSymbolApiKey, bool noServiceEndpoint, bool skipDuplicate, SymbolPackageUpdateResourceV3 symbolPackageUpdateResource, Common.ILogger log) { throw null; }

        public System.Threading.Tasks.Task Push(System.Collections.Generic.IList<string> packagePaths, string symbolSource, int timeoutInSecond, bool disableBuffering, System.Func<string, string> getApiKey, System.Func<string, string> getSymbolApiKey, bool noServiceEndpoint, bool skipDuplicate, SymbolPackageUpdateResourceV3 symbolPackageUpdateResource, bool allowInsecureConnections, Common.ILogger log) { throw null; }

        [System.Obsolete("Consolidating to one PackageUpdateResource.Push method which has all parameters defined.")]
        public System.Threading.Tasks.Task Push(string packagePath, string symbolSource, int timeoutInSecond, bool disableBuffering, System.Func<string, string> getApiKey, System.Func<string, string> getSymbolApiKey, bool noServiceEndpoint, Common.ILogger log) { throw null; }

        [System.Obsolete("Use Push method which takes multiple package paths.")]
        public System.Threading.Tasks.Task Push(string packagePath, string symbolSource, int timeoutInSecond, bool disableBuffering, System.Func<string, string> getApiKey, System.Func<string, string> getSymbolApiKey, bool noServiceEndpoint, bool skipDuplicate, SymbolPackageUpdateResourceV3 symbolPackageUpdateResource, Common.ILogger log) { throw null; }
    }

    public sealed partial class PluginFindPackageByIdResource : FindPackageByIdResource
    {
        public PluginFindPackageByIdResource(Plugins.IPlugin plugin, Plugins.IPluginMulticlientUtilities utilities, Configuration.PackageSource packageSource) { }

        public override System.Threading.Tasks.Task<bool> CopyNupkgToStreamAsync(string id, Versioning.NuGetVersion version, System.IO.Stream destination, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> DoesPackageExistAsync(string id, Versioning.NuGetVersion version, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<FindPackageByIdDependencyInfo> GetDependencyInfoAsync(string id, Versioning.NuGetVersion version, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class PluginResource : INuGetResource
    {
        public PluginResource(System.Collections.Generic.IEnumerable<Plugins.PluginCreationResult> pluginCreationResults, Configuration.PackageSource packageSource, Configuration.ICredentialService credentialService) { }

        public System.Threading.Tasks.Task<GetPluginResult> GetPluginAsync(Plugins.OperationClaim requiredClaim, System.Threading.CancellationToken cancellationToken) { throw null; }

        public sealed partial class GetPluginResult
        {
            internal GetPluginResult() { }

            public Plugins.IPlugin Plugin { get { throw null; } }

            public Plugins.IPluginMulticlientUtilities PluginMulticlientUtilities { get { throw null; } }
        }
    }

    public partial class PluginResourceProvider : ResourceProvider
    {
        public PluginResourceProvider() : base(default!) { }

        public PluginResourceProvider(Plugins.IPluginManager pluginManager) : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, INuGetResource>> TryCreate(SourceRepository source, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class RemoteSourceDependencyInfo : System.IEquatable<RemoteSourceDependencyInfo>
    {
        public RemoteSourceDependencyInfo(Packaging.Core.PackageIdentity identity, bool listed, System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> dependencyGroups, string contentUri) { }

        public string ContentUri { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> DependencyGroups { get { throw null; } }

        public Packaging.Core.PackageIdentity Identity { get { throw null; } }

        public bool Listed { get { throw null; } }

        public bool Equals(RemoteSourceDependencyInfo other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public static partial class Repository
    {
        public static RepositoryFactory Factory { get { throw null; } }

        public static ProviderFactory Provider { get { throw null; } set { } }

        [System.Obsolete("https://github.com/NuGet/Home/issues/8479")]
        public static ISourceRepositoryProvider CreateProvider(System.Collections.Generic.IEnumerable<INuGetResourceProvider> resourceProviders, string rootPath) { throw null; }

        [System.Obsolete("https://github.com/NuGet/Home/issues/8479")]
        public static ISourceRepositoryProvider CreateProvider(System.Collections.Generic.IEnumerable<INuGetResourceProvider> resourceProviders) { throw null; }

        public static SourceRepository CreateSource(System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> resourceProviders, Configuration.PackageSource source, FeedType type) { throw null; }

        public static SourceRepository CreateSource(System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> resourceProviders, Configuration.PackageSource source) { throw null; }

        public static SourceRepository CreateSource(System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> resourceProviders, string sourceUrl, FeedType type) { throw null; }

        public static SourceRepository CreateSource(System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> resourceProviders, string sourceUrl) { throw null; }

        public partial class ProviderFactory
        {
            public virtual System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> GetCoreV3() { throw null; }
        }

        public partial class RepositoryFactory
        {
        }
    }

    public abstract partial class ResourceProvider : INuGetResourceProvider
    {
        public ResourceProvider(System.Type resourceType, string name, System.Collections.Generic.IEnumerable<string> before, System.Collections.Generic.IEnumerable<string> after) { }

        public ResourceProvider(System.Type resourceType, string name, string? before) { }

        public ResourceProvider(System.Type resourceType, string name) { }

        public ResourceProvider(System.Type resourceType) { }

        public virtual System.Collections.Generic.IEnumerable<string> After { get { throw null; } }

        public virtual System.Collections.Generic.IEnumerable<string> Before { get { throw null; } }

        public virtual string Name { get { throw null; } }

        public virtual System.Type ResourceType { get { throw null; } }

        public abstract System.Threading.Tasks.Task<System.Tuple<bool, INuGetResource?>> TryCreate(SourceRepository source, System.Threading.CancellationToken token);
    }

    public partial class RetriableProtocolException : NuGetProtocolException
    {
        protected RetriableProtocolException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) : base(default!) { }

        public RetriableProtocolException(string message, System.Exception innerException) : base(default!) { }

        public RetriableProtocolException(string message) : base(default!) { }
    }

    public partial class SearchFilter
    {
        public SearchFilter(bool includePrerelease, SearchFilterType? filter) { }

        public SearchFilter(bool includePrerelease) { }

        public SearchFilterType? Filter { get { throw null; } }

        public bool IncludeDelisted { get { throw null; } set { } }

        public bool IncludePrerelease { get { throw null; } }

        public SearchOrderBy? OrderBy { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<string> PackageTypes { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<string> SupportedFrameworks { get { throw null; } set { } }
    }

    public enum SearchFilterType
    {
        IsLatestVersion = 0,
        IsAbsoluteLatestVersion = 1
    }

    public enum SearchOrderBy
    {
        Id = 0
    }

    public partial class SourceCacheContext : System.IDisposable
    {
        public bool DirectDownload { get { throw null; } set { } }

        public virtual string GeneratedTempFolder { get { throw null; } set { } }

        public bool IgnoreFailedSources { get { throw null; } set { } }

        public System.DateTimeOffset? MaxAge { get { throw null; } set { } }

        public System.TimeSpan MaxAgeTimeSpan { get { throw null; } }

        public bool NoCache { get { throw null; } set { } }

        public bool RefreshMemoryCache { get { throw null; } set { } }

        public System.Guid SessionId { get { throw null; } set { } }

        public virtual SourceCacheContext Clone() { throw null; }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }

        public virtual SourceCacheContext WithRefreshCacheTrue() { throw null; }
    }

    public partial class SourcePackageDependencyInfo : Packaging.Core.PackageDependencyInfo
    {
        public SourcePackageDependencyInfo(Packaging.Core.PackageIdentity identity, System.Collections.Generic.IEnumerable<Packaging.Core.PackageDependency> dependencies, bool listed, SourceRepository source, System.Uri downloadUri, string packageHash) : base(default!, default(Versioning.NuGetVersion)!) { }

        public SourcePackageDependencyInfo(string id, Versioning.NuGetVersion version, System.Collections.Generic.IEnumerable<Packaging.Core.PackageDependency> dependencies, bool listed, SourceRepository source, System.Uri downloadUri, string packageHash) : base(default!, default(Versioning.NuGetVersion)!) { }

        public SourcePackageDependencyInfo(string id, Versioning.NuGetVersion version, System.Collections.Generic.IEnumerable<Packaging.Core.PackageDependency> dependencies, bool listed, SourceRepository source) : base(default!, default(Versioning.NuGetVersion)!) { }

        public System.Uri DownloadUri { get { throw null; } }

        public bool Listed { get { throw null; } }

        public string PackageHash { get { throw null; } }

        public SourceRepository Source { get { throw null; } }
    }

    public partial class SourceRepository
    {
        protected SourceRepository() { }

        public SourceRepository(Configuration.PackageSource source, System.Collections.Generic.IEnumerable<INuGetResourceProvider> providers) { }

        public SourceRepository(Configuration.PackageSource source, System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> providers, FeedType feedTypeOverride) { }

        public SourceRepository(Configuration.PackageSource source, System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> providers) { }

        public FeedType FeedTypeOverride { get { throw null; } }

        public virtual Configuration.PackageSource PackageSource { get { throw null; } }

        public virtual System.Threading.Tasks.Task<FeedType> GetFeedType(System.Threading.CancellationToken token) { throw null; }

        public virtual T GetResource<T>()
            where T : class, INuGetResource { throw null; }

        public virtual T GetResource<T>(System.Threading.CancellationToken token)
            where T : class, INuGetResource { throw null; }

        public virtual System.Threading.Tasks.Task<T> GetResourceAsync<T>()
            where T : class, INuGetResource { throw null; }

        public virtual System.Threading.Tasks.Task<T> GetResourceAsync<T>(System.Threading.CancellationToken token)
            where T : class, INuGetResource { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class SourceRepositoryProvider : ISourceRepositoryProvider
    {
        public SourceRepositoryProvider(Configuration.IPackageSourceProvider packageSourceProvider, System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> resourceProviders) { }

        [System.Obsolete("https://github.com/NuGet/Home/issues/8479")]
        public SourceRepositoryProvider(Configuration.ISettings settings, System.Collections.Generic.IEnumerable<System.Lazy<INuGetResourceProvider>> resourceProviders) { }

        public Configuration.IPackageSourceProvider PackageSourceProvider { get { throw null; } }

        public SourceRepository CreateRepository(Configuration.PackageSource source, FeedType type) { throw null; }

        public SourceRepository CreateRepository(Configuration.PackageSource source) { throw null; }

        public System.Collections.Generic.IEnumerable<SourceRepository> GetRepositories() { throw null; }
    }

    public partial class SymbolPackageUpdateResourceV3 : INuGetResource
    {
        public SymbolPackageUpdateResourceV3(string source, HttpSource httpSource) { }

        public System.Uri SourceUri { get { throw null; } }
    }

    public static partial class UserAgent
    {
        public static string UserAgentString { get { throw null; } }

        public static void SetUserAgent(System.Net.Http.HttpClient client) { }

        public static void SetUserAgentString(UserAgentStringBuilder builder) { }
    }

    public partial class UserAgentStringBuilder
    {
        public static readonly string DefaultNuGetClientName;
        public UserAgentStringBuilder() { }

        public UserAgentStringBuilder(string clientName) { }

        public string NuGetClientVersion { get { throw null; } }

        public string Build() { throw null; }

        public UserAgentStringBuilder WithOSDescription(string osInfo) { throw null; }

        public UserAgentStringBuilder WithVisualStudioSKU(string vsInfo) { throw null; }
    }

    public partial class VersionInfo
    {
        public VersionInfo(Versioning.NuGetVersion version, long? downloadCount) { }

        public VersionInfo(Versioning.NuGetVersion version, string downloadCount) { }

        public VersionInfo(Versioning.NuGetVersion version) { }

        public long? DownloadCount { get { throw null; } }

        public IPackageSearchMetadata PackageSearchMetadata { get { throw null; } set { } }

        public Versioning.NuGetVersion Version { get { throw null; } }
    }
}

namespace NuGet.Protocol.Events
{
    public sealed partial class ProtocolDiagnosticHttpEvent : ProtocolDiagnosticHttpEventBase
    {
        internal ProtocolDiagnosticHttpEvent() : base(default!) { }

        public long Bytes { get { throw null; } }

        public System.TimeSpan EventDuration { get { throw null; } }

        public bool IsSuccess { get { throw null; } }

        public System.DateTime Timestamp { get { throw null; } }
    }

    public abstract partial class ProtocolDiagnosticHttpEventBase
    {
        protected ProtocolDiagnosticHttpEventBase(ProtocolDiagnosticHttpEventBase other) { }

        protected ProtocolDiagnosticHttpEventBase(string source, System.Uri url, System.TimeSpan? headerDuration, int? httpStatusCode, bool isRetry, bool isCancelled, bool isLastAttempt) { }

        public System.TimeSpan? HeaderDuration { get { throw null; } }

        public int? HttpStatusCode { get { throw null; } }

        public bool IsCancelled { get { throw null; } }

        public bool IsLastAttempt { get { throw null; } }

        public bool IsRetry { get { throw null; } }

        public string Source { get { throw null; } }

        public System.Uri Url { get { throw null; } }
    }

    public sealed partial class ProtocolDiagnosticNupkgCopiedEvent
    {
        public ProtocolDiagnosticNupkgCopiedEvent(string source, long fileSize) { }

        public long FileSize { get { throw null; } }

        public string Source { get { throw null; } }
    }

    public sealed partial class ProtocolDiagnosticResourceEvent
    {
        public ProtocolDiagnosticResourceEvent(string source, string resourceType, string type, string method, System.TimeSpan duration) { }

        public System.TimeSpan Duration { get { throw null; } }

        public string Method { get { throw null; } }

        public string ResourceType { get { throw null; } }

        public string Source { get { throw null; } }

        public string Type { get { throw null; } }
    }

    public static partial class ProtocolDiagnostics
    {
        public static event ProtocolDiagnosticHttpEventHandler HttpEvent { add { } remove { } }

        public static event ProtocolDiagnosticsNupkgCopiedEventHandler NupkgCopiedEvent { add { } remove { } }

        public static event ProtocolDiagnosticResourceEventHandler ResourceEvent { add { } remove { } }

        public delegate void ProtocolDiagnosticHttpEventHandler(ProtocolDiagnosticHttpEvent pdEvent);
        public delegate void ProtocolDiagnosticResourceEventHandler(ProtocolDiagnosticResourceEvent pdrEvent);
        public delegate void ProtocolDiagnosticsNupkgCopiedEventHandler(ProtocolDiagnosticNupkgCopiedEvent ncEvent);
    }
}

namespace NuGet.Protocol.LocalRepositories
{
    public partial class LocalPackageListResourceProvider : Core.Types.ResourceProvider
    {
        public LocalPackageListResourceProvider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }
}

namespace NuGet.Protocol.Model
{
    public sealed partial class GetVulnerabilityInfoResult
    {
        public GetVulnerabilityInfoResult(System.Collections.Generic.IReadOnlyList<System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyList<PackageVulnerabilityInfo>>>? knownVulnerabilities, System.AggregateException? exceptions) { }

        public System.AggregateException? Exceptions { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyList<PackageVulnerabilityInfo>>>? KnownVulnerabilities { get { throw null; } }
    }

    public sealed partial class PackageVulnerabilityInfo : System.IEquatable<PackageVulnerabilityInfo>
    {
        [System.Text.Json.Serialization.JsonConstructor]
        public PackageVulnerabilityInfo(System.Uri url, PackageVulnerabilitySeverity severity, Versioning.VersionRange versions) { }

        [System.Text.Json.Serialization.JsonPropertyName("severity")]
        public PackageVulnerabilitySeverity Severity { get { throw null; } }

        [System.Text.Json.Serialization.JsonPropertyName("url")]
        public System.Uri Url { get { throw null; } }

        [System.Text.Json.Serialization.JsonPropertyName("versions")]
        public Versioning.VersionRange Versions { get { throw null; } }

        public bool Equals(PackageVulnerabilityInfo? other) { throw null; }

        public override bool Equals(object? obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public sealed partial class V3VulnerabilityIndexEntry
    {
        public V3VulnerabilityIndexEntry(string name, System.Uri url, string updated, string? comment) { }

        [System.Text.Json.Serialization.JsonPropertyName("comment")]
        public string? Comment { get { throw null; } }

        [System.Text.Json.Serialization.JsonPropertyName("@name")]
        public string Name { get { throw null; } }

        [System.Text.Json.Serialization.JsonPropertyName("@updated")]
        public string Updated { get { throw null; } }

        [System.Text.Json.Serialization.JsonPropertyName("@id")]
        public System.Uri Url { get { throw null; } }
    }
}

namespace NuGet.Protocol.Plugins
{
    public sealed partial class AutomaticProgressReporter : System.IDisposable
    {
        internal AutomaticProgressReporter() { }

        public static AutomaticProgressReporter Create(IConnection connection, Message request, System.TimeSpan interval, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }
    }

    public sealed partial class CloseRequestHandler : IRequestHandler, System.IDisposable
    {
        public CloseRequestHandler(IPlugin plugin) { }

        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public void Dispose() { }

        public System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class Connection : IConnection, System.IDisposable
    {
        public Connection(IMessageDispatcher dispatcher, ISender sender, IReceiver receiver, ConnectionOptions options) { }

        public IMessageDispatcher MessageDispatcher { get { throw null; } }

        public ConnectionOptions Options { get { throw null; } }

        public Versioning.SemanticVersion ProtocolVersion { get { throw null; } }

        public ConnectionState State { get { throw null; } }

        public event System.EventHandler<ProtocolErrorEventArgs> Faulted { add { } remove { } }

        public event System.EventHandler<MessageEventArgs> MessageReceived { add { } remove { } }

        public void Close() { }

        public System.Threading.Tasks.Task ConnectAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task SendAsync(Message message, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<TInbound> SendRequestAndReceiveResponseAsync<TOutbound, TInbound>(MessageMethod method, TOutbound payload, System.Threading.CancellationToken cancellationToken)
            where TOutbound : class where TInbound : class { throw null; }
    }

    public sealed partial class ConnectionOptions
    {
        public ConnectionOptions(Versioning.SemanticVersion protocolVersion, Versioning.SemanticVersion minimumProtocolVersion, System.TimeSpan handshakeTimeout, System.TimeSpan requestTimeout) { }

        public System.TimeSpan HandshakeTimeout { get { throw null; } }

        public Versioning.SemanticVersion MinimumProtocolVersion { get { throw null; } }

        public Versioning.SemanticVersion ProtocolVersion { get { throw null; } }

        public System.TimeSpan RequestTimeout { get { throw null; } }

        public static ConnectionOptions CreateDefault(Common.IEnvironmentVariableReader reader = null) { throw null; }

        public void SetRequestTimeout(System.TimeSpan requestTimeout) { }
    }

    public enum ConnectionState
    {
        FailedToHandshake = 0,
        Closing = 1,
        Closed = 2,
        ReadyToConnect = 3,
        Connecting = 4,
        Handshaking = 5,
        Connected = 6
    }

    public sealed partial class CopyFilesInPackageRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public CopyFilesInPackageRequest(string packageSourceRepository, string packageId, string packageVersion, System.Collections.Generic.IEnumerable<string> filesInPackage, string destinationFolderPath) { }

        [Newtonsoft.Json.JsonRequired]
        public string DestinationFolderPath { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public System.Collections.Generic.IEnumerable<string> FilesInPackage { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageVersion { get { throw null; } }
    }

    public sealed partial class CopyFilesInPackageResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public CopyFilesInPackageResponse(MessageResponseCode responseCode, System.Collections.Generic.IEnumerable<string> copiedFiles) { }

        public System.Collections.Generic.IEnumerable<string> CopiedFiles { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class CopyNupkgFileRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public CopyNupkgFileRequest(string packageSourceRepository, string packageId, string packageVersion, string destinationFilePath) { }

        [Newtonsoft.Json.JsonRequired]
        public string DestinationFilePath { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageVersion { get { throw null; } }
    }

    public sealed partial class CopyNupkgFileResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public CopyNupkgFileResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public abstract partial class EmbeddedSignatureVerifier
    {
        public static EmbeddedSignatureVerifier Create() { throw null; }

        public abstract bool IsValid(string filePath);
    }

    public sealed partial class FallbackEmbeddedSignatureVerifier : EmbeddedSignatureVerifier
    {
        public override bool IsValid(string filePath) { throw null; }
    }

    public sealed partial class Fault
    {
        [Newtonsoft.Json.JsonConstructor]
        public Fault(string message) { }

        [Newtonsoft.Json.JsonRequired]
        public string Message { get { throw null; } }
    }

    public sealed partial class FaultedPluginEventArgs : System.EventArgs
    {
        public FaultedPluginEventArgs(IPlugin plugin, System.Exception exception) { }

        public System.Exception Exception { get { throw null; } }

        public IPlugin Plugin { get { throw null; } }
    }

    public sealed partial class GetAuthenticationCredentialsRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetAuthenticationCredentialsRequest(System.Uri uri, bool isRetry, bool isNonInteractive, bool canShowDialog) { }

        [Newtonsoft.Json.JsonRequired]
        public bool CanShowDialog { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public bool IsNonInteractive { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public bool IsRetry { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public System.Uri Uri { get { throw null; } }
    }

    public sealed partial class GetAuthenticationCredentialsResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetAuthenticationCredentialsResponse(string username, string password, string message, System.Collections.Generic.IList<string> authenticationTypes, MessageResponseCode responseCode) { }

        public System.Collections.Generic.IList<string> AuthenticationTypes { get { throw null; } }

        public string Message { get { throw null; } }

        public string Password { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }

        public string Username { get { throw null; } }

        public bool IsValid() { throw null; }
    }

    public sealed partial class GetCredentialsRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetCredentialsRequest(string packageSourceRepository, System.Net.HttpStatusCode statusCode) { }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public System.Net.HttpStatusCode StatusCode { get { throw null; } }
    }

    public sealed partial class GetCredentialsRequestHandler : IRequestHandler, System.IDisposable
    {
        public GetCredentialsRequestHandler(IPlugin plugin, System.Net.IWebProxy proxy, Configuration.ICredentialService credentialService) { }

        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public void AddOrUpdateSourceRepository(Core.Types.SourceRepository sourceRepository) { }

        public void Dispose() { }

        public System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class GetCredentialsResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetCredentialsResponse(MessageResponseCode responseCode, string username, string password, System.Collections.Generic.IReadOnlyList<string> authenticationTypes = null) { }

        public System.Collections.Generic.IReadOnlyList<string> AuthenticationTypes { get { throw null; } }

        public string Password { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }

        public string Username { get { throw null; } }
    }

    public sealed partial class GetFilesInPackageRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetFilesInPackageRequest(string packageSourceRepository, string packageId, string packageVersion) { }

        [Newtonsoft.Json.JsonRequired]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageVersion { get { throw null; } }
    }

    public sealed partial class GetFilesInPackageResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetFilesInPackageResponse(MessageResponseCode responseCode, System.Collections.Generic.IEnumerable<string> files) { }

        public System.Collections.Generic.IEnumerable<string> Files { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class GetOperationClaimsRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetOperationClaimsRequest(string packageSourceRepository, Newtonsoft.Json.Linq.JObject serviceIndex) { }

        public string PackageSourceRepository { get { throw null; } }

        public Newtonsoft.Json.Linq.JObject ServiceIndex { get { throw null; } }
    }

    public sealed partial class GetOperationClaimsResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetOperationClaimsResponse(System.Collections.Generic.IEnumerable<OperationClaim> claims) { }

        [Newtonsoft.Json.JsonRequired]
        public System.Collections.Generic.IReadOnlyList<OperationClaim> Claims { get { throw null; } }
    }

    public sealed partial class GetPackageHashRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetPackageHashRequest(string packageSourceRepository, string packageId, string packageVersion, string hashAlgorithm) { }

        [Newtonsoft.Json.JsonRequired]
        public string HashAlgorithm { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageVersion { get { throw null; } }
    }

    public sealed partial class GetPackageHashResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetPackageHashResponse(MessageResponseCode responseCode, string hash) { }

        public string Hash { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class GetPackageVersionsRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetPackageVersionsRequest(string packageSourceRepository, string packageId) { }

        [Newtonsoft.Json.JsonRequired]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }
    }

    public sealed partial class GetPackageVersionsResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetPackageVersionsResponse(MessageResponseCode responseCode, System.Collections.Generic.IEnumerable<string> versions) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }

        public System.Collections.Generic.IEnumerable<string> Versions { get { throw null; } }
    }

    public sealed partial class GetServiceIndexRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetServiceIndexRequest(string packageSourceRepository) { }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }
    }

    public sealed partial class GetServiceIndexRequestHandler : IRequestHandler, System.IDisposable
    {
        public GetServiceIndexRequestHandler(IPlugin plugin) { }

        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public void AddOrUpdateSourceRepository(Core.Types.SourceRepository sourceRepository) { }

        public void Dispose() { }

        public System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class GetServiceIndexResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public GetServiceIndexResponse(MessageResponseCode responseCode, Newtonsoft.Json.Linq.JObject serviceIndex) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }

        public Newtonsoft.Json.Linq.JObject ServiceIndex { get { throw null; } }
    }

    public sealed partial class HandshakeRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public HandshakeRequest(Versioning.SemanticVersion protocolVersion, Versioning.SemanticVersion minimumProtocolVersion) { }

        [Newtonsoft.Json.JsonRequired]
        public Versioning.SemanticVersion MinimumProtocolVersion { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public Versioning.SemanticVersion ProtocolVersion { get { throw null; } }
    }

    public sealed partial class HandshakeResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public HandshakeResponse(MessageResponseCode responseCode, Versioning.SemanticVersion protocolVersion) { }

        public Versioning.SemanticVersion ProtocolVersion { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public partial interface IConnection : System.IDisposable
    {
        IMessageDispatcher MessageDispatcher { get; }

        ConnectionOptions Options { get; }

        Versioning.SemanticVersion ProtocolVersion { get; }

        event System.EventHandler<ProtocolErrorEventArgs> Faulted;
        event System.EventHandler<MessageEventArgs> MessageReceived;
        void Close();
        System.Threading.Tasks.Task SendAsync(Message message, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<TInbound> SendRequestAndReceiveResponseAsync<TOutbound, TInbound>(MessageMethod method, TOutbound payload, System.Threading.CancellationToken cancellationToken)
            where TOutbound : class where TInbound : class;
    }

    public partial interface IIdGenerator
    {
        string GenerateUniqueId();
    }

    public partial interface IMessageDispatcher : System.IDisposable
    {
        IRequestHandlers RequestHandlers { get; }

        void Close();
        Message CreateMessage(MessageType type, MessageMethod method);
        Message CreateMessage<TPayload>(MessageType type, MessageMethod method, TPayload payload)
            where TPayload : class;
        System.Threading.Tasks.Task DispatchCancelAsync(Message request, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task DispatchFaultAsync(Message request, Fault fault, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task DispatchProgressAsync(Message request, Progress progress, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<TInbound> DispatchRequestAsync<TOutbound, TInbound>(MessageMethod method, TOutbound payload, System.Threading.CancellationToken cancellationToken)
            where TOutbound : class where TInbound : class;
        System.Threading.Tasks.Task DispatchResponseAsync<TOutbound>(Message request, TOutbound responsePayload, System.Threading.CancellationToken cancellationToken)
            where TOutbound : class;
        void SetConnection(IConnection connection);
    }

    public sealed partial class InboundRequestContext : System.IDisposable
    {
        public InboundRequestContext(IConnection connection, string requestId, System.Threading.CancellationToken cancellationToken) { }

        public string RequestId { get { throw null; } }

        public void BeginFaultAsync(Message request, System.Exception exception) { }

        public void BeginResponseAsync(Message request, IRequestHandler requestHandler, IResponseHandler responseHandler) { }

        public void Cancel() { }

        public void Dispose() { }
    }

    public sealed partial class InitializeRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public InitializeRequest(string clientVersion, string culture, System.TimeSpan requestTimeout) { }

        [Newtonsoft.Json.JsonRequired]
        public string ClientVersion { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string Culture { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public System.TimeSpan RequestTimeout { get { throw null; } }
    }

    public sealed partial class InitializeResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public InitializeResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public partial interface IPlugin : System.IDisposable
    {
        IConnection Connection { get; }

        string FilePath { get; }

        string Id { get; }

        string Name { get; }

        event System.EventHandler BeforeClose;
        event System.EventHandler Closed;
        void Close();
    }

    public partial interface IPluginDiscoverer : System.IDisposable
    {
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PluginDiscoveryResult>> DiscoverAsync(System.Threading.CancellationToken cancellationToken);
    }

    public partial interface IPluginFactory : System.IDisposable
    {
        System.Threading.Tasks.Task<IPlugin> GetOrCreateAsync(string filePath, System.Collections.Generic.IEnumerable<string> arguments, IRequestHandlers requestHandlers, ConnectionOptions options, System.Threading.CancellationToken sessionCancellationToken);
    }

    public partial interface IPluginManager
    {
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PluginCreationResult>> CreatePluginsAsync(Core.Types.SourceRepository source, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PluginDiscoveryResult>> FindAvailablePluginsAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Tuple<bool, PluginCreationResult>> TryGetSourceAgnosticPluginAsync(PluginDiscoveryResult pluginDiscoveryResult, OperationClaim requestedOperationClaim, System.Threading.CancellationToken cancellationToken);
    }

    public partial interface IPluginMulticlientUtilities
    {
        System.Threading.Tasks.Task DoOncePerPluginLifetimeAsync(string key, System.Func<System.Threading.Tasks.Task> taskFunc, System.Threading.CancellationToken cancellationToken);
    }

    public partial interface IPluginProcess : System.IDisposable
    {
        int? ExitCode { get; }

        int? Id { get; }

        event System.EventHandler<IPluginProcess> Exited;
        event System.EventHandler<LineReadEventArgs> LineRead;
        void BeginReadLine();
        void CancelRead();
        void Kill();
    }

    public partial interface IReceiver : System.IDisposable
    {
        event System.EventHandler<ProtocolErrorEventArgs> Faulted;
        event System.EventHandler<MessageEventArgs> MessageReceived;
        void Close();
        void Connect();
    }

    public partial interface IRequestHandler
    {
        System.Threading.CancellationToken CancellationToken { get; }

        System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken);
    }

    public partial interface IRequestHandlers
    {
        void AddOrUpdate(MessageMethod method, System.Func<IRequestHandler> addHandlerFunc, System.Func<IRequestHandler, IRequestHandler> updateHandlerFunc);
        bool TryAdd(MessageMethod method, IRequestHandler handler);
        bool TryGet(MessageMethod method, out IRequestHandler handler);
        bool TryRemove(MessageMethod method);
    }

    public partial interface IResponseHandler
    {
        System.Threading.Tasks.Task SendResponseAsync<TPayload>(Message request, TPayload payload, System.Threading.CancellationToken cancellationToken)
            where TPayload : class;
    }

    public partial interface ISender : System.IDisposable
    {
        void Close();
        void Connect();
        System.Threading.Tasks.Task SendAsync(Message message, System.Threading.CancellationToken cancellationToken);
    }

    public static partial class JsonSerializationUtilities
    {
        public static Newtonsoft.Json.JsonSerializer Serializer { get { throw null; } }

        public static T Deserialize<T>(string json)
            where T : class { throw null; }

        public static Newtonsoft.Json.Linq.JObject FromObject(object value) { throw null; }

        public static void Serialize(Newtonsoft.Json.JsonWriter writer, object value) { }

        public static T ToObject<T>(Newtonsoft.Json.Linq.JObject jObject) { throw null; }
    }

    public sealed partial class LineReadEventArgs : System.EventArgs
    {
        public LineReadEventArgs(string line) { }

        public string Line { get { throw null; } }
    }

    public sealed partial class LogRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public LogRequest(Common.LogLevel logLevel, string message) { }

        [Newtonsoft.Json.JsonRequired]
        public Common.LogLevel LogLevel { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string Message { get { throw null; } }
    }

    public sealed partial class LogRequestHandler : IRequestHandler
    {
        public LogRequestHandler(Common.ILogger logger) { }

        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public static Common.LogLevel GetLogLevel(Common.ILogger logger) { throw null; }

        public System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void SetLogger(Common.ILogger logger) { }
    }

    public sealed partial class LogResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public LogResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class Message
    {
        [Newtonsoft.Json.JsonConstructor]
        public Message(string requestId, MessageType type, MessageMethod method, Newtonsoft.Json.Linq.JObject payload = null) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageMethod Method { get { throw null; } }

        public Newtonsoft.Json.Linq.JObject Payload { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string RequestId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public MessageType Type { get { throw null; } }
    }

    public sealed partial class MessageDispatcher : IMessageDispatcher, System.IDisposable, IResponseHandler
    {
        public MessageDispatcher(IRequestHandlers requestHandlers, IIdGenerator idGenerator) { }

        public IRequestHandlers RequestHandlers { get { throw null; } }

        public void Close() { }

        public Message CreateMessage(MessageType type, MessageMethod method) { throw null; }

        public Message CreateMessage<TPayload>(MessageType type, MessageMethod method, TPayload payload)
            where TPayload : class { throw null; }

        public System.Threading.Tasks.Task DispatchCancelAsync(Message request, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task DispatchFaultAsync(Message request, Fault fault, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task DispatchProgressAsync(Message request, Progress progress, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<TInbound> DispatchRequestAsync<TOutbound, TInbound>(MessageMethod method, TOutbound payload, System.Threading.CancellationToken cancellationToken)
            where TOutbound : class where TInbound : class { throw null; }

        public System.Threading.Tasks.Task DispatchResponseAsync<TOutbound>(Message request, TOutbound responsePayload, System.Threading.CancellationToken cancellationToken)
            where TOutbound : class { throw null; }

        public void Dispose() { }

        System.Threading.Tasks.Task IResponseHandler.SendResponseAsync<TPayload>(Message request, TPayload payload, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void SetConnection(IConnection connection) { }
    }

    public sealed partial class MessageEventArgs : System.EventArgs
    {
        public MessageEventArgs(Message message) { }

        public Message Message { get { throw null; } }
    }

    public enum MessageMethod
    {
        None = 0,
        Close = 1,
        CopyFilesInPackage = 2,
        CopyNupkgFile = 3,
        GetCredentials = 4,
        GetFilesInPackage = 5,
        GetOperationClaims = 6,
        GetPackageHash = 7,
        GetPackageVersions = 8,
        GetServiceIndex = 9,
        Handshake = 10,
        Initialize = 11,
        Log = 12,
        MonitorNuGetProcessExit = 13,
        PrefetchPackage = 14,
        SetCredentials = 15,
        SetLogLevel = 16,
        GetAuthenticationCredentials = 17
    }

    public enum MessageResponseCode
    {
        Success = 0,
        Error = 1,
        NotFound = 2
    }

    public enum MessageType
    {
        Cancel = 0,
        Fault = 1,
        Progress = 2,
        Request = 3,
        Response = 4
    }

    public static partial class MessageUtilities
    {
        public static Message Create(string requestId, MessageType type, MessageMethod method) { throw null; }

        public static Message Create<TPayload>(string requestId, MessageType type, MessageMethod method, TPayload payload)
            where TPayload : class { throw null; }

        public static TPayload DeserializePayload<TPayload>(Message message) { throw null; }
    }

    public sealed partial class MonitorNuGetProcessExitRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public MonitorNuGetProcessExitRequest(int processId) { }

        [Newtonsoft.Json.JsonRequired]
        public int ProcessId { get { throw null; } }
    }

    public sealed partial class MonitorNuGetProcessExitRequestHandler : IRequestHandler, System.IDisposable
    {
        public MonitorNuGetProcessExitRequestHandler(IPlugin plugin) { }

        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public void Dispose() { }

        public System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class MonitorNuGetProcessExitResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public MonitorNuGetProcessExitResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class NoOpDisposePlugin : IPlugin, System.IDisposable
    {
        public NoOpDisposePlugin(IPlugin plugin) { }

        public IConnection Connection { get { throw null; } }

        public string FilePath { get { throw null; } }

        public string Id { get { throw null; } }

        public string Name { get { throw null; } }

        public event System.EventHandler BeforeClose { add { } remove { } }

        public event System.EventHandler Closed { add { } remove { } }

        public void Close() { }

        public void Dispose() { }
    }

    public enum OperationClaim
    {
        DownloadPackage = 0,
        Authentication = 1
    }

    public abstract partial class OutboundRequestContext : System.IDisposable
    {
        public System.Threading.CancellationToken CancellationToken { get { throw null; } protected set { } }

        public string RequestId { get { throw null; } protected set { } }

        public void Dispose() { }

        protected abstract void Dispose(bool disposing);
        public abstract void HandleCancelResponse();
        public abstract void HandleFault(Message fault);
        public abstract void HandleProgress(Message progress);
        public abstract void HandleResponse(Message response);
    }

    public sealed partial class OutboundRequestContext<TResult> : OutboundRequestContext
    {
        public OutboundRequestContext(IConnection connection, Message request, System.TimeSpan? timeout, bool isKeepAlive, System.Threading.CancellationToken cancellationToken) { }

        public System.Threading.Tasks.Task<TResult> CompletionTask { get { throw null; } }

        protected override void Dispose(bool disposing) { }

        public override void HandleCancelResponse() { }

        public override void HandleFault(Message fault) { }

        public override void HandleProgress(Message progress) { }

        public override void HandleResponse(Message response) { }
    }

    public sealed partial class Plugin : IPlugin, System.IDisposable
    {
        public Plugin(string filePath, IConnection connection, IPluginProcess process, bool isOwnProcess, System.TimeSpan idleTimeout) { }

        public IConnection Connection { get { throw null; } }

        public string FilePath { get { throw null; } }

        public string Id { get { throw null; } }

        public string Name { get { throw null; } }

        public event System.EventHandler BeforeClose { add { } remove { } }

        public event System.EventHandler Closed { add { } remove { } }

        public event System.EventHandler<PluginEventArgs> Exited { add { } remove { } }

        public event System.EventHandler<FaultedPluginEventArgs> Faulted { add { } remove { } }

        public event System.EventHandler<PluginEventArgs> Idle { add { } remove { } }

        public void Close() { }

        public void Dispose() { }
    }

    public sealed partial class PluginCacheEntry
    {
        public PluginCacheEntry(string rootCacheFolder, string pluginFilePath, string requestKey) { }

        public System.Collections.Generic.IReadOnlyList<OperationClaim> OperationClaims { get { throw null; } set { } }

        public void LoadFromFile() { }

        public System.Threading.Tasks.Task UpdateCacheFileAsync() { throw null; }
    }

    public static partial class PluginConstants
    {
        public static readonly System.TimeSpan CloseTimeout;
        public static readonly System.TimeSpan IdleTimeout;
        public static readonly System.Collections.Generic.IEnumerable<string> PluginArguments;
        public static readonly System.TimeSpan ProgressInterval;
        public static readonly System.TimeSpan RequestTimeout;
    }

    public sealed partial class PluginCreationResult
    {
        public PluginCreationResult(IPlugin plugin, IPluginMulticlientUtilities utilities, System.Collections.Generic.IReadOnlyList<OperationClaim> claims) { }

        public PluginCreationResult(string message, System.Exception exception) { }

        public PluginCreationResult(string message) { }

        public System.Collections.Generic.IReadOnlyList<OperationClaim> Claims { get { throw null; } }

        public System.Exception Exception { get { throw null; } }

        public string Message { get { throw null; } }

        public IPlugin Plugin { get { throw null; } }

        public IPluginMulticlientUtilities PluginMulticlientUtilities { get { throw null; } }
    }

    public sealed partial class PluginDiscoverer : IPluginDiscoverer, System.IDisposable
    {
        public PluginDiscoverer(string rawPluginPaths, EmbeddedSignatureVerifier verifier) { }

        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PluginDiscoveryResult>> DiscoverAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }
    }

    public sealed partial class PluginDiscoveryResult
    {
        public PluginDiscoveryResult(PluginFile pluginFile) { }

        public string Message { get { throw null; } }

        public PluginFile PluginFile { get { throw null; } }
    }

    public static partial class PluginDiscoveryUtility
    {
        public static System.Lazy<string> InternalPluginDiscoveryRoot { get { throw null; } set { } }

        public static System.Collections.Generic.IEnumerable<string> GetConventionBasedPlugins(System.Collections.Generic.IEnumerable<string> directories) { throw null; }

        public static string GetNuGetHomePluginsPath() { throw null; }

        public static string GetNuGetPluginsDirectoryRelativeToNuGetAssembly(string nugetAssemblyPath) { throw null; }
    }

    public sealed partial class PluginEventArgs : System.EventArgs
    {
        public PluginEventArgs(IPlugin plugin) { }

        public IPlugin Plugin { get { throw null; } }
    }

    public sealed partial class PluginException : System.Exception
    {
        public PluginException(string message, System.Exception innerException) { }

        public PluginException(string message) { }
    }

    public sealed partial class PluginFactory : IPluginFactory, System.IDisposable
    {
        public PluginFactory(System.TimeSpan pluginIdleTimeout) { }

        public static System.Threading.Tasks.Task<IPlugin> CreateFromCurrentProcessAsync(IRequestHandlers requestHandlers, ConnectionOptions options, System.Threading.CancellationToken sessionCancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task<IPlugin> GetOrCreateAsync(string filePath, System.Collections.Generic.IEnumerable<string> arguments, IRequestHandlers requestHandlers, ConnectionOptions options, System.Threading.CancellationToken sessionCancellationToken) { throw null; }
    }

    public sealed partial class PluginFile
    {
        public PluginFile(string filePath, System.Lazy<PluginFileState> state) { }

        public string Path { get { throw null; } }

        public System.Lazy<PluginFileState> State { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public enum PluginFileState
    {
        Valid = 0,
        NotFound = 1,
        InvalidFilePath = 2,
        InvalidEmbeddedSignature = 3
    }

    public sealed partial class PluginManager : IPluginManager, System.IDisposable
    {
        public PluginManager(Common.IEnvironmentVariableReader reader, System.Lazy<IPluginDiscoverer> pluginDiscoverer, System.Func<System.TimeSpan, IPluginFactory> pluginFactoryCreator, System.Lazy<string> pluginsCacheDirectoryPath) { }

        public Common.IEnvironmentVariableReader EnvironmentVariableReader { get { throw null; } }

        public static IPluginManager Instance { get { throw null; } }

        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PluginCreationResult>> CreatePluginsAsync(Core.Types.SourceRepository source, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PluginDiscoveryResult>> FindAvailablePluginsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<System.Tuple<bool, PluginCreationResult>> TryGetSourceAgnosticPluginAsync(PluginDiscoveryResult pluginDiscoveryResult, OperationClaim requestedOperationClaim, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class PluginMulticlientUtilities : IPluginMulticlientUtilities
    {
        public System.Threading.Tasks.Task DoOncePerPluginLifetimeAsync(string key, System.Func<System.Threading.Tasks.Task> taskFunc, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class PluginPackageDownloader : Packaging.IPackageDownloader, System.IDisposable
    {
        public PluginPackageDownloader(IPlugin plugin, Packaging.Core.PackageIdentity packageIdentity, PluginPackageReader packageReader, string packageSourceRepository) { }

        public Packaging.IAsyncPackageContentReader ContentReader { get { throw null; } }

        public Packaging.Core.IAsyncPackageCoreReader CoreReader { get { throw null; } }

        public Packaging.Signing.ISignedPackageReader SignedPackageReader { get { throw null; } }

        public string Source { get { throw null; } }

        public System.Threading.Tasks.Task<bool> CopyNupkgFileToAsync(string destinationFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task<string> GetPackageHashAsync(string hashAlgorithm, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void SetExceptionHandler(System.Func<System.Exception, System.Threading.Tasks.Task<bool>> handleExceptionAsync) { }

        public void SetThrottle(System.Threading.SemaphoreSlim throttle) { }
    }

    public sealed partial class PluginPackageReader : Packaging.PackageReaderBase
    {
        public PluginPackageReader(IPlugin plugin, Packaging.Core.PackageIdentity packageIdentity, string packageSourceRepository) : base(default!) { }

        public override Packaging.NuspecReader NuspecReader { get { throw null; } }

        public override bool CanVerifySignedPackages(Packaging.Signing.SignedPackageVerifierSettings verifierSettings) { throw null; }

        public override System.Collections.Generic.IEnumerable<string> CopyFiles(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, Packaging.Core.ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> CopyFilesAsync(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, Packaging.Core.ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<string> CopyNupkgAsync(string nupkgFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        protected override void Dispose(bool disposing) { }

        public override System.Threading.Tasks.Task<byte[]> GetArchiveHashAsync(Common.HashAlgorithmName hashAlgorithm, System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetBuildItems() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetBuildItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override string GetContentHash(System.Threading.CancellationToken token, System.Func<string> GetUnsignedPackageHash = null) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetContentItems() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetContentItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override bool GetDevelopmentDependency() { throw null; }

        public override System.Threading.Tasks.Task<bool> GetDevelopmentDependencyAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<string> GetFiles() { throw null; }

        public override System.Collections.Generic.IEnumerable<string> GetFiles(string folder) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetFilesAsync(string folder, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetFilesAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetFrameworkItems() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetFrameworkItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override Packaging.Core.PackageIdentity GetIdentity() { throw null; }

        public override System.Threading.Tasks.Task<Packaging.Core.PackageIdentity> GetIdentityAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetItems(string folderName) { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetItemsAsync(string folderName, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetLibItems() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetLibItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override Versioning.NuGetVersion GetMinClientVersion() { throw null; }

        public override System.Threading.Tasks.Task<Versioning.NuGetVersion> GetMinClientVersionAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.IO.Stream GetNuspec() { throw null; }

        public override System.Threading.Tasks.Task<System.IO.Stream> GetNuspecAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override string GetNuspecFile() { throw null; }

        public override System.Threading.Tasks.Task<string> GetNuspecFileAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.NuspecReader> GetNuspecReaderAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup> GetPackageDependencies() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.PackageDependencyGroup>> GetPackageDependenciesAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IReadOnlyList<Packaging.Core.PackageType> GetPackageTypes() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<Packaging.Core.PackageType>> GetPackageTypesAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<Packaging.Signing.PrimarySignature> GetPrimarySignatureAsync(System.Threading.CancellationToken token) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetReferenceItems() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetReferenceItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.IO.Stream GetStream(string path) { throw null; }

        public override System.Threading.Tasks.Task<System.IO.Stream> GetStreamAsync(string path, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> GetSupportedFrameworks() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework>> GetSupportedFrameworksAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup> GetToolItems() { throw null; }

        public override System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Packaging.FrameworkSpecificGroup>> GetToolItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override bool IsServiceable() { throw null; }

        public override System.Threading.Tasks.Task<bool> IsServiceableAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override System.Threading.Tasks.Task<bool> IsSignedAsync(System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task ValidateIntegrityAsync(Packaging.Signing.SignatureContent signatureContent, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class PluginProcess : IPluginProcess, System.IDisposable
    {
        public PluginProcess() { }

        public PluginProcess(System.Diagnostics.ProcessStartInfo startInfo) { }

        public int? ExitCode { get { throw null; } }

        public int? Id { get { throw null; } }

        public event System.EventHandler<IPluginProcess> Exited { add { } remove { } }

        public event System.EventHandler<LineReadEventArgs> LineRead { add { } remove { } }

        public void BeginReadLine() { }

        public void CancelRead() { }

        public void Dispose() { }

        public void Kill() { }

        public void Start() { }
    }

    public sealed partial class PrefetchPackageRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public PrefetchPackageRequest(string packageSourceRepository, string packageId, string packageVersion) { }

        [Newtonsoft.Json.JsonRequired]
        public string PackageId { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        [Newtonsoft.Json.JsonRequired]
        public string PackageVersion { get { throw null; } }
    }

    public sealed partial class PrefetchPackageResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public PrefetchPackageResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class Progress
    {
        [Newtonsoft.Json.JsonConstructor]
        public Progress(double? percentage = null) { }

        public double? Percentage { get { throw null; } }
    }

    public static partial class ProtocolConstants
    {
        public static readonly Versioning.SemanticVersion CurrentVersion;
        public static readonly System.TimeSpan HandshakeTimeout;
        public static readonly System.TimeSpan MaxTimeout;
        public static readonly System.TimeSpan MinTimeout;
        public static readonly System.TimeSpan RequestTimeout;
        public static readonly Versioning.SemanticVersion Version100;
    }

    public sealed partial class ProtocolErrorEventArgs : System.EventArgs
    {
        public ProtocolErrorEventArgs(System.Exception exception, Message message) { }

        public ProtocolErrorEventArgs(System.Exception exception) { }

        public System.Exception Exception { get { throw null; } }

        public Message Message { get { throw null; } }
    }

    public sealed partial class ProtocolException : System.Exception
    {
        public ProtocolException(string message, System.Exception innerException) { }

        public ProtocolException(string message) { }
    }

    public abstract partial class Receiver : IReceiver, System.IDisposable
    {
        protected bool IsClosed { get { throw null; } }

        protected bool IsDisposed { get { throw null; } set { } }

        public event System.EventHandler<ProtocolErrorEventArgs> Faulted { add { } remove { } }

        public event System.EventHandler<MessageEventArgs> MessageReceived { add { } remove { } }

        public virtual void Close() { }

        public abstract void Connect();
        public void Dispose() { }

        protected abstract void Dispose(bool disposing);
        protected void FireFaultEvent(System.Exception exception, Message message) { }

        protected void FireMessageReceivedEvent(Message message) { }

        protected void ThrowIfClosed() { }

        protected void ThrowIfDisposed() { }
    }

    public sealed partial class RequestHandlers : IRequestHandlers
    {
        public void AddOrUpdate(MessageMethod method, System.Func<IRequestHandler> addHandlerFunc, System.Func<IRequestHandler, IRequestHandler> updateHandlerFunc) { }

        public bool TryAdd(MessageMethod method, IRequestHandler handler) { throw null; }

        public bool TryGet(MessageMethod method, out IRequestHandler handler) { throw null; }

        public bool TryRemove(MessageMethod method) { throw null; }
    }

    public sealed partial class RequestIdGenerator : IIdGenerator
    {
        public string GenerateUniqueId() { throw null; }
    }

    public sealed partial class Sender : ISender, System.IDisposable
    {
        public Sender(System.IO.TextWriter writer) { }

        public void Close() { }

        public void Connect() { }

        public void Dispose() { }

        public System.Threading.Tasks.Task SendAsync(Message message, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public sealed partial class SetCredentialsRequest
    {
        public SetCredentialsRequest(string packageSourceRepository, string proxyUsername, string proxyPassword, string username, string password) { }

        [Newtonsoft.Json.JsonRequired]
        public string PackageSourceRepository { get { throw null; } }

        public string Password { get { throw null; } }

        public string ProxyPassword { get { throw null; } }

        public string ProxyUsername { get { throw null; } }

        public string Username { get { throw null; } }
    }

    public sealed partial class SetCredentialsResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public SetCredentialsResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class SetLogLevelRequest
    {
        [Newtonsoft.Json.JsonConstructor]
        public SetLogLevelRequest(Common.LogLevel logLevel) { }

        [Newtonsoft.Json.JsonRequired]
        public Common.LogLevel LogLevel { get { throw null; } }
    }

    public sealed partial class SetLogLevelResponse
    {
        [Newtonsoft.Json.JsonConstructor]
        public SetLogLevelResponse(MessageResponseCode responseCode) { }

        [Newtonsoft.Json.JsonRequired]
        public MessageResponseCode ResponseCode { get { throw null; } }
    }

    public sealed partial class StandardInputReceiver : Receiver
    {
        public StandardInputReceiver(System.IO.TextReader reader) { }

        public override void Connect() { }

        protected override void Dispose(bool disposing) { }
    }

    public sealed partial class StandardOutputReceiver : Receiver
    {
        public StandardOutputReceiver(IPluginProcess process) { }

        public override void Close() { }

        public override void Connect() { }

        protected override void Dispose(bool disposing) { }
    }

    public sealed partial class SymmetricHandshake : IRequestHandler, System.IDisposable
    {
        public SymmetricHandshake(IConnection connection, System.TimeSpan handshakeTimeout, Versioning.SemanticVersion protocolVersion, Versioning.SemanticVersion minimumProtocolVersion) { }

        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public void Dispose() { }

        public System.Threading.Tasks.Task HandleResponseAsync(IConnection connection, Message request, IResponseHandler responseHandler, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<Versioning.SemanticVersion> HandshakeAsync(System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public static partial class TimeoutUtilities
    {
        public static System.TimeSpan GetTimeout(string timeoutInSeconds, System.TimeSpan fallbackTimeout) { throw null; }

        public static bool IsValid(System.TimeSpan timeout) { throw null; }
    }

    public partial class UnixAndMonoPlatformsEmbeddedSignatureVerifier : EmbeddedSignatureVerifier
    {
        public override bool IsValid(string filePath) { throw null; }
    }

    public sealed partial class WindowsEmbeddedSignatureVerifier : EmbeddedSignatureVerifier
    {
        public override bool IsValid(string filePath) { throw null; }
    }
}

namespace NuGet.Protocol.Providers
{
    public partial class OwnerDetailsUriResourceV3Provider : Core.Types.ResourceProvider
    {
        public OwnerDetailsUriResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource?>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class VulnerabilityInfoResourceV3Provider : Core.Types.ResourceProvider
    {
        public VulnerabilityInfoResourceV3Provider() : base(default!) { }

        public override System.Threading.Tasks.Task<System.Tuple<bool, Core.Types.INuGetResource?>> TryCreate(Core.Types.SourceRepository source, System.Threading.CancellationToken token) { throw null; }
    }
}

namespace NuGet.Protocol.Resources
{
    public partial class OwnerDetailsUriTemplateResourceV3 : Core.Types.INuGetResource
    {
        internal OwnerDetailsUriTemplateResourceV3() { }

        public static OwnerDetailsUriTemplateResourceV3? CreateOrNull(System.Uri uriTemplate) { throw null; }

        public System.Uri GetUri(string owner) { throw null; }
    }

    public sealed partial class VulnerabilityInfoResourceV3 : IVulnerabilityInfoResource, Core.Types.INuGetResource
    {
        internal VulnerabilityInfoResourceV3() { }

        public System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyList<Model.PackageVulnerabilityInfo>>> GetVulnerabilityDataAsync(Model.V3VulnerabilityIndexEntry vulnerabilityPage, Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<Model.V3VulnerabilityIndexEntry>> GetVulnerabilityFilesAsync(Core.Types.SourceCacheContext cacheContext, Common.ILogger log, System.Threading.CancellationToken cancellationToken) { throw null; }

        public System.Threading.Tasks.Task<Model.GetVulnerabilityInfoResult> GetVulnerabilityInfoAsync(Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }
}

namespace NuGet.Protocol.VisualStudio
{
    public static partial class FactoryExtensionsVS
    {
        public static System.Collections.Generic.IEnumerable<System.Lazy<Core.Types.INuGetResourceProvider>> GetVisualStudio(this Core.Types.Repository.ProviderFactory factory) { throw null; }

        public static Core.Types.SourceRepository GetVisualStudio(this Core.Types.Repository.RepositoryFactory factory, Configuration.PackageSource source) { throw null; }

        public static Core.Types.SourceRepository GetVisualStudio(this Core.Types.Repository.RepositoryFactory factory, string source) { throw null; }
    }
}

namespace NuGet.Repositories
{
    public partial class LocalPackageInfo
    {
        public LocalPackageInfo(string packageId, Versioning.NuGetVersion version, string path, string manifestPath, string zipPath, string sha512Path, System.Lazy<Packaging.NuspecReader> nuspec, System.Lazy<System.Collections.Generic.IReadOnlyList<string>> files, System.Lazy<string> sha512, System.Lazy<RuntimeModel.RuntimeGraph> runtimeGraph) { }

        public string ExpandedPath { get { throw null; } set { } }

        public System.Collections.Generic.IReadOnlyList<string> Files { get { throw null; } }

        public string Id { get { throw null; } }

        public string ManifestPath { get { throw null; } }

        public Packaging.NuspecReader Nuspec { get { throw null; } }

        public RuntimeModel.RuntimeGraph RuntimeGraph { get { throw null; } }

        public string Sha512 { get { throw null; } }

        public string Sha512Path { get { throw null; } }

        public Versioning.NuGetVersion Version { get { throw null; } }

        public string ZipPath { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public partial class LocalPackageSourceInfo
    {
        public LocalPackageSourceInfo(NuGetv3LocalRepository repository, LocalPackageInfo package) { }

        public LocalPackageInfo Package { get { throw null; } }

        public NuGetv3LocalRepository Repository { get { throw null; } }
    }

    public partial class NuGetv3LocalRepository
    {
        public NuGetv3LocalRepository(string path, Protocol.LocalPackageFileCache packageFileCache, bool isFallbackFolder, bool updateLastAccessTime) { }

        public NuGetv3LocalRepository(string path, Protocol.LocalPackageFileCache packageFileCache, bool isFallbackFolder) { }

        public NuGetv3LocalRepository(string path) { }

        public Packaging.VersionFolderPathResolver PathResolver { get { throw null; } }

        public string RepositoryRoot { get { throw null; } }

        public void ClearCacheForIds(System.Collections.Generic.IEnumerable<string> packageIds) { }

        public bool Exists(string packageId, Versioning.NuGetVersion version) { throw null; }

        public LocalPackageInfo FindPackage(string packageId, Versioning.NuGetVersion version) { throw null; }

        public System.Collections.Generic.IEnumerable<LocalPackageInfo> FindPackagesById(string packageId) { throw null; }
    }

    public static partial class NuGetv3LocalRepositoryUtility
    {
        public static LocalPackageSourceInfo GetPackage(System.Collections.Generic.IReadOnlyList<NuGetv3LocalRepository> repositories, string id, Versioning.NuGetVersion version) { throw null; }
    }
}