/*

   Derby - Class org.apache.derby.client.am.SqlState

   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

*/

package org.apache.derby.client.am;

// This class is for strong-typing.
//
// Unless otherwise architected by PROTOCOL, all client-side generated SQL States should be
// Dnc architected codes in the range "46600" to "466ZZ".
//
// In general SQL states are architected by the product that issues them.
// Therefore Dnc will not attempt to reuse pre-existing sql states 
// Range for dnc architected sql codes is +/- 4400 to 4499.
//

public class SqlState {
    private String state_;

    private SqlState(String state) {
        state_ = state;
    }

    String getState() {
        return state_;
    }

    // The following codes are architected by PROTOCOL on page 331 of PROTOCOL V2 Volume 1.
    // SQL States generated by Dnc should be Dnc-specific with the following specific exctpions.
    //
    public final static SqlState _08004 = new SqlState("08004");
    public final static SqlState _58009 = new SqlState("58009");
    public final static SqlState _58010 = new SqlState("58010");
    public final static SqlState _58014 = new SqlState("58014");
    public final static SqlState _58015 = new SqlState("58015");
    public final static SqlState _58016 = new SqlState("58016");
    public final static SqlState _58017 = new SqlState("58017");
    public final static SqlState _24501 = new SqlState("24501");
    public final static SqlState _58008 = new SqlState("58008");
    public final static SqlState _22021 = new SqlState("22021");
    public final static SqlState _2D521 = new SqlState("2D521");

    // Dnc-archited sql states follow
    //
    public final static SqlState undefined = new SqlState(null);
}
