# Copyright(c) 2006 to 2018 ADLINK Technology Limited and others
#
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License v. 2.0 which is available at
# http://www.eclipse.org/legal/epl-2.0, or the Eclipse Distribution License
# v. 1.0 which is available at
# http://www.eclipse.org/org/documents/edl-v10.php.
#
# SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause

function(GENERATE_DUMMY_EXPORT_HEADER _target)
  set(_opts)
  set(_single_opts BASE_NAME EXPORT_FILE_NAME)
  set(_multi_opts)
  cmake_parse_arguments(_args "${_opts}" "${_single_opts}" "${_multi_opts}" ${ARGN})

  if(NOT _target)
    message(FATAL_ERROR "Target not specified")
  elseif(NOT TARGET ${_target})
    message(FATAL_ERROR "Target ${_target} does not exist")
  endif()

  string(TOUPPER _target_uc "${_target}")
  string(TOLOWER _target_lc "${_target}")

  if(_args_EXPORT_FILE_NAME)
    set(_path "${_args_EXPORT_FILE_NAME}")
  else()
    set(_path "${CMAKE_CURRENT_BINARY_DIR}/${_target_lc}_export.h")
  endif()

  if(_args_BASE_NAME)
    string(TOUPPER "${_args_BASE_NAME}" _base_name)
  else()
    set(_base_name "${_target_uc}")
  endif()

  get_filename_component(_dir  "${_path}" DIRECTORY)
  get_filename_component(_file "${_path}" NAME)

  if(NOT IS_DIRECTORY "${_dir}")
    file(MAKE_DIRECTORY "${_dir}")
  endif()

  set(_content
"/* Dummy export header generated by CMake. */
#define ${_base_name}_EXPORT
#define ${_base_name}_INLINE_EXPORT\n")

  file(WRITE "${_path}" "${_content}")
endfunction()

