/*
 * Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
 *
 * Use is subject to the GNU General Public License, Version 2,
 * June 1991, which is contained in the read-me file named
 * "README_GNU_GPL." This program is free software; you can
 * redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your
 * option) any later version. This library is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA.
 */

#include <stdio.h>
#include "lcd.h"
#include "lcdutils.h"

/* linkstatus.c
 *	Returns the link status of eth0 and eth1
 *	0 - both links down
 *	1 - eth0 UP, eth1 DOWN
 *	2 - eth0 DOWN, eth1 UP
 *	3 - eth0 UP, eth1 UP
 *
 */

int main (int argc, char **argv) {
	void *lcd;
	int button, err, status;
	
	status = 0;
	lcd_setlocale();
	
	if ((lcd = lcd_open(O_RDWR)) == NULL)
		exit(0);
	
	button = 1;
	if (lcd_checklink2(lcd, &button) < 0)
		exit(0);
	
	if (button) 
		status++;
	
	button = 0;
	if (lcd_checklink2(lcd, &button) < 0)
		exit(0);
	
	if (button)
		status += 2;
	
	printf("%d",status);
	
	lcd_close(lcd);
	exit(status);
}
