/****************************************************************************
 *    lib/c/Function.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Function.h"

using namespace C;

Function::Function(string* name, vector<Term*>* terms) {
	name_ = *name;
	terms_ = *terms;
	
	text_ = *name+"(";
	for(vector<Term*>::iterator n = terms_.begin(); n != terms_.end(); ++n) {
		text_ += (*n)->getText();
		if(n != terms_.end()-1) text_ += ",";
	}
	text_ += ")";
}

Function::~Function ( ) { }

set<Variable*>* Function::getVariables() {
	set<Variable*>* vars = new set<Variable*>();

	if(!terms_.empty()) {
		for(vector<Term*>::iterator n = terms_.begin(); n!= terms_.end(); ++n) {
			set<Variable*>* tmp_vars = (*n)->getVariables();
			
			if(!tmp_vars->empty()) {
				vars->insert(tmp_vars->begin(), tmp_vars->end());
			}
		}
	}
	return vars;
}
