/****************************************************************************
 *    lib/c/Fluent.cpp - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "FluentAction.h"
#include "Formula.h"

using namespace C;

FluentAction::FluentAction(string* name, Arguments* args) : Identifier(name, args) {
	type_ = '_';
}

FluentAction::FluentAction(string* name) : Identifier(name) {
	type_ = '_';
}

FluentAction::~FluentAction ( ) { }

string FluentAction::getNameWithArgs() {
	string result = getName();
	if(args_ != NULL) result += "(" + args_->print() + ")";

	return result;
}

void FluentAction::setClass(string cl) {
	class_ = cl;
}

string FluentAction::getClass() {
	return class_;
}


string FluentAction::print(Printer* p, string T) {
	string result = "";

	if(p->no_direct_enc) {
		if(name_ != "0") {
			result += name_;
			if(args_) result += "(" + args_->print(p) + ")";
		}
		else result += "\"true\"";
	}
	// true and false just gets ignored in direct encoding
	else if(name_ != "0") {
		if(class_ == "Fluent") { result += "fluent_"; }
		else if(class_ == "Action") { result += "action_"; }
		result += name_;
		
		result += "(";
		if(args_) {
			result += args_->print(p);
			result += "," + T;
		}
		else result += T;
		result += ")";
	}
	
	return result;
}

string FluentAction::print(Printer* p) {
	return print(p, "0");
}
