/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef cmParseDelphiCoverage_h
#define cmParseDelphiCoverage_h

#include "cmConfigure.h" // IWYU pragma: keep

#include <string>
#include <vector>

class cmCTest;
class cmCTestCoverageHandlerContainer;

/** \class cmParseDelphiCoverage
 * \brief Parse Delphi coverage information
 *
 * This class is used to parse Delphi(Pascal) coverage information
 * generated by the Delphi-Code-Coverage tool
 *
 * https://code.google.com/p/delphi-code-coverage/
 */

class cmParseDelphiCoverage
{
public:
  cmParseDelphiCoverage(cmCTestCoverageHandlerContainer& cont, cmCTest* ctest);
  bool LoadCoverageData(std::vector<std::string> const& files);
  bool ReadDelphiHTML(const char* file);
  // Read a single HTML file from output
  bool ReadHTMLFile(const char* f);

protected:
  class HTMLParser;

  cmCTestCoverageHandlerContainer& Coverage;
  cmCTest* CTest;
};
#endif
