/***********************************************************************
    filename:   CEGUIIrrlichtResourceProvider.h
    created:    12/22/2004
    author:     Thomas Suter

    purpose: Interface for Irrlicht specific ResourceProvider class
*************************************************************************/
/***************************************************************************
 *   Copyright (C) 2004 - 2006 Paul D Turner & The CEGUI Development Team
 *
 *   Permission is hereby granted, free of charge, to any person obtaining
 *   a copy of this software and associated documentation files (the
 *   "Software"), to deal in the Software without restriction, including
 *   without limitation the rights to use, copy, modify, merge, publish,
 *   distribute, sublicense, and/or sell copies of the Software, and to
 *   permit persons to whom the Software is furnished to do so, subject to
 *   the following conditions:
 *
 *   The above copyright notice and this permission notice shall be
 *   included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *   OTHER DEALINGS IN THE SOFTWARE.
 ***************************************************************************/
#ifndef _CEGUIIrrlichtResourceProvider_h_
#define _CEGUIIrrlichtResourceProvider_h_

#include "CEGUIIrrlichtRendererDef.h"
#include "../../CEGUIDefaultResourceProvider.h"
#include <IFileSystem.h>

// Start of CEGUI namespace section
namespace CEGUI
{
class IRR_GUIRENDERER_API IrrlichtResourceProvider : public DefaultResourceProvider
{
protected:
    irr::io::IFileSystem& d_fsys;

public:
    IrrlichtResourceProvider(irr::io::IFileSystem& fs);
    ~IrrlichtResourceProvider() ;

    void loadRawDataContainer(const String& filename, RawDataContainer& output,
                              const String& resourceGroup);
    void unloadRawDataContainer(RawDataContainer& data);
};

} // End of  CEGUI namespace section

#endif // end of guard _CEGUIIrrlichtResourceProvider_h_
