/* Copyright (C) 2007  Egon Willighagen <egonw@users.sf.ne>
 *
 * Contact: cdk-devel@lists.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */
package org.openscience.cdk.qsar.result;


/**
 * IDescriptorResult type for doubles.
 *
 * @cdk.module standard
 * @cdk.githash
 */
public class DoubleArrayResultType implements IDescriptorResult {

    private static final long serialVersionUID = -8255004284721233969L;

    private final int               size;

    public DoubleArrayResultType(int size) {
        this.size = size;
    }

    @Override
    public String toString() {
        return "DoubleArrayResultType";
    }

    @Override
    public int length() {
        return size;
    }
}
