/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef _Prob_H_
#define _Prob_H_

//
// $Id: Prob.H,v 1.8 2000/10/02 20:47:02 lijewski Exp $
//

#include <LevelBld.H>
#include <HyperCLaw.H>
#include <ProbBld.H>

//
//@Man:
//@Memo: Problem-dependent class derived from AmrLevel and HyperCLaw
/*@Doc: 

  Prob contains all the problem dependent parts, most notably
  variableSetUp(), where things like physical boundary conditions, derived
  quantities, and other static variables are set up ...
*/

class Prob
    :
    public HyperCLaw
{

    friend class ProbBld;
public:
    //
    //@ManDoc: The default constructor.
    //
    Prob ();
    //
    //@ManDoc: The main constructor.
    //
    Prob (Amr&            papa,
          int             lev,
          const Geometry& level_geom,
          const BoxArray& bl,
          Real            time);
    //
    //@ManDoc: The destructor.
    //
    virtual ~Prob ();
    //
    //@ManDoc: Defines static variables, physical boundary conditions, derived quantities
    //
    static void variableSetUp ();
    //
    //@ManDoc: Cleans up after variableSetUp().
    //
    static void variableCleanUp ();
    //
    //@ManDoc: Calls HyperCLaw::read\_params() 
    //
    static void read_params ();
    //
    //@ManDoc: Sums integrated quantities.
    //
    virtual void sum_integrated_quantities ();

protected:

    Prob& getLevel (int lev)
    {
        return *(Prob*) &parent->getLevel(lev);
    }
};

#endif /*_Prob_H_*/
