<?php
/*
 +-------------------------------------------------------------------------+
 | Copyright (C) 2004-2021 The Cacti Group                                 |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | Cacti: The Complete RRDTool-based Graphing Solution                     |
 +-------------------------------------------------------------------------+
 | This code is designed, written, and maintained by the Cacti Group. See  |
 | about.php and/or the AUTHORS file for specific developer information.   |
 +-------------------------------------------------------------------------+
 | http://www.cacti.net/                                                   |
 +-------------------------------------------------------------------------+
*/

/**
 * plugin install - provides a generic installer routine to
 * register all plugin hook functions.
 */
function plugin_example_install() {
   api_plugin_register_hook('example', 'top_header_tabs',       'example_show_tab',             'setup.php');
   api_plugin_register_hook('example', 'top_graph_header_tabs', 'example_show_tab',             'setup.php');
   api_plugin_register_hook('example', 'config_arrays',         'example_config_arrays',        'setup.php');
   api_plugin_register_hook('example', 'draw_navigation_text',  'example_draw_navigation_text', 'setup.php');
   api_plugin_register_hook('example', 'config_form',           'example_config_form',          'setup.php');
   api_plugin_register_hook('example', 'config_settings',       'example_config_settings',      'setup.php');
   api_plugin_register_hook('example', 'api_graph_save',        'example_api_graph_save',       'setup.php');

   // register the realm for each php file
   api_plugin_register_realm('example', 'example.php', 'View Example', 1);

	// Create an array to translate your Realms
	$examples = __('View Example', 'example');

	example_setup_table_new();
}

function plugin_example_version() {
	global $config;
	$info = parse_ini_file($config['base_path'] . '/plugins/example/INFO', true);
	return $info['info'];
}

/**
 * plugin uninstall - a generic uninstall routine.  Right now it will do nothing as I
 * If you don't want the tables removed from the system except let it empty.
 */
function plugin_example_uninstall() {
	/* Do any extra Uninstall stuff here like dropping tables */
}

function plugin_example_check_config() {
	/* Here we will check to ensure everything is configured */
	return true;
}

function plugin_example_upgrade() {
	/* Here we will upgrade to the newest version */
	example_check_upgrade();
	return false;
}

function example_check_upgrade() {
	global $config;

	$files = array('index.php', 'plugins.php', 'example.php');
	if (isset($_SERVER['PHP_SELF']) && !in_array(basename($_SERVER['PHP_SELF']), $files)) {
		return;
	}

	$current = plugin_example_version();
	$current = $current['version'];
	$old     = db_fetch_row('SELECT * FROM plugin_config WHERE directory="example"');

	if (sizeof($old) && $current != $old['version']) {
		/* if the plugin is installed and/or active */
		if ($old['status'] == 1 || $old['status'] == 4) {
			/* re-register the hooks */
			plugin_example_install();

			/* perform a database upgrade */
			example_database_upgrade();
		}

		/* update the plugin information */
		$info = plugin_example_version();

		db_execute_prepared('UPDATE plugin_config
			SET name = ?, author  = ?, webpage = ?, version = ?
			WHERE directory = "example"',
			array(
				$info['longname'],
				$info['author'],
				$info['homepage'],
				$info['version']
			)
		);
	}
}

function example_database_upgrade() {
	/* do some upgrading here */
}

function example_check_dependencies() {
	global $plugins, $config;

	return true;
}

function example_setup_table_new() {
	/* create any tables you need here */
}

function example_config_settings() {
	global $tabs, $settings, $page_refresh_interval, $graph_timespans;

	/* check for an upgrade */
	plugin_example_check_config();

	if (isset($_SERVER['PHP_SELF']) && basename($_SERVER['PHP_SELF']) != 'settings.php') {
		return;
	}

	/* IF you want your own tab settings you have to create a new $tab and change "misc" */
	$tabs['misc'] = __('Misc', 'example');

	$temp = array(
		'example_header' => array(
			'friendly_name' => __('Example Settings', 'example'),
			'method' => 'spacer',
		),
		'example_allowed_guest_account' => array(
			'friendly_name' => __('Allow guest account', 'example'),
			'description' => __('If checked this plugin is allowed to the \'guest\' account', 'example'),
			'method' => 'checkbox',
			'default' => 'on'
			),
		'example_settingsvariable1' => array(
			'friendly_name' => __('Your First Setting Variable', 'example'),
			'description' => __('This is your first setting variable.', 'example'),
			'method' => 'textbox',
			'max_length' => 3,
			),
		'example_settingsvariable2' => array(
			'friendly_name' => __('Your Second Setting Variable', 'example'),
			'description' => __('This is your second setting variable.', 'example'),
			'method' => 'textbox',
			'max_length' => 5,
			),
		'example_settingsvariable3' => array(
			'friendly_name' => __('Your Third Setting Variable', 'example'),
			'description' => __('Check your third setting variable.', 'example'),
			'method' => 'checkbox',
			),
	);

	if (isset($settings['misc'])) {
		$settings['misc'] = array_merge($settings['misc'], $temp);
	} else {
		$settings['misc'] = $temp;
	}
}

function example_device_action_execute($action) {
	global $config;

	if ($action != 'example_your_action') {
		/* Execute your action */
	}

	/* always return the variable passed for other plugins */
	return $action;
}

function example_device_action_prepare($save) {
	global $colors, $host_list;
	/* Look at monitor as example */

	/* always return the variable passed for other plugins */
	return $save;
}

function example_device_action_array($device_action_array) {
	/* here you can add actions in the devices view */
	/* Look at monitor as example */
	$device_action_array['example_your_action'] = __('Do Something', 'example');

	return $device_action_array;
}

function example_show_tab() {
	global $config, $user_auth_realms, $user_auth_realm_filenames;

	if (realm_is_allowed('example')) {
		if (strpos(get_current_page(), 'example.php') !== false) {
			print '<a href="' . html_escape($config['url_path'] . 'plugins/example/example.php') . '">
				<img src="' . $config['url_path'] . 'plugins/example/images/tab_example-green.png" alt="Example"></a>';
		} else {
			print '<a href="' . html_escape($config['url_path'] . 'plugins/example/example.php') . '">
				<img src="' . $config['url_path'] . 'plugins/example/images/tab_example.png" alt="Example"></a>';
		}
	}
}

function example_config_arrays() {
	global $menu, $messages, $example_menu;

	$menu['Utilities']['plugins/example/example.php'] = __('Menu example', 'example');
}

function example_draw_navigation_text ($nav) {
	$nav['example.php:'] = array(
		'title'   => 'example title',
		'mapping' => 'index.php:',
		'url'     => 'example.php',
		'level'   => '1'
	);

	return $nav;
}

function example_api_graph_save ($save) {
	/* what happend after a click on the save button */
}

