#/usr/bin/perl


print "/*\n  Autogenerated file, $0, ".localtime()."\n*/\n\n";

my @defines;

while(<STDIN>) {
    $line = $_;
     if ( $line =~ /^\s*#\s*define\s*(SSL_OP_\w*)\s*(0x[0-9a-fA-F]+)[U|L|u|l]/ ) {
         $def = {};
         $def->{name} = $1;
         $def->{value} = $2."U";
         # Check to see if it is already exist in array.
         if (!findDefine(\@defines, \$def)) {
             push @defines, $def;
         }
     }
}

print "struct {\n    const char *name;\n    unsigned long int value;\n} OPENSSL_OPTS[] = {\n";
for $def (@defines) {
    print "#if defined(".$def->{name}.")\n    {\"".$def->{name}."\", ".$def->{name}."},\n#endif\n";
}
print "    {NULL, 0x0}\n};\n";
exit(0);

sub findDefine {
    ($defines, $find) = @_;
    for $def (@$defines) {
        if ($def->{name} eq $$find->{name}) {
            return 1;
        }
    }
    return 0;
}
