#ifndef PREFERENCES_DIALOG_H
#define PREFERENCES_DIALOG_H

/*
 * Folder list window
 *
 * Copyright (C) 2004  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma interface

#include <gtkmm/dialog.h>
//#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/uimanager.h>
#include <gtkmm/toggleaction.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/treeview.h>
#include <gtkmm/liststore.h>

class BuffyWindow;
namespace Gtk
{
	class ComboBox;
};

class PrefDialog : public Gtk::Dialog
{
protected:
	Gtk::Adjustment updateInterval;

	Gtk::TreeView locationList;
	Gtk::TreeView progEdit;
	Glib::RefPtr<Gtk::ListStore> locationListModel;
	Glib::RefPtr<Gtk::ListStore> editorListModel;
	Gtk::ComboBox* editorSelection;
	Gtk::Dialog mpconfig;
	bool mpconfig_configured;

	class LocationListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		LocationListModelColumns() { add(path); }

		Gtk::TreeModelColumn<Glib::ustring> path;
	};
	LocationListModelColumns locationListModelColumns;


	class EditorListModelColumns : public Gtk::TreeModel::ColumnRecord
	{
	public:
		EditorListModelColumns() { add(name); add(command); }

		Gtk::TreeModelColumn<Glib::ustring> name;
		Gtk::TreeModelColumn<Glib::ustring> command;
	};
	EditorListModelColumns editorListModelColumns;

	/*
	Glib::RefPtr<Gtk::UIManager> uimanager;
	Glib::RefPtr<Gtk::ActionGroup> actionGroup;

	Glib::RefPtr<Gtk::Action> actionLocationAdd;
	Glib::RefPtr<Gtk::Action> actionLocationDel;
	Glib::RefPtr<Gtk::Action> actionLocationMod;
	*/

	void on_location_add();
	void on_location_remove();
	void on_configure_mail_programs();
	void on_mail_program_add();
	void on_mail_program_remove();

	void enact(BuffyWindow& buffy);
	void reset();

public:
	PrefDialog(Gtk::Window& parent);
	virtual ~PrefDialog() {}

	void do_dialog(BuffyWindow* buffy);
};

// vim:set ts=4 sw=4:
#endif
