/* libmutter-cogl-4.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Cogl", gir_namespace = "Cogl", gir_version = "4", lower_case_cprefix = "cogl_")]
namespace Cogl {
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_bitmap_get_gtype ()")]
	public class Bitmap : Cogl.Object {
		[CCode (has_construct_function = false)]
		protected Bitmap ();
		public static uint32 error_quark ();
		[CCode (has_construct_function = false)]
		[Version (since = "1.0")]
		public Bitmap.from_file (string filename) throws GLib.Error;
		[Version (since = "1.10")]
		public Cogl.PixelFormat get_format ();
		[Version (since = "1.10")]
		public int get_height ();
		[Version (since = "1.10")]
		public int get_rowstride ();
		[Version (since = "1.0")]
		public static Cogl.Bool get_size_from_file (string filename, out int width, out int height);
		[Version (since = "1.10")]
		public int get_width ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class Euler {
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_frame_closure_get_gtype ()")]
	[Compact]
	[Version (since = "1.14")]
	public class FrameClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_material_get_type ()")]
	[Compact]
	public class Material {
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Material ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.2")]
		public Cogl.Material copy ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void foreach_layer (Cogl.MaterialLayerCallback callback);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void get_ambient (Cogl.Color ambient);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public Cogl.Color get_color ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void get_diffuse (Cogl.Color diffuse);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void get_emission (Cogl.Color emission);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public Cogl.Bool get_layer_point_sprite_coords_enabled (int layer_index);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.6")]
		public Cogl.MaterialWrapMode get_layer_wrap_mode_p (int layer_index);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.6")]
		public Cogl.MaterialWrapMode get_layer_wrap_mode_s (int layer_index);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.6")]
		public Cogl.MaterialWrapMode get_layer_wrap_mode_t (int layer_index);
		public unowned GLib.List<Cogl.MaterialLayer> get_layers ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public int get_n_layers ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public float get_point_size ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public float get_shininess ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void get_specular (Cogl.Color specular);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public Cogl.Handle get_user_program ();
		[Version (deprecated = true, deprecated_since = "1.2", since = "1.0")]
		public static Cogl.Handle @ref (Cogl.Handle material);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void remove_layer (int layer_index);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_alpha_test_function (Cogl.MaterialAlphaFunc alpha_func, float alpha_reference);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_ambient (Cogl.Color ambient);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_ambient_and_diffuse (Cogl.Color color);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public Cogl.Bool set_blend (string blend_string) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_blend_constant (Cogl.Color constant_color);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_color (Cogl.Color color);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_color4f (float red, float green, float blue, float alpha);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_color4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_diffuse (Cogl.Color diffuse);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_emission (Cogl.Color emission);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_layer (int layer_index, Cogl.Handle texture);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public Cogl.Bool set_layer_combine (int layer_index, string blend_string) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_layer_combine_constant (int layer_index, Cogl.Color constant);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_layer_filters (int layer_index, Cogl.MaterialFilter min_filter, Cogl.MaterialFilter mag_filter);
		[Version (deprecated = true, deprecated_since = "1.16")]
		public void set_layer_matrix (int layer_index, Cogl.Matrix matrix);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public Cogl.Bool set_layer_point_sprite_coords_enabled (int layer_index, Cogl.Bool enable) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_layer_wrap_mode (int layer_index, Cogl.MaterialWrapMode mode);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_layer_wrap_mode_p (int layer_index, Cogl.MaterialWrapMode mode);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_layer_wrap_mode_s (int layer_index, Cogl.MaterialWrapMode mode);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_layer_wrap_mode_t (int layer_index, Cogl.MaterialWrapMode mode);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_point_size (float point_size);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_shininess (float shininess);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
		public void set_specular (Cogl.Color specular);
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public void set_user_program (Cogl.Handle program);
		[Version (deprecated = true, deprecated_since = "1.2", since = "1.0")]
		public static void unref (Cogl.Handle material);
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class MaterialLayer {
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Cogl.MaterialFilter get_mag_filter ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Cogl.MaterialFilter get_min_filter ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Cogl.Handle get_texture ();
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Cogl.MaterialLayerType get_type ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public Cogl.MaterialWrapMode get_wrap_mode_p ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public Cogl.MaterialWrapMode get_wrap_mode_s ();
		[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
		public Cogl.MaterialWrapMode get_wrap_mode_t ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_object_get_gtype ()")]
	public abstract class Object {
		[CCode (has_construct_function = false)]
		protected Object ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_offscreen_get_gtype ()")]
	public class Offscreen : Cogl.Object, Cogl.Framebuffer {
		[CCode (has_construct_function = false)]
		protected Offscreen ();
		[Version (deprecated = true, deprecated_since = "1.2")]
		public static void* @ref (void* offscreen);
		[CCode (has_construct_function = false)]
		[Version (deprecated = true, deprecated_since = "1.16")]
		public Offscreen.to_texture (Cogl.Texture texture);
		[Version (deprecated = true, deprecated_since = "1.2")]
		public static void unref (void* offscreen);
		[CCode (has_construct_function = false)]
		public Offscreen.with_texture (Cogl.Texture texture);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_onscreen_get_gtype ()")]
	public class Onscreen : Cogl.Object, Cogl.Framebuffer {
		[CCode (has_construct_function = false)]
		protected Onscreen ();
		[Version (since = "1.16")]
		public Cogl.OnscreenDirtyClosure add_dirty_callback ([CCode (delegate_target_pos = 1.5)] Cogl.OnscreenDirtyCallback callback, Cogl.UserDataDestroyCallback? destroy);
		[Version (since = "2.0")]
		public Cogl.OnscreenResizeClosure add_resize_callback ([CCode (delegate_target_pos = 1.5)] Cogl.OnscreenResizeCallback callback, Cogl.UserDataDestroyCallback? destroy);
		[Version (deprecated = true, deprecated_since = "1.14", since = "1.10")]
		public uint add_swap_buffers_callback (Cogl.SwapBuffersNotify callback);
		public static void clutter_backend_set_size_CLUTTER (int width, int height);
		[Version (since = "1.14")]
		public int get_buffer_age ();
		[Version (since = "1.14")]
		public int64 get_frame_counter ();
		[Version (since = "2.0")]
		public Cogl.Bool get_resizable ();
		[Version (since = "2.0")]
		public void hide ();
		[Version (since = "1.16")]
		public void remove_dirty_callback (Cogl.OnscreenDirtyClosure closure);
		[Version (since = "1.14")]
		public void remove_frame_callback (Cogl.FrameClosure closure);
		[Version (since = "2.0")]
		public void remove_resize_callback (Cogl.OnscreenResizeClosure closure);
		[Version (deprecated = true, deprecated_since = "1.14", since = "1.10")]
		public void remove_swap_buffers_callback (uint id);
		[Version (since = "2.0")]
		public void set_resizable (Cogl.Bool resizable);
		[Version (since = "2.0")]
		public void show ();
		[Version (since = "1.10")]
		public void swap_buffers ();
		[Version (since = "1.16")]
		public void swap_buffers_with_damage (int rectangles, int n_rectangles);
		[Version (since = "1.10")]
		public void swap_region (int rectangles, int n_rectangles);
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_onscreen_dirty_closure_get_gtype ()")]
	[Compact]
	[Version (since = "1.16")]
	public class OnscreenDirtyClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "cogl_onscreen_resize_closure_get_gtype ()")]
	[Compact]
	[Version (since = "2.0")]
	public class OnscreenResizeClosure {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_pipeline_get_gtype ()")]
	public class Pipeline : Cogl.Object {
		[CCode (has_construct_function = false)]
		protected Pipeline ();
		[Version (since = "2.0")]
		public Cogl.Pipeline copy ();
		[Version (since = "2.0")]
		public void foreach_layer (Cogl.PipelineLayerCallback callback);
		[Version (since = "2.0")]
		public Cogl.PipelineAlphaFunc get_alpha_test_function ();
		[Version (since = "2.0")]
		public float get_alpha_test_reference ();
		[Version (since = "2.0")]
		public void get_ambient (Cogl.Color ambient);
		[Version (since = "2.0")]
		public Cogl.Color get_color ();
		[Version (since = "1.8")]
		public Cogl.ColorMask get_color_mask ();
		[Version (since = "2.0")]
		public Cogl.PipelineCullFaceMode get_cull_face_mode ();
		[Version (since = "2.0")]
		public void get_diffuse (Cogl.Color diffuse);
		[Version (since = "2.0")]
		public void get_emission (Cogl.Color emission);
		[Version (since = "2.0")]
		public Cogl.Winding get_front_face_winding ();
		[Version (since = "1.10")]
		public Cogl.PipelineFilter get_layer_mag_filter (int layer_index);
		[Version (since = "1.10")]
		public Cogl.PipelineFilter get_layer_min_filter (int layer_index);
		[Version (since = "2.0")]
		public Cogl.Bool get_layer_point_sprite_coords_enabled (int layer_index);
		[Version (since = "1.10")]
		public unowned Cogl.Texture get_layer_texture (int layer_index);
		[Version (since = "1.6")]
		public Cogl.PipelineWrapMode get_layer_wrap_mode_p (int layer_index);
		[Version (since = "1.6")]
		public Cogl.PipelineWrapMode get_layer_wrap_mode_s (int layer_index);
		[Version (since = "1.6")]
		public Cogl.PipelineWrapMode get_layer_wrap_mode_t (int layer_index);
		[Version (since = "2.0")]
		public int get_n_layers ();
		[Version (since = "2.0")]
		public Cogl.Bool get_per_vertex_point_size ();
		[Version (since = "2.0")]
		public float get_point_size ();
		[Version (since = "2.0")]
		public float get_shininess ();
		[Version (since = "2.0")]
		public void get_specular (Cogl.Color specular);
		[Version (since = "2.0")]
		public int get_uniform_location (string uniform_name);
		[Version (since = "2.0")]
		public Cogl.Handle get_user_program ();
		[Version (since = "1.10")]
		public void remove_layer (int layer_index);
		[Version (since = "2.0")]
		public void set_alpha_test_function (Cogl.PipelineAlphaFunc alpha_func, float alpha_reference);
		[Version (since = "2.0")]
		public void set_ambient (Cogl.Color ambient);
		[Version (since = "2.0")]
		public void set_ambient_and_diffuse (Cogl.Color color);
		[Version (since = "2.0")]
		public Cogl.Bool set_blend (string blend_string) throws GLib.Error;
		[Version (since = "2.0")]
		public void set_blend_constant (Cogl.Color constant_color);
		[Version (since = "2.0")]
		public void set_color (Cogl.Color color);
		[Version (since = "2.0")]
		public void set_color4f (float red, float green, float blue, float alpha);
		[Version (since = "2.0")]
		public void set_color4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[Version (since = "1.8")]
		public void set_color_mask (Cogl.ColorMask color_mask);
		[Version (since = "2.0")]
		public void set_cull_face_mode (Cogl.PipelineCullFaceMode cull_face_mode);
		[Version (since = "2.0")]
		public void set_diffuse (Cogl.Color diffuse);
		[Version (since = "2.0")]
		public void set_emission (Cogl.Color emission);
		[Version (since = "2.0")]
		public void set_front_face_winding (Cogl.Winding front_winding);
		[Version (since = "2.0")]
		public Cogl.Bool set_layer_combine (int layer_index, string blend_string) throws GLib.Error;
		[Version (since = "2.0")]
		public void set_layer_combine_constant (int layer_index, Cogl.Color constant);
		[Version (since = "1.10")]
		public void set_layer_filters (int layer_index, Cogl.PipelineFilter min_filter, Cogl.PipelineFilter mag_filter);
		[Version (since = "1.10")]
		public void set_layer_matrix (int layer_index, Cogl.Matrix matrix);
		[Version (since = "1.10")]
		public void set_layer_null_texture (int layer_index, Cogl.TextureType texture_type);
		[Version (since = "2.0")]
		public Cogl.Bool set_layer_point_sprite_coords_enabled (int layer_index, Cogl.Bool enable) throws GLib.Error;
		public void set_layer_texture (int layer_index, Cogl.Texture texture);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode_p (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode_s (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public void set_layer_wrap_mode_t (int layer_index, Cogl.PipelineWrapMode mode);
		[Version (since = "2.0")]
		public Cogl.Bool set_per_vertex_point_size (Cogl.Bool enable) throws GLib.Error;
		[Version (since = "2.0")]
		public void set_point_size (float point_size);
		[Version (since = "2.0")]
		public void set_shininess (float shininess);
		[Version (since = "2.0")]
		public void set_specular (Cogl.Color specular);
		[Version (since = "2.0")]
		public void set_uniform_1f (int uniform_location, float value);
		[Version (since = "2.0")]
		public void set_uniform_1i (int uniform_location, int value);
		[Version (since = "2.0")]
		public void set_uniform_float (int uniform_location, int n_components, int count, float value);
		[Version (since = "2.0")]
		public void set_uniform_int (int uniform_location, int n_components, int count, int value);
		[Version (since = "2.0")]
		public void set_uniform_matrix (int uniform_location, int dimensions, int count, Cogl.Bool transpose, float value);
		[Version (since = "2.0")]
		public void set_user_program (Cogl.Handle program);
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Compact]
	public class Quaternion {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_framebuffer_get_gtype ()")]
	public interface Framebuffer : Cogl.Object {
		[Version (since = "1.8")]
		public Cogl.Bool allocate () throws GLib.Error;
		[Version (since = "1.8")]
		public void clear (ulong buffers, Cogl.Color color);
		[Version (since = "1.8")]
		public void clear4f (ulong buffers, float red, float green, float blue, float alpha);
		[Version (since = "1.8")]
		public void discard_buffers (ulong buffers);
		[Version (since = "1.10")]
		public void draw_multitextured_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2, [CCode (array_length = false)] float[] tex_coords, int tex_coords_len);
		[Version (since = "1.10")]
		public void draw_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2);
		[Version (since = "1.10")]
		public void draw_rectangles (Cogl.Pipeline pipeline, [CCode (array_length = false)] float[] coordinates, uint n_rectangles);
		[Version (since = "1.10")]
		public void draw_textured_rectangle (Cogl.Pipeline pipeline, float x_1, float y_1, float x_2, float y_2, float s_1, float t_1, float s_2, float t_2);
		[Version (since = "1.10")]
		public void draw_textured_rectangles (Cogl.Pipeline pipeline, [CCode (array_length = false)] float[] coordinates, uint n_rectangles);
		public static uint32 error_quark ();
		[Version (since = "1.10")]
		public void finish ();
		[Version (since = "1.10")]
		public void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
		[Version (since = "1.8")]
		public int get_alpha_bits ();
		[Version (since = "1.8")]
		public int get_blue_bits ();
		[Version (since = "1.8")]
		public Cogl.ColorMask get_color_mask ();
		[Version (since = "2.0")]
		public int get_depth_bits ();
		[Version (since = "1.14")]
		public unowned Cogl.Texture get_depth_texture ();
		[Version (since = "1.14")]
		public Cogl.Bool get_depth_texture_enabled ();
		[Version (since = "1.18")]
		public Cogl.Bool get_depth_write_enabled ();
		[Version (since = "1.8")]
		public Cogl.Bool get_dither_enabled ();
		[Version (since = "1.8")]
		public int get_green_bits ();
		[Version (since = "1.8")]
		public int get_height ();
		public Cogl.Bool get_is_stereo ();
		[Version (since = "1.10")]
		public Cogl.Matrix get_modelview_matrix ();
		[Version (since = "1.10")]
		public Cogl.Matrix get_projection_matrix ();
		[Version (since = "1.8")]
		public int get_red_bits ();
		[Version (since = "1.10")]
		public int get_samples_per_pixel ();
		[Version (since = "1.20")]
		public Cogl.StereoMode get_stereo_mode ();
		[Version (since = "1.8")]
		public void get_viewport4fv ([CCode (array_length = false)] out unowned float viewport[4]);
		[Version (since = "1.8")]
		public float get_viewport_height ();
		[Version (since = "1.8")]
		public float get_viewport_width ();
		[Version (since = "1.8")]
		public float get_viewport_x ();
		[Version (since = "1.8")]
		public float get_viewport_y ();
		[Version (since = "1.8")]
		public int get_width ();
		[Version (since = "1.10")]
		public void identity_matrix ();
		[Version (since = "1.10")]
		public void orthographic (float x_1, float y_1, float x_2, float y_2, float near, float far);
		[Version (since = "1.10")]
		public void perspective (float fov_y, float aspect, float z_near, float z_far);
		[Version (since = "1.10")]
		public void pop_clip ();
		[Version (since = "1.10")]
		public void pop_matrix ();
		[Version (since = "1.10")]
		public void push_matrix ();
		[Version (since = "1.10")]
		public void push_rectangle_clip (float x_1, float y_1, float x_2, float y_2);
		[Version (since = "1.10")]
		public void push_scissor_clip (int x, int y, int width, int height);
		[Version (since = "1.10")]
		public Cogl.Bool read_pixels (int x, int y, int width, int height, Cogl.PixelFormat format, uint8 pixels);
		[Version (since = "1.10")]
		public Cogl.Bool read_pixels_into_bitmap (int x, int y, Cogl.ReadPixelsFlags source, Cogl.Bitmap bitmap);
		[Version (since = "1.8")]
		public void resolve_samples ();
		[Version (since = "1.8")]
		public void resolve_samples_region (int x, int y, int width, int height);
		[Version (since = "1.10")]
		public void rotate (float angle, float x, float y, float z);
		[Version (since = "2.0")]
		public void rotate_euler (Cogl.Euler euler);
		[Version (since = "2.0")]
		public void rotate_quaternion (Cogl.Quaternion quaternion);
		[Version (since = "1.10")]
		public void scale (float x, float y, float z);
		[Version (since = "1.8")]
		public void set_color_mask (Cogl.ColorMask color_mask);
		[Version (since = "1.14")]
		public void set_depth_texture_enabled (Cogl.Bool enabled);
		[Version (since = "1.18")]
		public void set_depth_write_enabled (Cogl.Bool depth_write_enabled);
		[Version (since = "1.8")]
		public void set_dither_enabled (Cogl.Bool dither_enabled);
		[Version (since = "1.10")]
		public void set_modelview_matrix (Cogl.Matrix matrix);
		[Version (since = "1.10")]
		public void set_projection_matrix (Cogl.Matrix matrix);
		[Version (since = "1.8")]
		public void set_samples_per_pixel (int samples_per_pixel);
		[Version (since = "1.20")]
		public void set_stereo_mode (Cogl.StereoMode stereo_mode);
		[Version (since = "1.8")]
		public void set_viewport (float x, float y, float width, float height);
		[Version (since = "1.10")]
		public void transform (Cogl.Matrix matrix);
		[Version (since = "1.10")]
		public void translate (float x, float y, float z);
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_texture_get_gtype ()")]
	public interface Texture : Cogl.Object {
		public Cogl.Bool allocate () throws GLib.Error;
		public static uint32 error_quark ();
		[Version (since = "1.18")]
		public Cogl.TextureComponents get_components ();
		public int get_data (Cogl.PixelFormat format, uint rowstride, uint8 data);
		public Cogl.Bool get_gl_texture (out uint out_gl_handle, out uint out_gl_target);
		public uint get_height ();
		public int get_max_waste ();
		[Version (since = "1.18")]
		public Cogl.Bool get_premultiplied ();
		public uint get_width ();
		public Cogl.Bool is_sliced ();
		[Version (deprecated = true, deprecated_since = "1.18", since = "1.0")]
		public static Cogl.Texture new_from_bitmap (Cogl.Bitmap bitmap, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
		[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
		public static Cogl.Texture new_from_data (int width, int height, Cogl.TextureFlags flags, Cogl.PixelFormat format, Cogl.PixelFormat internal_format, int rowstride, uint8 data);
		[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
		public static Cogl.Texture new_from_file (string filename, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
		public static Cogl.Texture new_from_foreign (uint gl_handle, uint gl_target, uint width, uint height, uint x_pot_waste, uint y_pot_waste, Cogl.PixelFormat format);
		[Version (deprecated = true, deprecated_since = "1.18", since = "1.2")]
		public Cogl.Texture new_from_sub_texture (int sub_x, int sub_y, int sub_width, int sub_height);
		[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
		public static Cogl.Texture new_with_size (uint width, uint height, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
		[Version (since = "1.18")]
		public void set_components (Cogl.TextureComponents components);
		public Cogl.Bool set_data (Cogl.PixelFormat format, int rowstride, uint8 data, int level) throws GLib.Error;
		[Version (since = "1.18")]
		public void set_premultiplied (Cogl.Bool premultiplied);
		public Cogl.Bool set_region (int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, int width, int height, Cogl.PixelFormat format, uint rowstride, uint8 data);
		[Version (since = "1.8")]
		public Cogl.Bool set_region_from_bitmap (int src_x, int src_y, int dst_x, int dst_y, uint dst_width, uint dst_height, Cogl.Bitmap bitmap);
	}
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	public struct Angle : int32 {
	}
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	public struct Bool : int {
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_color_get_gtype ()")]
	[Version (since = "1.0")]
	public struct Color {
		public Cogl.Color? copy ();
		public static Cogl.Bool equal (void* v1, void* v2);
		public float get_alpha ();
		public uint8 get_alpha_byte ();
		public float get_alpha_float ();
		public float get_blue ();
		public uint8 get_blue_byte ();
		public float get_blue_float ();
		public float get_green ();
		public uint8 get_green_byte ();
		public float get_green_float ();
		public float get_red ();
		public uint8 get_red_byte ();
		public float get_red_float ();
		[Version (since = "1.4")]
		public void init_from_4f (float red, float green, float blue, float alpha);
		[Version (since = "1.4")]
		public void init_from_4fv (float color_array);
		[Version (since = "1.4")]
		public void init_from_4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[Version (since = "1.16")]
		public static void init_from_hsl (out Cogl.Color color, float hue, float saturation, float luminance);
		public void premultiply ();
		[Version (since = "1.4")]
		public void set_alpha (float alpha);
		[Version (since = "1.4")]
		public void set_alpha_byte (uint8 alpha);
		[Version (since = "1.4")]
		public void set_alpha_float (float alpha);
		[Version (since = "1.4")]
		public void set_blue (float blue);
		[Version (since = "1.4")]
		public void set_blue_byte (uint8 blue);
		[Version (since = "1.4")]
		public void set_blue_float (float blue);
		[Version (deprecated = true, deprecated_since = "1.4", since = "1.0")]
		public void set_from_4f (float red, float green, float blue, float alpha);
		[Version (deprecated = true, deprecated_since = "1.4", since = "1.0")]
		public void set_from_4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
		[Version (since = "1.4")]
		public void set_green (float green);
		[Version (since = "1.4")]
		public void set_green_byte (uint8 green);
		[Version (since = "1.4")]
		public void set_green_float (float green);
		[Version (since = "1.4")]
		public void set_red (float red);
		[Version (since = "1.4")]
		public void set_red_byte (uint8 red);
		[Version (since = "1.4")]
		public void set_red_float (float red);
		[Version (since = "1.16")]
		public void to_hsl (out float hue, out float saturation, out float luminance);
		[Version (since = "1.4")]
		public void unpremultiply ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.8")]
	public struct DebugObjectTypeInfo {
		public weak string name;
		public ulong instance_count;
	}
	[CCode (cheader_filename = "cogl/cogl.h")]
	[SimpleType]
	public struct Handle {
		public static GLib.Type get_type ();
		public Cogl.Handle @ref ();
		public void unref ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", type_id = "cogl_matrix_get_gtype ()")]
	public struct Matrix {
		public float xx;
		public float yx;
		public float zx;
		public float wx;
		public float xy;
		public float yy;
		public float zy;
		public float wy;
		public float xz;
		public float yz;
		public float zz;
		public float wz;
		public float xw;
		public float yw;
		public float zw;
		public float ww;
		[Version (since = "1.6")]
		public Cogl.Matrix? copy ();
		[Version (since = "1.4")]
		public static Cogl.Bool equal (void* v1, void* v2);
		[Version (since = "1.6")]
		public void free ();
		public void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
		public unowned float[] get_array ();
		[Version (since = "1.2")]
		public Cogl.Bool get_inverse (out Cogl.Matrix inverse);
		public void init_from_euler (Cogl.Euler euler);
		public void init_from_quaternion (Cogl.Quaternion quaternion);
		[Version (since = "2.0")]
		public void init_translation (float tx, float ty, float tz);
		[Version (since = "1.8")]
		public Cogl.Bool is_identity ();
		[Version (since = "1.8")]
		public void look_at (float eye_position_x, float eye_position_y, float eye_position_z, float object_x, float object_y, float object_z, float world_up_x, float world_up_y, float world_up_z);
		[Version (deprecated = true, deprecated_since = "1.10")]
		public void ortho (float left, float right, float bottom, float top, float near, float far);
		[Version (since = "1.10")]
		public void orthographic (float x_1, float y_1, float x_2, float y_2, float near, float far);
		public void perspective (float fov_y, float aspect, float z_near, float z_far);
		public void project_points (int n_components, size_t stride_in, void* points_in, size_t stride_out, void* points_out, int n_points);
		public void rotate (float angle, float x, float y, float z);
		[Version (since = "2.0")]
		public void rotate_euler (Cogl.Euler euler);
		[Version (since = "2.0")]
		public void rotate_quaternion (Cogl.Quaternion quaternion);
		public void scale (float sx, float sy, float sz);
		public void transform_point (ref float x, ref float y, ref float z, ref float w);
		public void transform_points (int n_components, size_t stride_in, void* points_in, size_t stride_out, void* points_out, int n_points);
		public void translate (float x, float y, float z);
		[Version (since = "1.10")]
		public void transpose ();
		[Version (since = "1.8")]
		public void view_2d_in_frustum (float left, float right, float bottom, float top, float z_near, float z_2d, float width_2d, float height_2d);
		[Version (since = "1.8")]
		public void view_2d_in_perspective (float fov_y, float aspect, float z_near, float z_2d, float width_2d, float height_2d);
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.16")]
	public struct OnscreenDirtyInfo {
		public int x;
		public int y;
		public int width;
		public int height;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	public struct TextureVertex {
		public float x;
		public float y;
		public float z;
		public float tx;
		public float ty;
		public Cogl.Color color;
	}
	[CCode (cheader_filename = "cogl/cogl.h", has_type_id = false)]
	[Version (since = "1.4")]
	public struct UserDataKey {
		public int unused;
	}
	[CCode (cheader_filename = "cogl/cogl.h", cname = "_CoglColorSizeCheck", has_type_id = false)]
	public struct _ColorSizeCheck {
		[CCode (array_length = false)]
		public weak char[] compile_time_assert_CoglColor_size;
	}
	[CCode (cheader_filename = "cogl/cogl.h", cname = "_CoglMatrixSizeCheck", has_type_id = false)]
	public struct _MatrixSizeCheck {
		[CCode (array_length = false)]
		public weak char[] compile_time_assert_CoglMatrix_size;
	}
	[CCode (cheader_filename = "cogl/cogl.h", cname = "_CoglTextureVertexSizeCheck", has_type_id = false)]
	public struct _TextureVertexSizeCheck {
		[CCode (array_length = false)]
		public weak char[] compile_time_assert_CoglTextureVertex_size;
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_ATTRIBUTE_TYPE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum AttributeType {
		BYTE,
		UNSIGNED_BYTE,
		SHORT,
		UNSIGNED_SHORT,
		FLOAT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BITMAP_ERROR_", has_type_id = false)]
	[Version (since = "1.4")]
	public enum BitmapError {
		FAILED,
		UNKNOWN_TYPE,
		CORRUPT_IMAGE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BLEND_STRING_ERROR_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum BlendStringError {
		PARSE_ERROR,
		ARGUMENT_PARSE_ERROR,
		INVALID_ERROR,
		GPU_UNSUPPORTED_ERROR;
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_BUFFER_BIT_", has_type_id = false)]
	[Flags]
	[Version (since = "1.0")]
	public enum BufferBit {
		COLOR,
		DEPTH,
		STENCIL
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_", has_type_id = false)]
	[Flags]
	[Version (since = "0.8")]
	public enum BufferTarget {
		WINDOW_BUFFER,
		OFFSCREEN_BUFFER
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_COLOR_MASK_", has_type_id = false)]
	[Flags]
	public enum ColorMask {
		NONE,
		RED,
		GREEN,
		BLUE,
		ALPHA,
		ALL
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_DEPTH_TEST_FUNCTION_", has_type_id = false)]
	public enum DepthTestFunction {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FEATURE_", has_type_id = false)]
	[Flags]
	[Version (since = "0.8")]
	public enum FeatureFlags {
		TEXTURE_RECTANGLE,
		TEXTURE_NPOT,
		TEXTURE_YUV,
		TEXTURE_READ_PIXELS,
		SHADERS_GLSL,
		OFFSCREEN,
		OFFSCREEN_MULTISAMPLE,
		OFFSCREEN_BLIT,
		FOUR_CLIP_PLANES,
		STENCIL_BUFFER,
		VBOS,
		PBOS,
		UNSIGNED_INT_INDICES,
		DEPTH_RANGE,
		TEXTURE_NPOT_BASIC,
		TEXTURE_NPOT_MIPMAP,
		TEXTURE_NPOT_REPEAT,
		POINT_SPRITE,
		TEXTURE_3D,
		MAP_BUFFER_FOR_READ,
		MAP_BUFFER_FOR_WRITE,
		ONSCREEN_MULTIPLE,
		DEPTH_TEXTURE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FILTER_", has_type_id = false)]
	public enum FilterReturn {
		CONTINUE,
		REMOVE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FOG_MODE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum FogMode {
		LINEAR,
		EXPONENTIAL,
		EXPONENTIAL_SQUARED
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FRAME_EVENT_", has_type_id = false)]
	[Version (since = "1.14")]
	public enum FrameEvent {
		SYNC,
		COMPLETE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_FRAMEBUFFER_ERROR_", has_type_id = false)]
	public enum FramebufferError {
		[CCode (cname = "COGL_FRAMEBUFFER_ERROR_ALLOCATE")]
		FRAMEBUFFER_ERROR_ALLOCATE;
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_INDICES_TYPE_UNSIGNED_", has_type_id = false)]
	public enum IndicesType {
		BYTE,
		SHORT,
		INT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_MATERIAL_ALPHA_FUNC_", has_type_id = false)]
	public enum MaterialAlphaFunc {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_MATERIAL_FILTER_", has_type_id = false)]
	public enum MaterialFilter {
		NEAREST,
		LINEAR,
		NEAREST_MIPMAP_NEAREST,
		LINEAR_MIPMAP_NEAREST,
		NEAREST_MIPMAP_LINEAR,
		LINEAR_MIPMAP_LINEAR
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_MATERIAL_LAYER_TYPE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum MaterialLayerType {
		[CCode (cname = "COGL_MATERIAL_LAYER_TYPE_TEXTURE")]
		MATERIAL_LAYER_TYPE_TEXTURE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_MATERIAL_WRAP_MODE_", has_type_id = false)]
	[Version (since = "1.4")]
	public enum MaterialWrapMode {
		REPEAT,
		CLAMP_TO_EDGE,
		AUTOMATIC
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_ALPHA_FUNC_", has_type_id = false)]
	public enum PipelineAlphaFunc {
		NEVER,
		LESS,
		EQUAL,
		LEQUAL,
		GREATER,
		NOTEQUAL,
		GEQUAL,
		ALWAYS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_CULL_FACE_MODE_", has_type_id = false)]
	public enum PipelineCullFaceMode {
		NONE,
		FRONT,
		BACK,
		BOTH
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_FILTER_", has_type_id = false)]
	public enum PipelineFilter {
		NEAREST,
		LINEAR,
		NEAREST_MIPMAP_NEAREST,
		LINEAR_MIPMAP_NEAREST,
		NEAREST_MIPMAP_LINEAR,
		LINEAR_MIPMAP_LINEAR
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIPELINE_WRAP_MODE_", has_type_id = false)]
	[Version (since = "2.0")]
	public enum PipelineWrapMode {
		REPEAT,
		MIRRORED_REPEAT,
		CLAMP_TO_EDGE,
		AUTOMATIC
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_PIXEL_FORMAT_", has_type_id = false)]
	[Flags]
	[Version (since = "0.8")]
	public enum PixelFormat {
		ANY,
		A_8,
		RGB_565,
		RGBA_4444,
		RGBA_5551,
		YUV,
		G_8,
		RG_88,
		RGB_888,
		BGR_888,
		RGBA_8888,
		BGRA_8888,
		ARGB_8888,
		ABGR_8888,
		RGBA_1010102,
		BGRA_1010102,
		ARGB_2101010,
		ABGR_2101010,
		RGBA_8888_PRE,
		BGRA_8888_PRE,
		ARGB_8888_PRE,
		ABGR_8888_PRE,
		RGBA_4444_PRE,
		RGBA_5551_PRE,
		RGBA_1010102_PRE,
		BGRA_1010102_PRE,
		ARGB_2101010_PRE,
		ABGR_2101010_PRE,
		DEPTH_16,
		DEPTH_32,
		DEPTH_24_STENCIL_8
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_READ_PIXELS_COLOR_", has_type_id = false)]
	[Flags]
	[Version (since = "1.0")]
	public enum ReadPixelsFlags {
		[CCode (cname = "COGL_READ_PIXELS_COLOR_BUFFER")]
		READ_PIXELS_COLOR_BUFFER
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_RENDERER_ERROR_", has_type_id = false)]
	public enum RendererError {
		XLIB_DISPLAY_OPEN,
		BAD_CONSTRAINT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SHADER_TYPE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum ShaderType {
		VERTEX,
		FRAGMENT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_STEREO_", has_type_id = false)]
	public enum StereoMode {
		BOTH,
		LEFT,
		RIGHT
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_SYSTEM_ERROR_", has_type_id = false)]
	[Version (since = "1.4")]
	public enum SystemError {
		UNSUPPORTED,
		NO_MEMORY
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_COMPONENTS_", has_type_id = false)]
	[Version (since = "1.18")]
	public enum TextureComponents {
		A,
		RG,
		RGB,
		RGBA,
		DEPTH
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_ERROR_", has_type_id = false)]
	[Version (since = "1.8")]
	public enum TextureError {
		SIZE,
		FORMAT,
		BAD_PARAMETER,
		TYPE;
		public static uint32 quark ();
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_", has_type_id = false)]
	[Flags]
	[Version (since = "1.0")]
	public enum TextureFlags {
		NONE,
		NO_AUTO_MIPMAP,
		NO_SLICING,
		NO_ATLAS
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_TEXTURE_TYPE_", has_type_id = false)]
	[Version (since = "1.10")]
	public enum TextureType {
		@2D,
		@3D,
		RECTANGLE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_VERTICES_MODE_", has_type_id = false)]
	[Version (since = "1.0")]
	public enum VerticesMode {
		POINTS,
		LINES,
		LINE_LOOP,
		LINE_STRIP,
		TRIANGLES,
		TRIANGLE_STRIP,
		TRIANGLE_FAN
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINDING_", has_type_id = false)]
	public enum Winding {
		CLOCKWISE,
		COUNTER_CLOCKWISE
	}
	[CCode (cheader_filename = "cogl/cogl.h", cprefix = "COGL_WINSYS_FEATURE_", has_type_id = false)]
	public enum WinsysFeature {
		MULTIPLE_ONSCREEN,
		SWAP_THROTTLE,
		VBLANK_COUNTER,
		VBLANK_WAIT,
		TEXTURE_FROM_PIXMAP,
		SWAP_BUFFERS_EVENT,
		SWAP_REGION,
		SWAP_REGION_THROTTLE,
		SWAP_REGION_SYNCHRONIZED,
		BUFFER_AGE,
		SYNC_AND_COMPLETE_EVENT,
		N_FEATURES
	}
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	[Version (since = "1.8")]
	public delegate void DebugObjectForeachTypeCallback (Cogl.DebugObjectTypeInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
	public delegate Cogl.Bool MaterialLayerCallback (Cogl.Material material, int layer_index);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	[Version (since = "1.16")]
	public delegate void OnscreenDirtyCallback (Cogl.Onscreen onscreen, Cogl.OnscreenDirtyInfo info);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 3.9)]
	[Version (since = "2.0")]
	public delegate void OnscreenResizeCallback (Cogl.Onscreen onscreen, int width, int height);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	public delegate void OnscreenX11MaskCallback (Cogl.Onscreen onscreen, uint32 event_mask);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 2.9)]
	[Version (since = "2.0")]
	public delegate Cogl.Bool PipelineLayerCallback (Cogl.Pipeline pipeline, int layer_index);
	[CCode (cheader_filename = "cogl/cogl.h", instance_pos = 1.9)]
	public delegate void SwapBuffersNotify (Cogl.Framebuffer framebuffer);
	[CCode (cheader_filename = "cogl/cogl.h", has_target = false)]
	public delegate void UserDataDestroyCallback (void* data);
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_AFIRST_BIT")]
	public const int AFIRST_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_A_BIT")]
	public const int A_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_BGR_BIT")]
	public const int BGR_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_DEPTH_BIT")]
	public const int DEPTH_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_PREMULT_BIT")]
	public const int PREMULT_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_STENCIL_BIT")]
	public const int STENCIL_BIT;
	[CCode (cheader_filename = "cogl/cogl.h", cname = "COGL_TEXTURE_MAX_WASTE")]
	public const int TEXTURE_MAX_WASTE;
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void begin_gl ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.2")]
	public static Cogl.Bool check_extension (string name, string ext);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void clear (Cogl.Color color, ulong buffers);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Bool clutter_check_extension_CLUTTER (string name, string ext);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static Cogl.Bool clutter_winsys_has_feature_CLUTTER (Cogl.WinsysFeature feature);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "2.0")]
	public static void debug_matrix_print (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.8")]
	public static void debug_object_foreach_type (Cogl.DebugObjectForeachTypeCallback func);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.8")]
	public static void debug_object_print_instances ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void disable_fog ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void end_gl ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static Cogl.Bool features_available (Cogl.FeatureFlags features);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.0")]
	public static void flush ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10", since = "0.8.2")]
	public static void frustum (float left, float right, float bottom, float top, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.Bool get_backface_culling_enabled ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.8")]
	public static void get_bitmasks (out int red, out int green, out int blue, out int alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.Bool get_depth_test_enabled ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.8")]
	public static unowned Cogl.Framebuffer get_draw_framebuffer ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10", since = "0.8")]
	public static Cogl.FeatureFlags get_features ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static Cogl.Matrix get_modelview_matrix ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static GLib.OptionGroup get_option_group ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static Cogl.Matrix get_projection_matrix ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.6")]
	public static void* get_source ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void get_viewport ([CCode (array_length = false)] out float v[4]);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.18")]
	public static GLib.Type gtype_matrix_get_type ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.10")]
	public static Cogl.Bool is_framebuffer (void* object);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.10")]
	public static Cogl.Bool is_onscreen (void* object);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "2.0")]
	public static Cogl.Bool is_pipeline (void* object);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.4")]
	public static Cogl.Bool is_vertex_buffer_indices (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10", since = "1.0")]
	public static void ortho (float left, float right, float bottom, float top, float near, float far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void perspective (float fovy, float aspect, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.0")]
	public static void polygon (Cogl.TextureVertex vertices, uint n_vertices, Cogl.Bool use_color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void pop_matrix ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.6")]
	public static void pop_source ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void push_matrix ();
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.6")]
	public static void push_source (void* material);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static void rectangle (float x_1, float y_1, float x_2, float y_2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.0")]
	public static void rectangle_with_multitexture_coords (float x1, float y1, float x2, float y2, [CCode (array_length = false)] float[] tex_coords, int tex_coords_len);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.0")]
	public static void rectangle_with_texture_coords (float x1, float y1, float x2, float y2, float tx1, float ty1, float tx2, float ty2);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.0")]
	public static void rectangles ([CCode (array_length = false)] float[] verts, uint n_rects);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "0.8.6")]
	public static void rectangles_with_texture_coords ([CCode (array_length = false)] float[] verts, uint n_rects);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void rotate (float angle, float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void scale (float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void set_backface_culling_enabled (Cogl.Bool setting);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void set_depth_test_enabled (Cogl.Bool setting);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void set_fog (Cogl.Color fog_color, Cogl.FogMode mode, float density, float z_near, float z_far);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void set_modelview_matrix (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void set_projection_matrix (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void set_source (void* material);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void set_source_color (Cogl.Color color);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void set_source_color4f (float red, float green, float blue, float alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void set_source_color4ub (uint8 red, uint8 green, uint8 blue, uint8 alpha);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16", since = "1.0")]
	public static void set_source_texture (Cogl.Texture texture);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.8", since = "1.2")]
	public static void set_viewport (int x, int y, int width, int height);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void shader_compile (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static string shader_get_info_log (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.ShaderType shader_get_type (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.Bool shader_is_compiled (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.Handle shader_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void shader_source (Cogl.Handle shader, string source);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void shader_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.18", since = "1.0")]
	public static Cogl.Texture texture_new_from_bitmap (Cogl.Bitmap bitmap, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
	public static Cogl.Texture texture_new_from_data (int width, int height, Cogl.TextureFlags flags, Cogl.PixelFormat format, Cogl.PixelFormat internal_format, int rowstride, uint8 data);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
	public static Cogl.Texture texture_new_from_file (string filename, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format) throws GLib.Error;
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
	public static Cogl.Texture texture_new_from_foreign (uint gl_handle, uint gl_target, uint width, uint height, uint x_pot_waste, uint y_pot_waste, Cogl.PixelFormat format);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.18", since = "0.8")]
	public static Cogl.Texture texture_new_with_size (uint width, uint height, Cogl.TextureFlags flags, Cogl.PixelFormat internal_format);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10", since = "1.4")]
	public static void transform (Cogl.Matrix matrix);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.10")]
	public static void translate (float x, float y, float z);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_add (Cogl.Handle handle, string attribute_name, uint8 n_components, Cogl.AttributeType type, Cogl.Bool normalized, uint16 stride, void* pointer);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_delete (Cogl.Handle handle, string attribute_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_disable (Cogl.Handle handle, string attribute_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_draw (Cogl.Handle handle, Cogl.VerticesMode mode, int first, int count);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_draw_elements (Cogl.Handle handle, Cogl.VerticesMode mode, Cogl.Handle indices, int min_index, int max_index, int indices_offset, int count);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_enable (Cogl.Handle handle, string attribute_name);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static uint vertex_buffer_get_n_vertices (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.Handle vertex_buffer_indices_get_for_quads (uint n_indices);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.IndicesType vertex_buffer_indices_get_type (Cogl.Handle indices);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static Cogl.Handle vertex_buffer_new (uint n_vertices);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.2")]
	public static Cogl.Handle vertex_buffer_ref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.16")]
	public static void vertex_buffer_submit (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.2")]
	public static void vertex_buffer_unref (Cogl.Handle handle);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (deprecated = true, deprecated_since = "1.8", since = "0.8.2")]
	public static void viewport (uint width, uint height);
	[CCode (cheader_filename = "cogl/cogl.h")]
	public static uint32 x11_onscreen_get_visual_xid (Cogl.Onscreen onscreen);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "1.10")]
	public static uint32 x11_onscreen_get_window_xid (Cogl.Onscreen onscreen);
	[CCode (cheader_filename = "cogl/cogl.h")]
	[Version (since = "2.0")]
	public static void x11_onscreen_set_foreign_window_xid (Cogl.Onscreen onscreen, uint32 xid, [CCode (scope = "async")] Cogl.OnscreenX11MaskCallback update);
}
