//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Widget/ItemComboToolbar.h
//! @brief     Defines class ItemComboToolbar
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_WIDGET_ITEMCOMBOTOOLBAR_H
#define BORNAGAIN_GUI_VIEW_WIDGET_ITEMCOMBOTOOLBAR_H

#include "GUI/View/Widget/StyledToolbar.h"
#include <QList>

class QAction;
class QComboBox;

//! The ItemComboToolbar class is a styled toolbar on top of ItemComboWidget. Contains
//! ComboBox to switch ItemComboWidget, and dynamic list of actions, which are updated
//! according to current state of ItemComboWidget.

class ItemComboToolbar : public StyledToolbar {
    Q_OBJECT

public:
    explicit ItemComboToolbar(QWidget* parent = nullptr);

    void setPresentation(const QString& name);

    void setPresentationList(const QStringList& presentationList,
                             const QStringList& activeList = {});

    QString currentPresentation() const;

    void setActionList(const QList<QAction*>& actionList);

signals:
    void comboChanged(const QString& presentation);

private:
    void setComboConnected(bool value);
    void makeItemsEnabled(const QStringList& activePresentations);
    void _comboChanged(const int index);

    QComboBox* m_comboBox;
    QAction* m_comboBoxAction;
};

#endif // BORNAGAIN_GUI_VIEW_WIDGET_ITEMCOMBOTOOLBAR_H
