//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Instrument/InstrumentListModel.h
//! @brief     Defines class InstrumentListModel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLISTMODEL_H
#define BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLISTMODEL_H

#include <QAbstractListModel>
#include <QIcon>

class InstrumentItem;
class MultiInstrumentNotifier;

//! List model for instruments.
//!
//! Used e.g. to present the instrument list in the instrument view.
class InstrumentListModel : public QAbstractListModel {
    Q_OBJECT
public:
    InstrumentListModel(QObject* parent, MultiInstrumentNotifier* ec);

    int rowCount(const QModelIndex& parent = QModelIndex()) const override;

    QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const override;

    InstrumentItem* instrumentItemForIndex(const QModelIndex& index) const;

    QModelIndex addNewGISASInstrument();
    QModelIndex addNewOffspecInstrument();
    QModelIndex addNewSpecularInstrument();
    QModelIndex addNewDepthprobeInstrument();

    void removeInstrument(const QModelIndex& index);

    QModelIndex copyInstrument(const QModelIndex& source);
    QModelIndex copyInstrument(const InstrumentItem* source);

private:
    template <class Instrument>
    QModelIndex addNewInstrument();
    void onInstrumentNameChanged(const InstrumentItem* instrument);

    MultiInstrumentNotifier* m_ec;
    QIcon m_gisasIcon;
    QIcon m_offspecIcon;
    QIcon m_specularIcon;
    QIcon m_depthProbeIcon;
};

#endif // BORNAGAIN_GUI_VIEW_INSTRUMENT_INSTRUMENTLISTMODEL_H
