//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Info/OverlayLabelWidget.cpp
//! @brief     Implements class OverlayLabelWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/View/Info/OverlayLabelWidget.h"
#include "GUI/Support/Util/DesignerHelper.h"
#include "GUI/Support/Util/Style.h"
#include <QPainter>

OverlayLabelWidget::OverlayLabelWidget(QWidget* parent)
    : QWidget(parent)
    , m_bounding_rect(QRect(0, 0, 10, 10))
{
    setAttribute(Qt::WA_TransparentForMouseEvents);
}

void OverlayLabelWidget::setRectangle(const QRect& rect)
{
    m_bounding_rect = rect;
}

void OverlayLabelWidget::setPosition(int x, int y)
{
    setGeometry(x, y, m_bounding_rect.width(), m_bounding_rect.height());
}

void OverlayLabelWidget::paintEvent(QPaintEvent* event)
{
    Q_UNUSED(event);
    QPainter painter(this);
    painter.setBrush(QColor(Qt::lightGray));
    QFont serifFont("Monospace", DesignerHelper::getSectionFontSize(), QFont::Normal, true);
    painter.setFont(serifFont);
    //    painter.drawRect(m_bounding_rect);
    auto margin = GUI::Style::SizeOfLetterM().width();
    painter.drawText(m_bounding_rect.marginsRemoved(QMargins(margin, margin, margin, margin)),
                     Qt::AlignCenter, m_text);
}
