# - Prevent in-source builds.

function(prevent_in_source_builds)
  # make sure the user doesn't play dirty with symlinks
  get_filename_component(srcdir ${CMAKE_SOURCE_DIR} REALPATH)
  get_filename_component(bindir ${CMAKE_BINARY_DIR} REALPATH)

  # disallow in-source builds
  if(srcdir STREQUAL bindir)
    message(FATAL_ERROR "\

CMake must not to be run in the source directory. \
Rather create a dedicated build directory and run CMake there. \
To clean up after this aborted in-place compilation:
  rm -r CMakeCache.txt CMakeFiles
")
  endif()
endfunction()

prevent_in_source_builds()
