#ifndef XHEXPROG_H_INCLUDED
#define XHEXPROG_H_INCLUDED

#include <boost/function.hpp>


typedef boost::function<void (int pos, int max, std::string info)> ProgressCallback;
typedef boost::function<void (std::string info)> InfoCallback;

class xhex;
class Programmer;

class xhexprog {

  private:
    xhex * input_xhex;
    Programmer * prog;
    std::string progName;
    std::string portName;
    std::string partName;

  protected:
    void callStatusChange(const std::string & status);
    void callInfo(const std::string & info);
    void callProgress(int pos, int max);

  public:
    boost::function<void (const std::string & prog, const std::string & port, const std::string & part, const std::string & status)> onStatusChange;
    boost::function<void (const std::string & info)> onInfo;
    boost::function<void (int pos, int max)> onProgress;

    xhexprog();
    ~xhexprog();
    void setProgrammer(std::string name);
    void connect(std::string port);
    void setParameter(std::string parameter, std::string value);
    std::string getParameter(std::string parameter);
    void loadFile(std::string filename);
    void saveFile(std::string filename);

    void eraseChip();
    void writeChip();
    void readChip();
    void verifyChip();
    void updateChipInfo();

    bool isConnected();
    bool hasXHex();
};



#endif // XHEXPROG_H_INCLUDED
