# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _
from gtk.glade import XML as glade_XML
from gtk import STOCK_DIRECTORY, ListStore
from ConfigParser import ConfigParser, DuplicateSectionError
from os.path import join, isfile
from os import getcwd

class Config:
    def __init__(self, module, view, config_file, get_configuration):
        self.module = module
        self.view = view
        self.config_file = config_file
        self.get_configuration = get_configuration

    def save_config(self, name):
        if name == self.module['name']:
            wdg = self.conf_widgets

            combo = wdg.get_widget('combobox1')
            it = combo.get_active_iter()
            md = combo.get_model()
            view_mode = md[it][1]

            fcbutton = wdg.get_widget('filechooserbutton1')
            folder = fcbutton.get_filename()

            chck_scan = wdg.get_widget('check-scan')
            scan = chck_scan.get_active()

            chck_artwork = wdg.get_widget('check-artwork')
            artwork = chck_artwork.get_active()

            columns = ''
            if wdg.get_widget('check-column-track').get_active():
                columns += 'track,'
            if wdg.get_widget('check-column-title').get_active():
                columns += 'title,'
            if wdg.get_widget('check-column-artist').get_active():
                columns += 'artist,'
            if wdg.get_widget('check-column-album').get_active():
                columns += 'album,'
            if wdg.get_widget('check-column-genre').get_active():
                columns += 'genre,'
            if wdg.get_widget('check-column-comment').get_active():
                columns += 'comment,'
            if wdg.get_widget('check-column-year').get_active():
                columns += 'year,'
            if wdg.get_widget('check-column-length').get_active():
                columns += 'length,'
            columns = columns[:-1]

            configparser = ConfigParser()
            configparser.read(self.config_file)

            try:
                configparser.add_section(self.module['name'])
            except DuplicateSectionError:
                pass

            configparser.set(self.module['name'], 'repeat', True)
            configparser.set(self.module['name'], 'artwork', int(artwork))
            configparser.set(self.module['name'], 'scan', int(scan))
            configparser.set(self.module['name'], 'mode', view_mode)
            configparser.set(self.module['name'], 'folder', folder)
            configparser.set(self.module['name'], 'columns', columns)

            if isfile(self.config_file):
                force_reload = False
            else:
                force_reload = True

            configparser.write(open(self.config_file, 'w'))
            self.view.reload_config(self.get_configuration(), force_reload)

    def configuration(self, args):
        (name, widgets) = args
        if name == self.module['name']:
            # Load the glade and put the vertical box in the module's
            # configuration one
            config = self.get_configuration()

            self.conf_widgets = glade_XML(join(getcwd(), 'modules',
                                          'explorer', 'configuration.glade'),
                                          'vbox1', domain='bluemindo')

            hbox = widgets.get_widget('hbox1')

            try:
                kids = hbox.get_children()
                hbox.remove(kids[2])
            except:
                pass

            hbox.add(self.conf_widgets.get_widget('vbox1'))

            columns = config['columns'].split(',')
            for column in columns:
                self.conf_widgets.get_widget('check-column-' +
                                             column).set_active(True)

            views = [(_('Lightweight'), 'lightweight'),
                     (_('Basic'), 'basic'),
                     (_('Normal'), 'normal'),
                     (_('Full'), 'full'),
                     (_('Albums'), 'albums'),
                     (_('Playlists'), 'playlists'),
                     (_('Webradios'), 'webradios')]

            combo = self.conf_widgets.get_widget('combobox1')
            lst = ListStore(str, str)
            combo.set_model(lst)
            for view in views:
                it = lst.append((view[0], view[1]))
                if view[1] == config['mode']:
                    combo.set_active_iter(it)

            fcbutton = self.conf_widgets.get_widget('filechooserbutton1')
            fcbutton.set_current_folder(config['folder'])

            check_scan = self.conf_widgets.get_widget('check-scan')
            if config['scan']:
                check_scan.set_active(True)

            check_artwork = self.conf_widgets.get_widget('check-artwork')
            if config['artwork']:
                check_artwork.set_active(True)