# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to LG VX9200"""

# groups     - same as VX-8700
# phonebook  - LG Phonebook v1.0 Extended (same as VX-11K)
# schedule   - same as VX-8550
# memos      - same as VX-8550
# sms        - same as VX-9100
# index file - same as VX-9700
from p_lgvx11000 import *

# SMS index files
inbox_index     = "dload/inbox.dat"
outbox_index    = "dload/outbox.dat"
drafts_index    = "dload/drafts.dat"

class call(BaseProtogenClass):
    __fields=['GPStime', 'unk0', 'duration', 'number', 'name', 'numberlength', 'status', 'pbnumbertype', 'unk1', 'pbentrynum', 'number_location']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(call,self).__init__(**dict)
        if self.__class__ is call:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(call,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(call,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_GPStime.writetobuffer(buf)
        self.__field_unk0.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self.__field_numberlength.writetobuffer(buf)
        self.__field_status.writetobuffer(buf)
        self.__field_pbnumbertype.writetobuffer(buf)
        self.__field_unk1.writetobuffer(buf)
        self.__field_pbentrynum.writetobuffer(buf)
        self.__field_number_location.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_GPStime=GPSDATE(**{'sizeinbytes': 4})
        self.__field_GPStime.readfrombuffer(buf)
        self.__field_unk0=UINT(**{'sizeinbytes': 4})
        self.__field_unk0.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self.__field_number=USTRING(**{'sizeinbytes': 49, 'raiseonunterminatedread': False})
        self.__field_number.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 36, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})
        self.__field_name.readfrombuffer(buf)
        self.__field_numberlength=UINT(**{'sizeinbytes': 1})
        self.__field_numberlength.readfrombuffer(buf)
        self.__field_status=UINT(**{'sizeinbytes': 1})
        self.__field_status.readfrombuffer(buf)
        self.__field_pbnumbertype=UINT(**{'sizeinbytes': 1})
        self.__field_pbnumbertype.readfrombuffer(buf)
        self.__field_unk1=UINT(**{'sizeinbytes': 4})
        self.__field_unk1.readfrombuffer(buf)
        self.__field_pbentrynum=UINT(**{'sizeinbytes': 2})
        self.__field_pbentrynum.readfrombuffer(buf)
        self.__field_number_location=DATA(**{'sizeinbytes': 75})
        self.__field_number_location.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_GPStime(self):
        return self.__field_GPStime.getvalue()

    def __setfield_GPStime(self, value):
        if isinstance(value,GPSDATE):
            self.__field_GPStime=value
        else:
            self.__field_GPStime=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_GPStime(self): del self.__field_GPStime

    GPStime=property(__getfield_GPStime, __setfield_GPStime, __delfield_GPStime, None)

    def __getfield_unk0(self):
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,USTRING):
            self.__field_number=value
        else:
            self.__field_number=USTRING(value,**{'sizeinbytes': 49, 'raiseonunterminatedread': False})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 36, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_numberlength(self):
        return self.__field_numberlength.getvalue()

    def __setfield_numberlength(self, value):
        if isinstance(value,UINT):
            self.__field_numberlength=value
        else:
            self.__field_numberlength=UINT(value,**{'sizeinbytes': 1})

    def __delfield_numberlength(self): del self.__field_numberlength

    numberlength=property(__getfield_numberlength, __setfield_numberlength, __delfield_numberlength, None)

    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def __getfield_pbnumbertype(self):
        return self.__field_pbnumbertype.getvalue()

    def __setfield_pbnumbertype(self, value):
        if isinstance(value,UINT):
            self.__field_pbnumbertype=value
        else:
            self.__field_pbnumbertype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_pbnumbertype(self): del self.__field_pbnumbertype

    pbnumbertype=property(__getfield_pbnumbertype, __setfield_pbnumbertype, __delfield_pbnumbertype, None)

    def __getfield_unk1(self):
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UINT):
            self.__field_unk1=value
        else:
            self.__field_unk1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_pbentrynum(self):
        return self.__field_pbentrynum.getvalue()

    def __setfield_pbentrynum(self, value):
        if isinstance(value,UINT):
            self.__field_pbentrynum=value
        else:
            self.__field_pbentrynum=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pbentrynum(self): del self.__field_pbentrynum

    pbentrynum=property(__getfield_pbentrynum, __setfield_pbentrynum, __delfield_pbentrynum, None)

    def __getfield_number_location(self):
        return self.__field_number_location.getvalue()

    def __setfield_number_location(self, value):
        if isinstance(value,DATA):
            self.__field_number_location=value
        else:
            self.__field_number_location=DATA(value,**{'sizeinbytes': 75})

    def __delfield_number_location(self): del self.__field_number_location

    number_location=property(__getfield_number_location, __setfield_number_location, __delfield_number_location, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('GPStime', self.__field_GPStime, None)
        yield ('unk0', self.__field_unk0, None)
        yield ('duration', self.__field_duration, None)
        yield ('number', self.__field_number, None)
        yield ('name', self.__field_name, None)
        yield ('numberlength', self.__field_numberlength, None)
        yield ('status', self.__field_status, None)
        yield ('pbnumbertype', self.__field_pbnumbertype, None)
        yield ('unk1', self.__field_unk1, None)
        yield ('pbentrynum', self.__field_pbentrynum, None)
        yield ('number_location', self.__field_number_location, None)




class callhistory(BaseProtogenClass):
    __fields=['unk0', 'numcalls', 'unk1', 'calls']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callhistory,self).__init__(**dict)
        if self.__class__ is callhistory:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callhistory,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callhistory,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unk0.writetobuffer(buf)
        self.__field_numcalls.writetobuffer(buf)
        self.__field_unk1.writetobuffer(buf)
        try: self.__field_calls
        except:
            self.__field_calls=LIST(**{'elementclass': call, 'length': self.numcalls})
        self.__field_calls.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unk0=UINT(**{'sizeinbytes': 4,  'default': 0x00020000 })
        self.__field_unk0.readfrombuffer(buf)
        self.__field_numcalls=UINT(**{'sizeinbytes': 4})
        self.__field_numcalls.readfrombuffer(buf)
        self.__field_unk1=UINT(**{'sizeinbytes': 1})
        self.__field_unk1.readfrombuffer(buf)
        self.__field_calls=LIST(**{'elementclass': call, 'length': self.numcalls})
        self.__field_calls.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unk0(self):
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 4,  'default': 0x00020000 })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_numcalls(self):
        return self.__field_numcalls.getvalue()

    def __setfield_numcalls(self, value):
        if isinstance(value,UINT):
            self.__field_numcalls=value
        else:
            self.__field_numcalls=UINT(value,**{'sizeinbytes': 4})

    def __delfield_numcalls(self): del self.__field_numcalls

    numcalls=property(__getfield_numcalls, __setfield_numcalls, __delfield_numcalls, None)

    def __getfield_unk1(self):
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UINT):
            self.__field_unk1=value
        else:
            self.__field_unk1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_calls(self):
        try: self.__field_calls
        except:
            self.__field_calls=LIST(**{'elementclass': call, 'length': self.numcalls})
        return self.__field_calls.getvalue()

    def __setfield_calls(self, value):
        if isinstance(value,LIST):
            self.__field_calls=value
        else:
            self.__field_calls=LIST(value,**{'elementclass': call, 'length': self.numcalls})

    def __delfield_calls(self): del self.__field_calls

    calls=property(__getfield_calls, __setfield_calls, __delfield_calls, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unk0', self.__field_unk0, None)
        yield ('numcalls', self.__field_numcalls, None)
        yield ('unk1', self.__field_unk1, None)
        yield ('calls', self.__field_calls, None)




class indexentry(BaseProtogenClass):
    __fields=['filename', 'size', 'date', 'type', 'unk0']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(indexentry,self).__init__(**dict)
        if self.__class__ is indexentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(indexentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(indexentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_filename.writetobuffer(buf)
        self.__field_size.writetobuffer(buf)
        try: self.__field_date
        except:
            self.__field_date=UINT(**{'sizeinbytes': 4, 'default': 0})
        self.__field_date.writetobuffer(buf)
        self.__field_type.writetobuffer(buf)
        try: self.__field_unk0
        except:
            self.__field_unk0=UINT(**{'sizeinbytes': 4, 'default': 0})
        self.__field_unk0.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_filename=USTRING(**{'sizeinbytes': 256, 'encoding': PHONE_ENCODING,                 'raiseonunterminatedread': False,                 'raiseontruncate': False })
        self.__field_filename.readfrombuffer(buf)
        self.__field_size=UINT(**{'sizeinbytes': 4})
        self.__field_size.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4, 'default': 0})
        self.__field_date.readfrombuffer(buf)
        self.__field_type=UINT(**{'sizeinbytes': 4})
        self.__field_type.readfrombuffer(buf)
        self.__field_unk0=UINT(**{'sizeinbytes': 4, 'default': 0})
        self.__field_unk0.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_filename(self):
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'sizeinbytes': 256, 'encoding': PHONE_ENCODING,                 'raiseonunterminatedread': False,                 'raiseontruncate': False })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, "full pathname")

    def __getfield_size(self):
        return self.__field_size.getvalue()

    def __setfield_size(self, value):
        if isinstance(value,UINT):
            self.__field_size=value
        else:
            self.__field_size=UINT(value,**{'sizeinbytes': 4})

    def __delfield_size(self): del self.__field_size

    size=property(__getfield_size, __setfield_size, __delfield_size, None)

    def __getfield_date(self):
        try: self.__field_date
        except:
            self.__field_date=UINT(**{'sizeinbytes': 4, 'default': 0})
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4, 'default': 0})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,**{'sizeinbytes': 4})

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=UINT(**{'sizeinbytes': 4, 'default': 0})
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 4, 'default': 0})

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('filename', self.__field_filename, "full pathname")
        yield ('size', self.__field_size, None)
        yield ('date', self.__field_date, None)
        yield ('type', self.__field_type, None)
        yield ('unk0', self.__field_unk0, None)




class indexfile(BaseProtogenClass):
    "Used for tracking wallpaper and ringtones"
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(indexfile,self).__init__(**dict)
        if self.__class__ is indexfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(indexfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(indexfile,kwargs)
        if len(args):
            dict2={'elementclass': indexentry, 'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'elementclass': indexentry, 'createdefault': True})
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{'elementclass': indexentry, 'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'elementclass': indexentry, 'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{'elementclass': indexentry, 'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class pnfileentry(BaseProtogenClass):
    __fields=['entry_tag', 'pad00', 'mod_date', 'unk0', 'pn_id', 'pe_id', 'unknown00', 'pn_order', 'phone_number', 'unknown01', 'ntype', 'unknown02', 'exit_tag', 'blanks']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pnfileentry,self).__init__(**dict)
        if self.__class__ is pnfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pnfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pnfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag != '\xff\xff\xff\xff':
            try: self.__field_pad00
            except:
                self.__field_pad00=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_pad00.writetobuffer(buf)
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_unk0
            except:
                self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
            self.__field_unk0.writetobuffer(buf)
            self.__field_pn_id.writetobuffer(buf)
            self.__field_pe_id.writetobuffer(buf)
            try: self.__field_unknown00
            except:
                self.__field_unknown00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown00.writetobuffer(buf)
            self.__field_pn_order.writetobuffer(buf)
            self.__field_phone_number.writetobuffer(buf)
            try: self.__field_unknown01
            except:
                self.__field_unknown01=UINT(**{'sizeinbytes': 1,  'default': 1 })
            self.__field_unknown01.writetobuffer(buf)
            self.__field_ntype.writetobuffer(buf)
            try: self.__field_unknown02
            except:
                self.__field_unknown02=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown02.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_blanks
            except:
                self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
            self.__field_blanks.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag != '\xff\xff\xff\xff':
            self.__field_pad00=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_pad00.readfrombuffer(buf)
            self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
            self.__field_unk0.readfrombuffer(buf)
            self.__field_pn_id=UINT(**{'sizeinbytes': 2})
            self.__field_pn_id.readfrombuffer(buf)
            self.__field_pe_id=UINT(**{'sizeinbytes': 2})
            self.__field_pe_id.readfrombuffer(buf)
            self.__field_unknown00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown00.readfrombuffer(buf)
            self.__field_pn_order=UINT(**{'sizeinbytes': 1})
            self.__field_pn_order.readfrombuffer(buf)
            self.__field_phone_number=LGHEXPN(**{'sizeinbytes': 25})
            self.__field_phone_number.readfrombuffer(buf)
            self.__field_unknown01=UINT(**{'sizeinbytes': 1,  'default': 1 })
            self.__field_unknown01.readfrombuffer(buf)
            self.__field_ntype=UINT(**{'sizeinbytes': 1})
            self.__field_ntype.readfrombuffer(buf)
            self.__field_unknown02=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unknown02.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
            self.__field_blanks.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_pad00(self):
        try: self.__field_pad00
        except:
            self.__field_pad00=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_pad00.getvalue()

    def __setfield_pad00(self, value):
        if isinstance(value,UINT):
            self.__field_pad00=value
        else:
            self.__field_pad00=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_pad00(self): del self.__field_pad00

    pad00=property(__getfield_pad00, __setfield_pad00, __delfield_pad00, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,STRING):
            self.__field_unk0=value
        else:
            self.__field_unk0=STRING(value,**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_pn_id(self):
        return self.__field_pn_id.getvalue()

    def __setfield_pn_id(self, value):
        if isinstance(value,UINT):
            self.__field_pn_id=value
        else:
            self.__field_pn_id=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pn_id(self): del self.__field_pn_id

    pn_id=property(__getfield_pn_id, __setfield_pn_id, __delfield_pn_id, None)

    def __getfield_pe_id(self):
        return self.__field_pe_id.getvalue()

    def __setfield_pe_id(self, value):
        if isinstance(value,UINT):
            self.__field_pe_id=value
        else:
            self.__field_pe_id=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pe_id(self): del self.__field_pe_id

    pe_id=property(__getfield_pe_id, __setfield_pe_id, __delfield_pe_id, None)

    def __getfield_unknown00(self):
        try: self.__field_unknown00
        except:
            self.__field_unknown00=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unknown00.getvalue()

    def __setfield_unknown00(self, value):
        if isinstance(value,UINT):
            self.__field_unknown00=value
        else:
            self.__field_unknown00=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unknown00(self): del self.__field_unknown00

    unknown00=property(__getfield_unknown00, __setfield_unknown00, __delfield_unknown00, None)

    def __getfield_pn_order(self):
        return self.__field_pn_order.getvalue()

    def __setfield_pn_order(self, value):
        if isinstance(value,UINT):
            self.__field_pn_order=value
        else:
            self.__field_pn_order=UINT(value,**{'sizeinbytes': 1})

    def __delfield_pn_order(self): del self.__field_pn_order

    pn_order=property(__getfield_pn_order, __setfield_pn_order, __delfield_pn_order, "0-based order of this phone within this contact")

    def __getfield_phone_number(self):
        return self.__field_phone_number.getvalue()

    def __setfield_phone_number(self, value):
        if isinstance(value,LGHEXPN):
            self.__field_phone_number=value
        else:
            self.__field_phone_number=LGHEXPN(value,**{'sizeinbytes': 25})

    def __delfield_phone_number(self): del self.__field_phone_number

    phone_number=property(__getfield_phone_number, __setfield_phone_number, __delfield_phone_number, None)

    def __getfield_unknown01(self):
        try: self.__field_unknown01
        except:
            self.__field_unknown01=UINT(**{'sizeinbytes': 1,  'default': 1 })
        return self.__field_unknown01.getvalue()

    def __setfield_unknown01(self, value):
        if isinstance(value,UINT):
            self.__field_unknown01=value
        else:
            self.__field_unknown01=UINT(value,**{'sizeinbytes': 1,  'default': 1 })

    def __delfield_unknown01(self): del self.__field_unknown01

    unknown01=property(__getfield_unknown01, __setfield_unknown01, __delfield_unknown01, None)

    def __getfield_ntype(self):
        return self.__field_ntype.getvalue()

    def __setfield_ntype(self, value):
        if isinstance(value,UINT):
            self.__field_ntype=value
        else:
            self.__field_ntype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ntype(self): del self.__field_ntype

    ntype=property(__getfield_ntype, __setfield_ntype, __delfield_ntype, None)

    def __getfield_unknown02(self):
        try: self.__field_unknown02
        except:
            self.__field_unknown02=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unknown02.getvalue()

    def __setfield_unknown02(self, value):
        if isinstance(value,UINT):
            self.__field_unknown02=value
        else:
            self.__field_unknown02=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unknown02(self): del self.__field_unknown02

    unknown02=property(__getfield_unknown02, __setfield_unknown02, __delfield_unknown02, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,DATA):
            self.__field_blanks=value
        else:
            self.__field_blanks=DATA(value,**{'sizeinbytes': 60,  'default': '\xFF'*60 })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag != '\xff\xff\xff\xff':
            yield ('pad00', self.__field_pad00, None)
            yield ('mod_date', self.__field_mod_date, None)
            yield ('unk0', self.__field_unk0, None)
            yield ('pn_id', self.__field_pn_id, None)
            yield ('pe_id', self.__field_pe_id, None)
            yield ('unknown00', self.__field_unknown00, None)
            yield ('pn_order', self.__field_pn_order, "0-based order of this phone within this contact")
            yield ('phone_number', self.__field_phone_number, None)
            yield ('unknown01', self.__field_unknown01, None)
            yield ('ntype', self.__field_ntype, None)
            yield ('unknown02', self.__field_unknown02, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('blanks', self.__field_blanks, None)

    def valid(self):
         return self.phone_number != None
    def malformed(self):
         # malformed (yet valid) entries have been seen on several phones including the VX-8550 and VX-10000
         return self.entry_tag != PB_NUMBER_SOR




class pnfile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pnfile,self).__init__(**dict)
        if self.__class__ is pnfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pnfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pnfile,kwargs)
        if len(args):
            dict2={ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class pbgroup(BaseProtogenClass):
    __fields=['name', 'groupid', 'user_added', 'unk0']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbgroup,self).__init__(**dict)
        if self.__class__ is pbgroup:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbgroup,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbgroup,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 34, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        self.__field_name.writetobuffer(buf)
        try: self.__field_groupid
        except:
            self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_groupid.writetobuffer(buf)
        try: self.__field_user_added
        except:
            self.__field_user_added=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_user_added.writetobuffer(buf)
        try: self.__field_unk0
        except:
            self.__field_unk0=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_unk0.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=USTRING(**{'sizeinbytes': 34, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        self.__field_name.readfrombuffer(buf)
        self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_groupid.readfrombuffer(buf)
        self.__field_user_added=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_user_added.readfrombuffer(buf)
        self.__field_unk0=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_unk0.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 34, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 34, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_groupid(self):
        try: self.__field_groupid
        except:
            self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_groupid.getvalue()

    def __setfield_groupid(self, value):
        if isinstance(value,UINT):
            self.__field_groupid=value
        else:
            self.__field_groupid=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_groupid(self): del self.__field_groupid

    groupid=property(__getfield_groupid, __setfield_groupid, __delfield_groupid, None)

    def __getfield_user_added(self):
        try: self.__field_user_added
        except:
            self.__field_user_added=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_user_added.getvalue()

    def __setfield_user_added(self, value):
        if isinstance(value,UINT):
            self.__field_user_added=value
        else:
            self.__field_user_added=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_user_added(self): del self.__field_user_added

    user_added=property(__getfield_user_added, __setfield_user_added, __delfield_user_added, "=1 when was added by user -- not really")

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('groupid', self.__field_groupid, None)
        yield ('user_added', self.__field_user_added, "=1 when was added by user -- not really")
        yield ('unk0', self.__field_unk0, None)




class pbgroups(BaseProtogenClass):
    "Phonebook groups"
    __fields=['groups']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbgroups,self).__init__(**dict)
        if self.__class__ is pbgroups:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbgroups,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbgroups,kwargs)
        if len(args):
            dict2={'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_groups=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_groups
        except:
            self.__field_groups=LIST(**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        self.__field_groups.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_groups=LIST(**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        self.__field_groups.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_groups(self):
        try: self.__field_groups
        except:
            self.__field_groups=LIST(**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        return self.__field_groups.getvalue()

    def __setfield_groups(self, value):
        if isinstance(value,LIST):
            self.__field_groups=value
        else:
            self.__field_groups=LIST(value,**{'elementclass': pbgroup,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})

    def __delfield_groups(self): del self.__field_groups

    groups=property(__getfield_groups, __setfield_groups, __delfield_groups, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('groups', self.__field_groups, None)




