open Printf
open Html5.M

let href uri =
  a_href (uri_of_string uri)

let a_link url text =
  a ~a:[a_href (uri_of_string url)] [pcdata text]

let page ~title ~subtitle ~headers ~body ~footer =
  let headers =
    (meta
      ~a:[a_charset "utf-8"]
      ())
    ::
    (link ~rel:[`Stylesheet] ~href:"media/revamp.css" ())
    ::
    (link ~rel:[`Stylesheet] ~href:"media/styles.css" ())
    ::
    headers in
  html ~a:[a_xmlns `W3_org_1999_xhtml]
    (head
       (Html5.M.title (pcdata title))
       headers
    )
    (Html5.M.body ~a:[a_class ["debian"]] [
      h1 ~a:[a_id "title"] [pcdata "Transition tracker"];
      h2 ~a:[a_id "subtitle"] subtitle;
      div ~a:[a_id "body"] body;
      div ~a:[a_id "footer"] footer
    ])

open Template

let () =
  Benl_templates.register_template {
    name = "Simple";
    page;
    intro = [];
    pts = (fun ~src -> sprintf "https://tracker.debian.org/%s" src);
    changelog = (fun ~letter ~src ~ver -> sprintf "https://packages.debian.org/changelog:%s" src);
    buildd = (fun ~src ~ver -> sprintf "https://buildd.debian.org/status/package.php?p=%s" src);
    buildds = (fun ~srcs ->
      let srcs = String.concat "," srcs in
      Some (sprintf "https://buildd.debian.org/status/package.php?p=%s&compact=compact" srcs));
    bugs = (fun ~src -> sprintf "https://bugs.debian.org/%s" src);
    critical_bugs = (fun ~srcs ->
      let srcs = String.concat ";src=" srcs in
      Some (sprintf "https://bugs.debian.org/cgi-bin/pkgreport.cgi?sev-inc=serious;sev-inc=grave;sev-inc=critical;src=%s" srcs));
    msg_id = (fun ~mid -> sprintf "https://lists.debian.org/%s" mid);
  }
