/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import java.util.ArrayList;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGICCColor;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class CSSOMSVGColor
implements SVGColor,
RGBColor,
SVGICCColor,
SVGNumberList {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected RedComponent redComponent;
    protected GreenComponent greenComponent;
    protected BlueComponent blueComponent;
    protected ArrayList iccColors;

    public CSSOMSVGColor(ValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.handler = modificationHandler;
    }

    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    public void setCssText(String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.iccColors = null;
        this.handler.textChanged(string);
    }

    public short getCssValueType() {
        return 3;
    }

    public short getColorType() {
        Value value = this.valueProvider.getValue();
        short s = value.getCssValueType();
        switch (s) {
            case 1: {
                short s2 = value.getPrimitiveType();
                switch (s2) {
                    case 21: {
                        if (value.getStringValue().equalsIgnoreCase("currentcolor")) {
                            return 3;
                        }
                        return 1;
                    }
                    case 25: {
                        return 1;
                    }
                }
                throw new IllegalStateException("Found unexpected PrimitiveType:" + s2);
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalStateException("Found unexpected CssValueType:" + s);
    }

    public RGBColor getRGBColor() {
        return this;
    }

    public RGBColor getRgbColor() {
        return this;
    }

    public void setRGBColor(String string) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.rgbColorChanged(string);
    }

    public SVGICCColor getICCColor() {
        return this;
    }

    public SVGICCColor getIccColor() {
        return this;
    }

    public void setRGBColorICCColor(String string, String string2) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.iccColors = null;
        this.handler.rgbColorICCColorChanged(string, string2);
    }

    public void setColor(short s, String string, String string2) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.iccColors = null;
        this.handler.colorChanged(s, string, string2);
    }

    public CSSPrimitiveValue getRed() {
        this.valueProvider.getValue().getRed();
        if (this.redComponent == null) {
            this.redComponent = new RedComponent();
        }
        return this.redComponent;
    }

    public CSSPrimitiveValue getGreen() {
        this.valueProvider.getValue().getGreen();
        if (this.greenComponent == null) {
            this.greenComponent = new GreenComponent();
        }
        return this.greenComponent;
    }

    public CSSPrimitiveValue getBlue() {
        this.valueProvider.getValue().getBlue();
        if (this.blueComponent == null) {
            this.blueComponent = new BlueComponent();
        }
        return this.blueComponent;
    }

    public String getColorProfile() {
        if (this.getColorType() != 2) {
            throw new DOMException(12, "");
        }
        Value value = this.valueProvider.getValue();
        return ((ICCColor)value.item(1)).getColorProfile();
    }

    public void setColorProfile(String string) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.colorProfileChanged(string);
    }

    public SVGNumberList getColors() {
        return this;
    }

    public int getNumberOfItems() {
        if (this.getColorType() != 2) {
            throw new DOMException(12, "");
        }
        Value value = this.valueProvider.getValue();
        return ((ICCColor)value.item(1)).getNumberOfColors();
    }

    public void clear() throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.iccColors = null;
        this.handler.colorsCleared();
    }

    public SVGNumber initialize(SVGNumber sVGNumber) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        float f = sVGNumber.getValue();
        this.iccColors = new ArrayList();
        ColorNumber colorNumber = new ColorNumber(f);
        this.iccColors.add(colorNumber);
        this.handler.colorsInitialized(f);
        return colorNumber;
    }

    public SVGNumber getItem(int n) throws DOMException {
        if (this.getColorType() != 2) {
            throw new DOMException(1, "");
        }
        int n2 = this.getNumberOfItems();
        if (n < 0 || n >= n2) {
            throw new DOMException(1, "");
        }
        if (this.iccColors == null) {
            this.iccColors = new ArrayList(n2);
            for (int i = this.iccColors.size(); i < n2; ++i) {
                this.iccColors.add(null);
            }
        }
        Value value = this.valueProvider.getValue().item(1);
        float f = ((ICCColor)value).getColor(n);
        ColorNumber colorNumber = new ColorNumber(f);
        this.iccColors.set(n, colorNumber);
        return colorNumber;
    }

    public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        int n2 = this.getNumberOfItems();
        if (n < 0 || n > n2) {
            throw new DOMException(1, "");
        }
        if (this.iccColors == null) {
            this.iccColors = new ArrayList(n2);
            for (int i = this.iccColors.size(); i < n2; ++i) {
                this.iccColors.add(null);
            }
        }
        float f = sVGNumber.getValue();
        ColorNumber colorNumber = new ColorNumber(f);
        this.iccColors.add(n, colorNumber);
        this.handler.colorInsertedBefore(f, n);
        return colorNumber;
    }

    public SVGNumber replaceItem(SVGNumber sVGNumber, int n) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        int n2 = this.getNumberOfItems();
        if (n < 0 || n >= n2) {
            throw new DOMException(1, "");
        }
        if (this.iccColors == null) {
            this.iccColors = new ArrayList(n2);
            for (int i = this.iccColors.size(); i < n2; ++i) {
                this.iccColors.add(null);
            }
        }
        float f = sVGNumber.getValue();
        ColorNumber colorNumber = new ColorNumber(f);
        this.iccColors.set(n, colorNumber);
        this.handler.colorReplaced(f, n);
        return colorNumber;
    }

    public SVGNumber removeItem(int n) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        int n2 = this.getNumberOfItems();
        if (n < 0 || n >= n2) {
            throw new DOMException(1, "");
        }
        ColorNumber colorNumber = null;
        if (this.iccColors != null) {
            colorNumber = (ColorNumber)this.iccColors.get(n);
        }
        if (colorNumber == null) {
            Value value = this.valueProvider.getValue().item(1);
            colorNumber = new ColorNumber(((ICCColor)value).getColor(n));
        }
        this.handler.colorRemoved(n);
        return colorNumber;
    }

    public SVGNumber appendItem(SVGNumber sVGNumber) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        if (this.iccColors == null) {
            int n = this.getNumberOfItems();
            this.iccColors = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.iccColors.add(null);
            }
        }
        float f = sVGNumber.getValue();
        ColorNumber colorNumber = new ColorNumber(f);
        this.iccColors.add(colorNumber);
        this.handler.colorAppend(f);
        return colorNumber;
    }

    protected class BlueComponent
    extends FloatComponent {
        protected BlueComponent() {
        }

        protected Value getValue() {
            return CSSOMSVGColor.this.valueProvider.getValue().getBlue();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMSVGColor.this.handler.blueTextChanged(string);
        }

        public void setFloatValue(short s, float f) throws DOMException {
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMSVGColor.this.handler.blueFloatValueChanged(s, f);
        }
    }

    protected class GreenComponent
    extends FloatComponent {
        protected GreenComponent() {
        }

        protected Value getValue() {
            return CSSOMSVGColor.this.valueProvider.getValue().getGreen();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMSVGColor.this.handler.greenTextChanged(string);
        }

        public void setFloatValue(short s, float f) throws DOMException {
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMSVGColor.this.handler.greenFloatValueChanged(s, f);
        }
    }

    protected class RedComponent
    extends FloatComponent {
        protected RedComponent() {
        }

        protected Value getValue() {
            return CSSOMSVGColor.this.valueProvider.getValue().getRed();
        }

        public void setCssText(String string) throws DOMException {
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMSVGColor.this.handler.redTextChanged(string);
        }

        public void setFloatValue(short s, float f) throws DOMException {
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMSVGColor.this.handler.redFloatValueChanged(s, f);
        }
    }

    protected abstract class FloatComponent
    extends AbstractComponent {
        protected FloatComponent() {
        }

        public void setStringValue(short s, String string) throws DOMException {
            throw new DOMException(15, "");
        }
    }

    protected abstract class AbstractComponent
    implements CSSPrimitiveValue {
        protected AbstractComponent() {
        }

        protected abstract Value getValue();

        public String getCssText() {
            return this.getValue().getCssText();
        }

        public short getCssValueType() {
            return this.getValue().getCssValueType();
        }

        public short getPrimitiveType() {
            return this.getValue().getPrimitiveType();
        }

        public float getFloatValue(short s) throws DOMException {
            return CSSOMValue.convertFloatValue(s, this.getValue());
        }

        public String getStringValue() throws DOMException {
            return CSSOMSVGColor.this.valueProvider.getValue().getStringValue();
        }

        public Counter getCounterValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public Rect getRectValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public RGBColor getRGBColorValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public int getLength() {
            throw new DOMException(15, "");
        }

        public CSSValue item(int n) {
            throw new DOMException(15, "");
        }
    }

    public abstract class AbstractModificationHandler
    implements ModificationHandler {
        protected abstract Value getValue();

        public void redTextChanged(String string) throws DOMException {
            StringBuffer stringBuffer = new StringBuffer(40);
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(string);
                    stringBuffer.append(',');
                    stringBuffer.append(value.getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.getBlue().getCssText());
                    stringBuffer.append(')');
                    break;
                }
                case 2: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(string);
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getBlue().getCssText());
                    stringBuffer.append(')');
                    stringBuffer.append(value.item(1).getCssText());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(stringBuffer.toString());
        }

        public void redFloatValueChanged(short s, float f) throws DOMException {
            StringBuffer stringBuffer = new StringBuffer(40);
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(FloatValue.getCssText(s, f));
                    stringBuffer.append(',');
                    stringBuffer.append(value.getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.getBlue().getCssText());
                    stringBuffer.append(')');
                    break;
                }
                case 2: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(FloatValue.getCssText(s, f));
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getBlue().getCssText());
                    stringBuffer.append(')');
                    stringBuffer.append(value.item(1).getCssText());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(stringBuffer.toString());
        }

        public void greenTextChanged(String string) throws DOMException {
            StringBuffer stringBuffer = new StringBuffer(40);
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(string);
                    stringBuffer.append(',');
                    stringBuffer.append(value.getBlue().getCssText());
                    stringBuffer.append(')');
                    break;
                }
                case 2: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.item(0).getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(string);
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getBlue().getCssText());
                    stringBuffer.append(')');
                    stringBuffer.append(value.item(1).getCssText());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(stringBuffer.toString());
        }

        public void greenFloatValueChanged(short s, float f) throws DOMException {
            StringBuffer stringBuffer = new StringBuffer(40);
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(FloatValue.getCssText(s, f));
                    stringBuffer.append(',');
                    stringBuffer.append(value.getBlue().getCssText());
                    stringBuffer.append(')');
                    break;
                }
                case 2: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.item(0).getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(FloatValue.getCssText(s, f));
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getBlue().getCssText());
                    stringBuffer.append(')');
                    stringBuffer.append(value.item(1).getCssText());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(stringBuffer.toString());
        }

        public void blueTextChanged(String string) throws DOMException {
            StringBuffer stringBuffer = new StringBuffer(40);
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(string);
                    stringBuffer.append(')');
                    break;
                }
                case 2: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.item(0).getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(string);
                    stringBuffer.append(')');
                    stringBuffer.append(value.item(1).getCssText());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(stringBuffer.toString());
        }

        public void blueFloatValueChanged(short s, float f) throws DOMException {
            StringBuffer stringBuffer = new StringBuffer(40);
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(FloatValue.getCssText(s, f));
                    stringBuffer.append(')');
                    break;
                }
                case 2: {
                    stringBuffer.append("rgb(");
                    stringBuffer.append(value.item(0).getRed().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(value.item(0).getGreen().getCssText());
                    stringBuffer.append(',');
                    stringBuffer.append(FloatValue.getCssText(s, f));
                    stringBuffer.append(')');
                    stringBuffer.append(value.item(1).getCssText());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(stringBuffer.toString());
        }

        public void rgbColorChanged(String string) throws DOMException {
            switch (CSSOMSVGColor.this.getColorType()) {
                case 1: {
                    break;
                }
                case 2: {
                    string = string + this.getValue().item(1).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        public void rgbColorICCColorChanged(String string, String string2) throws DOMException {
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    this.textChanged(string + ' ' + string2);
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorChanged(short s, String string, String string2) throws DOMException {
            switch (s) {
                case 3: {
                    this.textChanged("currentcolor");
                    break;
                }
                case 1: {
                    this.textChanged(string);
                    break;
                }
                case 2: {
                    this.textChanged(string + ' ' + string2);
                    break;
                }
                default: {
                    throw new DOMException(9, "");
                }
            }
        }

        public void colorProfileChanged(String string) throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    stringBuffer.append(string);
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    for (int i = 0; i < iCCColor.getLength(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorsCleared() throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorsInitialized(float f) throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorInsertedBefore(float f, int n) throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    for (n2 = n; n2 < iCCColor.getLength(); ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorReplaced(float f, int n) throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    for (n2 = n + 1; n2 < iCCColor.getLength(); ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorRemoved(int n) throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    for (n2 = n + 1; n2 < iCCColor.getLength(); ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        public void colorAppend(float f) throws DOMException {
            Value value = this.getValue();
            switch (CSSOMSVGColor.this.getColorType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(value.item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)value.item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (int i = 0; i < iCCColor.getLength(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void redTextChanged(String var1) throws DOMException;

        public void redFloatValueChanged(short var1, float var2) throws DOMException;

        public void greenTextChanged(String var1) throws DOMException;

        public void greenFloatValueChanged(short var1, float var2) throws DOMException;

        public void blueTextChanged(String var1) throws DOMException;

        public void blueFloatValueChanged(short var1, float var2) throws DOMException;

        public void rgbColorChanged(String var1) throws DOMException;

        public void rgbColorICCColorChanged(String var1, String var2) throws DOMException;

        public void colorChanged(short var1, String var2, String var3) throws DOMException;

        public void colorProfileChanged(String var1) throws DOMException;

        public void colorsCleared() throws DOMException;

        public void colorsInitialized(float var1) throws DOMException;

        public void colorInsertedBefore(float var1, int var2) throws DOMException;

        public void colorReplaced(float var1, int var2) throws DOMException;

        public void colorRemoved(int var1) throws DOMException;

        public void colorAppend(float var1) throws DOMException;
    }

    public static interface ValueProvider {
        public Value getValue();
    }

    protected class ColorNumber
    implements SVGNumber {
        protected float value;

        public ColorNumber(float f) {
            this.value = f;
        }

        public float getValue() {
            if (CSSOMSVGColor.this.iccColors == null) {
                return this.value;
            }
            int n = CSSOMSVGColor.this.iccColors.indexOf(this);
            if (n == -1) {
                return this.value;
            }
            Value value = CSSOMSVGColor.this.valueProvider.getValue().item(1);
            return ((ICCColor)value).getColor(n);
        }

        public void setValue(float f) {
            this.value = f;
            if (CSSOMSVGColor.this.iccColors == null) {
                return;
            }
            int n = CSSOMSVGColor.this.iccColors.indexOf(this);
            if (n == -1) {
                return;
            }
            if (CSSOMSVGColor.this.handler == null) {
                throw new DOMException(7, "");
            }
            CSSOMSVGColor.this.handler.colorReplaced(f, n);
        }
    }
}

