# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import balazar3.globdef

class Room(object):
  def __init__(self, name, blocs, nb_monster, monster_places, monster_classes, traps = ()):
    self.name  = name
    self.blocs = [
      [blocs[42], blocs[35], blocs[28], blocs[21], blocs[14], blocs[ 7], blocs[ 0]],
      [blocs[43], blocs[36], blocs[29], blocs[22], blocs[15], blocs[ 8], blocs[ 1]],
      [blocs[44], blocs[37], blocs[30], blocs[23], blocs[16], blocs[ 9], blocs[ 2]],
      [blocs[45], blocs[38], blocs[31], blocs[24], blocs[17], blocs[10], blocs[ 3]],
      [blocs[46], blocs[39], blocs[32], blocs[25], blocs[18], blocs[11], blocs[ 4]],
      [blocs[47], blocs[40], blocs[33], blocs[26], blocs[19], blocs[12], blocs[ 5]],
      [blocs[48], blocs[41], blocs[34], blocs[27], blocs[20], blocs[13], blocs[ 6]],
      ]
    self.nb_monster      = nb_monster
    self.monster_places  = monster_places
    self.monster_classes = monster_classes
    self.traps           = traps
    
  def get_model_name   (self): return "room_%s" % self.name
  def get_shot_filename(self): return os.path.join(balazar3.globdef.APPDIR, "room_shots", "room_%s.jpeg" % self.name)
  
  def ij2xy(self, i, j):
    dy = 758.3636363636 * j / (6.8181818181 + j)
    #return int(320.0 + (i - 2.5) * (148.0 + 103.0 * (1.0 - dy / 325.0)) / 2.5), 444 - int(dy)
    return int(320.0 + (i - 2.5) * (100.4 - 0.12676923076923077 * dy)), 444 - int(dy)
    
  def xy2ij(self, x, y):
    dy = float(444 - y)
    j = (-6.8181818181 * dy ) / (dy - 758.3636363636)
    #i = (2.5 * float(x) - 800.0) / (148.0 + 103.0 * (1.0 - dy / 325.0)) + 2.5
    i = (2.5 * float(x) - 800.0) / (251.0 - dy * 0.31692307692307692) + 2.5
    return i, j
    
  def ij2zoom(self, i, j):
    return 1.25 - j / (6.8181818181 + j)
  
  def get(name):
    globs = {}
    execfile(os.path.join(balazar3.globdef.APPDIR, "rooms", "room_%s.py" % name), globs)
    return globs["room"]
  get = staticmethod(get)
  
