//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_13.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot13(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[13] = {7.208202589466973e-01,1.796131365633884e-01,1.630899655950554e+00,2.922597921220351e+00,4.615178476472022e+00,
    6.736185972285235e+00,9.324365594647540e+00,1.243461777443965e+01,1.614688493695546e+01,2.058352207215326e+01,2.594791911981656e+01,3.262986350068336e+01,
    4.162753157986593e+01};
  constexpr double aw[13] = {1.494768436328437e-01,6.367596495535342e-02,1.372778489802784e-01,6.843535893685798e-02,2.022038839755062e-02,
    3.615779955547196e-03,3.866588766540874e-04,2.381578592958704e-05,7.904546713574322e-07,1.266922283453344e-08,8.132383035028306e-11,1.458806950273524e-13,
    2.953797767717638e-17};
  constexpr double x[4992] = {  2.508282882833451e-02, -4.424877074139207e-04,  5.781441055729038e-06, -6.601030133076684e-08,  6.907825890279364e-10,
 -6.738826304772121e-12,  6.146298673460683e-14, -5.202500484468878e-16,  3.996142229164310e-18, -2.631256442088735e-20,  1.218844613690991e-22,  1.278932969233528e-25,
  9.915491252753597e-02, -1.685785490186414e-03,  2.039795858187348e-05, -2.028045984772987e-07,  1.667770689872272e-09, -1.034673234090061e-11,  2.602811621508794e-14,
  4.859619847574185e-16, -1.031693975402992e-17,  1.242462791227185e-19, -1.061768007227518e-21,  5.343334261285823e-24,  2.187254734474121e-01, -3.492107140854285e-03,
  3.678556327729524e-05, -2.728854742702846e-07,  9.782128815831663e-10,  9.065021116612211e-12, -2.140106116616787e-13,  2.152662592352818e-15, -9.062077721467604e-18,
 -9.946684502043971e-20,  2.508628331033307e-21, -2.659117915514503e-23,  3.781059793939590e-01, -5.512140210470343e-03,  4.648283248845378e-05, -1.689775070573718e-07,
 -1.662269497187675e-09,  3.286693130602533e-11, -2.049939715794225e-13, -1.146171127654103e-15,  3.678470235925891e-17, -3.071262731919985e-19, -7.609743898578617e-22,
  4.815801233034301e-23,  5.696086508068359e-01, -7.348504699604195e-03,  4.326293595145159e-05,  9.500697647127270e-08, -4.040957411674855e-09,  2.199558155839077e-11,
  2.500692003273084e-13, -4.553563449158365e-15,  7.973247964560445e-18,  5.062594428983200e-19, -5.425316604891733e-21, -2.049982053953607e-23,  7.838319968556962e-01,
 -8.630885287722406e-03,  2.599834793445602e-05,  3.776170777712797e-07, -3.516238824792215e-09, -2.275855650262529e-11,  4.792804867147650e-13,  6.423503844192011e-16,
 -6.301405977233034e-17,  1.970754074760685e-19,  7.674599496985073e-21, -6.283610625487594e-23,  1.010038246127127e+00, -9.090206947310848e-03, -5.079117987890338e-07,
  5.006509873584976e-07,  2.613934624468654e-11, -4.965361195693514e-11, -1.322876161143498e-16,  5.990341391584687e-15, -4.269681029620328e-19, -8.011273531461436e-19,
  1.223134262054007e-22,  1.141795083642925e-22,  1.236624573647729e+00, -8.617673759051475e-03, -2.725829444201959e-05,  3.775198731240600e-07,  3.645410851034174e-09,
 -2.288654272346411e-11, -4.987802468904388e-13,  6.466442835739550e-16,  6.634042502748975e-17,  2.045230414354929e-19, -8.248732769678099e-21, -6.617550438303385e-23,
  1.451683399993582e+00, -7.295184794184588e-03, -4.482366406117114e-05,  8.353214301124537e-08,  4.183021870546724e-09,  2.447938896970240e-11, -2.548090429966252e-13,
 -4.983274504633765e-15, -1.069214492355318e-17,  5.539753632213728e-19,  6.288917729292429e-21, -2.084440541605799e-23,  1.643636182002764e+00, -5.387388235885023e-03,
 -4.758222875436400e-05, -1.930957251993818e-07,  1.555441529069338e-09,  3.501136697963511e-11,  2.457710602783396e-13, -9.635137051725034e-16, -4.068877385842875e-17,
 -3.859076461776735e-19,  3.328078114693390e-22,  5.483156452622581e-23,  1.801910582005052e+00, -3.292734160949774e-03, -3.644374345806495e-05, -2.907159343115411e-07,
 -1.276998381581581e-09,  6.853587770044644e-12,  2.193132146475992e-13,  2.538312582360182e-15,  1.454613557770669e-17, -6.413751562974322e-20, -2.707234425217680e-21,
 -3.497732446357488e-23,  1.917615721838686e+00, -1.460531871555329e-03, -1.856876393472765e-05, -1.964636557826980e-07, -1.762846279019400e-09, -1.275602852779468e-11,
 -5.810557203075306e-14,  1.922764573969091e-16,  8.837097285057234e-18,  1.331685933873991e-19,  1.412802962578338e-21,  1.079740378947503e-23,  1.984172710580599e+00,
 -2.906935836707544e-04, -3.972264367316167e-06, -4.772499366063201e-08, -5.300450353551549e-10, -5.551875458135803e-12, -5.528721300107282e-14, -5.241618819346106e-16,
 -4.711554970995341e-18, -3.970642543934614e-20, -3.061932553476173e-22, -2.038263363266918e-24,  2.340061665573960e-02, -3.992265264404729e-04,  5.051431631890579e-06,
 -5.596054806574386e-08,  5.696483412331984e-10, -5.424910117507895e-12,  4.855057823207430e-14, -4.065870786793675e-16,  3.136595440471647e-18, -2.147301999397824e-20,
  1.171741347535687e-22, -2.773825438395489e-25,  9.272334474644794e-02, -1.531898294735740e-03,  1.811770162079807e-05, -1.777377986276356e-07,  1.468008657893374e-09,
 -9.592228909679550e-12,  3.562976119162679e-14,  2.196590453001180e-16, -6.550472272802353e-18,  8.660903213912610e-20, -8.197167427663890e-22,  5.417390539645782e-24,
  2.053252662375703e-01, -3.210642998541507e-03,  3.360997945207941e-05, -2.560428668302496e-07,  1.112851947973697e-09,  4.616621540344979e-12, -1.582088620401406e-13,
  1.822564468695267e-15, -1.110274787863568e-17, -2.074503937415815e-20,  1.474938462791605e-21, -2.013053176325095e-23,  3.567877268924809e-01, -5.148792432090214e-03,
  4.431632647048613e-05, -1.905910727624514e-07, -1.056085317635113e-09,  2.768464450469642e-11, -2.222893387697163e-13, -1.481171336762153e-16,  2.562696902468621e-17,
 -3.021722127600036e-19,  8.413413184232079e-22,  2.527899925722160e-23,  5.409125542750081e-01, -6.998904678076873e-03,  4.403054437560904e-05,  3.415441066588063e-08,
 -3.551141742549353e-09,  2.651138923707208e-11,  1.285761470531984e-13, -4.049723072061714e-15,  2.218600824702469e-17,  2.831667997236193e-19, -5.463814280021390e-21,
  1.586467098298275e-23,  7.497517374583120e-01, -8.405759819952979e-03,  3.017920483737498e-05,  3.183429886362385e-07, -3.856068325387501e-09, -1.125932520043174e-11,
  4.704907391112127e-13, -1.207325490409688e-15, -5.114557903252629e-17,  4.398367041124977e-19,  4.303306046988812e-21, -8.483651760121932e-23,  9.737072520981013e-01,
 -9.070307077181835e-03,  5.469792497458981e-06,  4.931811277210487e-07, -9.534987102536271e-10, -4.767195001262050e-11,  1.631332647418905e-13,  5.525847969308534e-15,
 -2.799527673025366e-17, -6.992457966314513e-19,  4.813739623177029e-21,  9.266120142459228e-23,  1.201747786119353e+00, -8.816666573814280e-03, -2.239528113573862e-05,
  4.315447261179312e-07,  3.070699265024086e-09, -3.439570814572426e-11, -4.503296400103353e-13,  2.818828797927342e-15,  6.719600441954805e-17, -1.685699657479885e-19,
 -9.980996116069425e-21, -8.150551193385360e-24,  1.421793482962985e+00, -7.648591969414964e-03, -4.340475891300315e-05,  1.539970403892115e-07,  4.600037922895260e-09,
  1.667103022867007e-11, -3.958016158992680e-13, -4.960532154798993e-15,  1.341163953826762e-17,  7.709645440276966e-19,  4.141671646909120e-21, -7.801501465453331e-23,
  1.621311308130257e+00, -5.776836338039697e-03, -4.972594122098853e-05, -1.622983387543688e-07,  2.311654550204846e-09,  4.042638344190196e-11,  1.985239794941106e-13,
 -2.479988514340363e-15, -5.367523471694938e-17, -3.150173779564349e-19,  3.437360035162268e-21,  8.555829461223230e-23,  1.788133976913351e+00, -3.598573417850999e-03,
 -4.004940853845284e-05, -3.097402741642874e-07, -1.081274748196217e-09,  1.301961819527893e-11,  2.963881936742825e-13,  2.942756277959830e-15,  9.890140754656029e-18,
 -2.061026837937148e-19, -4.453803117155726e-21, -4.346108939638509e-23,  1.911460859789617e+00, -1.619011602500219e-03, -2.110421894633022e-05, -2.267834643551085e-07,
 -2.031290662779699e-09, -1.404915921269155e-11, -4.795881992806467e-14,  5.636326550603756e-16,  1.476695951045808e-17,  1.996015766776020e-19,  1.915243478667877e-21,
  1.163027330155962e-23,  1.982942537631484e+00, -3.249156038789026e-04, -4.599760796650513e-06, -5.717142314146994e-08, -6.556342513359759e-10, -7.073333742904048e-12,
 -7.230732164028099e-14, -7.003497311780324e-16, -6.384262597703430e-18, -5.387867949793385e-20, -4.054626298527939e-22, -2.451975210689020e-24,  2.188048882352913e-02,
 -3.613540883055691e-04,  4.431205828565463e-06, -4.765452576054426e-08,  4.719358395034568e-10, -4.385650162316759e-12,  3.846141694044544e-14, -3.177071205416071e-16,
  2.444499176680157e-18, -1.708121953870257e-20,  1.015054466778809e-22, -4.047030987858979e-25,  8.687267160422214e-02, -1.395103067308301e-03,  1.611960126157810e-05,
 -1.557362557474293e-07,  1.285102431861068e-09, -8.684329662927642e-12,  3.927185684015202e-14,  5.405685919069161e-17, -3.967158459806005e-18,  5.837518241992555e-20,
 -5.981773868512155e-22,  4.576613193560722e-24,  1.930014296567286e-01, -2.953744764694892e-03,  3.064672319103596e-05, -2.376882572244541e-07,  1.171138762660543e-09,
  1.391519371276076e-12, -1.121916127225445e-13,  1.465103585426552e-15, -1.098253567529406e-17,  2.256543191612640e-20,  7.394951786645438e-22, -1.343786172121280e-23,
  3.368867810361194e-01, -4.803657250269626e-03,  4.194518220701816e-05, -2.033486289700735e-07, -5.556405346028254e-10,  2.238282835618738e-11, -2.165338820620746e-13,
  5.062224486216845e-16,  1.557097607212530e-17, -2.518458768425242e-19,  1.549424934365298e-21,  8.056411255284088e-24,  5.136227106445157e-01, -6.645945620474587e-03,
  4.411742668595032e-05, -1.829137552689277e-08, -2.998791231429280e-09,  2.832468743570481e-11,  2.636501734667438e-14, -3.217060551218466e-15,  2.867684297823369e-17,
  8.518048543163845e-20, -4.305242741462491e-21,  3.380380286805819e-23,  7.166342611653295e-01, -8.150107766454598e-03,  3.362365535499579e-05,  2.554432998517102e-07,
 -3.971965247288486e-09, -5.425139021152934e-13,  4.163473124030214e-13, -2.564718155564347e-15, -3.311032381805126e-17,  5.379705673323525e-19,  6.688514242039737e-22,
 -7.605845276532968e-23,  9.375505626063906e-01, -9.003206221234265e-03,  1.126579447493379e-05,  4.705608635808801e-07, -1.855869548562270e-09, -4.202304553501070e-11,
  3.018381150581603e-13,  4.271581894290220e-15, -4.884166844650558e-17, -4.388895531635501e-19,  7.824475886563666e-21,  4.094238815836345e-23,  1.166156698321891e+00,
 -8.974335391864192e-03, -1.694647701713910e-05,  4.746164791163050e-07,  2.282321034984461e-09, -4.402186864219830e-11, -3.427581683515857e-13,  4.795508523219003e-15,
  5.404671383014938e-17, -5.538335309128584e-19, -8.754291185706362e-21,  6.380812167133796e-23,  1.390518138036817e+00, -7.987165215469570e-03, -4.110598597010597e-05,
  2.297028731374013e-07,  4.827578688284544e-09,  5.580152525879515e-12, -5.243315764485260e-13, -4.063038174270473e-15,  4.316803604948977e-17,  8.513775216440344e-19,
 -5.015945281081816e-22, -1.297580478855704e-22,  1.597396983692987e+00, -6.181742419862323e-03, -5.142415565753253e-05, -1.186119941014011e-07,  3.161159877179422e-09,
  4.415425357838938e-11,  1.035668925389445e-13, -4.344720084828677e-15, -6.157056742796105e-17, -9.559764821962437e-20,  7.656936494383734e-21,  1.020974606986586e-22,
  1.773074966661655e+00, -3.934107883874188e-03, -4.386017143403432e-05, -3.245424831768345e-07, -7.429240907326558e-10,  2.114928496981921e-11,  3.818336664201787e-13,
  3.102354838005095e-15, -1.203106311180158e-18, -4.229419555250118e-19, -6.370498858192574e-21, -4.080394687787753e-23,  1.904629101688725e+00, -1.799305201595992e-03,
 -2.403008227510664e-05, -2.615881018586447e-07, -2.322199501199239e-09, -1.495020046757199e-11, -2.437017231321755e-14,  1.166905914193505e-15,  2.345041392742213e-17,
  2.858695914129785e-19,  2.372899034679999e-21,  8.071087533799484e-24,  1.981564667262423e+00, -3.646476500056454e-04, -5.353751858585035e-06, -6.889470006621522e-08,
 -8.161704156463724e-10, -9.069021911628849e-12, -9.509241741612004e-14, -9.390260426074402e-16, -8.642490934551036e-18, -7.232110760850905e-20, -5.173977809835988e-22,
 -2.543143422301033e-24,  2.050252284701686e-02, -3.280698471030086e-04,  3.901917395241428e-06, -4.075797521766672e-08,  3.927763874805075e-10, -3.561027485571545e-12,
  3.057369207930839e-14, -2.485736476650764e-16,  1.898297859746257e-18, -1.338355219287157e-20,  8.337085628501865e-23, -4.068182404002159e-25,  8.153881349674728e-02,
 -1.273284915511613e-03,  1.436857108879404e-05, -1.365126192266252e-07,  1.120897216102090e-09, -7.736201133127021e-12,  3.929335617772228e-14, -4.351046716521579e-17,
 -2.250600407072403e-18,  3.816824922187724e-20, -4.198288883947127e-22,  3.529371191977339e-24,  1.816591852510612e-01, -2.719660234764062e-03,  2.790737434590920e-05,
 -2.188604470764119e-07,  1.175164618331075e-09, -8.475893523374074e-13, -7.593224663059026e-14,  1.131316567158391e-15, -9.764539618233566e-18,  4.202194700141159e-20,
  2.726020921480278e-22, -8.049621536432386e-24,  3.183276496665721e-01, -4.477975445924775e-03,  3.946553057659045e-05, -2.089342559252065e-07, -1.585469451405905e-10,
  1.740447386370817e-11, -1.966586418542470e-13,  8.718657630922845e-16,  7.672698962837833e-18, -1.862904986744658e-19,  1.653443746846582e-21, -2.251163461473970e-24,
  4.877423221769910e-01, -6.294656731719995e-03,  4.362877274655261e-05, -6.173444086586953e-08, -2.432722323976806e-09,  2.798193048063824e-11, -5.062396925416643e-14,
 -2.280548743745472e-15,  2.901851004799089e-17, -5.566460096002078e-20, -2.720815515872177e-21,  3.613669379708994e-23,  6.845897002401093e-01, -7.869935046264443e-03,
  3.630899548402378e-05,  1.923216301766811e-07, -3.889251607281042e-09,  8.486274431716039e-12,  3.326141885913449e-13, -3.315344830313115e-15, -1.400402477875696e-17,
  5.050456724400695e-19, -2.113356317392388e-21, -4.861068536007675e-23,  9.017529596419377e-01, -8.891058869953084e-03,  1.670800421461118e-05,  4.345741832342422e-07,
 -2.615167979395805e-09, -3.353266256808400e-11,  3.976319517427362e-13,  2.518721536685973e-15, -5.873434676474083e-17, -1.074690103962407e-19,  8.318186826265504e-21,
 -1.748615497715922e-23,  1.130025068800419e+00, -9.086574402723851e-03, -1.106234604775290e-05,  5.036920709114673e-07,  1.331421464141490e-09, -5.046202243952890e-11,
 -1.877126981750064e-13,  6.145049859363565e-15,  2.865438568709301e-17, -8.293413348564130e-19, -4.616273653966936e-21,  1.189511693920341e-22,  1.357931097975836e+00,
 -8.303670403601171e-03, -3.788473395708296e-05,  3.071177154568517e-07,  4.805052663865939e-09, -8.184996181199070e-12, -6.142448511876988e-13, -2.206871151738511e-15,
  7.199851111503370e-17,  7.087731310325149e-19, -6.749210943253432e-21, -1.459060125494700e-22,  1.571839516217429e+00, -6.597901435159078e-03, -5.251457166567590e-05,
 -6.087908979424460e-08,  4.058091447445729e-09,  4.495654364614611e-11, -4.571430911868277e-14, -6.302238310517820e-15, -5.843455546602295e-17,  2.978834867281930e-19,
  1.186609641141052e-20,  8.100775620156219e-23,  1.756611868507347e+00, -4.300733842452859e-03, -4.781035047063354e-05, -3.325182138745420e-07, -2.213510236369043e-10,
  3.133542507124598e-11,  4.655021301619008e-13,  2.767855867030000e-15, -2.139922471704492e-17, -7.078209500785106e-19, -7.670633596469411e-21, -1.267111052980769e-23,
  1.897026597000445e+00, -2.004756595927069e-03, -2.740200641638848e-05, -3.011543417948725e-07, -2.623924783423558e-09, -1.504802911326439e-11,  2.048994533149384e-14,
  2.100828714576237e-15,  3.550969285103594e-17,  3.848396959531531e-19,  2.475935438302079e-21, -5.773120018831550e-24,  1.980014847979910e+00, -4.110212461440053e-04,
 -6.265253693689500e-06, -8.353800476151410e-08, -1.022675001735344e-09, -1.170055771237184e-11, -1.256780935948482e-13, -1.261448088952351e-15, -1.164424960909780e-17,
 -9.509363470800065e-20, -6.146444709188806e-22, -1.615251041717867e-24,  1.924972053317790e-02, -2.987092205817395e-04,  3.448300910353712e-06, -3.500569772892596e-08,
  3.283634261026888e-10, -2.904338410683339e-12,  2.439602476616631e-14, -1.949277629892514e-16,  1.472307607114720e-18, -1.039478905640180e-20,  6.641567503059587e-23,
 -3.595308319697028e-25,  7.666561135043011e-02, -1.164595497211729e-03,  1.283308442225064e-05, -1.197653628691105e-07,  9.754678468989165e-10, -6.814757328184428e-12,
  3.725192523004091e-14, -9.649982044082700e-17, -1.144078963949089e-18,  2.418827532334583e-20, -2.861311837638349e-22,  2.574879050546742e-24,  1.712108777240578e-01,
 -2.506588777359427e-03,  2.539301257648949e-05, -2.002822897237054e-07,  1.142378592889111e-09, -2.323692162334856e-12, -4.839110814218416e-14,  8.445431614934370e-16,
 -8.129480129788348e-18,  4.706679676459608e-20,  7.103571139337875e-24, -4.274760873775298e-24,  3.010312893187954e-01, -4.172298338684320e-03,  3.695377898173031e-05,
 -2.089340097124275e-07,  1.444405814596365e-10,  1.299961054366386e-11, -1.697279019571614e-13,  1.022549693791973e-15,  2.116544424332179e-18, -1.238542553022741e-19,
  1.434474482262616e-21, -6.938136754538676e-24,  4.632561850442861e-01, -5.949209499957041e-03,  4.267261750893585e-05, -9.626675630959728e-08, -1.889873802104972e-09,
  2.610309471000231e-11, -1.019124415870471e-13, -1.401998568606793e-15,  2.542530935528541e-17, -1.342744604276202e-19, -1.260305416994268e-21,  2.928408887547198e-23,
  6.537040473156159e-01, -7.571273963204970e-03,  3.825040481996312e-05,  1.318528728130726e-07, -3.647410760379826e-09,  1.532054383893620e-11,  2.361062427447450e-13,
 -3.492505406827217e-15,  2.225779418487015e-18,  3.870811001851580e-19, -3.556774909989496e-21, -1.746652229924246e-23,  8.664880128136304e-01, -8.737294098605769e-03,
  2.165144259100429e-05,  3.879049151785979e-07, -3.185781706141781e-09, -2.335692141251713e-11,  4.417062975367821e-13,  6.391519087374982e-16, -5.693156508240279e-17,
  1.956940807751027e-19,  6.531395991086239e-21, -5.966896519802449e-23,  1.093540462748492e+00, -9.150611800889727e-03, -4.924159029320761e-06,  5.167361146711015e-07,
  2.914815732015192e-10, -5.282737414324995e-11, -7.494746552315672e-15,  6.559394547276840e-15, -3.191446871635276e-18, -9.020083053058876e-19,  1.075233898679859e-21,
  1.315363393055684e-22,  1.324135423643371e+00, -8.590717379963177e-03, -3.374607849574809e-05,  3.818719391499640e-07,  4.490366579928306e-09, -2.338662543235916e-11,
 -6.403884507732168e-13,  4.410607460704734e-16,  9.117195952916822e-17,  3.183628615791081e-19, -1.245999391685661e-20, -1.032022486554045e-22,  1.544604698050560e+00,
 -7.019768770031770e-03, -5.282623848361576e-05,  1.112017036426981e-08,  4.930919864143291e-09,  4.154388710123614e-11, -2.460549689150946e-13, -7.903013859888274e-15,
 -3.846982463047029e-17,  8.251807153270136e-19,  1.392606681699527e-20,  2.404982474232527e-24,  1.738618679062471e+00, -4.699186030328533e-03, -5.179910312789001e-05,
 -3.304145120429837e-07,  5.228479163244966e-10,  4.333442424087628e-11,  5.291606420718348e-13,  1.616028644175242e-15, -5.238793454421009e-17, -1.008642822169837e-18,
 -6.859233727218951e-21,  5.767203688652215e-23,  1.888545213392318e+00, -2.239164353352792e-03, -3.127753986791609e-05, -3.454956235905436e-07, -2.914482745916374e-09,
 -1.370852465065264e-11,  9.743545402386805e-14,  3.476969951284888e-15,  5.101432727275458e-17,  4.706472239570936e-19,  1.567134053591920e-21, -3.995834532905973e-23,
  1.978263752474993e+00, -4.654501799588220e-04, -7.374174511535252e-06, -1.019495869694262e-07, -1.289941520323987e-09, -1.518611967822749e-11, -1.667643479281601e-13,
 -1.693680625933644e-15, -1.552071603670607e-17, -1.203308187531093e-19, -6.217340010621551e-22,  1.936111186702766e-24,  1.810751655321723e-02, -2.727179886881624e-04,
  3.057936762772111e-06, -3.018652882470829e-08,  2.757157192127353e-10, -2.379333868312344e-12,  1.954486603545557e-14, -1.533184871465206e-16,  1.142261403776949e-18,
 -8.036974804649719e-21,  5.191693805528146e-23, -2.991088688314821e-25,  7.220381785931167e-02, -1.067424279659624e-03,  1.148520192509602e-05, -1.052006455177207e-07,
  8.478760638314272e-10, -5.956541213555773e-12,  3.415375224647455e-14, -1.211798939343914e-16, -4.542259688635947e-19,  1.476850044073839e-20, -1.904531197541264e-22,
  1.806507998935521e-24,  1.615760229082905e-01, -2.312751403820491e-03,  2.309757614264083e-05, -1.824315938053426e-07,  1.086061008105675e-09, -3.229149052715561e-12,
 -2.813267739379336e-14,  6.112463075379158e-16, -6.467928808760869e-18,  4.437964066417165e-20, -1.241450315526519e-22, -1.891185694944820e-24,  2.849175572074864e-01,
 -3.886639281268032e-03,  3.446832679580005e-05, -2.047545245358004e-07,  3.660407020758164e-10,  9.273631594640196e-12, -1.407432790494906e-13,  1.029381393082319e-15,
 -1.387984618359683e-18, -7.309119432444167e-20,  1.096123766319428e-21, -8.003735018696247e-24,  4.401341180895295e-01, -5.612924656314887e-03,  4.135275349476586e-05,
 -1.224728889132061e-07, -1.394995507000340e-09,  2.327330743018206e-11, -1.305601605934627e-13, -6.731104564687176e-16,  1.996847527879554e-17, -1.617989169198304e-19,
 -1.893135833154502e-22,  1.926810210668850e-23,  6.240396111746808e-01, -7.259908758897136e-03,  3.949350657391867e-05,  7.622052137426367e-08, -3.292162822251421e-09,
  1.983352622884603e-11,  1.412060402587765e-13, -3.226800780143662e-15,  1.348722962017318e-17,  2.372804579058458e-19, -3.756884899243845e-21,  6.687697816407208e-24,
  8.319134748599938e-01, -8.546361399450709e-03,  2.598692465395565e-05,  3.337737664542218e-07, -3.546491208440096e-09, -1.273890277586845e-11,  4.354839226147031e-13,
 -1.025073428932199e-15, -4.587848637156401e-17,  3.980659183048899e-19,  3.481263139152053e-21, -7.426648969306485e-23,  1.056898507303521e+00, -9.165202509876914e-03,
  1.269928147598679e-06,  5.129995254828380e-07, -7.521729415580275e-10, -5.084426536386061e-11,  1.699798810218855e-13,  5.956963044054815e-15, -3.355486750389499e-17,
 -7.504900902042827e-19,  6.241889826933976e-21,  9.631466074935097e-23,  1.289263309789211e+00, -8.841175702882358e-03, -2.875065423189360e-05,  4.491511082910011e-07,
  3.871676772733168e-09, -3.827111645554559e-11, -5.862008416991510e-13,  3.438337729746818e-15,  9.279532907021392e-17, -2.451450225033336e-19, -1.499643141976176e-20,
 -5.116202355956821e-24,  1.515683221922952e+00, -7.440443019745105e-03, -5.219325925790858e-05,  9.626370411712865e-08,  5.684231838400269e-09,  3.287530803644319e-11,
 -4.793504275406003e-13, -8.553112920216105e-15,  9.677919490241583e-19,  1.348418702296465e-18,  1.126943999433082e-20, -1.295339408064426e-22,  1.718968331126038e+00,
 -5.129226124932032e-03, -5.568301511912983e-05, -3.144138826581357e-07,  1.519072304264685e-09,  5.635254208553398e-11,  5.451410410834598e-13, -6.875135675931872e-16,
 -9.274221870749302e-17, -1.200395151350662e-18, -1.855716786762776e-21,  1.771175686998517e-22,  1.879060712297435e+00, -2.506781034497226e-03, -3.571181487667984e-05,
 -3.941570321424563e-07, -3.156361921337342e-09, -1.000135854711622e-11,  2.202538019999002e-13,  5.388208031568793e-15,  6.851107088528021e-17,  4.810088428950600e-19,
 -1.546150848191736e-21, -1.084284321892614e-22,  1.976275689141430e+00, -5.297126003829047e-04, -8.732177794585959e-06, -1.252530776069109e-07, -1.637836267013375e-09,
 -1.981783161276201e-11, -2.218245828584722e-13, -2.264164684522820e-15, -2.026047357964387e-17, -1.412700353575261e-19, -3.553854620701098e-22,  1.163761804270741e-23,
  1.706337871722242e-02, -2.496319112534340e-04,  2.720675506650485e-06, -2.613167279995284e-08,  2.324923456699891e-10, -1.957895308357397e-12,  1.572289895977270e-14,
 -1.210193174701408e-16,  8.872972761175058e-19, -6.206210674946562e-21,  4.003486380541160e-23, -2.424469118233514e-25,  6.811020272730178e-02, -9.803704433735000e-04,
  1.030040001873687e-05, -9.254431597597590e-08,  7.366607205329945e-10, -5.178767752631928e-12,  3.062751139309021e-14, -1.285345525956312e-16, -4.222829051728760e-20,
  8.556071641648701e-21, -1.244110013026716e-22,  1.223310695415050e-24,  1.526811240194091e-01, -2.136437221988859e-03,  2.101042373028725e-05, -1.656025497071039e-07,
  1.015997746721489e-09, -3.720904088039155e-12, -1.368286229283137e-14,  4.287429725245095e-16, -4.975384085410730e-18,  3.821083813419962e-20, -1.744684677695914e-22,
 -5.367780586877861e-25,  2.699070896680260e-01, -3.620608369278955e-03,  3.205196500269769e-05, -1.975879403702386e-07,  5.200343752648260e-10,  6.234500382690485e-12,
 -1.128816139428433e-13,  9.506456067828189e-16, -3.313746912708517e-18, -3.614050534206731e-20,  7.573792777321395e-22, -7.203581894323085e-24,  4.183342651159311e-01,
 -5.288326523258915e-03,  3.976395362331229e-05, -1.412445163637065e-07, -9.620401469266085e-10,  1.998050796364269e-11, -1.413387065586623e-13, -1.272929103112168e-16,
  1.418534381409808e-17, -1.552902817628576e-19,  4.467046446809547e-22,  9.950735750562911e-24,  5.956364418853736e-01, -6.941166394937410e-03,  4.010571015810044e-05,
  2.687366242472115e-08, -2.868639403379574e-09,  2.219391176428314e-11,  5.798008709096952e-14, -2.686668019251846e-15,  1.943927422167320e-17,  9.755964074346526e-20,
 -3.134029411311707e-21,  1.977031726393859e-23,  7.981678040562257e-01, -8.323425240706787e-03,  2.964514504125915e-05,  2.755469881005853e-07, -3.699876185039356e-09,
 -2.783565183917699e-12,  3.885374877183752e-13, -2.243353512910517e-15, -2.981783862970508e-17,  4.735133210947773e-19,  3.677427924182672e-22, -6.393941115386545e-23,
  1.020296615497526e+00, -9.130699270098035e-03,  7.321023667702487e-06,  4.931055557740249e-07, -1.715478814255797e-09, -4.490759828068495e-11,  3.180670888831022e-13,
  4.506357636548112e-15, -5.521767250683844e-17, -4.339910507319781e-19,  9.105946905680469e-21,  3.130798542029663e-23,  1.253474135993579e+00, -9.048631539306823e-03,
 -2.301679135053596e-05,  5.042487770902576e-07,  2.975048948659910e-09, -5.086137361314822e-11, -4.504995805718010e-13,  6.152444196003797e-15,  7.343389099773776e-17,
 -8.148568479409313e-19, -1.263836418505641e-20,  1.107567694520002e-22,  1.485095916758709e+00, -7.851776817454604e-03, -5.047295664638499e-05,  1.917656296443532e-07,
  6.207514159193522e-09,  1.854819173983802e-11, -7.105634024206683e-13, -7.672188156585345e-15,  5.585901752905618e-17,  1.642360175490539e-18,  2.407052242128994e-21,
 -2.682681100768576e-22,  1.697537304930469e+00, -5.589278709070068e-03, -5.927068894400332e-05, -2.803945468048396e-07,  2.773494590754021e-09,  6.882954821959815e-11,
  4.778440923136776e-13, -4.343261102972941e-15, -1.350312503130769e-16, -1.076600880627920e-18,  9.089581323100199e-21,  3.191345559692593e-22,  1.868431013784684e+00,
 -2.812266684106630e-03, -4.075022922907030e-05, -4.459158778156706e-07, -3.289961881868799e-09, -2.641782470658829e-12,  4.042721903172181e-13,  7.834614230955633e-15,
  8.329545920938340e-17,  2.935228797414542e-19, -8.663032566650089e-21, -2.229670625973517e-22,  1.974006933512819e+00, -6.060597769095384e-04, -1.040652596465524e-05,
 -1.549415040183268e-07, -2.092964755121172e-09, -2.598040985390668e-11, -2.950747278091973e-13, -2.995308039299643e-15, -2.543085098907988e-17, -1.397528475525246e-19,
  5.991991640083838e-22,  3.492538381755798e-23,  1.610648138771009e-02, -2.290604378673532e-04,  2.428185886301898e-06, -2.270565277756275e-08,  1.968492078346664e-10,
 -1.618195650941524e-12,  1.270036619964224e-14, -9.591150966704109e-17,  6.902589554977377e-19, -4.803971527911810e-21,  3.040300908758578e-23, -1.977471555650041e-25,
  6.434676680500950e-02, -9.022166169997010e-04,  9.257295697345075e-06, -8.154763208178943e-08,  6.401447533097012e-10, -4.486795065825945e-12,  2.704965167553287e-14,
 -1.258211532132739e-16,  1.879160056981535e-19,  4.518456276114031e-21, -8.065002005227209e-23,  7.859255639818616e-25,  1.444593386809878e-01, -1.976032155836221e-03,
  1.911822573221281e-05, -1.499559991136979e-07,  9.391804025465694e-10, -3.922004105696705e-12, -3.710030490768126e-15,  2.901618322493582e-16, -3.728903114394870e-18,
  3.099276384639505e-20, -1.817330417537711e-22,  1.127058492576184e-25,  2.559226819836379e-01, -3.373526856929323e-03,  2.973449515614679e-05, -1.884082468245558e-07,
  6.197225441922193e-10,  3.831768015757379e-12, -8.790547538014310e-14,  8.290397739941241e-16, -4.142198378903664e-18, -1.177576889651510e-20,  4.714624354161646e-22,
 -5.758404694702827e-24,  3.978061168036398e-01, -4.977227135521307e-03,  3.798925246215426e-05, -1.536249368928275e-07, -5.963962921836375e-10,  1.659187913887490e-11,
 -1.393594405834794e-13,  2.413579671473910e-16,  9.001277950563256e-18, -1.309089665431146e-19,  7.215014694915729e-22,  2.968641996077403e-24,  5.685144534557531e-01,
 -6.619776943567768e-03,  4.016763084708128e-05, -1.542221513607290e-08, -2.416565266553809e-09,  2.275543018488956e-11, -8.171943158486277e-15, -2.030806039689901e-15,
  2.091962156204060e-17, -8.878588688678544e-21, -2.166069340900160e-21,  2.282359499668272e-23,  7.653679446630716e-01, -8.074045243806881e-03,  3.259626223047810e-05,
  2.163871567180956e-07, -3.667876863498353e-09,  5.695469453583005e-12,  3.149180504402885e-13, -2.927068386940090e-15, -1.312656790966272e-17,  4.384570845021318e-19,
 -1.944987359388524e-21, -4.003976556087358e-23,  9.839276857154485e-01, -9.048993991368858e-03,  1.304541709023357e-05,  4.589265869619089e-07, -2.528158125503707e-09,
 -3.597139797454529e-11,  4.176696053913003e-13,  2.561184129685773e-15, -6.413817624587025e-17, -6.239008581669761e-20,  8.995385583981623e-21, -3.401971313464612e-23,
  1.216950700142790e+00, -9.207833532530806e-03, -1.671550202823702e-05,  5.431872583335259e-07,  1.864900782697267e-09, -5.937093048109577e-11, -2.503745784370367e-13,
  7.946663814835302e-15,  3.643235123564478e-17, -1.195333172122605e-18, -5.808664196454074e-21,  1.892722353810121e-22,  1.452898229221557e+00, -8.244645448613598e-03,
 -4.756679663454587e-05,  2.930582883354124e-07,  6.391818455256304e-09, -8.265086075166520e-13, -8.914814969275342e-13, -4.944974945862952e-15,  1.136117752565724e-16,
  1.475450668516211e-18, -1.122328593227763e-20, -3.316415440504583e-22,  1.674211756846918e+00, -6.076040341592806e-03, -6.232185717408822e-05, -2.244333577278349e-07,
  4.252253631443297e-09,  7.831761376336326e-11,  2.905819194432615e-13, -9.184677759541484e-15, -1.635536411791139e-16, -3.999362324107861e-19,  2.534314965520620e-20,
  3.991620674186170e-22,  1.856494789926867e+00, -3.160567547566375e-03, -4.641687497766312e-05, -4.983706802944791e-07, -3.226415616222163e-09,  1.000122796903671e-11,
  6.619459443358697e-13,  1.058053592569772e-14,  8.487268518846693e-17, -2.921730049517991e-19, -2.172421419453810e-20, -3.732495935325358e-22,  1.971403555342354e+00,
 -6.973606018189001e-04, -1.248522411753705e-05, -1.930008101236284e-07, -2.690678346128737e-09, -3.416498124356299e-11, -3.910389664593376e-13, -3.881264982511350e-15,
 -2.955141870401062e-17, -7.260834113118718e-20,  3.132069506506705e-21,  8.671233420705998e-23,  1.522743745826223e-02, -2.106736355432647e-04,  2.173598823084195e-06,
 -1.979928561828830e-08,  1.673281060868084e-10, -1.343268970783410e-12,  1.029965869099731e-14, -7.637200613841588e-17,  5.372012409841049e-19, -3.751950230492998e-21,
  2.242107953474337e-23, -1.669252680786259e-25,  6.088005655366717e-02, -8.319050150429221e-04,  8.337327742019325e-06, -7.198911436710281e-08,  5.566194795794716e-10,
 -3.879070231332270e-12,  2.363122082155081e-14, -1.177665835795188e-16,  2.998815472703740e-19,  1.879470963040078e-21, -5.371357454089827e-23,  4.546606357524149e-25,
  1.368500577750116e-01, -1.830034760970775e-03,  1.740631785915289e-05, -1.355589387434210e-07,  8.604425076325893e-10, -3.926053045622723e-12,  2.901766403171187e-15,
  1.873009873689117e-16, -2.742010837714391e-18,  2.390589432205639e-20, -1.711775301007771e-22,  3.139850746292342e-25,  2.428902522123108e-01, -3.144520809368019e-03,
  2.753526812039021e-05, -1.779866128240150e-07,  6.770622167828347e-10,  1.985342409515969e-12, -6.658859030397679e-14,  6.928766388935929e-16, -4.283800625423313e-18,
  2.444944325270487e-21,  2.498697119465622e-22, -4.346080587729041e-24,  3.784931635689703e-01, -4.680825279985111e-03,  3.609886873153458e-05, -1.606914720746728e-07,
 -2.973070974291680e-10,  1.335674663694401e-11, -1.292365921135201e-13,  4.597283019320248e-16,  4.825651388353326e-18, -1.009247146718404e-19,  7.452284866446459e-22,
 -1.495475957741256e-24,  5.426759731298041e-01, -6.299799040335624e-03,  3.976550849697002e-05, -5.047502838181438e-08, -1.967636126913535e-09,  2.195175295500118e-11,
 -5.581857353794837e-14, -1.381284068805516e-15,  1.927680996682162e-17, -7.612882310934956e-20, -1.222431636443392e-21,  1.932180946234963e-23,  7.336083554451824e-01,
 -7.803875041030204e-03,  3.484580335707404e-05,  1.589945163922449e-07, -3.485211356967651e-09,  1.223651323956291e-11,  2.293276242918560e-13, -3.112566863727055e-15,
  9.029825783196774e-19,  3.330840666458820e-19, -3.139291666885662e-21, -1.484523156449968e-23,  9.479742765294031e-01, -8.923340871425472e-03,  1.828791263434386e-05,
  4.132854814513368e-07, -3.142735276601559e-09, -2.531837537769697e-11,  4.607848326185525e-13,  5.384337942285403e-16, -6.040405617585220e-17,  2.529973235575587e-19,
  6.469952599286865e-21, -7.562251431218730e-23,  1.179893795149699e+00, -9.315069288923216e-03, -1.005825557209937e-05,  5.632773342290821e-07,  6.359229191388443e-10,
 -6.261905289228766e-11, -1.823811484732660e-14,  8.395949100846037e-15, -8.703472257554360e-18, -1.254476048584270e-18,  2.864216680035034e-21,  1.910637090110287e-22,
  1.419183294152108e+00, -8.609383459778885e-03, -4.344090325269071e-05,  3.939935579111107e-07,  6.152435429040295e-09, -2.342747311217082e-11, -9.718383178611848e-13,
 -5.741942164768827e-16,  1.552247719187597e-16,  7.473360660669739e-19, -2.457491555623566e-20, -2.482137430491706e-22,  1.648895181164418e+00, -6.584110360267965e-03,
 -6.455418882127397e-05, -1.435857358779628e-07,  5.864429969195553e-09,  8.160865233330961e-11, -4.043407809316997e-14, -1.441933059502982e-14, -1.555791639089136e-16,
  9.497570385529162e-19,  4.130691871371889e-20,  2.827070373317881e-22,  1.843070762364091e+00, -3.556680593344560e-03, -5.269737406052401e-05, -5.474238979412028e-07,
 -2.842007053819442e-09,  2.973333281622556e-11,  9.932484288816017e-13,  1.292582041130019e-14,  5.437848971126463e-17, -1.529819360015820e-18, -4.098709356188841e-20,
 -4.839631803521209e-22,  1.968398575194303e+00, -8.072937331381496e-04, -1.508384523120769e-05, -2.420668684173712e-07, -3.477188717144149e-09, -4.496221868725898e-11,
 -5.131235743281901e-13, -4.835602971739843e-15, -2.875892717391989e-17,  1.554041056919734e-19,  9.050025422983979e-21,  1.947322872509965e-22,  1.441807741931264e-02,
 -1.941916554066219e-04,  1.951225936257246e-06, -1.732422185496146e-08,  1.427709640705875e-10, -1.119914600034354e-12,  8.382756303388699e-15, -6.118348692654459e-17,
  4.165777576694850e-19, -2.993738718576540e-21,  1.572266609623628e-23, -1.339762405849403e-25,  5.768056877840207e-02, -7.685161715655196e-04,  7.524430456664373e-06,
 -6.367413978546630e-08,  4.844482917025458e-10, -3.350357554914187e-12,  2.047552288618087e-14, -1.074678523023588e-16,  3.330162323409403e-19,  5.936499022730149e-23,
 -3.874781951650879e-23,  2.580139435749589e-25,  1.297984399205822e-01, -1.697062941649949e-03,  1.585963860096762e-05, -1.224146287585969e-07,  7.829946311954623e-10,
 -3.802643986218164e-12,  7.037891201944151e-15,  1.120328530238576e-16, -2.001183326968575e-18,  1.734997135174268e-20, -1.561562001624694e-22,  3.877365296652969e-25,
  2.307394695806631e-01, -2.932595375693820e-03,  2.546547315083335e-05, -1.669164749449949e-07,  7.022797595329286e-10,  6.046740257603435e-13, -4.908225614185308e-14,
  5.587811433808859e-16, -4.058480895933776e-18,  8.998041703657042e-21,  8.741908152331935e-23, -3.008873990396231e-24,  3.603351430464815e-01, -4.399809158100107e-03,
  3.415031176707509e-05, -1.634751811429883e-07, -6.006961135891243e-11,  1.042383106994273e-11, -1.147084938836843e-13,  5.615903059884466e-16,  1.705562510134385e-18,
 -7.322134414308517e-20,  6.248735749461129e-22, -3.550416051668107e-24,  5.181084767519175e-01, -5.984600137292798e-03,  3.898513447957537e-05, -7.852964454103890e-08,
 -1.544781880241253e-09,  2.021487026780052e-11, -8.632866976409027e-14, -8.161513276526750e-16,  1.584550220578208e-17, -1.097267052526534e-19, -5.005399208276700e-22,
  1.348691561889880e-23,  7.029611601876744e-01, -7.518404458919405e-03,  3.642812151157113e-05,  1.054585803128271e-07, -3.192441108990909e-09,  1.670800765573194e-11,
  1.442046363586884e-13, -2.916947363422318e-15,  1.053360583513549e-17,  2.006414010393912e-19, -3.342360888209333e-21,  4.459661101954702e-24,  9.126036767241010e-01,
 -8.758089261484695e-03,  2.293087686666477e-05,  3.595529606165475e-07, -3.538380410912596e-09, -1.428701312246467e-11,  4.504858474546991e-13, -1.205672398583779e-15,
 -4.748896804911433e-17,  4.403130722198912e-19,  2.834126759684466e-21, -8.414272094909124e-23,  1.142515513972410e+00, -9.368419993195130e-03, -3.279068686125126e-06,
  5.634881096695531e-07, -6.021288566193083e-10, -6.030774788099169e-11,  2.064085682156090e-13,  7.432494710567164e-15, -4.992191345504331e-17, -9.886714102516155e-19,
  9.897390055703715e-21,  1.192760259992889e-22,  1.384082954603193e+00, -8.936369360990425e-03, -3.814190400720603e-05,  4.874217318590882e-07,  5.452322596328374e-09,
 -4.636562157555942e-11, -9.157906363275523e-13,  4.615724313412450e-15,  1.623221008864317e-16, -3.952559294042216e-19, -3.088010514236362e-20, -1.990651147807792e-23,
  1.621517374361797e+00, -7.105717879476273e-03, -6.566093978155446e-05, -3.689707075477662e-08,  7.451465576288758e-09,  7.527426337488777e-11, -5.063467427544223e-13,
 -1.851308907418517e-14, -8.951253902910393e-17,  2.751628903589532e-18,  4.578594545189828e-20, -1.279253615141280e-22,  1.827958257403260e+00, -4.005254726716545e-03,
 -5.951513095134352e-05, -5.867176611002346e-07, -1.978889258985485e-09,  5.804777092256993e-11,  1.368756673816306e-12,  1.342685279624929e-14, -3.528561450512268e-17,
 -3.584793030925602e-18, -6.087018186650190e-20, -3.559836614386509e-22,  1.964908230547903e+00, -9.406024255916131e-04, -1.835443035413060e-05, -3.056127675384117e-07,
 -4.511054818193916e-09, -5.899780363975718e-11, -6.599538391552199e-13, -5.576779496082136e-15, -1.412173959196765e-17,  7.411651801718784e-19,  2.175620902005350e-20,
  4.041193453098916e-22,  1.367126643760746e-02, -1.793762109008698e-04,  1.756336022708278e-06, -1.520869825239680e-08,  1.222531467948778e-10, -9.378752656923464e-13,
  6.840847186253275e-15, -4.946645290171423e-17,  3.188761634703655e-19, -2.462359030817260e-21,  1.153348134108436e-23, -3.766322466438987e-26,  5.472223527127646e-02,
 -7.112502407530096e-04,  6.804720324415275e-06, -5.643332574984588e-08,  4.221177235868604e-10, -2.893858196414836e-12,  1.761392968260255e-14, -9.705427599312592e-17,
  3.099961801341562e-19, -1.256327312513424e-21, -2.596901733856652e-23,  4.122016558625124e-25,  1.232549319902161e-01, -1.575854476086010e-03,  1.446335313956768e-05,
 -1.104850169483104e-07,  7.088498327553460e-10, -3.602792892996767e-12,  9.363802184643823e-15,  5.682173798388525e-17, -1.484028159675777e-18,  1.155339097170929e-20,
 -1.293121906581137e-22,  1.005732047662055e-24,  2.194041203905357e-01, -2.736692032558473e-03,  2.353009997799380e-05, -1.556421946196514e-07,  7.037863082076484e-10,
 -3.999075618412619e-13, -3.520243043900005e-14,  4.345383162280924e-16, -3.698878759095208e-18,  1.037589059518570e-20, -2.705102636058163e-24, -8.023052697614486e-25,
  3.432698839198238e-01, -4.134454912289522e-03,  3.218925292091734e-05, -1.629126340923247e-07,  1.221727997607567e-10,  7.863418077186714e-12, -9.858353662211753e-14,
  5.785101251099639e-16, -5.179968532806762e-19, -5.127792926993956e-20,  4.815960714418773e-22, -2.227960454914823e-24,  4.947873164522473e-01, -5.676878704393110e-03,
  3.790743799412085e-05, -1.001311347661093e-07, -1.162774169959619e-09,  1.792229171088806e-11, -1.026972131886503e-13, -3.750858354599872e-16,  1.166547619605503e-17,
 -1.191842121046874e-19,  4.716159831843752e-24,  1.044286553825403e-23,  6.734772161082277e-01, -7.222759335893950e-03,  3.739871247677075e-05,  5.721383909971859e-08,
 -2.830065620580773e-09,  1.923268023498125e-11,  6.815461738415394e-14, -2.489454311478758e-15,  1.543788868926343e-17,  7.526654960924079e-20, -2.821925222321313e-21,
  1.895418378252371e-23,  8.779641570877428e-01, -8.558364112518398e-03,  2.689826292128427e-05,  3.012260119012379e-07, -3.719561573609557e-09, -4.036925367095597e-12,
  3.979500735694716e-13, -2.456828223838701e-15, -3.045141252516499e-17,  4.842261186909041e-19, -4.712901129528389e-22, -6.123814247588590e-23,  1.105031844536589e+00,
 -9.367858474830001e-03,  3.386237670137975e-06,  5.445410821532614e-07, -1.742950682912566e-09, -5.306707492029601e-11,  3.873983794766559e-13,  5.350449995684136e-15,
 -7.738882929129060e-17, -5.170596086666429e-19,  1.295879808925247e-20,  2.094912450698569e-23,  1.347766242064638e+00, -9.216703292290129e-03, -3.180374491627449e-05,
  5.661004528912627e-07,  4.318635645637381e-09, -6.622837891120490e-11, -7.176544326746172e-13,  9.347209785376584e-15,  1.264027896890209e-16, -1.564987470252924e-18,
 -2.555457189162217e-20,  2.596904088062523e-22,  1.592044129348853e+00, -7.630640425585744e-03, -6.534131450867526e-05,  9.352920938681548e-08,  8.792200141005354e-09,
  5.668157423358154e-11, -1.047516694902644e-12, -1.946030936114218e-14,  3.959087337071547e-17,  4.297098044645220e-18,  2.704413061467822e-20, -7.313016762258849e-22,
  1.810939777656434e+00, -4.509976031764976e-03, -6.670128303853807e-05, -6.071835562568124e-07, -4.602087923903386e-10,  9.514509925787385e-11,  1.706010678777433e-12,
  9.740449740679699e-15, -2.106452058736864e-16, -6.180793294593247e-18, -6.386634394941343e-20,  3.445392499508785e-22,  1.960827065545555e+00, -1.103429821980860e-03,
 -2.249671747520662e-05, -3.881435005023557e-07, -5.862182307667576e-09, -7.672993963559177e-11, -8.169937839628972e-13, -5.393604824757876e-15,  3.334895389192694e-17,
  2.061628149499553e-18,  4.692164126780776e-20,  7.689608166052567e-22,  1.298075224525743e-02, -1.660236572514152e-04,  1.584976604825504e-06, -1.339423867522613e-08,
  1.050308779850937e-10, -7.892413479649711e-13,  5.585949562606441e-15, -4.059144031159748e-17,  2.386860107283230e-19, -1.970625595085294e-21,  1.503464973810299e-23,
  2.358627271092620e-25,  5.198197737708998e-02, -6.594107157194293e-04,  6.166205694388200e-06, -5.012039530655039e-08,  3.682533768255334e-10, -2.502661064131865e-12,
  1.502731695392621e-14, -8.801215701060792e-17,  2.521769058226527e-19, -1.728208990605765e-21,  9.196205629889884e-24,  1.354472416100291e-24,  1.171747959559132e-01,
 -1.465263519233951e-03,  1.320324548523169e-05, -9.970720709956113e-08,  6.391439347566264e-10, -3.363984529980332e-12,  1.034600978182289e-14,  1.510359482917327e-17,
 -1.146155643499945e-18,  7.777772254781600e-21, -4.292308224083687e-23,  3.291873371485591e-24,  2.088222741539026e-01, -2.555731514718909e-03,  2.172955522764564e-05,
 -1.444876022899042e-07,  6.882574417783166e-10, -1.111792274697460e-12, -2.463652539271113e-14,  3.221280838219833e-16, -3.325266969583572e-18,  1.077008776202716e-20,
  5.906387573980748e-23,  4.256734759545804e-24,  3.272347726108623e-01, -3.884716320027486e-03,  3.025081826164865e-05, -1.598228221851047e-07,  2.570767281424805e-10,
  5.688343515520967e-12, -8.286902077631807e-14,  5.360112535194129e-16, -2.027072527235553e-18, -3.235834298702983e-20,  5.173945871083972e-22,  5.087503015536699e-24,
  4.726782989731916e-01, -5.378715412472221e-03,  3.660562493584649e-05, -1.160047344654526e-07, -8.296251026635127e-10,  1.536977172447491e-11, -1.086128700884479e-13,
 -6.946622044634106e-17,  7.495887304501234e-18, -1.088857349507271e-19,  5.540419735235226e-22,  1.653697588616860e-23,  6.451878588019859e-01, -6.921563452065484e-03,
  3.782651141766953e-05,  1.507622112099658e-08, -2.434404554500224e-09,  2.008952798295361e-11,  5.628879834348710e-15, -1.971967667047952e-15,  1.635908242837833e-17,
 -1.616447353638638e-20, -1.616457487940390e-21,  3.739694258535939e-23,  8.441825337162691e-01, -8.329733769473558e-03,  3.015484549325798e-05,  2.415608795661387e-07,
 -3.710865729583703e-09,  4.594129967412563e-12,  3.180844312291874e-13, -3.160521961511092e-15, -1.389215392769374e-17,  4.245994994735661e-19, -2.135560448797540e-21,
 -9.860026344720016e-24,  1.067655204340308e+00, -9.315181832247693e-03,  9.720146138425007e-06,  5.087140234247366e-07, -2.700687886678527e-09, -4.226520548037402e-11,
  5.004591021112998e-13,  2.676613505302697e-15, -8.666034088359217e-17, -2.430157842303907e-21,  1.234343311936391e-20, -3.718090853591424e-23,  1.310435111162309e+00,
 -9.442892035421162e-03, -2.464243121213684e-05,  6.237627389083100e-07,  2.845148116159470e-09, -7.991282676909511e-11, -4.090294207472682e-13,  1.232006627412208e-14,
  5.506792245126499e-17, -2.288752151451297e-18, -9.105306611991599e-21,  4.685254538245170e-22,  1.560486692348546e+00, -8.146413682496124e-03, -6.334242353797839e-05,
  2.417267055234527e-07,  9.631659710991758e-09,  2.529433550221901e-11, -1.550336090559715e-12, -1.558192723489488e-14,  2.045893563959564e-16,  4.585554558712384e-18,
 -1.555687129421403e-20, -1.125234804703750e-21,  1.791786539691466e+00, -5.072696814636396e-03, -7.396144950307534e-05, -5.970228154281628e-07,  1.869357423773449e-09,
  1.383783618656018e-10,  1.847687847058732e-12, -1.001511562081049e-15, -4.720296610050487e-16, -8.040345353329913e-18, -1.784616705582667e-20,  1.886721848202409e-21,
  1.956021486011944e+00, -1.303752757104366e-03, -2.777143460068727e-05, -4.953287258170658e-07, -7.604125172274709e-09, -9.794612918087515e-11, -9.389094472245592e-13,
 -2.702017819765398e-15,  1.508117125327321e-16,  4.760646077749386e-18,  9.185979885376591e-20,  1.291612154507222e-21,  1.234103808735298e-02, -1.539593536513209e-04,
  1.433830380545579e-06, -1.183311086129969e-08,  9.049881707319258e-11, -6.680149513341554e-13,  4.546638482426333e-15, -3.394440737165747e-17,  1.822748160440083e-19,
 -1.026101018614912e-21,  3.592949194507091e-23,  7.450796409515402e-25,  4.943932120461913e-02, -6.123903650495153e-04,  5.598522742583122e-06, -4.460999358135956e-08,
  3.216115888487620e-10, -2.170717203575514e-12,  1.266792231556206e-14, -8.072105227845469e-17,  2.154902696335431e-19,  3.443983244879309e-22,  1.087622758582003e-22,
  3.305315867109038e-24,  1.115176548597834e-01, -1.364254679325366e-03,  1.206594051002276e-05, -9.000557798882700e-08,  5.743612030213770e-10, -3.114494858706378e-12,
  1.029713751729716e-14, -1.707280576169019e-17, -8.515233768651637e-19,  1.015605059378036e-20,  1.951896572296557e-22,  7.834167900214247e-24,  1.989363017383378e-01,
 -2.388645156065271e-03,  2.006094673592693e-05, -1.336826408471856e-07,  6.607788902404657e-10, -1.606471867494781e-12, -1.704232292460131e-14,  2.228843615250317e-16,
 -2.828412555235306e-18,  1.929067741118886e-20,  4.331681227433952e-22,  1.327925028284670e-23,  3.121678831511798e-01, -3.650303375558196e-03,  2.836104162753014e-05,
 -1.549025620919718e-07,  3.521288240711118e-10,  3.871338182411928e-12, -6.891186952899867e-14,  4.571601004597122e-16, -2.731208594667978e-18, -3.319943207465669e-21,
  1.042108020462536e-21,  1.974377514759817e-23,  4.517400220264948e-01, -5.091641857841346e-03,  3.514360865032301e-05, -1.269614220549047e-07, -5.483289091730020e-10,
  1.276339818145849e-11, -1.077490571743331e-13,  1.136458936200838e-16,  4.191091903519205e-18, -6.751529423873864e-20,  1.650624749344214e-21,  3.505966620098452e-23,
  6.181070803688095e-01, -6.618859365294843e-03,  3.778695734331298e-05, -2.067030666985626e-08, -2.035433393379368e-09,  1.962029862453239e-11, -4.241290950285210e-14,
 -1.466586259619755e-15,  1.508121546804414e-17, -3.990296366003348e-20,  6.488532658760733e-22,  6.731531134557696e-23,  8.113630222361188e-01, -8.077899913336649e-03,
  3.270162464832623e-05,  1.833060539211950e-07, -3.550012762344694e-09,  1.112952251911199e-11,  2.255475392542625e-13, -3.376621747523488e-15, -6.217945369916668e-20,
  3.512671538204712e-19, -9.846317233200920e-22,  6.471585440385078e-23,  1.030587545319708e+00, -9.213796876636916e-03,  1.553972340242297e-05,  4.594130583841283e-07,
 -3.421418958091750e-09, -2.966496381643103e-11,  5.372277461529192e-13, -5.872124183968917e-18, -7.825418762132334e-17,  4.599508064794827e-19,  1.097133658155583e-20,
 -1.074667848075077e-23,  1.272317598839073e+00, -9.609441332752947e-03, -1.693828740055359e-05,  6.560855601562083e-07,  1.177366652933349e-09, -8.546847183792162e-11,
 -5.204076394617569e-14,  1.273607384918517e-14, -2.860328341171890e-17, -2.208463212704278e-18,  1.366182758096290e-20,  5.429899783033677e-22,  1.526909661947642e+00,
 -8.638905740350353e-03, -5.950728723233484e-05,  3.977255784025071e-07,  9.734573226390923e-09, -1.626361917206511e-11, -1.871572591008606e-12, -6.610093930208662e-15,
  3.467043766368768e-16,  3.003749483035120e-18, -6.120047334712599e-20, -8.029410485418826e-22,  1.770268010148851e+00, -5.692311235871583e-03, -8.084723810285629e-05,
 -5.426068539393495e-07,  5.068138983091607e-09,  1.804117925477336e-10,  1.564793167250223e-12, -2.067778346445794e-14, -7.489349656360410e-16, -6.499887457481587e-18,
  1.096401059440700e-19,  3.886330521566192e-21,  1.950321360659479e+00, -1.551925247337191e-03, -3.451402742061891e-05, -6.339040592207776e-07, -9.790922117403724e-09,
 -1.206558582149398e-10, -9.154912937662887e-13,  5.695810162297263e-15,  4.034413502799323e-16,  9.722850091597599e-18,  1.594104655542902e-19,  1.710172071108755e-21,
  1.174727610187626e-02, -1.430330626710290e-04,  1.300098396634407e-06, -1.048639498239290e-08,  7.815602864830787e-11, -5.696642860637841e-13,  3.674698784522644e-15,
 -2.835127037250334e-17,  1.805899222372550e-19,  1.226224265074925e-21,  8.007152978607390e-23,  1.194130972134787e-24,  4.707606502813290e-02, -5.696591803727811e-04,
  5.092696303146571e-06, -3.979575788507688e-08,  2.810586806054515e-10, -1.892980889945343e-12,  1.051396105746180e-14, -7.246432788581044e-17,  3.470419455389129e-19,
  8.225977646948874e-21,  2.985031141313401e-22,  5.051989327791925e-24,  1.062470651886287e-01, -1.271895844551128e-03,  1.103899961147583e-05, -8.130090338153945e-08,
  5.144896729100732e-10, -2.875769061620948e-12,  9.507671628175835e-15, -3.620121381920116e-17, -2.488636309224294e-19,  2.630040670312377e-20,  6.426051550706654e-22,
  1.188537663979000e-23,  1.896927867309892e-01, -2.234397193480261e-03,  1.851906293650225e-05, -1.233874897997108e-07,  6.250151988436290e-10, -1.950033213961817e-12,
 -1.193296425145729e-14,  1.481479638636646e-16, -1.655021293304475e-18,  5.112273047327531e-20,  1.218562727078341e-21,  2.126418210338234e-23,  2.980088159859632e-01,
 -3.430749264975212e-03,  2.653829071622890e-05, -1.487347716137163e-07,  4.140032675797726e-10,  2.361407744248725e-12, -5.728429968791482e-14,  3.778839441011433e-16,
 -1.847317865677929e-18,  6.044656866844747e-20,  2.247618738820896e-21,  3.321732639126723e-23,  4.319259171428771e-01, -4.816717788451193e-03,  3.357540428114814e-05,
 -1.338317147462515e-07, -3.185922560888811e-10,  1.022905263449293e-11, -1.029444794890891e-13,  2.250267197394956e-16,  3.380195200127541e-18,  3.576610051068092e-20,
  3.651546290806870e-21,  5.332673864228507e-23,  5.922339204620066e-01, -6.318080121002015e-03,  3.735624648420243e-05, -5.016629442713143e-08, -1.656255385638406e-09,
  1.816315550380672e-11, -7.686476263758684e-14, -9.955902608845663e-16,  1.491264461260751e-17,  5.462074578392602e-20,  4.273958274734268e-21,  9.332089524129308e-23,
  7.795872411489433e-01, -7.808435160413917e-03,  3.456870674900221e-05,  1.285486860672079e-07, -3.280901130682749e-09,  1.541946973664835e-11,  1.328601128820424e-13,
 -3.176955167967412e-15,  1.276526177130585e-17,  3.908843328054830e-19,  3.449015390973690e-21,  1.295873077060470e-22,  9.940145412158240e-01, -9.068398448105260e-03,
  2.070690233651451e-05,  4.006195846635507e-07, -3.887183358621660e-09, -1.703810900348091e-11,  5.050996450933308e-13, -2.159979206844988e-15, -5.370721991769770e-17,
  9.119806364271397e-19,  1.221137583080359e-20,  6.651013899380139e-23,  1.233658964408127e+00, -9.713265043037607e-03, -9.008537641531295e-06,  6.612991019165948e-07,
 -5.164359807960478e-10, -8.261009853854454e-11,  2.808238454177166e-13,  1.070051324837613e-14, -9.258439772878409e-17, -1.194133999036508e-18,  3.652047482257008e-20,
  4.683404377979515e-22,  1.491435834777520e+00, -9.093266200098555e-03, -5.381881598256245e-05,  5.483967694751181e-07,  8.951968732839502e-09, -6.206706940393002e-11,
 -1.888766818706687e-12,  5.689027352291465e-15,  4.047520018448449e-16,  1.321831544797058e-19, -7.426949698559222e-20,  2.963102099611235e-22,  1.746166294247864e+00,
 -6.363469436750334e-03, -8.674695801094042e-05, -4.308582311118639e-07,  8.990252770681243e-09,  2.081337815116234e-10,  6.232190095592024e-13, -4.718058606286895e-14,
 -8.589735047527501e-16,  1.692320542827575e-18,  3.051893705063021e-19,  4.551624664134926e-21,  1.943509247717830e+00, -1.861318753700358e-03, -4.314408324891549e-05,
 -8.109724779433359e-07, -1.240175520047677e-08, -1.388839670542050e-10, -5.130270874275882e-13,  2.558217615621587e-14,  8.859400000711701e-16,  1.753169555377713e-17,
  2.257792375619202e-19,  9.444461127583587e-22,  1.119517736746968e-02, -1.331152000647237e-04,  1.181403471519572e-06, -9.322510398652732e-09,  6.758400660354533e-11,
 -4.902790958760809e-13,  2.973404156232805e-15, -2.114609700033184e-17,  2.947873307623262e-19,  5.430151247794051e-21,  1.260250836698784e-22,  6.055792153606125e-25,
  4.487599121104796e-02, -5.307541499400006e-04,  4.640922064297224e-06, -3.558864861728449e-08,  2.455660457568055e-10, -1.663372174097096e-12,  8.703888396887111e-15,
 -5.388634841528766e-17,  9.104657634998811e-19,  2.439405583260082e-20,  4.929080100433510e-22,  2.614472205147840e-24,  1.013301188358977e-01, -1.187350642182511e-03,
  1.011092098002729e-05, -7.351714134048104e-08,  4.591738177445706e-10, -2.659570939493676e-12,  8.566149358583266e-15, -2.304266083920443e-17,  1.283929310039038e-18,
  6.196663455297308e-20,  1.101618200382545e-21,  6.277317473608091e-24,  1.810423614935670e-01, -2.092000343859507e-03,  1.709708074054320e-05, -1.137134843775650e-07,
  5.834642812577905e-10, -2.190548944269832e-12, -8.171939558328760e-15,  1.358595248127152e-16,  1.284394015093093e-18,  1.177890706813320e-19,  2.045631138034439e-21,
  1.132775723535799e-23,  2.846992908543809e-01, -3.225466477884918e-03,  2.479454394055127e-05, -1.418040831390321e-07,  4.483167295916618e-10,  1.109575776604905e-12,
 -4.706371872713853e-14,  3.737879584766124e-16,  2.294480501073611e-18,  1.784571151959742e-19,  3.543786693117838e-21,  1.749718301706980e-23,  4.131859783223518e-01,
 -4.554610445974493e-03,  3.194516162255706e-05, -1.374243938334570e-07, -1.381352631673755e-10,  7.848528044302240e-12, -9.470836605363114e-14,  3.865330934500584e-16,
  7.851120534981698e-18,  2.266166335944222e-19,  5.715031787286139e-21,  2.802221143610130e-23,  5.675548868074186e-01, -6.022061718922212e-03,  3.660688995521254e-05,
 -7.386897880535862e-08, -1.313406484260707e-09,  1.604100165200582e-11, -9.748337464723396e-14, -4.459942851636107e-16,  2.092352529057835e-17,  3.039032498099662e-19,
  7.912599292462431e-21,  5.351951999366931e-23,  7.489151417895260e-01, -7.526583157582449e-03,  3.580698227108333e-05,  7.866539666091138e-08, -2.947532535001854e-09,
  1.760105113294359e-11,  5.199551199692942e-14, -2.505302748929663e-15,  3.071849731617648e-17,  6.434067668406828e-19,  8.904647685098083e-21,  8.968864054821816e-23,
  9.581011833772025e-01, -8.884592536769112e-03,  2.513199245960713e-05,  3.363335692605045e-07, -4.112482631436024e-09, -5.801813392869631e-12,  4.262038648449299e-13,
 -3.252648786669809e-15, -1.129151327407422e-17,  1.465946934271609e-18,  1.530377320928438e-20,  3.716400804867730e-23,  1.194711666086208e+00, -9.753854166232239e-03,
 -1.175599791754736e-06,  6.402801482139615e-07, -2.078830503497315e-09, -7.263844824011549e-11,  5.347234821111957e-13,  7.368506119369042e-15, -1.049038516942841e-16,
  6.095986131375102e-19,  5.138494166126001e-20,  1.510287817795312e-22,  1.454246640547182e+00, -9.495168715676613e-03, -4.642739706587453e-05,  6.793149400370558e-07,
  7.277737258956689e-09, -1.040374384118746e-10, -1.551261516400011e-12,  1.819126769330864e-14,  3.624725796911741e-16, -2.223367986630075e-18, -3.584035074604119e-20,
  1.324187355807152e-21,  1.719295592972397e+00, -7.075361755574349e-03, -9.091555014688195e-05, -2.534035232234222e-07,  1.318001831753166e-08,  2.042820126932961e-10,
 -1.054579164385730e-12, -7.097697881886071e-14, -5.353166726972084e-16,  1.725257133019209e-17,  4.470323096620633e-19,  9.845379772418341e-22,  1.935306989175483e+00,
 -2.248985354975220e-03, -5.415933018528304e-05, -1.031981714604285e-06, -1.522527861356831e-08, -1.387508303298813e-10,  7.077114966693618e-13,  6.580351473762267e-14,
  1.681413260528360e-15,  2.641057729671085e-17,  1.832857157647154e-19, -3.935024251413403e-21,  1.068093551232087e-02, -1.240937908879055e-04,  1.075709888688900e-06,
 -8.315913101662949e-09,  5.845048681193220e-11, -4.247404744183912e-13,  2.549829303433299e-15, -7.596837860986670e-18,  5.815961951801697e-19,  1.032033384551630e-20,
  9.600973377012996e-23, -2.495200956253758e-24,  4.282461568110126e-02, -4.952706914471893e-04,  4.236370327194783e-06, -3.191482357461170e-08,  2.142862852959033e-10,
 -1.468341984764089e-12,  7.762698663485516e-15, -6.819989026336286e-18,  2.147477932443607e-18,  4.362470335782306e-20,  3.771353980186897e-22, -1.000828180207565e-23,
  9.673707478368360e-02, -1.109871172472359e-03,  9.271076502493562e-06, -6.658482773714616e-08,  4.080198881575335e-10, -2.454710365530338e-12,  8.893633328226293e-15,
  6.243507369706479e-17,  4.319571153195932e-18,  1.051266423513215e-19,  8.452338740942821e-22, -2.285519697247350e-23,  1.729394907668345e-01, -1.960526634815455e-03,
  1.578705507449198e-05, -1.047377671363190e-07,  5.380428979878195e-10, -2.331886502900052e-12, -3.039762592237319e-15,  2.609421027115909e-16,  7.017375333547394e-18,
  1.978147617193792e-19,  1.568112589935233e-21, -4.214391900414027e-23,  2.721835344331264e-01, -3.033793473802183e-03,  2.313647713973899e-05, -1.345110608944468e-07,
  4.601324040683335e-10,  1.208697413708845e-13, -3.440504070908883e-14,  5.778393365336702e-16,  1.129266380540883e-17,  3.164465550820361e-19,  2.722974470697246e-21,
 -6.980854368574745e-23,  3.954681765694554e-01, -4.305671948568802e-03,  3.028759941822469e-05, -1.384979903903341e-07, -2.833485746095666e-12,  5.742939466994917e-12,
 -7.882074333817492e-14,  8.132416124928431e-16,  2.016852097299272e-17,  4.502446640513714e-19,  4.489742851318769e-21, -1.067472149230161e-22,  5.440462628678375e-01,
 -5.733086015416920e-03,  3.560454248099989e-05, -9.244677373883834e-08, -1.016551859233215e-09,  1.363957093694240e-11, -9.850202686666593e-14,  4.618940353778937e-16,
  3.774678214565331e-17,  6.227846900333292e-19,  6.563227297499248e-21, -1.490764685498266e-22,  7.193866032870710e-01, -7.237126004383995e-03,  3.647978052234999e-05,
  3.436729373391392e-08, -2.588040326545094e-09,  1.814223326052685e-11, -3.898697811259682e-16, -1.078554336421542e-15,  6.071583715903850e-17,  1.016358550389263e-18,
  7.658913192193444e-21, -1.978918854395746e-22,  9.229889000007139e-01, -8.668516543419028e-03,  2.877108311712890e-05,  2.701302931967954e-07, -4.133595630259316e-09,
  3.346355256195698e-12,  3.388463677255334e-13, -2.652328172268227e-15,  5.223941934684598e-17,  2.032657279114415e-18,  1.030237764536172e-20, -3.400929091595379e-22,
  1.155725163377284e+00, -9.733196517732129e-03,  6.262687645807725e-06,  5.961577116621986e-07, -3.388376311308356e-09, -5.767400571081822e-11,  7.001963803061455e-13,
  4.761817483057770e-15, -4.601604019352307e-17,  2.607996727562438e-18,  4.279755762376074e-20, -6.395801775169317e-22,  1.415577326030046e+00, -9.832171557701521e-03,
 -3.765164450869068e-05,  7.772856416644247e-07,  4.872376915745260e-09, -1.339256855097117e-10, -8.928419366633986e-13,  2.835074238222030e-14,  2.710769552329906e-16,
 -2.474406290947019e-18,  2.009920303950818e-20,  8.731209704299857e-22,  1.689525693509256e+00, -7.810966453447457e-03, -9.256265068066991e-05, -1.191524350379995e-08,
  1.684446443428291e-08,  1.538851713264824e-10, -3.163920868662152e-12, -7.476411691128481e-14,  3.978292601550968e-16,  3.370639802480997e-17,  3.105173906663759e-19,
 -7.881419655467036e-21,  1.925359955219189e+00, -2.736137705274377e-03, -6.809132328566607e-05, -1.296115954065266e-06, -1.764590397404361e-08, -9.265831388581272e-11,
  3.453662735853605e-12,  1.357140891328747e-13,  2.693575210891638e-15,  2.694491888494019e-17, -2.606734324172820e-19, -1.831048470181868e-20,  1.020116131837498e-02,
 -1.158720012676800e-04,  9.812605234625692e-07, -7.445368693397449e-09,  5.056280683996662e-11, -3.636312771841575e-13,  2.657110901477905e-15,  1.739116063954292e-17,
  9.812270389148710e-19,  1.032138094212177e-20, -1.419201804529663e-22, -8.767814418651551e-24,  4.090896874053609e-02, -4.628555202936265e-04,  3.873027812747000e-06,
 -2.871096099660787e-08,  1.868136059096405e-10, -1.275036460420005e-12,  8.783819561212055e-15,  8.869492666727801e-17,  3.824144901400524e-18,  4.322099690195527e-20,
 -5.841520785652802e-22, -3.550575658940400e-23,  9.244101873138057e-02, -1.038791302333497e-03,  8.509648338758049e-06, -6.043674390758238e-08,  3.612979655882235e-10,
 -2.200999833898789e-12,  1.317677427264447e-14,  2.648896700355299e-16,  8.333573259663637e-18,  1.033944467389241e-19, -1.363303715856928e-21, -8.173838471367826e-23,
  1.653422189589918e-01, -1.839114815103371e-03,  1.458031017940879e-05, -9.650311815425768e-08,  4.914277070432126e-10, -2.284895672549954e-12,  8.538387214689692e-15,
  6.062923063872444e-16,  1.456894855530918e-17,  1.950313494707762e-19, -2.502516457826516e-21, -1.506724567052905e-22,  2.604084979348391e-01, -2.855033108568895e-03,
  2.156646867250669e-05, -1.271680910674917e-07,  4.558609530666760e-10, -4.587819722735572e-13, -1.135166878484510e-14,  1.133826568555980e-15,  2.349214660539098e-17,
  3.173427818176713e-19, -3.982701827221023e-21, -2.478437687136589e-22,  3.787195741522391e-01, -4.070011721507409e-03,  2.862883367159240e-05, -1.377179822721035e-07,
  9.539678700359636e-11,  4.213334723658978e-12, -4.440376921408699e-14,  1.739343347670476e-15,  3.784183743121408e-17,  4.641125834281723e-19, -5.806096341482941e-21,
 -3.810327772312371e-22,  5.216762014972478e-01, -5.452943692403020e-03,  3.440619679696702e-05, -1.066505860479789e-07, -7.655547765689446e-10,  1.158931029215716e-11,
 -6.503079091969819e-14,  2.060211831183204e-15,  6.236029668469491e-17,  6.467854000956719e-19, -8.365957368041080e-21, -5.589018997636810e-22,  6.910234301763544e-01,
 -6.944314537560841e-03,  3.665569083475556e-05, -4.144971143569367e-09, -2.226451394647332e-09,  1.802536982120733e-11,  2.391430356809965e-15,  1.482940605303360e-15,
  9.933650199670911e-17,  9.922869359313915e-19, -1.324851779679781e-20, -7.964482080892864e-22,  8.887941239479005e-01, -8.426498113734672e-03,  3.161940245787791e-05,
  2.049490705652322e-07, -3.990090328584872e-09,  1.084589372463469e-11,  2.993227248604706e-13,  2.280285924205386e-16,  1.273042690437245e-16,  1.927924945919344e-18,
 -2.170814069444549e-20, -1.181857983087549e-21,  1.116936479316883e+00, -9.655482600102553e-03,  1.305630813723670e-05,  5.336724583696907e-07, -4.363463794637106e-09,
 -3.933889997035280e-11,  8.289597948409781e-13,  5.045574999507669e-15,  6.861709810099309e-17,  3.388098097303503e-18, -1.388828365390592e-20, -2.017812119424734e-21,
  1.375706881988085e+00, -1.009495943951997e-02, -2.794785319891864e-05,  8.329378421635403e-07,  2.048621683867514e-09, -1.449233364361943e-10,  1.040669385938130e-14,
  3.579593852610752e-14,  2.003280226689156e-16, -1.524973995206624e-18,  8.312031291018046e-21, -1.721953420096167e-21,  1.656806658498229e+00, -8.547254172005627e-03,
 -9.100221492432296e-05,  2.774212334542954e-07,  1.900570242490065e-08,  5.545559362247546e-11, -4.884411741509840e-12, -4.108321090023417e-14,  1.723517697036351e-15,
  3.617866928872966e-17, -2.559512632808186e-19, -1.719132694469693e-20,  1.913220522266783e+00, -3.347985961598464e-03, -8.538131274931503e-05, -1.587294526302371e-06,
 -1.830865997219338e-08,  4.634737305503745e-11,  8.580730211814864e-12,  2.334287850285303e-13,  3.218071502050472e-15, -6.756795321107101e-18, -1.621448456579050e-18,
 -4.509232418730586e-20,  9.752826350743055e-03, -1.083660708074099e-04,  8.965419701493687e-07, -6.690846668897070e-09,  4.398691527960222e-11, -2.901860044610609e-13,
  3.626689690626908e-15,  5.275524366795980e-17,  1.137946390479067e-18, -5.212421737794412e-21, -6.839444520161905e-22, -1.535959864900762e-23,  3.911740235270286e-02,
 -4.332004689977656e-04,  3.545628907504885e-06, -2.591338571127653e-08,  1.636988604948920e-10, -1.019404177142734e-12,  1.316195098436484e-14,  2.278687122418323e-16,
  4.502958914925084e-18, -2.009424339020638e-20, -2.781548693138873e-21, -6.230897379360133e-23,  8.841754918921314e-02, -9.735200253112582e-04,  7.817703296568640e-06,
 -5.498785119843450e-08,  3.212094995167180e-10, -1.762753914260829e-12,  2.476489757346353e-14,  5.723382568707131e-16,  1.002249327905262e-17, -4.317908197284131e-20,
 -6.427570564451496e-21, -1.437044029670871e-22,  1.582118946847232e-01, -1.726974182941937e-03,  1.346799607124593e-05, -8.898793091208272e-08,  4.494502001067712e-10,
 -1.818144892843276e-12,  3.287302053715454e-14,  1.150295754643162e-15,  1.784922926993436e-17, -7.477961294434387e-20, -1.184167738416854e-20, -2.651294094856539e-22,
  2.493239383076856e-01, -2.688482166680440e-03,  2.008389692230529e-05, -1.199500814219196e-07,  4.470103428651716e-10, -2.564486338678736e-13,  3.227642155511590e-14,
  2.012584759155077e-15,  2.886004860906601e-17, -1.210615245424196e-19, -1.934146695157957e-20, -4.361073154549635e-22,  3.628871667531697e-01, -3.847559446451318e-03,
  2.698802077169829e-05, -1.355562074110022e-07,  1.737153476464650e-10,  3.881817699286291e-12,  2.322514846091861e-14,  3.134287640779674e-15,  4.546473008111453e-17,
 -1.974638494084731e-19, -2.943905821831087e-20, -6.715861656371381e-22,  5.004065491291178e-01, -5.183004397535867e-03,  3.306033465273553e-05, -1.171060604768154e-07,
 -5.434594199596525e-10,  1.096415402861172e-11,  2.331192165966749e-14,  4.307082159141315e-15,  7.240391631946440e-17, -3.201070418339633e-19, -4.321804952370301e-20,
 -9.935293156203933e-22,  6.638315293709157e-01, -6.651846047800111e-03,  3.640417364561838e-05, -3.686006400821760e-08, -1.860029738725843e-09,  1.896765471425119e-11,
  9.259893882113618e-14,  5.049928147792971e-15,  1.151785881687780e-16, -4.448855331078448e-19, -6.338295241134642e-20, -1.437038486768754e-21,  8.556081108527244e-01,
 -8.164771574605883e-03,  3.370419276244624e-05,  1.432444781866202e-07, -3.698197531671760e-09,  1.862187788569082e-11,  3.713016797239205e-13,  5.125044635408403e-15,
  1.658338506666290e-16, -2.759877417053334e-19, -9.534565340480447e-20, -2.102085112307218e-21,  1.078562263712854e+00, -9.526655229933454e-03,  1.901916796041589e-05,
  4.586976432851528e-07, -4.938116814507688e-09, -1.739637419402452e-11,  1.017406893533602e-12,  8.884483916471614e-15,  1.550320155796525e-16,  6.051403525901276e-19,
 -1.355753544866352e-19, -3.402980568017850e-21,  1.334943680333404e+00, -1.027822247639314e-02, -1.785057579941692e-05,  8.428947717626605e-07, -7.626405471880225e-10,
 -1.319749906589272e-10,  1.093483716411666e-12,  4.118249597585409e-14,  1.237959720348879e-16, -3.732954520179636e-18, -1.432966128852078e-19, -5.031983068436386e-21,
  1.621190045814869e+00, -9.256744645126424e-03, -8.583341082740743e-05,  5.837515245084342e-07,  1.888631462407860e-08, -6.824743321356549e-11, -5.089872955864363e-12,
  3.137395099042890e-14,  2.648383149889391e-15,  9.780936963315736e-18, -1.066427600834203e-18, -1.743521635767681e-20,  1.898335011394601e+00, -4.112051555101420e-03,
 -1.061130849279182e-04, -1.859204732274603e-06, -1.473570154439025e-08,  3.415759691569478e-10,  1.640772670953007e-11,  3.156327108412884e-13,  1.257456428548357e-15,
 -1.188121039250754e-16, -4.111217232868992e-18, -6.149040753554239e-20,  9.333214586217248e-03, -1.015033388228214e-04,  8.202998917561879e-07, -6.028184660868502e-09,
  3.919298428539702e-11, -1.817005964628075e-13,  5.539923210127470e-15,  7.952920478728122e-17,  2.907382418346556e-19, -4.633124017735936e-20, -1.347346424403005e-21,
 -1.161378009762990e-23,  3.743942209434112e-02, -4.060361802442024e-04,  3.249772755490840e-06, -2.343770034738559e-08,  1.470645320974137e-10, -6.122430793425511e-13,
  2.126586473749439e-14,  3.334056092910411e-16,  1.098693054487100e-18, -1.872028541810958e-19, -5.474487459592301e-21, -4.719590487012896e-23,  8.464449337619166e-02,
 -9.135328868151865e-04,  7.187642760756184e-06, -5.009218401818040e-08,  2.933697933632466e-10, -9.433738750303232e-13,  4.461941971631257e-14,  8.058541039754579e-16,
  2.275483178739784e-18, -4.291581412204492e-19, -1.264444076069036e-20, -1.091650449724442e-22,  1.515128921751250e-01, -1.623381810819444e-03,  1.244225957339150e-05,
 -8.203272098791517e-08,  4.238949401313897e-10, -5.844857764014187e-13,  7.188551263369151e-14,  1.563518445444829e-15,  3.742907421865019e-18, -7.863871250166520e-19,
 -2.332597202747795e-20, -2.022366050629898e-22,  2.388824073926713e-01, -2.533447022365721e-03,  1.868743265613970e-05, -1.127759334628759e-07,  4.546919904769234e-10,
  1.288452697268909e-12,  9.961495344513912e-14,  2.678450161492901e-15,  5.822410763798855e-18, -1.286442165513285e-18, -3.826206463453174e-20, -3.345314516866381e-22,
  3.479185099559195e-01, -3.638108470950050e-03,  2.538077134152176e-05, -1.320927647630196e-07,  2.648217529299987e-10,  5.640579010763780e-12,  1.283201817080162e-13,
  4.188654889822482e-15,  9.833165707124669e-18, -1.979040397663274e-18, -5.864372046540410e-20, -5.191947290344316e-22,  4.801944106353035e-01, -4.924273547346576e-03,
  3.161034744227330e-05, -1.239713047531937e-07, -3.075555600037463e-10,  1.320787974882950e-11,  1.717262560650966e-13,  6.017852746552141e-15,  1.890633979969469e-17,
 -2.944415428523032e-18, -8.658421949985964e-20, -7.764523611259041e-22,  6.378031356669295e-01, -6.362857986605128e-03,  3.579634840189299e-05, -6.340978386866981e-08,
 -1.444983854370077e-09,  2.326784613800184e-11,  2.789620685514428e-13,  7.862355977615003e-15,  3.778620482702729e-17, -4.279748616060971e-18, -1.264239790529556e-19,
 -1.137794038930749e-21,  8.234977997377407e-01, -7.889236471614755e-03,  3.508211679198902e-05,  8.759616207496135e-08, -3.222074493904058e-09,  2.981468204273328e-11,
  5.812748493579527e-13,  9.349889233339326e-15,  6.422436316573496e-17, -5.991230080221967e-18, -1.876618418850963e-19, -1.675427006170895e-21,  1.040792890820250e+00,
 -9.353844929678367e-03,  2.404255147781647e-05,  3.783255506553525e-07, -5.018894174902216e-09,  1.054245010033358e-11,  1.329698703750500e-12,  1.284650058612087e-14,
  4.213620043955943e-17, -7.876373423208685e-18, -2.840131861000697e-19, -2.715999446640335e-21,  1.293608697959582e+00, -1.038096493777095e-02, -7.890450446055045e-06,
  8.114004703165920e-07, -3.044696312258086e-09, -9.162150919306774e-11,  2.271290376420372e-12,  4.142256609693823e-14, -1.715528391615290e-16, -1.430337525451132e-17,
 -3.848827310200440e-19, -4.865784175063367e-21,  1.582841161681243e+00, -9.910399451024400e-03, -7.708061566394830e-05,  8.688477494560920e-07,  1.642064293884300e-08,
 -1.702893826246512e-10, -3.038575328308769e-12,  1.121921264431856e-13,  2.074861945926417e-15, -4.502596038976784e-17, -1.567081344322437e-18, -2.777083460867722e-21,
  1.880042915704626e+00, -5.053532933294799e-03, -1.295351503341124e-04, -2.015904236321391e-06, -3.248274449430159e-09,  8.407519810540633e-10,  2.491139200111700e-11,
  2.509748756729409e-13, -6.533525960582572e-15, -3.244932466886669e-16, -5.572651604056709e-18,  2.335679051002875e-20,  8.939882636840922e-03, -9.521985755599784e-05,
  7.516297440659005e-07, -5.422192457677537e-09,  3.706640422100966e-11, -2.290053531469746e-14,  7.568098757935063e-15,  5.112550184112207e-17, -2.409261880804931e-18,
 -1.031569206701695e-19, -1.238667425490472e-21,  2.373441750764940e-23,  3.586554796420125e-02, -3.811237409853921e-04,  2.982332932408232e-06, -2.115174575024626e-08,
  1.406679985860011e-10,  6.322770814489668e-15,  2.976274265094483e-14,  2.159521394583753e-16, -9.834795248318510e-18, -4.181715274544249e-19, -5.038760690886897e-21,
  9.615715490831238e-23,  8.110166839306331e-02, -8.583573909463481e-04,  6.614286745678671e-06, -4.548342219182376e-08,  2.870073149285454e-10,  3.885504800504488e-13,
  6.514655473275699e-14,  5.280127742461076e-16, -2.286525185039761e-17, -9.629977749437951e-19, -1.166306291874461e-20,  2.210669008839972e-22,  1.452123690594244e-01,
 -1.527666211299202e-03,  1.149851911214178e-05, -7.523545367030805e-08,  4.329382371640776e-10,  1.646728106235594e-12,  1.117310629320328e-13,  1.039369509785153e-15,
 -4.245796646823042e-17, -1.772417608983494e-18, -2.158912962557016e-20,  4.053249395289265e-22,  2.290392256552184e-01, -2.389234201418352e-03,  1.737911220784388e-05,
 -1.051395898335049e-07,  5.103303451948951e-10,  4.546342711858110e-12,  1.680353947701615e-13,  1.810251146085164e-15, -6.987276737634907e-17, -2.907043731242421e-18,
 -3.558947997892471e-20,  6.599333807994516e-22,  3.337622439686396e-01, -3.441320863467957e-03,  2.382545418045707e-05, -1.267462878104814e-07,  4.177727416471925e-10,
  1.008036512100272e-11,  2.358874233725721e-13,  2.882224492831666e-15, -1.065269279574278e-16, -4.469746721042092e-18, -5.491035375370077e-20,  1.002415491735396e-21,
  4.609935707325409e-01, -4.677403230392826e-03,  3.010276529000514e-05, -1.264979814130419e-07,  1.131133270532569e-11,  1.929658875490876e-11,  3.277208354339747e-13,
  4.215432122708171e-15, -1.538333823090214e-16, -6.633379402988906e-18, -8.171130732636384e-20,  1.462406859636421e-21,  6.129191213397275e-01, -6.079885799972669e-03,
  3.491345339297001e-05, -8.236777696524696e-08, -8.948753872432006e-10,  3.256223134184872e-11,  4.855101854597012e-13,  5.566665816626024e-15, -2.138661825715688e-16,
 -9.679618980385066e-18, -1.202549586354612e-19,  2.095050439483723e-21,  7.925076542504368e-01, -7.605200634497658e-03,  3.584633120772880e-05,  4.166140718706847e-08,
 -2.464912531230228e-09,  4.688526706928630e-11,  8.284884415281304e-13,  6.410500577770966e-15, -2.963947310536204e-16, -1.402163294247746e-17, -1.801088060589779e-19,
  3.006748740795983e-21,  1.003789053466398e+00, -9.144682136728205e-03,  2.811355072324962e-05,  3.015648402960934e-07, -4.460406448107926e-09,  4.657911491618140e-11,
  1.649016806005439e-12,  7.306271521461374e-15, -4.627004854875699e-16, -2.019283524193802e-17, -2.810079894547585e-19,  4.334865893522963e-21,  1.252018931207971e+00,
 -1.040608761059174e-02,  1.504223166330169e-06,  7.513636263133942e-07, -4.243710398554646e-09, -2.440341498889811e-11,  3.253760586624916e-12,  2.441343409338398e-14,
 -9.974323795292467e-16, -3.183578234992688e-17, -4.129309955882666e-19,  6.081410061330422e-21,  1.542038245319651e+00, -1.048115208097296e-02, -6.520009402738805e-05,
  1.101549062160173e-06,  1.257089704467084e-08, -1.999441526237010e-10,  7.031684458201797e-13,  1.407580647019148e-13, -6.351743932712110e-16, -1.023768338620403e-16,
 -1.077206842995331e-18,  2.797668134714100e-20,  1.857603728025792e+00, -6.185962466415742e-03, -1.533725389263105e-04, -1.899060101904932e-06,  1.994156900107061e-08,
  1.487115892530555e-09,  2.697950383909638e-11, -1.820461410053732e-13, -2.135594338204124e-14, -4.550023108334088e-16,  1.229703659350146e-18,  3.199501781476992e-19,
  8.570631466268890e-03, -8.945697185313672e-05,  6.901395135681963e-07, -4.822642059884023e-09,  3.848008296416850e-11,  1.634984066977399e-13,  7.311279139240828e-15,
 -9.174537234803807e-17, -6.582879323172645e-18, -1.115308729922811e-19,  1.376886027813757e-21,  9.887507039950506e-23,  3.438721714990043e-02, -3.582418309129146e-04,
  2.742149667008142e-06, -1.886000907287699e-08,  1.481803134939781e-10,  7.426152875362160e-13,  2.893378668432880e-14, -3.655278163960870e-16, -2.676573469258510e-17,
 -4.527423560443522e-19,  5.572380845500616e-21,  4.013908053428247e-22,  7.777072238331012e-02, -8.075470753328722e-04,  6.096579208056339e-06, -4.074108362653303e-08,
  3.110381549616368e-10,  2.012214906317570e-12,  6.399667069944839e-14, -8.184759058061373e-16, -6.189847594247400e-17, -1.044901462213514e-18,  1.279312556645054e-20,
  9.261762470097529e-22,  1.392801334095710e-01, -1.439168116237892e-03,  1.063883316958130e-05, -6.789293974803096e-08,  4.939840329665756e-10,  4.460283736014486e-12,
  1.113311788104752e-13, -1.451885327637152e-15, -1.143982728485576e-16, -1.928664347512280e-18,  2.342755290446207e-20,  1.707805731815892e-21,  2.197525709840773e-01,
 -2.255100797638656e-03,  1.617017248707199e-05, -9.601640316479723e-08,  6.439456927305072e-10,  8.830255382676321e-12,  1.702166414499473e-13, -2.285095262892959e-15,
 -1.880412958503981e-16, -3.173917370008307e-18,  3.812538726264904e-20,  2.803473571719627e-21,  3.203687183313851e-01, -3.256669995994225e-03,  2.235230821579951e-05,
 -1.181229897468315e-07,  6.798625340458508e-10,  1.616410237847850e-11,  2.423985735951260e-13, -3.388160733869894e-15, -2.884887820132707e-16, -4.898553595719924e-18,
  5.793799117303341e-20,  4.306108734801964e-21,  4.427560349027987e-01, -4.442617679050622e-03,  2.860007445135847e-05, -1.227750884687334e-07,  4.815773421590391e-10,
  2.778327522205043e-11,  3.375308617212652e-13, -4.958021829438392e-15, -4.243340345981917e-16, -7.303548412901353e-18,  8.454648339515426e-20,  6.371163531699919e-21,
  5.891516604828348e-01, -5.804721433001398e-03,  3.386277564011852e-05, -9.080804060235704e-08, -1.199469992661864e-10,  4.496279146178162e-11,  4.881328504129766e-13,
 -7.491483000203769e-15, -6.097797336143850e-16, -1.073607383697782e-17,  1.205756375362377e-19,  9.275903851419792e-21,  7.626627158025131e-01, -7.317022206338046e-03,
  3.614418674342369e-05,  1.084015234924114e-08, -1.321501325603712e-09,  6.734430219854284e-11,  7.916695423380522e-13, -1.212301667982754e-14, -8.742535823049230e-16,
 -1.578730079731414e-17,  1.699057915795775e-19,  1.356307220686171e-20,  9.676814590440100e-01, -8.906426887329656e-03,  3.134193491800409e-05,  2.398315056263111e-07,
 -3.128226979868539e-09,  8.620161126478825e-11,  1.524877799600308e-12, -2.068699444211968e-14, -1.308647259331433e-15, -2.339312468556237e-17,  2.397475213624054e-19,
  2.040284401801401e-20,  1.210474109241582e+00, -1.035915134759633e-02,  1.011127537135567e-05,  6.839556117606968e-07, -3.918993437773372e-09,  5.713003478808075e-11,
  3.300379397789788e-12, -2.811678649069895e-14, -2.315768699064493e-15, -3.613357081010612e-17,  3.931395410425697e-19,  3.249977335311428e-20,  1.499158594987083e+00,
 -1.094675082611508e-02, -5.090023020833682e-05,  1.272862009998140e-06,  9.032842276414401e-09, -1.416993649181110e-10,  3.764177808768078e-12,  5.632508626471193e-14,
 -4.681011139929435e-15, -1.075693821246581e-16,  1.173969289933550e-18,  7.633534697472501e-20,  1.830272496677672e+00, -7.496199462849623e-03, -1.731598961297330e-04,
 -1.310181889047590e-06,  5.528654359878094e-08,  1.982239004116145e-09,  1.011105189891472e-11, -1.084132451399704e-12, -3.251042593524916e-14, -2.416301762478912e-17,
  2.215811670941359e-17,  5.547806646042061e-19,  8.223494464775072e-03, -8.415657174643404e-05,  6.360971784701811e-07, -4.172610709669144e-09,  4.316004478756237e-11,
  2.812422490515531e-13,  1.320618493587133e-15, -3.463409086253854e-16, -8.390458499672308e-18,  4.734931884554124e-20,  6.747168920003400e-21,  1.194490502319901e-22,
  3.299674952826916e-02, -3.371682600168601e-04,  2.530653134311554e-06, -1.633796741749303e-08,  1.685922331004835e-10,  1.204848910845049e-12,  4.788418260726337e-15,
 -1.400526811069792e-15, -3.411298929397889e-17,  1.918097835208539e-19,  2.739368359183296e-20,  4.859159666204356e-22,  7.463510711279832e-02, -7.606418669910406e-04,
  5.639112397929312e-06, -3.537127924062507e-08,  3.635009429236655e-10,  3.020261696618059e-12,  8.915079478438394e-15, -3.211669841756451e-15, -7.889790052630620e-17,
  4.407760892850058e-19,  6.322472684032380e-20,  1.125203528749620e-21,  1.336887221056723e-01, -1.357174326925779e-03,  9.874897122281230e-06, -5.915236481931679e-08,
  6.042426350073957e-10,  6.177079212798259e-12,  1.123376342148198e-14, -5.875360031373067e-15, -1.459063801200255e-16,  8.071097680445953e-19,  1.166401188441437e-19,
  2.085641192423391e-21,  2.109838598984463e-01, -2.130158349729411e-03,  1.508624986591401e-05, -8.411365304220542e-08,  8.523175636819109e-10,  1.137927895431126e-11,
  8.480842000313274e-15, -9.561249219157164e-15, -2.402324534050909e-16,  1.310024256118158e-18,  1.916386868130866e-19,  3.448186743072247e-21,  3.076909936849840e-01,
 -3.083310131045512e-03,  2.101165394153664e-05, -1.043957184725876e-07,  1.047643952493819e-09,  1.966330947460179e-11, -2.622807171406958e-15, -1.457094975258572e-14,
 -3.698336712125912e-16,  1.976720174547832e-18,  2.947525495360717e-19,  5.346257579590039e-21,  4.254340782460427e-01, -4.219534564750322e-03,  2.719256597905480e-05,
 -1.102619568207855e-07,  1.098177798128007e-09,  3.247922438121175e-11, -2.269322343094641e-14, -2.146342309885993e-14, -5.473300851904522e-16,  2.846527325059354e-18,
  4.368884880317539e-19,  8.006001974489031e-21,  5.664677263648460e-01, -5.538138690124050e-03,  3.279300219400184e-05, -8.501168429196762e-08,  8.667505794951609e-10,
  5.165407013703132e-11, -4.105931829558854e-14, -3.134154816471832e-14, -7.939637619836136e-16,  3.986637997065688e-18,  6.371914655881165e-19,  1.183472193853916e-20,
  7.339733927684680e-01, -7.027599588323707e-03,  3.619473016377017e-05,  1.325257073049542e-09,  1.695978034973879e-10,  7.866378726338191e-11, -7.878139315681593e-15,
 -4.653691008228725e-14, -1.150650123113912e-15,  5.568395841915340e-18,  9.320212573276191e-19,  1.763697502052758e-20,  9.325744357896739e-01, -8.644887783361825e-03,
  3.398217456730105e-05,  2.052695613588400e-07, -1.112503617579274e-09,  1.104525769107624e-10,  2.575188314364732e-13, -7.215541380529427e-14, -1.721457893205150e-15,
  8.278007759860326e-18,  1.400285648197505e-18,  2.720578492493422e-20,  1.169249907295285e+00, -1.024638443235572e-02,  1.799304163127369e-05,  6.342641725367202e-07,
 -2.095803350579344e-09,  1.175028998286743e-10,  1.320291788417365e-12, -1.167316723006785e-13, -2.919823375472431e-15,  1.529104392753983e-17,  2.280823423046680e-18,
  4.498730069935161e-20,  1.454657151933261e+00, -1.129058057148454e-02, -3.483571384535121e-05,  1.399814508588913e-06,  7.129087800260128e-09, -5.243714106424173e-11,
  2.768545480099307e-12, -1.390316061663652e-13, -6.788098406281217e-15,  1.769548609936137e-17,  5.211985130863854e-18,  8.991918634331517e-20,  1.797442804510955e+00,
 -8.926290415895424e-03, -1.822567601169237e-04, -1.076314942108688e-07,  9.431403602553454e-08,  1.749483775106701e-09, -3.346932814195961e-11, -1.925256333039768e-12,
 -1.252497096237765e-14,  1.222303242514874e-15,  3.436996001795523e-17, -2.441567738590450e-19,  7.896745742946588e-03, -7.925591987929085e-05,  5.903501736918288e-07,
 -3.439131941544245e-09,  4.817370965346492e-11,  1.698787694635744e-13, -1.145968804166707e-14, -5.275535430558593e-16, -9.474556303737924e-19,  3.753148326549120e-19,
  7.902751878194910e-21, -1.192631646999428e-22,  3.168739236704648e-02, -3.176596030291325e-04,  2.351556375238250e-06, -1.345686090430301e-08,  1.900820248939307e-10,
  7.406570828340528e-13, -4.696548755789236e-14, -2.137927237724149e-15, -3.897735135754207e-18,  1.524360350941873e-18,  3.213411078751006e-20, -4.835243096780437e-22,
  7.168022274962138e-02, -7.171234220461846e-04,  5.251489056961795e-06, -2.909572914036306e-08,  4.174197330061337e-10,  1.903947541755141e-12, -1.100342764102900e-13,
 -4.919605746432146e-15, -9.183363016956263e-18,  3.520239480879086e-18,  7.435714155421422e-20, -1.113263231558555e-21,  1.284137717182800e-01, -1.280840939122328e-03,
  9.227026128459231e-06, -4.854623584831641e-08,  7.146718762156994e-10,  4.007776421953075e-12, -2.070032801035393e-13, -9.039991252460148e-15, -1.738702156794315e-17,
  6.498731433316803e-18,  1.376888296815255e-19, -2.046531948432479e-21,  2.026985634220219e-01, -2.013257119117874e-03,  1.416597069696069e-05, -6.875035143925624e-08,
  1.056162251420395e-09,  7.604266297078757e-12, -3.478097217434698e-13, -1.478407176577563e-14, -2.937947725081876e-17,  1.068443185536864e-17,  2.273513891118072e-19,
 -3.346354321787005e-21,  2.956864462723519e-01, -2.919913849633521e-03,  1.987201250807332e-05, -8.465176080322443e-08,  1.400929526948736e-09,  1.352401008825489e-11,
 -5.471787211059690e-13, -2.263251348650196e-14, -4.635458631915081e-17,  1.644134085813620e-17,  3.519367789427239e-19, -5.115175600822883e-21,  4.089831262809669e-01,
 -4.006939881201438e-03,  2.599554923884156e-05, -8.776145096875232e-08,  1.684297271689068e-09,  2.297357820792906e-11, -8.261202035605814e-13, -3.342510072026027e-14,
 -6.981959446327029e-17,  2.437422958451134e-17,  5.259221747610553e-19, -7.524094831436597e-21,  5.448338326180421e-01, -5.279562990339872e-03,  3.188905622205549e-05,
 -6.327898647854660e-08,  1.805331915694680e-09,  3.759703750759158e-11, -1.212766265444152e-12, -4.872872230980463e-14, -1.014740276596006e-16,  3.555061736967006e-17,
  7.750089429500208e-19, -1.087736093250668e-20,  7.064424304768663e-01, -6.737814988667636e-03,  3.627741952165114e-05,  1.610202991882545e-08,  1.615763168259300e-09,
  5.915246266818795e-11, -1.737610573263953e-12, -7.174698197476435e-14, -1.432706272169339e-16,  5.206132315603654e-17,  1.148601459875278e-18, -1.577612537516031e-20,
  8.985539921594458e-01, -8.363313819393202e-03,  3.641046505526769e-05,  2.046865421914769e-07,  9.652747114322661e-10,  8.687621347390930e-11, -2.400739271808881e-12,
 -1.097830066638354e-13, -2.031008478304150e-16,  7.877372101323529e-17,  1.753480039562214e-18, -2.364449181009623e-20,  1.128599899492053e+00, -1.007238193278380e-02,
  2.548267770764003e-05,  6.199655838054432e-07,  2.565372032889894e-10,  1.006317926157732e-10, -3.028975264364159e-12, -1.806210428505253e-13, -3.736788413457808e-16,
  1.307172880119458e-16,  2.875699957714836e-18, -3.935654944288841e-20,  1.409046496098652e+00, -1.150020061476481e-02, -1.738109354801414e-05,  1.507357962264710e-06,
  6.310887668878762e-09, -5.506296766660811e-11, -3.746094004809119e-12, -2.998384631224324e-13, -1.734116039958162e-15,  2.697518925819365e-16,  6.025733113665714e-18,
 -9.721995320408076e-20,  1.758852607594515e+00, -1.036157395708002e-02, -1.735316368032570e-04,  1.619129405993165e-06,  1.168743823297219e-07,  3.031342133579230e-10,
 -8.474532857840671e-11, -1.406871038472945e-12,  4.917515191591550e-14,  1.891515623227537e-15, -1.267589544015314e-17, -1.788041006120033e-18,  7.588924979040426e-03,
 -7.468495701564438e-05,  5.537554964874057e-07, -2.661020933329085e-09,  4.766649080763764e-11, -2.715548299817079e-13, -2.428316291259553e-14, -2.979019233101899e-16,
  1.593572078241664e-17,  4.721772973620307e-19, -5.596567293183361e-21, -4.513829609016906e-22,  3.045342998854002e-02, -2.994407507168346e-04,  2.208557719294350e-06,
 -1.037816819015834e-08,  1.889444201716899e-10, -1.060930440305539e-12, -9.893542901335961e-14, -1.206459212273667e-15,  6.470267383702719e-17,  1.919177496410308e-18,
 -2.272256976017885e-20, -1.835771834434207e-21,  6.889370426165463e-02, -6.763928338208005e-04,  4.943078644659317e-06, -2.230162430569630e-08,  4.183216488865018e-10,
 -2.289033147052546e-12, -2.296306387348342e-13, -2.773118234787605e-15,  1.493513356495640e-16,  4.437581214273331e-18, -5.244552760064709e-20, -4.249351823239488e-21,
  1.234346306083411e-01, -1.209156641803485e-03,  8.714619380480075e-06, -3.682427361454210e-08,  7.253541402649466e-10, -3.813040356046387e-12, -4.267807499154385e-13,
 -5.087755191920257e-15,  2.755977899475084e-16,  8.207348527894704e-18, -9.676158053539106e-20, -7.872599643763333e-21,  1.948673817025998e-01, -1.902934171464377e-03,
  1.344552958446232e-05, -5.122618585190245e-08,  1.092396849411070e-09, -5.409536788154623e-12, -7.072445203810931e-13, -8.303714076251262e-15,  4.530252407135830e-16,
  1.352740864042487e-17, -1.590105505455579e-19, -1.300855194672736e-20,  2.843188674722493e-01, -2.764605115476713e-03,  1.899671617846810e-05, -6.099721185192075e-08,
  1.490512706922562e-09, -6.753036425902232e-12, -1.097387315366131e-12, -1.268054966144025e-14,  6.974463480683462e-16,  2.088427337629110e-17, -2.447031236372667e-19,
 -2.015784047121742e-20,  3.933653077649768e-01, -3.802703545418133e-03,  2.511492220088759e-05, -5.852530767200754e-08,  1.872279540042168e-09, -7.405322339039512e-12,
 -1.638489334229196e-12, -1.867427907029513e-14,  1.035695520184480e-15,  3.108801481749819e-17, -3.632451808439421e-19, -3.017048842422057e-20,  5.242217492305324e-01,
 -5.026952280261032e-03,  3.132146493539009e-05, -3.041311954611251e-08,  2.159481089270413e-09, -6.888607295105222e-12, -2.396395262855711e-12, -2.714326698287645e-14,
  1.516094015779481e-15,  4.556268988108926e-17, -5.319030971128212e-19, -4.457733227030576e-20,  6.800735493597118e-01, -6.446311400100100e-03,  3.665562333543218e-05,
  4.848533655976182e-08,  2.224725909884071e-09, -5.179116123521190e-12, -3.478675257214502e-12, -3.986773720772017e-14,  2.233827612359902e-15,  6.704457488090340e-17,
 -7.863836091589547e-19, -6.640191428192509e-20,  8.656993734053642e-01, -8.061835990259739e-03,  3.900376174817578e-05,  2.298799350365229e-07,  1.886471979058159e-09,
 -5.338618424240087e-12, -5.062468235711447e-12, -6.100792299174819e-14,  3.401277954857233e-15,  1.015914693099140e-16, -1.215804133660201e-18, -1.025127316661025e-19,
  1.088765469563856e+00, -9.838573506968739e-03,  3.299589344453264e-05,  6.345401429384083e-07,  1.146514063098764e-09, -2.909536132253753e-11, -7.420968890125723e-12,
 -1.011807142885416e-13,  5.573784210037534e-15,  1.662470753347912e-16, -2.119513253625355e-18, -1.725267380963145e-19,  1.362884411096718e+00, -1.156530923872493e-02,
  1.253090553959471e-06,  1.591798805149404e-06,  3.641283272180605e-09, -2.416624433493119e-10, -1.120356611141854e-11, -1.675334955499061e-13,  1.041637959781974e-14,
  3.310907035599965e-16, -5.026427870469525e-18, -3.655591116725814e-19,  1.714797379687957e+00, -1.164062709844057e-02, -1.430673027985132e-04,  3.417659190386732e-06,
  1.005680184235584e-07, -1.970141823787135e-09, -9.348270150945205e-11,  1.001265963522113e-12,  8.903222797757852e-14, -1.465481828190751e-16, -8.057584538939277e-17,
 -5.983830149035092e-19,  7.298860490498027e-03, -7.037030449144588e-05,  5.261125706564853e-07, -1.975092075225817e-09,  3.608752200464945e-11, -8.836205569273716e-13,
 -2.346114046022126e-14,  4.026604619359671e-16,  2.430390738010252e-17, -1.149070594841994e-19, -2.118646506292206e-20, -1.007429639789981e-22,  2.929028449492901e-02,
 -2.822215363084189e-04,  2.101020599584228e-06, -7.660369443106712e-09,  1.426896619654525e-10, -3.553123895112334e-12, -9.550196273443566e-14,  1.638863969547990e-15,
  9.871658802877471e-17, -4.674668199382876e-19, -8.615639020457116e-20, -4.101359619161756e-22,  6.626568075299434e-02, -6.378104095751139e-04,  4.713092267154283e-06,
 -1.628916919740028e-08,  3.144757231890588e-10, -8.067788900359288e-12, -2.213424523776648e-13,  3.797919671130578e-15,  2.279994071941911e-16, -1.082854805869315e-18,
 -1.993929218650989e-19, -9.508085977107464e-22,  1.187349054527538e-01, -1.141019523746395e-03,  8.337960432396006e-06, -2.641262142807427e-08,  5.412843757796148e-10,
 -1.453916214785715e-11, -4.105766678744018e-13,  7.045633344094319e-15,  4.210382514788385e-16, -2.009267649209002e-18, -3.692951219075163e-19, -1.764568532688616e-21,
  1.874672810769876e-01, -1.797546128710886e-03,  1.292899399642114e-05, -3.558007724673902e-08,  8.057608178230612e-10, -2.315693967161578e-11, -6.787816209008983e-13,
  1.165573257917857e-14,  6.926312088404182e-16, -3.330250085927316e-18, -6.099323751436513e-19, -2.919688561404329e-21,  2.735603053147505e-01, -2.615173781557249e-03,
  1.839854329668185e-05, -3.972794177039993e-08,  1.078916505440483e-09, -3.424485093779308e-11, -1.050427287764713e-12,  1.806943666259564e-14,  1.066951019923770e-15,
 -5.190265714463019e-18, -9.444716228713816e-19, -4.523748446885518e-21,  3.785525703423239e-01, -3.604109827295923e-03,  2.458025124061448e-05, -3.198893097090271e-08,
  1.311752580261760e-09, -4.838906984712467e-11, -1.564099624521061e-12,  2.701063796186025e-14,  1.584432649173503e-15, -7.850310745524527e-18, -1.412079298206608e-18,
 -6.745240132723846e-21,  5.046135609966794e-01, -4.777284605981142e-03,  3.114871822748632e-05, -2.310610756478437e-10,  1.418935104231206e-09, -6.676644365766014e-11,
 -2.282037524946686e-12,  3.972351861339249e-14,  2.316464970918397e-15, -1.182043617157266e-17, -2.082914712379082e-18, -9.846679965115082e-21,  6.548792839191757e-01,
 -6.150172539893996e-03,  3.743227760651313e-05,  7.850718347692514e-08,  1.245802044104268e-09, -9.211414302303242e-11, -3.307673681752273e-12,  5.851763723172471e-14,
  3.400138192768723e-15, -1.821893123443894e-17, -3.094663911322640e-18, -1.421408446222300e-20,  8.340942178992949e-01, -7.738311392259170e-03,  4.191754514971830e-05,
  2.522865667156826e-07,  5.023146435673315e-10, -1.322127851776047e-10, -4.814986999364248e-12,  8.825448348454955e-14,  5.132699894301083e-15, -2.993374456115830e-17,
 -4.757626944787879e-18, -2.020855083018249e-20,  1.049987633818882e+00, -9.543946765209298e-03,  4.066826980588785e-05,  6.380136849716714e-07, -1.321592177695627e-09,
 -2.164629041129120e-10, -7.059324521884885e-12,  1.419948545910966e-13,  8.277324422220136e-15, -5.647609914221688e-17, -7.942676196209792e-18, -2.616055616385798e-20,
  1.316764988821515e+00, -1.147835472071728e-02,  2.049496049440410e-05,  1.595987949219435e-06, -4.026914767079728e-09, -5.203104279040609e-10, -9.889528796327640e-12,
  2.876748678379960e-13,  1.513363677879039e-14, -1.468586389402439e-16, -1.618085903825204e-17, -1.627582512804430e-21,  1.666239293511142e+00, -1.259748002749502e-02,
 -9.405662181789129e-05,  4.604664083963185e-06,  4.256153915344822e-08, -3.582617308161752e-09, -3.078432495991103e-11,  3.154207476144735e-12,  2.884017397455070e-14,
 -2.859630974659219e-15, -3.061962592861688e-17,  2.606363326682549e-18,  7.025658833564156e-03, -6.624790929926910e-05,  5.052076359609100e-07, -1.564356150269328e-09,
  1.411444943675828e-11, -1.233122117314271e-12, -3.063692622398938e-15,  9.568574939956509e-16,  6.111734518633528e-18, -8.029921484985383e-19, -7.440909124893920e-21,
  6.593998343574952e-22,  2.819447926822941e-02, -2.657483653644587e-04,  2.020103096007773e-06, -6.048777311005517e-09,  5.411630264532818e-11, -4.976643594430851e-12,
 -1.256797469551758e-14,  3.888718158831317e-15,  2.473506916461970e-17, -3.264922404983762e-18, -3.019930063892061e-20,  2.684141523534034e-21,  6.378871312953420e-02,
 -6.008159159298242e-04,  4.541684616083804e-06, -1.278704607415907e-08,  1.125199863442139e-10, -1.136995922751271e-11, -2.947686342566247e-14,  8.989563261640412e-15,
  5.677010227826153e-17, -7.554084100112591e-18, -6.964392741883237e-20,  6.222558366616684e-21,  1.143024022318836e-01, -1.075461556492403e-03,  8.061887474270020e-06,
 -2.052111858827721e-08,  1.751575776086845e-10, -2.067092488186283e-11, -5.547383941086584e-14,  1.661969185887689e-14,  1.038433185253721e-16, -1.398572089118691e-17,
 -1.282770375916634e-19,  1.155408373045938e-20,  1.804815130197515e-01, -1.695643078790932e-03,  1.256164058391449e-05, -2.712519155884652e-08,  2.180134001993951e-10,
 -3.330421331643234e-11, -9.304997869790080e-14,  2.737448008398968e-14,  1.685238133417524e-16, -2.308774935777650e-17, -2.101234962493426e-19,  1.915071292738337e-20,
  2.633913033835051e-01, -2.469658742087699e-03,  1.799897250031783e-05, -2.907754334293583e-08,  2.011604887468433e-10, -4.995627564829687e-11, -1.455146648798563e-13,
  4.221522426985696e-14,  2.546815853750679e-16, -3.572898382856776e-17, -3.214076252401431e-19,  2.979842844712588e-20,  3.645273759710501e-01, -3.408731619886938e-03,
  2.428470449379021e-05, -2.042966999451020e-08,  5.693758599818185e-11, -7.176919496395393e-11, -2.165717335452719e-13,  6.272320291282800e-14,  3.680319720856686e-16,
 -5.337670576744225e-17, -4.716814239485500e-19,  4.484517798141937e-20,  4.860031741980437e-01, -4.527838364420448e-03,  3.122983178424017e-05,  9.331698053178967e-09,
 -3.344489305428913e-10, -1.007732240306226e-10, -3.081187644863961e-13,  9.162498594883471e-14,  5.168006686337789e-16, -7.865335726675544e-17, -6.755804793679826e-19,
  6.674831674061235e-20,  6.308837396191078e-01, -5.846771540685245e-03,  3.842121468541671e-05,  8.015072355751059e-08, -1.199721207432936e-09, -1.409901397818931e-10,
 -4.107752920118197e-13,  1.339889565868946e-13,  7.116002323736551e-16, -1.166789547955974e-16, -9.547796887806520e-19,  1.004317890624618e-19,  8.038307099830194e-01,
 -7.390960958564351e-03,  4.488865299506233e-05,  2.340393570100503e-07, -3.010412507983925e-09, -2.018454203799224e-10, -4.608424297395631e-13,  2.003576800861642e-13,
  9.576143290774398e-16, -1.788470666925268e-16, -1.334155040602985e-18,  1.572544121867826e-19,  1.012510022107046e+00, -9.188715503845209e-03,  4.802977150353408e-05,
  5.748737927168054e-07, -6.884163619352631e-09, -3.122591202815661e-10, -1.009437488627026e-13,  3.169019273904929e-13,  1.178282254443020e-15, -2.960749252301128e-16,
 -1.774423032913825e-18,  2.698209003124158e-19,  1.271298110743999e+00, -1.123974034455744e-02,  3.888468470506373e-05,  1.439030086839965e-06, -1.590763987932432e-08,
 -6.153874619588046e-10,  3.323895912199908e-12,  5.754354039636193e-13,  1.563064319900233e-16, -5.831853599001383e-16, -1.224395500383189e-18,  5.729827520606742e-19,
  1.614703443204530e+00, -1.312288643120067e-02, -3.712548077371965e-05,  4.702936218346196e-06, -2.920208101562087e-08, -3.255110465058694e-09,  5.464986342344921e-11,
  2.427362416020209e-12, -6.760000063821374e-14, -1.778551499982571e-15,  7.413598994040825e-17,  1.229308560129828e-18,  6.768634599191854e-03, -6.227935285662031e-05,
  4.869886293387897e-07, -1.530663282208629e-09, -9.115007417647527e-12, -9.903414343838099e-13,  2.205498731914376e-14,  6.917746798720250e-16, -2.089283072913450e-17,
 -5.111683033564489e-19,  1.974538888840987e-20,  3.581617030214906e-22,  2.716335864866521e-02, -2.498706478694654e-04,  1.949477177393090e-06, -5.958363714705906e-09,
 -3.962299139847299e-11, -3.993181888265450e-12,  8.946537105177005e-14,  2.807877913072754e-15, -8.499890054450425e-17, -2.074415676726277e-18,  8.038497403039476e-20,
  1.453859787416321e-21,  6.145716523439022e-02, -5.650827154200481e-04,  4.391648829159708e-06, -1.275838085645254e-08, -1.015960908654136e-10, -9.108268427398330e-12,
  2.061922571352263e-13,  6.476755967549539e-15, -1.968571813432617e-16, -4.783523415323473e-18,  1.863921087256559e-19,  3.353862557163650e-21,  1.101280128100953e-01,
 -1.011934925569393e-03,  7.819007301734967e-06, -2.093941015325131e-08, -2.139608560945343e-10, -1.651747944245702e-11,  3.796692965371011e-13,  1.193460189307954e-14,
 -3.649769309490819e-16, -8.811307888422085e-18,  3.461955034657712e-19,  6.180713355775832e-21,  1.738978830115079e-01, -1.596442771035882e-03,  1.223541022877772e-05,
 -2.882548759122585e-08, -4.085011718934975e-10, -2.651357100517723e-11,  6.223906218921959e-13,  1.956549154686687e-14, -6.036237844227910e-16, -1.443970004545542e-17,
  5.740348076534702e-19,  1.013285495734063e-20,  2.537984201118512e-01, -2.327083126420946e-03,  1.763687159544170e-05, -3.363884060748978e-08, -7.375380802885621e-10,
 -3.955432686384334e-11,  9.550539968613013e-13,  2.997503492910598e-14, -9.363050745221313e-16, -2.211520946626414e-17,  8.936218784135782e-19,  1.552053011541648e-20,
  3.512793314718228e-01, -3.215527064023691e-03,  2.399837047390336e-05, -3.068631051842306e-08, -1.288977520524246e-09, -5.636725483904959e-11,  1.413009589021936e-12,
  4.412585244399814e-14, -1.402772177483273e-15, -3.255151381797028e-17,  1.345600393182994e-18,  2.282842974841253e-20,  4.683918788957034e-01, -4.277794196148677e-03,
  3.124428292247339e-05, -1.167326314726171e-08, -2.217703755846088e-09, -7.816824332208557e-11,  2.060626682883458e-12,  6.359576112317538e-14, -2.074162045919706e-15,
 -4.692589831008707e-17,  2.003944904019813e-18,  3.282308220931508e-20,  6.081167444653042e-01, -5.536092352696456e-03,  3.917654791307464e-05,  3.913244300488520e-08,
 -3.817640282557558e-09, -1.071783747400934e-10,  3.027494898878847e-12,  9.109321250166183e-14, -3.089580349394475e-15, -6.727094908583414e-17,  3.016312657912013e-18,
  4.671787228034689e-20,  7.750013177070820e-01, -7.021737932556213e-03,  4.727815438157743e-05,  1.548691845493114e-07, -6.711091023490927e-09, -1.480953850524463e-10,
  4.617310427023548e-12,  1.315093260577537e-13, -4.759777299192403e-15, -9.724889041887515e-17,  4.720411729336758e-18,  6.625019259853203e-20,  9.765640745993619e-01,
 -8.779216522212767e-03,  5.406901150082038e-05,  4.176013452668223e-07, -1.245451285708634e-08, -2.136972507321250e-10,  7.736021982018216e-12,  1.936341568806992e-13,
 -7.941615209758366e-15, -1.430191420269973e-16,  8.066777197148130e-18,  9.172131749350178e-20,  1.227063396530905e+00, -1.086479713814627e-02,  5.424825864046189e-05,
  1.095626307484946e-06, -2.618933472825960e-08, -3.602478388926843e-10,  1.655860249417200e-11,  2.819566953322232e-13, -1.611820825265174e-14, -1.970619143521086e-16,
  1.681420281725123e-17,  8.819976885410778e-20,  1.561958275632453e+00, -1.320648219392121e-02,  1.464015261905690e-05,  3.804315214804672e-06, -7.711803828816708e-08,
 -1.409666415748835e-09,  8.707363312671915e-11, -1.480310987794020e-13, -7.514324921605293e-14,  1.199368979170035e-15,  5.191267729560942e-17, -1.791980092925588e-18,
  6.527187458605391e-03, -5.846068681580452e-05,  4.671995273027351e-07, -1.801131999789345e-09, -2.250084753663569e-11, -3.152200393145947e-13,  3.048478953576705e-14,
 -1.039946901120445e-16, -2.371152822912907e-17,  3.292140545915190e-19,  1.625607300572338e-20, -4.389550527320456e-22,  2.619459272592175e-02, -2.345768131504998e-04,
  1.871973677515111e-06, -7.094025834971991e-09, -9.344067036926936e-11, -1.254845028991972e-12,  1.236079182564182e-13, -4.265245668505351e-16, -9.628574471902856e-17,
  1.342840230364937e-18,  6.599358469367626e-20, -1.789335213735689e-21,  5.926607635664318e-02, -5.306014102314138e-04,  4.223788823125113e-06, -1.552500917703111e-08,
 -2.237378764225012e-10, -2.798622382300730e-12,  2.846470577170708e-13, -1.001861297819786e-15, -2.222722384719027e-16,  3.124008559269996e-18,  1.522708681878761e-19,
 -4.158221575208971e-21,  1.062036751806482e-01, -9.504675885303179e-04,  7.538143446075391e-06, -2.642336393871368e-08, -4.338113044097029e-10, -4.904723320858689e-12,
  5.233920922096131e-13, -1.897072229026601e-15, -4.100947846306999e-16,  5.830502511826463e-18,  2.807312115580051e-19, -7.748312221293077e-21,  1.677054853171409e-01,
 -1.500088503689098e-03,  1.183582262738826e-05, -3.864956818680902e-08, -7.577216467704995e-10, -7.493826147007136e-12,  8.559983695378748e-13, -3.231860870678336e-15,
 -6.736035765885468e-16,  9.731776316588155e-18,  4.605993804577487e-19, -1.290434437786732e-20,  2.447693701145982e-01, -2.187854315191523e-03,  1.714094788476448e-05,
 -5.030512861170784e-08, -1.251082078729090e-09, -1.041650194167854e-11,  1.308534742537878e-12, -5.220093110975279e-15, -1.034997372697560e-15,  1.528290529551469e-17,
  7.065241633405585e-19, -2.020523105508424e-20,  3.387982741953330e-01, -3.025435673595955e-03,  2.347606476933102e-05, -5.816729804036435e-08, -2.006482713871049e-09,
 -1.338427746306129e-11,  1.923944436801266e-12, -8.260698704558096e-15, -1.530407573816882e-15,  2.327758605132916e-17,  1.041999685846698e-18, -3.065298373442303e-20,
  4.517787401655439e-01, -4.029102416967189e-03,  3.084971469202467e-05, -5.652009799293799e-08, -3.185517801805825e-09, -1.581352575106922e-11,  2.776683355970187e-12,
 -1.315480967496387e-14, -2.221171460409141e-15,  3.519064765472686e-17,  1.505955180040535e-18, -4.609046744341214e-20,  5.866005296293247e-01, -5.221973856498188e-03,
  3.922353473544715e-05, -3.450427705028438e-08, -5.092024683344656e-09, -1.643470877479458e-11,  4.006984270633679e-12, -2.169357244513029e-14, -3.218552067218396e-15,
  5.403919987174624e-17,  2.166040581407501e-18, -7.023332510131008e-20,  7.476797679003153e-01, -6.638085525380854e-03,  4.841669248192038e-05,  3.073175751312405e-08,
 -8.364269923351118e-09, -1.216720633648092e-11,  5.914545073610158e-12, -3.855651350625819e-14, -4.744174762362330e-15,  8.693493341684671e-17,  3.145731714612417e-18,
 -1.116438083818577e-19,  9.423389306679772e-01, -8.330259562290540e-03,  5.777993687625206e-05,  1.955137586434577e-07, -1.459287310744605e-08,  5.852728366044301e-12,
  9.282969508133579e-12, -7.929824062309495e-14, -7.297932333043079e-15,  1.547522072227066e-16,  4.663708117540595e-18, -1.944106103855339e-19,  1.184544856789704e+00,
 -1.038574288207455e-02,  6.471849671458152e-05,  6.421467797532371e-07, -2.909300955005967e-08,  7.163610726739869e-11,  1.706941974198617e-11, -2.231408375005089e-13,
 -1.212862665814145e-14,  3.475943466167007e-16,  6.671590404713336e-18, -4.110789049111550e-19,  1.509624178523162e+00, -1.292915968530325e-02,  5.231174331633107e-05,
  2.452746250214062e-06, -8.594507136819608e-08,  4.088786219075233e-10,  5.767968843075382e-11, -1.621760174175009e-12, -1.423985304136276e-14,  1.683136937851592e-15,
 -2.161178926172996e-17, -1.033426727107960e-18,  6.300674058306327e-03, -5.481589661116992e-05,  4.433405457204838e-07, -2.174184958132952e-09, -2.210835229821056e-11,
  3.101453422850739e-13,  1.938559075660762e-14, -5.895294918491056e-16, -5.346515726160361e-18,  5.489644388145703e-19, -4.583762886040080e-21, -3.590959669307584e-22,
  2.528566077741351e-02, -2.199678561446707e-04,  1.777544358841382e-06, -8.638273419387946e-09, -9.139590592072800e-11,  1.278974311090347e-12,  7.844725326611075e-14,
 -2.395320791704145e-15, -2.156488402061492e-17,  2.230271080773552e-18, -1.878172427205958e-20, -1.457331218904691e-21,  5.720998282916568e-02, -4.976190995654033e-04,
  4.015307858674122e-06, -1.920374552318423e-08, -2.172580896743736e-10,  3.028806613031519e-12,  1.800269372696150e-13, -5.535421924218935e-15, -4.919640213804708e-17,
  5.152834409228106e-18, -4.403262867964196e-20, -3.360680482913411e-21,  1.025202358931108e-01, -8.915519675508829e-04,  7.178284002160507e-06, -3.350823355360373e-08,
 -4.172106369666683e-10,  5.789787327113420e-12,  3.293215543684880e-13, -1.023024359757525e-14, -8.915288599503837e-17,  9.518913467070390e-18, -8.310343564287288e-20,
 -6.190420763198063e-21,  1.618912698721956e-01, -1.407467653971581e-03,  1.129777790629275e-05, -5.092533549084580e-08, -7.203359955536262e-10,  9.949409022304537e-12,
  5.347172533693086e-13, -1.684703247448956e-14, -1.427003481980671e-16,  1.566256636379526e-17, -1.408092699498095e-19, -1.014356608770100e-20,  2.362878969105317e-01,
 -2.053486912493116e-03,  1.641555432611079e-05, -7.039172311028308e-08, -1.173827274295675e-09,  1.614853211464902e-11,  8.093216307388491e-13, -2.598588004118414e-14,
 -2.113335621738102e-16,  2.412255135858769e-17, -2.254765021809543e-19, -1.553001190779511e-20,  3.270669501347822e-01, -2.840969746696294e-03,  2.258429971065588e-05,
 -9.006970125657654e-08, -1.855650117054207e-09,  2.547228455660271e-11,  1.173801846552292e-12, -3.865049001384340e-14, -2.962798237259834e-16,  3.578295059906828e-17,
 -3.520296692337004e-19, -2.283968592273261e-20,  4.361504037251880e-01, -3.785885783775149e-03,  2.986630493977377e-05, -1.066492434035117e-07, -2.900585491009850e-09,
  3.985611643166359e-11,  1.661908885819840e-12, -5.661191160695839e-14, -3.967697368246877e-16,  5.216056500728389e-17, -5.490448076405718e-19, -3.286638805190711e-20,
  5.663356407721470e-01, -4.911219629399050e-03,  3.832571900756513e-05, -1.137693896920084e-07, -4.559097084017314e-09,  6.304222937811094e-11,  2.332117678994994e-12,
 -8.327047661730275e-14, -5.039073907895838e-16,  7.604555908823254e-17, -8.768356612489663e-19, -4.693835379849686e-20,  7.219012518101576e-01, -6.251523255138986e-03,
  4.799780474049843e-05, -9.796285045656766e-08, -7.349595284041810e-09,  1.031834110624408e-10,  3.295044983508971e-12, -1.260351446922233e-13, -5.763978280213459e-16,
  1.131058911027758e-16, -1.481944901335963e-18, -6.730425368609700e-20,  9.099517310253941e-01, -7.862522544507890e-03,  5.876521763730141e-05, -2.608526464139600e-08,
 -1.253896731253668e-08,  1.816233758469820e-10,  4.788941138375161e-12, -2.045756722859130e-13, -4.209522947436549e-16,  1.765410734688626e-16, -2.805044075699132e-18,
 -9.711753888214790e-20,  1.144075322343135e+00, -9.844844862447332e-03,  6.974335321741684e-05,  2.076249635922729e-07, -2.424334294093896e-08,  3.750268988876477e-10,
  7.440107706086442e-12, -3.928616983388904e-13,  1.198295734008138e-15,  3.020605815086254e-16, -6.745005480484974e-18, -1.278821916780992e-19,  1.458899273156621e+00,
 -1.241527895950856e-02,  7.396447587201352e-05,  1.202539479134364e-06, -6.765811444944165e-08,  1.245211158002035e-09,  1.345487933226406e-11, -1.331562541893359e-12,
  2.465941360994278e-14,  4.258123553239799e-16, -3.045389568835144e-17,  4.170950504780555e-19,  6.088330986577954e-03, -5.137893945532105e-05,  4.153988085611546e-07,
 -2.458760283835109e-09, -1.261900936342053e-11,  5.743683923864737e-13,  3.064134613339440e-15, -5.023742342557191e-16,  8.575013452099033e-18,  1.880717596145568e-19,
 -1.022210479049282e-20,  7.300694339149387e-23,  2.443354171681467e-02, -2.061845052605277e-04,  1.666222802368201e-06, -9.817004454147265e-09, -5.253692116866424e-11,
  2.345425388111096e-12,  1.219390139853839e-14, -2.037234815279722e-15,  3.490921770920472e-17,  7.604034639443904e-19, -4.153954077269468e-20,  3.001536538026706e-22,
  5.528221610972504e-02, -4.664716492020224e-04,  3.766618349577669e-06, -2.201437985907120e-08, -1.262849692853327e-10,  5.465197840709683e-12,  2.717048052216392e-14,
 -4.692038057324151e-15,  8.094241691213781e-17,  1.742141643661929e-18, -9.601367048880216e-20,  7.076824659908195e-22,  9.906618824736442e-02, -8.358364754686185e-04,
  6.741073450557657e-06, -3.892725108487445e-08, -2.460205208621517e-10,  1.021697632295414e-11,  4.751095068713259e-14, -8.627973945922390e-15,  1.503219345829278e-16,
  3.177940908273250e-18, -1.774746956231927e-19,  1.346308329919626e-21,  1.564380414229568e-01, -1.319706937332264e-03,  1.062589982799129e-05, -6.032505276643461e-08,
 -4.318787696828780e-10,  1.707102784411196e-11,  7.222691578240832e-14, -1.410828258853951e-14,  2.491878036260057e-16,  5.136331777757106e-18, -2.922532383384951e-19,
  2.304856260721915e-21,  2.283308370827782e-01, -1.925830410074141e-03,  1.547155457561465e-05, -8.578552355696048e-08, -7.164126180276833e-10,  2.679091537048015e-11,
  9.930794483347414e-14, -2.155118726243020e-14,  3.877079699245057e-16,  7.716029915092747e-18, -4.505661466761319e-19,  3.738015971433903e-21,  3.160569233866727e-01,
 -2.665076625079504e-03,  2.134606969312272e-05, -1.145271531486253e-07, -1.153116976115299e-09,  4.064067066039233e-11,  1.245737947459694e-13, -3.163026803534931e-14,
  5.831662620699350e-16,  1.105287320407707e-17, -6.691850384885519e-19,  5.924905952045604e-21,  4.214755966056369e-01, -3.552791515353401e-03,  2.833989265466767e-05,
 -1.450589782369257e-07, -1.833784266776135e-09,  6.081494588367842e-11,  1.389276779243854e-13, -4.547575379928542e-14,  8.666337223048324e-16,  1.531955858401009e-17,
 -9.768715626694777e-19,  9.402537721747537e-21,  5.472937229806462e-01, -4.611203265891651e-03,  3.657209148925674e-05, -1.743832363084221e-07, -2.927218372119461e-09,
  9.142348836136184e-11,  1.210439671414944e-13, -6.511505295134425e-14,  1.299006592496289e-15,  2.068027518762777e-17, -1.426416147455011e-18,  1.530558093216752e-20,
  6.976530909225956e-01, -5.874063326146746e-03,  4.619543535938636e-05, -1.959443638831785e-07, -4.777612937109851e-09,  1.410796326758594e-10,  1.474232243210605e-14,
 -9.456305657123031e-14,  2.015857540968403e-15,  2.700750996167290e-17, -2.124419297961211e-18,  2.637447058352495e-20,  8.794354903195406e-01, -7.396756401488055e-03,
  5.738331260551533e-05, -1.933127844261371e-07, -8.207381859213821e-09,  2.312522265233467e-10, -3.585749412181841e-13, -1.430373239955947e-13,  3.384246101558798e-15,
  3.216881464460839e-17, -3.315422688395178e-18,  5.068244311145612e-20,  1.105819115743070e+00, -9.282911018631467e-03,  7.017664647545914e-05, -1.141153580950986e-07,
 -1.579046381084618e-08,  4.339545136764539e-10, -1.791855536321623e-12, -2.372938484197737e-13,  6.794994897612064e-15,  1.791511621901170e-17, -5.630991441923030e-18,
  1.210038509194948e-19,  1.410489571697550e+00, -1.178229357383939e-02,  8.274791326412738e-05,  3.258233391017999e-07, -4.205105718615940e-08,  1.216690191355037e-09,
 -1.190690791165438e-11, -4.891293199839293e-13,  2.347788338791445e-14, -3.344659505003428e-16, -7.456913309658040e-18,  4.556058394341926e-19,  5.889271055924746e-03,
 -4.817632413200950e-05,  3.850626836578360e-07, -2.568940447028686e-09, -1.358391212002017e-12,  5.137812077359620e-13, -6.650015703790499e-15, -1.885451186855100e-16,
  9.292895204891919e-18, -1.037333262743263e-19, -3.757288178868675e-21,  1.613897331008716e-22,  2.363470171897158e-02, -1.933366470088620e-04,  1.544927659886826e-06,
 -1.028333121331637e-08, -6.601412727958611e-12,  2.094567376338030e-12, -2.715339068477691e-14, -7.618998994183423e-16,  3.771494692735685e-17, -4.233857471064749e-19,
 -1.519451362255206e-20,  6.557593186166058e-22,  5.347488481962984e-02, -4.374214034125251e-04,  3.493935985605556e-06, -2.316398117327254e-08, -1.943268648127540e-11,
  4.867097418913927e-12, -6.327009097421554e-14, -1.744065793298375e-15,  8.698185463203722e-17, -9.859781808759188e-19, -3.482493264400315e-20,  1.515374386141644e-21,
  9.582766711352979e-02, -7.838277459402784e-04,  6.257073511593153e-06, -4.123836363181880e-08, -4.675422480255542e-11,  9.062657258023534e-12, -1.183010493646169e-13,
 -3.178013897016213e-15,  1.602649737662879e-16, -1.842704789768179e-18, -6.356363521044780e-20,  2.800080526633287e-21,  1.513245117781143e-01, -1.237686848051505e-03,
  9.871786114065261e-06, -6.452621530960495e-08, -1.000113647848157e-10,  1.506229939837950e-11, -1.977798528819075e-13, -5.130721972908304e-15,  2.627658791057538e-16,
 -3.080696714558971e-18, -1.028251012336074e-19,  4.608503726815481e-21,  2.208683191514845e-01, -1.806329887549922e-03,  1.439095915880858e-05, -9.300987551200834e-08,
 -1.977218961654027e-10,  2.347842124787683e-11, -3.108109919533893e-13, -7.701485604871322e-15,  4.027960976638112e-16, -4.846250091911564e-18, -1.546725739939865e-19,
  7.099117241010020e-21,  3.057290882878915e-01, -2.500057519224084e-03,  1.988766909144088e-05, -1.265722288997368e-07, -3.703035936696463e-10,  3.531145641923740e-11,
 -4.727235203015447e-13, -1.103482220801661e-14,  5.938380202852013e-16, -7.392074965277955e-18, -2.220127195338498e-19,  1.053039028078557e-20,  4.077062611965102e-01,
 -3.333442283948877e-03,  2.646282840692367e-05, -1.648604418372063e-07, -6.698223270666008e-10,  5.226937521447273e-11, -7.106981229589255e-13, -1.533876886252616e-14,
  8.587095219707035e-16, -1.118055689468510e-17, -3.087393041327076e-19,  1.534134238861453e-20,  5.294198673865536e-01, -4.327655858271802e-03,  3.425785216724194e-05,
 -2.069632553148336e-07, -1.191487053967901e-09,  7.748252536422782e-11, -1.076970405005137e-12, -2.090271661336635e-14,  1.238755541651045e-15, -1.713465820049210e-17,
 -4.192817458935358e-19,  2.232598183818245e-20,  6.748795163018952e-01, -5.514994030544776e-03,  4.347649738534835e-05, -2.505570281374108e-07, -2.127386348892927e-09,
  1.173293640098871e-10, -1.684586297379966e-12, -2.806434095608629e-14,  1.816799287638075e-15, -2.734520315276256e-17, -5.546381506258870e-19,  3.304919131762707e-20,
  8.507492067596140e-01, -6.948858700246350e-03,  5.442358527752016e-05, -2.892339923028727e-07, -3.927959620299427e-09,  1.871006955845261e-10, -2.826958864976040e-12,
 -3.675928800860160e-14,  2.785369597509318e-15, -4.754749772415636e-17, -6.865807778688251e-19,  5.093962671716765e-20,  1.069796400674149e+00, -8.730635394400263e-03,
  6.756510036883055e-05, -3.014891257320038e-07, -7.954885362324357e-09,  3.350995747964652e-10, -5.542230245215675e-12, -4.220316008248078e-14,  4.708947170800361e-15,
 -9.943229035651469e-17, -5.451203543787188e-19,  8.381123732027874e-20,  1.364695268724528e+00, -1.111437759401111e-02,  8.336422754331482e-05, -1.711347039529190e-07,
 -2.129744242693194e-08,  8.391358636289608e-10, -1.711101906733444e-11,  4.439734111800988e-14,  9.869970944222325e-15, -3.446744770030315e-16,  4.251133733754191e-18,
  9.441776476411439e-20,  5.702531951736385e-03, -4.521878331183403e-05,  3.544124374247481e-07, -2.518383550813269e-09,  7.049883428709377e-12,  3.202613486750785e-13,
 -8.461336476500429e-15,  3.239442750189685e-17,  4.318986976803119e-18, -1.400502063681755e-19,  1.142292089601076e-21,  5.564913033279794e-23,  2.288529378021704e-02,
 -1.814696942830090e-04,  1.422147299110273e-06, -1.009424195968095e-08,  2.767908821763292e-11,  1.306271571077167e-12, -3.442182583356700e-14,  1.338403901316093e-16,
  1.748291416778056e-17, -5.686410666168944e-19,  4.676306039184103e-21,  2.249420150272343e-22,  5.177934326034944e-02, -4.105802714825415e-04,  3.217014898737322e-06,
 -2.279010810889759e-08,  6.022987455558609e-11,  3.037690072034051e-12, -7.970540683228370e-14,  3.180463795214769e-16,  4.013942425559967e-17, -1.312442235364424e-18,
  1.094566238194693e-20,  5.151415462322134e-22,  9.278933399933902e-02, -7.357506544522711e-04,  5.763146847838387e-06, -4.071141231783437e-08,  1.015877525525604e-10,
  5.661766371400950e-12, -1.476971490619632e-13,  6.112806666911528e-16,  7.346369845728081e-17, -2.420820695583992e-18,  2.060547611711222e-20,  9.391320859224155e-22,
  1.465267984220011e-01, -1.161815979744730e-03,  9.096880536884174e-06, -6.400760279156142e-08,  1.465325553698459e-10,  9.419946303601592e-12, -2.439830048238250e-13,
  1.058956303642283e-15,  1.193279738233305e-16, -3.974913449049603e-18,  3.478052448102873e-20,  1.516663554976628e-21,  2.138661536791633e-01, -1.695687680376092e-03,
  1.326989985311993e-05, -9.287166225348344e-08,  1.865177206636793e-10,  1.469766781553915e-11, -3.775624230181146e-13,  1.738758646814586e-15,  1.806015685785867e-16,
 -6.104706267385654e-18,  5.537936118448765e-20,  2.276166111981581e-21,  2.960373644861276e-01, -2.347083064532713e-03,  1.835436016488164e-05, -1.275336898464123e-07,
  2.073423207720307e-10,  2.211892613889039e-11, -5.631904053688346e-13,  2.787627427996232e-15,  2.616760484692686e-16, -9.021691023535510e-18,  8.573705818747644e-20,
  3.256836687549541e-21,  3.947832072376199e-01, -3.129762237694273e-03,  2.445141981959087e-05, -1.682367713600197e-07,  1.844645319168037e-10,  3.273630024308247e-11,
 -8.261864215009335e-13,  4.461327835287360e-15,  3.694018494323473e-16, -1.308495770015804e-17,  1.320269764663002e-19,  4.509116974795208e-21,  5.126413257835785e-01,
 -4.063743400852483e-03,  3.170613240065133e-05, -2.151607096689643e-07,  7.273199418028470e-11,  4.844823025917153e-11, -1.213286203876470e-12,  7.280526732407755e-15,
  5.147957072550577e-16, -1.894715164262608e-17,  2.067009009551433e-19,  6.084501799690594e-21,  6.534955209404211e-01, -5.179624259158745e-03,  4.033543266792572e-05,
 -2.681808373930387e-07, -2.190111016761162e-10,  7.303895680900927e-11, -1.820649119843243e-12,  1.244573732447888e-14,  7.160767997182496e-16, -2.791840180290768e-17,
  3.381747451339151e-19,  7.969832999231404e-21,  8.238014026546155e-01, -6.528162287003531e-03,  5.068667216076035e-05, -3.260216818557935e-07, -9.028260941996436e-10,
  1.152977388796179e-10, -2.881872928463199e-12,  2.329901040172234e-14,  1.002218408147944e-15, -4.304144444001859e-17,  6.044263596325057e-19,  9.702372709612672e-21,
  1.035929544120872e+00, -8.206288299528795e-03,  6.338086377746307e-05, -3.825164730598837e-07, -2.604839137957002e-09,  2.016245060044953e-10, -5.148476721020937e-12,
  5.263482612342911e-14,  1.387687072146717e-15, -7.314084619638154e-17,  1.295190388583023e-18,  7.463017355529250e-21,  1.321551905663069e+00, -1.046033638743049e-02,
  7.975001482449082e-05, -3.990142807933586e-07, -8.380181376866899e-09,  4.689122488315291e-10, -1.305030637845748e-11,  1.987121383533973e-13,  9.463747657437986e-16,
 -1.513769210483442e-16,  4.371462710123245e-18, -5.103184175802390e-20  };
  constexpr double w[4992] = {  2.765327088534714e-03, -8.928815873649829e-05,  2.036889978751625e-06, -4.007002497264451e-08,  7.221209327302503e-10,
 -1.223732429557379e-11,  1.977775211779937e-13, -3.075585765343573e-15,  4.630068207263094e-17, -6.777843951418066e-19,  9.680792419159142e-21, -1.352433163143365e-22,
  1.036832505194435e-02, -5.035311399056498e-04,  1.725475774330004e-05, -4.940105534366876e-07,  1.254697974212633e-08, -2.916227576118295e-10,  6.320429754407179e-12,
 -1.293334454927732e-13,  2.520635037595037e-15, -4.709132497650492e-17,  8.474986485987981e-19, -1.474553336685229e-20,  2.098687101885048e-02, -1.570902622881603e-03,
  7.724819301887388e-05, -3.026150720988178e-06,  1.018129524709479e-07, -3.059253902560854e-09,  8.405771320437394e-11, -2.145247345301704e-12,  5.141704449559199e-14,
 -1.166837642769330e-15,  2.522909372590930e-17, -5.220986338662329e-19,  3.230007463380042e-02, -3.547447202069369e-03,  2.378065376546190e-04, -1.219288760932031e-05,
  5.220316056153461e-07, -1.953712165940266e-08,  6.571068126793233e-10, -2.023147766919231e-11,  5.777042602495832e-13, -1.544810512500273e-14,  3.897323161274998e-16,
 -9.326373459110966e-18,  4.217307399024988e-02, -6.392437344197748e-03,  5.595307928690011e-04, -3.623304827662013e-05,  1.912789613338305e-06, -8.663053903829965e-08,
  3.472426548943129e-09, -1.257728176384678e-10,  4.177894338406891e-12, -1.286848072809006e-13,  3.706641500856606e-15, -1.004529770262968e-16,  4.911151909416232e-02,
 -9.706588144134458e-03,  1.067301227511897e-03, -8.458005416818683e-05,  5.356432052133848e-06, -2.864018168961974e-07,  1.337351736961564e-08, -5.578986578351710e-10,
  2.113295441706555e-11, -7.357555925796077e-13,  2.376581365000440e-14, -7.170114686799271e-16,  5.238535106364568e-02, -1.284619702159893e-02,  1.712591726853517e-03,
 -1.613301963293744e-04,  1.195162583779478e-05, -7.376127926403073e-07,  3.930606533351425e-08, -1.852860154633654e-09,  7.862146502367060e-11, -3.042526300796478e-12,
  1.084753818329409e-13, -3.588856433117407e-15,  5.190161158539904e-02, -1.512704927481508e-02,  2.366522750391308e-03, -2.578815824105415e-04,  2.182301250283742e-05,
 -1.521860285212234e-06,  9.077051333285373e-08, -4.749338031611029e-09,  2.220229092322019e-10, -9.402502226292294e-12,  3.646287734046719e-13, -1.304716056451155e-14,
  4.797863469552689e-02, -1.601235762002485e-02,  2.852426395413880e-03, -3.504116280986631e-04,  3.311116136876433e-05, -2.556215744769128e-06,  1.674902479415609e-07,
 -9.561021978124409e-09,  4.846124902032800e-10, -2.212668230823660e-11,  9.203777941802980e-13, -3.515367263390729e-14,  4.114284152905532e-02, -1.522234576282673e-02,
  3.002939616709188e-03, -4.058006899323704e-04,  4.188557334801792e-05, -3.509040896924831e-06,  2.480098817760515e-07, -1.518773840920764e-08,  8.217200105588280e-10,
 -3.986608597094009e-11,  1.754662591366044e-12, -7.063437201270507e-14,  3.199870676086720e-02, -1.275871875494555e-02,  2.715882497746160e-03, -3.943482246111130e-04,
  4.352172018455242e-05, -3.880016377898460e-06,  2.905240055634690e-07, -1.877095997207321e-08,  1.067461335106336e-09, -5.424408115715072e-11,  2.492683860581822e-12,
 -1.044443052585906e-13,  2.116803576679119e-02, -8.870316463478438e-03,  1.988283360575969e-03, -3.032574154853931e-04,  3.504570228069630e-05, -3.261264710775470e-06,
  2.541278400585634e-07, -1.703941799413022e-08,  1.002967938031651e-09, -5.262677054388440e-11,  2.491564673178314e-12, -1.073280061435853e-13,  9.284986196992012e-03,
 -3.996790949624353e-03,  9.216430618658634e-04, -1.444391498625624e-04,  1.712285164265262e-05, -1.631751526674699e-06,  1.299970844720536e-07, -8.897712370915657e-09,
  5.338595741087371e-10, -2.851554444075333e-11,  1.372595823058492e-12, -6.004285364184376e-14,  2.437974089102870e-03, -7.473704243287687e-05,  1.618058734557960e-06,
 -3.024269209781439e-08,  5.186440971502401e-10, -8.376773024178369e-12,  1.292080210631573e-13, -1.919876887269791e-15,  2.764446781959339e-17, -3.874169101763240e-19,
  5.301695103250577e-21, -7.101716474723925e-23,  8.597026159171947e-03, -3.861880360548781e-04,  1.236235858732286e-05, -3.327619403116015e-07,  7.979318755742594e-09,
 -1.756343433844991e-10,  3.613689497302772e-12, -7.034118818422752e-14,  1.306349593398223e-15, -2.329202169327994e-17,  4.006083821471325e-19, -6.669764047691902e-21,
  1.574299739081434e-02, -1.074506466398952e-03,  4.899566836093669e-05, -1.794527177795529e-06,  5.675467485423011e-08, -1.609568317699739e-09,  4.187644967867420e-11,
 -1.014700519607822e-12,  2.314414839475245e-14, -5.008433716579808e-16,  1.034525715140255e-17, -2.048665434567363e-19,  2.115584365787867e-02, -2.113213920854270e-03,
  1.310397573786891e-04, -6.270137525924623e-06,  2.520615370253102e-07, -8.898658587164393e-09,  2.833857623288917e-10, -8.287205532542622e-12,  2.253700079366043e-13,
 -5.753155065411493e-15,  1.388540082154689e-16, -3.185049723635735e-18,  2.339394069983354e-02, -3.242363005508557e-03,  2.631339188439675e-04, -1.593305675284365e-05,
  7.913573454203125e-07, -3.388209539006686e-08,  1.288929714227878e-09, -4.445482890877565e-11,  1.410168636934724e-12, -4.158341533066034e-14,  1.149302956605741e-15,
 -2.994919506382860e-17,  2.253296054291021e-02, -4.114807064891654e-03,  4.222463974179487e-04, -3.145806971840050e-05,  1.883553289767255e-06, -9.565136817520508e-08,
  4.258137028045041e-09, -1.699003612696315e-10,  6.172910910754994e-12, -2.066517225043018e-13,  6.432885186492935e-15, -1.874247977196065e-16,  1.958521383808541e-02,
 -4.497186418331604e-03,  5.649734146643587e-04, -5.044459700910409e-05,  3.558971693305389e-06, -2.100171109065084e-07,  1.073710124141030e-08, -4.870202169315953e-10,
  1.993625931328207e-11, -7.459893736890393e-13,  2.577042425734932e-14, -8.276965861429914e-16,  1.574046322845308e-02, -4.358755542194895e-03,  6.500740908599813e-04,
 -6.781613874169808e-05,  5.514462682103363e-06, -3.707136009861410e-07,  2.137479634692486e-08, -1.083812959195209e-09,  4.920769689115299e-11, -2.027882550167363e-12,
  7.666213378499546e-14, -2.678497450458607e-15,  1.188659109005882e-02, -3.823262663282264e-03,  6.572589675020829e-04, -7.813309294776165e-05,  7.163353060378500e-06,
 -5.378498449749705e-07,  3.434765837519574e-08, -1.914601791706633e-09,  9.492312382896884e-11, -4.245808725762923e-12,  1.732516813795953e-13, -6.499970714718912e-15,
  8.486195574108010e-03, -3.064868154993331e-03,  5.902758770087159e-04, -7.800020021284244e-05,  7.886020072615416e-06, -6.481567102440289e-07,  4.500742723810084e-08,
 -2.711422780819593e-09,  1.444867347649463e-10, -6.911474751048326e-12,  3.002233971932541e-13, -1.193840989584783e-14,  5.664107786008085e-03, -2.227508208503730e-03,
  4.675328306270794e-04, -6.699116331300638e-05,  7.302716745814989e-06, -6.436414539367307e-07,  4.768561202802395e-08, -3.050835699091329e-09,  1.719152109919563e-10,
 -8.662043014283922e-12,  3.949052256036481e-13, -1.642503365657771e-14,  3.347320097870634e-03, -1.393769769001949e-03,  3.103410777927602e-04, -4.703422039041335e-05,
  5.403198376084839e-06, -5.000211168879928e-07,  3.876178371301383e-08, -2.586465088703330e-09,  1.515578192405061e-10, -7.918904607461985e-12,  3.734348083035139e-13,
 -1.602698002881968e-14,  1.375516382037648e-03, -5.908140896754241e-04,  1.359203554927527e-04, -2.125271545905659e-05,  2.513951482579183e-06, -2.390742582406701e-07,
  1.900886195154955e-08, -1.298637736667797e-09,  7.777940407981254e-11, -4.147488896183014e-12,  1.993185454460652e-13, -8.705680482434983e-15,  2.162800063142492e-03,
 -6.311487259667304e-05,  1.299907423405967e-06, -2.313281354009732e-08,  3.782310953214749e-10, -5.832458491628434e-12,  8.599940960823567e-14, -1.222883168330493e-15,
  1.686693954155149e-17, -2.266139766157840e-19,  2.975279600911050e-21, -3.826344328728686e-23,  7.227528817660081e-03, -3.013307256921834e-04,  9.032930673102582e-06,
 -2.290756855761860e-07,  5.195870145397291e-09, -1.084935906534578e-10,  2.122447145867622e-12, -3.935584248892836e-14,  6.973949510573221e-16, -1.188142088989635e-17,
  1.955152577667950e-19, -3.118075924446990e-21,  1.211148130326217e-02, -7.553754267911652e-04,  3.200117726288411e-05, -1.097719126026317e-06,  3.268328721810355e-08,
 -8.759710964026350e-10,  2.160427124954203e-11, -4.975151091468125e-13,  1.080836630331543e-14, -2.232066210611884e-16,  4.407374283406846e-18, -8.356661626396325e-20,
  1.440466115935410e-02, -1.308766476310462e-03,  7.513496973068669e-05, -3.357757769156394e-06,  1.268256814335573e-07, -4.225853223397238e-09,  1.274766133898694e-10,
 -3.541908878568532e-12,  9.175542587262208e-14, -2.236351633258894e-15,  5.163886575388352e-17, -1.135365747206500e-18,  1.367127521509385e-02, -1.729191907183376e-03,
  1.300210721802960e-04, -7.358219230597650e-06,  3.436972522984475e-07, -1.390540065706473e-08,  5.018142568546306e-10, -1.647237347243160e-11,  4.987238171348146e-13,
 -1.407155050077339e-14,  3.729535196217323e-16, -9.338883774093359e-18,  1.100774856021428e-02, -1.850471087440113e-03,  1.768123153859284e-04, -1.236200017984425e-05,
  6.987129370293427e-07, -3.365172818989156e-08,  1.426299584469585e-09, -5.436119464540980e-11,  1.892035972745145e-12, -6.083018852484410e-14,  1.822667227119125e-15,
 -5.122203953063906e-17,  7.839731363694789e-03, -1.677634944601860e-03,  1.979204464339962e-04, -1.670181203827034e-05,  1.119413542030407e-06, -6.301925782769474e-08,
  3.084658892453969e-09, -1.343701600332557e-10,  5.296678845971516e-12, -1.913081423325387e-13,  6.392829487537113e-15, -1.990102893453825e-16,  5.105474493467750e-03,
 -1.336495332670881e-03,  1.892611811556932e-04, -1.883660959606570e-05,  1.467362965415671e-06, -9.483508719971467e-08,  5.272904012129691e-09, -2.585077920331933e-10,
  1.137479053343740e-11, -4.552542494842387e-13,  1.674601627915260e-14, -5.702989114983861e-16,  3.124538930503642e-03, -9.641962528517177e-04,  1.593379863222218e-04,
 -1.826730421091503e-05,  1.620050238614380e-06, -1.179813839657173e-07,  7.325211062887059e-09, -3.978185102888596e-10,  1.925201641270191e-11, -8.419630310980072e-13,
  3.364326953462714e-14, -1.237759003003725e-15,  1.832333930370830e-03, -6.437433173647891e-04,  1.206598287041939e-04, -1.554722936493120e-05,  1.535774687703013e-06,
 -1.235540992603222e-07,  8.411742458083441e-09, -4.975858690562238e-10,  2.607040089949392e-11, -1.227617222403851e-12,  5.255133375522639e-14, -2.061471206743619e-15,
  1.032875953046879e-03, -3.997680280358842e-04,  8.256312431848503e-05, -1.165214270860943e-05,  1.252477695341460e-06, -1.089653717090931e-07,  7.976561335999089e-09,
 -5.046819482251289e-10,  2.814718381399593e-11, -1.404693316812800e-12,  6.347235914525088e-14, -2.618193389555361e-15,  5.373279168166801e-04, -2.220896539783881e-04,
  4.907334936773741e-05, -7.383381336511280e-06,  8.424324021543673e-07, -7.746781031275862e-08,  5.970061299974522e-09, -3.961886142999213e-10,  2.309709365911651e-11,
 -1.201094071676372e-12,  5.638923108153029e-14, -2.410083993448350e-15,  2.048677824217462e-04, -8.777934875709622e-05,  2.014108439327628e-05, -3.141247880169236e-06,
  3.706690634559473e-07, -3.516892844271689e-08,  2.790184538540410e-09, -1.902242889612858e-10,  1.137079981880837e-11, -6.052071969541314e-13,  2.903353163895310e-14,
 -1.265983695040889e-15,  1.929515402445737e-03, -5.373129980548718e-05,  1.055108321286610e-06, -1.791279977045374e-08,  2.797342545624535e-10, -4.125162055858239e-12,
  5.823514710414729e-14, -7.936278448897838e-16,  1.050007367874688e-17, -1.354274426318233e-19,  1.708098047594719e-21, -2.111622333896274e-23,  6.151121429715511e-03,
 -2.387982573671194e-04,  6.719260852151695e-06, -1.608669443245871e-07,  3.457659502367209e-09, -6.860386596366648e-11,  1.278000329516140e-12, -2.260596928054258e-14,
  3.827131472699532e-16, -6.237706305031790e-18,  9.831499823264218e-20, -1.503452435746824e-21,  9.529571655065110e-03, -5.443360733941766e-04,  2.146782432843386e-05,
 -6.908875425300349e-07,  1.939492464482041e-08, -4.919158180755460e-10,  1.151448732210620e-11, -2.522702464360701e-13,  5.224863875009559e-15, -1.030545007779086e-16,
  1.946660674011010e-18, -3.536257368689869e-20,  1.015797936802509e-02, -8.398519110914309e-04,  4.468694843802941e-05, -1.867033339403670e-06,  6.631407569149173e-08,
 -2.086939667115973e-09,  5.966809387707495e-11, -1.575906963250007e-12,  3.890380657863140e-14, -9.055652725610826e-16,  2.000899491679393e-17, -4.217313443621992e-19,
  8.384275083927367e-03, -9.662819325458266e-04,  6.729779648314578e-05, -3.559054920459185e-06,  1.563187367564395e-07, -5.975251141535444e-09,  2.045134958742129e-10,
 -6.387643563815754e-12,  1.845248986834021e-13, -4.979729223665914e-15,  1.265121053349646e-16, -3.042682881661823e-18,  5.708810407199421e-03, -8.805120702437596e-04,
  7.819356459347221e-05, -5.123123257546755e-06,  2.730042868257836e-07, -1.245590005258823e-08,  5.020847490672855e-10, -1.825972564543534e-11,  6.081645975182705e-13,
 -1.875844576370847e-14,  5.404474647186955e-16, -1.463451679764199e-17,  3.356707712331028e-03, -6.663233541664356e-04,  7.358522391259300e-05, -5.853525639672067e-06,
  3.718580027335989e-07, -1.993072277138469e-08,  9.322568842797334e-10, -3.893085581638548e-11,  1.475247381835932e-12, -5.134917506004522e-14,  1.657253556282074e-15,
 -4.992898636526536e-17,  1.773806162894964e-03, -4.366877420923491e-04,  5.848033468245284e-05, -5.534153877517896e-06,  4.117773152569596e-07, -2.551719486020619e-08,
  1.364816050744304e-09, -6.454942175335899e-11,  2.746897132050064e-12, -1.065612345173650e-13,  3.806890271457132e-15, -1.261478504042026e-16,  8.746238313316371e-04,
 -2.576728398659888e-04,  4.076434266870987e-05, -4.490982046543440e-06,  3.840584506965119e-07, -2.705155320115515e-08,  1.628741682345791e-09, -8.597602502071897e-11,
  4.052498805096284e-12, -1.729393173361161e-13,  6.754189993143330e-15, -2.432517681947989e-16,  4.160441757420386e-04, -1.416290291586529e-04,  2.574429881248112e-05,
 -3.224542600212932e-06,  3.103474843266780e-07, -2.437812124151510e-08,  1.623569763937156e-09, -9.410806640807873e-11,  4.838781675169716e-12, -2.239085503062879e-13,
  9.430698468410973e-15, -3.644077698255238e-16,  1.947908538267469e-04, -7.401077245911064e-05,  1.500414191096353e-05, -2.081129601562967e-06,  2.201452761097125e-07,
 -1.887204849809452e-08,  1.362809372043614e-09, -8.514838566753773e-11,  4.693964740462647e-12, -2.317399038725594e-13,  1.036697996276896e-14, -4.236729962184175e-16,
  8.775470733794580e-05, -3.596055411527190e-05,  7.875715009214024e-06, -1.175043662928245e-06,  1.330271914194316e-07, -1.214451637639149e-08,  9.296540177465285e-10,
 -6.131109353114690e-11,  3.553703875104552e-12, -1.838073615259939e-13,  8.586251911901009e-15, -3.652683227964301e-16,  3.069717107939649e-05, -1.311614379266162e-05,
  3.000578371439637e-06, -4.666319163495800e-07,  5.491256765908702e-08, -5.196649188649118e-09,  4.112816343924491e-10, -2.797524431101955e-11,  1.668613215788735e-12,
 -8.862915724240902e-14,  4.243532752105632e-15, -1.846957393822775e-16,  1.730210293543223e-03, -4.607997170798401e-05,  8.645134741354740e-07, -1.402806463420033e-08,
  2.095861925899799e-10, -2.960283937540861e-12,  4.006912757213999e-14, -5.240670409986254e-16,  6.659809821708329e-18, -8.256494045882942e-20,  1.001610930619747e-21,
 -1.191698342079390e-23,  5.292413391695334e-03, -1.919197269597739e-04,  5.080379158040625e-06, -1.150472235634645e-07,  2.347393009799914e-09, -4.432681599374093e-11,
  7.874753326674814e-13, -1.330576881196707e-14,  2.154864387174417e-16, -3.363917162522917e-18,  5.083941750183355e-20, -7.462431930813148e-22,  7.649776775374214e-03,
 -4.011415032790807e-04,  1.475722935062626e-05, -4.463612568459897e-07,  1.183277115977689e-08, -2.843952619065081e-10,  6.325713470945725e-12, -1.319955230440900e-13,
  2.608841799793582e-15, -4.918869167440802e-17,  8.895694191492020e-19, -1.549307525104094e-20,  7.393507540552815e-03, -5.566685319514125e-04,  2.748771309305423e-05,
 -1.074920873782434e-06,  3.593823692841946e-08, -1.069116172643678e-09,  2.899237632172845e-11, -7.283061989673549e-13,  1.714186038248229e-14, -3.812234678152110e-16,
  8.062910293419170e-18, -1.629509130295654e-19,  5.375340844439415e-03, -5.638248406012399e-04,  3.637465450503422e-05, -1.797939205365514e-06,  7.426430470397225e-08,
 -2.682206139243678e-09,  8.706894124885815e-11, -2.587356693917710e-12,  7.130517973717228e-14, -1.840153268463575e-15,  4.480044590837012e-17, -1.034559911157558e-18,
  3.132843045322485e-03, -4.420218238274243e-04,  3.642978927796287e-05, -2.234288018273321e-06,  1.121485260096506e-07, -4.843037287913131e-09,  1.855024532823380e-10,
 -6.431897969635063e-12,  2.048253732278054e-13, -6.055816293050838e-15,  1.676178538258822e-16, -4.369557204387029e-18,  1.534856349468604e-03, -2.813765278854892e-04,
  2.900318088916549e-05, -2.169799909172113e-06,  1.303888217159306e-07, -6.641413548545590e-09,  2.963590771076053e-10, -1.184528614633666e-11,  4.308471082129727e-13,
 -1.443083509768734e-14,  4.491835309110171e-16, -1.307877683324071e-17,  6.606863966598595e-04, -1.521606442196518e-04,  1.919420596616496e-05, -1.721423352265713e-06,
  1.219927362524945e-07, -7.229852233091222e-09,  3.711178467793704e-10, -1.689584635039720e-11,  6.939474356290157e-13, -2.604337680220299e-14,  9.019739249146713e-16,
 -2.903174995463886e-17,  2.615705286788470e-04, -7.318325999400937e-05,  1.103584812581187e-05, -1.164040773261488e-06,  9.567881791115080e-08, -6.499160324036811e-09,
  3.784635221897389e-10, -1.937129724487912e-11,  8.873367071008055e-13, -3.687335405314919e-14,  1.404838911868421e-15, -4.943888304665111e-17,  9.980296546856869e-05,
 -3.277470540028018e-05,  5.755173195603299e-06, -6.983313255921439e-07,  6.528801940558692e-08, -4.993788357709471e-09,  3.245474061259474e-10, -1.839242426164366e-11,
  9.261708105665929e-13, -4.203685901886444e-14,  1.739018148802753e-15, -6.608509861876861e-17,  3.815699955335706e-05, -1.418957086343778e-05,  2.815874293882340e-06,
 -3.828992586650843e-07,  3.977127907980961e-08, -3.352722956099206e-09,  2.384047358783744e-10, -1.468525303583904e-11,  7.989901796100841e-13, -3.896941125642334e-14,
  1.723775233908332e-15, -6.971450949190083e-17,  1.461914421644820e-05, -5.930735385461845e-06,  1.285567502317770e-06, -1.899520712781795e-07,  2.131193957445130e-08,
 -1.929534190564036e-09,  1.465743528858346e-10, -9.598214012324717e-12,  5.526809860622965e-13, -2.841215328585556e-14,  1.319714176509422e-15, -5.584690938764830e-17,
  4.631140063957410e-06, -1.972474479416998e-06,  4.497192307244549e-07, -6.971012656533543e-08,  8.178145019457873e-09, -7.716968793949699e-10,  6.090852673355762e-11,
 -4.132360565373490e-12,  2.458840547422283e-13, -1.303051004507619e-14,  6.225546555116226e-16, -2.704114140596230e-17,  1.558731437450909e-03, -3.978438686315677e-05,
  7.144997769176658e-07, -1.110066934432180e-08,  1.589222552872393e-10, -2.153122903171620e-12,  2.798172236836472e-14, -3.516971016230241e-16,  4.298205151633409e-18,
 -5.128268296778623e-20,  5.990653331788992e-22, -6.867591776015242e-24,  4.598097228899987e-03, -1.562217513344707e-04,  3.898917567282050e-06, -8.366831721373410e-08,
  1.623271884095776e-09, -2.921825152787076e-11,  4.957123113405189e-13, -8.011563155659632e-15,  1.242687406237908e-16, -1.860210578253994e-18,  2.698655164075298e-20,
 -3.806080159060980e-22,  6.251437476619850e-03, -3.016747998123071e-04,  1.037279302164302e-05, -2.953970873198863e-07,  7.406280593197000e-09, -1.689151197662681e-10,
  3.574588202503392e-12, -7.111935500441924e-14,  1.342744150753552e-15, -2.422323471599186e-17,  4.197553106396069e-19, -7.014246396375123e-21,  5.536872845064198e-03,
 -3.799976595129668e-04,  1.743900531831195e-05, -6.391229166705608e-07,  2.013593438974319e-08, -5.667844193403145e-10,  1.459015174657814e-11, -3.488488869653696e-13,
  7.832927193069357e-15, -1.665173535582445e-16,  3.372571834891465e-18, -6.537753192342882e-20,  3.589334637037811e-03, -3.423739441397591e-04,  2.046864998878107e-05,
 -9.459961086386682e-07,  3.676024432107885e-08, -1.254805558195813e-09,  3.863980907780018e-11, -1.092569772788642e-12,  2.872621492713772e-14, -7.088872248618311e-16,
  1.653724776919283e-17, -3.666183955772944e-19,  1.812850423805542e-03, -2.333724045955900e-04,  1.783168454578936e-05, -1.022998523715659e-06,  4.833651879824093e-08,
 -1.974496471280796e-09,  7.182156580271028e-11, -2.372717681092593e-12,  7.219847908934324e-14, -2.044745366814496e-15,  5.433456185110646e-17, -1.362614156055319e-18,
  7.478505731867308e-04, -1.260840878358681e-04,  1.209943091574961e-05, -8.496098615041734e-07,  4.821191646730824e-08, -2.330078229424310e-09,  9.904632293148574e-11,
 -3.783807289146551e-12,  1.319255527533272e-13, -4.246475556097883e-15,  1.273159066170624e-16, -3.578168721373766e-18,  2.638468702101141e-04, -5.654598591617559e-05,
  6.693441762249345e-06, -5.671448762929814e-07,  3.817728803591263e-08, -2.158615234255716e-09,  1.061050221120222e-10, -4.640429427514669e-12,  1.835945141217095e-13,
 -6.653462479962027e-15,  2.230037209888867e-16, -6.960449722940446e-18,  8.380937523485760e-05, -2.214414773706822e-05,  3.168862736985880e-06, -3.188124273651478e-07,
  2.510422884842119e-08, -1.639678016422667e-09,  9.210296887391135e-11, -4.559894760528703e-12,  2.025281865878289e-13, -8.178014618841421e-15,  3.033474696787043e-16,
 -1.041212469154007e-17,  2.541263195306574e-05, -8.010814611438588e-06,  1.353134379485773e-06, -1.584736819319851e-07,  1.434519582446993e-08, -1.065328434028253e-09,
  6.738569259799462e-11, -3.724736413642393e-12,  1.832908501302803e-13, -8.143499027345242e-15,  3.302776641524706e-16, -1.232220469572288e-17,  7.800891747835161e-06,
 -2.829354616149757e-06,  5.478544723624875e-07, -7.282506648775946e-08,  7.408627797620984e-09, -6.127693862730769e-10,  4.281804227514944e-11, -2.595463060860389e-12,
  1.391365830201432e-13, -6.693903403641972e-15,  2.923699201625633e-16, -1.168642804211818e-17,  2.491861105710725e-06, -9.990128805321087e-07,  2.139609968644403e-07,
 -3.126029129707465e-08,  3.471022160555366e-09, -3.112656992730161e-10,  2.343744214450674e-11, -1.522348748058240e-12,  8.700392600828596e-14, -4.441729049095733e-15,
  2.049892651458041e-16, -8.623017744946504e-18,  7.041387561651586e-07, -2.988046707366954e-07,  6.786346796984798e-08, -1.048040915746169e-08,  1.225233460421477e-09,
 -1.152357837465889e-10,  9.067449516255983e-12, -6.134158274054222e-13,  3.640100962666132e-14, -1.924159185904993e-15,  9.171027098797953e-17, -3.974551478562897e-18,
  1.410239226467839e-03, -3.456104516673844e-05,  5.952368951534749e-07, -8.869013622183446e-09,  1.218514058749525e-10, -1.585743518908076e-12,  1.981210223257838e-14,
 -2.396002010930885e-16,  2.819422334998030e-18, -3.241192907481217e-20,  3.649832825237575e-22, -4.036164436935479e-24,  4.029803760199563e-03, -1.286455205077105e-04,
  3.033351175962484e-06, -6.179338936110421e-08,  1.141792069691179e-09, -1.961885163930729e-11,  3.183087319160785e-13, -4.926924249595374e-15,  7.328316567731257e-17,
 -1.053096128849684e-18,  1.468054237885482e-20, -1.991394930079126e-22,  5.190792726389400e-03, -2.310865138551911e-04,  7.440985890345497e-06, -1.998607460576905e-07,
  4.746633070224851e-09, -1.028690058489669e-10,  2.073725113166112e-12, -3.938343411034797e-14,  7.110179057943200e-16, -1.228417995398826e-17,  2.041407650737817e-19,
 -3.275505557148666e-21,  4.254067119629197e-03, -2.664390869802398e-04,  1.138214529291659e-05, -3.914821660485661e-07,  1.163656071050231e-08, -3.102408021506530e-10,
  7.587803745393473e-12, -1.728154724539695e-13,  3.704324946459846e-15, -7.532080249096101e-17,  1.461593069860873e-18, -2.718830448629356e-20,  2.487400207066546e-03,
 -2.156586954244426e-04,  1.195622280823949e-05, -5.170098798406401e-07,  1.891092809553933e-08, -6.103712033943797e-10,  1.783589170903624e-11, -4.800050202355864e-13,
  1.204256747528749e-14, -2.842041466270178e-16,  6.353175927554351e-18, -1.352096060257887e-19,  1.102173565919662e-03, -1.291637859800135e-04,  9.144160308845035e-06,
 -4.905135572252679e-07,  2.180960173071770e-08, -8.424308610989948e-10,  2.908951642454160e-11, -9.152736056324338e-13,  2.659960560479864e-14, -7.212686127493269e-16,
  1.839060198632363e-17, -4.434341248920334e-19,  3.872528208472940e-04, -5.980822526481955e-05,  5.331862054187139e-06, -3.508305339065620e-07,  1.877290989659651e-08,
 -8.597700097235310e-10,  3.477199809095519e-11, -1.268153201905534e-12,  4.233446476801744e-14, -1.308077744121146e-15,  3.773319517477045e-17, -1.022480229228809e-18,
  1.129021631552766e-04, -2.239844828428176e-05,  2.479113799030514e-06, -1.978883405883080e-07,  1.262173084009846e-08, -6.793547608739354e-10,  3.191140048173328e-11,
 -1.338106291228225e-12,  5.090510818554805e-14, -1.778356307660621e-15,  5.758841910402220e-17, -1.740277896561768e-18,  2.883106320107158e-05, -7.151910743971575e-06,
  9.668560621195859e-07, -9.243409437168953e-08,  6.950069258871543e-09, -4.352155837695734e-10,  2.351891534100667e-11, -1.123536748486213e-12,  4.827673085973447e-14,
 -1.890264829386825e-15,  6.812939314921245e-17, -2.276573264107543e-18,  6.899807268531124e-06, -2.076399655327868e-06,  3.358340434536485e-07, -3.781297250228825e-08,
  3.302662727632901e-09, -2.374005931209137e-10,  1.457451516129491e-11, -7.837729781907408e-13,  3.760301329149747e-14, -1.631916603056118e-15,  6.475962788672431e-17,
 -2.367719389791869e-18,  1.673197490816850e-06, -5.894709764466901e-07,  1.109627350637943e-07, -1.437246307186031e-08,  1.427957870260951e-09, -1.155835696378572e-10,
  7.918486454480352e-12, -4.713595390264374e-13,  2.485016666058823e-14, -1.177280254801108e-15,  5.069325393586686e-17, -1.999788502726781e-18,  4.361518575132086e-07,
 -1.724291161008350e-07,  3.641312888438763e-08, -5.250759116326935e-09,  5.760421523522806e-10, -5.108941754429896e-11,  3.808097332691800e-12, -2.450562954579406e-13,
  1.388557650389195e-14, -7.032951775097473e-16,  3.222076545553157e-17, -1.346244483430380e-18,  1.080214406346012e-07, -4.564447663787230e-08,  1.032043522205371e-08,
 -1.587050848131835e-09,  1.847983007950050e-10, -1.731603146163594e-11,  1.357801451468427e-12, -9.155790028759530e-14,  5.416703314613763e-15, -2.855133701444539e-16,
  1.357197513278161e-17, -5.867120006674536e-19,  1.280888602658579e-03, -3.019397218363306e-05,  4.995377430535667e-07, -7.149385565817830e-09,  9.439648203731008e-11,
 -1.181549078819768e-12,  1.420922920075228e-14, -1.655438495397693e-16,  1.877641417768809e-18, -2.082237135743276e-20,  2.262314972315812e-22, -2.416526448803498e-24,
  3.559461265779064e-03, -1.070615652380906e-04,  2.389721049207674e-06, -4.629120667884502e-08,  8.158692334016597e-10, -1.340126166619997e-11,  2.082050311674410e-13,
 -3.090258378713635e-15,  4.412739170981765e-17, -6.094132221555513e-19,  8.171831173582201e-21, -1.067204792492694e-22,  4.371949651412924e-03, -1.800013408198210e-04,
  5.438276092388065e-06, -1.380029250043730e-07,  3.109363687622327e-09, -6.411993598748721e-11,  1.232834911759946e-12, -2.237466103403743e-14,  3.866625856960129e-16,
 -6.403758827391394e-18,  1.021445629052598e-19, -1.574974802544395e-21,  3.344591233556166e-03, -1.914224959405476e-04,  7.624783113256411e-06, -2.464739812989835e-07,
  6.920768904313392e-09, -1.749579137669159e-10,  4.069541844508020e-12, -8.836303542886243e-14,  1.809516500918276e-15, -3.521480342663254e-17,  6.550848725324644e-19,
 -1.169927563223588e-20,  1.782976883731246e-03, -1.404781519633142e-04,  7.229213886863473e-06, -2.927285107553155e-07,  1.008596973076783e-08, -3.079962851446876e-10,
  8.544874404436762e-12, -2.189618216127819e-13,  5.243517484434209e-15, -1.183719784470987e-16,  2.536030560151120e-18, -5.181762628015357e-20,  7.014975805694061e-04,
 -7.469415570349143e-05,  4.898364257611364e-06, -2.456630657462138e-07,  1.027775523879380e-08, -3.753545164864847e-10,  1.230206597611633e-11, -3.685729610988148e-13,
  1.022763582702832e-14, -2.654431370507856e-16,  6.491962428585011e-18, -1.504421442696354e-19,  2.124617770685750e-04, -2.994964199145517e-05,  2.476128223414603e-06,
 -1.524731021075685e-07,  7.685055363240969e-09, -3.331887359956151e-10,  1.280835433280632e-11, -4.455242216447404e-13,  1.422668787984918e-14, -4.215715336122112e-16,
  1.168919691863843e-17, -3.051085910945961e-19,  5.169684085586808e-05, -9.445351532527764e-06,  9.743386939044120e-07, -7.307856266532536e-08,  4.406681118226487e-09,
 -2.253353173066943e-10,  1.009636793419643e-11, -4.052083010637013e-13,  1.479793023377141e-14, -4.975538920008510e-16,  1.554338986987933e-17, -4.540943269236571e-19,
  1.066348536897229e-05, -2.468425073423748e-06,  3.138439378920460e-07, -2.840705364834903e-08,  2.033044266374544e-09, -1.217119955750205e-10,  6.311361224922908e-12,
 -2.902340759565087e-13,  1.203807547280150e-14, -4.561028904021082e-16,  1.594207522664367e-17, -5.176512809148656e-19,  2.006125246925100e-06, -5.728785819513511e-07,
  8.828761292610085e-08, -9.517260281239212e-09,  7.991635345533016e-10, -5.542357822706878e-11,  3.292867598529779e-12, -1.718270566428067e-13,  8.017876160814711e-15,
 -3.391329773716334e-16,  1.314063969465264e-17, -4.699213132447152e-19,  3.786329020890905e-07, -1.289557995099976e-07,  2.350043659778697e-08, -2.955188814569655e-09,
  2.858274076984036e-10, -2.257712780036756e-11,  1.512596374908357e-12, -8.821783725705507e-14,  4.564346734720213e-15, -2.125286160927679e-16,  9.006407122479350e-18,
 -3.500909867124796e-19,  7.872154773559893e-08, -3.060928127161790e-08,  6.357884414979159e-09, -9.028727608676708e-10,  9.767382567079855e-11, -8.552695029323805e-12,
  6.300923355588845e-13, -4.011543908136701e-14,  2.250811080916227e-15, -1.129749325789428e-16,  5.132802024972710e-18, -2.128135048486299e-19,  1.674365647140956e-08,
 -7.039817085544911e-09,  1.583499248107331e-09, -2.423114360701216e-10,  2.808590758633963e-11, -2.620520913388246e-12,  2.046706933293018e-13, -1.375040004547299e-14,
  8.107065136208390e-16, -4.259543330881262e-17,  2.018726055852908e-18, -8.702456961372792e-20,  1.167595987591908e-03, -2.651684783446143e-05,  4.220833456643522e-07,
 -5.811022992188116e-09,  7.383262407517851e-11, -8.899957348488577e-13,  1.031383865215567e-14, -1.158948822076865e-16,  1.268232617734587e-18, -1.358503081091375e-20,
  1.424777694751338e-22, -1.472616303112020e-24,  3.166220904334186e-03, -8.996259957569763e-05,  1.904510642663979e-06, -3.513678909586095e-08,  5.915506707098027e-10,
 -9.301327044439503e-12,  1.385504458552511e-13, -1.974269180656831e-15,  2.709479935140469e-17, -3.599948443917216e-19,  4.647942923872058e-21, -5.849632514674823e-23,
  3.729545961409082e-03, -1.423615073336641e-04,  4.043101346746282e-06, -9.709500665562703e-08,  2.078514476416179e-09, -4.083945769084584e-11,  7.498367180514773e-13,
 -1.301943989144030e-14,  2.155871786249071e-16, -3.425898835639178e-18,  5.249672756959044e-20, -7.784871813544720e-22,  2.684511568280964e-03, -1.406077373288262e-04,
  5.231162062996734e-06, -1.591651636731880e-07,  4.227325186916417e-09, -1.014483787427482e-10,  2.246420129384727e-12, -4.654413373068730e-14,  9.113186923898831e-16,
 -1.698632334596578e-17,  3.031153520808886e-19, -5.200174038457703e-21,  1.317820157214149e-03, -9.435690770051591e-05,  4.512568726711614e-06, -1.712776140249629e-07,
  5.563724873533580e-09, -1.608639567177539e-10,  4.239825134103226e-12, -1.035017869512640e-13,  2.366841898534217e-15, -5.112821249693041e-17,  1.050096615066702e-18,
 -2.060373144777936e-20,  4.657316993905928e-04, -4.498489827210762e-05,  2.733100786574545e-06, -1.281749793783620e-07,  5.046527684958662e-09, -1.742758070662131e-10,
  5.421546889867052e-12, -1.546629874874587e-13,  4.097558217869909e-15, -1.017723051084613e-16,  2.386985708385762e-18, -5.314848851440995e-20,  1.230915133566350e-04,
 -1.578476227691661e-05,  1.208716738962926e-06, -6.958856432548778e-08,  3.301149439807280e-09, -1.353871134259019e-10,  4.943314682340941e-12, -1.638750519792048e-13,
  5.001854711134858e-15, -1.420350505203698e-16,  3.782632794284467e-18, -9.502905231710695e-20,  2.527979349168223e-05, -4.232636591688556e-06,  4.057501935391103e-07,
 -2.853093459399052e-08,  1.623392080960904e-09, -7.872739521621726e-11,  3.359278700922041e-12, -1.288432665425970e-13,  4.510216064811385e-15, -1.457472602066939e-16,
  4.386263391240822e-18, -1.237159770864779e-19,  4.242884404639511e-06, -9.108567691369700e-07,  1.084455991959292e-07, -9.260588451595763e-09,  6.289375009073289e-10,
 -3.589980890024084e-11,  1.781923107009228e-12, -7.870094145919805e-14,  3.144281192220161e-15, -1.150473755845832e-16,  3.892278503196934e-18, -1.225907461583917e-19,
  6.269893441401200e-07, -1.687944254142419e-07,  2.465979553608051e-08, -2.534142167013312e-09,  2.038147569560334e-10, -1.359249103150108e-11,  7.792046741660303e-13,
 -3.934689999254970e-14,  1.781272870984598e-15, -7.326141844572137e-17,  2.765872730999084e-18, -9.655123173327493e-20,  9.093230504788624e-08, -2.977573434488613e-08,
  5.228418366712532e-09, -6.357266289335458e-10,  5.964591162231841e-11, -4.583149864133401e-12,  2.994376179997715e-13, -1.706726970440028e-14,  8.646412779258368e-16,
 -3.948722888807160e-17,  1.643713861332159e-18, -6.284813798483123e-20,  1.472405152786066e-08, -5.612842812423945e-09,  1.143321542478032e-09, -1.594762246029713e-10,
  1.697326453408569e-11, -1.464372726795107e-12,  1.064359493793691e-13, -6.693303089026811e-15,  3.713342440482138e-16, -1.844623250632439e-17,  8.301171758602022e-19,
 -3.411731298172040e-20,  2.626768131742993e-09, -1.097922217644096e-09,  2.454637988639152e-10, -3.734698472717993e-11,  4.305892230474488e-12, -3.997882750365883e-13,
  3.108325452763188e-14, -2.079505969870262e-15,  1.221276195544139e-16, -6.393477485280317e-18,  3.019828960430375e-19, -1.297711268626365e-20,  1.067866963980475e-03,
 -2.340029827525176e-05,  3.588923422011964e-07, -4.759677316643945e-09,  5.826709792979292e-11, -6.772338465855045e-13,  7.570593364640978e-15, -8.215165327981203e-17,
  8.678741407394088e-19, -8.995729033763194e-21,  9.105551652954687e-23, -9.115065115318664e-25,  2.834382168715150e-03, -7.626522939596555e-05,  1.534056976694292e-06,
 -2.699669495483736e-08,  4.347584273010781e-10, -6.552302315658423e-12,  9.369047732578639e-14, -1.283196972374819e-15,  1.694307687200046e-17, -2.168088540493547e-19,
  2.697696254306421e-21, -3.274924811174234e-23,  3.218133954691772e-03, -1.141681873576413e-04,  3.053404104913392e-06, -6.950655026669393e-08,  1.415751243603682e-09,
 -2.653931464401769e-11,  4.658777341003883e-13, -7.747292836852049e-15,  1.230489507802564e-16, -1.877966325737916e-18,  2.766969893476213e-20, -3.949454723384567e-22,
  2.195124201182411e-03, -1.053856880163084e-04,  3.668453993166162e-06, -1.052206773315582e-07,  2.646841878381665e-09, -6.036904379394388e-11,  1.273933538467630e-12,
 -2.521008044829709e-14,  4.723430445676965e-16, -8.438779665498858e-18,  1.445503934928573e-19, -2.383640426255604e-21,  1.001430573911581e-03, -6.517727798204942e-05,
  2.900729749357706e-06, -1.033181237788877e-07,  3.167206050462973e-09, -8.677569949846740e-11,  2.174348415709223e-12, -5.059801615832436e-14,  1.105476464855065e-15,
 -2.286109769914666e-17,  4.502849569471020e-19, -8.486434311024657e-21,  3.214191167416378e-04, -2.812516371490587e-05,  1.583881814245442e-06, -6.948846974411858e-08,
  2.575696264337214e-09, -8.413309637016183e-11,  2.484816230402299e-12, -6.750454310673526e-14,  1.707596816488635e-15, -4.058782577736422e-17,  9.128575467683226e-19,
 -1.952709424172765e-20,  7.504419670645135e-05, -8.727881997835306e-06,  6.184959614579554e-07, -3.327237490281274e-08,  1.484798968863291e-09, -5.757563429492974e-11,
  1.995732679557171e-12, -6.302135252757595e-14,  1.837609809525014e-15, -4.997620685283285e-17,  1.277565044210557e-18, -3.087170128235820e-20,  1.316813947733186e-05,
 -2.010845382106095e-06,  1.786940583568424e-07, -1.175771344842042e-08,  6.302561507287540e-10, -2.894480343845451e-11,  1.174573227723490e-12, -4.299601877379481e-14,
  1.440866505344368e-15, -4.469407452008377e-17,  1.294201187715681e-18, -3.519977115619421e-20,  1.815653527167129e-06, -3.592322929502854e-07,  3.988574210228706e-08,
 -3.202822415794053e-09,  2.058394837029805e-10, -1.117432739629777e-11,  5.296976479189725e-13, -2.242111466685360e-14,  8.611118133953651e-16, -3.036955998845921e-17,
  9.927140330107089e-19, -3.027520406962787e-20,  2.113027300538556e-07, -5.325475884011596e-08,  7.336514469893851e-09, -7.155934215203520e-10,  5.491840638164883e-11,
 -3.510251675033782e-12,  1.935789810989938e-13, -9.433378554806023e-15,  4.132775731626905e-16, -1.648934388168400e-17,  6.052328835874920e-19, -2.058159367894415e-20,
  2.331677886503015e-08, -7.294583927947568e-09,  1.227721840851425e-09, -1.436973952695478e-10,  1.302757616663411e-11, -9.704589613836308e-13,  6.164238266391045e-14,
 -3.424256272764278e-15,  1.694357032402978e-16, -7.572182062463355e-18,  3.089751201075619e-19, -1.159842945913412e-20,  2.870221336907799e-09, -1.068481949178221e-09,
  2.126853085374238e-10, -2.904900645387197e-11,  3.033464624690226e-12, -2.572456034851671e-13,  1.840771963252815e-14, -1.141240850113197e-15,  6.249787531855949e-17,
 -3.067949836315193e-18,  1.365666165790598e-19, -5.556912893365059e-21,  4.179646051033647e-10, -1.734730415975464e-10,  3.850576260173001e-11, -5.819333174159191e-12,
  6.667907861118812e-13, -6.155778300661876e-14,  4.761064097181526e-15, -3.169862375807866e-16,  1.853345256477503e-17, -9.662393568680577e-19,  4.546355724980035e-20,
 -1.946758757449204e-21,  9.796674065848446e-04, -2.074274432168891e-05,  3.069528507446625e-07, -3.926618334742076e-09,  4.636807814324527e-11, -5.202802410947378e-13,
  5.615061941581488e-15, -5.892970569989497e-17,  6.009744548430076e-19, -6.042531458705174e-21,  5.910233898918580e-23, -5.670087895642711e-25,  2.551969161256580e-03,
 -6.517958287407887e-05,  1.247873762413359e-06, -2.097795545827623e-08,  3.235763364628640e-10, -4.680150408425569e-12,  6.431172588685581e-14, -8.475955111249325e-16,
  1.077745817957716e-17, -1.329698365058013e-19,  1.596007241989103e-21, -1.869559517179695e-23,  2.805528197878756e-03, -9.272891365810654e-05,  2.339505682542707e-06,
 -5.055979648213886e-08,  9.812645300415101e-10, -1.757198972273026e-11,  2.952625243870010e-13, -4.707692825363876e-15,  7.179102721308266e-17, -1.053276442319825e-18,
  1.493477231025546e-20, -2.053513880210365e-22,  1.825187627030812e-03, -8.045075389327732e-05,  2.624851295207178e-06, -7.108155604652464e-08,  1.695795055364896e-09,
 -3.680259001216416e-11,  7.408986106590538e-13, -1.401692306181128e-14,  2.515307588520030e-16, -4.310665618565284e-18,  7.092902354310014e-20, -1.124964228483205e-21,
  7.803438698822166e-04, -4.618483770164287e-05,  1.915714464884508e-06, -6.411001138596229e-08,  1.856612167792578e-09, -4.824699128520061e-11,  1.150246752579960e-12,
 -2.553293549427233e-14,  5.333024037156436e-16, -1.056336191763928e-17,  1.996213950283860e-19, -3.615171979700158e-21,  2.298230141184666e-04, -1.819858997750809e-05,
  9.507332338976388e-07, -3.904508804892277e-08,  1.363271881555535e-09, -4.213867488059228e-11,  1.181973999257402e-12, -3.058739897810017e-14,  7.389159144467001e-16,
 -1.680995064220837e-17,  3.625661313988427e-19, -7.451005793444401e-21,  4.797285357512408e-05, -5.046287849378639e-06,  3.308063462871908e-07, -1.662395783052202e-08,
  6.977169005463903e-10, -2.557445304330951e-11,  8.413454420549036e-13, -2.529957952469007e-14,  7.044821400549841e-16, -1.834216393309625e-17,  4.498822271395935e-19,
 -1.045157774053954e-20,  7.284733362139359e-06, -1.009986907294726e-06,  8.303570038062585e-08, -5.104770917232773e-09,  2.574554086888543e-10, -1.118403998807580e-11,
  4.311361660396188e-13, -1.504614158237684e-14,  4.821894982278439e-16, -1.434194804830647e-17,  3.991725461357871e-19, -1.045801774289529e-20,  8.347179066066270e-07,
 -1.512609862609012e-07,  1.560285455805544e-08, -1.174667629962506e-09,  7.125831777122214e-11, -3.670715105516036e-12,  1.658291376163683e-13, -6.713978885374309e-15,
  2.474230433305686e-16, -8.396077034271729e-18,  2.647191790076761e-19, -7.804577719707713e-21,  7.696547826304629e-08, -1.802576122183822e-08,  2.329238288667705e-09,
 -2.147066993641569e-10,  1.566503213661143e-11, -9.564905927710528e-13,  5.059160661886419e-14, -2.372776491195116e-15,  1.003447022953859e-16, -3.874863657737177e-18,
  1.379706985224019e-19, -4.561223672639124e-21,  6.421910888231051e-09, -1.905817236134403e-09,  3.056800452747611e-10, -3.427365355922169e-11,  2.989942253327587e-12,
 -2.151337198719288e-13,  1.324177483945277e-14, -7.147923947574261e-16,  3.445263664926897e-17, -1.503049500130152e-18,  5.998417381126317e-20, -2.206119974248615e-21,
  5.869506613491351e-10, -2.123598526732329e-10,  4.113264127740009e-11, -5.480948206615340e-12,  5.597821996335072e-13, -4.653072442198479e-14,  3.269929467256794e-15,
 -1.994305374540273e-16,  1.075958398726838e-17, -5.210249561322872e-19,  2.290523274821571e-20, -9.214246399814758e-22,  6.763026745171118e-11, -2.783200759681719e-11,
  6.125080043608774e-12, -9.183350645585996e-13,  1.044606851935352e-13, -9.579778098392971e-15,  7.364310853142171e-16, -4.875773818432644e-17,  2.836152809522792e-18,
 -1.471640810617651e-19,  6.894127105944286e-21, -2.940153288489424e-22,  9.013260713239275e-04, -1.846373296864792e-05,  2.639636552182903e-07, -3.261176219033945e-09,
  3.718686944842513e-11, -4.033318223336934e-13,  4.204557141981475e-15, -4.276706315914873e-17,  4.206590958816237e-19, -4.104624306296248e-21,  3.943358905344775e-23,
 -3.409154785782240e-25,  2.309738000297939e-03, -5.612212825044701e-05,  1.024363903402733e-06, -1.647311623579787e-08,  2.436699205822913e-10, -3.386509124839504e-12,
  4.476706445221245e-14, -5.684305051419782e-16,  6.966074633992608e-18, -8.294328250806139e-20,  9.621396094549396e-22, -1.085113505097702e-23,  2.468546581574294e-03,
 -7.619724741671770e-05,  1.816527078223384e-06, -3.732661825397976e-08,  6.912173660793877e-10, -1.183919005607705e-11,  1.906391551480994e-13, -2.917369260362239e-15,
  4.275811987506459e-17, -6.035993154884347e-19,  8.243629319645040e-21, -1.092828576733653e-22,  1.540564638181232e-03, -6.245286688698706e-05,  1.913179925067221e-06,
 -4.898985679728254e-08,  1.109924959375605e-09, -2.294714126376537e-11,  4.411884713567481e-13, -7.987285856319671e-15,  1.373978586094338e-16, -2.260535336512762e-18,
  3.575532288170784e-20, -5.458386950414839e-22,  6.220107969016220e-04, -3.349607456728440e-05,  1.297055247102066e-06, -4.083620676454975e-08,  1.118476554705229e-09,
 -2.759482356367255e-11,  6.264908818131994e-13, -1.327566666968163e-14,  2.652631200294313e-16, -5.035464405016643e-18,  9.134348791860878e-20, -1.590306760272746e-21,
  1.697230674413915e-04, -1.215138811422003e-05,  5.895536322881648e-07, -2.268304374901598e-08,  7.465551757149068e-10, -2.184970493333034e-11,  5.823560144703538e-13,
 -1.436128322155008e-14,  3.314247957005178e-16, -7.218101758281122e-18,  1.493249786126666e-19, -2.948503666332064e-21,  3.204156945594048e-05, -3.040786817462987e-06,
  1.844117254258628e-07, -8.657056663003759e-09,  3.417372365559902e-10, -1.184051866732883e-11,  3.696700709638938e-13, -1.058405079907852e-14,  2.813975356409109e-16,
 -7.012430873227245e-18,  1.649759740427907e-19, -3.683526366359747e-21,  4.265708542131661e-06, -5.346516716817723e-07,  4.060651309753102e-08, -2.329780332935742e-09,
  1.104489866909494e-10, -4.534401744016707e-12,  1.659095842110565e-13, -5.515388060569776e-15,  1.688865120935287e-16, -4.812541988098401e-18,  1.286316162711993e-19,
 -3.243406019317284e-21,  4.115002336565726e-07, -6.787701613470733e-08,  6.482963373861939e-09, -4.564004068277638e-10,  2.607528215043681e-11, -1.272045433780437e-12,
  5.466588752832047e-14, -2.113345709324357e-15,  7.460490261622498e-17, -2.432017119426592e-18,  7.384600839965175e-20, -2.101548011590647e-21,  3.034023794518506e-08,
 -6.552546256600853e-09,  7.900388386344923e-10, -6.853551675818974e-11,  4.736771741589430e-12, -2.754138208532857e-13,  1.393207162753082e-14, -6.272173772660354e-16,
  2.554199526413079e-17, -9.524049185139908e-19,  3.282666282022033e-20, -1.052870760737565e-21,  1.910567171234751e-09, -5.335607268146226e-10,  8.104992686122442e-11,
 -8.660674099255187e-12,  7.238043210380159e-13, -5.010873896427824e-14,  2.978409604091043e-15, -1.557439873392241e-16,  7.291683001189907e-18, -3.097340372106466e-19,
  1.206092053626615e-20, -4.336491724297475e-22,  1.268545860353571e-10, -4.434685459870326e-11,  8.316386203784774e-12, -1.076498964146035e-12,  1.071332082452528e-13,
 -8.700705510359991e-15,  5.987789875549659e-16, -3.583467297008648e-17,  1.900419999929958e-18, -9.059842258699430e-20,  3.926379388201552e-21, -1.559001504497628e-22,
  1.116481906987317e-11, -4.547284575909856e-12,  9.904374451632891e-13, -1.470906276373964e-13,  1.658763393638958e-14, -1.509323775864797e-15,  1.152029210610370e-16,
 -7.577953519629675e-18,  4.381828592580465e-19, -2.261295814469801e-20,  1.054030055063381e-21, -4.474396785603390e-23,  8.314602225530394e-04, -1.649902471624570e-05,
  2.281499909146803e-07, -2.725618080041642e-09,  3.003965037053450e-11, -3.153974010743919e-13,  3.175336411153072e-15, -3.139201558127213e-17,  2.981417607672875e-19,
 -2.776225950555563e-21,  2.815172267518481e-23, -1.808258543294522e-25,  2.100474582653706e-03, -4.865644175242302e-05,  8.480190537593133e-07, -1.306285388594784e-08,
  1.855140050280589e-10, -2.480417733305907e-12,  3.157093453032015e-14, -3.867041185161468e-16,  4.571786761480551e-18, -5.250756665001939e-20,  5.920944382288077e-22,
 -6.373583610427159e-24,  2.190228782754285e-03, -6.328520523623746e-05,  1.427886210994611e-06, -2.793804553515138e-08,  4.942918261848381e-10, -8.107488562714560e-12,
  1.252463520359769e-13, -1.841477901306545e-15,  2.596474340430688e-17, -3.529929840371918e-19,  4.647094010810806e-21, -5.945601188704824e-23,  1.318025333104778e-03,
 -4.922852721023219e-05,  1.418384736643436e-06, -3.439526523746013e-08,  7.410333347174666e-10, -1.461189008352461e-11,  2.685906462046373e-13, -4.657539254637304e-15,
  7.687227493195578e-17, -1.215214960199388e-18,  1.848809283023513e-20, -2.719118986560117e-22,  5.060560221866165e-04, -2.481274552950965e-05,  8.985202165463400e-07,
 -2.664985886859114e-08,  6.911571296058307e-10, -1.620577922994050e-11,  3.506910796073752e-13, -7.099733651499266e-15,  1.358071939281845e-16, -2.472310098979481e-18,
  4.307233074693894e-20, -7.213159584709812e-22,  1.290748324465352e-04, -8.349560750792126e-06,  3.767378298503361e-07, -1.359259459636574e-08,  4.220620409056338e-10,
 -1.170452096631414e-11,  2.966054711219251e-13, -6.973857106075289e-15,  1.538112260114134e-16, -3.208073239337697e-18,  6.367317666613937e-20, -1.208264907944005e-21,
  2.228198511233754e-05, -1.903380006282435e-06,  1.068435990192787e-07, -4.686742893931029e-09,  1.740556489116633e-10, -5.701653761125469e-12,  1.689556498452234e-13,
 -4.606050138678058e-15,  1.169229099855617e-16, -2.788558517670609e-18,  6.291779675294988e-20, -1.349870586473445e-21,  2.634566828471440e-06, -2.972958481078594e-07,
  2.083946970735161e-08, -1.115023451514177e-09,  4.965727941279831e-11, -1.925501720363953e-12,  6.682989698986584e-14, -2.114950206347721e-15,  6.183942747070624e-17,
 -1.687108035482963e-18,  4.327468478364825e-20, -1.049392967026339e-21,  2.169783469627424e-07, -3.238167651591249e-08,  2.855540396014868e-09, -1.875707769475859e-10,
  1.007403544457337e-11, -4.646285685748697e-13,  1.896448966892066e-14, -6.990031674808041e-16,  2.360387959764625e-17, -7.381302956195177e-19,  2.155487929489431e-20,
 -5.913136604957365e-22,  1.294815338197064e-08, -2.558210196636010e-09,  2.863690177624869e-10, -2.328717396093430e-11,  1.519533391303799e-12, -8.388367593695657e-14,
  4.047308480384258e-15, -1.744648201837276e-16,  6.825424315365153e-18, -2.452145358090773e-19,  8.164350791942444e-21, -2.535505088779593e-22,  6.170980391508331e-10,
 -1.607408947422931e-10,  2.297321649915847e-11, -2.327002727330022e-12,  1.854583993374516e-13, -1.230393876331497e-14,  7.037121386208319e-16, -3.553139326349158e-17,
  1.611107403028084e-18, -6.645438990058932e-20,  2.518620689392010e-21, -8.832582436242014e-23,  2.921496961513977e-11, -9.798781165179999e-12,  1.768594596435447e-12,
 -2.212849724397633e-13,  2.136765968690125e-14, -1.689234170529318e-15,  1.134765903927948e-16, -6.644781891826691e-18,  3.455094746890872e-19, -1.617879447420179e-20,
  6.897957979848415e-22, -2.698358881367118e-23,  1.888297331498445e-12, -7.592874843078462e-13,  1.633086610968693e-13, -2.397647727015285e-14,  2.676073467776136e-15,
 -2.412429355691790e-16,  1.825934018706894e-17, -1.191966725517984e-18,  6.844732249955652e-20, -3.510014933779031e-21,  1.626617714899711e-22, -6.868428965123280e-24,
  7.689183119052782e-04, -1.479693758328921e-05,  1.981308584159255e-07, -2.291587184851552e-09,  2.442779296399779e-11, -2.487438869367527e-13,  2.416372583854425e-15,
 -2.324666401976954e-17,  2.168712394485440e-19, -1.774919103449364e-21,  2.263357443971610e-23, -8.280158710779960e-26,  1.918490926221469e-03, -4.245236640781144e-05,
  7.075610427952010e-07, -1.045373300983777e-08,  1.426842098921071e-10, -1.837712062879223e-12,  2.253688878552660e-14, -2.665748868507370e-16,  3.048317073988764e-18,
 -3.356699216799498e-20,  3.736574990441646e-22, -3.791894909576329e-24,  1.957985648481014e-03, -5.308003731446843e-05,  1.135215639253528e-06, -2.117923366546046e-08,
  3.584644038082684e-10, -5.636999572946512e-12,  8.363572070458851e-14, -1.182608064519832e-15,  1.605659906427649e-17, -2.104425567138176e-19,  2.671622476450610e-21,
 -3.303442246101364e-23,  1.141449234688903e-03, -3.935099703413630e-05,  1.068161283558037e-06, -2.456620266842898e-08,  5.039759220404556e-10, -9.488522129760371e-12,
  1.669381164971519e-13, -2.775357072570901e-15,  4.398582363536933e-17, -6.688763934553629e-19,  9.789708815413299e-21, -1.388814240495734e-22,  4.193922744444192e-04,
 -1.873774702474448e-05,  6.356930055838851e-07, -1.778667026265881e-08,  4.373330157574959e-10, -9.755349292747074e-12,  2.014141891924640e-13, -3.898897453099094e-15,
  7.144841347464471e-17, -1.248355847678337e-18,  2.089637930803303e-20, -3.368362220958609e-22,  1.008127803387622e-04, -5.888873051241275e-06,  2.475125431380161e-07,
 -8.383148983973469e-09,  2.458184175294232e-10, -6.464433113158981e-12,  1.558652739907473e-13, -3.496148905265129e-15,  7.372990336707009e-17, -1.473400225387985e-18,
  2.806541509414828e-20, -5.119798225833042e-22,  1.607875159836405e-05, -1.233677326662313e-06,  6.415881526864783e-08, -2.631079678620975e-09,  9.197193165348409e-11,
 -2.849448937044272e-12,  8.016544308834286e-14, -2.081363648905039e-15,  5.045148037895620e-17, -1.151631310123950e-18,  2.491961742403242e-20, -5.136979276901117e-22,
  1.709891076021929e-06, -1.730408189263146e-07,  1.119105450876845e-08, -5.581693304336733e-10,  2.334447738021062e-11, -8.546824505704858e-13,  2.812885116241942e-14,
 -8.470953541825069e-16,  2.364021742459748e-17, -6.171877375560394e-19,  1.518442885439372e-20, -3.539238637411961e-22,  1.219906522445591e-07, -1.637392001245902e-08,
  1.330178930456287e-09, -8.138066540202340e-11,  4.102726260449082e-12, -1.786551236529503e-13,  6.916950332652059e-15, -2.427704127614717e-16,  7.832073880503965e-18,
 -2.346673956112840e-19,  6.582605132129828e-21, -1.738655192466972e-22,  5.977716771818617e-09, -1.071691535126222e-09,  1.108712253819425e-10, -8.421173700649153e-12,
  5.172177614693979e-13, -2.703523618263704e-14,  1.241089876770543e-15, -5.110730139182530e-17,  1.916667034687939e-18, -6.620909367143325e-20,  2.125245104399902e-21,
 -6.378640130727182e-23,  2.172868007579196e-10, -5.228134538018751e-11,  6.982761264786949e-12, -6.668297811995325e-13,  5.044754291431903e-14, -3.194380236509294e-15,
  1.751649377557165e-16, -8.512000750144460e-18,  3.726813524981989e-19, -1.488590956682065e-20,  5.477108575308585e-22, -1.869010267279600e-23,  7.233811341185618e-12,
 -2.307994894369546e-12,  3.981855855473839e-13, -4.788239057696602e-14,  4.464487242940839e-15, -3.421286777938083e-16,  2.235218100884429e-17, -1.276518222109207e-18,
  6.489168228626584e-20, -2.976947147541013e-21,  1.245780580492752e-22, -4.791131233287938e-24,  3.289148310530456e-13, -1.301525810598303e-13,  2.756255264612277e-14,
 -3.990543856755181e-15,  4.398797156472674e-16, -3.921528235842786e-17,  2.938656358890071e-18, -1.901170442292711e-19,  1.082877304120338e-20, -5.512161091255334e-22,
  2.537302057763317e-23, -1.064813462163367e-24,  7.127354009836678e-04, -1.331560120421921e-05,  1.728223438573614e-07, -1.937598465048159e-09,  1.998394578089938e-11,
 -1.978305755201674e-13,  1.854226063742045e-15, -1.716094193709589e-17,  1.684712058799762e-19, -9.356875032076215e-22,  1.924300904504761e-23, -9.573563454685540e-26,
  1.759259287582984e-03, -3.725746137536188e-05,  5.946897506503458e-07, -8.437784307431862e-09,  1.107868101198298e-10, -1.376394124952631e-12,  1.627560110843098e-14,
 -1.857745518572465e-16,  2.073282290813201e-18, -2.147173116314817e-20,  2.413632056574665e-22, -2.378459487634274e-24,  1.762346510593484e-03, -4.492532471913368e-05,
  9.120818461656745e-07, -1.624695893550386e-08,  2.633876662060429e-10, -3.975365371605380e-12,  5.670922518503233e-14, -7.719264608807876e-16,  1.009930054836512e-17,
 -1.277992228127125e-19,  1.564250425117970e-21, -1.870870276391396e-23,  9.994449418259592e-04, -3.186093176420671e-05,  8.161253855672084e-07, -1.782688458606893e-08,
  3.487126755817348e-10, -6.275290812437706e-12,  1.057905713892861e-13, -1.688021291136348e-15,  2.569667261645723e-17, -3.766535809692286e-19,  5.300739247065330e-21,
 -7.255856592823901e-23,  3.534109189463248e-04, -1.440029741045590e-05,  4.585578900267083e-07, -1.212050351651010e-08,  2.829006601195692e-10, -6.009482556809547e-12,
  1.184995181719143e-13, -2.195375571770179e-15,  3.856068700830980e-17, -6.474095287205256e-19,  1.041434508063869e-20, -1.616613976512260e-22,  8.066329184311044e-05,
 -4.252954426242443e-06,  1.668245461558921e-07, -5.310161470128787e-09,  1.472031038928550e-10, -3.673996249414825e-12,  8.435242695068796e-14, -1.806296034809914e-15,
  3.644098991354854e-17, -6.981879389621309e-19,  1.276725615571703e-20, -2.239773314970509e-22,  1.200097787092390e-05, -8.254208270237294e-07,  3.982595865017198e-08,
 -1.527868078105498e-09,  5.030433576102490e-11, -1.474769326296988e-12,  3.940895495412697e-14, -9.747896572286927e-16,  2.256778833774737e-17, -4.931532660265798e-19,
  1.023485088835752e-20, -2.027284976586349e-22,  1.161873167192176e-06, -1.050502156287281e-07,  6.269985047445874e-09, -2.914803054316996e-10,  1.144835552350914e-11,
 -3.957180505035552e-13,  1.234798922737918e-14, -3.537890632336993e-16,  9.421169475017369e-18, -2.353039286818702e-19,  5.550652314558521e-21, -1.243044591302456e-22,
  7.287226525130554e-08, -8.745479068273804e-09,  6.535020828288339e-10, -3.718848724526871e-11,  1.757923494637727e-12, -7.220012315781224e-14,  2.648929489702300e-15,
 -8.844379721825126e-17,  2.723302485749954e-18, -7.810281805700507e-20,  2.102365293443686e-21, -5.341049485319975e-23,  2.980119243130333e-09, -4.808259206641654e-10,
  4.578823360925278e-11, -3.238160230886237e-12,  1.867040018587798e-13, -9.218632727817560e-15,  4.017632803257700e-16, -1.577216304171128e-17,  5.659047608483778e-19,
 -1.876076255467971e-20,  5.795214114603382e-22, -1.678041877370649e-23,  8.365151048468220e-11, -1.839887999612018e-11,  2.280976757612697e-12, -2.042647969124870e-13,
  1.460255057259153e-14, -8.790226621731083e-16,  4.604930501607832e-17, -2.146671242075486e-18,  9.048333492560516e-20, -3.490143177590505e-21,  1.243474641433230e-22,
 -4.118955985049447e-24,  1.943689576779049e-12, -5.839380034110617e-13,  9.554304086002214e-14, -1.097166909714863e-14,  9.824569163250120e-16, -7.264342290113466e-17,
  4.597004095946257e-18, -2.551257811363473e-19,  1.263889931945049e-20, -5.664237142207483e-22,  2.320522225905390e-23, -8.753592267809183e-25,  5.940330202246830e-14,
 -2.303239180822711e-14,  4.784368396058514e-15, -6.809097112350571e-16,  7.392857473913557e-17, -6.502864462428633e-18,  4.815136754387008e-19, -3.082033253578570e-20,
  1.738682978435925e-21, -8.773890548275044e-23,  4.007030181668558e-24, -1.669621138830167e-25,  6.620981924187444e-04, -1.202087730771289e-05,  1.513664643681360e-07,
 -1.647243074280567e-09,  1.643646239563939e-11, -1.585120911079806e-13,  1.445131621577369e-15, -1.217074199499392e-17,  1.472690287861353e-19, -2.922691917876338e-22,
  1.152663841463613e-23, -2.882383249309824e-25,  1.619143153930087e-03, -3.287678549926859e-05,  5.032276743592658e-07, -6.865837247145215e-09,  8.677967694476371e-11,
 -1.041355367278563e-12,  1.189871108869054e-14, -1.301240505598659e-16,  1.451013284468296e-18, -1.368418649315373e-20,  1.523133869296517e-22, -1.784485243015887e-24,
  1.596097490292437e-03, -3.834247864120179e-05,  7.400007449770557e-07, -1.260160812428275e-08,  1.959119928869278e-10, -2.841048269940902e-12,  3.900572459646197e-14,
 -5.117278829756101e-16,  6.451447821088933e-18, -7.901263350598323e-20,  9.327843259148633e-22, -1.074086855171105e-23,  8.838267468883188e-04, -2.610148498607043e-05,
  6.319441469833609e-07, -1.312812286463220e-08,  2.452000873444159e-10, -4.221779851966787e-12,  6.825886264723220e-14, -1.047271558670754e-15,  1.529346627106508e-17,
 -2.168283307273214e-19,  2.936628782220314e-21, -3.852374966602024e-23,  3.023232373348380e-04, -1.124489441755145e-05,  3.367529777845442e-07, -8.419728238275079e-09,
  1.868104772428295e-10, -3.782676046842604e-12,  7.130206934302079e-14, -1.266043861233185e-15,  2.130782443124657e-17, -3.444271701485039e-19,  5.327725273128354e-21,
 -7.950255196060906e-23,  6.596706438457483e-05, -3.138153085172709e-06,  1.151237093898789e-07, -3.447847133936267e-09,  9.046498893809770e-11, -2.144807958323942e-12,
  4.692807585357440e-14, -9.602706998139233e-16,  1.853696843617409e-17, -3.408345204301060e-19,  5.986102433881465e-21, -1.009761958330918e-22,  9.237124082068696e-06,
 -5.684165860845910e-07,  2.549164333593904e-08, -9.155697626281468e-10,  2.841746309272590e-11, -7.888368871049499e-13,  2.003248930938574e-14, -4.723241999396105e-16,
  1.044652937634169e-17, -2.186201015936379e-19,  4.352625635536066e-21, -8.284581098233353e-23,  8.235567035591439e-07, -6.627885609200460e-08,  3.654328234481758e-09,
 -1.583619488685199e-10,  5.842798977735278e-12, -1.906963903767584e-13,  5.642136133924672e-15, -1.538042492914354e-16,  3.907708351291213e-18, -9.335849378942143e-20,
  2.111127422019450e-21, -4.541195383360836e-23,  4.607432211623671e-08, -4.915218061759037e-09,  3.376011673693329e-10, -1.785270483847071e-11,  7.907393566493736e-13,
 -3.060979699738359e-14,  1.063455439073939e-15, -3.375355660548083e-17,  9.912101517216452e-19, -2.718904660158157e-20,  7.017477945538009e-22, -1.713322915944211e-23,
  1.600076261815980e-09, -2.303964058841607e-10,  2.013026994064972e-11, -1.321977812706276e-12,  7.139580005896988e-14, -3.323291115125448e-15,  1.372420784373715e-16,
 -5.127115886323037e-18,  1.756969887321172e-19, -5.580599672488581e-21,  1.656223684736660e-22, -4.619276204463637e-24,  3.526445721004666e-11, -7.011717025325494e-12,
  8.016563358932225e-13, -6.697735857413502e-14,  4.505153039969857e-15, -2.568410548679233e-16,  1.281057376480831e-17, -5.710977542921835e-19,  2.310740858992254e-20,
 -8.583949991325541e-22,  2.953898403534085e-23, -9.475402582241976e-25,  5.719995199544844e-13, -1.598763223181729e-13,  2.459206167180255e-14, -2.677936466439426e-15,
  2.289450147092631e-16, -1.625108545412637e-17,  9.917175317258494e-19, -5.327693191668742e-20,  2.563117450430257e-21, -1.118628810175947e-22,  4.473747167354932e-24,
 -1.651048304114636e-25,  1.121987875321008e-14, -4.237800109569249e-15,  8.591975047483240e-16, -1.197105103516823e-16,  1.275836107798521e-17, -1.104105677932337e-18,
  8.058674784382927e-20, -5.092580117580163e-21,  2.840260681785798e-22, -1.418644675548557e-23,  6.419245974896030e-25, -2.652444265668926e-26,  6.163173648544207e-04,
 -1.088477177446307e-05,  1.330786403816415e-07, -1.407843542439955e-09,  1.358816913715130e-11, -1.273930345383044e-13,  1.169208728106227e-15, -7.567981011791559e-18,
  1.411135865307801e-19, -1.831037631500495e-22, -8.729643232935756e-24, -6.500623727193520e-25,  1.495197207529889e-03, -2.915840806027364e-05,  4.285282725014546e-07,
 -5.629613185803636e-09,  6.853846488459440e-11, -7.946780100046256e-13,  8.838742449762506e-15, -9.054839792700648e-17,  1.049548299486261e-18, -9.122044714249126e-21,
  7.600568286007742e-23, -1.748562956375882e-24,  1.453679790853544e-03, -3.297807233753816e-05,  6.058662977293461e-07, -9.875203741575017e-09,  1.474020832373856e-10,
 -2.055914932820738e-12,  2.718643512339179e-14, -3.444210294456115e-16,  4.178939257155234e-18, -4.962770733046295e-20,  5.695340564077443e-22, -6.177508626056970e-24,
  7.886205449103930e-04, -2.161527185587604e-05,  4.954227985082303e-07, -9.800456793131053e-09,  1.750293117886839e-10, -2.886626107952804e-12,  4.475759859544644e-14,
 -6.630341277271084e-16,  9.250933717609722e-18, -1.271311658432547e-19,  1.678837257681025e-21, -2.047598840791780e-23,  2.621566568299010e-04, -8.909405374714716e-06,
  2.514247697127565e-07, -5.953810928275052e-09,  1.257525059198422e-10, -2.429907556566971e-12,  4.379264211919977e-14, -7.474277261238812e-16,  1.203071480970760e-17,
 -1.875187917371297e-19,  2.804268690142346e-21, -3.982292533977947e-23,  5.502528614116862e-05, -2.360957076441706e-06,  8.119447105114175e-08, -2.290448733663394e-09,
  5.695737377262248e-11, -1.284032837311085e-12,  2.678567392538418e-14, -5.246702512926178e-16,  9.686904107936813e-18, -1.710919457036173e-19,  2.891514578891258e-21,
 -4.678976266166136e-23,  7.311261717309608e-06, -4.017504095772318e-07,  1.678603560242200e-08, -5.648814010129976e-10,  1.654552483168401e-11, -4.352098146905403e-13,
  1.050807070374441e-14, -2.363859155780296e-16,  4.995043531179908e-18, -1.001612350743602e-19,  1.914228995573039e-21, -3.499775881786672e-23,  6.067889366408027e-07,
 -4.330478024524641e-08,  2.209400991005525e-09, -8.927596945203439e-11,  3.095852806973129e-12, -9.543988331449570e-14,  2.677922891840412e-15, -6.947431586114454e-17,
  1.684068617598258e-18, -3.848723475035477e-20,  8.343036565092893e-22, -1.723439584260810e-23,  3.071023942252468e-08, -2.895143303114156e-09,  1.828245688543440e-10,
 -8.978480510503461e-12,  3.725090229156917e-13, -1.358573418866146e-14,  4.467571483349354e-16, -1.347354088101443e-17,  3.771439810232220e-19, -9.888890389308968e-21,
  2.445779076214543e-22, -5.734892068233330e-24,  9.220768954293679e-10, -1.174811895323666e-10,  9.396609901978565e-12, -5.717835465311446e-13,  2.887498298972395e-14,
 -1.265026562662043e-15,  4.942713274589658e-17, -1.754576659725045e-18,  5.734127462983324e-20, -1.742483504477908e-21,  4.961443775527517e-23, -1.330980310424480e-24,
  1.627890371809432e-11, -2.891795172986716e-12,  3.031206350558519e-13, -2.351718908687751e-14,  1.482560884170275e-15, -7.977053281842506e-17,  3.776196598953360e-18,
 -1.605185368888827e-19,  6.217479529148325e-21, -2.218661279371862e-22,  7.356194138924184e-24, -2.279817121457656e-25,  1.859529640388646e-13, -4.768328881556831e-14,
  6.830481149781015e-15, -7.000705798625925e-16,  5.678837734615046e-17, -3.849056409396226e-18,  2.254490007160453e-19, -1.167508293295951e-20,  5.434247294354688e-22,
 -2.301844266402314e-23,  8.959262678047363e-25, -3.225808025887895e-26,  2.240715000142230e-15, -8.178963756980468e-16,  1.608035809940084e-16, -2.181853087331501e-17,
  2.272746092903732e-18, -1.928078696466272e-19,  1.382947032390177e-20, -8.605951014981623e-22,  4.734651051403823e-23, -2.336191261490499e-24,  1.045605906608223e-25,
 -4.278172073110880e-27,  5.748055145403493e-04, -9.884207212101614e-06,  1.174096664453525e-07, -1.209354053946359e-09,  1.130635204501724e-11, -1.013746091079128e-13,
  1.018695959298782e-15, -3.287744839141550e-18,  1.203564603024281e-19, -1.209646615763900e-21, -4.474004505603316e-23, -9.334939744245065e-25,  1.385016992706228e-03,
 -2.598289789480142e-05,  3.670632551634620e-07, -4.649417960267424e-09,  5.457922970772605e-11, -6.094635116900260e-13,  6.727517124253358e-15, -6.178310140280719e-17,
  7.570053861239739e-19, -7.655214704564922e-21, -3.193092998254102e-24, -1.805769085778803e-24,  1.330763600647570e-03, -2.856796827943162e-05,  5.002640366338679e-07,
 -7.813292406184271e-09,  1.120990060143142e-10, -1.505560655868944e-12,  1.917476843317646e-14, -2.353601147863543e-16,  2.745174237999677e-18, -3.139625346344982e-20,
  3.611945877910445e-22, -3.537839513245010e-24,  7.094032561510256e-04, -1.807874097487025e-05,  3.928881060941251e-07, -7.409244257438418e-09,  1.266913464783134e-10,
 -2.005577070441970e-12,  2.973225694755489e-14, -4.288258053095776e-16,  5.696865785333012e-18, -7.468369253142301e-20,  1.013962056756752e-21, -1.075912714521275e-23,
  2.301331892085722e-04, -7.152940311848222e-06,  1.906148021153020e-07, -4.279856181234837e-09,  8.617035256587414e-11, -1.592057202267574e-12,  2.737620097050114e-14,
 -4.518065153624751e-16,  6.940569832992255e-18, -1.036056188213169e-19,  1.533286022548780e-21, -2.019331992455164e-23,  4.672605209411245e-05, -1.807597713052911e-06,
  5.843039984627274e-08, -1.554077928106636e-09,  3.667482062069402e-11, -7.874204786481262e-13,  1.564724737463530e-14, -2.943953822746790e-16,  5.194744722663685e-18,
 -8.796665213967213e-20,  1.441971214544709e-21, -2.221703742942038e-23,  5.935486916692750e-06, -2.906585303998314e-07,  1.134752651422581e-08, -3.580475009826524e-10,
  9.908060354589495e-12, -2.472491384540571e-13,  5.675139699399639e-15, -1.220207111147360e-16,  2.463279023878493e-18, -4.731587596739808e-20,  8.700759941188852e-22,
 -1.525454242291137e-23,  4.631578489677488e-07, -2.919801758205928e-08,  1.382037310085060e-09, -5.208692535559020e-11,  1.698962139471646e-12, -4.950552374442371e-14,
  1.317370130257366e-15, -3.254980473290605e-17,  7.527933814375700e-19, -1.645702899639126e-20,  3.421549798561104e-22, -6.784781331773901e-24,  2.149240732381726e-08,
 -1.779606760906255e-09,  1.034647582078944e-10, -4.716849963621661e-12,  1.833218318955410e-13, -6.298847076030589e-15,  1.959970050266003e-16, -5.615846744193353e-18,
  1.497829354857244e-19, -3.752687745970820e-21,  8.890773561965540e-23, -2.001065956088796e-24,  5.680370271705334e-10, -6.347401806786400e-11,  4.643022730803144e-12,
 -2.613355475024231e-13,  1.232527465147519e-14, -5.076220867553609e-16,  1.874250125418913e-17, -6.314744569734303e-19,  1.965791488708268e-20, -5.708287777844926e-22,
  1.557503007541463e-23, -4.013959209774343e-25,  8.216470291997564e-12, -1.287878304141231e-12,  1.231683453323774e-13, -8.836835696538395e-15,  5.203403542515548e-16,
 -2.634280671368433e-17,  1.180195209368068e-18, -4.770952141627294e-20,  1.764629498379104e-21, -6.034386627138460e-23,  1.923339610498260e-24, -5.746379475603941e-26,
  6.726672590242198e-14, -1.557307531661692e-14,  2.057287584380859e-15, -1.969429699179216e-16,  1.506202349923034e-17, -9.694818735580132e-19,  5.424034002353603e-20,
 -2.695985190150295e-21,  1.209352537183549e-22, -4.954151927383012e-24,  1.870559100059014e-25, -6.551335152974973e-27,  4.797783192708638e-16, -1.673944125121001e-16,
  3.164425115115746e-17, -4.153331992624816e-18,  4.205512555659282e-19, -3.481738735945638e-20,  2.444930075066734e-21, -1.493447626109249e-22,  8.082758767798056e-24,
 -3.930615167891950e-25,  1.736521918770350e-26, -7.023019042646261e-28,  5.370594786487628e-04, -9.000049132183158e-06,  1.039201552530119e-07, -1.043368100798030e-09,
  9.517917423176725e-12, -7.764993639594094e-14,  9.710906059026240e-16, -5.571780138644040e-19,  3.503669609968920e-20, -3.767748281360337e-21, -7.970860731499534e-23,
 -4.379773560754044e-25,  1.286624862964237e-03, -2.325559048566019e-05,  3.161345210667239e-07, -3.865433991513482e-09,  4.387749052096341e-11, -4.662841631527108e-13,
  5.294251164060723e-15, -4.214215316670960e-17,  4.610287191579549e-19, -9.236206819028899e-21, -6.980641252044276e-23, -9.459538192367276e-25,  1.223942362649676e-03,
 -2.491253953813740e-05,  4.163476369350349e-07, -6.237668607002376e-09,  8.610315110257453e-11, -1.115472296991257e-12,  1.366287530606119e-14, -1.630843711314117e-16,
  1.841990542775456e-18, -1.958014456112204e-20,  2.394333468849540e-22, -2.187457218946249e-24,  6.428563239473542e-04, -1.525963525508643e-05,  3.149311258037576e-07,
 -5.668045224092315e-09,  9.283984207856009e-11, -1.417713834955633e-12,  1.992411829886324e-14, -2.825358296498285e-16,  3.639993653376860e-18, -4.192577446416001e-20,
  6.569519377370295e-22, -6.219355501484973e-24,  2.042761627966078e-04, -5.812224313342703e-06,  1.465830071297759e-07, -3.124051094027376e-09,  5.999129473845468e-11,
 -1.064800442348654e-12,  1.734965899003456e-14, -2.790750308702964e-16,  4.132021644579302e-18, -5.670757157841608e-20,  8.801717378162435e-22, -1.072266290118608e-23,
  4.032509437311768e-05, -1.405851680208033e-06,  4.284172512234643e-08, -1.075362668283058e-09,  2.410003502452682e-11, -4.945898867119183e-13,  9.324896572983818e-15,
 -1.693602407267793e-16,  2.868096551771237e-18, -4.585612976468043e-20,  7.453201325085813e-22, -1.088966543117200e-23,  4.930565050608236e-06, -2.147025246253683e-07,
  7.860089746520993e-09, -2.326974334732006e-10,  6.088503467023638e-12, -1.445001882040618e-13,  3.147271138136102e-15, -6.485530465602834e-17,  1.252864403610412e-18,
 -2.294566020631173e-20,  4.088649400202956e-22, -6.862166820722143e-24,  3.650853560163747e-07, -2.024522278854026e-08,  8.922430807291929e-10, -3.137365077339536e-11,
  9.632453217298882e-13, -2.656894103024756e-14,  6.700796391022587e-16, -1.578867996209257e-17,  3.485930292329091e-19, -7.281444220299602e-21,  1.454690311361319e-22,
 -2.767442753082972e-24,  1.573051791444444e-08, -1.136578467710503e-09,  6.100642507752364e-11, -2.581042239269234e-12,  9.399421176350354e-14, -3.044198512096561e-15,
  8.959581338974138e-17, -2.439627401664362e-18,  6.199501172989591e-20, -1.483434823850141e-21,  3.366907978798220e-23, -7.270428898643995e-25,  3.724524005420929e-10,
 -3.615965097043689e-11,  2.420556196077628e-12, -1.258500946958054e-13,  5.538927142409313e-15, -2.143078753518332e-16,  7.470158332878256e-18, -2.386915502343288e-19,
  7.071527313686697e-21, -1.960308994302020e-22,  5.120724163650136e-24, -1.266515830008322e-25,  4.521382638465520e-12, -6.170738874140930e-13,  5.366605726241051e-14,
 -3.547980721256100e-15,  1.945866782978692e-16, -9.245326291824266e-18,  3.910519280410681e-19, -1.499931558782653e-20,  5.285868032102512e-22, -1.728490930486487e-23,
  5.285053757509310e-25, -1.519150589892263e-26,  2.721877427627415e-14, -5.586762442971201e-15,  6.742321248421921e-16, -5.983210206262484e-17,  4.287436930838287e-18,
 -2.606555063767525e-19,  1.386275013534097e-20, -6.584829045409611e-22,  2.835438290982240e-23, -1.119293460826942e-24,  4.086056087340554e-26, -1.387776300634394e-27,
  1.120557420097545e-16, -3.680703403513905e-17,  6.617285028113086e-18, -8.330524018136061e-19,  8.144144877176115e-20, -6.543517052619386e-21,  4.477728955303553e-22,
 -2.674311430462834e-23,  1.419099786925025e-24, -6.781857608513011e-26,  2.950193518210305e-27, -1.176821962113310e-28,  5.026462182333323e-04, -8.216290509612521e-06,
  9.226629809156647e-08, -9.022439598368248e-10,  8.196758021233367e-12, -5.455203398488273e-14,  9.463285612470625e-16, -2.230098145344300e-18, -1.579998517609391e-19,
 -6.797935025692116e-21, -5.389508360882407e-23,  2.030534804330278e-24,  1.198382849098152e-03, -2.090078625460941e-05,  2.736751346364648e-07, -3.231471241393981e-09,
  3.573408653138900e-11, -3.520426024836055e-13,  4.266710721492255e-15, -3.328794129845944e-17,  7.483678195596936e-20, -1.208998229391364e-20, -4.785404702409331e-23,
  2.506127934662732e-24,  1.130510669036873e-03, -2.185933349312493e-05,  3.490790457842629e-07, -5.022117826029704e-09,  6.673480541025484e-11, -8.362886873417630e-13,
  9.827897569996323e-15, -1.137483829613581e-16,  1.287774721617797e-18, -1.178153063876405e-20,  1.521604866426650e-22, -1.955552999539681e-24,  5.864589163296848e-04,
 -1.298899855915979e-05,  2.549688614512712e-07, -4.385930033283043e-09,  6.868928791973426e-11, -1.022530827756822e-12,  1.345012568726219e-14, -1.856426500623533e-16,
  2.541328265282706e-18, -2.078938257423645e-20,  3.998408016466928e-22, -6.219220715299554e-24,  1.831562388531313e-04, -4.774680762547747e-06,  1.142174145423006e-07,
 -2.314344417065810e-09,  4.229629262494641e-11, -7.289009835009235e-13,  1.112334732044923e-14, -1.735532810562136e-16,  2.623583508719476e-18, -2.958328230252388e-20,
  5.000748454723620e-22, -7.396836943366236e-24,  3.531378153114794e-05, -1.108860162875744e-06,  3.195994039321805e-08, -7.581802315633630e-10,  1.610991036687105e-11,
 -3.186670536602494e-13,  5.655708515430346e-15, -9.906343962558078e-17,  1.655382108014932e-18, -2.383406122327296e-20,  3.916488642779606e-22, -5.921423430346775e-24,
  4.181909998035389e-06, -1.615309522738121e-07,  5.568630722097413e-09, -1.548420549978218e-10,  3.827296014054191e-12, -8.689018491983648e-14,  1.787917294230734e-15,
 -3.533242209088599e-17,  6.606265009349162e-19, -1.133948950473310e-20,  1.975105490467804e-22, -3.244478215007240e-24,  2.963189382199501e-07, -1.438658234615783e-08,
  5.931635809874917e-10, -1.946935221761881e-11,  5.624928610398840e-13, -1.473876969393566e-14,  3.515704436365422e-16, -7.906146206366756e-18,  1.673120190162542e-19,
 -3.321765571059836e-21,  6.397564706390321e-23, -1.172809821931861e-24,  1.199497362650438e-08, -7.508196678299952e-10,  3.737167779412484e-11, -1.467117376909475e-12,
  5.005878488351270e-14, -1.530836131131027e-15,  4.257622945502424e-17, -1.102152165251102e-18,  2.671140235569937e-20, -6.095518977528669e-22,  1.326375685225036e-23,
 -2.748913000264766e-25,  2.587434571232355e-10, -2.160154449703509e-11,  1.326943623536142e-12, -6.365923319536548e-14,  2.613132688582095e-15, -9.499107706028556e-17,
  3.123120562507125e-18, -9.459696221734523e-20,  2.665933039597816e-21, -7.048406648130439e-23,  1.761721013783470e-24, -4.178469012467395e-26,  2.701740695475831e-12,
 -3.164519072813926e-13,  2.499951777614409e-14, -1.518471035760189e-15,  7.739549973087667e-17, -3.444518475583719e-18,  1.372680982445041e-19, -4.986254526501609e-21,
  1.671112866282194e-22, -5.215681412504726e-24,  1.527104006323941e-25, -4.215481882776369e-27,  1.235352438076394e-14, -2.202417757922946e-15,  2.408219766434242e-16,
 -1.967077977725638e-17,  1.313056880917069e-18, -7.501616106672172e-20,  3.775188683850022e-21, -1.706527806691109e-22,  7.026672322217434e-24, -2.663318734500651e-25,
  9.368996747897851e-27, -3.076197333607378e-28,  2.914190400747051e-17, -8.825269049271946e-18,  1.488297084932684e-18, -1.778432340143296e-19,  1.664836622108042e-20,
 -1.289429907344986e-21,  8.550390243992964e-23, -4.969567357411770e-24,  2.575153172437795e-25, -1.205238077196949e-26,  5.147062130946355e-28, -2.019809344251832e-29,
  4.711917945651046e-04, -7.519313376113289e-06,  8.219416300536802e-08, -7.786246528229230e-10,  7.323829664977406e-12, -3.339614012058558e-14,  7.747119881134891e-16,
 -1.137019284067401e-17, -4.087884256490972e-19, -5.916580374308826e-21,  1.307108299370359e-22,  6.428291912258828e-24,  1.118925974433765e-03, -1.885727665444880e-05,
  2.381127609492424e-07, -2.710806140768733e-09,  2.964141438543753e-11, -2.609638827981467e-13,  3.301849957098253e-15, -3.791006296489016e-17, -3.527813830343415e-19,
 -1.006891976560414e-20,  1.943649726594686e-22,  8.616338596749037e-24,  1.048300967798944e-03, -1.929080386449976e-05,  2.947069683647810e-07, -4.076355298566443e-09,
  5.213228782175375e-11, -6.343362026087151e-13,  7.163470867839059e-15, -7.832640953689553e-17,  9.513459874709881e-19, -7.544418425273612e-21,  5.592273982359913e-23,
 -2.443331645738732e-24,  5.382735543365032e-04, -1.114253725072222e-05,  2.083093673820665e-07, -3.434577268094265e-09,  5.109057845415626e-11, -7.535096221184496e-13,
  9.296800094925238e-15, -1.137935694195749e-16,  2.006964079187066e-18, -1.117084442442071e-20,  5.491352929182058e-23, -9.691668959482750e-24,  1.657239948035840e-04,
 -3.961546628725647e-06,  9.006750740225233e-08, -1.741215966223694e-09,  3.003956343489792e-11, -5.116293430498469e-13,  7.302982107059454e-15, -1.034099474188602e-16,
  1.840646334668104e-18, -1.608296810849660e-20,  1.703077220431918e-22, -7.947667708563604e-24,  3.133768095668897e-05, -8.856321310216667e-07,  2.421956067904949e-08,
 -5.448779281886172e-10,  1.089719038943435e-11, -2.109260114128940e-13,  3.513375163261660e-15, -5.726254906282474e-17,  1.022906891524029e-18, -1.271576804255329e-20,
  1.765467325804625e-22, -4.194951437747752e-24,  3.614429072379763e-06, -1.234917371523211e-07,  4.027325954653035e-09, -1.054740368798166e-10,  2.449381894564226e-12,
 -5.379197169665026e-14,  1.042628822050682e-15, -1.944351309041357e-17,  3.653792167682424e-19, -5.747816891873966e-21,  9.299904945363310e-23, -1.725123422291766e-24,
  2.469733598824737e-07, -1.044256287609284e-08,  4.051058898831384e-10, -1.243486320404465e-11,  3.368781616349919e-13, -8.447597733201150e-15,  1.901877114641456e-16,
 -4.057673575639444e-18,  8.355974308806111e-20, -1.561885575430141e-21,  2.866715572591064e-23, -5.262359435022340e-25,  9.494693973103734e-09, -5.106638932879798e-10,
  2.371641476130423e-11, -8.645738128456244e-13,  2.758548223437476e-14, -7.998676292814931e-16,  2.099641523128898e-17, -5.158340741345278e-19,  1.198211717862239e-20,
 -2.598953268642973e-22,  5.412210042658886e-24, -1.084996164060369e-25,  1.895719658692419e-10, -1.345265204090785e-11,  7.622912891645093e-13, -3.372813308530193e-14,
  1.289707446859025e-15, -4.411537096778182e-17,  1.366764575490139e-18, -3.921547972285245e-20,  1.052113501875935e-21, -2.649379089688177e-23,  6.332587189729869e-25,
 -1.441093004900228e-26,  1.744560970883443e-12, -1.725616714682019e-13,  1.240660929163526e-14, -6.907353102068543e-16,  3.265626369102564e-17, -1.360061075373894e-18,
  5.097708322679937e-20, -1.750996163759018e-21,  5.573372384247759e-23, -1.657468610079674e-24,  4.640079734494534e-26, -1.228259397111249e-27,  6.288185890952207e-15,
 -9.514668659112590e-16,  9.371851936399986e-17, -7.001529369645655e-18,  4.331253937855969e-19, -2.314917922919442e-20,  1.097703292102659e-21, -4.703845920370303e-23,
  1.845319903047338e-24, -6.692698978830997e-26,  2.261409152301035e-27, -7.156173243532559e-29,  8.636715502789476e-18, -2.343744613993225e-18,  3.647041712460232e-19,
 -4.085636431143851e-20,  3.626821242957656e-21, -2.686360845330178e-22,  1.714831857259579e-23, -9.645095112880733e-25,  4.857397623894010e-26, -2.217307906229238e-27,
  9.263075662683255e-29, -3.564979957498581e-30,  4.423732250952109e-04, -6.897186825275906e-06,  7.353462140217206e-08, -6.659134249882252e-10,  6.807754205903523e-12,
 -2.024759571424386e-14,  2.518586733070822e-16, -2.624468211535446e-17, -4.522081578138306e-19,  5.648093536929690e-21,  4.470325070542683e-22,  6.116649752523764e-24,
  1.047111542982665e-03, -1.707480138658406e-05,  2.082693245237812e-07, -2.274379580642270e-09,  2.512084564603939e-11, -1.959943392210420e-13,  2.043211031752799e-15,
 -5.268132394223242e-17, -4.733751661654689e-19,  6.285372681142427e-21,  6.247291550136910e-22,  8.467115912443173e-24,  9.755620806420682e-04, -1.711554015319983e-05,
  2.504051057947251e-07, -3.335078200586014e-09,  4.100390554293966e-11, -4.855312967343992e-13,  5.357550705827020e-15, -5.200946817992839e-17,  6.939716454742463e-19,
 -7.440715923006885e-21, -4.595445213770289e-23, -1.733539499076937e-24,  4.967935293575617e-04, -9.628096819933422e-06,  1.715384329317905e-07, -2.726524054444849e-09,
  3.802944959627736e-11, -5.617418267274740e-13,  6.947214118149359e-15, -5.645719813447945e-17,  1.535921552572103e-18, -1.799207984309352e-20, -3.891865148819490e-22,
 -8.471978537542836e-24,  1.511971384110013e-04, -3.317134404366935e-06,  7.174747040937921e-08, -1.333791800945593e-09,  2.135740217913879e-11, -3.649528998257383e-13,
  5.150423157394569e-15, -5.315313148249699e-17,  1.298732271619404e-18, -1.633272308884805e-20, -1.740159082719705e-22, -6.549962821189173e-24,  2.814505100218400e-05,
 -7.153590463102728e-07,  1.860144484229497e-08, -4.001732032306212e-10,  7.409479427593960e-12, -1.425292896628435e-13,  2.307172333111006e-15, -3.083590842284793e-17,
  6.502440567037819e-19, -9.064210218787689e-21,  1.466396904712886e-23, -2.944295102237604e-24,  3.177726187954760e-06, -9.574341230464225e-08,  2.965226106535564e-09,
 -7.369460999496445e-11,  1.585774821053774e-12, -3.414961123745097e-14,  6.351260394973102e-16, -1.047773581959214e-17,  2.093531077471572e-19, -3.306941822495215e-21,
  3.433878955320913e-23, -9.822194773827587e-25,  2.108540049060479e-07, -7.718359209276234e-09,  2.833620005399857e-10, -8.182212251983531e-12,  2.057350946592265e-13,
 -4.989366026131701e-15,  1.069008798144989e-16, -2.101248727442310e-18,  4.330423937461309e-20, -7.816008468009606e-22,  1.232458934255697e-23, -2.507529877569837e-25,
  7.774981028204481e-09, -3.559883430177430e-10,  1.553875499109299e-11, -5.280345157116736e-13,  1.564937190804130e-14, -4.333009708641979e-16,  1.076569989178536e-17,
 -2.481833963696162e-19,  5.591116706532624e-21, -1.158000953698756e-22,  2.248833949194319e-24, -4.490407623714375e-26,  1.458141372084468e-10, -8.679557872998288e-12,
  4.571457949509526e-13, -1.868368240583587e-14,  6.629550500370573e-16, -2.141795523160881e-17,  6.254768291053696e-19, -1.693809159506023e-20,  4.342020528448786e-22,
 -1.041094510986096e-23,  2.367403767520427e-25, -5.200329893759229e-27,  1.210596756658956e-12, -9.928715471118063e-14,  6.532333772088073e-15, -3.330127198925533e-16,
  1.456529343382500e-17, -5.679463261474659e-19,  1.999687601651465e-20, -6.483339856507078e-22,  1.959329406310907e-23, -5.543899192044273e-25,  1.481343702637127e-26,
 -3.758657094526170e-28,  3.579114458113247e-15, -4.476878246711278e-16,  3.965206928273338e-17, -2.695147187270758e-18,  1.538090450449889e-19, -7.663499440278305e-21,
  3.411346628560345e-22, -1.380937452082157e-23,  5.145024305595747e-25, -1.779845014017987e-26,  5.759063669574857e-28, -1.751449955697650e-29,  2.985862518346762e-18,
 -6.991712117234898e-19,  9.860647670324469e-20, -1.021254632550285e-20,  8.503223247561729e-22, -5.969576852055331e-23,  3.640800509976659e-24, -1.969028353615023e-25,
  9.584543684935313e-27, -4.246951025540955e-28,  1.728423172936239e-29, -6.500302794663132e-31,  4.159129969652268e-04, -6.339051979510096e-06,  6.618415950302462e-08,
 -5.601761171268531e-10,  6.396554115569401e-12, -2.433526856742456e-14, -6.282326843601823e-16, -3.366932972227447e-17,  1.081100383264395e-19,  2.537348407735445e-20,
  4.178762412970205e-22, -1.037043730816518e-23,  9.819810660502768e-04, -1.551126734173795e-05,  1.832662099991594e-07, -1.901668633214574e-09,  2.156456304972694e-11,
 -1.659746247604479e-13,  4.275170597675215e-16, -5.890496573725311e-17,  2.525618481328960e-19,  3.396129905866676e-20,  5.939854334732319e-22, -1.397772136108140e-23,
  9.108677626571180e-04, -1.526192490284008e-05,  2.140214705559725e-07, -2.750167773765999e-09,  3.247299757846487e-11, -3.721787942180065e-13,  4.168780891996413e-15,
 -3.453804315957305e-17,  3.832071227694029e-19, -9.808222153793748e-21, -4.118265274179830e-23,  2.487819039568657e-24,  4.608320900894244e-04, -8.377115784356930e-06,
  1.421283197569166e-07, -2.199318775177749e-09,  2.835962476316989e-11, -4.091445206371589e-13,  5.932543566558659e-15, -2.118171471905329e-17,  5.539482406881525e-19,
 -3.677214247405097e-20, -4.061255373618813e-22,  1.106207092453775e-23,  1.389827143003307e-04, -2.801880723136057e-06,  5.757197033664897e-08, -1.044178729398274e-09,
  1.519564701884128e-11, -2.551087310690733e-13,  4.143423534268974e-15, -2.276245530536006e-17,  5.393966425715954e-19, -2.628979857068393e-20, -2.305139161991131e-22,
  6.163106385687983e-24,  2.555340741625967e-05, -5.839388201190516e-07,  1.442564389251834e-08, -3.016727871162385e-10,  5.053548547131092e-12, -9.546957831691157e-14,
  1.685603957576174e-15, -1.533821534627628e-17,  3.113621543148155e-19, -1.012451945154727e-20, -3.733496015099476e-23,  1.203060039423302e-24,  2.837142102424813e-06,
 -7.517458515831301e-08,  2.213026522673791e-09, -5.304540537125032e-11,  1.034923411761252e-12, -2.177246030768743e-14,  4.191077216090266e-16, -5.489328897040989e-18,
  1.066749410137293e-19, -2.565321337384757e-21,  9.255582430216333e-24, -8.693548767567922e-26,  1.839625476569498e-07, -5.795016556296665e-09,  2.020360478868417e-10,
 -5.566840648140005e-12,  1.275481341270092e-13, -2.996249425177343e-15,  6.380510720456582e-17, -1.089004910678683e-18,  2.185524273816786e-20, -4.579374332111494e-22,
  5.050497526899078e-24, -8.579323757122447e-26,  6.564760302564851e-09, -2.533451486423459e-10,  1.045849938951162e-11, -3.349771369504640e-13,  9.094366999953634e-15,
 -2.414119362883461e-16,  5.799054739336506e-18, -1.218737418554100e-19,  2.654304940660318e-21, -5.591858971536922e-23,  9.396949875812517e-25, -1.785664660847719e-26,
  1.172077512318130e-10, -5.766840246516818e-12,  2.847103277624233e-13, -1.082452724463346e-14,  3.531461995404795e-16, -1.081821051783070e-17,  3.002137562087220e-19,
 -7.583026752136252e-21,  1.861370639272711e-22, -4.316610767181471e-24,  9.135869934730281e-26, -1.934672019422441e-27,  8.972927895381367e-13, -5.977137912448180e-14,
  3.629830596118632e-15, -1.698625434867631e-16,  6.835767107825460e-18, -2.500444276574460e-19,  8.280714728257049e-21, -2.523433552889947e-22,  7.246210958919303e-24,
 -1.953524571884879e-25,  4.956262064804144e-27, -1.206220592574435e-28,  2.264650570561894e-15, -2.272997123182893e-16,  1.816650310010455e-17, -1.119789321341766e-18,
  5.867239203217957e-20, -2.719634844776759e-21,  1.133250533116009e-22, -4.318876294657167e-24,  1.524484654495794e-25, -5.016624837429150e-27,  1.549630650206697e-28,
 -4.518571236062326e-30,  1.227544173697512e-18, -2.364110642854647e-19,  2.972801656292101e-20, -2.805196181692901e-21,  2.165507993811126e-22, -1.427318222962887e-23,
  8.249209115603697e-25, -4.259614152108476e-26,  1.991844621573854e-27, -8.521426865247852e-29,  3.362651691295735e-30, -1.230700779354575e-31,  3.915755611595740e-04,
 -5.834771128740661e-06,  6.005656693487414e-08, -4.628458940997018e-10,  5.688638936311810e-12, -4.940535350224764e-14, -1.369454816502946e-15, -1.367859511875573e-17,
  1.149782721290883e-18,  2.625695935678790e-20, -5.098730450994198e-22, -2.805781613988922e-23,  9.227316787169586e-04, -1.413080351746098e-05,  1.624071885961534e-07,
 -1.583162657770782e-09,  1.822406143746063e-11, -1.733399921182480e-13, -9.020202597106558e-16, -2.845903058977188e-17,  1.667357173717251e-18,  3.606362214590243e-20,
 -6.816471214321907e-22, -3.904319580294627e-23,  8.530471602107722e-04, -1.367346047592022e-05,  1.839079883301618e-07, -2.285020438211192e-09,  2.595735429852197e-11,
 -2.826778113640261e-13,  3.319724850968183e-15, -2.794037791695597e-17,  3.995159063050254e-20, -7.891623469783013e-21,  1.611985581274213e-22,  5.600017678611176e-24,
  4.294406642103995e-04, -7.338515260651974e-06,  1.182135419416955e-07, -1.803473995319215e-09,  2.155736070246891e-11, -2.731800049068762e-13,  5.374202963444051e-15,
 -2.632863194167381e-17, -8.712390688366484e-19, -3.538960812027155e-20,  6.364483969008538e-22,  3.202535687034978e-23,  1.286223522695297e-04, -2.387645959425757e-06,
  4.634920470015153e-08, -8.366560371106873e-10,  1.104246632913873e-11, -1.622832372374745e-13,  3.597434505883978e-15, -2.156884716522489e-17, -4.587186033321340e-19,
 -2.482679623607528e-20,  4.139622373060889e-22,  2.054762774027193e-23,  2.342730173283259e-05, -4.817708887660885e-07,  1.123446140568732e-08, -2.340232602875388e-10,
  3.518280789457962e-12, -5.938544015849247e-14,  1.339885383778491e-15, -1.128761298384956e-17, -5.163849750205023e-20, -8.875320942552751e-21,  1.360538235219602e-22,
  5.953580546370319e-24,  2.568178699496624e-06, -5.976483170658967e-08,  1.663106377843444e-09, -3.947009334996556e-11,  6.892514478506055e-13, -1.325515653397897e-14,
  2.998750749675754e-16, -3.469999312799897e-18,  2.299379498508420e-20, -1.954812012247783e-21,  2.825250569754886e-23,  8.362715669611696e-25,  1.636355766030641e-07,
 -4.415303509357579e-09,  1.457452643581593e-10, -3.931396585320073e-12,  8.081492684811847e-14, -1.765777444240875e-15,  4.087374790531971e-17, -6.192201299723638e-19,
  8.485065399798709e-21, -2.894580078303675e-22,  4.297428313140499e-24,  3.842588647346494e-26,  5.696321493327486e-09, -1.836053394546927e-10,  7.174194461699332e-12,
 -2.215403055781639e-13,  5.424040685973586e-15, -1.352193592702832e-16,  3.317395092299262e-18, -6.312836093632205e-20,  1.173145481748145e-21, -2.927575461388239e-23,
  4.929193939202209e-25, -4.074422128588851e-27,  9.798983858917752e-11, -3.926894369646441e-12,  1.826744521730687e-13, -6.575324318233995e-15,  1.945843831159162e-16,
 -5.609845355589989e-18,  1.521268510640116e-19, -3.545052674138659e-21,  8.032702174748144e-23, -1.908213591980460e-24,  3.814081122231471e-26, -6.724030781252515e-28,
  7.055746666137407e-13, -3.734698625217363e-14,  2.112075082529497e-15, -9.170179671918470e-17,  3.362042427955024e-18, -1.152418854426531e-19,  3.626715275283655e-21,
 -1.031361977521605e-22,  2.793487947541564e-24, -7.282893519939471e-26,  1.746270341495890e-27, -3.986869785661952e-29,  1.579092877717293e-15, -1.231026081572953e-16,
  8.952898053771328e-18, -5.013771273157805e-19,  2.395290334050496e-20, -1.031816515029272e-21,  4.024821334156353e-23, -1.437761232349733e-24,  4.796201116534321e-26,
 -1.501107882217691e-27,  4.409724318735957e-29, -1.228474909520631e-30,  6.057597018210054e-19, -9.063104029555504e-20,  1.005851988679421e-20, -8.532342281293620e-22,
  6.034781588852743e-23, -3.700372735605505e-24,  2.009938665697599e-25, -9.835142259986244e-27,  4.389617878885263e-28, -1.802750082587471e-29,  6.861582300199211e-31,
 -2.432708524616371e-32,  3.691642758540505e-04, -5.375074893899466e-06,  5.500997843753910e-08, -3.815643742653954e-10,  4.365333859714750e-12, -8.203554128422959e-14,
 -1.136627901261463e-15,  3.204672240154659e-17,  1.459637280530212e-18, -1.477141903380212e-20, -1.335266343873028e-21, -1.489120463001282e-25,  8.686932992804514e-04,
 -1.290285284885580e-05,  1.450400814947283e-07, -1.320637894995426e-09,  1.451153560102798e-11, -1.975905701508838e-13, -8.128735559049490e-16,  3.724618016144834e-17,
  2.098200056830185e-18, -2.027699025264874e-20, -1.856433151855702e-21, -1.253709725250279e-24,  8.011316195234846e-04, -1.230522001562264e-05,  1.588063774313016e-07,
 -1.910868527867295e-09,  2.103699365637380e-11, -2.124549865961838e-13,  2.523967429648882e-15, -2.954265744997625e-17, -7.909549384329011e-20,  2.172617702376711e-21,
  2.889137018108729e-22, -1.516920356296782e-24,  4.018487418979210e-04, -6.473881298378202e-06,  9.848291273234930e-08, -1.495577215853441e-09,  1.730343213338499e-11,
 -1.571316480834068e-13,  4.105420785146732e-15, -6.709798834906630e-17, -1.379858082378330e-18,  1.370423109127415e-20,  1.582466422793078e-21,  1.161297586557668e-25,
  1.197537219064448e-04, -2.054225626820730e-06,  3.727684459158461e-08, -6.814951300477834e-10,  8.599745165649149e-12, -8.551956526692647e-14,  2.686312701617719e-15,
 -4.567268999033724e-17, -8.538631766639490e-19,  7.265229425886841e-21,  1.046184913924836e-21,  9.513307563493133e-25,  2.166342942269666e-05, -4.022508148728157e-07,
  8.730093505498520e-09, -1.855993571048932e-10,  2.624503699197850e-12, -3.145268816369279e-14,  9.630645918247371e-16, -1.650619060165494e-17, -2.137596690023053e-19,
  1.201672844931944e-21,  3.277549257394919e-22,  5.064184798988463e-25,  2.352970461306648e-06, -4.818483661702194e-08,  1.248063369457301e-09, -3.020413841638912e-11,
  4.884364051880654e-13, -7.196342753985268e-15,  2.044140799771695e-16, -3.569856153361230e-18, -1.832601753470367e-20, -1.387095184973326e-22,  5.713511016429800e-23,
  9.638739925402966e-26,  1.480353976995994e-07, -3.418431885443382e-09,  1.053189533895440e-10, -2.873036665787336e-12,  5.402702236041521e-14, -9.705301533143705e-16,
  2.602943854919113e-17, -4.773293756995299e-19,  1.641501308631357e-21, -7.856518880873964e-23,  5.978483115158033e-24,  1.492299665757196e-27,  5.061694123722007e-09,
 -1.355505209400295e-10,  4.959703605348257e-12, -1.526007197228406e-13,  3.390918743528100e-15, -7.341510468128121e-17,  1.942616429557632e-18, -3.888119570585758e-20,
  4.472747406923728e-22, -1.153308456270920e-23,  4.103967061306442e-25, -1.850050917321951e-27,  8.477024746104420e-11, -2.735574378503507e-12,  1.193095286061785e-13,
 -4.190418624219532e-15,  1.121238918978809e-16, -2.913641900994933e-18,  8.034497937485213e-20, -1.825956299248269e-21,  3.360682174899374e-23, -8.032670149718719e-25,
  2.015544521231141e-26, -2.494311698527961e-28,  5.841041938324954e-13, -2.408626991076127e-14,  1.271364617217639e-15, -5.244558880501741e-17,  1.737146073045350e-18,
 -5.476639447951240e-20,  1.675724434857514e-21, -4.499698598406212e-23,  1.101617882559341e-24, -2.807382775767649e-26,  6.798192106891525e-28, -1.354555319616907e-29,
  1.199313828590409e-15, -7.031490182752722e-17,  4.693784570454625e-18, -2.418427159745047e-19,  1.043688897587873e-20, -4.154651243871629e-22,  1.528138023877036e-23,
 -5.105237677145526e-25,  1.593289332787728e-26, -4.762446972935875e-28,  1.337239085186100e-29, -3.506635712321576e-31,  3.567746072052770e-19, -3.899607263550918e-20,
  3.819105860334306e-21, -2.888674348838558e-22,  1.848450980426922e-23, -1.045688572506810e-24,  5.301845991904179e-26, -2.439477055186989e-27,  1.032071297079447e-28,
 -4.046894665360458e-30,  1.477650117382649e-31, -5.047484357131699e-33,  3.485166390675770e-04, -4.952255241445499e-06,  5.079237478317919e-08, -3.259366356014230e-10,
  2.548414918832258e-12, -9.411150495326556e-14,  2.657608796170223e-16,  6.087376834350336e-17,  1.081435090111380e-19, -5.282880195308423e-20, -2.308435670491421e-22,
  4.407968083121448e-23,  8.193073312457420e-04, -1.180228063281278e-05,  1.304529595086705e-07, -1.120650246672169e-09,  1.048365448573621e-11, -1.981627869448486e-13,
  9.639877926008351e-16,  7.959260487132938e-17,  2.184600159542371e-19, -7.396149419121796e-20, -3.513016902328919e-22,  6.133041855481398e-23,  7.543140931523470e-04,
 -1.112107158347819e-05,  1.377651700932591e-07, -1.605262906366657e-09,  1.732574151237994e-11, -1.619468828344602e-13,  1.687302772161136e-15, -2.891151554450751e-17,
  1.628060148450881e-19,  9.396138979757155e-21,  1.401750886858463e-23, -9.159130267519157e-24,  3.774216486168146e-04, -5.753306731119441e-06,  8.210880974287314e-08,
 -1.239228444710493e-09,  1.497160174172192e-11, -8.526352118031717e-14,  1.764410681628203e-15, -9.223184150522775e-17,  8.803210957446518e-20,  5.914311378747421e-20,
  2.975133749215612e-22, -5.135773623424441e-23,  1.120846119939113e-04, -1.786493101950794e-06,  2.987807322712788e-08, -5.545638810716413e-10,  7.416571288650753e-12,
 -3.896247620590814e-14,  1.118788017604984e-15, -6.137142525888199e-17,  6.220579752436719e-20,  3.813884458329654e-20,  2.346086932857643e-22, -3.357238182591596e-23,
  2.018095615095552e-05, -3.406454521343593e-07,  6.737702828747149e-09, -1.475535549888161e-10,  2.185645568021206e-12, -1.453066299678113e-14,  4.288549782090012e-16,
 -2.029782205591642e-17,  3.784338485376487e-20,  1.116045965377743e-20,  8.835795800656526e-23, -1.023795265455006e-23,  2.178079722660858e-06, -3.952665355226741e-08,
  9.285219121804851e-10, -2.330909889447542e-11,  3.851666892178446e-13, -3.545417057981385e-15,  9.852060009169296e-17, -3.821409330044547e-18,  1.356498811123468e-20,
  1.653582156724707e-21,  1.894758288694295e-23, -1.679343682234733e-24,  1.358474747747634e-07, -2.700367546804917e-09,  7.548630586472597e-11, -2.134401714910806e-12,
  3.980635761241612e-14, -5.012825483017809e-16,  1.329033052001714e-17, -4.266191834622555e-19,  2.696801786748547e-21,  1.136013057577348e-22,  2.447471428292135e-24,
 -1.532880307115960e-25,  4.588423247302858e-09, -1.023722631365217e-10,  3.412824922766517e-12, -1.079041593184614e-13,  2.307787595511950e-15, -3.851508573845166e-17,
  1.013101692186369e-18, -2.830003865466261e-20,  2.926877454149499e-22,  1.522409308980615e-24,  1.950505386072330e-25, -7.971877663950751e-27,  7.545640879739594e-11,
 -1.955567053238407e-12,  7.816189437162705e-14, -2.773337596040153e-15,  6.952585998364726e-17, -1.499025685000879e-18,  4.091776843058566e-20, -1.077995906967243e-21,
  1.669623845848723e-23, -2.051596056208367e-25,  9.598094454807580e-27, -2.597708613925304e-28,  5.046879894434401e-13, -1.603115783215506e-14,  7.786953045353917e-16,
 -3.159575551704963e-17,  9.591643720490130e-19, -2.645593575934816e-20,  7.890265611182730e-22, -2.164241158776143e-23,  4.647403461424083e-25, -9.907898255748247e-27,
  2.794133904579884e-28, -6.318726911100315e-30,  9.780878608998817e-16, -4.205681278777714e-17,  2.572790964672724e-18, -1.253954125007761e-19,  4.879161877769696e-21,
 -1.754146609287544e-22,  6.139352584242936e-24, -1.957922747249603e-25,  5.599659361687760e-27, -1.560731109349564e-28,  4.347288958383896e-30, -1.095337552290820e-31,
  2.453964441806321e-19, -1.851434277060096e-20,  1.610622350191703e-21, -1.091936271517749e-22,  6.239940749089390e-24, -3.222252323777603e-25,  1.520635275558035e-26,
 -6.544933642405656e-28,  2.600661494310053e-29, -9.678640497123369e-31,  3.381867856576935e-32, -1.106731464708451e-33,  3.294963211929873e-04, -4.561006003127815e-06,
  4.706634340382650e-08, -2.993091088016026e-10,  8.626670068330606e-13, -6.861484496433313e-14,  1.742135932484061e-15,  3.590304187818605e-17, -1.502118125927347e-18,
 -2.558879360974109e-20,  1.382362380382920e-21,  1.634151515663866e-23,  7.741039300682266e-04, -1.080988594501758e-05,  1.178869077102290e-07, -9.826202539393020e-10,
  6.925988735826726e-12, -1.499187638242003e-13,  2.901708970043283e-15,  4.656054101260599e-17, -2.055486046965826e-18, -3.677739682136875e-20,  1.926165117530376e-21,
  2.384848220996511e-23,  7.119183945100895e-04, -1.009152341482742e-05,  1.200648106023202e-07, -1.352023056995130e-09,  1.443050698627564e-11, -1.302796185210197e-13,
  9.979727098502882e-16, -1.892299941119154e-17,  4.225156915590100e-19,  3.053909112753441e-21, -2.758322065534427e-22, -1.884969897367318e-24,  3.556335731580182e-04,
 -5.151965843695778e-06,  6.862419071963781e-08, -1.011871386544883e-09,  1.349054376219385e-11, -7.165033560949221e-14, -4.679389445590193e-16, -5.746260864371564e-17,
  1.897001948964619e-18,  2.843514786098139e-20, -1.590310574472670e-21, -1.938097403835510e-23,  1.053773202742389e-04, -1.572122847033584e-06,  2.391275701794117e-08,
 -4.412377417660801e-10,  6.773187316044853e-12, -3.124687647328976e-14, -3.694142862579353e-16, -3.851638396767162e-17,  1.250149295129678e-18,  1.918132923779686e-20,
 -1.032805634259429e-21, -1.383073761832269e-23,  1.891577712443677e-05, -2.932512904882327e-07,  5.168591851615055e-09, -1.145348623182078e-10,  1.954221205911930e-12,
 -1.054815029264224e-14, -6.249884344667586e-17, -1.287537715371753e-17,  3.937609714680589e-19,  5.889316709656051e-21, -3.093883848058060e-22, -4.623327440738669e-24,
  2.033199604926255e-06, -3.311727853610892e-08,  6.837692105978502e-10, -1.761999868736560e-11,  3.297303412352106e-13, -2.359343314769132e-15,  6.722287468662806e-18,
 -2.438052429329899e-18,  6.847943706464034e-20,  9.348997964788490e-22, -4.858042314356893e-23, -8.457393370258159e-25,  1.261059703303696e-07, -2.188769676824264e-09,
  5.340962650003872e-11, -1.564208258488922e-12,  3.207060669103835e-14, -3.117947334651432e-16,  3.222586472684878e-18, -2.698137677249387e-19,  6.854431260156569e-21,
  7.360164984521684e-23, -3.952936863863558e-24, -8.754409083580259e-26,  4.226156960630843e-09, -7.967256185875739e-11,  2.317693918245166e-12, -7.607022549610315e-14,
  1.722269339637821e-15, -2.256439823715832e-17,  3.666348176423627e-19, -1.727083137930233e-20,  3.995366272070259e-22,  2.093779799125177e-24, -1.453319800265594e-25,
 -5.120705299937227e-27,  6.869803064353885e-11, -1.446459707733092e-12,  5.071423278549416e-14, -1.856653322365424e-15,  4.721162455109246e-17, -8.235656558375130e-19,
  1.750139510345771e-20, -6.102245704044798e-22,  1.347768499036825e-23, -4.461021518780341e-26, -9.181008490840050e-28, -1.692901193894361e-28,  4.509438116045395e-13,
 -1.109174007703948e-14,  4.769998949341546e-16, -1.963254991545199e-17,  5.778539480661802e-19, -1.337557315680499e-20,  3.501139617673223e-22, -1.081111922112702e-23,
  2.502788311784060e-25, -3.413868886515858e-27,  6.688062416685533e-29, -3.282323996947251e-30,  8.430730440638492e-16, -2.638892437654834e-17,  1.442264080168692e-18,
 -6.894543729202503e-20,  2.486586989675273e-21, -7.780028741351976e-23,  2.514442025451893e-24, -8.065201855089265e-26,  2.202297436288383e-27, -5.212415300833933e-29,
  1.352507852310489e-30, -3.877745747664651e-32,  1.906920540191628e-19, -9.559606618801774e-21,  7.371994258686359e-22, -4.595678536234625e-23,  2.337656924602084e-24,
 -1.079222155572234e-25,  4.717862508854349e-27, -1.912360741269906e-28,  7.094846598649064e-30, -2.464128135116732e-31,  8.206560414613069e-33, -2.596337357859353e-34,
  3.119828251010150e-04, -4.198695708812905e-06,  4.352020584139771e-08, -2.939759999047776e-10, -4.032776705907769e-14, -2.062608578127607e-14,  2.015055290415771e-15,
 -1.587020307536060e-17, -1.412045154872126e-18,  2.715512907703711e-20,  8.930762941784660e-22, -3.166441767742069e-23,  7.326782897743422e-04, -9.912274260083298e-06,
  1.066745360217729e-07, -8.917082996472101e-10,  4.688039007201634e-12, -7.273422155167830e-14,  3.196169748117699e-15, -2.494273325328989e-17, -1.960791359795842e-18,
  3.743377079608434e-20,  1.271561067773838e-21, -4.417421197626188e-23,  6.733758739977206e-04, -9.192167289574354e-06,  1.051436687371636e-07, -1.140830440928738e-09,
  1.202955844389229e-11, -1.111334255691273e-13,  6.588055937421929e-16, -5.737318113757452e-18,  3.433837023727635e-19, -6.505835111517243e-21, -1.405156782949594e-22,
  6.338090182715950e-24,  3.360518237153036e-04, -4.647987775804775e-06,  5.772638024514066e-08, -8.085129377089889e-10,  1.185270588826048e-11, -9.484047940274072e-14,
 -1.164325925155846e-15,  6.891398245770182e-18,  1.753387304872712e-18, -3.250120873413630e-20, -1.033930725744559e-21,  3.668943084773907e-23,  9.944043146902920e-05,
 -1.400209991176507e-06,  1.924515257123181e-08, -3.386280688314700e-10,  5.997216091576174e-12, -4.819529472597835e-14, -8.437576489352604e-16,  4.179620299587403e-18,
  1.172072016794886e-18, -2.116854202056985e-20, -6.994943323555476e-22,  2.398012437752597e-23,  1.781749278690200e-05, -2.568857420695150e-07,  3.974283407571340e-09,
 -8.513185960160426e-11,  1.706917742059462e-12, -1.484514071385215e-14, -2.328383503142358e-16,  5.797109438427778e-19,  3.716119719376943e-19, -6.482969982958155e-21,
 -2.194795103007709e-22,  7.265478370931224e-24,  1.910453520466916e-06, -2.840682357085595e-08,  5.024024587851451e-10, -1.273154016788329e-11,  2.799866066367190e-13,
 -2.752924097783523e-15, -2.869767298604419e-17, -1.148839003505119e-19,  6.442484879565201e-20, -1.075412705589108e-21, -3.673158387915575e-23,  1.166452418479492e-24,
  1.180982771792389e-07, -1.828308950668988e-09,  3.751983320921955e-11, -1.098866543203571e-12,  2.613030484028577e-14, -2.990852535724605e-16, -1.106022330775395e-18,
 -4.240827943242410e-20,  6.294957867890687e-21, -9.989225391235671e-23, -3.304751983340392e-24,  9.982480199051509e-26,  3.939387656186502e-09, -6.434582484571771e-11,
  1.556459580405766e-12, -5.178412060686405e-14,  1.327393904010030e-15, -1.810151983575967e-17,  6.370387663012872e-20, -4.662668315216965e-21,  3.433657319787884e-22,
 -5.222153939415309e-24, -1.495076520714685e-25,  4.258292259638860e-27,  6.359914847542434e-11, -1.118152551778857e-12,  3.248326805218029e-14, -1.215172356082318e-15,
  3.380038479959323e-17, -5.618480544562362e-19,  6.098772896612712e-21, -2.217910320308025e-22,  1.010343443555532e-23, -1.545774591416839e-25, -2.749012737767543e-27,
  7.331539528964644e-29,  4.129150537485977e-13, -8.078741224951104e-15,  2.892893555972003e-16, -1.215839039268831e-17,  3.740936010570838e-19, -7.801303136793239e-21,
  1.434047336853655e-22, -4.472059158294888e-24,  1.502542799206834e-25, -2.585897786487415e-27, -9.333834769810375e-31,  9.345636294791761e-33,  7.561754558983377e-16,
 -1.758409271645225e-17,  8.111088201504518e-19, -3.897290561054168e-20,  1.386056843501829e-21, -3.802014520326958e-23,  1.019069778204562e-24, -3.244876164775034e-26,
  9.850842457658966e-28, -2.188449715907253e-29,  3.701916896916830e-31, -9.701088609210376e-33,  1.614786864183518e-19, -5.363637223428856e-21,  3.547780430442888e-22,
 -2.111518340235385e-23,  9.823425927162283e-25, -3.967923100790851e-26,  1.556425251617983e-27, -5.997276910850753e-29,  2.134039784269305e-30, -6.845769509164908e-32,
  2.077865674985139e-33, -6.313485566562343e-35,  2.958619867626101e-04, -3.864671236429928e-06,  3.998291587441394e-08, -2.955233024473072e-10, -2.711459687134395e-14,
  1.837604919743476e-14,  1.117677989065488e-15, -4.137193854203360e-17, -1.410028189724366e-19,  3.440211436037593e-20, -4.383741141560901e-22, -2.008500217352191e-23,
  6.946699020572940e-04, -9.100489934894262e-06,  9.638866859722749e-08, -8.245157509204781e-10,  3.913465872010476e-12, -9.999893847964048e-15,  1.868750126200470e-15,
 -6.030873644321971e-17, -1.882172168877103e-19,  4.827331285219098e-20, -6.051228937106142e-22, -2.861532984809176e-23,  6.382072038606104e-04, -8.402669293290051e-06,
  9.253787371617118e-08, -9.653150955625096e-10,  9.957392553242171e-12, -9.624973586762999e-14,  6.122250982439102e-16,  9.625188799822907e-19,  7.400474761227117e-20,
 -6.831967163841952e-21,  9.966287057670595e-23,  3.197446119557566e-24,  3.183263975501206e-04, -4.221914706474719e-06,  4.909499113698540e-08, -6.353987261209045e-10,
  9.719491736277977e-12, -1.154130767782206e-13, -3.994650177370183e-16,  3.960798460812204e-17,  2.448089067168359e-19, -4.077681500112285e-20,  5.142080526866215e-22,
  2.342056265948019e-23,  9.412397612264931e-05, -1.260951609041666e-06,  1.572224513946219e-08, -2.513785652787975e-10,  4.858673783809739e-12, -6.364615521660486e-14,
 -3.420569269895215e-16,  2.627764625946517e-17,  1.747068487207582e-19, -2.721612933152527e-20,  3.323596399731504e-22,  1.591927154212077e-23,  1.684769169105153e-05,
 -2.287379451403245e-07,  3.105850188807747e-09, -6.047355139537787e-11,  1.361310472461815e-12, -1.915445967227415e-14, -9.342077052044432e-17,  7.712124805063524e-18,
  6.257913693285217e-20, -8.507590215872021e-21,  1.001872347115163e-22,  5.036029894361871e-24,  1.803998771695773e-06, -2.492697928962934e-08,  3.745704824138601e-10,
 -8.727083106138976e-12,  2.188039811000351e-13, -3.290538689327136e-15, -1.026423565875969e-17,  1.152845007667672e-18,  1.273096892587799e-20, -1.435733154213709e-21,
  1.615690114620355e-23,  8.552401974976016e-25,  1.113112670539096e-07, -1.574252927381693e-09,  2.663965109013154e-11, -7.301214347093476e-13,  1.988793965033555e-14,
 -3.211175795207765e-16, -1.408054857498091e-19,  8.554217486064127e-20,  1.504133298050981e-21, -1.339345237941032e-22,  1.427187486651111e-24,  7.918560507479828e-26,
  3.703446069625525e-09, -5.404584786455099e-11,  1.050728997967012e-12, -3.338359115221297e-14,  9.756398912352578e-16, -1.710232993819266e-17,  5.292254260993912e-20,
  2.588419347420983e-21,  1.007998525784699e-22, -6.761088923704118e-24,  6.829009387498048e-26,  3.824909040390076e-27,  5.956582605451502e-11, -9.082313767900749e-13,
  2.079663535761831e-14, -7.578350430416009e-16,  2.368895586862306e-17, -4.591711919916504e-19,  3.473455972745352e-21, -5.489924094858512e-25,  3.597018141744278e-24,
 -1.757685929429620e-25,  1.757985004450629e-27,  8.594256796521508e-29,  3.844340144688154e-13, -6.257094207401332e-15,  1.746633404770877e-16, -7.268000411159550e-18,
  2.447858885740287e-19, -5.404537619983313e-21,  7.161436351226854e-23, -1.129585511121207e-24,  6.089531242171872e-26, -2.190637655730336e-27,  2.519006600847416e-29,
  6.564828285353074e-31,  6.963202193176813e-16, -1.263937429157861e-17,  4.549983085846603e-19, -2.180362882314022e-20,  8.122771229318373e-22, -2.154471347122363e-23,
  4.502123268649829e-25, -1.125347251798065e-26,  3.981265794023971e-28, -1.179012421621857e-29,  1.968635715154385e-31, -9.546695489803013e-34,  1.444072582590712e-19,
 -3.321228189846370e-21,  1.748069744647133e-22, -1.017334165268074e-23,  4.582268289589516e-25, -1.657297605703936e-26,  5.520195733486856e-28, -1.924316052821388e-29,
  6.812822272647050e-31, -2.172992246785057e-32,  5.964422387562738e-34, -1.532084724938993e-35,  2.810206046672420e-04, -3.558964948690788e-06,  3.644981332883614e-08,
 -2.919493517438339e-10,  5.164906915203845e-13,  3.178056173379946e-14,  5.093381935761604e-17, -3.061477293983574e-17,  6.543865539267224e-19,  8.440486292402375e-21,
 -6.549267951690679e-22,  7.338013977649360e-24,  6.597489970343766e-04, -8.367895082041885e-06,  8.686990858559938e-08, -7.616312737740033e-10,  4.027722905702966e-12,
  1.529834750624561e-14,  3.134023753107371e-16, -4.486315279320479e-17,  9.309489423207730e-19,  1.192227578902378e-20, -9.226152565884900e-22,  1.017816614254831e-23,
  6.060074060755927e-04, -7.706134074324487e-06,  8.184909436668245e-08, -8.205870526350681e-10,  8.182049927195978e-12, -8.116020850370525e-14,  6.419191829025881e-16,
  3.360383263723193e-19, -8.189507346167953e-20, -1.705764307221305e-21,  1.211976880396684e-22, -1.572584706416163e-24,  3.021794673081006e-04, -3.857187145117917e-06,
  4.232645178565176e-08, -4.984965221768483e-10,  7.404650569287856e-12, -1.119835357333740e-13,  6.352723464521124e-16,  2.928040674293834e-17, -7.041395671599850e-19,
 -1.036743824358127e-20,  7.675069783964812e-22, -8.547219197577437e-24,  8.931435689724084e-05, -1.146016648628985e-06,  1.312937154968807e-08, -1.840181615960717e-10,
  3.563097578629506e-12, -6.318229006392095e-14,  3.487574237298634e-16,  1.968889453503738e-17, -4.632880010275643e-19, -7.096668250848673e-21,  5.131442006088756e-22,
 -5.549362420811029e-24,  1.597832133488411e-05, -2.064531344170521e-07,  2.498020002297353e-09, -4.180491190324267e-11,  9.733879282000780e-13, -1.882612574485034e-14,
  1.118667422418220e-16,  5.885344497224289e-18, -1.387073828560564e-19, -2.297956181654395e-21,  1.600847478551751e-22, -1.675446601157350e-24,  1.709698109038119e-06,
 -2.229483342044908e-08,  2.886663131876845e-10, -5.754843007123638e-12,  1.532005997168848e-13, -3.145381038207050e-15,  2.115370867869721e-17,  9.091166372350056e-19,
 -2.165903982077260e-20, -4.070880389219970e-22,  2.685114761672392e-23, -2.695429616554132e-25,  1.053919976674525e-07, -1.391257062429595e-09,  1.957724977283108e-11,
 -4.626167071335574e-13,  1.363687793784148e-14, -2.942455484197359e-16,  2.311482487254739e-18,  7.234332215654673e-20, -1.756603313657757e-21, -4.056234386028204e-23,
  2.471034779810782e-24, -2.351660406564917e-26,  3.501878296637626e-09, -4.700246170728755e-11,  7.328006462310226e-13, -2.041215732672683e-14,  6.531844920523788e-16,
 -1.479761966423996e-17,  1.391691364516372e-19,  2.681850442136071e-21, -6.720830839155873e-23, -2.232876902833214e-24,  1.212227550132272e-25, -1.082825805985322e-27,
  5.621626551455206e-11, -7.724588108496470e-13,  1.368877104408456e-14, -4.475898816292005e-16,  1.538257499633537e-17, -3.682018010671263e-19,  4.247854610601758e-21,
  3.222781816179115e-23, -8.676864589687386e-25, -6.443126025452885e-26,  2.970077157867335e-27, -2.517962666315135e-29,  3.617317649439852e-13, -5.149718228671918e-15,
  1.076605577477614e-16, -4.130414882546021e-18,  1.521784686911793e-19, -3.909942571931229e-21,  5.704725871160263e-23, -2.078432524924185e-25,  4.641781350092068e-27,
 -8.841665362680792e-28,  3.288831524703838e-29, -2.931038089211361e-31,  6.516586208745618e-16, -9.854398945248172e-18,  2.587752638058134e-19, -1.175300886202596e-20,
  4.698786352322679e-22, -1.342091940821509e-23,  2.600528104865846e-25, -3.863712099774503e-27,  1.053742928627379e-28, -4.809093044889365e-30,  1.445317205577985e-31,
 -1.815502966127835e-33,  1.332937938057873e-19, -2.307726641533908e-21,  8.769899523426115e-23, -4.920290405794520e-24,  2.257836294152384e-25, -7.912041154008181e-27,
  2.274488953082229e-28, -6.388977880295655e-30,  2.073716823325518e-31, -7.088096892159153e-33,  2.089506302469343e-34, -4.847327158345700e-36,  2.673460147494885e-04,
 -3.281192054119854e-06,  3.301650520831772e-08, -2.787811026516505e-10,  1.107715797206059e-12,  2.520212895129286e-14, -4.988428636830136e-16, -9.047722876760131e-18,
  5.911147164135648e-19, -8.740606090647304e-21, -1.845842476455941e-22,  1.037968580090028e-23,  6.276110296346096e-04, -7.708374529113406e-06,  7.812740066677882e-08,
 -6.946950397883966e-10,  4.325396089066262e-12,  1.128139692599499e-14, -5.054773827220600e-16, -1.418028896872271e-17,  8.420170069263984e-19, -1.234350119678564e-20,
 -2.616799355081918e-22,  1.466182742976646e-23,  5.764330767765726e-04, -7.088621912872565e-06,  7.273666719221305e-08, -7.018253819538347e-10,  6.712006601194814e-12,
 -6.596457629078905e-14,  6.111504369859561e-16, -2.494389962329968e-18, -7.653291697877154e-20,  1.400537494991878e-21,  3.260474597520796e-23, -1.848304448003802e-24,
  2.873926834258405e-04, -3.540652943478547e-06,  3.698475982828045e-08, -3.968806547218483e-10,  5.369930260748433e-12, -8.960066029784434e-14,  1.120395510214440e-15,
  5.744125862822469e-18, -6.465403788763591e-19,  9.815152222002916e-21,  2.185769208962841e-22, -1.212827267252154e-23,  8.492762118261097e-05, -1.048937666245518e-06,
  1.122341940337295e-08, -1.365074361143423e-10,  2.418616843405347e-12, -4.998122510805754e-14,  6.787731483287540e-16,  4.107068454937485e-18, -4.296515440020988e-19,
  6.470501702395926e-21,  1.483943356478571e-22, -8.134651140973155e-24,  1.518963748420375e-05, -1.882382772817113e-07,  2.077983622715683e-09, -2.905058644757115e-11,
  6.342913331630095e-13, -1.470222453836918e-14,  2.098013309399715e-16,  1.165677924275685e-18, -1.308559825316797e-19,  1.961405936934486e-21,  4.718369977737402e-23,
 -2.542935924457608e-24,  1.624752864854897e-06, -2.022462973057475e-08,  2.323488700415667e-10, -3.772170587439802e-12,  9.699415135837070e-14, -2.417422746879986e-15,
  3.600227850903082e-17,  1.571467449149872e-19, -2.103896921741139e-20,  3.132363904477257e-22,  8.120229550782618e-24, -4.269662849602514e-25,  1.001097216742743e-07,
 -1.253560191542286e-09,  1.515213275488223e-11, -2.879284357747098e-13,  8.434518803116825e-15, -2.215479642041693e-16,  3.450742958026097e-18,  9.014308304213786e-21,
 -1.801217472916460e-21,  2.645089386245313e-23,  7.741787317695780e-25, -3.924061241822426e-26,  3.324264720467150e-09, -4.196338061428233e-11,  5.414396682817734e-13,
 -1.212683569097109e-14,  3.952559744705818e-16, -1.084341346348012e-17,  1.779916756224456e-19,  4.727069450387261e-23, -7.753050618633730e-23,  1.101301134125515e-24,
  3.987465362800661e-26, -1.911230009740457e-27,  5.331664964211306e-11, -6.807713535980375e-13,  9.570007131488381e-15, -2.546113645212902e-16,  9.088561721232644e-18,
 -2.599587640996671e-19,  4.558737754348138e-21, -1.286023772256927e-23, -1.453919381112055e-24,  1.863874773480106e-26,  1.042535399853409e-27, -4.580299036921752e-29,
  3.425927474863682e-13, -4.450770595455661e-15,  7.035978443118605e-17, -2.248730983635301e-18,  8.719202297684367e-20, -2.614996928830293e-21,  5.013969714938911e-23,
 -3.489471305348406e-25, -7.900059569335718e-27,  4.758837712611103e-29,  1.243726931260826e-29, -4.774742665779462e-31,  6.156443172343020e-16, -8.238891682038780e-18,
  1.550004200978430e-19, -6.074805875309353e-21,  2.565324076740593e-22, -8.221050841725829e-24,  1.800289129690290e-25, -2.315718087625206e-27,  1.521574207872665e-29,
 -7.927240456712127e-31,  5.651601205054790e-32, -1.803753499586602e-33,  1.251650881320901e-19, -1.791250965201303e-21,  4.593023530672903e-23, -2.326944358419374e-24,
  1.106957075343879e-25, -4.037261701041175e-27,  1.125201350827644e-28, -2.572802520589384e-30,  6.116392269528961e-32, -1.951828517412563e-33,  6.844106877503701e-35,
 -1.956716963709843e-36,  2.547287934448857e-04, -3.030106411117825e-06,  2.979184737928422e-08, -2.577275424965037e-10,  1.481207929356168e-12,  1.200547711191304e-14,
 -5.402631968015066e-16,  4.175270069492522e-18,  2.340979176070876e-19, -9.172012016628711e-21,  1.060024074996089e-22,  2.786542544263023e-24,  5.979764506957696e-04,
 -7.115511780188831e-06,  7.021135933264844e-08, -6.244287803050171e-10,  4.411370164542640e-12, -3.024685964242078e-15, -6.000612216462884e-16,  4.718482340689405e-18,
  3.372766466075097e-19, -1.297779650991633e-20,  1.495326364586972e-22,  3.952848639870561e-24,  5.491914886456867e-04, -6.538685752213765e-06,  6.491808467823266e-08,
 -6.042187372720765e-10,  5.532522690012540e-12, -5.235974317445710e-14,  5.155896705034554e-16, -4.020312429079809e-18, -1.858466616705989e-20,  1.483532381569402e-21,
 -1.819722224555246e-23, -4.771613712875486e-25,  2.737935594760067e-04, -3.262491099775510e-06,  3.268335951823712e-08, -3.238196715168645e-10,  3.849286717509666e-12,
 -6.275539583407304e-14,  1.051400628067861e-15, -8.500714297149410e-18, -2.416766230754756e-19,  1.042910573226132e-20, -1.213697222475000e-22, -3.270747700367734e-24,
  8.090190660711351e-05, -9.651149340116389e-07,  9.787443050122573e-09, -1.049072618327268e-10,  1.584195166627456e-12, -3.362369265714250e-14,  6.408926191201285e-16,
 -5.371490726350860e-18, -1.610148630915372e-19,  6.939889094822187e-21, -8.044453314161444e-23, -2.214371403157321e-24,  1.446794064183880e-05, -1.728568554455259e-07,
  1.781463121101390e-09, -2.097719178297447e-11,  3.911058901076838e-13, -9.675107462306475e-15,  1.959078197811079e-16, -1.716330974398135e-18, -4.856381424215415e-20,
  2.135023727899094e-21, -2.464798249104287e-23, -7.000197783922575e-25,  1.547318031383916e-06, -1.852388763934946e-08,  1.949519519881359e-10, -2.559828687671833e-12,
  5.729918169697029e-14, -1.564802907117218e-15,  3.293047270836372e-17, -3.047373579704559e-19, -7.669254374470433e-21,  3.492551062403076e-22, -4.004659157750432e-24,
 -1.193127436623623e-25,  9.531886417490524e-08, -1.144177029491671e-09,  1.237503967269415e-11, -1.839426480659443e-13,  4.822786958873081e-15, -1.411965232091792e-16,
  3.064579558662512e-18, -3.033910478043211e-20, -6.377985677600756e-22,  3.075086290736660e-23, -3.479910665014882e-25, -1.119542163155416e-26,  3.164284521351886e-09,
 -3.812143217130196e-11,  4.274476705037211e-13, -7.309631485685298e-15,  2.199475474858374e-16, -6.792130972380107e-18,  1.518871754736770e-19, -1.634620522063296e-21,
 -2.611523087236123e-23,  1.389548000311667e-24, -1.528770653496766e-26, -5.614478281928157e-28,  5.073035042104251e-11, -6.143180266680628e-13,  7.234315459470728e-15,
 -1.450501512077002e-16,  4.930535730932136e-18, -1.593084354511956e-19,  3.685119234047435e-21, -4.404564053775883e-23, -4.404970670440995e-25,  2.879534829929570e-26,
 -2.949561261202752e-28, -1.402317574485256e-29,  3.257732720593164e-13, -3.975683615774284e-15,  5.022112296936665e-17, -1.210465377324067e-18,  4.600276677653072e-20,
 -1.553367814568275e-21,  3.755858829150560e-23, -5.143313150567637e-25, -1.504200101197761e-27,  2.142308296946391e-28, -1.670628216537715e-30, -1.545095963939755e-31,
  5.847908971228475e-16, -7.231779192436632e-18,  1.020060745150136e-19, -3.072166127794512e-21,  1.302842325033974e-22, -4.637662563095145e-24,  1.200258433356173e-25,
 -1.984016212673028e-27,  1.137018223282905e-29,  2.283903718235553e-31,  3.437038468801703e-33, -6.137501937060980e-34,  1.185936057094637e-19, -1.510684389301915e-21,
  2.638554220877842e-23, -1.076237930457874e-24,  5.204472384031319e-26, -2.029713362448632e-27,  6.025986753301793e-29, -1.350062453543268e-30,  2.386593140352401e-32,
 -4.638986639765353e-34,  1.573015594711805e-35, -6.092273884207810e-37  };
  int offset = -13;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 13;
    if (std::isnan(t)) {
      fill_n(rr+offset, 13, 0.5);
      fill_n(ww+offset, 13, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 13; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=13; ++j) {
        const int boxof = it*156+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
