//
// BAGEL - Parallel electron correlation program.
// Filename: _breitroot_7.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot7(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[7] = {1.290758622959153e+00,3.193036339206300e-01,2.958374458696650e+00,5.409031597244433e+00,8.804079578056776e+00,
    1.346853574325148e+01,2.024991636587088e+01};
  constexpr double aw[7] = {2.045709347070511e-01,1.315622571979460e-01,9.105886604635807e-02,1.502666215063549e-02,8.804470587700310e-04,
    1.426473561057987e-05,3.083000770519572e-08};
  constexpr double x[2688] = {  7.626105300631937e-02, -2.297680865367110e-03,  4.992996836187280e-05, -9.115929245811886e-07,  1.433924331460779e-08,
 -1.885928755571862e-10,  1.796970016495297e-12, -2.539027424945077e-15, -4.164575922253494e-16,  1.302146733991937e-17, -2.680180880937858e-19,  4.180933855945523e-21,
  2.945988907709758e-01, -7.921419134961364e-03,  1.330747683068267e-04, -1.346954329213732e-06, -1.448572818301468e-09,  3.832586165399999e-10, -8.132211005126539e-12,
  6.511718010895692e-14,  1.199814834967816e-15, -5.156172690956731e-17,  8.133162016263621e-19, -7.302541403159779e-22,  6.244042762448027e-01, -1.368241189752649e-02,
  1.256434155667044e-04,  9.299853662907307e-07, -4.134228612481816e-08,  2.255981446578627e-10,  1.085030943342382e-11, -2.221167942256539e-13, -1.175964742305730e-15,
  1.041183602263554e-16, -9.494970887807738e-19, -3.094192913870778e-20,  1.017322313486484e+00, -1.612540513008033e-02, -2.720484185935970e-06,  2.793132258158482e-06,
  3.802536765699677e-10, -8.721922117969272e-10,  2.208714989343119e-14,  3.308388193431087e-13, -9.431603123452955e-17, -1.393126957639025e-16,  7.477526315879341e-20,
  6.239602669429113e-20,  1.412047869695798e+00, -1.356540633378956e-02, -1.341213407482582e-04,  8.555952900634440e-07,  4.418797754225277e-08,  2.813802832176287e-10,
 -1.171871169921473e-11, -2.602723409306229e-13,  1.149478497092098e-15,  1.237792696042851e-16,  1.219775913026464e-18, -3.781870143651061e-20,  1.742399976424029e+00,
 -7.415449863955043e-03, -1.356048334820167e-04, -1.582120096469943e-06, -2.891974753429044e-09,  3.780517312136903e-10,  9.883147206668452e-12,  1.121265161270341e-13,
 -7.816028905220609e-16, -6.241247451956203e-17, -1.306434216541677e-18, -9.036942394458260e-21,  1.949029358844548e+00, -1.652883896866094e-03, -3.912592527299206e-05,
 -7.923040546304134e-07, -1.425826343818619e-08, -2.278906392218845e-10, -3.122077842520576e-12, -3.233816005726075e-14, -9.713598719163496e-17,  6.724386378473551e-18,
  2.449325639612308e-19,  5.730240287911707e-21,  6.780507522585852e-02, -1.938368954719259e-03,  4.025041922850674e-05, -7.100430204837466e-07,  1.098671266252211e-08,
 -1.474572309380633e-10,  1.596925090331794e-12, -1.011177250663696e-14, -1.019381009219293e-16,  5.371150605942634e-18, -1.284874923118510e-19,  2.269463775493216e-21,
  2.649401710546729e-01, -6.921351826071643e-03,  1.169926917628133e-04, -1.318736347692456e-06,  4.428499822973940e-09,  2.128074308538829e-10, -6.007054808790056e-12,
  7.983203300791357e-14, -1.070277198293013e-16, -2.258569269502995e-17,  5.889814613651728e-19, -7.300771669430046e-21,  5.717402816465572e-01, -1.264344620804549e-02,
  1.330232358828878e-04,  3.166035856857456e-07, -3.473841800100206e-08,  4.102705230585270e-10,  4.603487735736573e-12, -2.090645038010471e-13,  1.666837680583379e-15,
  5.042019930089141e-17, -1.475116269003687e-18,  4.314187558316618e-21,  9.529878604498633e-01, -1.601430536215371e-02,  3.026651755270564e-05,  2.662779699405782e-06,
 -1.632888215565104e-08, -7.653258626413720e-10,  8.523413562768167e-12,  2.532617942290990e-13, -4.439412054364277e-15, -8.728690946196680e-17,  2.273078427412809e-18,
  2.848614641501081e-20,  1.355722720743732e+00, -1.458497274528730e-02, -1.194824101201071e-04,  1.589994850409658e-06,  4.645266673224953e-08, -7.880675979759548e-11,
 -1.777753762787529e-11, -1.469046072012616e-13,  5.952145148375861e-15,  1.254090943929594e-16, -1.413103535588290e-18, -7.417610544669968e-20,  1.710448017170665e+00,
 -8.576353555488468e-03, -1.545739148187334e-04, -1.554029436457132e-06,  7.270543787780663e-09,  6.476456612863124e-10,  1.226001251514833e-11,  4.065484879282059e-14,
 -4.008274464667631e-15, -1.158823737286249e-16, -1.132215715409510e-18,  2.345328256460473e-20,  1.941725626279930e+00, -2.008174527147391e-03, -5.016681129405119e-05,
 -1.061280502944783e-06, -1.963929311668193e-08, -3.137320520364725e-10, -4.017841801755481e-12, -2.908762649183282e-14,  3.978624631163425e-16,  2.336023856823515e-17,
  6.390106643909918e-19,  1.289638177145518e-20,  6.064558267423590e-02, -1.647670383746896e-03,  3.269377640353992e-05, -5.558673051383763e-07,  8.396634777667588e-09,
 -1.127496192268809e-10,  1.291132385609536e-12, -1.110128696701480e-14,  1.929324629904156e-17,  1.835787146169441e-18, -5.653538284056532e-20,  1.134112281710832e-21,
  2.390284902920224e-01, -6.047228793163295e-03,  1.017101124968524e-04, -1.220919471965248e-06,  7.419367931527461e-09,  9.447037206590589e-11, -3.913156857980888e-12,
  6.731947140703150e-14, -5.725516273514306e-16, -5.280054780594455e-18,  2.888027446016665e-19, -5.681500552268791e-21,  5.233064507684856e-01, -1.157285896472084e-02,
  1.337726763460101e-04, -1.694291253361748e-07, -2.586549454133989e-08,  4.578219912747119e-10, -3.079311474087366e-13, -1.373415962494224e-13,  2.518090770800294e-15,
  6.232353745595982e-19, -9.241584421164568e-19,  1.693881083333779e-20,  8.896095745687340e-01, -1.564988164920850e-02,  6.018901365522067e-05,  2.292271552552659e-06,
 -2.910824111503672e-08, -4.939549804327528e-10,  1.328782978076185e-11,  7.991249589131919e-14, -5.796435584614214e-15,  1.196943141015563e-17,  2.298166446322475e-18,
 -2.415040760801979e-20,  1.295609434587352e+00, -1.545215274576952e-02, -9.607290330738055e-05,  2.296483571689800e-06,  4.040375454772876e-08, -5.296789313149439e-10,
 -1.865962804418489e-11,  9.868902473963109e-14,  8.698836042262090e-15,  8.959787254713582e-18, -4.098700579741872e-18, -3.164952836344687e-20,  1.673555535557298e+00,
 -9.884471727995255e-03, -1.720447465910124e-04, -1.318016014567602e-06,  2.316587918790681e-08,  9.369539109760098e-10,  1.092998386907465e-11, -1.600246519100587e-13,
 -8.583141338619317e-15, -1.221468322294167e-16,  1.323164533023161e-18,  9.160691107874465e-20,  1.932801387282456e+00, -2.466304510357877e-03, -6.501225264297435e-05,
 -1.431184695856838e-06, -2.693271412310752e-08, -4.175109363087418e-10, -4.485177316374994e-12,  3.316488870092732e-15,  1.862315339268034e-15,  6.322079690417511e-17,
  1.429078325356726e-18,  2.301612086477750e-20,  5.453876715200558e-02, -1.410678876749513e-03,  2.676020036105872e-05, -4.379812336921251e-07,  6.426906461804260e-09,
 -8.537504471804505e-11,  9.962727387256187e-13, -9.776483978821252e-15,  5.505489906052460e-17,  3.993771768612450e-19, -1.862194019196314e-20,  6.671623825371811e-22,
  2.163771473269993e-01, -5.290020492223026e-03,  8.781881737525342e-05, -1.091595004166412e-06,  8.511107553028210e-09,  2.099664638131609e-11, -2.299940025431315e-12,
  4.775565221147250e-14, -6.059971896046892e-16,  2.258976085206501e-18,  1.127480419980614e-19, -2.352314234959180e-21,  4.791334758267706e-01, -1.051715811778918e-02,
  1.295541190721670e-04, -5.115726881225145e-07, -1.704811506185507e-08,  4.131921622873681e-10, -3.064422066620466e-12, -6.208093794363692e-14,  2.053759615587035e-15,
 -2.169159004596983e-17, -2.148788647704145e-19,  1.393578574106255e-20,  8.281352620098875e-01, -1.506689390314920e-02,  8.463319236120967e-05,  1.765228752551145e-06,
 -3.572153944950001e-08, -1.681853242647931e-10,  1.310522837373146e-11, -8.352090316672177e-14, -4.039445208559169e-15,  7.541877281615133e-17,  7.883044308364019e-19,
 -3.616875314087615e-20,  1.232452452729528e+00, -1.610047119478307e-02, -6.506083168795362e-05,  2.835360677670854e-06,  2.571527585348689e-08, -9.137641906983631e-10,
 -1.218355767016085e-11,  3.496086001935666e-13,  6.006011175862465e-15, -1.525821882291972e-16, -3.188703073554573e-18,  7.422993243912716e-20,  1.631175641367451e+00,
 -1.131628657798188e-02, -1.849780664152251e-04, -7.853252000587308e-07,  4.398959599118296e-08,  1.110987309587300e-09,  2.067086349859624e-12, -4.858275161052785e-13,
 -1.089285891587717e-14,  2.818724211231976e-17,  6.440287072545714e-18,  1.224858814973166e-19,  1.921775977342671e+00, -3.063096954761487e-03, -8.506606687694391e-05,
 -1.934574605564134e-06, -3.630652510837239e-08, -5.147578998073300e-10, -3.125111730528377e-12,  1.124558572897446e-13,  5.427443857505543e-15,  1.421182663202823e-16,
  2.509075372424899e-18,  2.124277521312580e-20,  4.929323520419254e-02, -1.215994031228694e-03,  2.206902390950127e-05, -3.476009579267051e-07,  4.937408805293739e-09,
 -6.454084011258897e-11,  7.486414268220458e-13, -7.875800432335692e-15,  6.236909097178823e-17,  1.602639220420192e-19,  4.432673643333529e-21,  3.504535218123507e-22,
  1.965424935798452e-01, -4.637536961164369e-03,  7.554203645860832e-05, -9.546404975502838e-07,  8.476458469470016e-09, -2.024516736242758e-11, -1.216777336777589e-12,
  3.037932264568556e-14, -4.615720082154909e-16,  5.418081797880543e-18,  5.831303115296985e-20, -5.846728503522816e-22,  4.390930756230607e-01, -9.509318076064113e-03,
  1.220370763410296e-04, -7.226947925186673e-07, -9.625340528860399e-09,  3.254599026929704e-10, -4.005460435291975e-12, -9.433808851279540e-15,  1.247539283538674e-15,
 -2.008143576051087e-17,  2.395475868647048e-19,  6.269061104511042e-21,  7.693420546577594e-01, -1.431496315530568e-02,  1.023282919497091e-04,  1.182839464484585e-06,
 -3.619370130749700e-08,  1.063247870483824e-10,  9.391873369405137e-12, -1.660806613190810e-13, -1.094740950519135e-15,  8.038470564312126e-17, -3.834705578431943e-19,
 -1.552980788941720e-20,  1.167233017260078e+00, -1.647934025905091e-02, -2.921250676974730e-05,  3.088362258098309e-06,  5.396936687336488e-09, -1.072753888841578e-09,
 -6.610941159965455e-13,  4.370683874298132e-13, -7.951660618137907e-16, -1.945307971787577e-16,  1.360036166594486e-18,  1.097749491900767e-19,  1.582910270455802e+00,
 -1.282016107537473e-02, -1.894512627749690e-04,  9.365944318077349e-08,  6.541124764738838e-08,  9.609234062402998e-10, -1.585459247687424e-11, -7.593341428725282e-13,
 -4.180592975799833e-15,  3.638877666554562e-16,  9.156771248708371e-18, -4.087842647831101e-20,  1.908000506609282e+00, -3.847162372334726e-03, -1.121154076449048e-04,
 -2.600424114734775e-06, -4.697253250390336e-08, -5.268949400424498e-10,  3.370100565493212e-12,  3.885720716495657e-13,  1.247309240447521e-14,  2.484862589103198e-16,
  2.296541171329370e-18, -5.142514919853309e-20,  4.475771996974136e-02, -1.054875825799593e-03,  1.833217405124356e-05, -2.780235580812495e-07,  3.809598178460509e-09,
 -4.898705648005852e-11,  5.573006195468968e-13, -5.732785065296860e-15,  7.356352287890672e-17,  4.765460244309128e-19,  6.375971632911248e-21, -3.324222834006811e-22,
  1.791316686594862e-01, -4.076757575497659e-03,  6.488231230088502e-05, -8.235814275397137e-07,  7.840622184439312e-09, -4.071442710984377e-11, -5.407276691827315e-13,
  1.912272360197934e-14, -2.320804686802634e-16,  7.040875259162814e-18,  1.214220208926766e-20, -2.020912914410756e-21,  4.029503848970308e-01, -8.569868286958032e-03,
  1.126385233975151e-04, -8.298662470067488e-07, -4.078094598429740e-09,  2.300785909988966e-10, -3.803907380401389e-12,  2.114001483415394e-14,  7.375450789304867e-16,
 -7.880484474733937e-18,  2.939151166200170e-19, -4.194108293151971e-21,  7.137957556501832e-01, -1.344917205422742e-02,  1.131531965086300e-04,  6.313798881552881e-07,
 -3.219941303968568e-08,  2.745090368122543e-10,  4.658931781273869e-12, -1.587975499889891e-13,  1.403578588171713e-15,  5.601030394374953e-17, -7.650933109388964e-19,
 -6.025200540595380e-21,  1.101082911836561e+00, -1.656494696912400e-02,  7.666210589597277e-06,  3.006242263385197e-06, -1.526578584557775e-08, -9.505213475528891e-10,
  1.029204422957192e-11,  3.183872054531804e-13, -5.838464433523291e-15, -6.547660604312341e-17,  4.336238032108428e-18,  8.233247547619074e-21,  1.528632354116195e+00,
 -1.431219376393414e-02, -1.815006506649732e-04,  1.265990400621123e-06,  7.908431219473673e-08,  3.246033403034211e-10, -3.656296367568912e-11, -6.218933409321757e-13,
  1.422633199882195e-14,  5.995473734298119e-16,  2.162126512156055e-19, -3.627324921461083e-19,  1.890601347742064e+00, -4.882432803845019e-03, -1.481510733132708e-04,
 -3.427271725013500e-06, -5.555036464654607e-08, -2.616178115037940e-10,  2.126784444583125e-11,  9.408347734331950e-13,  2.200228651475109e-14,  2.337807837252028e-16,
 -5.036071226627945e-18, -3.285282213988611e-19,  4.081177201771886e-02, -9.205973431268604e-04,  1.533149822328092e-05, -2.242307738281925e-07,  2.952052565783984e-09,
 -3.725543132672065e-11,  4.324281886447657e-13, -3.098911605792687e-15,  8.947476211953491e-17,  1.880684210431957e-19, -2.652673647517578e-20, -1.099120648244506e-21,
  1.638030876435830e-01, -3.595163950441947e-03,  5.572334695562980e-05, -7.051809477843362e-07,  6.936581658557679e-09, -4.787355346522386e-11, -7.174990370762679e-14,
  1.562000234599311e-14,  8.604083988990751e-19,  4.888776008821496e-18, -1.401072254609474e-19, -4.724221152132789e-21,  3.704089142216729e-01, -7.709384244052609e-03,
  1.024250750203452e-04, -8.630169020918382e-07, -3.285880170882824e-10,  1.483612631021296e-10, -2.911086198614069e-12,  4.191686475736488e-14,  5.918451556342164e-16,
 -2.959329076314182e-18, -1.170961430341233e-19, -1.350102221260903e-20,  6.618457300897214e-01, -1.252194882196275e-02,  1.178356036502954e-04,  1.647872037694313e-07,
 -2.591792134138076e-08,  3.396798795607900e-10,  1.098864185562600e-12, -8.816444655687810e-14,  2.786016259171710e-15,  1.782097451968834e-17, -1.219075348503748e-18,
 -1.565503551876081e-20,  1.035166617112121e+00, -1.636481410344413e-02,  4.169906191229011e-05,  2.625962012753810e-06, -3.119808886599248e-08, -6.186551135223495e-10,
  1.646761628967297e-11,  1.255874800247883e-13, -5.353847378351188e-15,  7.552867519523627e-17,  1.839219750955525e-18, -1.091846826343347e-19,  1.468606382252766e+00,
 -1.568176162436943e-02, -1.586702782255316e-04,  2.530852315490884e-06,  7.573883309398732e-08, -6.912581215391958e-10, -4.454383835597341e-11,  1.458503442211242e-13,
  3.166233506762958e-14,  2.464712235458654e-16, -1.789806678191952e-17, -3.606957732708010e-19,  1.868419159521743e+00, -6.247427042720642e-03, -1.946659051453271e-04,
 -4.319735607424119e-06, -5.310820083112877e-08,  6.500269616692444e-10,  5.825212483938956e-11,  1.704115630739833e-12,  2.203062840975231e-14, -3.993976906936472e-16,
 -3.035017751123536e-17, -8.256021272682354e-19,  3.735870847070236e-02, -8.079585637315016e-04,  1.290129737257463e-05, -1.824186072281636e-07,  2.305362514343567e-09,
 -2.759835441759136e-11,  3.847289042266893e-13, -4.312101421743133e-16,  6.493488131974430e-17, -1.880282321686114e-18, -7.506077873332796e-20, -8.266593227977049e-22,
  1.502629794913860e-01, -3.181411741409076e-03,  4.789559787020893e-05, -6.017985925157104e-07,  5.997848646363260e-09, -4.423056875124694e-11,  3.823060747615819e-13,
  1.696084412958197e-14,  2.417451128171224e-17, -4.974865892466681e-18, -3.440544653065278e-19, -3.393638256627192e-21,  3.411447318269576e-01, -6.931294853202592e-03,
  9.212412894286936e-05, -8.478968267298037e-07,  2.045473011446838e-09,  9.455877309171951e-11, -1.501722746946081e-12,  5.703755030143076e-14,  2.519191664075220e-16,
 -1.993469295526537e-17, -7.100161246122519e-19, -1.032867773706600e-20,  6.136465640648856e-01, -1.157788167398722e-02,  1.175519123211705e-04, -1.947719079771428e-07,
 -1.900731217138016e-08,  3.467243866163261e-10, -1.006069228343523e-13,  3.924408176196470e-16,  2.370531093437435e-15, -4.578196729265881e-17, -1.932734295043882e-18,
 -1.119619407283276e-20,  9.705610803896270e-01, -1.591445751093968e-02,  6.987934129376655e-05,  2.050164048763964e-06, -3.942246743438038e-08, -1.978217860140140e-10,
  1.803740343174344e-11,  1.877129397587987e-15, -2.560474309146092e-15,  4.518713864464086e-17, -3.258170195457364e-18, -9.569472327685157e-20,  1.403560197735285e+00,
 -1.681045460337048e-02, -1.216646322849687e-04,  3.577486773017244e-06,  5.216035154372509e-08, -1.594189653976302e-09, -2.606994970416689e-11,  1.139393584944437e-12,
  2.502185358899236e-14, -6.486172806074147e-16, -2.268265943798901e-17,  1.981903147567989e-19,  1.839968131838258e+00, -8.024979990425524e-03, -2.508788321860508e-04,
 -4.972112300724081e-06, -2.194333499013366e-08,  2.676812717649649e-09,  1.115715927814265e-10,  1.869759351015431e-12, -2.342313934692530e-14, -2.367405137238447e-15,
 -6.526174617568853e-17, -3.818690079125305e-19,  3.432026520908018e-02, -7.129159160312793e-04,  1.091699584177190e-05, -1.494477529651112e-07,  1.845620819962308e-09,
 -1.835945056918557e-11,  3.871675298021020e-13, -5.717919228394757e-17, -6.079977927561159e-17, -5.045902739634236e-18, -6.389995389396666e-20,  1.845917209661150e-21,
  1.382601449874244e-01, -2.825565069949166e-03,  4.122266929705218e-05, -5.122514328294054e-07,  5.242844635624733e-09, -2.953443504717509e-11,  8.210898828709583e-13,
  1.204765313713281e-14, -4.183350653321381e-16, -1.932437792369561e-17, -2.917174282992493e-19,  7.909048566451279e-21,  3.148300605739027e-01, -6.234310767369643e-03,
  8.220329837636601e-05, -8.014492691170891e-07,  3.706721718731239e-09,  7.771755452409026e-11,  5.761769499841937e-14,  4.757129108557392e-14, -1.034580573592002e-15,
 -5.130184073892190e-17, -6.514136494673485e-19,  1.827723897567685e-20,  5.691944609250141e-01, -1.065145868650163e-02,  1.136186886677457e-04, -4.434111020867045e-07,
 -1.206023207568421e-08,  3.509436606791718e-10,  6.154770097861393e-13,  3.459234691135946e-14, -6.920020040445685e-16, -1.215439391277977e-16, -1.459810780832866e-18,
  4.355087782470300e-20,  9.081617894528784e-01, -1.526788624550554e-02,  9.064205001808473e-05,  1.411134199797392e-06, -3.909096612912220e-08,  2.268849554746301e-10,
  1.697045874110419e-11, -8.531792077896148e-14, -3.963017505667738e-15, -1.309971853357962e-16, -4.355963583218474e-18,  6.794723759790626e-20,  1.334660263003966e+00,
 -1.760044938644554e-02, -7.485684370929668e-05,  4.135128586625478e-06,  1.695910787593259e-08, -1.773768975964006e-09,  1.243513867211361e-11,  1.418928162813526e-12,
 -1.099485573973268e-14, -1.215658430212479e-15, -2.353725439516318e-18,  6.489652412256682e-19,  1.803474494477228e+00, -1.027154850452308e-02, -3.103703577179287e-04,
 -4.734336386689083e-06,  6.177299173306456e-08,  5.801339048578875e-09,  1.370675777473836e-10, -7.311489245687243e-13, -1.518097770490688e-13, -4.375101170345078e-15,
 -2.570065773052274e-18,  4.063541852679446e-18,  3.163259147549249e-02, -6.322760855155458e-04,  9.290304590618113e-06, -1.223572466207264e-07,  1.569326752662058e-09,
 -9.486501917787939e-12,  3.288369404985284e-13, -5.158441536634604e-15, -2.557260045959754e-16, -4.502999192460492e-18,  1.303285656308425e-19,  7.089388495509396e-21,
  1.275804796626148e-01, -2.518983238348764e-03,  3.556316938159245e-05, -4.319420950614288e-07,  4.865775850688244e-09, -7.992939155926765e-12,  8.560567196075137e-13,
 -1.368237889463490e-14, -1.184742668468377e-15, -1.781970790352636e-17,  5.327902689010666e-19,  3.005544389152871e-20,  2.911487421985910e-01, -5.614025203349157e-03,
  7.299431431370667e-05, -7.292694106967182e-07,  5.355734695191467e-09,  8.951220230751203e-11,  6.260996465199619e-13, -1.764236156542516e-14, -3.017826343431660e-15,
 -4.571168784206078e-17,  1.347131816478268e-18,  7.391909342398175e-20,  5.283689062391250e-01, -9.766533381893166e-03,  1.073748679861896e-04, -5.791917334569403e-07,
 -4.846352722904096e-09,  3.705149979497641e-10,  5.662872506917178e-13, -6.329491862970303e-14, -5.380225316867868e-15, -1.105253150261293e-16,  2.852173441930433e-18,
  1.561052692728308e-19,  8.486333819000328e-01, -1.448516481296216e-02,  1.040413725244868e-04,  8.429738297314129e-07, -3.077009200637546e-08,  5.858431950544147e-10,
  1.191251762439475e-11, -3.110155535670396e-13, -1.042553882224116e-14, -1.709395667727325e-16,  4.297831590644458e-18,  3.285925813872013e-19,  1.263378192329198e+00,
 -1.799873349402895e-02, -2.469132220338160e-05,  4.151166683324140e-06, -1.268853298818253e-08, -1.077974887341275e-09,  4.086790516142329e-11,  4.072432377146976e-13,
 -4.918202900651907e-14, -6.988713570410681e-16,  2.885806251056650e-17,  7.454853283591939e-19,  1.757099277480215e+00, -1.295505892818004e-02, -3.568910489614928e-04,
 -2.657642548222925e-06,  2.056147729455738e-07,  8.160923399991824e-09,  2.736075129648409e-11, -7.664594825563470e-12, -2.510059012108013e-13,  8.916967096759307e-16,
  2.966017450455002e-16,  7.775654669779552e-18,  2.924341959220759e-02, -5.634118899374077e-04,  7.967623451931650e-06, -9.840423828056827e-08,  1.441586484776036e-09,
 -4.350008276191280e-12,  5.643691739604313e-14, -1.427036018778431e-14, -2.426089870601551e-16,  7.408706824007446e-18,  4.451254556055086e-19,  3.884085104880567e-21,
  1.180425902110690e-01, -2.253893489766148e-03,  3.084476528641199e-05, -3.544651923318435e-07,  4.856438875527873e-09,  3.294003120361917e-12, -1.088093490430386e-13,
 -5.494805312003371e-14, -1.096983425919201e-15,  3.196663836377860e-17,  1.874083602156928e-18,  1.684663121035698e-20,  2.698073665779591e-01, -5.063479181883300e-03,
  6.481799046983018e-05, -6.288180434092986e-07,  7.195277443478866e-09,  8.671888738931608e-11, -1.353302248251343e-12, -1.232292402510991e-13, -2.838144383782101e-15,
  7.877826783440803e-17,  4.687405973220342e-18,  4.302667411929189e-20,  4.909756340897452e-01, -8.936090414082982e-03,  1.002036783593196e-04, -5.977016653228448e-07,
  2.444170425052578e-09,  3.408522510057040e-10, -3.973375223350895e-12, -2.624948566866497e-13, -5.496621945880332e-15,  1.531001231792100e-16,  9.956369859959685e-18,
  9.446445779294500e-20,  7.924109146280924e-01, -1.361976680489854e-02,  1.116302575925938e-04,  4.562268579109225e-07, -1.711181950765136e-08,  7.258015872785550e-10,
 -1.976716060896657e-12, -6.788780734084402e-13, -9.633248793145117e-15,  3.207719824209931e-16,  1.965297933324280e-17,  2.191216440449652e-19,  1.191297096464576e+00,
 -1.800174614788166e-02,  2.336816416672523e-05,  3.829436301583360e-06, -2.449977442978183e-08, -1.518605571968303e-10,  2.841022708825054e-11, -1.283453556332108e-12,
 -4.593232520471578e-14,  1.065603421247322e-15,  5.584002636229188e-17,  2.059784055279489e-19,  1.699461890845967e+00, -1.586961501339946e-02, -3.637779720293035e-04,
  1.885621086994335e-06,  3.537952481214035e-07,  5.459921053038403e-09, -2.754636385646152e-10, -1.239762229252878e-11,  4.798584441385944e-14,  1.594008755992637e-14,
  3.081485126274649e-16, -1.214651698572068e-17,  2.711031985817665e-02, -5.040090519430194e-04,  6.922132456800158e-06, -7.610851252805287e-08,  1.332733685146435e-09,
 -8.296451165265776e-12, -3.870282774233718e-13, -1.435961284980096e-14,  3.282759586558463e-16,  2.197852976931778e-17,  8.193281926095772e-20, -2.276415501759383e-20,
  1.094954600166309e-01, -2.022827483929698e-03,  2.705755463300863e-05, -2.769526817688422e-07,  4.757516476812317e-09, -2.015714864433648e-11, -1.861593711361203e-12,
 -5.725832352439557e-14,  1.338646344581601e-15,  9.359703494890968e-17,  3.515789029940240e-19, -9.640702542620503e-20,  2.505456620437456e-01, -4.573047478875765e-03,
  5.801088826597453e-05, -5.028945132216362e-07,  8.288274904982485e-09,  6.510881462711396e-12, -5.387634530500050e-12, -1.326019245158409e-13,  3.224444674345131e-15,
  2.339951647535421e-16,  9.257031350206715e-19, -2.412902994258774e-19,  4.567906686933306e-01, -8.162014967069250e-03,  9.346658705019524e-05, -5.120035076996708e-07,
  7.641412296787718e-09,  1.453190303159408e-10, -1.240024870192439e-11, -2.732235840956110e-13,  6.913862479584530e-15,  4.866254581492168e-16,  2.147012660394073e-18,
 -5.112673570948798e-19,  7.397474258412529e-01, -1.270842778608533e-02,  1.159141663837864e-04,  2.890904841466577e-07, -4.724210463347441e-09,  4.316957542887572e-10,
 -2.245295055988571e-11, -6.483845078678773e-13,  1.575088987231538e-14,  9.919224041120926e-16,  4.251281567032463e-18, -1.060194978367045e-18,  1.119945544581861e+00,
 -1.763771272447043e-02,  6.694991433260895e-05,  3.435586736659347e-06, -2.428182906566068e-08, -1.674880833363904e-11, -1.935158840789806e-11, -1.730706168145969e-12,
  2.846502785071396e-14,  2.740409544168751e-15,  4.849134842211076e-18, -2.846478567721402e-18,  1.630449480048210e+00, -1.858767917229688e-02, -3.050451589079594e-04,
  7.953179363230189e-06,  3.721092984726226e-07, -4.563566992948510e-09, -5.064639679804726e-10, -8.515466149618652e-13,  6.411499863156746e-13,  1.006848688162157e-14,
 -6.981101438859479e-16, -2.350542443725088e-17,  2.519974384914667e-02, -4.519391467567840e-04,  6.129360231203561e-06, -5.672308461554638e-08,  1.050493257710910e-09,
 -2.052448175537288e-11, -5.316405687764067e-13,  7.152124429582635e-15,  8.931147021381566e-16,  1.404001929278556e-18, -1.067074059782769e-18, -1.572488358587568e-20,
  1.018177864562504e-01, -1.818415357487982e-03,  2.416848267120331e-05, -2.069040984566087e-07,  3.815561753717345e-09, -7.625773828884571e-11, -2.394676542873110e-12,
  3.250282007388749e-14,  3.749207948851767e-15,  6.288177352223348e-18, -4.537423871205901e-18, -6.715365105580259e-20,  2.331465583770251e-01, -4.130885719921640e-03,
  5.275063799307620e-05, -3.772208539302030e-07,  6.917057751996547e-09, -1.482366018106703e-10, -6.477865456017524e-12,  8.813609321761398e-14,  9.267817212037629e-15,
  1.592805833030403e-17, -1.139824184597832e-17, -1.701040695597889e-19,  4.256022423967116e-01, -7.436674520229302e-03,  8.809407387005704e-05, -3.846077395860079e-07,
  7.148117944929060e-09, -2.035623802493000e-10, -1.449773554932233e-11,  1.929815101683112e-13,  1.948280613646014e-14,  2.802000120671214e-17, -2.420593315471760e-17,
 -3.644843317734731e-19,  6.907890929173351e-01, -1.176808217637948e-02,  1.191063139265091e-04,  2.485615696545736e-07, -2.519237599320853e-09, -2.365218130554407e-10,
 -2.856789400537743e-11,  3.513604942678094e-13,  4.093880131446456e-14,  2.241990302234986e-17, -5.089373366267019e-17, -7.476336334488084e-19,  1.050717346424635e+00,
 -1.694406963758955e-02,  1.057150161972879e-04,  3.005665653406841e-06, -3.228468403719416e-08, -8.741307638594113e-10, -4.157852788874110e-11,  5.138740693428626e-13,
  9.550747920937544e-14,  2.392746365454977e-17, -1.322303502587746e-16, -1.540492675771350e-18,  1.551950984243086e+00, -2.055616411974477e-02, -1.789525738795905e-04,
  1.255201609383409e-05,  1.699323119773497e-07, -1.458127328612479e-08, -2.351614996129272e-10,  1.880379833482834e-11,  3.715687915315062e-13, -2.455887893195633e-14,
 -6.063447202240230e-16,  3.161048093893640e-17,  2.348610334075495e-02, -4.053763732581391e-04,  5.534059868530350e-06, -4.376860809216883e-08,  5.443959932091474e-10,
 -2.791285628941721e-11,  1.506294203189459e-14,  2.804125432911486e-14,  1.770999327346364e-16, -3.635817529874184e-17, -3.520777163441936e-19,  4.476506263438434e-20,
  9.491638585396252e-02, -1.634094762838429e-03,  2.199289468633229e-05, -1.606358711873185e-07,  1.855574908579533e-09, -1.103540473782349e-10, -3.150547015549116e-14,
  1.199534205974713e-13,  7.160473070170353e-16, -1.541805236189274e-16, -1.482080487422339e-18,  1.912178323945769e-19,  2.174406547786761e-01, -3.725379438559349e-03,
  4.876652017223281e-05, -2.972965171200560e-07,  2.760967146411863e-09, -2.433445026618293e-10, -4.266282268836967e-13,  3.030731719297931e-13,  1.656126361855991e-15,
 -3.863852978941591e-16, -3.632391277276149e-18,  4.849785989059837e-19,  3.972380185800977e-01, -6.748856952645744e-03,  8.397736913542330e-05, -3.186650109472280e-07,
  3.776461018859689e-10, -4.222802036945279e-10, -1.604046788010822e-12,  6.399353209244431e-13,  3.149989280321293e-15, -8.209235200575338e-16, -7.260046834628425e-18,
  1.048063971907984e-18,  6.456396423095581e-01, -1.080456046735027e-02,  1.215857120362966e-04,  1.390315789751486e-07, -1.259425284429549e-08, -6.699531454071829e-10,
 -3.172649671422662e-12,  1.272491822909777e-12,  5.719782946493073e-15, -1.721402610928161e-15, -1.285979732856059e-17,  2.258360656377785e-18,  9.848464043042900e-01,
 -1.596449149093697e-02,  1.379587261547729e-04,  2.305780437173251e-06, -5.692812199483545e-08, -1.390278696869733e-09,  8.405544611423584e-12,  2.579048197332480e-12,
  7.579522466788972e-15, -4.118684699857800e-15, -1.669294125040585e-17,  5.879337727650055e-18,  1.467851717383723e+00, -2.136227498875904e-02, -2.210953226496692e-05,
  1.282296438698214e-05, -1.323694536741715e-07, -1.347031920102870e-08,  3.097928045932975e-10,  1.504984465739023e-11, -5.546175126884173e-13, -1.634913941117462e-14,
  8.982969033410829e-16,  1.647645926424050e-17,  2.194997127075117e-02, -3.630976941687739e-04,  5.043462627652824e-06, -3.924187214292114e-08,  5.149346376600898e-11,
 -1.869701073738748e-11,  6.864085140369603e-13,  1.398592871880321e-14, -9.094751197088614e-16, -1.287566335375816e-17,  1.246227440957657e-18,  8.685115606055370e-21,
  8.872018271407295e-02, -1.465519788515449e-03,  2.017351992528642e-05, -1.475222165355192e-07, -9.552601284664737e-11, -7.333323408294375e-11,  2.830109850712595e-12,
  5.941444805053251e-14, -3.872860224746792e-15, -5.344478462524693e-17,  5.309437112851777e-18,  3.543243604616824e-20,  2.032973921181924e-01, -3.349125841754124e-03,
  4.530938521188788e-05, -2.897854651594291e-07, -1.544746250109259e-09, -1.585520233854593e-10,  6.758572463315948e-12,  1.479384697532614e-13, -9.744873092858727e-15,
 -1.282683844628965e-16,  1.340151695417924e-17,  8.130474504275348e-20,  3.715613282206786e-01, -6.092856802823378e-03,  7.992053351736156e-05, -3.763332345292419e-07,
 -7.058463705018910e-09, -2.613878384379819e-10,  1.341636407492238e-11,  3.029837224067320e-13, -2.065528031882608e-14, -2.506409525623295e-16,  2.870955544803663e-17,
  1.403544156242179e-19,  6.043711977488123e-01, -9.829612992899379e-03,  1.216218711377318e-04, -1.620491703273494e-07, -2.400199005666548e-08, -3.537892787722182e-10,
  2.612869828255721e-11,  5.577734870313537e-13, -4.237335356366306e-14, -4.373791013086545e-16,  6.058996617723479e-17,  1.480132712150555e-19,  9.233466044986630e-01,
 -1.476755274737278e-02,  1.593454513958226e-04,  1.206790446134513e-06, -7.728398651476955e-08, -4.239885732250539e-10,  6.362343598463020e-11,  7.963029696217943e-13,
 -9.646727253250781e-14, -5.265260325623285e-16,  1.458130392173975e-16, -5.561398180006409e-19,  1.382949565656505e+00, -2.097695532901086e-02,  1.117713260779432e-04,
  9.056568567288468e-06, -3.050120636754090e-07, -3.266430406407726e-09,  4.461801071227442e-10, -4.912234533777379e-12, -4.933352795718371e-13,  1.591614379656249e-14,
  3.721830024849350e-16, -2.831927096963253e-17,  2.057528365359396e-02, -3.246417889753660e-04,  4.568279097587017e-06, -4.044256642083953e-08, -1.435609826018149e-10,
 -9.025873652131512e-13,  6.674475924322291e-13, -1.343652482979273e-14, -5.714157246698252e-16,  2.504151372813430e-17,  3.148112571743259e-19, -3.554109409909146e-20,
  8.316951691620876e-02, -1.311324418640991e-03,  1.835855547769978e-05, -1.567882901584281e-07, -8.228550932297893e-10,  2.083630321321568e-13,  2.752176304809089e-12,
 -5.668595356644107e-14, -2.398925066575092e-15,  1.067626475232683e-16,  1.287460023489268e-18, -1.513377073410480e-19,  1.906029817934974e-01, -3.001160035645340e-03,
  4.160984338504988e-05, -3.303008513066762e-07, -2.945160700010371e-09,  1.746785215766964e-11,  6.550440624496161e-12, -1.410268162717649e-13, -5.871474695087915e-15,
  2.694946170141558e-16,  2.989215416020696e-18, -3.811943483477545e-19,  3.484369479328287e-01, -5.473751351004441e-03,  7.461564502975757e-05, -5.120854982628487e-07,
 -8.772336112211066e-09,  8.704346171336855e-11,  1.279289191029592e-11, -2.979462923726250e-13, -1.182827098600770e-14,  5.755907334372574e-16,  5.419123998138795e-18,
 -8.112502095102058e-19,  5.669767516968443e-01, -8.871246313267493e-03,  1.172577446608626e-04, -5.660896969396306e-07, -2.433700946071376e-08,  3.088038912585069e-10,
  2.349687754751478e-11, -6.306996405028236e-13, -2.185643160062720e-14,  1.201036251102511e-15,  7.614533847428023e-18, -1.678397919473374e-18,  8.668878050347248e-01,
 -1.345597737718626e-02,  1.664024495260167e-04, -1.317860159072224e-08, -7.043050122745735e-08,  1.040537694210495e-09,  4.689542581588923e-11, -1.654820048652639e-12,
 -3.630578131116107e-14,  2.820748284628595e-15, -2.042524562295423e-18, -3.774007565944937e-18,  1.301399067290254e+00, -1.973255478396539e-02,  1.907087379530241e-04,
  4.164038359228036e-06, -2.811817289856820e-07,  4.582880847143854e-09,  1.811705773233017e-10, -1.086022654134769e-11,  8.786719616712924e-14,  1.105546323832325e-14,
 -4.125215056761363e-16, -2.753247620823777e-18,  1.934668460555810e-02, -2.900723132043483e-04,  4.070994973859443e-06, -4.216773418723610e-08, -3.895295686906608e-11,
  9.385728672118909e-12,  1.721434681878522e-13, -1.754127091768559e-14,  2.432425828835977e-16,  1.403165858326505e-17, -6.027340497358150e-19, -1.905730589734379e-21,
  7.820575020008899e-02, -1.172185147112467e-03,  1.640811618153812e-05, -1.669809212267661e-07, -3.161560600037916e-10,  4.215192328395244e-11,  6.713228287910447e-13,
 -7.334637792249427e-14,  1.044683070682115e-15,  5.858450201126726e-17, -2.566769219226112e-18, -6.582316604431609e-21,  1.792379607530573e-01, -2.684862576333810e-03,
  3.739836322707486e-05, -3.676943971414675e-07, -1.414630015442194e-09,  1.151154234896433e-10,  1.425421779941137e-12, -1.788742782521291e-13,  2.679901982184604e-15,
  1.419918748901130e-16, -6.464365177434378e-18, -9.287703350997611e-21,  3.276937968534053e-01, -4.903568027931319e-03,  6.773089892554457e-05, -6.251926024578799e-07,
 -4.776320649825274e-09,  2.702871886747552e-10,  2.210516176541356e-12, -3.621985170874878e-13,  5.915685133212461e-15,  2.816628186218770e-16, -1.374461017132254e-17,
  6.981704736984933e-21,  5.333163505820366e-01, -7.966341694600190e-03,  1.084126578862418e-04, -8.823526000846868e-07, -1.419359677146624e-08,  6.207125339506971e-10,
  2.252499175060762e-12, -6.978010495027455e-13,  1.321505217792974e-14,  5.076535958782730e-16, -2.837612247864763e-17,  1.133437930655956e-19,  8.157007714421709e-01,
 -1.214265233447227e-02,  1.603215958921194e-04, -9.294029293173240e-07, -4.242208356709387e-08,  1.565395923279705e-09, -2.042912082007588e-12, -1.452098514784053e-12,
  3.616144505337005e-14,  8.010620012274166e-16, -6.421952401554421e-17,  7.372273745264353e-19,  1.225739215577815e+00, -1.807546874949217e-02,  2.172130121261703e-04,
  5.405629292449359e-07, -1.678822981553697e-07,  5.855397538077648e-09, -4.579311981944858e-11, -4.708460835738843e-12,  2.164453253143299e-13, -2.151434374572760e-15,
 -1.708960249969952e-16,  8.137889713214946e-18,  1.824833129687820e-02, -2.595240241115209e-04,  3.567756009860882e-06, -4.121158167151689e-08,  1.562279080528814e-10,
  8.808671998318252e-12, -1.657605250608459e-13, -6.007739153740465e-15,  3.642241917606844e-16, -4.690470984836352e-18, -2.366244796721429e-19,  1.170120140818210e-20,
  7.376681533217630e-02, -1.048954662782124e-03,  1.440294651218070e-05, -1.650318376893125e-07,  5.469355420345137e-10,  3.866297362387406e-11, -7.314998333742664e-13,
 -2.451871774383723e-14,  1.529517876417695e-15, -2.030696718158534e-17, -9.796366663318691e-19,  4.957579328711080e-20,  1.690686328900160e-01, -2.403530317781163e-03,
  3.292808752837193e-05, -3.715363154811164e-07,  8.879460562974319e-10,  1.019313662540260e-10, -1.949022642849121e-12, -5.704847023077597e-14,  3.756584050205466e-15,
 -5.274503115574703e-17, -2.335667112183308e-18,  1.236214560365165e-19,  3.091144169723745e-01, -4.392614925956816e-03,  5.994948199765962e-05, -6.584643261160134e-07,
  4.756128394884091e-10,  2.288211158654131e-10, -4.457999912680330e-12, -1.060929796803040e-13,  7.677503975801020e-15, -1.181216492194142e-16, -4.495640634505342e-18,
  2.581627115343504e-19,  5.031143096987470e-01, -7.144320409942303e-03,  9.686526966900829e-05, -1.012838381779407e-06, -2.529373140887647e-09,  4.977661163664633e-10,
 -1.002719762056415e-11, -1.730872751940132e-13,  1.492339559104312e-14, -2.663518624178363e-16, -7.617090516373505e-18,  5.147765572405966e-19,  7.696114266966138e-01,
 -1.091392599951944e-02,  1.460890892180209e-04, -1.371644174503821e-06, -1.416653058982439e-08,  1.170354649437133e-09, -2.516955099244780e-11, -2.345810224162956e-13,
  3.090015892856503e-14, -7.147898826705913e-16, -9.847975544396271e-18,  1.071275420256681e-18,  1.156900402019714e+00, -1.634913897642142e-02,  2.111629249877934e-04,
 -1.300401295106929e-06, -6.882311920395399e-08,  3.853861994801993e-09, -9.812671436734876e-11,  2.611685703284567e-13,  8.676340468517687e-14, -3.593620874890866e-15,
  4.938135458686574e-17,  1.714893352177307e-18,  1.726426284998054e-02, -2.329058492180025e-04,  3.093223920532365e-06, -3.755465439158845e-08,  2.849737905407476e-10,
  3.930183161948388e-12, -2.040006528074696e-13,  1.995839125179601e-15,  1.284743790594291e-16, -6.233323220522220e-18,  9.038032105436880e-20,  2.707133729349847e-21,
  6.978918012871817e-02, -9.414520727444403e-04,  1.249707696693223e-05, -1.511931153660851e-07,  1.114070844257821e-09,  1.754920972559091e-11, -8.746275313334243e-13,
  8.863232474845243e-15,  5.289547200248639e-16, -2.618426557113462e-17,  3.900143576426465e-19,  1.103512998543844e-20,  1.599536464871004e-01, -2.157561211735945e-03,
  2.861298279641563e-05, -3.438872813610807e-07,  2.390604468549153e-09,  4.740803888066817e-11, -2.223033933461128e-12,  2.388382717112686e-14,  1.250761115199634e-15,
 -6.431260041698218e-17,  1.005983651733689e-18,  2.550169968885517e-20,  2.924536953738926e-01, -3.944189138015546e-03,  5.222407606649945e-05, -6.206254538695186e-07,
  3.865376341669626e-09,  1.092623740452308e-10, -4.763722281360080e-12,  5.561605430842448e-14,  2.389512418886655e-15, -1.312529120113602e-16,  2.221925143780765e-18,
  4.618173347346307e-20,  4.760098100987142e-01, -6.418035504005364e-03,  8.475212028577379e-05, -9.875445296299866e-07,  4.863612963402785e-09,  2.429100749678619e-10,
 -9.830670865929786e-12,  1.286125569155958e-13,  4.088797712127952e-15, -2.535191498586418e-16,  4.870692970432359e-18,  6.782817921427754e-20,  7.281855349178580e-01,
 -9.813343819202614e-03,  1.289335385523567e-04, -1.444411679596757e-06,  3.140721232532599e-09,  5.745978402593090e-10, -2.187510698549569e-11,  3.375487374386428e-13,
  6.241333893369757e-15, -5.122626921569272e-16,  1.225046045330232e-17,  3.918984602552763e-20,  1.094763906918367e+00, -1.473591777319265e-02,  1.910974987879972e-04,
 -1.906157865367982e-06, -1.353273706028834e-08,  1.796579524424023e-09, -6.820506379041938e-11,  1.420344530042762e-12,  3.708723198610909e-17, -1.247127325600836e-15,
  4.961293170797770e-17, -8.675131094880860e-19,  1.637939215662521e-02, -2.098808029221312e-04,  2.671724567274575e-06, -3.260728323707290e-08,  3.207675718607139e-10,
 -9.597197036932320e-15, -1.185726042483948e-13,  3.328149053522076e-15, -1.958850599219153e-17, -2.036221011600387e-18,  8.919884257662658e-20, -1.516434286478614e-21,
  6.621228866616774e-02, -8.484099108248583e-04,  1.079788984843134e-05, -1.315918096007771e-07,  1.281874669644404e-09,  6.994342012665968e-13, -5.067446308629761e-13,
  1.416944758838718e-14, -8.879891972430543e-17, -8.393407084050761e-18,  3.740354404347546e-19, -6.494163801103485e-21,  1.517560648740600e-01, -1.944459094524943e-03,
  2.473849604186856e-05, -3.006668164382193e-07,  2.874818676009333e-09,  4.772157395469565e-12, -1.280060977116690e-12,  3.561013875271476e-14, -2.471871843610637e-16,
 -1.988453946188795e-17,  9.153843481074720e-19, -1.651491384806572e-20,  2.774670126844203e-01, -3.555006362867815e-03,  4.520134987602858e-05, -5.468738634914622e-07,
  5.062006815149762e-09,  1.855898657535230e-11, -2.713313046484479e-12,  7.517228978410132e-14, -6.007203268947881e-16, -3.808098030467643e-17,  1.855287801162211e-18,
 -3.561944869211246e-20,  4.516209064366145e-01, -5.785805012664235e-03,  7.349106650634086e-05, -8.822841656227502e-07,  7.699874768789821e-09,  5.794107152195324e-11,
 -5.490704753205710e-12,  1.523711125013820e-13, -1.463598578485147e-15, -6.533233093180327e-17,  3.533397830358481e-18, -7.499290490989659e-20,  6.908874656952222e-01,
 -8.849647986898228e-03,  1.121982895913333e-04, -1.327315553284528e-06,  1.020466538889715e-08,  1.718503460695819e-10, -1.174626954355479e-11,  3.323176944313150e-13,
 -4.087836844042092e-15, -1.000422876516025e-16,  6.899399481582581e-18, -1.746884197906932e-19,  1.038730683833329e+00, -1.330009563183936e-02,  1.678581412394023e-04,
 -1.911056070295018e-06,  9.119411645282932e-09,  6.073475629233092e-10, -3.287863206984855e-11,  1.010384946049723e-12, -1.838653656881633e-14, -1.206956442849105e-17,
  1.460260889293841e-17, -5.728191906796027e-19,  1.558026045748184e-02, -1.899857765551899e-04,  2.310805719175791e-06, -2.760139890892284e-08,  2.990918319812249e-10,
 -1.854374339573857e-12, -4.105334555200231e-14,  2.082207535424670e-15, -4.517930108585253e-17,  1.861819129233664e-19,  2.566625892032206e-20, -1.075648328674310e-21,
  6.298190329382981e-02, -7.679971223764002e-04,  9.340517936210978e-06, -1.115042591490434e-07,  1.203866748982771e-09, -7.212814843504165e-12, -1.779512309771202e-13,
  8.807407700656896e-15, -1.917708633420022e-16,  8.643988463356925e-19,  1.056320056297397e-19, -4.497896012533182e-21,  1.443522955354672e-01, -1.760203178549648e-03,
  2.140509304363153e-05, -2.552587194261705e-07,  2.737189178242065e-09, -1.532279241066566e-11, -4.593245074973618e-13,  2.187386314259556e-14, -4.795855016644506e-16,
  2.492419281305209e-18,  2.494565411454276e-19, -1.094864083671276e-20,  2.639306025568849e-01, -3.218260069397756e-03,  3.912743896450849e-05, -4.657857175226099e-07,
  4.937499666944986e-09, -2.430562690043655e-11, -9.993316308246537e-13,  4.529557649722503e-14, -1.005625422065429e-15,  6.316450410025565e-18,  4.748551788170391e-19,
 -2.197954303663355e-20,  4.295895123601532e-01, -5.238083457310877e-03,  6.366158335220581e-05, -7.556396235670831e-07,  7.852977116378295e-09, -2.928577218323393e-11,
 -2.075421618543089e-12,  8.898003026105090e-14, -2.021260390318476e-15,  1.609265813235303e-17,  8.046855662527366e-19, -4.112846969486793e-20,  6.571873257723624e-01,
 -8.012820921603592e-03,  9.732189927514400e-05, -1.148990984905920e-06,  1.149155107683760e-08, -1.495561364719356e-11, -4.515148235061154e-12,  1.834485319677478e-13,
 -4.361434566621170e-15,  4.692890180480179e-17,  1.193795644525132e-18, -7.731141734606773e-20,  9.880752119402481e-01, -1.204579311641351e-02,  1.460863570328569e-04,
 -1.702394982297986e-06,  1.533298713539671e-08,  9.384598226084914e-11, -1.232622559861490e-11,  4.877482190438716e-13, -1.299559037792286e-14,  2.162800025614860e-16,
 -3.448601062629793e-20, -1.430705075507942e-19,  1.485530333973339e-02, -1.727459245038968e-04,  2.006951821556012e-06, -2.314914680816831e-08,  2.560752996112427e-10,
 -2.292099460666281e-12, -1.023866129746972e-15,  8.662173576267125e-16, -2.885819130215833e-17,  5.399212579413604e-19, -2.026130722206886e-21, -2.664456751874946e-22,
  6.005133514842050e-02, -6.983098350780663e-04,  8.112726229587857e-06, -9.355653178866131e-08,  1.033494781062017e-09, -9.168133953792939e-12, -8.652021524961206e-15,
  3.668672108249384e-15, -1.215314720016063e-16,  2.287652709899347e-18, -9.437663967209261e-21, -1.093287903865396e-21,  1.376355812351030e-01, -1.600496606880647e-03,
  1.859320258948380e-05, -2.143356840579856e-07,  2.361680054395039e-09, -2.059937442860112e-11, -3.906514851743162e-14,  9.124547683147011e-15, -2.996102742781985e-16,
  5.703666244663039e-18, -2.733880664103176e-20, -2.566745368826437e-21,  2.516500405233021e-01, -2.926298795572647e-03,  3.399277602172559e-05, -3.916083066461727e-07,
  4.296723196424548e-09, -3.640531186347202e-11, -1.303697518802739e-13,  1.889891897172730e-14, -6.138862614662054e-16,  1.190756645477319e-17, -6.962695615927244e-20,
 -4.833940029927627e-21,  4.096012744846887e-01, -4.762983879676273e-03,  5.532171469962261e-05, -6.366600337307976e-07,  6.936032618249962e-09, -5.582384124295462e-11,
 -3.749610380932496e-13,  3.697756982393314e-14, -1.188809027678528e-15,  2.378820380868233e-17, -1.780377115845862e-19, -8.021277625016902e-21,  6.266102130480535e-01,
 -7.286324983241631e-03,  8.461239053755590e-05, -9.719220086471469e-07,  1.045073742047060e-08, -7.569636706061917e-11, -1.043662798349536e-12,  7.501800835515454e-14,
 -2.403277438617207e-15,  5.085020947707834e-17, -5.182625200450258e-19, -1.126526647154487e-20,  9.421060079472777e-01, -1.095458849496098e-02,  1.271503057029801e-04,
 -1.454237174485742e-06,  1.514469677492606e-08, -7.813739318783240e-11, -3.374450326745003e-12,  1.877694786025755e-13, -6.181893179483704e-15,  1.481104335729801e-16,
 -2.325380753847778e-18,  4.075892532999721e-21,  1.419476530607510e-02, -1.577352750735891e-04,  1.752246674961214e-06, -1.941342304117266e-08,  2.114856442026917e-10,
 -2.112993841708731e-12,  1.301811679878979e-14,  2.228518717431342e-16, -1.257863099927547e-17,  3.414037377290678e-19, -5.818607492392686e-21,  2.502678438864586e-23,
  5.738116770511689e-02, -6.376314924975622e-04,  7.083254277041353e-06, -7.847084488365334e-08,  8.544127201784073e-10, -8.510790151997535e-12,  5.110183188367713e-14,
  9.623238786495442e-16, -5.288021857188608e-17,  1.434241208200722e-18, -2.461575119022354e-20,  1.142745791821675e-22,  1.315156621652455e-01, -1.461428003812222e-03,
  1.623433058334234e-05, -1.798259474164124e-07,  1.956176662007381e-09, -1.937628756527804e-11,  1.106684518901516e-13,  2.467292898085537e-15, -1.299004821049500e-16,
  3.520935004456012e-18, -6.120887342649891e-20,  3.216223451638371e-22,  2.404605440360459e-01, -2.672040770063777e-03,  2.968178961137297e-05, -3.287107846464055e-07,
  3.570304946587813e-09, -3.503445978682302e-11,  1.827461316351455e-13,  5.311525086060916e-15, -2.643771289441855e-16,  7.169251510392582e-18, -1.272632784627976e-19,
  7.919181317808831e-22,  3.913886495988866e-01, -4.349169804680849e-03,  4.831002249025540e-05, -5.348200362724328e-07,  5.794353344547132e-09, -5.596679439733279e-11,
  2.441590709924475e-13,  1.084821760006297e-14, -5.054350985557047e-16,  1.376019409189094e-17, -2.526574721314327e-19,  1.952099646433598e-21,  5.987486991908525e-01,
 -6.653356433902013e-03,  7.389984838542587e-05, -8.176046092583052e-07,  8.818166820144950e-09, -8.269460784121357e-11,  2.236930261854137e-13,  2.291782645831467e-14,
 -9.946210034182755e-16,  2.744703555306943e-17, -5.343525487112434e-19,  5.449874660052408e-21,  9.002171689091500e-01, -1.000320999164045e-02,  1.110915675557554e-04,
 -1.227381936069405e-06,  1.310105406167012e-08, -1.140796338556815e-10, -2.071247641089560e-13,  5.837100662240979e-14, -2.379389788463526e-15,  6.877270203507350e-17,
 -1.515443061941727e-18,  2.290611441212110e-20,  1.359046185683053e-02, -1.445947156777607e-04,  1.538252746529852e-06, -1.634932261005389e-08,  1.726630686101203e-10,
 -1.761334340522076e-12,  1.516959283240859e-14, -2.443132741216605e-17, -4.020498436004760e-18,  1.495273704775925e-19, -3.564087881111692e-21,  5.717138196044190e-23,
  5.493832164465268e-02, -5.845121286048621e-04,  6.218244446541385e-06, -6.608906287716228e-08,  6.978345016487869e-10, -7.110952528195657e-12,  6.084903816628246e-14,
 -7.843908110757595e-17, -1.698255671449728e-17,  6.263596623204697e-19, -1.494774049208349e-20,  2.414846966040375e-22,  1.259167462970089e-01, -1.339681351928379e-03,
  1.425193807554980e-05, -1.514666361141950e-07,  1.598818016180147e-09, -1.625978994240204e-11,  1.374689438689452e-13, -9.372734273404881e-17, -4.202785629997489e-17,
  1.529274064914396e-18, -3.658792039733248e-20,  5.987839907461432e-22,  2.302236105424546e-01, -2.449444961252992e-03,  2.605776140690434e-05, -2.769170259006361e-07,
  2.921471551742405e-09, -2.961436803720604e-11,  2.453360280737918e-13,  8.938740685937627e-17, -8.631854751916691e-17,  3.084731059062942e-18, -7.416595542254567e-20,
  1.239443856052983e-21,  3.747264003848975e-01, -3.986867525843338e-03,  4.241274773088527e-05, -4.506710778754541e-07,  4.750477713649098e-09, -4.789677618379539e-11,
  3.831920818576042e-13,  8.522529836000979e-16, -1.664848902808998e-16,  5.824626076695824e-18, -1.413952153215984e-19,  2.443427320921456e-21,  5.732587569730901e-01,
 -6.099127070514748e-03,  6.488196667986474e-05, -6.892895679605670e-07,  7.254728120620654e-09, -7.244422833079189e-11,  5.418456569353866e-13,  3.279173898936310e-15,
 -3.287857896019878e-16,  1.126168219952635e-17, -2.789875906433969e-19,  5.104173358146024e-21,  8.618933156964305e-01, -9.170001232807066e-03,  9.754572013460459e-05,
 -1.035861440139752e-06,  1.086600676093339e-08, -1.061256518682213e-10,  6.609540302416175e-13,  1.199983802128968e-14, -7.703055523043124e-16,  2.614886034594572e-17,
 -6.829240492900516e-19,  1.405067034720374e-20,  1.303551542189526e-02, -1.330290475702569e-04,  1.357536981622003e-06, -1.384918503540220e-08,  1.409644375780389e-10,
 -1.415905343899739e-12,  1.332423120263254e-14, -8.990266159343422e-17, -6.521002093683492e-19,  5.102911279366135e-20, -1.539496736086559e-21,  3.342057280415030e-23,
  5.269499663117284e-02, -5.377589375815738e-04,  5.487727409869360e-06, -5.598373744005827e-08,  5.697989197268383e-10, -5.721142882288393e-12,  5.372477290250789e-14,
 -3.572277266057749e-16, -2.872477787763204e-18,  2.139581324708099e-19, -6.435007333269697e-21,  1.399798462807581e-22,  1.207751232464375e-01, -1.232524931148727e-03,
  1.257766639925140e-05, -1.283109192157256e-07,  1.305799769029520e-09, -1.310202383186100e-11,  1.225581332764313e-13, -7.926353484061446e-16, -7.583546470322582e-18,
  5.229908989476390e-19, -1.565286072200379e-20,  3.418239492520107e-22,  2.208227742847937e-01, -2.253523196908235e-03,  2.299670048855652e-05, -2.345954933375760e-07,
  2.387023374687227e-09, -2.392377447887509e-11,  2.223557431499472e-13, -1.370705967750136e-15, -1.688959524037590e-17,  1.055532805659662e-18, -3.139788631005028e-20,
  6.903339582359762e-22,  3.594250155366425e-01, -3.667975178644431e-03,  3.743074819977317e-05, -3.818278164764579e-07,  3.884025737244015e-09, -3.885623877728880e-11,
  3.573342806886232e-13, -2.020867673554734e-15, -3.565960509171148e-17,  1.989394295010814e-18, -5.880896578814656e-20,  1.308535689929135e-21,  5.498506206733493e-01,
 -5.611289392307626e-03,  5.726146423382605e-05, -5.840844776390581e-07,  5.938521071766213e-09, -5.921940120605064e-11,  5.342731826489145e-13, -2.516653055865830e-15,
 -7.724847773063168e-17,  3.811831204209330e-18, -1.123245727534259e-19,  2.556779650406237e-21,  8.266992842311155e-01, -8.436556581137081e-03,  8.609148093336158e-05,
 -8.780499212278135e-07,  8.918034909525996e-09, -8.830804605501068e-11,  7.619720009795685e-13, -1.815260547930095e-15, -1.962933964974649e-16,  8.549379634998915e-18,
 -2.549276164166103e-19,  6.123140895203460e-21,  1.252411871501261e-02, -1.227972139224690e-04,  1.203998730557706e-06, -1.180380430787353e-08,  1.156339232759710e-10,
 -1.127352943269539e-12,  1.072090194719426e-14, -9.079043240052460e-17,  3.702372067067879e-19,  1.235253711276703e-20, -5.352468656609044e-22,  1.409649858069341e-23,
  5.062771764515038e-02, -4.963976107481913e-04,  4.867064661775282e-06, -4.771579230337885e-08,  4.674307346118681e-10, -4.556556433404388e-12,  4.330060428456181e-14,
 -3.652417771680927e-16,  1.425867008643246e-18,  5.236872425313924e-20, -2.236033118790446e-21,  5.883453653331698e-23,  1.160369909856750e-01, -1.137726262111663e-03,
  1.115514110124093e-05, -1.093624845401852e-07,  1.071294030977319e-09, -1.044065021268948e-11,  9.908535136197443e-14, -8.296854380018430e-16,  2.969987910069231e-18,
  1.303124391982960e-19, -5.431757218425443e-21,  1.427368252247440e-22,  2.121596704114534e-01, -2.080195454577844e-03,  2.039582088186891e-05, -1.999547441120343e-07,
  1.958610568797770e-09, -1.908111215579590e-11,  1.806952075733002e-13, -1.494768374087443e-15,  4.535754193679215e-18,  2.693018351655345e-19, -1.086373221179370e-20,
  2.851622445077168e-22,  3.453244051659317e-01, -3.385856609807605e-03,  3.319748854981549e-05, -3.254552894044778e-07,  3.187641217010640e-09, -3.103575521455773e-11,
  2.928734857969687e-13, -2.374166993240342e-15,  4.996030892628422e-18,  5.219030289391883e-19, -2.022045549280991e-20,  5.309030390389991e-22,  5.282794233660579e-01,
 -5.179704077299205e-03,  5.078564593283716e-05, -4.978741781326546e-07,  4.875648050834748e-09, -4.742116902943196e-11,  4.447522728222515e-13, -3.474041811737443e-15,
  1.150245917729101e-18,  1.029199333429769e-18, -3.807164996864613e-20,  1.004344654882081e-21,  7.942670453416473e-01, -7.787673324062822e-03,  7.635587725927341e-05,
 -7.485240465330772e-07,  7.327949592154730e-09, -7.111504368601733e-11,  6.580548551414392e-13, -4.701509490018784e-15, -2.024757958227902e-17,  2.351791069582126e-18,
 -8.302463780559271e-20,  2.236156907724072e-21,  1.205133900341018e-02, -1.137019811855111e-04,  1.072752872945565e-06, -1.012089416609097e-08,  9.546217782094288e-11,
 -8.989288968093715e-13,  8.388003630379110e-15, -7.495708532355568e-17,  5.477836540654288e-19,  4.170088949403409e-23, -1.467188182292908e-22,  4.893285379601547e-24,
  4.871654464017004e-02, -4.596308862724269e-04,  4.336514839934080e-06, -4.091285280053421e-08,  3.858955285901100e-10, -3.633673728985956e-12,  3.389790378131477e-14,
 -3.025279105563634e-16,  2.194460036227274e-18,  8.844480048374763e-22, -6.155637372324479e-22,  2.039714277140930e-23,  1.116566481106076e-01, -1.053458209196225e-03,
  9.939142199978752e-06, -9.377073923958337e-08,  8.844490825087421e-10, -8.327537595324831e-12,  7.765145350090991e-14, -6.913753424585369e-16,  4.946114308630191e-18,
  5.038067221618169e-21, -1.505641515893151e-21,  4.936071286851420e-23,  2.041507408786488e-01, -1.926121514736188e-03,  1.817252231716677e-05, -1.714481719732740e-07,
  1.617078616086385e-09, -1.522378250758664e-11,  1.418538853276148e-13, -1.258132437628776e-15,  8.794356871395044e-18,  1.823100560473093e-20, -3.038377469329320e-21,
  9.816612319730646e-23,  3.322885687911093e-01, -3.135076320279006e-03,  2.957873154828283e-05, -2.790589453218225e-07,  2.631981042004873e-09, -2.477368872531470e-11,
  2.305708742860796e-13, -2.032169023048611e-15,  1.365676907741531e-17,  5.366439348210648e-20, -5.711434259607844e-21,  1.812438909862240e-22,  5.083371207190954e-01,
 -4.796059168996779e-03,  4.524970926068076e-05, -4.269038872111655e-07,  4.026220617930496e-09, -3.788466180061372e-11,  3.518918008799616e-13, -3.067443392698411e-15,
  1.913480270470561e-17,  1.470094851958987e-19, -1.084000515411826e-20,  3.372167827202742e-22,  7.642838364209377e-01, -7.210865002436455e-03,  6.803279188554305e-05,
 -6.418424221081890e-07,  6.052802317563848e-09, -5.691525697467949e-11,  5.264341114267741e-13, -4.479314861358805e-15,  2.302372466955345e-17,  4.382808724871782e-19,
 -2.353281525603253e-20,  7.203236934269173e-22,  1.161296087806967e-02, -1.055810941172991e-04,  9.599067852557187e-07, -8.727068250511550e-09,  7.933684237084868e-11,
 -7.208518815346242e-13,  6.528782817547480e-15, -5.819909832414185e-17,  4.831833947475107e-19, -2.818455356932107e-21, -2.128379523725575e-23,  1.408537016389427e-24,
  4.694443720271808e-02, -4.268028706264508e-04,  3.880344009497711e-06, -3.527844756787879e-08,  3.207120542309255e-10, -2.913941914440495e-12,  2.638956778510683e-14,
 -2.351407386654336e-16,  1.947910406042846e-18, -1.119519148256441e-20, -9.252609999161349e-23,  5.881364718862865e-24,  1.075950387033077e-01, -9.782175282967958e-04,
  8.893615054328778e-06, -8.085696376712300e-08,  7.350585623560113e-10, -6.678478568396667e-12,  6.047357875172654e-14, -5.384158537395517e-16,  4.442309192762617e-18,
 -2.482857164802110e-20, -2.393253014209999e-22,  1.426994636660816e-23,  1.967245770095700e-01, -1.788552998568217e-03,  1.626090394879540e-05, -1.478371461713742e-07,
  1.343958901943562e-09, -1.221027637857072e-11,  1.105380106750653e-13, -9.828960696195103e-16,  8.056300909579583e-18, -4.292419772597594e-20, -5.190788237804106e-22,
  2.846542525401441e-23,  3.202012781170517e-01, -2.911161193435755e-03,  2.646726698297602e-05, -2.406288221754954e-07,  2.187493439582332e-09, -1.987287797879245e-11,
  1.798392472538578e-13, -1.595835500142740e-15,  1.294044208368064e-17, -6.335818173784415e-20, -1.060994829662254e-21,  5.268103864746990e-23,  4.898459084285064e-01,
 -4.453512492730383e-03,  4.048978560079463e-05, -3.681149553343698e-07,  3.346393887431444e-09, -3.039822217627505e-11,  2.749137660578325e-13, -2.430912857405382e-15,
  1.934216991228442e-17, -7.961451943471276e-20, -2.204746538105341e-21,  9.791511408535065e-23,  7.364823366429701e-01, -6.695846997767902e-03,  6.087629881943482e-05,
 -5.534585678369114e-07,  5.031154991909207e-09, -4.569325679161550e-11,  4.127004662855265e-13, -3.622383221122332e-15,  2.763866437653591e-17, -6.366100647652494e-20,
 -5.240082433050214e-21,  2.060781369340462e-22,  1.120536084020599e-02, -9.830020250051194e-05,  8.623486775511804e-07, -7.565025400456119e-09,  6.636333564303939e-11,
 -5.820659632892257e-13,  5.099810576844503e-15, -4.443176623123123e-17,  3.772050641667489e-19, -2.861198331254952e-21,  1.113134645675913e-23,  2.852337529821327e-25,
  4.529674764490949e-02, -3.973704665903841e-04,  3.485973441584115e-06, -3.058099016237946e-08,  2.682681760771749e-10, -2.352943570312905e-12,  2.061495556132211e-14,
 -1.795807762268439e-16,  1.523460283958038e-18, -1.151395980697960e-20,  4.322932009273825e-23,  1.206223044385114e-24,  1.038185907962586e-01, -9.107594694613911e-04,
  7.989731422077281e-06, -7.009057353480406e-08,  6.148608774001631e-10, -5.392823957566774e-12,  4.724624347189549e-14, -4.114640908042136e-16,  3.486049513976388e-18,
 -2.617159036545773e-20,  9.167839983933500e-23,  2.987838578301184e-24,  1.898197965916674e-01, -1.665214060708476e-03,  1.460826203209544e-05, -1.281521587387842e-07,
  1.124197427947032e-09, -9.860006748248743e-12,  8.637665617862800e-14, -7.519334507363303e-16,  6.357095709446274e-18, -4.720622769610751e-20,  1.456288960738258e-22,
  6.129040706678844e-24,  3.089626238280148e-01, -2.710406998104130e-03,  2.377732448102629e-05, -2.085884568497397e-07,  1.829810069418916e-09, -1.604845187011391e-11,
  1.405730023275982e-13, -1.222914672934223e-15,  1.030378879826137e-17, -7.515156342757999e-20,  1.792914520384626e-22,  1.173688456111560e-23,  4.726529451875252e-01,
 -4.146397492787234e-03,  3.637469807193458e-05, -3.190998035801709e-07,  2.799244015421046e-09, -2.455022150375484e-11,  2.150006236621924e-13, -1.868296705881108e-15,
  1.564995783892096e-17, -1.105520169225957e-19,  1.214165080758314e-22,  2.266926238287689e-23,  7.106327511802110e-01, -6.234100265697795e-03,  5.468928260272739e-05,
 -4.797655730235843e-07,  4.208625852732582e-09, -3.690882532964471e-11,  3.231058356385961e-13, -2.801268871842368e-15,  2.318016462360018e-17, -1.523159003977478e-19,
 -3.075691888506431e-22,  4.952019840789819e-23,  1.082540703615344e-02, -9.174732701118793e-05,  7.775755317538203e-07, -6.590092067199867e-09,  5.585185769545231e-11,
 -4.733272582543298e-13,  4.009938742402814e-15, -3.390676344642150e-17,  2.840699302697992e-19, -2.286374497820184e-21,  1.545576398359681e-23, -1.865623011752599e-26,
  4.376081570815506e-02, -3.708810075677497e-04,  3.143284996248348e-06, -2.663990368489333e-08,  2.257764998072334e-10, -1.913384085581321e-12,  1.620970324820294e-14,
 -1.370578357048426e-16,  1.147994312982817e-18, -9.229299976875264e-21,  6.201934092436409e-23, -6.114288568489387e-26,  1.002982875184870e-01, -8.500465388422469e-04,
  7.204301307395942e-06, -6.105774343857398e-08,  5.174718572310202e-10, -4.385400945750982e-12,  3.715148822812657e-14, -3.141008877061402e-16,  2.629771024017232e-18,
 -2.109834818542174e-20,  1.402296673035251e-22, -8.045049569139506e-26,  1.833833457900395e-01, -1.554207775726133e-03,  1.317219772420096e-05, -1.116367302835270e-07,
  9.461346227519526e-10, -8.018149468918777e-12,  6.792528482457232e-14, -5.742049448219508e-16,  4.804129371592927e-18, -3.841408271713591e-20,  2.507285985018143e-22,
  2.995794101829275e-26,  2.984862522233757e-01, -2.529726197744851e-03,  2.143989630223867e-05, -1.817069440364294e-07,  1.539987175366699e-09, -1.305077162998661e-11,
  1.105550121640158e-13, -9.343791641918926e-16,  7.808958761006673e-18, -6.210640245716858e-20,  3.933568444437603e-22,  5.122954532610603e-25,  4.566261267030645e-01,
 -3.869990883592688e-03,  3.279888662215122e-05, -2.779763884753304e-07,  2.355879546573429e-09, -1.996496991464037e-11,  1.691164654141757e-13, -1.428824810578248e-15,
  1.191910397685501e-17, -9.392675638830271e-20,  5.632725665763221e-22,  2.005047053623044e-24,  6.865364618963321e-01, -5.818523496711574e-03,  4.931305940426413e-05,
 -4.179368665221989e-07,  3.542053127441596e-09, -3.001675945206353e-11,  2.542328699537236e-13, -2.146456038216708e-15,  1.783822877136139e-17, -1.378870001226652e-19,
  7.267470443612784e-22,  6.893954374033259e-24,  1.047037862911076e-02, -8.582854248709065e-05,  7.035599077397463e-07, -5.767270989867145e-09,  4.727579856045946e-11,
 -3.875260656525876e-13,  3.176271443924591e-15, -2.601749163448585e-17,  2.124406034620906e-19, -1.710017123404763e-21,  1.296893955007113e-23, -7.518244282133118e-26,
  4.232564263433532e-02, -3.469548089696229e-04,  2.844082938692815e-06, -2.331371756093546e-08,  1.911085121527335e-10, -1.566541650612391e-12,  1.283978254003453e-14,
 -1.051718216495036e-16,  8.586938033193159e-19, -6.909394091054526e-21,  5.231132168987746e-23, -3.002615188175538e-25,  9.700892009555599e-02, -7.952085129658912e-04,
  6.518540470285099e-06, -5.343424010324468e-08,  4.380141210594197e-10, -3.590457503742782e-12,  2.942820444462796e-14, -2.410429829125115e-16,  1.967765651815122e-18,
 -1.582276369359940e-20,  1.194191331476392e-22, -6.729428048807361e-25,  1.773691333997988e-01, -1.453943046417584e-03,  1.191836660413244e-05, -9.769807524598956e-08,
  8.008560122752564e-10, -6.564713001500105e-12,  5.380553226128614e-14, -4.406969996503859e-16,  3.596854013358358e-18, -2.889091662011599e-20,  2.169414561888701e-22,
 -1.185404637540821e-24,  2.886971423751623e-01, -2.366529026867671e-03,  1.939908208001798e-05, -1.590195216172190e-07,  1.303523335912377e-09, -1.068512309941111e-11,
  8.757625353026897e-14, -7.172523202173343e-16,  5.851984315153425e-18, -4.692409815351347e-20,  3.494852254513748e-22, -1.812626300511136e-24,  4.416506855231309e-01,
 -3.620330836542198e-03,  2.967683648055109e-05, -2.432690485179357e-07,  1.994137583881241e-09, -1.634612750384599e-11,  1.339721575903524e-13, -1.097121066663636e-15,
  8.946091976375135e-18, -7.152732583426747e-20,  5.253048540422987e-22, -2.469353416587450e-24,  6.640209162477673e-01, -5.443160121168046e-03,  4.461906376056886e-05,
 -3.657545088001005e-07,  2.998180324674999e-09, -2.457625334372945e-11,  2.014194676524344e-13, -1.649119110243879e-15,  1.343166023516959e-17, -1.067661459629759e-19,
  7.613040161525779e-22, -2.772765636291662e-24,  1.013790051485719e-02, -8.046459652171235e-05,  6.386481368719979e-07, -5.068955086029529e-09,  4.023231594982465e-11,
 -3.193227069457314e-13,  2.534376495111476e-15, -2.011075899252421e-17,  1.594161498881983e-19, -1.257436218435949e-21,  9.711320504796265e-24, -6.885127856966711e-26,
  4.098162726048429e-02, -3.252714995061336e-04,  2.581682455481915e-06, -2.049083313348478e-08,  1.626358197270807e-10, -1.290835607118024e-12,  1.024500070767362e-14,
 -8.129568883078244e-17,  6.444081685265126e-19, -5.082325399275759e-21,  3.922963347087381e-23, -2.774245898734647e-25,  9.392848299187412e-02, -7.455111119624863e-04,
  5.917127571529600e-06, -4.696428613094531e-08,  3.727557100479152e-10, -2.958550421405391e-12,  2.348115945981625e-14, -1.863252880854212e-16,  1.476884932267212e-18,
 -1.164537873569002e-20,  8.979850716332733e-23, -6.321017983412666e-25,  1.717369249489987e-01, -1.363077330804043e-03,  1.081875551651993e-05, -8.586854389433624e-08,
  6.815389288370505e-10, -5.409351926149775e-12,  4.293238507936150e-14, -3.406685897963529e-16,  2.700083398085777e-18, -2.128300818951646e-20,  1.638504549023449e-22,
 -1.144719165849929e-24,  2.795298061323451e-01, -2.218630280779513e-03,  1.760928601923470e-05, -1.397650351135089e-07,  1.109315523226624e-09, -8.804597438463342e-12,
  6.987922249448762e-14, -5.544814820100953e-16,  4.394257517683268e-18, -3.461813190890202e-20,  2.658327467265059e-22, -1.834856320329299e-24,  4.276264374733759e-01,
 -3.394074414297736e-03,  2.693879535963678e-05, -2.138134195696592e-07,  1.697037679221748e-09, -1.346931921215254e-11,  1.069011105583980e-13, -8.482188609524030e-16,
  6.720931597804500e-18, -5.289964942104859e-20,  4.044775775673435e-22, -2.734130938747200e-24,  6.429354875495866e-01, -5.102984046483832e-03,  4.050242454618378e-05,
 -3.214680424303914e-07,  2.551492411778095e-09, -2.025106935876635e-11,  1.607239987225948e-13, -1.275207366950988e-15,  1.010072089399473e-17, -7.935896404478111e-20,
  6.015676759913902e-22, -3.890177122710269e-24  };
  constexpr double w[2688] = {  1.422219632149992e-02, -8.809313586612736e-04,  3.878106677147227e-05, -1.458883805114201e-06,  4.960436534672944e-08,
 -1.564718131778548e-09,  4.648719853727578e-11, -1.313767031287693e-12,  3.556365200098930e-14, -9.268548589257909e-16,  2.334575680460601e-17, -5.697172391463011e-19,
  4.716643790513612e-02, -4.965603049131822e-03,  3.512904084562386e-04, -1.996170605594829e-05,  9.765615421255696e-07, -4.265839610390732e-08,  1.700958189374576e-09,
 -6.282238451528747e-11,  2.171418115710504e-12, -7.077577005225311e-14,  2.188068008421802e-15, -6.440525834600635e-17,  7.858251613261233e-02, -1.340901823422675e-02,
  1.388703521929034e-03, -1.088528010528674e-04,  7.046819929010080e-06, -3.944202494044594e-07,  1.962685848820378e-08, -8.846160087274265e-10,  3.659473382814258e-11,
 -1.403192155918629e-12,  5.025071179676638e-14, -1.689215907951049e-15,  9.325091740062423e-02, -2.304429511888086e-02,  3.220567580991172e-03, -3.255509886186133e-04,
  2.627766959372828e-05, -1.785470405358956e-06,  1.054982672500000e-07, -5.541044118367209e-09,  2.627979558223174e-10, -1.138830420245708e-11,  4.550707467936679e-13,
 -1.687194573895237e-14,  8.714530027265277e-02, -2.796834301067479e-02,  4.893051589223589e-03, -6.000153082762502e-04,  5.728284447888351e-05, -4.508573392825388e-06,
  3.032326590367372e-07, -1.785903353338507e-08,  9.375104645477695e-10, -4.445772626046244e-11,  1.924508733491790e-12, -7.659445992548465e-14,  6.380676539368564e-02,
 -2.420642586161962e-02,  4.933026627618775e-03, -6.913037506019054e-04,  7.415504357291802e-05, -6.463276956999780e-06,  4.754150923952563e-07, -3.029446705538659e-08,
  1.704606265163392e-09, -8.593677072892957e-11,  3.926478672436840e-12, -1.638768928096296e-13,  2.939122504960850e-02, -1.216935382604415e-02,  2.696047013342048e-03,
 -4.068916696728440e-04,  4.657943900753690e-05, -4.297730807649228e-06,  3.322989425716753e-07, -2.212193265280235e-08,  1.293491858131309e-09, -6.744760008711267e-11,
  3.174356893058448e-12, -1.359690651292340e-13,  1.122443534342472e-02, -6.292552905772607e-04,  2.517077395774589e-05, -8.654829619186830e-07,  2.704117741756270e-08,
 -7.872735465117720e-10,  2.166640962304873e-11, -5.689808217250072e-13,  1.435184426841039e-14, -3.494060600160555e-16,  8.240361135002224e-18, -1.887135055873871e-19,
  3.171220535076172e-02, -2.900731869803323e-03,  1.831804724518565e-04, -9.425968741603092e-06,  4.215585825371990e-07, -1.695581412064077e-08,  6.262008178287183e-10,
 -2.152838405384581e-11,  6.956978995633944e-13, -2.128368611452575e-14,  6.198122635552551e-16, -1.724334862491910e-17,  4.097640977065048e-02, -6.074697533353679e-03,
  5.631962098181470e-04, -4.014377821737928e-05,  2.389309525356029e-06, -1.239992767960444e-07,  5.760883131267053e-09, -2.438390415394375e-10,  9.520746352186759e-12,
 -3.461068009806742e-13,  1.179803493422702e-14, -3.789035792833072e-16,  3.524657629470096e-02, -7.785001277882405e-03,  9.923013492823707e-04, -9.272084630691354e-05,
  6.987822621456225e-06, -4.468213578029828e-07,  2.500715581267265e-08, -1.250882678273848e-09,  5.676593367026632e-11, -2.363415418574230e-12,  9.106258999797396e-14,
 -3.266074216979371e-15,  2.336085329578804e-02, -6.976937368115933e-03,  1.146668793267419e-03, -1.332501547157996e-04,  1.214069331392444e-05, -9.172167442328791e-07,
  5.949743429290100e-08, -3.393285197796502e-09,  1.730911739070433e-10, -7.999719333330612e-12,  3.383777855068352e-13, -1.318987125091254e-14,  1.263907856365259e-02,
 -4.633406403151224e-03,  9.148951782938160e-04, -1.247176462322370e-04,  1.305947513310099e-05, -1.114438755698749e-06,  8.046106268139578e-08, -5.043256068256184e-09,
  2.796386889246706e-10, -1.391417669936519e-11,  6.283119047248146e-13, -2.594811699100528e-14,  4.786591917354764e-03, -1.961950639240561e-03,  4.303599961997989e-04,
 -6.436704670540514e-05,  7.308998569009232e-06, -6.694805755657798e-07,  5.142490960032968e-08, -3.403165279669575e-09,  1.979125842107086e-10, -1.026905338988196e-11,
  4.811196414984232e-13, -2.052264136452146e-14,  9.053378387714087e-03, -4.631137356593209e-04,  1.694001198636060e-05, -5.351472364438812e-07,  1.543123756846911e-08,
 -4.162546192839738e-10,  1.064795329865473e-11, -2.606405093733896e-13,  6.142531177447879e-15, -1.400409398356076e-16,  3.098911068086576e-18, -6.671586234745250e-20,
  2.245732007659815e-02, -1.794399076818563e-03,  1.015247870419536e-04, -4.744724086965574e-06,  1.944235221654983e-07, -7.212483957599538e-09,  2.469948214532398e-10,
 -7.910030506544441e-12,  2.390664658699572e-13, -6.864912166023456e-15,  1.882605445735786e-16, -4.947360075063185e-18,  2.335675076987251e-02, -2.995248384782776e-03,
  2.482197761634763e-04, -1.606534296791598e-05,  8.776749326283327e-07, -4.215627322215513e-08,  1.824861793000654e-09, -7.237732689789438e-11,  2.661108929956593e-12,
 -9.149172640221512e-14,  2.961124782545632e-15, -9.061975154410459e-17,  1.493377804380949e-02, -2.910804437513063e-03,  3.357758083716680e-04, -2.881892648046984e-05,
  2.016574154396463e-06, -1.207305748464114e-07,  6.369772707760164e-09, -3.020959495455670e-10,  1.306251064901867e-11, -5.204276118249229e-13,  1.926176698642908e-14,
 -6.659227821833239e-16,  6.979365749839939e-03, -1.911621152994051e-03,  2.920342315325028e-04, -3.188541676441289e-05,  2.752572457634874e-06, -1.983609157740946e-07,
  1.234158498542009e-08, -6.782592139512834e-10,  3.347109583284195e-11, -1.501657995481187e-12,  6.184293660235028e-14, -2.353288870090186e-15,  2.683518051358530e-03,
 -9.416476563291620e-04,  1.787615826334881e-04, -2.355387775022890e-05,  2.394825400971542e-06, -1.991885828639162e-07,  1.406133520089880e-08, -8.640492325669311e-10,
  4.707503544127105e-11, -2.305974514406850e-12,  1.026827614226288e-13, -4.187851944941802e-15,  7.985344098565782e-04, -3.231229301776526e-04,  7.000317562245817e-05,
 -1.035419665377603e-05,  1.164172148570236e-06, -1.057001326504581e-07,  8.055529310755679e-09, -5.293383597514887e-10,  3.058804197733638e-11, -1.577953834855709e-12,
  7.354048714999761e-14, -3.121886075946456e-15,  7.436484198059708e-03, -3.496367883362193e-04,  1.176395990076567e-05, -3.430971903450287e-07,  9.168258374889355e-09,
 -2.299936716607176e-10,  5.486279838119802e-12, -1.255642053217765e-13,  2.772130039214944e-15, -5.932553993546623e-17,  1.235154090082135e-18, -2.502429362206232e-20,
  1.660597109517149e-02, -1.166254268030035e-03,  5.936201623017513e-05, -2.528101303669665e-06,  9.517146743456828e-08, -3.263190536939736e-09,  1.037929728270992e-10,
 -3.100181538333997e-12,  8.770737085422198e-14, -2.365248522448578e-15,  6.109714974037208e-17, -1.516606157230435e-18,  1.439486015973864e-02, -1.593348557193885e-03,
  1.180402590112117e-04, -6.936088041785448e-06,  3.476362092824489e-07, -1.544075211940321e-08,  6.220756208301152e-10, -2.308739339771813e-11,  7.980616159364800e-13,
 -2.590394826672594e-14,  7.944742260182168e-16, -2.312069586540583e-17,  7.059085431872929e-03, -1.200407561206410e-03,  1.245547300643167e-04, -9.769478624008053e-06,
  6.318116643731331e-07, -3.526425442655515e-08,  1.746774996691571e-09, -7.823734547413430e-11,  3.211101683237947e-12, -1.219756971734678e-13,  4.321200520554637e-15,
 -1.435124192629046e-16,  2.342646208804432e-03, -5.791124681159185e-04,  8.134760672937340e-05, -8.272824586333594e-06,  6.716917333350190e-07, -4.587542328337140e-08,
  2.722063158825245e-09, -1.434142345487058e-10,  6.814985761993844e-12, -2.955490004434353e-13,  1.180495039069623e-14, -4.369839899826416e-16,  6.193376536332184e-04,
 -2.055095170776585e-04,  3.715361675520047e-05, -4.695517250304467e-06,  4.606201468631227e-07, -3.714157390985378e-08,  2.551882828751274e-09, -1.531222601119502e-10,
  8.168835222801121e-12, -3.927524545116545e-13,  1.720034136888497e-14, -6.911638778023191e-16,  1.373132136415863e-04, -5.464282013814338e-05,  1.165294969333052e-05,
 -1.699781152375558e-06,  1.887962262142632e-07, -1.695835389694699e-08,  1.280170609343452e-09, -8.341105924814473e-11,  4.783454420521362e-12, -2.450821932975701e-13,
  1.135151335482536e-14, -4.791866379888042e-16,  6.203196813670883e-03, -2.698083994299698e-04,  8.395443487528653e-06, -2.270872648110107e-07,  5.644833657679758e-09,
 -1.321675301574286e-10,  2.948619810321002e-12, -6.328970048784567e-14,  1.313053017449074e-15, -2.639652410836637e-17,  5.195356451976975e-19, -9.923760926358629e-21,
  1.272957001219621e-02, -7.910274862230604e-04,  3.637716357862791e-05, -1.416794469914733e-06,  4.914439792619448e-08, -1.561231056024279e-09,  4.621405045906620e-11,
 -1.289481393320880e-12,  3.419188767810479e-14, -8.667452536036977e-16,  2.110325500415356e-17, -4.950191238880444e-19,  9.491037378587293e-03, -9.065143986121547e-04,
  6.012108886980998e-05, -3.210331358005873e-06,  1.476794368940542e-07, -6.065771082385321e-09,  2.273661420994255e-10, -7.891147572419780e-12,  2.562198430945087e-13,
 -7.842719062701174e-15,  2.276364462738041e-16, -6.290243505731335e-18,  3.694763005950200e-03, -5.428546401916424e-04,  5.045300289735473e-05, -3.603179024443261e-06,
  2.146306805663167e-07, -1.113088159618958e-08,  5.159321932191054e-10, -2.175214377102640e-11,  8.446718600313171e-13, -3.049270200085175e-14,  1.030726487261515e-15,
 -3.278161023112571e-17,  8.875288535747634e-04, -1.947305423102539e-04,  2.489129041180242e-05, -2.338196306684212e-06,  1.772851272909813e-07, -1.140355066267359e-08,
  6.416510600851167e-10, -3.224188080002515e-11,  1.468374802162652e-12, -6.128785211259662e-14,  2.364726453648405e-15, -8.483789055633935e-17,  1.577774046131903e-04,
 -4.875632931713744e-05,  8.299728591508816e-06, -9.970718133638638e-07,  9.367184226587045e-08, -7.276723950523109e-09,  4.840059790609742e-10, -2.822835202376002e-11,
  1.468681243979909e-12, -6.906346217377416e-14,  2.965460025854279e-15, -1.170834779138735e-16,  2.454194644458660e-05, -9.552520470443761e-06,  1.996130225891363e-06,
 -2.860812220420256e-07,  3.129425836199372e-08, -2.773884573126270e-09,  2.069744517505297e-10, -1.334777257717098e-11,  7.585079933558479e-13, -3.854645063473029e-14,
  1.772308999214138e-15, -7.432222291092816e-17,  5.242962624081606e-03, -2.121882389916738e-04,  6.136062098142819e-06, -1.545988143222948e-07,  3.586884674434050e-09,
 -7.867125158955479e-11,  1.646215978019377e-12, -3.318593109489138e-14,  6.514179922619213e-16, -1.226052658405824e-17,  2.284178525814680e-19, -4.189675283007379e-21,
  1.005598936196874e-02, -5.566836217727817e-04,  2.322939614169991e-05, -8.303888100334686e-07,  2.662149655958202e-08, -7.856321588528087e-10,  2.169012039906430e-11,
 -5.663783578060471e-13,  1.409826772486750e-14, -3.363474805223583e-16,  7.726205524576979e-18, -1.714033560572911e-19,  6.629525699492837e-03, -5.470817550287064e-04,
  3.255996499404905e-05, -1.582768883167661e-06,  6.690805598915276e-08, -2.543181557037726e-09,  8.872274944491636e-11, -2.879660772863025e-12,  8.779877021400197e-14,
 -2.533081688851063e-15,  6.952679847275376e-17, -1.822417276343545e-18,  2.121336476165498e-03, -2.671944258400496e-04,  2.219517762490454e-05, -1.440046766178320e-06,
  7.883259738765443e-08, -3.789823476136396e-09,  1.639782447382215e-10, -6.491302518899371e-12,  2.378650292514216e-13, -8.139055420747271e-15,  2.617980470790854e-16,
 -7.951936447625936e-18,  3.797533487803177e-04, -7.271973138852157e-05,  8.381267019870827e-06, -7.217924725250724e-07,  5.077712461102355e-08, -3.058182130803677e-09,
  1.623093059124836e-10, -7.740050331696132e-12,  3.362809118873533e-13, -1.345062213091322e-14,  4.993107074911982e-16, -1.729622705351392e-17,  4.506182021549468e-05,
 -1.272758552621688e-05,  2.013825665486457e-06, -2.276386098465581e-07,  2.031047179128695e-08, -1.509347488605918e-09,  9.660173337931258e-11, -5.447413186746472e-12,
  2.751386335415552e-13, -1.260298122777134e-14,  5.286713968493204e-16, -2.044421129356263e-17,  4.611060368285292e-06, -1.741795978269784e-06,  3.544054062388826e-07,
 -4.965588086603841e-08,  5.328053823219029e-09, -4.645056634117802e-10,  3.416437946260915e-11, -2.175723384158734e-12,  1.222765239428542e-13, -6.153179518711741e-15,
  2.804443668467593e-16, -1.166857180037851e-17,  4.481872699877204e-03, -1.696518990351244e-04,  4.579476358837123e-06, -1.079276136031862e-07,  2.343932614153998e-09,
 -4.830973224864818e-11,  9.532373880715507e-13, -1.794732099795088e-14,  3.378586674900217e-16, -5.988039348296100e-18,  1.016856502059142e-19, -1.895445989155112e-21,
  8.146666665593549e-03, -4.044999557471950e-04,  1.538069588249750e-05, -5.064617428847576e-07,  1.505266380729536e-08, -4.137641278383011e-10,  1.068015544295870e-11,
 -2.614624375098391e-13,  6.120892019735833e-15, -1.376492484337839e-16,  2.985856803177969e-18, -6.271946197101000e-20,  4.863268544875911e-03, -3.476060798348872e-04,
  1.862299549325217e-05, -8.260744450126227e-07,  3.214920844415408e-08, -1.132266704103055e-09,  3.679471510428278e-11, -1.117584035685275e-12,  3.199912905100923e-14,
 -8.701694429147408e-16,  2.258353950308071e-17, -5.611217255063648e-19,  1.322353716103116e-03, -1.419382400909241e-04,  1.053595342485508e-05, -6.204638161466282e-07,
  3.118235215666162e-08, -1.387744183875856e-09,  5.596189312698470e-11, -2.076486392115054e-12,  7.166301522484996e-14, -2.319450531928879e-15,  7.084266838106033e-17,
 -2.050394804434204e-18,  1.828608729735664e-04, -3.007102719848514e-05,  3.102646687663083e-06, -2.434445978814161e-07,  1.580344727999794e-08, -8.867105864225859e-10,
  4.417951367192783e-11, -1.990440713974725e-12,  8.214668991031421e-14, -3.135904008631662e-15,  1.115650229988221e-16, -3.717726770646494e-18,  1.463251636761680e-05,
 -3.694810372774607e-06,  5.358690687779854e-07, -5.637662545369453e-08,  4.734329661930102e-09, -3.340005230209988e-10,  2.043365463345561e-11, -1.107648763575268e-12,
  5.403298280591820e-14, -2.399990325531229e-15,  9.795697174243116e-17, -3.696889195810603e-18,  9.248151423812048e-07, -3.351641525315643e-07,  6.582771354074029e-08,
 -8.956125578313868e-09,  9.376041649648731e-10, -8.005057627351112e-11,  5.783102772235532e-12, -3.626173476076010e-13,  2.010481442492654e-14, -9.997159397706483e-16,
  4.508544203460529e-17, -1.858359078775482e-18,  3.869146719688438e-03, -1.376251860056375e-04,  3.481085577282728e-06, -7.706241061972787e-08,  1.571369536254344e-09,
 -3.041536718671110e-11,  5.744310611143108e-13, -9.940341353909735e-15,  1.787915786824883e-16, -3.227812323414716e-18,  4.391358346683225e-20, -8.411557817337252e-22,
  6.741318546783118e-03, -3.022195890687624e-04,  1.051428332928964e-05, -3.200368701362551e-07,  8.845201101329491e-09, -2.270294749584045e-10,  5.494068954376881e-12,
 -1.263126403908448e-13,  2.785447424058381e-15, -5.919399549750868e-17,  1.213113487726802e-18, -2.415852467155841e-20,  3.718443743424707e-03, -2.309839153885779e-04,
  1.117979050038965e-05, -4.537448949245235e-07,  1.629447271981790e-08, -5.327213418525541e-10,  1.613891259396149e-11, -4.594250856690313e-13,  1.236017332050437e-14,
 -3.167185580684281e-16,  7.780920929479992e-18, -1.831990693790631e-19,  8.857104086603083e-04, -8.066867415852457e-05,  5.359749308422044e-06, -2.865426977605963e-07,
  1.322000536864429e-08, -5.444545005386550e-10,  2.044320265941608e-11, -7.104134999544597e-13,  2.306177743504500e-14, -7.049425899526579e-16,  2.041515625206408e-17,
 -5.620265331936491e-19,  9.838695917998119e-05, -1.368640208860597e-05,  1.258511460061265e-06, -8.954407119152347e-08,  5.341553921306875e-09, -2.780918765657128e-10,
  1.295569449847793e-11, -5.493611930136120e-13,  2.145589274680950e-14, -7.788501880731039e-16,  2.646119879931789e-17, -8.453210081569760e-19,  5.459049066881897e-06,
 -1.201723276037602e-06,  1.575728814423338e-07, -1.525981901281706e-08,  1.195170326121751e-09, -7.941811285027038e-11,  4.612297295671313e-12, -2.388683381492482e-13,
  1.119254020071785e-14, -4.797008866673150e-16,  1.896649695757104e-17, -6.957844050377687e-19,  2.021175505878876e-07, -6.909393997708399e-08,  1.294337389092990e-08,
 -1.694663118094949e-09,  1.718817268125136e-10, -1.429075902576550e-11,  1.009434828423237e-12, -6.208451456329628e-14,  3.385148801880900e-15, -1.658901581303199e-16,
  7.386057390337069e-18, -3.010170351221896e-19,  3.369034663695160e-03, -1.130898763899044e-04,  2.689307027073759e-06, -5.612216791817222e-08,  1.081305655658186e-09,
 -1.941926725454972e-11,  3.607927155924420e-13, -5.798711839986558e-15,  8.723367153531285e-17, -2.000528263646374e-18,  2.237183558971457e-20, -1.603144660484932e-22,
  5.679339649150104e-03, -2.313650491840363e-04,  7.393449173577531e-06, -2.087176827967729e-07,  5.381482400445224e-09, -1.292199437018588e-10,  2.941253387974517e-12,
 -6.365080840570147e-14,  1.321653190484664e-15, -2.666903376844683e-17,  5.166125563300194e-19, -9.733811402486124e-21,  2.944238784548719e-03, -1.595851175784817e-04,
  7.005423885941980e-06, -2.609097796027819e-07,  8.664417581176340e-09, -2.637820017221544e-10,  7.449911672746904e-12, -1.991036249592821e-13,  5.049064098034964e-15,
 -1.215572632650916e-16,  2.831950646156005e-18, -6.342655015374467e-20,  6.311832819868100e-04, -4.863164413642846e-05,  2.901942632731548e-06, -1.409933777026755e-07,
  5.974775859555957e-09, -2.279422535182473e-10,  7.962685095255392e-12, -2.591131536822237e-13,  7.911579993343345e-15, -2.280120838628356e-16,  6.256713570817208e-18,
 -1.637038110113093e-19,  5.857826344859312e-05, -6.797724928890552e-06,  5.564238188695057e-07, -3.578588489637132e-08,  1.955929728767801e-09, -9.423177689551749e-11,
  4.091853730043292e-12, -1.628101107574301e-13,  5.999303736917622e-15, -2.064174614110298e-16,  6.676639817750566e-18, -2.038408899467237e-19,  2.351664073317690e-06,
 -4.390776889489746e-07,  5.143640976031403e-08, -4.538092259650956e-09,  3.286397240227093e-10, -2.041357843678455e-11,  1.117745442181590e-12, -5.496534065722033e-14,
  2.459983967469467e-15, -1.012134172116329e-16,  3.858471598590019e-18, -1.370051200886701e-19,  4.943503998422741e-08, -1.554470111384101e-08,  2.733494344968829e-09,
 -3.403700201152452e-10,  3.314341400202873e-11, -2.664220907563193e-12,  1.829290984647639e-13, -1.098300055871759e-14,  5.865783422821461e-16, -2.823457551656085e-17,
  1.237586151519466e-18, -4.974992400253581e-20,  2.955818631354064e-03, -9.400188354645710e-05,  2.108214712216975e-06, -4.150820809722742e-08,  7.677289046223953e-10,
 -1.245368002964536e-11,  2.278884175529107e-13, -3.989597264157764e-15,  3.129075173424836e-17, -1.065454370361477e-18,  2.854058776947836e-20,  3.975906080269836e-22,
  4.858147722624385e-03, -1.809463321543026e-04,  5.331127028838413e-06, -1.399838437771350e-07,  3.380018697062481e-09, -7.600020464624832e-11,  1.631039123717501e-12,
 -3.343714111842115e-14,  6.498302930279253e-16, -1.250858250568493e-17,  2.325945666194025e-19, -4.004240894227999e-21,  2.401023903133152e-03, -1.140547427478518e-04,
  4.559175236893780e-06, -1.563815843587048e-07,  4.804853115341319e-09, -1.370041167668344e-10,  3.608205889655656e-12, -9.018424196159361e-14,  2.181505065643620e-15,
 -4.919305518779935e-17,  1.071608739505229e-18, -2.349972794011518e-20,  4.742819993729674e-04, -3.084810710203726e-05,  1.661109709062504e-06, -7.351901870970732e-08,
  2.860298814572520e-09, -1.014436349997007e-10,  3.294930741482854e-12, -1.002301934435949e-13,  2.888915482978711e-15, -7.833381619784548e-17,  2.030264022850287e-18,
 -5.073059402393939e-20,  3.816852370439767e-05, -3.646978279358290e-06,  2.663970261282601e-07, -1.546473988585087e-08,  7.726022651568193e-10, -3.441906750897045e-11,
  1.389660899310213e-12, -5.175281044641165e-14,  1.796129592383204e-15, -5.840953113191780e-17,  1.793761449718143e-18, -5.222827904106225e-20,  1.168119905303634e-06,
 -1.796549956224887e-07,  1.865594254196745e-08, -1.486302505397913e-09,  9.876026745073313e-11, -5.696540221652216e-12,  2.922051416789137e-13, -1.356400777753869e-14,
  5.767040381823134e-16, -2.266199855857576e-17,  8.290553323595821e-19, -2.836869649289871e-20,  1.397653456816217e-08, -3.896887143311342e-09,  6.305141952594214e-10,
 -7.356598216166919e-11,  6.799739064247439e-12, -5.237254483744963e-13,  3.470047866416888e-14, -2.021637047634322e-15,  1.052337363054408e-16, -4.954592597352420e-18,
  2.130450915526189e-19, -8.422198718825907e-21,  2.610659969876335e-03, -7.893691811520819e-05,  1.676461663808594e-06, -3.095628262298981e-08,  5.647660921054857e-10,
 -8.238371517282597e-12,  1.262150529589546e-13, -3.345075250199179e-15,  1.793501535453299e-17,  4.294175860341060e-19,  4.320228053730347e-20, -4.388603803153460e-23,
  4.210182941343253e-03, -1.442003029148183e-04,  3.931753601621790e-06, -9.621750761628044e-08,  2.186216266837258e-09, -4.609974894201178e-11,  9.293034831734125e-13,
 -1.834240086587385e-14,  3.325419231982868e-16, -5.884475178521273e-18,  1.150604009915186e-19, -1.728016239101273e-21,  2.007471162398992e-03, -8.396216536657631e-05,
  3.066635689397656e-06, -9.745453259454528e-08,  2.760961138067919e-09, -7.420499815621420e-11,  1.843083419704848e-12, -4.212385835474980e-14,  9.828553605308762e-16,
 -2.174116436231920e-17,  4.058290284518603e-19, -8.841632937773657e-21,  3.728051198506495e-04, -2.044049587335839e-05,  9.982172496666374e-07, -4.048349595993360e-08,
  1.439558175870142e-09, -4.773364663375677e-11,  1.449456144087568e-12, -4.075755550813253e-14,  1.116486136913239e-15, -2.882857951191439e-17,  6.880950383183983e-19,
 -1.659473685912511e-20,  2.690767272388063e-05, -2.090550687220375e-06,  1.370324709582673e-07, -7.194649531036501e-09,  3.271857693663393e-10, -1.350154896918835e-11,
  5.067809931900304e-13, -1.758554944055110e-14,  5.750864069249939e-16, -1.766684644048892e-17,  5.121808914016293e-19, -1.423042655939681e-20,  6.640296148489725e-07,
 -8.158685456068049e-08,  7.496047355891464e-09, -5.359674871869485e-10,  3.244719803119560e-11, -1.729546332619647e-12,  8.266397321581799e-14, -3.602102389294129e-15,
  1.448152575313390e-16, -5.408953247886225e-18,  1.889847708693214e-19, -6.206684809528743e-21,  4.727757667435396e-09, -1.110127812803163e-09,  1.616441623527416e-10,
 -1.736595850613815e-11,  1.503253363520899e-12, -1.097589511989946e-13,  6.956096103001361e-15, -3.903909216040000e-16,  1.968619376342442e-17, -9.019570443371908e-19,
  3.788220576241295e-20, -1.467329369513735e-21,  2.319584528017069e-03, -6.686911540388225e-05,  1.354216048213977e-06, -2.310396310599227e-08,  4.231408435211258e-10,
 -6.242781621781105e-12,  4.510729422373692e-14, -2.227388882774621e-15,  5.883052992748125e-17,  1.527786180028203e-18, -4.741264774318308e-21, -2.199525632667673e-21,
  3.689733335756146e-03, -1.168330491031207e-04,  2.960089878573038e-06, -6.755740336460440e-08,  1.451142158216305e-09, -2.892440697910914e-11,  5.383973074862699e-13,
 -1.033583184085560e-14,  1.873872595911961e-16, -2.586894568125064e-18,  5.253497338310106e-20, -1.325034704798294e-21,  1.714211146487652e-03, -6.345485340863704e-05,
  2.120083409004704e-06, -6.309394383689235e-08,  1.639318657437938e-09, -4.119775809773562e-11,  1.004960469077167e-12, -2.067058621221888e-14,  4.214583817853796e-16,
 -1.084564100533549e-17,  1.910823647057075e-19, -1.691197672813564e-21,  3.044084255520931e-04, -1.406835021869886e-05,  6.243223386728321e-07, -2.352389674384198e-08,
  7.577053407228129e-10, -2.340316993017031e-11,  6.833895103471350e-13, -1.747626605640033e-14,  4.388013230998827e-16, -1.162860069435960e-17,  2.552936188823120e-19,
 -4.960907816715639e-21,  2.029432781696618e-05, -1.267570163174280e-06,  7.495474093758844e-08, -3.595429003841861e-09,  1.475834475017955e-10, -5.639693089738582e-12,
  1.988095891650159e-13, -6.371119514747761e-15,  1.949175415629023e-16, -5.749810541783466e-18,  1.559615847515084e-19, -4.040916880583851e-21,  4.265914490645642e-07,
 -4.058652869650411e-08,  3.311858716010789e-09, -2.124969010140442e-10,  1.162352671471478e-11, -5.707788411696554e-13,  2.536289446805255e-14, -1.030952563456284e-15,
  3.902527931069591e-17, -1.382356067210069e-18,  4.585789720892295e-20, -1.438640388756220e-21,  1.967697665314838e-09, -3.638844965597834e-10,  4.676467010890583e-11,
 -4.542246689434562e-12,  3.626740933393147e-13, -2.481063854385319e-14,  1.489085458726255e-15, -7.981606582890357e-17,  3.871544141957250e-18, -1.715723425364047e-19,
  7.001409287296289e-21, -2.645453822547614e-22,  2.072169971516967e-03, -5.703847743451604e-05,  1.113612903427314e-06, -1.729051379539428e-08,  3.053534387900875e-10,
 -5.651382606096268e-12,  1.592790756720163e-14,  2.954670311355368e-16,  8.553430470542108e-17, -6.728593698006189e-19, -9.446903529878674e-20, -6.699484661604918e-22,
  3.265132693834447e-03, -9.604022102152921e-05,  2.271653097571353e-06, -4.835215235471153e-08,  9.816081572086109e-10, -1.887248897342146e-11,  3.211764420625129e-13,
 -5.537151133143700e-15,  1.182460670202431e-16, -1.610993771814100e-18, -2.160742374890156e-22, -8.005293081290071e-22,  1.490074514965880e-03, -4.913178747521484e-05,
  1.496904349912809e-06, -4.231950649702773e-08,  1.016202439164195e-09, -2.281046449170932e-11,  5.662842032941254e-13, -1.204136903450251e-14,  1.591421103799993e-16,
 -3.871567066100185e-18,  1.633754139682775e-19, -9.116234106675193e-22,  2.565868309134311e-04, -1.002733119315496e-05,  4.018204120283315e-07, -1.439613907294547e-08,
  4.208061844990108e-10, -1.161220132172195e-11,  3.397682459267257e-13, -8.492369124452485e-15,  1.654684397418579e-16, -4.331731814960802e-18,  1.333503353944962e-19,
 -1.660787401120916e-21,  1.619724769721356e-05, -8.075151523673907e-07,  4.295537354730800e-08, -1.927255034825930e-09,  7.101836385960412e-11, -2.459556897863479e-12,
  8.356131985121999e-14, -2.516261493683596e-15,  6.811279006370411e-17, -1.948930947736066e-18,  5.439721438930301e-20, -1.189232998439380e-21,  3.046264158628415e-07,
 -2.182275886033421e-08,  1.586394277377090e-09, -9.253284632500258e-11,  4.528882158932395e-12, -2.031892894930066e-13,  8.450339045978898e-15, -3.194108832699882e-16,
  1.123121450865782e-17, -3.785630460980199e-19,  1.199083794091774e-20, -3.520420829234607e-22,  1.016997619380748e-09, -1.371998636044868e-10,  1.539120438721078e-11,
 -1.333162858710764e-12,  9.652042475303623e-14, -6.112538439294926e-15,  3.441552172179650e-16, -1.744588427022368e-17,  8.071459477212445e-19, -3.438364253527911e-20,
  1.355038140611246e-21, -4.964508399672249e-23,  1.860625931367213e-03, -4.888488311137201e-05,  9.317979742348904e-07, -1.328047439540374e-08,  1.982278878478296e-10,
 -4.908583017517181e-12,  5.383800878137834e-14,  1.958577028061837e-15,  1.492115245293366e-18, -3.372461446194783e-18, -3.160225603716032e-21,  4.126694732427303e-21,
  2.913985755649465e-03, -7.994710019124176e-05,  1.774435426997199e-06, -3.529292373499079e-08,  6.706607696305909e-10, -1.265194674447831e-11,  2.101330837372255e-13,
 -2.720401297767542e-15,  5.644979919828099e-17, -1.783813218167450e-18,  5.276730234211174e-21,  9.763183571560071e-22,  1.314631456029486e-03, -3.894188778107385e-05,
  1.073671737572721e-06, -2.907701778350420e-08,  6.711735494910521e-10, -1.277693005011622e-11,  2.876814117764380e-13, -8.062767687829979e-15,  1.174947754557980e-16,
  7.348316622691987e-19,  4.093419802310381e-20, -4.187290650734308e-21,  2.219540272123540e-04, -7.404458365820058e-06,  2.630369233370507e-07, -9.149729703402891e-09,
  2.534490623836496e-10, -5.823785194779375e-12,  1.591510216291414e-13, -4.812851674947982e-15,  8.667868338904963e-17, -6.233290779462570e-19,  4.571212381620341e-20,
 -2.376202664263194e-21,  1.353110904846003e-05, -5.401974202336126e-07,  2.531939721126633e-08, -1.095750658254648e-09,  3.722035534098690e-11, -1.105268464644135e-12,
  3.556106119861315e-14, -1.124519918142430e-15,  2.699108090176236e-17, -5.656376133021679e-19,  1.890483804100510e-20, -5.859299472916180e-22,  2.370918419121133e-07,
 -1.259118583261228e-08,  8.055164615871055e-10, -4.400574450213579e-11,  1.935227179071079e-12, -7.699407389466581e-14,  3.008132046828294e-15, -1.090585415709805e-16,
  3.488489596939180e-18, -1.068185280165484e-19,  3.383983636800380e-21, -9.821958147044934e-23,  6.408238842592059e-10, -5.883674627932408e-11,  5.725372534356858e-12,
 -4.433060255816730e-13,  2.861508405406548e-14, -1.649984646032747e-15,  8.663282001624553e-17, -4.126307385714039e-18,  1.798245942456817e-19, -7.298322935132997e-21,
  2.773270710349039e-22, -9.796592863700274e-24,  1.679052815419379e-03, -4.202096089761926e-05,  7.884980635121638e-07, -1.080663057176820e-08,  1.169958516143264e-10,
 -3.057484620132315e-12,  9.290030271521618e-14,  3.741908606718340e-16, -8.251068873455701e-17, -4.735913839758343e-19,  1.147105458472274e-19, -1.801707835863110e-22,
  2.620140339284655e-03, -6.728082430694043e-05,  1.407777574516032e-06, -2.633560318083954e-08,  4.626995108151606e-10, -8.374340973184104e-12,  1.504074028829986e-13,
 -1.811560264136348e-15,  6.831454896380213e-18, -7.205941714596321e-19,  4.092230067258531e-20,  8.379794343153543e-23,  1.174067568905048e-03, -3.158298402238286e-05,
  7.817720256081289e-07, -2.007617191967050e-08,  4.687048954999881e-10, -8.129642275607123e-12,  1.188092245590511e-13, -3.898898811192386e-15,  1.336569377408276e-16,
 -6.719864125227147e-19, -8.017854390641168e-20, -1.512723736060983e-22,  1.959365062291423e-04, -5.678120909659477e-06,  1.742878114495811e-07, -5.859177588080327e-09,
  1.658160239008947e-10, -3.320853627426516e-12,  6.123414789479485e-14, -2.237328826106067e-15,  7.421811825870625e-17, -5.765977370791068e-19, -2.849968131250574e-20,
 -4.209825247689809e-22,  1.170455269415194e-05, -3.815397958888186e-07,  1.513881212942396e-08, -6.398447688818706e-10,  2.153906745902458e-11, -5.467872402833295e-13,
  1.388087664200708e-14, -4.854762221347114e-16,  1.490289744181359e-17, -2.249952538117570e-19,  1.089587639473999e-21, -1.820699539589973e-22,  1.968865142588046e-07,
 -7.828861047042991e-09,  4.227455333236481e-10, -2.228762803178325e-11,  9.228872951128743e-13, -3.162527393473174e-14,  1.084767137670940e-15, -3.964276220238442e-17,
  1.279952071207773e-18, -3.251034137608320e-20,  8.226300323431355e-22, -2.900567588155900e-23,  4.718061086568233e-10, -2.845957370183234e-11,  2.344992760243694e-12,
 -1.665718085514473e-13,  9.602833517984296e-15, -4.899818078455436e-16,  2.361181167671839e-17, -1.066125369610008e-18,  4.375788558197955e-20, -1.647471023254145e-21,
  5.930777493326865e-23, -2.061972333699898e-24,  1.522803423415980e-03, -3.620373601671084e-05,  6.684215378016734e-07, -9.304465546711863e-09,  7.749024566911309e-11,
 -9.869890724210111e-13,  6.954949613440538e-14, -1.772668219719794e-15, -3.400043543473008e-17,  2.415167232059313e-18,  7.719297788055984e-21, -3.119101997779904e-21,
  2.371702373876524e-03, -5.716839769392482e-05,  1.131231241295371e-06, -2.009317505011760e-08,  3.272675698791650e-10, -5.361701991158939e-12,  1.009647938179473e-13,
 -1.719552054810282e-15,  6.132792351076419e-18,  4.597384516288712e-19,  9.381034711269570e-21, -1.060791261622517e-21,  1.058882970398923e-03, -2.617647744247390e-05,
  5.809083861963117e-07, -1.375162542952267e-08,  3.281101251783165e-10, -6.147964325336782e-12,  6.186085628088439e-14, -5.482748159682464e-16,  6.364622672758132e-17,
 -2.632515988426025e-18,  2.239439911894817e-21,  2.536489006164330e-21,  1.756248950561392e-04, -4.524573134796982e-06,  1.179156400545576e-07, -3.674403166817529e-09,
  1.102976881509489e-10, -2.361614397233847e-12,  2.718435026045015e-14, -4.020096566448121e-16,  3.563027628816791e-17, -1.348151498744309e-18,  1.769868950879537e-21,
  1.155901364849585e-21,  1.037928600197630e-05, -2.860160770859522e-07,  9.215677103433227e-09, -3.683521579657641e-10,  1.308070382671795e-11, -3.302990678812380e-13,
  5.754986965280864e-15, -1.375609244699915e-16,  6.821993400452289e-18, -2.197905512331266e-19,  1.336604904165109e-21,  1.075887239858020e-22,  1.709417954054826e-07,
 -5.306135764911679e-09,  2.267433167803260e-10, -1.147309390031640e-11,  4.808118873652093e-13, -1.518603491878477e-14,  4.063900110300128e-16, -1.289149015411454e-17,
  4.924911326412054e-19, -1.483670126385678e-20,  2.531308044338272e-22, -2.630452014090289e-24,  3.857357346935194e-10, -1.566869584808194e-11,  1.022209440346098e-12,
 -6.840666974225111e-14,  3.685244632580870e-15, -1.652583503929372e-16,  6.907519425275068e-18, -2.902224702676244e-19,  1.174422783524401e-20, -4.227405017566741e-22,
  1.348164617360637e-23, -4.209128737249002e-25,  1.388004496387124e-03, -3.128290097246551e-05,  5.638001417572468e-07, -8.149932239866933e-09,  7.011633202324667e-11,
  4.034651963385483e-14,  1.686555999121663e-14, -1.627655380091957e-15,  3.344067357056857e-17,  8.997401744332610e-19, -5.714656778521036e-20,  2.884661920607920e-22,
  2.159717308715648e-03, -4.900137674001869e-05,  9.183752582454344e-07, -1.559887449195615e-08,  2.405474478336366e-10, -3.478285691848358e-12,  5.810490305901458e-14,
 -1.263624520914734e-15,  2.040787059012955e-17,  1.638069026044031e-19, -1.587059021928686e-20,  6.030845231134467e-24,  9.625407892277874e-04, -2.210887610897266e-05,
  4.435844402139372e-07, -9.407027401443025e-09,  2.195893635984159e-10, -4.699653399470522e-12,  6.196400673768527e-14,  1.658327020046309e-16, -9.236887997195310e-18,
 -1.074053952328297e-18,  5.360942857347259e-20, -3.136663623495736e-22,  1.591718956428333e-04, -3.730989261233782e-06,  8.296145427187794e-08, -2.254111044710248e-09,
  6.916234837867481e-11, -1.757606029206159e-12,  2.518868201851387e-14,  5.789448888868076e-17, -2.092044957555014e-18, -5.810322720900404e-19,  2.653365832702043e-20,
 -1.322878961770966e-22,  9.359094107061378e-06, -2.268719193907737e-07,  5.854806835722491e-09, -2.053583058452334e-10,  7.642431106569903e-12, -2.204618275712100e-13,
  3.892142173581765e-15, -2.743692257879135e-17,  8.110962081993440e-19, -9.759045918922870e-20,  3.742547854977691e-21, -2.146599064390473e-23,  1.526311148133121e-07,
 -3.932255866919121e-09,  1.266472653112356e-10, -5.776289639013026e-12,  2.527384193694223e-13, -8.410735254587766e-15,  1.988672342838694e-16, -3.860306035338232e-18,
  1.247642693360625e-19, -5.953359647861684e-21,  1.901138526949152e-22, -2.201298283266445e-24,  3.353614151631953e-10, -9.975970479515641e-12,  4.691791444749777e-13,
 -2.902502777196125e-14,  1.550646936723353e-15, -6.558663100198812e-17,  2.333078730568186e-18, -8.097799534481419e-20,  3.087750143528300e-21, -1.188573544647074e-22,
  3.921697537544329e-24, -1.028452062063027e-25,  1.271301403182794e-03, -2.714448794242863e-05,  4.727934321770426e-07, -7.012704340390925e-09,  7.197807714031732e-11,
  3.463351637107500e-14, -1.167528990738934e-14, -4.197914495840870e-16,  3.284216207435983e-17, -6.316284444821105e-19, -1.424016328588583e-20,  1.052185306545498e-21,
  1.977306244989430e-03, -4.234254068959873e-05,  7.522014814680447e-07, -1.224154561985146e-08,  1.824503814057742e-10, -2.433207523132268e-12,  3.195007438792322e-14,
 -6.249385539866389e-16,  1.684447269112444e-17, -2.765268499515071e-19, -3.895442690210580e-21,  3.295524592410236e-22,  8.805632725232721e-04, -1.895862388220628e-05,
  3.489427992147463e-07, -6.564084950473733e-09,  1.405694890172641e-10, -3.212396376777569e-12,  5.929606552590400e-14, -3.916139305576466e-16, -1.690192161359379e-17,
  3.755628650688184e-19,  1.464959396384274e-20, -9.377504008041142e-22,  1.454273162548622e-04, -3.159139428692554e-06,  6.149885946280809e-08, -1.395649257177069e-09,
  4.009057384333395e-11, -1.153776311739528e-12,  2.404474053247844e-14, -1.654100855716553e-16, -7.464420762810189e-18,  1.514153765785756e-19,  7.817721130257604e-21,
 -4.634774570563706e-22,  8.532209071702375e-06, -1.881152473628148e-07,  3.994458086528705e-09, -1.135184249199982e-10,  4.109970292564031e-12, -1.356317898107347e-13,
  3.144974078148848e-15, -3.248991071309836e-17, -4.977673583267762e-19,  7.304643811645591e-21,  1.222694969655242e-21, -6.181855304618604e-23,  1.385715764854581e-07,
 -3.138851149006393e-09,  7.679815786854725e-11, -2.849566377040523e-12,  1.251617070124317e-13, -4.634826003224102e-15,  1.236299500676134e-16, -2.055530956423749e-18,
  1.881927835090723e-20, -7.790322542003174e-22,  6.581787887748244e-23, -2.607860241618800e-24,  3.012435401827375e-10, -7.277047652292969e-12,  2.345938699444797e-13,
 -1.227776908718306e-14,  6.594492101155712e-16, -2.869539954584412e-17,  9.784587044097956e-19, -2.759450566277817e-20,  7.790195103528706e-22, -2.774961467267274e-23,
  1.100277460094546e-24, -3.658477442936113e-26,  1.169782750142013e-03, -2.367923069903281e-05,  3.955180060327522e-07, -5.872889967720128e-09,  6.943325059074045e-11,
 -2.908573723382759e-13, -1.247244181335239e-14,  2.317831685684121e-16,  8.515009513924793e-18, -5.526626427882927e-19,  1.118532111652567e-20,  1.287443038190395e-22,
  1.819106443019346e-03, -3.686634983247771e-05,  6.213333240057408e-07, -9.674966762668010e-09,  1.403107405989357e-10, -1.825133668800786e-12,  2.042797277597968e-14,
 -2.517578345556969e-16,  6.826120964228213e-18, -2.269455557561196e-19,  4.153981665497619e-21,  3.847776484891409e-23,  8.098611380374526e-04, -1.644832548818639e-05,
  2.817863044079075e-07, -4.756276671260864e-09,  8.941061981409874e-11, -1.967194922016911e-12,  4.319945009301233e-14, -6.695266315345980e-16, -5.856469647323310e-19,
  3.799916992345008e-19, -8.296738085271346e-21, -1.285300537467832e-22,  1.336819986013037e-04, -2.724794634883053e-06,  4.793453459365540e-08, -9.094315879631613e-10,
  2.229754488608728e-11, -6.529419970387806e-13,  1.712097144580991e-14, -2.897806049831359e-16, -2.479319666697888e-19,  1.735283518479912e-19, -3.719498740027749e-21,
 -6.923660253154335e-23,  7.836369989501280e-06, -1.606717200217630e-07,  2.949650128831314e-09, -6.569514275675583e-11,  2.071020196631986e-12, -7.240444882499631e-14,
  2.092517602274676e-15, -3.921676998413282e-17,  1.252528129444306e-19,  1.691155288312261e-20, -3.549092779192603e-22, -1.078388899827315e-23,  1.270683552705723e-07,
 -2.633291527480008e-09,  5.203115197506099e-11, -1.445875242653500e-12,  5.776636636905358e-14, -2.302947233410470e-15,  7.279280455203704e-17, -1.581453235213527e-18,
  1.616662613792961e-20,  1.838645538597735e-22, -2.293116111622900e-24, -5.658291306808183e-25,  2.751605216013651e-10, -5.846718760285445e-12,  1.351452187387527e-13,
 -5.263331502013262e-15,  2.693186092022296e-16, -1.235245002573607e-17,  4.501410419578996e-19, -1.266594615107156e-20,  2.791541000621108e-22, -5.887615063344406e-24,
  1.946636562584149e-25, -8.767499840585350e-27,  1.080973737378017e-03, -2.077863481240326e-05,  3.314711808747627e-07, -4.822202885113017e-09,  6.124109838012148e-11,
 -4.967336543279840e-13, -4.527122506767101e-15,  2.738751804533775e-16, -3.337705998562114e-18, -1.318926529297583e-19,  7.740032109655492e-21, -1.710684511319429e-22,
  1.680897506449346e-03, -3.232452865718602e-05,  5.175795859924509e-07, -7.697416065924741e-09,  1.082395853050693e-10, -1.401151185520452e-12,  1.544058873739416e-14,
 -1.317859547394750e-16,  1.602051557603523e-18, -7.298995570497988e-20,  2.850917200446136e-21, -5.976451781694191e-23,  7.482457541783397e-04, -1.440067210388863e-05,
  2.321613280363450e-07, -3.590399522188997e-09,  5.895005439426236e-11, -1.147248285362700e-12,  2.576839136064990e-14, -5.361736134728222e-16,  6.966340375379516e-18,
  5.813518348147389e-20, -5.919556175734750e-21,  1.374828054884008e-22,  1.234880757759130e-04, -2.379767102639794e-06,  3.879586028165538e-08, -6.375274577439042e-10,
  1.270640177237762e-11, -3.356225734280730e-13,  9.616994325549293e-15, -2.282838995696493e-16,  3.189616716883676e-18,  2.526636782736585e-20, -2.750090368007641e-21,
  6.436582368094516e-23,  7.236554990077281e-06, -1.397586939800575e-07,  2.320191289663790e-09, -4.177395073539731e-11,  1.040520364020333e-12, -3.445570163699588e-14,
  1.119949184522408e-15, -2.858851134065258e-17,  4.437095058736237e-19,  1.348321441956372e-21, -2.965203511574385e-22,  7.133023347466026e-24,  1.172760593172509e-07,
 -2.273685891116454e-09,  3.897529231651967e-11, -8.091014512918159e-13,  2.591406547387747e-14, -1.024139174790757e-15,  3.644933865237721e-17, -1.003318711255197e-18,
  1.823697684461288e-20, -8.773042556976973e-23, -6.163428529310806e-24,  1.572674913919804e-25,  2.536187739548901e-10, -4.960436707912541e-12,  9.129822024753269e-14,
 -2.448160581189240e-15,  1.061109751194680e-16, -4.951923280040976e-18,  1.961525520062180e-19, -6.155070428465066e-21,  1.466506278386263e-22, -2.492854585039737e-24,
  3.114881458701813e-26, -8.297356781618486e-28,  1.002818736987931e-03, -1.834245499031940e-05,  2.791434405872783e-07, -3.925373953556861e-09,  5.076670483836278e-11,
 -5.280372524334716e-13,  1.275948854384853e-15,  1.367992778090529e-16, -4.209429224617602e-18,  4.244433281911617e-20,  1.606368800530217e-21, -9.076364243959860e-23,
  1.559334575258279e-03, -2.852593160287738e-05,  4.347388233933631e-07, -6.170807097282470e-09,  8.364551436050156e-11, -1.070828707693634e-12,  1.220151461110775e-14,
 -1.054456963060003e-16,  4.367141132727880e-19, -6.002504709208273e-21,  7.182905542088194e-22, -3.164659111025077e-23,  6.941053607257520e-04, -1.270123520728838e-05,
  1.940745708530896e-07, -2.801796556648841e-09,  4.110682969812810e-11, -6.831847861803363e-13,  1.393174824129379e-14, -3.141148668298906e-16,  6.167806056129852e-18,
 -6.931086575956587e-20, -9.625903862792925e-22,  7.278358750838136e-23,  1.145455862142094e-04, -2.096983997528483e-06,  3.217902852769189e-08, -4.773454556438697e-10,
  7.845125634977697e-12, -1.697686034408318e-13,  4.670605919247432e-15, -1.275595962265679e-16,  2.763579035551151e-18, -3.331197180567435e-20, -4.184057843290676e-22,
  3.409686534335655e-23,  6.711809409090672e-06, -1.229634103208940e-07,  1.900109441642113e-09, -2.942152918587540e-11,  5.635883927242954e-13, -1.560013661582041e-14,
  5.127324269045898e-16, -1.530342380864172e-17,  3.512203789314854e-19, -4.719268340371401e-21, -3.338179198096402e-23,  3.827723067072403e-24,  1.087516640451852e-07,
 -1.994962464853407e-09,  3.120850305323722e-11, -5.192252013279882e-13,  1.222695929147445e-14, -4.247940883571563e-16,  1.579445538782406e-17, -5.037622089918520e-19,
  1.235912698834828e-20, -1.954837118500880e-22,  2.249166200789584e-25,  9.355564296785247e-26,  2.350843420986514e-10, -4.324821212083019e-12,  6.952792068300732e-14,
 -1.336952917283522e-15,  4.260556767528332e-17, -1.857565177452383e-18,  7.747522735470382e-20, -2.698891722943145e-21,  7.481606524911434e-23, -1.555831076432335e-24,
  2.064634421716916e-26, -6.055281232491416e-29,  9.336353401451704e-04, -1.628470325251415e-05,  2.365723867497007e-07, -3.194879204388573e-09,  4.075085829390692e-11,
 -4.649776768169185e-13,  3.501753714559092e-15,  3.281623978208520e-17, -2.236541049248379e-18,  5.350418967067391e-20, -5.056003433896989e-22, -1.575248606970098e-23,
  1.451747786888702e-03, -2.532299733750263e-05,  3.680612228612263e-07, -4.988877190335731e-09,  6.492600335106652e-11, -8.119009925645840e-13,  9.438809432727455e-15,
 -9.153399159420119e-17,  4.876091816700588e-19,  3.959291947653517e-21, -3.438359145133132e-23, -6.185685600531687e-24,  6.462072248033697e-04, -1.127287755292382e-05,
  1.639999410480915e-07, -2.237850050837857e-09,  3.017927622983383e-11, -4.345051197969554e-13,  7.500947178533646e-15, -1.592314809855818e-16,  3.543088900465126e-18,
 -6.591690818246667e-20,  6.780369597606225e-22,  1.060040585413572e-23,  1.066389520403517e-04, -1.860554306102969e-06,  2.710877888039960e-08, -3.739453651112022e-10,
  5.328114076129666e-12, -9.170446331674616e-14,  2.147388128915630e-15, -5.927416140913903e-17,  1.525370760159574e-18, -3.059942236945505e-20,  3.381876002416566e-22,
  4.550052764636122e-24,  6.248311330011110e-06, -1.090414780956196e-07,  1.592677734527357e-09, -2.235641937401103e-11,  3.458191444223267e-13, -7.326004858024462e-15,
  2.157253816409577e-16, -6.788840388781088e-18,  1.862683918458033e-19, -3.920222438248873e-21,  4.819398570571494e-23,  3.878329759472148e-25,  1.012356760657696e-07,
 -1.767424221661247e-09,  2.592659408375812e-11, -3.750380724575828e-13,  6.583339147175408e-15, -1.765817181677618e-16,  6.216521067259839e-18, -2.131972108357870e-19,
  6.160093738737643e-21, -1.376988223076353e-22,  1.983155724729697e-24,  5.671391528615116e-28,  2.188092258451184e-10, -3.823459928728478e-12,  5.661605982255259e-14,
 -8.728808844414764e-16,  1.912601014982167e-17, -6.806735442710885e-19,  2.809978197508470e-20, -1.048846148052369e-21,  3.270702149928246e-23, -8.189843535817543e-25,
  1.534908110990534e-26, -1.682602287964233e-28,  8.720536296636799e-04, -1.453507019152182e-05,  2.018543748082976e-07, -2.612507466529977e-09,  3.233132708416489e-11,
 -3.763782997786547e-13,  3.675580118433359e-15, -1.258884940257199e-17, -7.532237318581054e-19,  2.849608424000550e-20, -5.934044011281271e-22,  5.661605032157970e-24,
  1.355989022589309e-03, -2.260147210282123e-05,  3.139293064999650e-07, -4.068495253773492e-09,  5.075530465311360e-11, -6.142488041007355e-13,  7.111791410683919e-15,
 -7.424340952109815e-17,  5.696178653282607e-19,  2.105467007713846e-22, -1.016013958617784e-22,  1.092656600062367e-24,  6.035804270190757e-04, -1.006068964497989e-05,
  1.397842171709330e-07, -1.816032729126961e-09,  2.298589888303731e-11, -2.971648547048650e-13,  4.313134204608548e-15, -7.816726763588299e-17,  1.698802411099109e-18,
 -3.684512965662272e-20,  6.545351933982285e-22, -6.546829511561737e-24,  9.960393758144291e-05, -1.660307844521592e-06,  2.308014960940149e-08, -3.010451879693289e-10,
  3.899508956465586e-12, -5.548681982771526e-14,  1.025189572391174e-15, -2.531538910151512e-17,  6.820261825595748e-19, -1.650170480010724e-20,  3.111199080912569e-22,
 -3.339754512625867e-24,  5.836049249993235e-06, -9.728868648944083e-08,  1.353524605612121e-09, -1.776821614335808e-11,  2.386532814094969e-13, -3.872878835022418e-15,
  9.058418471465996e-17, -2.706804616679074e-18,  8.018595287665665e-20, -2.035679965207495e-21,  3.999180320356247e-23, -4.731859850788663e-25,  9.455453169729918e-08,
 -1.576447002559267e-09,  2.196315414429226e-11, -2.915336275136675e-13,  4.157780872762855e-15, -8.078918703399583e-17,  2.367615043154298e-18, -8.068083626925114e-20,
  2.542923234684297e-21, -6.735700067594996e-23,  1.397607594381531e-24, -1.909765604661540e-26,  2.043611329004876e-10, -3.408066043903771e-12,  4.762419178829946e-14,
 -6.472977806900799e-16,  1.038758362653153e-17, -2.637930025450012e-19,  9.712106586045679e-21, -3.701569286263815e-22,  1.246997087548170e-23, -3.534575929400802e-25,
  8.141250766498860e-27, -1.415545115181817e-28,  8.169561676019916e-04, -1.303738314245725e-05,  1.733747866053077e-07, -2.150792016477032e-09,  2.564674110977021e-11,
 -2.943204641711501e-13,  3.110345321064657e-15, -2.431273855145398e-17, -8.656309380083856e-20,  1.046309834720306e-20, -3.085921931171121e-22,  5.881001365480658e-24,
  1.270315128322188e-03, -2.027239674622968e-05,  2.696026663657613e-07, -3.346086316072446e-09,  4.001935597420968e-11, -4.664701009073782e-13,  5.284375525204392e-15,
 -5.656209160370379e-17,  5.187367632334940e-19, -2.603180749817145e-21, -3.789700157837124e-23,  1.343750202188216e-24,  5.654444704946871e-04, -9.023751758885373e-06,
  1.200187624528364e-07, -1.490828070491599e-09,  1.792762750687277e-11, -2.148306716064803e-13,  2.718673208739843e-15, -4.057502496751956e-17,  7.695441191083231e-19,
 -1.680766239275716e-20,  3.527354429304874e-22, -6.031553481372562e-24,  9.331050504929916e-05, -1.489132843099119e-06,  1.980910386908321e-08, -2.463969665069462e-10,
  2.989108022846897e-12, -3.739249397862351e-14,  5.479847124419223e-16, -1.089429571561133e-17,  2.749359762224327e-19, -7.113579762256223e-21,  1.621947018261895e-22,
 -2.910524407441469e-24,  5.467285227682346e-06, -8.725367912483212e-08,  1.160983713593380e-09, -1.447262163130941e-11,  1.780449409326078e-13, -2.376093679664194e-15,
  4.166157179947654e-17, -1.045915561415043e-18,  3.064117319919782e-20, -8.497761167503802e-22,  2.011698014852166e-23, -3.741400893693501e-25,  8.857945359707770e-08,
 -1.413710438643753e-09,  1.881882151233567e-11, -2.354759068577575e-13,  2.966531014378515e-15, -4.377463116568325e-17,  9.508956806253640e-19, -2.890394387130826e-20,
  9.312594894365222e-22, -2.706309384058245e-23,  6.642650114535404e-25, -1.297929524584564e-26,  1.914452070493043e-10, -3.055650726825518e-12,  4.071278303644907e-14,
 -5.134821359398550e-16,  6.793536966244960e-18, -1.197731509020217e-19,  3.404910925320011e-21, -1.228128336711582e-22,  4.293293057401315e-24, -1.318341284344449e-25,
  3.439373119858536e-27, -7.389474386433301e-29,  7.674264617356967e-04, -1.174706912788866e-05,  1.498456183834436e-07, -1.783712917436334e-09,  2.045126001807063e-11,
 -2.278798330525241e-13,  2.433123050033433e-15, -2.298491721172614e-17,  1.222382674453017e-19,  2.409024546832730e-21, -1.158682666024888e-22,  2.944087521460605e-24,
  1.193299367359287e-03, -1.826596909937289e-05,  2.330045470397146e-07, -2.774026925779052e-09,  3.183921833853647e-11, -3.568686454708307e-13,  3.917457664013485e-15,
 -4.165294847078041e-17,  4.098331833404825e-19, -3.173796653864458e-21,  3.518886833270031e-24,  5.567508233736729e-25,  5.311629413046951e-04, -8.130590338609607e-06,
  1.037186244810592e-07, -1.235156298275675e-09,  1.420379626293892e-11, -1.609066485447416e-13,  1.853036605638932e-15, -2.337315768228632e-17,  3.626429128965271e-19,
 -7.111144305927801e-21,  1.536743418053027e-22, -3.109221782954365e-24,  8.765327134809490e-05, -1.341726674795582e-06,  1.711668414379487e-08, -2.039279292575652e-10,
  2.352344610368420e-12, -2.710473457861843e-14,  3.352272207714189e-16, -5.164906020699882e-18,  1.088956616668016e-19, -2.735517883882676e-21,  6.744587303755764e-23,
 -1.454689473696231e-24,  5.135810331598078e-06, -7.861536818126623e-08,  1.002989226135119e-09, -1.195802795109496e-11,  1.386202331210729e-13, -1.640288023706305e-15,
  2.244323627713517e-17, -4.280523703673958e-19,  1.112814748201008e-20, -3.131970782094974e-22,  8.133940360364720e-24, -1.808442472788610e-25,  8.320887697530594e-08,
 -1.273715450252887e-09,  1.625239501625077e-11, -1.939998956665955e-13,  2.267868759682057e-15, -2.803934000136563e-17,  4.431121380196178e-19, -1.054002921020754e-20,
  3.188454939121048e-22, -9.622132460337401e-24,  2.592795960899602e-25, -5.949294269469155e-27,  1.798373831319264e-10, -2.752905811771074e-12,  3.513588086863182e-14,
 -4.204470891300982e-16,  5.001338665943294e-18, -6.737168796825055e-20,  1.333193360815919e-21, -4.023398453447004e-23,  1.380137839068226e-24, -4.432747227842099e-26,
  1.252279617942177e-27, -3.036401025423905e-29,  7.227075742325533e-04, -1.062868647339374e-05,  1.302636841086645e-07, -1.489990845178017e-09,  1.642800904744426e-11,
 -1.767121313657833e-13,  1.852235440927819e-15, -1.836708154661667e-17,  1.507487305552657e-19, -2.751154718996011e-22, -3.171547602446572e-23,  1.101639245202129e-24,
  1.123764288293293e-03, -1.652693686478869e-05,  2.025527807166534e-07, -2.316961259237648e-09,  2.555478412175321e-11, -2.754667089929551e-13,  2.918022811539293e-15,
 -3.030177150818615e-17,  3.024573815468106e-19, -2.708207791741497e-21,  1.640451020935628e-23,  9.394170966172105e-26,  5.002113563958156e-04, -7.356495309948098e-06,
  9.016138513053515e-08, -1.031425842905739e-09,  1.138329035080187e-11, -1.231758468436891e-13,  1.329671065510798e-15, -1.490645613244730e-17,  1.901948199003743e-19,
 -3.073575615859636e-21,  6.135843161007813e-23, -1.296984239526280e-24,  8.254558536501367e-05, -1.213980482559624e-06,  1.487878143814028e-08, -1.702331270290765e-10,
  1.880698218295097e-12, -2.047604129390881e-14,  2.276726037407609e-16, -2.841338639308384e-18,  4.639840385759897e-20, -1.014729787976933e-21,  2.491247580678245e-23,
 -5.835462536358892e-25,  4.836538037271704e-06, -7.113005580402414e-08,  8.718029995729736e-10, -9.976749556142983e-12,  1.104008493146705e-13, -1.213749111079010e-15,
  1.411782667181452e-17, -2.026907520255009e-19,  4.154337949557611e-21, -1.084277992515487e-22,  2.902252125169826e-24, -7.075815902296612e-26,  7.836012838053992e-08,
 -1.152430716822184e-09,  1.412524547802254e-11, -1.617055562951511e-13,  1.794348837594027e-15, -2.005276946678668e-17,  2.504775930849013e-19, -4.306861850423767e-21,
  1.083711797151683e-22, -3.178149445466093e-24,  8.965937509997092e-26, -2.252913213451920e-27,  1.693577777781720e-10, -2.490732564578744e-12,  3.053094475062948e-14,
 -3.497758426763790e-16,  3.903231116630932e-18, -4.508807791204770e-20,  6.410910581002007e-22, -1.409619329139588e-23,  4.310216068888876e-25, -1.387657559701627e-26,
  4.114412155492050e-28, -1.077650545767228e-29,  6.821697809601085e-04, -9.653881881828953e-06,  1.138516221165686e-07, -1.253166560823747e-09,  1.329939939910849e-11,
 -1.379006196234455e-13,  1.402715399605171e-15, -1.386995723744025e-17,  1.269754476059291e-19, -8.604387896474729e-22, -3.161839383209088e-24,  3.217930869716508e-25,
  1.060730586757192e-03, -1.501117320226292e-05,  1.770322793134186e-07, -1.948624189364601e-09,  2.068233794774941e-11, -2.146073066474958e-13,  2.191346615171333e-15,
 -2.205239362654655e-17,  2.171724761847925e-19, -2.031538177061619e-21,  1.629657720509896e-23, -6.445979866681329e-26,  4.721537066793726e-04, -6.681793035081637e-06,
  7.880103084116855e-08, -8.673981404682144e-10,  9.208260942844241e-12, -9.567228153503336e-14,  9.836867156583890e-16, -1.021000126787789e-17,  1.127210204013727e-19,
 -1.470044181805377e-21,  2.461238783414241e-23, -4.927003375364931e-25,  7.791546965328445e-05, -1.102639189330132e-06,  1.300391097824193e-08, -1.431456416187553e-10,
  1.520120043429371e-12, -1.582676729293463e-14,  1.645338635680615e-16, -1.790241450934940e-18,  2.291143270703361e-20, -3.951824385030880e-22,  8.768619794825156e-24,
 -2.079622441697031e-25,  4.565248530783192e-06, -6.460622066920233e-08,  7.619343369854912e-10, -8.387824911933152e-12,  8.911926601419303e-14, -9.309391611305724e-16,
  9.846700483512755e-18, -1.148088867970865e-19,  1.750514653837224e-21, -3.770746580490732e-23,  9.665542644056872e-25, -2.449709506467432e-26,  7.396477111705194e-08,
 -1.046731093958829e-09,  1.234476189384458e-11, -1.359128908022456e-13,  1.445293366797082e-15, -1.518164326099565e-17,  1.652238666725525e-19, -2.136088633824973e-21,
  3.983846251878187e-23, -1.025126678495200e-24,  2.873046037846480e-26, -7.585234412475995e-28,  1.598581743003952e-10, -2.262276240640250e-12,  2.668098453945979e-14,
 -2.938133656192902e-16,  3.129806862325173e-18, -3.324728519197640e-20,  3.825480767540654e-22, -5.872240765442369e-24,  1.393379273056647e-25, -4.180752590779768e-27,
  1.257993360272206e-28, -3.460914760141965e-30,  6.452854835534579e-04, -8.799801811603427e-06,  1.000049346814532e-07, -1.060735280704258e-09,  1.084883176217877e-11,
 -1.084655464563199e-13,  1.066538405052098e-15, -1.030561507248712e-17,  9.617097746351034e-20, -8.045770324239891e-22,  4.067276688703819e-24,  5.767290341557762e-26,
  1.003377849103622e-03, -1.368313195871873e-05,  1.555013674919514e-07, -1.649383068175301e-09,  1.686988781632123e-11, -1.687025302968731e-13,  1.661038514052988e-15,
 -1.615365786473848e-17,  1.549609354984914e-19, -1.449027897880625e-21,  1.266165852180714e-23, -8.885530412724485e-26,  4.466247829614088e-04, -6.090652794966826e-06,
  6.921700841723564e-08, -7.341812359115766e-10,  7.509664632021797e-12, -7.512977902020167e-14,  7.414953434769070e-16, -7.294793150587961e-18,  7.337224794147986e-20,
 -8.058799358843394e-22,  1.079993893655866e-23, -1.854794314410445e-25,  7.370265007143877e-05, -1.005088161486527e-06,  1.142230082263952e-08, -1.211571517765152e-10,
  1.239392516128616e-12, -1.240773306126281e-14,  1.229282455395292e-16, -1.231596833117765e-18,  1.328185057375708e-20, -1.761151346345032e-22,  3.172598026250184e-24,
 -7.010296977118403e-26,  4.318409577961919e-06, -5.889045774761876e-08,  6.692603174714740e-10, -7.099019729279389e-12,  7.263152128715971e-14, -7.278963385648971e-16,
  7.255208188681573e-18, -7.475755744163297e-20,  8.883971444295826e-22, -1.439178676245406e-23,  3.181140842047036e-25, -7.894577373730283e-27,  6.996555977161881e-08,
 -9.541254658359651e-10,  1.084318324634465e-11, -1.150199217847392e-13,  1.177093765529402e-15, -1.181748410148105e-17,  1.189798974486448e-19, -1.282529923667510e-21,
  1.744826406321464e-23, -3.472125092628306e-25,  8.899083964323173e-27, -2.366323729007215e-28,  1.512147742747206e-10, -2.062127639349151e-12,  2.343522406278806e-14,
 -2.486055085511757e-16,  2.545474320216263e-18, -2.564593825584357e-20,  2.634207358572328e-22, -3.088609039446774e-24,  5.149581073220799e-26, -1.274715686828885e-27,
  3.682655925805466e-29, -1.035393472595045e-30,  6.116096987841452e-04, -8.047883040132827e-06,  8.825026322684229e-08, -9.032098778207980e-10,  8.913804964306981e-12,
 -8.600911158511322e-14,  8.169544845610022e-16, -7.657107849876297e-18,  7.046930353802495e-20, -6.198132210590080e-22,  4.666466612687643e-24, -1.351447878503679e-26,
  9.510141468345140e-04, -1.251394587668360e-05,  1.372235552593502e-07, -1.404435559881133e-09,  1.386055345437027e-11, -1.337497884536885e-13,  1.270969863165154e-15,
 -1.193927502077046e-17,  1.109981321635415e-19, -1.017387601300906e-21,  9.036484557551696e-24, -7.340271363769429e-26,  4.233165868080509e-04, -5.570223039993933e-06,
  6.108112885618763e-08, -6.251454464726796e-10,  6.169750499362731e-12, -5.954379820945063e-14,  5.662656266411259e-16, -5.341027740312265e-18,  5.055808921969421e-20,
 -4.962992688438940e-22,  5.467952461747957e-24, -7.531824815876967e-26,  6.985629860156283e-05, -9.192060566705433e-07,  1.007969672334387e-08, -1.031627385796171e-10,
  1.018173495103632e-12, -9.828354965301985e-15,  9.358600419346055e-17, -8.884332306638729e-19,  8.648921633329300e-21, -9.348252396485619e-23,  1.289226557227779e-24,
 -2.389107753858850e-26,  4.093042891728009e-06, -5.385842063496680e-08,  5.905931238545524e-10, -6.044577292686872e-12,  5.966013830248555e-14, -5.760826356464709e-16,
  5.496352646730361e-18, -5.270898077838492e-20,  5.352423991187500e-22, -6.561931533498776e-24,  1.119810181235194e-25, -2.486756087385818e-27,  6.631423684873161e-08,
 -8.725977976418257e-10,  9.568617308628577e-12, -9.793327103739722e-14,  9.666750958876492e-16, -9.339322641891449e-18,  8.939925968483446e-20, -8.717369134261985e-22,
  9.451692322735751e-24, -1.362624806528049e-25,  2.830226102712802e-27, -7.092637721670786e-29,  1.433232619988827e-10, -1.885923426364851e-12,  2.068043657614693e-14,
 -2.116642806699318e-16,  2.089584943107272e-18, -2.020949318756267e-20,  1.947149278077262e-22, -1.961280485704059e-24,  2.386530856182781e-26, -4.285863200594432e-28,
  1.074710870123189e-29, -2.958149948118215e-31,  5.807647857217759e-04, -7.382934610279932e-06,  7.821396607978623e-08, -7.733537104872986e-10,  7.373559504382759e-12,
 -6.873954083810241e-14,  6.310194806266977e-16, -5.724614563662768e-18,  5.131873755632412e-20, -4.504691927018349e-22,  3.724071412330099e-24, -2.466931842007742e-26,
  9.030522704363011e-04, -1.147999333936932e-05,  1.216177413087806e-07, -1.202516176980142e-09,  1.146545149889560e-11, -1.068882367179226e-13,  9.813538242259499e-16,
 -8.909535118242549e-18,  8.015643271489780e-20, -7.143449052169953e-22,  6.266209700067211e-24, -5.284906100880517e-26,  4.019677372647412e-04, -5.109988767382424e-06,
  5.413464109893515e-08, -5.352657910532906e-10,  5.103544640753699e-12, -4.758033267419460e-14,  4.369490328103047e-16, -3.972364986950439e-18,  3.596891762431204e-20,
 -3.291950284842443e-22,  3.174127016378570e-24, -3.527817881126341e-26,  6.633328138704065e-05, -8.432575372182075e-07,  8.933375272949515e-09, -8.833039520919430e-11,
  8.422016581677996e-13, -7.852327614063151e-15,  7.213954644000475e-17, -6.572519405323880e-19,  6.012277123507002e-21, -5.730331163251713e-23,  6.262786502584983e-25,
 -8.962365371815241e-27,  3.886621122096515e-06, -4.940841923576801e-08,  5.234272788726104e-10, -5.175490555019622e-12,  4.934724044099050e-14, -4.601368266539324e-16,
  4.229908523832345e-18, -3.866902996912345e-20,  3.593641698207763e-22, -3.634429495105251e-24,  4.626834781365263e-26, -8.201863881105768e-28,  6.296985400032977e-08,
 -8.005001978219281e-10,  8.480411226322725e-12, -8.385191995222084e-14,  7.995271932210648e-16, -7.456345486922675e-18,  6.861419013570983e-20, -6.307846051874773e-22,
  6.014343385274665e-24, -6.643762522735801e-26,  1.012918602496107e-27, -2.147841272499420e-29,  1.360951326659284e-10, -1.730100607877497e-12,  1.832850194579313e-14,
 -1.812278087824951e-16,  1.728073052349952e-18, -1.612084534137372e-20,  1.486423670103483e-22, -1.381567247499504e-24,  1.382804534010475e-26, -1.766516515552013e-28,
  3.358953518825568e-30, -8.342937853908883e-32,  5.524283959684761e-04, -6.792437647310562e-06,  6.959873932472437e-08, -6.656035775095620e-10,  6.138128970645359e-12,
 -5.534698387037888e-14,  4.914759414019315e-16, -4.315227467957672e-18,  3.752695496381790e-20, -3.225239486984976e-22,  2.701839615629633e-24, -2.091006262283108e-26,
  8.589909882232535e-04, -1.056180813960558e-05,  1.082216096980679e-07, -1.034971277786696e-09,  9.544407939457961e-12, -8.606164216937718e-14,  7.642510198172040e-16,
 -6.711844889574770e-18,  5.843958251053101e-20, -5.049700841090676e-22,  4.322870394557737e-24, -3.633053429242137e-26,  3.823551251077975e-04, -4.701285031401227e-06,
  4.817173655908198e-08, -4.606877575960797e-10,  4.248425119376326e-12, -3.830834944049900e-14,  3.402142214099533e-16, -2.989144222557085e-18,  2.608315222643647e-20,
 -2.275660190369307e-22,  2.022427808215236e-24, -1.925821266461644e-26,  6.309678053566503e-05, -7.758126690811503e-07,  7.949367865866781e-09, -7.602335988202138e-11,
  7.010827930796573e-13, -6.321824854415506e-15,  5.615046802736198e-17, -4.936829705835117e-19,  4.322851767084172e-21, -3.829147164868605e-23,  3.597771952151997e-25,
 -3.998634517231883e-27,  3.696987014579612e-06, -4.545666741195059e-08,  4.657719513940499e-10, -4.454386984988419e-12,  4.107822495891904e-14, -3.704219869682972e-16,
  3.290702314781634e-18, -2.896362015051693e-20,  2.549941118838551e-22, -2.311749788302706e-24,  2.349456760846535e-26, -3.107661893450896e-28,  5.989745981635705e-08,
 -7.364751094333171e-10,  7.546295912858634e-12, -7.216866690836053e-14,  6.655409787563881e-16, -6.001769936235444e-18,  5.333394484798792e-20, -4.702619704150878e-22,
  4.177148311029866e-24, -3.929402004828219e-26,  4.462773620979163e-28, -7.130013810069806e-30,  1.294548457367260e-10, -1.591724797530972e-12,  1.630961744093896e-14,
 -1.559764658407564e-16,  1.438433290789791e-18, -1.297273092652384e-20,  1.153482400890054e-22, -1.020572636294517e-24,  9.222311644921220e-27, -9.282046502782027e-29,
  1.249782861481894e-30, -2.464767061825403e-32,  5.263238904703257e-04, -6.266007291479916e-06,  6.216619710441710e-08, -5.756469167973003e-10,  5.140014938590216e-12,
 -4.487580563592978e-14,  3.858549320850033e-16, -3.280978820718390e-18,  2.765510063838451e-20, -2.311592017147963e-22,  1.907871006140670e-24, -1.525243691751092e-26,
  8.184001439748413e-04, -9.743242445857557e-06,  9.666447915594891e-08, -8.950943290782767e-10,  7.992397824536060e-12, -6.977915732399367e-14,  5.999883627812047e-16,
 -5.102164178165833e-18,  4.302263416661476e-20, -3.602741218260848e-22,  2.996628519278222e-24, -2.468121075934028e-26,  3.642872785892067e-04, -4.336924060765062e-06,
  4.302741196375404e-08, -3.984255038065882e-10,  3.557587393986092e-12, -3.106029342494294e-14,  2.670743722070126e-16, -2.271443266403054e-18,  1.916692021727420e-20,
 -1.610380960461927e-22,  1.358029723614392e-24, -1.176419524344302e-26,  6.011519908878266e-05, -7.156853086209555e-07,  7.100444072152957e-09, -6.574874099286555e-11,
  5.870784523088307e-13, -5.125641802276473e-15,  4.407477151810527e-17, -3.749315792670956e-19,  3.167321639424564e-21, -2.675178985969468e-23,  2.304829557488529e-25,
 -2.147275185751949e-27,  3.522289227981613e-06, -4.193366556628061e-08,  4.160315230881023e-10, -3.852371898381089e-12,  3.439832500494567e-14, -3.003258484005238e-16,
  2.582605361141887e-18, -2.197675712442272e-20,  1.859804106703753e-22, -1.583702186604877e-24,  1.409234624560711e-26, -1.448706904230967e-28,  5.706705937806216e-08,
 -6.793965030184751e-10,  6.740416345770275e-12, -6.241496775598504e-14,  5.573120942252056e-16, -4.865855781574394e-18,  4.184685266852813e-20, -3.562893627184277e-22,
  3.023823347775695e-24, -2.609317739226239e-26,  2.441324056512529e-28, -2.863279971757333e-30,  1.233375737502166e-10, -1.468362261757083e-12,  1.456788949232116e-14,
 -1.348959084335191e-16,  1.204507945929115e-18, -1.051672493394916e-20,  9.046002970640206e-23, -7.709849431044660e-25,  6.579678316421132e-27, -5.822723340911084e-29,
  5.950745070744271e-31, -8.416646944687777e-33  };
  int offset = -7;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 7;
    if (std::isnan(t)) {
      fill_n(rr+offset, 7, 0.5);
      fill_n(ww+offset, 7, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 7; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=7; ++j) {
        const int boxof = it*84+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
